/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.DurationAmplitude;
import net.alomax.timedom.TimeDomainException;

public class DurationAmplitudeToolManager
extends JToolManager {
    protected String[] resultNames = new String[]{"MOMENT", "MAGNITUDE"};
    protected SeisGram2KFrame seisFrame = null;
    protected DurationAmplitude durationAmplitude;
    protected AJLJButton buttonApplyEnergyDuration;
    protected JTextField textFieldMwpdConst;
    protected JTextField textFieldPower;
    protected JComboBox choiceResults;
    protected double mwpdConst = 1.886E19;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public DurationAmplitudeToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        String string = null;
        string = "duramp.mwpdConst";
        String string2 = seisGram2KFrame.getParameter(string);
        if (string2 != null) {
            try {
                double d;
                this.mwpdConst = d = Double.valueOf(string2).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string + "> value: " + string2);
            }
        }
        this.durationAmplitude = new DurationAmplitude(SeisGramText.getLocaleString(), this.mwpdConst);
        string = "duramp.result";
        String string3 = seisGram2KFrame.getParameter(string);
        if (string3 == null) {
            string3 = "MOMENT";
        }
        try {
            this.durationAmplitude.setResultsType(string3);
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string + "> value: " + string3);
        }
        this.commandNames = new String[]{"durationamplitude"};
        this.commandNamesShort = new String[]{"da"};
    }

    public void updateLabel() {
        this.label = SeisGramText.DURATION_AMPLITUDE;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyEnergyDuration = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyEnergyDuration);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.COEFF + ":", 4));
        this.textFieldMwpdConst = SwingExt.newJTextField(this, this, String.valueOf(this.durationAmplitude.mwpdConst), 5);
        jToolBar.add(this.textFieldMwpdConst);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RESULT + ":", 4));
        this.choiceResults = SwingExt.newChoice(this, this.resultNames);
        this.choiceResults.setSelectedItem(this.durationAmplitude.getResultsTypeString());
        jToolBar.add(this.choiceResults);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyEnergyDuration)) {
            boolean bl = false;
            try {
                this.durationAmplitude.setMwpdConst(this.textFieldMwpdConst.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldMwpdConst.setText(String.valueOf(this.durationAmplitude.mwpdConst));
            if (bl) {
                return;
            }
            try {
                this.durationAmplitude.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            try {
                this.durationAmplitude.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMwpdConst)) {
            try {
                this.durationAmplitude.setMwpdConst(this.textFieldMwpdConst.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
        } else {
            if (actionEvent.getSource().equals(this.choiceResults)) {
                try {
                    this.durationAmplitude.setResultsType((String)this.choiceResults.getSelectedItem());
                }
                catch (TimeDomainException timeDomainException) {
                    this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                }
                return;
            }
            return;
        }
        this.textFieldMwpdConst.setText(String.valueOf(this.durationAmplitude.mwpdConst));
    }

    protected void apply() throws TimeDomainException {
        this.durationAmplitude.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.durationAmplitude, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("const")) {
                        this.durationAmplitude.setMwpdConst(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("res")) {
                        this.durationAmplitude.setResultsType(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " const " + this.durationAmplitude.mwpdConst;
        string = string + " result " + this.durationAmplitude.getResultsTypeString();
        return string;
    }
}

