/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.monitor.waveserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import net.alomax.earthworm.WSPacket;
import net.alomax.earthworm.WSSiteChanNet;
import net.alomax.earthworm.WaveserverConnection;
import net.alomax.earthworm.WaveserverException;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.monitor.MonitorClient;
import net.alomax.seisgram2k.monitor.waveserver.WaveserverManager;
import nl.knmi.orfeus.seedlink.SLLog;

public class WaveserverClient
implements MonitorClient,
Runnable {
    protected static final boolean VERBOSE = true;
    public static final int DATA_REQUEST_TYPE_GETSCNRAW = 0;
    public static final int DATA_REQUEST_TYPE_GETSCN = 1;
    public int dataRequestType = 0;
    protected WaveserverManager manager = null;
    public WaveserverConnection wsconn = new WaveserverConnection(null);
    public int verbose = 0;
    public String selectors = null;
    public WSSiteChanNet[] wsSiteChanNetList = null;
    public double windowLength = -1.0;
    public double initSegmentLength = -1.0;
    public SLLog sllog = null;
    protected double[] nextReadLength = null;
    protected boolean stopRunning = false;

    public WaveserverClient(WaveserverManager waveserverManager, String[] stringArray, double d, double d2, int n) throws Exception {
        this.manager = waveserverManager;
        this.wsconn.setWSAddress(stringArray[0]);
        this.selectors = stringArray[1];
        this.windowLength = d;
        this.initSegmentLength = d2;
        this.dataRequestType = n;
        ++this.verbose;
        this.wsconn.setKeepAlive(60);
    }

    public void init() throws UnknownHostException, IOException, WaveserverException {
        if (this.wsconn.getWSAddress() == null) {
            String string = "no Waverserver specified";
            throw new WaveserverException(string);
        }
        if (this.sllog == null) {
            this.sllog = new SLLog(this.verbose, null, null, null, null);
        }
        this.wsconn.setLog(this.sllog);
        if (this.wsconn.getWSAddress().startsWith(":")) {
            this.wsconn.setWSAddress(InetAddress.getLocalHost().toString() + this.wsconn.getWSAddress());
        }
        this.wsconn.connect();
        if (this.selectors != null) {
            this.wsSiteChanNetList = this.wsconn.parseStreamlist(this.selectors);
        }
        for (int i = 0; i < this.wsSiteChanNetList.length; ++i) {
            System.out.println(this.wsSiteChanNetList[i].toStringPretty());
        }
    }

    public void run() {
        int n;
        long l = (long)(1000.0 * this.initSegmentLength / 2.0);
        long l2 = (long)(1000.0 * this.initSegmentLength * 10.0);
        long l3 = 1000L;
        this.nextReadLength = new double[this.wsSiteChanNetList.length];
        long[] lArray = new long[this.wsSiteChanNetList.length];
        for (n = 0; n < this.nextReadLength.length; ++n) {
            this.nextReadLength[n] = 2.0 * (double)l / 1000.0;
            lArray[n] = -1L;
        }
        try {
            for (n = 0; n < this.wsSiteChanNetList.length; ++n) {
                WSSiteChanNet wSSiteChanNet = this.wsSiteChanNetList[n];
                wSSiteChanNet.starttime = wSSiteChanNet.endtime - this.windowLength;
                this.requestDataFromWaveserver(n);
            }
            do {
                long l4 = System.currentTimeMillis() + l;
                for (int i = 0; i < this.wsSiteChanNetList.length; ++i) {
                    if (this.checkForStop()) {
                        return;
                    }
                    this.nextReadLength[i] = 2.0 * (double)l / 1000.0;
                    if (System.currentTimeMillis() - lArray[i] >= 0L) {
                        boolean bl;
                        long l5;
                        block16: {
                            l5 = System.currentTimeMillis();
                            bl = false;
                            try {
                                bl = this.requestDataFromWaveserver(i);
                            }
                            catch (Exception exception) {
                                System.out.println("WaveserverClient: (" + new Date().toString() + ") caught and ignoring an exception:");
                                System.out.println(exception);
                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block16;
                                exception.printStackTrace();
                            }
                        }
                        lArray[i] = bl ? l5 + l : -1L;
                    }
                    if (lArray[i] <= 0L) continue;
                    l4 = l4 < lArray[i] ? l4 : lArray[i];
                }
                if (this.checkForStop()) {
                    return;
                }
                System.out.println("WaveserverClient:  normalSleep: " + l);
                long l6 = l4 - System.currentTimeMillis();
                if (l6 > 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(l6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (l <= l3) continue;
                    l = (long)((double)l / 1.05);
                    continue;
                }
                if (l < l2) {
                    l = (long)((double)l * 1.05);
                    continue;
                }
                this.writeMessage("WARNING: Too much time before segment updates.");
            } while (!this.checkForStop());
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: WaveserverClient: " + exception.getMessage());
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            this.manager.close(exception.getMessage());
            return;
        }
    }

    public boolean requestDataFromWaveserver(int n) throws Exception {
        WSSiteChanNet wSSiteChanNet = this.wsSiteChanNetList[n];
        WSSiteChanNet wSSiteChanNet2 = new WSSiteChanNet(wSSiteChanNet, wSSiteChanNet.starttime, wSSiteChanNet.endtime);
        WSPacket wSPacket = null;
        if (this.dataRequestType == 0) {
            wSPacket = this.wsconn.sendRequest_GETSCNRAW(wSSiteChanNet2, this.verbose);
            System.out.println("requestDataFromWaveserver GETSCNRAW: <" + wSPacket + ">");
            if (wSPacket.type != 5) {
                return false;
            }
        } else if (this.dataRequestType == 1) {
            wSPacket = this.wsconn.sendRequest_GETSCN(wSSiteChanNet2, this.verbose);
            System.out.println("requestDataFromWaveserver GETSCN (ASCII)");
            if (wSPacket.type != 4) {
                return false;
            }
            wSPacket.scnList[0].endtime = wSSiteChanNet.endtime;
        }
        if (wSPacket == null || wSPacket == WSPacket.WSNOPACKET || wSPacket == WSPacket.WSERROR) {
            return false;
        }
        if (!wSPacket.scnList[0].flag.equals("F")) {
            if (wSPacket.scnList[0].flag.equals("FL")) {
                this.writeMessage("WARNING: Requested time interval is older than anything in the tank: " + wSSiteChanNet.toSCNString());
                wSSiteChanNet.starttime = wSPacket.scnList[0].starttime;
                wSSiteChanNet.endtime = wSPacket.scnList[0].starttime + this.nextReadLength[n];
                return false;
            }
            if (wSPacket.scnList[0].flag.equals("FR")) {
                this.writeMessage("WARNING: Requested time interval is younger than anything in the tank: " + wSSiteChanNet.toSCNString());
                wSSiteChanNet.endtime = wSPacket.scnList[0].endtime;
                wSSiteChanNet.starttime = wSPacket.scnList[0].endtime - this.nextReadLength[n];
                return false;
            }
            if (wSPacket.scnList[0].flag.equals("FG")) {
                this.writeMessage("WARNING: Requested time interval falls completely within a data gap: " + wSSiteChanNet.toSCNString());
                wSSiteChanNet.endtime += this.nextReadLength[n];
                return false;
            }
            this.writeMessage("ERROR: Unrecognized response flag: " + wSPacket.scnList[0].flag + ": " + wSSiteChanNet.toSCNString());
            wSSiteChanNet.starttime = wSPacket.scnList[0].starttime + this.nextReadLength[n];
            wSSiteChanNet.endtime = wSPacket.scnList[0].endtime + this.nextReadLength[n];
            return false;
        }
        System.out.print(" start/end: " + wSSiteChanNet.starttime + "/" + wSSiteChanNet.endtime);
        wSSiteChanNet.starttime = wSPacket.scnList[0].endtime;
        wSSiteChanNet.endtime = wSPacket.scnList[0].endtime + this.nextReadLength[n];
        System.out.println(" -> " + wSSiteChanNet.starttime + "/" + wSSiteChanNet.endtime + "  nextReadLength[]:" + this.nextReadLength[n]);
        return this.manager.packetHandler(wSPacket);
    }

    protected boolean checkForStop() {
        return this.stopRunning;
    }

    public void close() {
        this.wsconn.close();
    }

    public boolean isConnected() {
        return this.wsconn.isConnected();
    }

    protected void writeMessage(String string) {
        this.manager.writeMessage(string + "  [" + new Date().toString() + "]");
    }
}

