/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.monitor.seedlink;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.exception.SeedException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.SimpleTimeZone;
import javax.swing.JPanel;
import net.alomax.seis.SampleRateSEEDException;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KException;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.monitor.MonitorManager;
import net.alomax.seisgram2k.monitor.MonitorStatusPanel;
import net.alomax.seisgram2k.monitor.seedlink.ProcessDataBlocketteActionEvent;
import net.alomax.seisgram2k.monitor.seedlink.SeedLinkClient;
import net.alomax.seisgram2k.monitor.seedlink.SeedLinkClock;
import net.alomax.seistools.SeedChannel;
import net.alomax.util.AJLGregorianCalendar;
import net.alomax.util.StringExt;
import net.alomax.util.SystemClock;
import net.alomax.util.TimeInstant;
import nl.knmi.orfeus.seedlink.SLPacket;

public class SeedLinkManager
extends MonitorManager
implements ActionListener {
    public static final int CLOCK_SYSTEM = 0;
    public static final int CLOCK_SEEDLINK = 1;
    public static String CLASS_NAME = "SeedLinkManager";
    private static int clockType = 1;
    protected SeedLinkClient seedLinkClient = null;
    public TimeInstant endTimeInstant = null;
    protected long lastInfoRequestTime = -1L;
    protected static final long INFO_REQUEST_INTERVAL = 3600000L;

    public SeedLinkManager(SeisGram2KFrame seisGram2KFrame, String string, boolean bl, double[] dArray, int n, boolean bl2, int n2, boolean bl3) throws Exception {
        super(seisGram2KFrame, bl, dArray, n, bl2);
        Object object;
        String string2;
        clockType = n2;
        className = CLASS_NAME + "[" + (numberManagers + 1) + "]";
        String string3 = null;
        String string4 = null;
        String[] stringArray = StringExt.parse(string, "#");
        if (stringArray == null) {
            String string5 = "ERROR: " + className + ": cannot parse seedlink parameters: " + string;
            throw new SeisGram2KException(string5);
        }
        if (stringArray.length < 2) {
            String string6 = "ERROR: " + className + ": not at least 2 seedlink parameters: " + string;
            throw new SeisGram2KException(string6);
        }
        if (stringArray.length > 2) {
            string2 = stringArray[2];
            if (string2.indexOf(44) >= 0) {
                object = StringExt.parse(string2, "-");
                string3 = object[0];
                double d = Double.parseDouble(object[1]);
                this.endTimeInstant = TimeInstant.create(string3, ",").add(d);
                string4 = this.endTimeInstant.toDelimitedStringIntSec(",");
                this.windowLength = -1;
                this.windowMode = true;
            } else {
                this.windowLength = Integer.parseInt(string2);
                if (bl3) {
                    string3 = this.getBackFillTime();
                }
            }
        }
        if (stringArray.length > 3) {
            this.minPeakToPeakAmplitude = Double.parseDouble(stringArray[3]);
        }
        if (stringArray.length > 4) {
            this.maxPeakToPeakAmplitude = Double.parseDouble(stringArray[4]);
        }
        if (stringArray.length > 5) {
            this.title = stringArray[5];
        }
        if (stringArray.length > 6) {
            this.multiplier = Double.parseDouble(stringArray[6]);
        }
        if (stringArray.length > 7) {
            this.onReadCommands = stringArray[7];
        }
        if (n2 == 0) {
            activeClock = new SystemClock();
            seisGram2KFrame.setClock(activeClock);
        } else {
            activeClock = new SeedLinkClock();
            seisGram2KFrame.setClock(activeClock);
        }
        string2 = stringArray[0];
        object = stringArray[1];
        String string7 = "[" + numberManagers + "] ";
        this.seedLinkClient = new SeedLinkClient(this, string2, (String)object, string3, string4, string7);
        this.seedLinkClient.init();
        this.runnableClient = this.seedLinkClient;
        this.monitorClient = this.seedLinkClient;
        className = CLASS_NAME + "[" + numberManagers + ":" + this.seedLinkClient.slconn.getSLAddress() + "]";
        ++numberManagers;
    }

    protected String getBackFillTime() {
        AJLGregorianCalendar aJLGregorianCalendar = new AJLGregorianCalendar(new SimpleTimeZone(0, "GMT"));
        aJLGregorianCalendar.setTimeInMillis(aJLGregorianCalendar.getTimeInMillis() - 1000L * (long)this.windowLength);
        String string = "";
        string = string + aJLGregorianCalendar.get(1);
        string = string + "," + (aJLGregorianCalendar.get(2) + 1);
        string = string + "," + aJLGregorianCalendar.get(5);
        string = string + "," + aJLGregorianCalendar.get(11);
        string = string + "," + aJLGregorianCalendar.get(12);
        string = string + "," + aJLGregorianCalendar.get(13);
        return string;
    }

    public boolean packetHandler(int n, SLPacket sLPacket) throws Exception {
        Object object;
        if (sLPacket == null || sLPacket == SLPacket.SLNOPACKET || sLPacket == SLPacket.SLERROR) {
            return false;
        }
        int n2 = sLPacket.getType();
        if (n2 == -102) {
            return false;
        }
        if (n2 == -101) {
            block9: {
                System.out.println("INFO: " + className + ": received INFO packet:\n" + this.seedLinkClient.slconn.getInfoString());
                if (clockType == 1) {
                    byte[] byArray = new byte[10];
                    System.arraycopy(sLPacket.msrecord, 20, byArray, 0, 10);
                    try {
                        Btime btime = new Btime(byArray);
                        if (btime.getYear() < 1000 || btime.getYear() > 3000) {
                            throw new Exception("bad time: year not in range 1000-3000");
                        }
                        ((SeedLinkClock)activeClock).setTime(btime);
                        System.out.println("INFO: " + className + ": SeedLinkClock: current GMT time set to " + ((SeedLinkClock)activeClock).getTimeUTCString());
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: " + className + ": setting SeedLinkClock using timestamp from INFO packet : " + exception);
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block9;
                        exception.printStackTrace();
                    }
                }
            }
            return this.seedLinkClient.infolevel != null;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastInfoRequestTime > 3600000L && !this.seedLinkClient.slconn.getState().expect_info) {
            System.out.println("INFO: " + className + ": " + new Date(l) + ": requesting INFO level ID");
            object = "ID";
            this.seedLinkClient.slconn.requestInfo((String)object);
            this.lastInfoRequestTime = l;
        }
        if (((Blockette)(object = sLPacket.getBlockette())).getType() == 999) {
            ProcessDataBlocketteActionEvent processDataBlocketteActionEvent = new ProcessDataBlocketteActionEvent(this, "processDataBlockette", (Blockette)object, sLPacket);
            this.seisFrame.getJFrame().getToolkit().getSystemEventQueue().postEvent(processDataBlocketteActionEvent);
        }
        return false;
    }

    public void processDataBlockette(Blockette blockette, SLPacket sLPacket) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        String string2 = null;
        SeedChannel seedChannel = null;
        try {
            String string3 = (String)blockette.getFieldVal(7);
            object4 = (String)blockette.getFieldVal(4);
            String string4 = (String)blockette.getFieldVal(5);
            object3 = (String)blockette.getFieldVal(6);
            object2 = ((Btime)blockette.getFieldVal(8)).toString();
            seedChannel = new SeedChannel(string3, (String)object4, (String)object3, null, string4, null);
            string = string3 + "_" + (String)object4 + "_" + string4 + (String)object3;
            object = seedChannel.toSeisComPFileName();
            string2 = this.seedLinkClient.slconn.getSLAddress() + "." + (String)object;
            string2 = SeismogramURL.cleanedURLname(string2.trim());
        }
        catch (SeedException seedException) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                seedException.printStackTrace();
            }
            System.out.println("INFO: " + className + ": processDataBlockette(): Exception ignored: " + seedException);
            return;
        }
        boolean bl = true;
        object4 = null;
        boolean bl2 = false;
        object4 = (GatherPanel)this.gatherTable.get(string);
        if (object4 == null) {
            if (!this.groupMode || (object4 = this.findRelatedGather(string)) == null) {
                object4 = this.seisFrame.createSeedLinkGather();
                ((GatherPanel)object4).setMonitorManager(this);
                int n = this.seedLinkClient.getChannelOrder(seedChannel);
                ((GatherPanel)object4).setDefaultSortOrder(n);
                bl2 = true;
            }
            this.gatherTable.put(string, object4);
            bl = false;
        }
        if (object4 == CLOSED_GATHER) {
            return;
        }
        object3 = null;
        try {
            object3 = this.readChannel(sLPacket, string2, (GatherPanel)object4, this.getChannelIndex(string));
            if (object3 == null) {
                return;
            }
        }
        catch (Exception exception) {
            object = "ERROR: " + className + ": " + exception;
            System.out.println((String)object);
            this.seisFrame.writeMessage((String)object);
            return;
        }
        this.doPreProcessing((Seismogram)object3);
        if (!bl) {
            ((GatherPanel)object4).addSeismogram((Seismogram)object3, this.getChannelIndex(string));
            this.doPreDisplay((GatherPanel)object4);
            if (bl2) {
                object2 = new MonitorStatusPanel(this.latencyLimits, this.nStatusDec);
                ((GatherPanel)object4).setAuxilliaryPanel((JPanel)object2);
                ((GatherPanel)object4).monitorSeismogramAppended(true);
            }
        } else {
            boolean bl3 = this.windowMode;
            ((Seismogram)object3).setComponent();
            ((GatherPanel)object4).appendSeismogram((Seismogram)object3, this.windowLength, true, bl3);
            this.doPreDisplay((GatherPanel)object4);
            ((GatherPanel)object4).monitorSeismogramAppended(false);
        }
        if (this.windowMode) {
            boolean bl4 = true;
            for (GatherPanel gatherPanel : this.gatherTable.values()) {
                if (gatherPanel.timeMax < gatherPanel.timeInstantToRefTime(this.endTimeInstant)) {
                    bl4 = false;
                    continue;
                }
                gatherPanel.removeMonitorManager();
            }
            if (bl4) {
                this.close(null);
            }
        }
    }

    protected Seismogram readChannel(SLPacket sLPacket, String string, GatherPanel gatherPanel, int n) throws Exception {
        Object object;
        SeismogramURL seismogramURL = new SeismogramURL();
        try {
            object = gatherPanel.seismograms[n].getSeismogramURL();
            seismogramURL = new SeismogramURL((SeismogramURL)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        seismogramURL.URLname = string;
        seismogramURL.formatName = "MINI_SEED";
        seismogramURL.binaryTypeName = "SUN_UNIX";
        object = null;
        try {
            object = this.seisFrame.getDataManager().readSeismogramInputStream(new ByteArrayInputStream(sLPacket.msrecord), seismogramURL, false, false, true);
        }
        catch (SampleRateSEEDException sampleRateSEEDException) {
            return null;
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return object;
    }

    protected void updateStatusPanel(GatherPanel gatherPanel) {
        if (gatherPanel.getNumberSeismograms() < 1) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            MonitorStatusPanel monitorStatusPanel = (MonitorStatusPanel)gatherPanel.getAuxilliaryPanel();
            if (monitorStatusPanel == null) {
                return;
            }
            if (clockType != 1 || ((SeedLinkClock)SeedLinkManager.activeClock).hasBtime) {
                string = monitorStatusPanel.setDataLatency(gatherPanel.getDataLatency());
                string2 = monitorStatusPanel.setFeedLatency(gatherPanel.getFeedLatency());
            } else {
                monitorStatusPanel.setDataLatency(Double.NaN);
                monitorStatusPanel.setFeedLatency(Double.NaN);
            }
        }
        catch (Exception exception) {
            return;
        }
        this.dumpStatus(gatherPanel, string, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent instanceof ProcessDataBlocketteActionEvent) {
            ProcessDataBlocketteActionEvent processDataBlocketteActionEvent = (ProcessDataBlocketteActionEvent)actionEvent;
            if (processDataBlocketteActionEvent.seedLinkManager == this) {
                this.processDataBlockette(processDataBlocketteActionEvent.blockette, processDataBlocketteActionEvent.slpack);
            }
        } else if (actionEvent.getSource() == this.seisFrame.getRealtimeTimer()) {
            super.actionPerformed(actionEvent);
        }
    }
}

