/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.commandmenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.calc.AmplitudeDurationMagnitudeCalculator;
import net.alomax.seisgram2k.calc.CalculatorException;
import net.alomax.swing.JCommandMenu;
import net.alomax.swing.JCommandMenuException;
import net.alomax.swing.SwingExt;

public class CalculationCommandMenu
extends JCommandMenu
implements ActionListener {
    protected SeisGram2KFrame seisFrame = null;
    protected JMenuItem menuItemEnergyDurationMagnitude;
    protected double magnitudePercentile = AmplitudeDurationMagnitudeCalculator.DEFAULT_MAG_PERCENTILE;
    protected static int cmd_count = 0;
    protected static final int CMD_MED = cmd_count++;
    protected static final int CMD_AMED = cmd_count++;
    protected static final int CMD_MDA = cmd_count++;
    protected static final int CMD_AMDA = cmd_count++;
    protected static final int CMD_MWP = cmd_count++;
    protected static final int CMD_AMWP = cmd_count++;
    protected static final int CMD_DUR = cmd_count++;
    protected String[] commandNames = new String[]{"mag_ed", "ave_mag_ed", "mag_da", "ave_mag_da", "mag_wp", "ave_mag_wp", "dur_ad"};
    protected String[] commandNamesShort = new String[]{"med", "amed", "mda", "amda", "mwp", "amwp", "dur"};
    protected int variant = 0;
    protected String argumentString = "";

    public CalculationCommandMenu(SeisGram2KFrame seisGram2KFrame) {
        super(SeisGramText.CALCULATE);
        this.seisFrame = seisGram2KFrame;
        this.menuItemEnergyDurationMagnitude = SwingExt.newJMenuItem(this, SeisGramText.ENERGY_DURATION_MAGNITUDE);
        this.add(this.menuItemEnergyDurationMagnitude);
        String string = null;
        string = "mag.percentile";
        String string2 = seisGram2KFrame.getParameter(string);
        if (string2 != null) {
            try {
                double d;
                this.magnitudePercentile = d = Double.valueOf(string2).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string + "> value: " + string2);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this.menuItemEnergyDurationMagnitude)) {
                this.applyCommand(this.commandNamesShort[CMD_MED]);
                return;
            }
        }
        catch (JCommandMenuException jCommandMenuException) {
            this.seisFrame.writeMessage(jCommandMenuException.getMessage());
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JCommandMenuException {
        if (!this.isCommandHandler(string)) {
            throw new JCommandMenuException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant == CMD_MED) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(0, 0, this.seisFrame);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_AMED) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(1, 0, this.seisFrame);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_MDA) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(0, 1, this.seisFrame, 1, this.magnitudePercentile);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_AMDA) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(1, 1, this.seisFrame, 1, this.magnitudePercentile);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_MWP) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(0, 1, this.seisFrame, 2, this.magnitudePercentile);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_AMWP) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(1, 1, this.seisFrame, 2, this.magnitudePercentile);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            } else if (this.variant == CMD_DUR) {
                AmplitudeDurationMagnitudeCalculator amplitudeDurationMagnitudeCalculator = new AmplitudeDurationMagnitudeCalculator(0, 2, this.seisFrame);
                this.seisFrame.applyCalculatorProcess(amplitudeDurationMagnitudeCalculator, this.getCommandString());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                noSuchElementException.printStackTrace();
            }
            throw new JCommandMenuException("Parsing or applying command", string, string2);
        }
        catch (CalculatorException calculatorException) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                calculatorException.printStackTrace();
            }
            throw new JCommandMenuException(calculatorException.getMessage(), string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                numberFormatException.printStackTrace();
            }
            throw new JCommandMenuException("Parsing or applying command", string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        if (this.variant == CMD_MED || this.variant == CMD_MED) {
            // empty if block
        }
        return string;
    }
}

