/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.PeppHeader;
import net.alomax.seis.SeisData;
import net.alomax.util.PhysicalUnits;

public class SeisDataPepp
extends SeisData {
    public PeppHeader header;
    float[] sample;
    private static final int DATABLOCKEND = 95959595;

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        String string;
        boolean bl = false;
        try {
            binaryInputStream.mark(8);
            string = binaryInputStream.readStringB(4);
            if (string.compareTo("PEPP") == 0) {
                bl = true;
            } else {
                binaryInputStream.reset();
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IOException reading PEPP file.");
        }
        try {
            if (bl) {
                string = binaryInputStream.readStringB(32);
            }
            this.header = new PeppHeader(binaryInputStream);
            this.sample = new float[this.header.npts];
            for (int i = 0; i < this.header.npts; ++i) {
                this.sample[i] = binaryInputStream.readFloatB();
            }
            int n = binaryInputStream.readIntB();
            if (n != 95959595) {
                System.out.println("ERROR: Reading PEPP file: dataBlockEnd = " + n + ", should be: " + 95959595);
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IOException reading PEPP file.");
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataPepp seisDataPepp = this;
        String string = "counts";
        if (seisDataPepp.header.idep == 1) {
            string = "?";
        } else if (seisDataPepp.header.idep == 2) {
            string = "counts";
        } else if (seisDataPepp.header.idep == 3) {
            string = "volts";
        } else if (seisDataPepp.header.idep == 4) {
            string = "nm";
        } else if (seisDataPepp.header.idep == 5) {
            string = PhysicalUnits.timeDerivative("nm");
        } else if (seisDataPepp.header.idep == 6) {
            string = PhysicalUnits.timeDerivative(PhysicalUnits.timeDerivative("nm"));
        }
        this.timeSeries = new TimeSeriesFloat(seisDataPepp.sample, 1.0 / (double)seisDataPepp.header.samplingrate, 0.0, string, "sec");
        this.timeMin = seisDataPepp.header.begin_time;
        short s = seisDataPepp.header.stime.year;
        short s2 = seisDataPepp.header.stime.jday;
        short s3 = seisDataPepp.header.stime.hour;
        short s4 = seisDataPepp.header.stime.min;
        double d = seisDataPepp.header.stime.sec;
        this.iyear = s;
        this.ijday = s2;
        this.ihour = s3;
        this.imin = s4;
        this.sec = d;
        if (!seisDataPepp.header.kstnm.startsWith("-12345")) {
            this.channel.staName = seisDataPepp.header.kstnm;
        }
        if (!seisDataPepp.header.kcmpname.startsWith("-12345")) {
            this.channel.instName = seisDataPepp.header.kcmpname;
        }
        if (!seisDataPepp.header.event_loc.startsWith("-12345")) {
            this.evtName = seisDataPepp.header.event_loc;
        }
        double d2 = seisDataPepp.header.cmpaz;
        double d3 = seisDataPepp.header.cmpinc;
        this.channel.azimuth = d2;
        this.channel.inclination = d3;
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        try {
            int n = binaryInputStream.readUnsignedShortB();
            if (n != 3737 && n != 39182) {
                String string = binaryInputStream.readStringB(2);
                if (string.compareTo("PP") != 0) {
                    return -1;
                }
                n = binaryInputStream.readUnsignedShortB();
                if (n != 3737 && n != 39182) {
                    return -1;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

