/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import java.util.Vector;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import orfeus.srem.BasicReading;
import sdsu.io.ASCIIInputStream;

public class SeisDataINERIS
extends SeisData {
    protected static boolean VERBOSE = false;
    protected int index = 0;
    protected String dateStr;
    protected String timeStr;
    protected double duration;
    protected double sampleRate;
    protected int numChannels;
    protected double locX;
    protected double locY;
    protected double locZ;
    protected String channelName;
    protected double sensitivity;
    protected double gain;
    protected double sensitivityAcquis;
    protected double staX;
    protected double staY;
    protected double staZ;
    protected double azimuth;
    protected double inclination;
    protected double timeP;
    protected double timeS;
    protected double timeEnd;
    protected float[] sample;
    protected String dataUnits = PhysicalUnits.timeDerivative("nm");

    public SeisDataINERIS(int n) {
        this.index = n;
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        try {
            this.dateStr = aSCIIInputStream.readWord();
            if (VERBOSE) {
                System.out.println("dateStr " + this.dateStr);
            }
            String string = aSCIIInputStream.readWord();
            this.timeStr = aSCIIInputStream.readWord();
            if (VERBOSE) {
                System.out.println("timeStr " + this.timeStr);
            }
            aSCIIInputStream.flushLine();
            this.duration = aSCIIInputStream.readDouble();
            if (VERBOSE) {
                System.out.println("duration " + this.duration);
            }
            aSCIIInputStream.flushLine();
            this.sampleRate = aSCIIInputStream.readDouble();
            if (VERBOSE) {
                System.out.println("sampleRate " + this.sampleRate);
            }
            aSCIIInputStream.flushLine();
            this.numChannels = aSCIIInputStream.readInt();
            if (VERBOSE) {
                System.out.println("numChannels " + this.numChannels);
            }
            aSCIIInputStream.flushLine();
            this.locX = aSCIIInputStream.readDouble();
            this.locY = aSCIIInputStream.readDouble();
            this.locZ = aSCIIInputStream.readDouble();
            if (VERBOSE) {
                System.out.println("locX locY locZ " + this.locX + " " + this.locY + " " + this.locZ);
            }
            aSCIIInputStream.flushLine();
            String[] stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.channelName = stringArray[this.index];
            if (VERBOSE) {
                System.out.println("channelName " + this.channelName);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.sensitivity = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("sensitivity " + this.sensitivity);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.gain = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("gain " + this.gain);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.sensitivityAcquis = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("sensitivityAcquis " + this.sensitivityAcquis);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.staX = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("staX " + this.staX);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.staY = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("staY " + this.staY);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.staZ = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("staZ " + this.staZ);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.azimuth = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("azimuth " + this.azimuth);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.inclination = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("inclination " + this.inclination);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.timeP = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("timeP " + this.timeP);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.timeS = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("timeS " + this.timeS);
            }
            stringArray = StringExt.parse(aSCIIInputStream.readLine());
            this.timeEnd = Double.parseDouble(stringArray[this.index]);
            if (VERBOSE) {
                System.out.println("timeEnd " + this.timeEnd);
            }
            int n = (int)(this.duration * this.sampleRate + 0.5);
            double d = this.sensitivityAcquis / (this.sensitivity * this.gain);
            this.sample = new float[n];
            int n2 = 0;
            while (n2 < n && !aSCIIInputStream.eof()) {
                int n3 = 0;
                while (n3++ < this.index) {
                    aSCIIInputStream.readWord();
                }
                this.sample[n2] = aSCIIInputStream.readFloat() * (float)(d * 1.0E9);
                ++n2;
                while (n3++ < this.numChannels) {
                    aSCIIInputStream.readWord();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataINERIS seisDataINERIS = this;
        this.timeSeries = new TimeSeriesFloat(seisDataINERIS.sample, 1.0 / this.sampleRate, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        String string = this.dateStr;
        if (VERBOSE) {
            System.out.println("dateStrParse " + string);
        }
        int n = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n3 = Integer.parseInt(string);
        if (VERBOSE) {
            System.out.println("iyear/imonth/iday " + n3 + "/" + n2 + "/" + n);
        }
        string = this.timeStr;
        if (VERBOSE) {
            System.out.println("dateStrParse " + string);
        }
        int n4 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        int n5 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        double d = Double.parseDouble(string);
        if (VERBOSE) {
            System.out.println("ihour:imin:sec " + n4 + ":" + n5 + ":" + d);
        }
        TimeInstant timeInstant = new TimeInstant(n3, n2, n);
        int n6 = timeInstant.getDoY();
        this.iyear = n3;
        this.ijday = n6;
        this.ihour = n4;
        this.imin = n5;
        this.sec = d;
        String string2 = seisDataINERIS.channelName + "    ";
        this.channel.staName = (string2.substring(0, 3) + "_" + seisDataINERIS.staZ + "_" + (int)seisDataINERIS.gain).trim();
        this.channel.instName = "INERIS";
        this.channel.compName = string2.substring(3, 4).trim();
        if (this.channel.compName.length() < 1) {
            this.channel.compName = BasicChannel.UNDEF_STRING;
        }
        this.evtName = this.dateStr.trim() + "-" + this.timeStr.trim();
        double d2 = seisDataINERIS.azimuth;
        double d3 = 90.0 + seisDataINERIS.inclination;
        this.channel.azimuth = d2;
        this.channel.inclination = d3;
        if (seisDataINERIS.locY > -1.0E30) {
            this.hypocenter.position.latitude = seisDataINERIS.locY;
        }
        if (seisDataINERIS.locX > -1.0E30) {
            this.hypocenter.position.longitude = seisDataINERIS.locX;
        }
        this.hypocenter.position.elevation = seisDataINERIS.locZ;
        if (seisDataINERIS.locZ > -1.0E30) {
            this.hypocenter.position.depth = 0.0;
        }
        if (seisDataINERIS.staY > -1.0E30) {
            this.channel.staPosition.latitude = seisDataINERIS.staY;
        }
        if (seisDataINERIS.staX > -1.0E30) {
            this.channel.staPosition.longitude = seisDataINERIS.staX;
        }
        this.channel.staPosition.elevation = seisDataINERIS.staZ;
        if (seisDataINERIS.staZ > -1.0E30) {
            this.channel.staPosition.depth = 0.0;
        }
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            String string = aSCIIInputStream.readWord();
            if (string.indexOf("/") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.indexOf("-") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.indexOf(":") < 0) {
                return -1;
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public Vector setReadings() {
        Vector<BasicReading> vector = new Vector<BasicReading>();
        BasicReading basicReading = this.getBasicReading(this.timeP, "P");
        if (basicReading != null) {
            vector.addElement(basicReading);
        }
        if ((basicReading = this.getBasicReading(this.timeS, "S")) != null) {
            vector.addElement(basicReading);
        }
        if ((basicReading = this.getBasicReading(this.timeEnd, "Tend")) != null) {
            vector.addElement(basicReading);
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public BasicReading getBasicReading(double d, String string) {
        if (d > 0.0) {
            BasicReading basicReading = new BasicReading();
            TimeInstant timeInstant = new TimeInstant(this.iyear, this.ijday, this.ihour, this.imin, this.sec);
            TimeInstant timeInstant2 = BasicHypocenter.UNDEF_OTIME;
            try {
                timeInstant2 = new TimeInstant(timeInstant.getMillisecondTime() + d * 1000.0);
            }
            catch (Exception exception) {
                timeInstant2 = BasicHypocenter.UNDEF_OTIME;
            }
            basicReading.iyear = timeInstant2.getYear();
            basicReading.imonth = timeInstant2.getMonth();
            basicReading.idate = timeInstant2.getDate();
            basicReading.ihour = timeInstant2.getHours();
            basicReading.imin = timeInstant2.getMinutes();
            basicReading.sec = timeInstant2.getSeconds();
            basicReading.name = string;
            basicReading.network = "INERIS";
            basicReading.staName = this.channel.staName;
            basicReading.instName = "?";
            basicReading.compName = this.channelName;
            basicReading.azimuth = this.channel.azimuth;
            basicReading.inclination = this.channel.inclination;
            basicReading.uncertainty = 0.0;
            return basicReading;
        }
        return null;
    }
}

