/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataCSMIP
extends SeisData {
    protected static boolean VERBOSE = false;
    protected int index = 0;
    String[] textHeader = null;
    int[] integerHeader = null;
    double[] realHeader = null;
    protected float[] sample;
    double undefinedRealValue = -1.0;
    double undefinedIntegerValue = -1.0;
    double sampleInterval = -1.0;
    String dataUnits = "counts";

    public SeisDataCSMIP(int n) {
        this.index = n;
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        try {
            int n;
            int n2;
            int n3;
            if (VERBOSE) {
                System.out.println("Reading file...");
            }
            String string = "";
            for (n3 = 0; n3 < this.index; ++n3) {
                do {
                    string = aSCIIInputStream.readWord();
                    aSCIIInputStream.flushLine();
                } while (!string.equals("/&"));
            }
            this.textHeader = new String[25];
            for (n3 = 0; n3 < 25; ++n3) {
                this.textHeader[n3] = aSCIIInputStream.readLine();
                if (!VERBOSE) continue;
                System.out.println("textHeader[" + n3 + "]: " + this.textHeader[n3]);
            }
            this.integerHeader = new int[100];
            if (VERBOSE) {
                System.out.print("integerHeader:  ");
            }
            String string2 = "";
            int n4 = 0;
            for (int i = 0; i < 100; ++i) {
                if (i % 16 == 0) {
                    string2 = aSCIIInputStream.readLine();
                    n4 = 0;
                }
                this.integerHeader[i] = Integer.parseInt(string2.substring(n4, n4 + 5).trim());
                n4 += 5;
                if (!VERBOSE) continue;
                System.out.print("[" + i + "] " + this.integerHeader[i] + ",  ");
            }
            if (VERBOSE) {
                System.out.println("");
            }
            this.realHeader = new double[100];
            if (VERBOSE) {
                System.out.print("realHeader:  ");
            }
            for (n2 = 0; n2 < 100; ++n2) {
                if (n2 % 8 == 0) {
                    string2 = aSCIIInputStream.readLine();
                    n4 = 0;
                }
                this.realHeader[n2] = Double.parseDouble(string2.substring(n4, n4 + 10).trim());
                n4 += 10;
                if (!VERBOSE) continue;
                System.out.print("[" + n2 + "] " + this.realHeader[n2] + ",  ");
            }
            if (VERBOSE) {
                System.out.println("");
            }
            n2 = 1;
            for (n = 0; n < n2; ++n) {
                aSCIIInputStream.flushLine();
            }
            n = this.integerHeader[52];
            this.sample = new float[n];
            int n5 = 0;
            for (n5 = 0; n5 < n; ++n5) {
                this.sample[n5] = aSCIIInputStream.readFloat();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.undefinedRealValue = this.realHeader[0];
        this.undefinedIntegerValue = this.integerHeader[0];
        this.sampleInterval = Double.parseDouble(this.textHeader[16].substring(31, 40).trim());
        this.dataUnits = PhysicalUnits.timeDerivative(PhysicalUnits.timeDerivative("cm"));
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataCSMIP seisDataCSMIP = this;
        this.timeSeries = new TimeSeriesFloat(seisDataCSMIP.sample, this.sampleInterval, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        int n = 0;
        int n2 = 0;
        try {
            this.iyear = Integer.parseInt(this.textHeader[4].substring(55, 57).trim());
            if (this.iyear < 50) {
                this.iyear += 2000;
            } else {
                this.iyear += 1900;
            }
            n = Integer.parseInt(this.textHeader[4].substring(49, 51).trim());
            n2 = Integer.parseInt(this.textHeader[4].substring(52, 54).trim());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
            n = 0;
            this.iyear = 0;
            System.out.println("WARNING: trigger date not available or not complete! Setting date to 0000 00 00.");
        }
        TimeInstant timeInstant = new TimeInstant(this.iyear, n, n2);
        this.ijday = timeInstant.getDoY();
        try {
            this.ihour = Integer.parseInt(this.textHeader[4].substring(59, 61).trim());
            this.imin = Integer.parseInt(this.textHeader[4].substring(62, 64).trim());
            this.sec = Double.parseDouble(this.textHeader[4].substring(65, 70).trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.imin = 0;
            this.ihour = 0;
            this.sec = 0.0;
            System.out.println("WARNING: trigger time not available or not complete!  Setting start time to 00:00:00");
        }
        this.channel.network = this.textHeader[3].substring(0, 5).trim();
        this.channel.staName = this.textHeader[5].substring(12, 17).trim();
        this.channel.instName = this.textHeader[5].substring(39, 47).trim();
        this.channel.chanName = this.textHeader[5].substring(53, 57).trim();
        this.channel.compName = this.textHeader[7].substring(5, 7).trim();
        this.evtName = this.textHeader[2].trim();
        try {
            String string = this.textHeader[7].substring(9, 12).trim();
            if (string.equalsIgnoreCase("UP")) {
                this.channel.azimuth = 0.0;
                this.channel.inclination = 0.0;
            } else if (string.equalsIgnoreCase("DOW")) {
                this.channel.azimuth = 0.0;
                this.channel.inclination = 0.0;
            } else {
                int n3 = Integer.parseInt(string);
                this.channel.azimuth = n3;
                if (this.channel.azimuth >= 360.0) {
                    this.channel.azimuth -= 360.0;
                }
                this.channel.inclination = 90.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.channel.inclination = Double.MAX_VALUE;
            this.channel.azimuth = Double.MAX_VALUE;
        }
        this.channel.staPosition.latitude = Double.parseDouble(this.textHeader[5].substring(20, 26).trim());
        if (this.textHeader[5].substring(26, 27).equalsIgnoreCase("S")) {
            this.channel.staPosition.latitude *= -1.0;
        }
        this.channel.staPosition.longitude = Double.parseDouble(this.textHeader[5].substring(29, 36).trim());
        if (this.textHeader[5].substring(36, 37).equalsIgnoreCase("W")) {
            this.channel.staPosition.longitude *= -1.0;
        }
        this.channel.staPosition.elevation = 0.0;
        this.channel.staPosition.depth = 0.0;
        try {
            this.hypocenter.position.latitude = Double.parseDouble(this.textHeader[9].substring(18, 24).trim());
            if (this.textHeader[9].substring(24, 25).equalsIgnoreCase("S")) {
                this.hypocenter.position.latitude *= -1.0;
            }
            this.hypocenter.position.longitude = Double.parseDouble(this.textHeader[9].substring(27, 34).trim());
            if (this.textHeader[9].substring(34, 35).equalsIgnoreCase("W")) {
                this.hypocenter.position.longitude *= -1.0;
            }
            this.hypocenter.position.elevation = 0.0;
            this.hypocenter.position.depth = 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            byte[] byArray = new byte[100];
            aSCIIInputStream.read(byArray);
            String string = new String(byArray);
            if (VERBOSE) {
                System.out.println("canRead.line: <" + string + ">");
            }
            if (string.toUpperCase().indexOf("CORRECTED ACCELEROGRAM") >= 0) {
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

