/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.math.stat;

import net.alomax.math.MathException;

public final class StatUtils {
    private StatUtils() {
    }

    public static double mean(double[] dArray, double[] dArray2) throws MathException {
        if (dArray.length != dArray2.length) {
            throw new MathException("StatUtils.mean: number of values and number of weights not identical");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i] * dArray2[i];
            d += dArray2[i];
        }
        return d2 / d;
    }

    public static double geometricMean(double[] dArray, double[] dArray2) throws MathException {
        if (dArray.length != dArray2.length) {
            throw new MathException("StatUtils.geometricMean: number of values and number of weights not identical");
        }
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 *= Math.pow(dArray[i], dArray2[i]);
            d += dArray2[i];
        }
        return Math.pow(d2, 1.0 / d);
    }
}

