/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.hodo;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.alomax.graphics3d.Vect3D;
import net.alomax.hodo.HodochroneText;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.JCompParent;
import net.alomax.swing.SwingText;
import net.alomax.text.GeneralText;
import net.alomax.util.ApplicationProperties;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;
import net.alomax.volume3d.ConstantSlownessModel;
import net.alomax.volume3d.GradientHalfSpaceModel;
import net.alomax.volume3d.SlownessModel;
import net.alomax.volume3d.TauPSlownessModel;

public class HodochronePanel
extends Panel
implements ApplicationJComp,
ActionListener,
ChangeListener {
    protected static final String VERSION = "2.0X01";
    protected static final String VERSION_YEAR = "2006";
    protected static final String VERSION_DATE = "08Feb2006";
    protected static final String VERSION_CHAR = "10";
    protected static final String COPYRIGHT_YEAR = "2000-2003";
    protected static final String PROGRAM_NAME = "Hodochrone v2.0X01";
    protected static final String[] BANNER = new String[]{"Hodochrone v2.0X01 (08Feb2006)", "Copyright \u00a9 2000-2003 Anthony Lomax (www.alomax.net), EDUSeis", "Hodochrone comes with ABSOLUTELY NO WARRANTY", "The development of the Hodochrone software is supported by:", "   EDUSeis - European Educational Project", "   Centre Internationale de Valbonne, 06560 Valbonne, France"};
    protected static final int MOD_CONSTANT = 0;
    protected static final int MOD_GRAD_LAYER_HALFSPACE = 1;
    protected static final int MOD_GLOBAL = 2;
    protected static final double SP_RATIO = 1.78;
    protected static final String DISTANCE_UNITS_KM = "km";
    protected static final String DISTANCE_UNITS_DEG = "deg";
    protected static final String TIME_UNITS_SEC = "s";
    protected static final String TIME_UNITS_MIN = "min";
    protected static final String pWavetype = "P";
    protected static final String sWavetype = "S";
    protected static final String pWavetypeUp = "p";
    protected static final String sWavetypeUp = "s";
    protected JCompParent parent = null;
    public String titleString = "Hodochrone v2.0X01";
    protected HodoPanel hodoPanel = new HodoPanel();
    protected String distanceUnits = "km";
    protected String timeUnits = "s";
    protected double timeMultiplier = 1.0;
    protected int xOrig;
    protected int xMax;
    protected int yMax;
    protected int yOrig;
    protected Vect3D origin = new Vect3D(0.0, 0.0, 0.0);
    protected double distanceMax;
    protected double timeMax;
    protected double timeMaxP;
    protected double timeMaxS;
    protected int modelType = 1;
    protected SlownessModel slownessModel;
    protected String pModelString = "";
    protected String sModelString = "";
    protected String mohoString = "";
    protected boolean plotTeleseismicRayleighWave = false;
    protected boolean plotTeleseismicLoveWave = false;
    protected double timeMaxRayleigh;
    protected double timeMaxLove;
    protected String rayleighModelString = "";
    protected String loveModelString = "";
    protected double velSurfaceP;
    protected double velLowerCrustP;
    protected double velMohoP;
    protected double velSurfaceS;
    protected double velLowerCrustS;
    protected double velMohoS;
    protected double mohoDepth = Double.MAX_VALUE;
    protected JSpinner spinner_sourceDepth = null;
    protected JSpinner spinner_velSurfaceP = null;
    protected JSpinner spinner_velLowerCrustP = null;
    protected JSpinner spinner_velSurfaceS = null;
    protected JSpinner spinner_velLowerCrustS = null;
    protected JSpinner spinner_mohoDepth = null;
    protected JSpinner spinner_velMohoP = null;
    protected JSpinner spinner_velMohoS = null;
    protected JComboBox modelComboBox = null;
    protected JButton resetButton = null;
    protected int currentModelIndex = 0;
    protected boolean inLayoutComponents = false;
    protected int fontSize;
    protected int numTimeDecimals;
    protected Font normalFont;
    protected Font emphasisFont;
    protected Color valuesColor;
    protected Color travelTimeColorP;
    protected Color travelTimeColorS;
    protected Color travelTimeColorRayleigh;
    protected Color travelTimeColorLove;
    protected Color textColor;

    public HodochronePanel(JCompParent jCompParent) {
        this.parent = jCompParent;
    }

    public String getAppletInfo() {
        String string = "";
        for (int i = 0; i < BANNER.length; ++i) {
            string = string + BANNER[i] + System.getProperty("line.separator");
        }
        return string;
    }

    public void init() {
        String string = this.parent.getParameter("locale");
        if (string != null) {
            this.setLocale(string);
        } else {
            this.setLocale("fr");
        }
        for (int i = 0; i < BANNER.length; ++i) {
            System.out.println(BANNER[i]);
        }
        System.out.println(GeneralText.YOU_ARE_USING_JAVA_VERSION + " " + System.getProperty("java.version") + " (" + System.getProperty("java.class.version") + ", " + System.getProperty("java.vendor") + ")");
    }

    public void start() {
        this.layoutComponents();
        this.setVisible(true);
    }

    public void layoutComponents() {
        JPanel jPanel;
        this.inLayoutComponents = true;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.hodoPanel, "Center");
        this.fontSize = this.getFont().getSize();
        this.normalFont = new Font("TimesNewRoman", 1, this.fontSize);
        this.emphasisFont = new Font("TimesNewRoman", 1, 3 * this.fontSize / 2);
        this.valuesColor = new Color(191, 0, 0);
        this.travelTimeColorP = new Color(0, 0, 191);
        this.travelTimeColorS = new Color(0, 127, 0);
        this.travelTimeColorRayleigh = new Color(127, 127, 127);
        this.travelTimeColorLove = new Color(127, 127, 127);
        this.textColor = new Color(0, 0, 0);
        this.initSlownessModel(true);
        if (ApplicationProperties.getTrueFalseParameter(this, false, "allow_edit") && (jPanel = this.initEditPanel()) != null) {
            this.add((Component)jPanel, "South");
        }
        super.validate();
        this.inLayoutComponents = false;
        this.setVisible(true);
    }

    protected JPanel initEditPanel() {
        Object object;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        if (this.modelType == 0) {
            jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Vp:"));
            this.spinner_velSurfaceP = new JSpinner(new SpinnerNumberModel(this.velSurfaceP, 0.01, 10.0, 0.1));
            this.spinner_velSurfaceP.addChangeListener(this);
            jPanel.add(this.spinner_velSurfaceP);
            jPanel.add(new JLabel("   "));
            jPanel.add(new JLabel("Vs:"));
            this.spinner_velSurfaceS = new JSpinner(new SpinnerNumberModel(this.velSurfaceS, 0.01, 10.0, 0.1));
            this.spinner_velSurfaceS.addChangeListener(this);
            jPanel.add(this.spinner_velSurfaceS);
            jPanel2.add((Component)jPanel, "North");
        } else if (this.modelType == 1) {
            jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Vp " + HodochroneText.SURFACE + ":"));
            this.spinner_velSurfaceP = new JSpinner(new SpinnerNumberModel(this.velSurfaceP, 0.01, 10.0, 0.1));
            this.spinner_velSurfaceP.addChangeListener(this);
            jPanel.add(this.spinner_velSurfaceP);
            jPanel.add(new JLabel("   "));
            jPanel.add(new JLabel("Vp " + HodochroneText.BASE_CRUST + ":"));
            this.spinner_velLowerCrustP = new JSpinner(new SpinnerNumberModel(this.velLowerCrustP, 0.01, 10.0, 0.1));
            this.spinner_velLowerCrustP.addChangeListener(this);
            jPanel.add(this.spinner_velLowerCrustP);
            jPanel.add(new JLabel("   "));
            jPanel.add(new JLabel("Vs " + HodochroneText.SURFACE + ":"));
            this.spinner_velSurfaceS = new JSpinner(new SpinnerNumberModel(this.velSurfaceS, 0.01, 10.0, 0.1));
            this.spinner_velSurfaceS.addChangeListener(this);
            jPanel.add(this.spinner_velSurfaceS);
            jPanel.add(new JLabel("   "));
            jPanel.add(new JLabel("Vs " + HodochroneText.BASE_CRUST + ":"));
            this.spinner_velLowerCrustS = new JSpinner(new SpinnerNumberModel(this.velLowerCrustS, 0.01, 10.0, 0.1));
            this.spinner_velLowerCrustS.addChangeListener(this);
            jPanel.add(this.spinner_velLowerCrustS);
            jPanel2.add((Component)jPanel, "North");
            object = new JPanel(new FlowLayout());
            ((Container)object).add(new JLabel("   "));
            ((Container)object).add(new JLabel(HodochroneText.MOHO_DEPTH + ":"));
            this.spinner_mohoDepth = new JSpinner(new SpinnerNumberModel(this.mohoDepth, 0.01, 100.0, 0.1));
            this.spinner_mohoDepth.addChangeListener(this);
            ((Container)object).add(this.spinner_mohoDepth);
            ((Container)object).add(new JLabel("   "));
            ((Container)object).add(new JLabel("Vp " + HodochroneText.MANTLE + ":"));
            this.spinner_velMohoP = new JSpinner(new SpinnerNumberModel(this.velMohoP, 0.01, 10.0, 0.1));
            this.spinner_velMohoP.addChangeListener(this);
            ((Container)object).add(this.spinner_velMohoP);
            ((Container)object).add(new JLabel("   "));
            ((Container)object).add(new JLabel("Vs " + HodochroneText.MANTLE + ":"));
            this.spinner_velMohoS = new JSpinner(new SpinnerNumberModel(this.velMohoS, 0.01, 10.0, 0.1));
            this.spinner_velMohoS.addChangeListener(this);
            ((Container)object).add(this.spinner_velMohoS);
            jPanel2.add((Component)object, "Center");
        }
        jPanel = new JPanel(new FlowLayout());
        try {
            object = this.getParameter("vel_model_name");
            if (object != null) {
                String[] stringArray = StringExt.parse((String)object, ",");
                if (stringArray.length > 1) {
                    this.modelComboBox = new JComboBox<String>(stringArray);
                    this.modelComboBox.addActionListener(this);
                    this.modelComboBox.setSelectedIndex(this.currentModelIndex);
                    jPanel.add(new JLabel(HodochroneText.SELECT_MODEL + ":"));
                    jPanel.add(this.modelComboBox);
                    jPanel.add(new JLabel("  "));
                } else if (stringArray.length == 1) {
                    jPanel.add(new JLabel(HodochroneText.MODEL + ": " + stringArray[0]));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("ERRROR: parsing vel_model_name parameter: " + exception.getMessage());
        }
        jPanel.add(new JLabel(HodochroneText.SOURCE_DEPTH + ":"));
        double d = 700.0;
        this.spinner_sourceDepth = new JSpinner(new SpinnerNumberModel(this.origin.z, -0.001, d, 1.0));
        this.spinner_sourceDepth.addChangeListener(this);
        jPanel.add(this.spinner_sourceDepth);
        if (this.modelType != 2) {
            jPanel.add(new JLabel("      "));
            this.resetButton = new JButton(HodochroneText.RESET);
            this.resetButton.addActionListener(this);
            jPanel.add(this.resetButton);
        }
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.inLayoutComponents) {
            return;
        }
        if (actionEvent.getSource().equals(this.resetButton)) {
            this.layoutComponents();
            this.repaint();
        } else if (actionEvent.getSource().equals(this.modelComboBox)) {
            this.currentModelIndex = this.modelComboBox.getSelectedIndex();
            this.layoutComponents();
            this.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.inLayoutComponents) {
            return;
        }
        if (changeEvent.getSource().equals(this.spinner_velSurfaceP)) {
            this.velSurfaceP = ((Number)this.spinner_velSurfaceP.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_velLowerCrustP)) {
            this.velLowerCrustP = ((Number)this.spinner_velLowerCrustP.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_velSurfaceS)) {
            this.velSurfaceS = ((Number)this.spinner_velSurfaceS.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_velLowerCrustS)) {
            this.velLowerCrustS = ((Number)this.spinner_velLowerCrustS.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_mohoDepth)) {
            this.mohoDepth = ((Number)this.spinner_mohoDepth.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_velMohoP)) {
            this.velMohoP = ((Number)this.spinner_velMohoP.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_velMohoS)) {
            this.velMohoS = ((Number)this.spinner_velMohoS.getValue()).doubleValue();
        } else if (changeEvent.getSource().equals(this.spinner_sourceDepth)) {
            double d = ((Number)this.spinner_sourceDepth.getValue()).doubleValue();
            this.origin = new Vect3D(0.0, 0.0, d);
        } else {
            return;
        }
        this.initSlownessModel(false);
        this.repaint();
    }

    protected void initSlownessModel(boolean bl) {
        int n;
        this.numTimeDecimals = 1;
        try {
            int n2;
            this.numTimeDecimals = n2 = new Integer(this.getListParameter("num_time_decimals", this.currentModelIndex)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.distanceMax = 300.0;
        try {
            double d;
            this.distanceMax = d = new Double(this.getListParameter("distmax", this.currentModelIndex)).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                String string = this.getListParameter("vel_model", this.currentModelIndex);
                if (string.equals("GRAD_LAYER_HALFSPACE")) {
                    this.modelType = 1;
                } else if (string.equals("GLOBAL")) {
                    this.modelType = 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.velSurfaceP = 5.0;
            try {
                double d;
                this.velSurfaceP = d = new Double(this.getListParameter("vel_p", this.currentModelIndex)).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.velSurfaceS = 2.8;
            try {
                double d;
                this.velSurfaceS = d = new Double(this.getListParameter("vel_s", this.currentModelIndex)).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.timeUnits = "s";
        this.distanceUnits = DISTANCE_UNITS_KM;
        this.timeMultiplier = 1.0;
        if (bl) {
            this.mohoDepth = Double.MAX_VALUE;
        }
        if (this.modelType == 2) {
            try {
                this.slownessModel = new TauPSlownessModel("P,S,p,s");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pModelString = HodochroneText.P_TELESEISMIC;
            this.sModelString = HodochroneText.S_TELESEISMIC;
            this.distanceUnits = DISTANCE_UNITS_DEG;
            if (this.distanceMax > 180.0) {
                this.distanceMax = 95.0;
            }
            this.timeUnits = TIME_UNITS_MIN;
            this.timeMultiplier = 0.016666666666666666;
            this.plotTeleseismicRayleighWave = true;
            this.plotTeleseismicLoveWave = false;
            this.rayleighModelString = HodochroneText.RAYLEIGH_TELESEISMIC;
            this.loveModelString = HodochroneText.LOVE_TELESEISMIC;
        } else if (this.modelType == 0) {
            this.slownessModel = new ConstantSlownessModel(1.0 / this.velSurfaceP, pWavetype, 1.0 / this.velSurfaceS, sWavetype, null, null, null);
            this.pModelString = HodochroneText.P_WAVE + " (Vp=" + NumberFormat.decimalString(this.velSurfaceP, 2) + "km/s)";
            this.sModelString = HodochroneText.S_WAVE + " (Vs=" + NumberFormat.decimalString(this.velSurfaceS, 2) + "km/s)";
        } else if (this.modelType == 1) {
            if (bl) {
                this.velLowerCrustP = 6.8;
                try {
                    double d;
                    this.velLowerCrustP = d = new Double(this.getListParameter("vel_p_lower_crust", this.currentModelIndex)).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.velMohoP = 8.0;
                try {
                    double d;
                    this.velMohoP = d = new Double(this.getListParameter("vel_p_mantle", this.currentModelIndex)).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.velLowerCrustS = 3.8;
                try {
                    double d;
                    this.velLowerCrustS = d = new Double(this.getListParameter("vel_s_lower_crust", this.currentModelIndex)).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.velMohoS = 4.5;
                try {
                    double d;
                    this.velMohoS = d = new Double(this.getListParameter("vel_s_mantle", this.currentModelIndex)).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mohoDepth = 35.0;
                try {
                    double d;
                    this.mohoDepth = d = new Double(this.getListParameter("moho_depth", this.currentModelIndex)).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.slownessModel = new GradientHalfSpaceModel(this.velSurfaceP, (this.velLowerCrustP - this.velSurfaceP) / this.mohoDepth, this.velMohoP, pWavetype, this.velSurfaceS, (this.velLowerCrustS - this.velSurfaceS) / this.mohoDepth, this.velMohoS, sWavetype, this.mohoDepth, 0.0, null, null, null);
            this.pModelString = HodochroneText.P_WAVE + " (V=[" + NumberFormat.decimalString(this.velSurfaceP, -1, 2, false) + "->" + NumberFormat.decimalString(this.velLowerCrustP, -1, 2, false) + "] / " + NumberFormat.decimalString(this.velMohoP, -1, 2, false) + " km/s)";
            this.sModelString = HodochroneText.S_WAVE + " (V=[" + NumberFormat.decimalString(this.velSurfaceS, -1, 2, false) + "->" + NumberFormat.decimalString(this.velLowerCrustS, -1, 2, false) + "] /" + NumberFormat.decimalString(this.velMohoS, -1, 2, false) + " km/s)";
            this.mohoString = "Moho h=" + NumberFormat.decimalString(this.mohoDepth, -1, 1, false) + DISTANCE_UNITS_KM;
        }
        if (bl) {
            double d = 10.0;
            try {
                d = new Double(this.getListParameter("source_depth", this.currentModelIndex));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d > this.mohoDepth) {
                d = 0.0;
            }
            this.origin = new Vect3D(0.0, 0.0, d);
        }
        this.timeMaxP = 0.0;
        for (n = 0; n < 101; ++n) {
            this.timeMaxP = Math.max(this.pTime(this.distanceMax * ((double)n / 100.0)), this.timeMaxP);
        }
        this.timeMaxS = 0.0;
        for (n = 0; n < 101; ++n) {
            this.timeMaxS = Math.max(this.sTime(this.distanceMax * ((double)n / 100.0)), this.timeMaxS);
        }
        this.timeMax = Math.max(this.timeMaxP, this.timeMaxS);
        this.timeMaxRayleigh = this.timeMaxP;
        this.timeMaxLove = this.timeMaxS;
    }

    public String getTitleString() {
        if (this.titleString != null) {
            return this.titleString;
        }
        return " ";
    }

    public String getProgramName() {
        return PROGRAM_NAME;
    }

    public JCompParent getJCompParent() {
        return this.parent;
    }

    public String getParameter(String string) {
        String string2 = this.parent.getParameter(string);
        if (string2 == null) {
            string2 = this.parent.getParameter(StringExt.replace(string, ".", ""));
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public String getListParameter(String string, int n) {
        String[] stringArray;
        String string2 = this.parent.getParameter(string);
        if (string2 == null) {
            string2 = this.parent.getParameter(StringExt.replace(string, ".", ""));
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((stringArray = StringExt.parse(string2, ",")).length <= n) {
            return null;
        }
        return stringArray[n];
    }

    public void writeMessage(String string) {
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{};
        return stringArray;
    }

    protected void setLocale(String string) {
        GeneralText.setLocale(string);
        HodochroneText.setLocale(string);
        HodochronePanel.BANNER[2] = PROGRAM_NAME + GeneralText.NO_WARRANTY;
    }

    public void stop() {
    }

    public void run() {
    }

    public void cleanUp() {
    }

    public void dispose() {
    }

    public void print(Graphics graphics) {
    }

    public void writeAppletSecurityMessage(String string, Throwable throwable) {
        String string2 = "ERROR: " + string + ": " + throwable;
        System.out.println(string2);
        this.writeMessage(string2);
        if (this.parent.isApplet()) {
            String string3 = this.parent.getDocumentBase().getHost();
            if (string3 == null || string3.length() < 1) {
                string3 = "localhost";
            }
            string2 = "ERROR: " + SwingText.ERROR_APPLET_SECURITY_1 + ": <" + string3 + "> " + SwingText.ERROR_APPLET_SECURITY_2;
            System.out.println(string2);
            this.writeMessage(string2);
            String string4 = SwingText.ERROR_APPLET_SECURITY_TITLE + " - " + string;
            JOptionPane.showMessageDialog(this, string2, string4, 0);
        }
    }

    public double pTime(double d) {
        Vect3D vect3D = new Vect3D(0.0, d, 0.0);
        double d2 = this.slownessModel.getTravelTime(this.origin, vect3D, pWavetype);
        if (d2 < 0.0) {
            d2 = this.slownessModel.getTravelTime(this.origin, vect3D, pWavetypeUp);
        }
        return this.timeMultiplier * d2;
    }

    public double sTime(double d) {
        Vect3D vect3D = new Vect3D(0.0, d, 0.0);
        double d2 = this.slownessModel.getTravelTime(this.origin, vect3D, sWavetype);
        if (d2 < 0.0) {
            d2 = this.slownessModel.getTravelTime(this.origin, vect3D, "s");
        }
        return this.timeMultiplier * d2;
    }

    public double rayleighTime(double d) {
        return this.timeMultiplier * this.slownessModel.getTravelTime(this.origin, new Vect3D(0.0, d, 0.0), "Lr");
    }

    public double loveTime(double d) {
        return this.timeMultiplier * this.slownessModel.getTravelTime(this.origin, new Vect3D(0.0, d, 0.0), "Lq");
    }

    public class HodoPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        protected BasicStroke basicStroke = new BasicStroke(2.0f);
        private int lastx = -1;

        public HodoPanel() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setDoubleBuffered(false);
        }

        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            this.setXYbounds();
            graphics.drawLine(HodochronePanel.this.xOrig, HodochronePanel.this.yOrig, HodochronePanel.this.xMax, HodochronePanel.this.yOrig);
            graphics.drawLine(HodochronePanel.this.xOrig, HodochronePanel.this.yOrig, HodochronePanel.this.xOrig, HodochronePanel.this.yMax);
            graphics.setFont(HodochronePanel.this.normalFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = 3;
            int n3 = 0;
            double d = HodochronePanel.this.distanceMax <= 500.0 ? 50.0 : 100.0;
            d = HodochronePanel.this.distanceMax <= 200.0 ? 20.0 : d;
            d = HodochronePanel.this.distanceMax <= 100.0 ? 10.0 : d;
            d = HodochronePanel.this.distanceMax <= 50.0 ? 5.0 : d;
            for (double d2 = d = HodochronePanel.this.distanceMax <= 20.0 ? 2.0 : d; d2 <= HodochronePanel.this.distanceMax; d2 += d) {
                n3 = this.dist2x(d2);
                graphics.setColor(Color.black);
                graphics.drawLine(n3, HodochronePanel.this.yOrig - n2, n3, HodochronePanel.this.yOrig + n2);
                graphics.setColor(HodochronePanel.this.textColor);
                String string = NumberFormat.intString((int)(0.5 + d2), -1);
                graphics.drawString(string, n3 - fontMetrics.stringWidth(string) / 2, HodochronePanel.this.yOrig + 2 * n2 + fontMetrics.getAscent());
            }
            graphics.setColor(HodochronePanel.this.textColor);
            graphics.drawString("(" + HodochronePanel.this.distanceUnits + ")", n3 + 1 * fontMetrics.getMaxAdvance(), HodochronePanel.this.yOrig + 2 * n2 + fontMetrics.getAscent());
            int n4 = 0;
            d = HodochronePanel.this.timeMax <= 500.0 ? 50.0 : 100.0;
            d = HodochronePanel.this.timeMax <= 200.0 ? 20.0 : d;
            d = HodochronePanel.this.timeMax <= 100.0 ? 10.0 : d;
            d = HodochronePanel.this.timeMax <= 50.0 ? 5.0 : d;
            for (double d3 = d = HodochronePanel.this.timeMax <= 20.0 ? 2.0 : d; d3 <= HodochronePanel.this.timeMax; d3 += d) {
                n4 = this.sec2y(d3);
                graphics.setColor(Color.black);
                graphics.drawLine(HodochronePanel.this.xOrig - n2, n4, HodochronePanel.this.xOrig + n2, n4);
                graphics.setColor(HodochronePanel.this.textColor);
                String string = NumberFormat.decimalString(d3, -1, HodochronePanel.this.numTimeDecimals, false);
                graphics.drawString(string, HodochronePanel.this.xOrig - fontMetrics.stringWidth(string) - 2 * n2, n4 + fontMetrics.getAscent() / 2);
            }
            graphics.setColor(HodochronePanel.this.textColor);
            String string = "(" + HodochronePanel.this.timeUnits + ")  ";
            graphics.drawString(string, HodochronePanel.this.xOrig - fontMetrics.stringWidth(string), this.sec2y(HodochronePanel.this.timeMax) - fontMetrics.getAscent());
            double d4 = HodochronePanel.this.distanceMax / 500.0;
            int n5 = this.sec2y(HodochronePanel.this.pTime(0.0));
            int n6 = this.sec2y(HodochronePanel.this.sTime(0.0));
            int n7 = this.sec2y(HodochronePanel.this.rayleighTime(0.0));
            int n8 = this.sec2y(HodochronePanel.this.loveTime(0.0));
            int n9 = this.dist2x(0.0);
            Graphics graphics2 = graphics.create();
            if (this.basicStroke != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(this.basicStroke);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            for (double d5 = d4; d5 <= HodochronePanel.this.distanceMax; d5 += d4) {
                int n14;
                double d6;
                n = this.dist2x(d5);
                int n15 = this.sec2y(HodochronePanel.this.pTime(d5));
                graphics2.setColor(HodochronePanel.this.travelTimeColorP);
                graphics2.drawLine(n9, n5, n, n15);
                int n16 = this.sec2y(HodochronePanel.this.sTime(d5));
                graphics2.setColor(HodochronePanel.this.travelTimeColorS);
                graphics2.drawLine(n9, n6, n, n16);
                n5 = n15;
                n6 = n16;
                if (HodochronePanel.this.plotTeleseismicRayleighWave && (d6 = HodochronePanel.this.rayleighTime(d5)) < HodochronePanel.this.timeMax) {
                    n14 = this.sec2y(d6);
                    graphics2.setColor(HodochronePanel.this.travelTimeColorRayleigh);
                    graphics2.drawLine(n9, n7, n, n14);
                    n7 = n14;
                    n10 = n;
                    n12 = n14;
                }
                if (HodochronePanel.this.plotTeleseismicLoveWave && (d6 = HodochronePanel.this.loveTime(d5)) < HodochronePanel.this.timeMax) {
                    n14 = this.sec2y(d6);
                    graphics2.setColor(HodochronePanel.this.travelTimeColorLove);
                    graphics2.drawLine(n9, n8, n, n14);
                    n8 = n14;
                    n11 = n;
                    n13 = n14;
                }
                n9 = n;
            }
            graphics2.dispose();
            this.lastx = -1;
            graphics.setColor(HodochronePanel.this.travelTimeColorP);
            graphics.drawString(HodochronePanel.this.pModelString, HodochronePanel.this.xMax - fontMetrics.stringWidth(HodochronePanel.this.pModelString), this.sec2y(HodochronePanel.this.timeMaxP) - fontMetrics.getAscent() / 4);
            graphics.setColor(HodochronePanel.this.travelTimeColorS);
            graphics.drawString(HodochronePanel.this.sModelString, HodochronePanel.this.xMax - fontMetrics.stringWidth(HodochronePanel.this.sModelString), this.sec2y(HodochronePanel.this.timeMaxS) - fontMetrics.getAscent() / 4);
            graphics.setColor(HodochronePanel.this.textColor);
            String string2 = HodochroneText.SOURCE_DEPTH + "=" + NumberFormat.decimalString(HodochronePanel.this.origin.z, -1, 1, false) + HodochronePanel.DISTANCE_UNITS_KM;
            String string3 = HodochronePanel.this.mohoString + "    " + string2;
            graphics.drawString(string3, HodochronePanel.this.xMax - fontMetrics.stringWidth(string3), this.sec2y(0.0) - fontMetrics.getAscent());
            n = fontMetrics.stringWidth("-");
            if (HodochronePanel.this.plotTeleseismicRayleighWave) {
                graphics.setColor(HodochronePanel.this.travelTimeColorRayleigh);
                graphics.drawString(HodochronePanel.this.rayleighModelString, n10 + n, n12 + fontMetrics.getAscent());
            }
            if (HodochronePanel.this.plotTeleseismicLoveWave) {
                graphics.setColor(HodochronePanel.this.travelTimeColorLove);
                graphics.drawString(HodochronePanel.this.loveModelString, n11 + n, n13 + fontMetrics.getAscent());
            }
        }

        protected synchronized boolean update(int n, int n2) {
            Graphics graphics = this.getGraphics();
            graphics.setFont(HodochronePanel.this.emphasisFont);
            this.setXYbounds();
            double d = this.x2dist(n);
            if (d < 0.0 || d > HodochronePanel.this.distanceMax) {
                return true;
            }
            if (this.lastx > -1) {
                double d2 = this.x2dist(this.lastx);
                if (this.lastx != HodochronePanel.this.xOrig) {
                    this.drawLines(graphics, this.lastx, d2);
                }
                graphics.setPaintMode();
                graphics.setColor(this.getBackground());
                this.drawValues(graphics, this.lastx, d2, 0);
                this.drawValues(graphics, this.lastx, d2, -1);
                this.drawValues(graphics, this.lastx, d2, 1);
            }
            if (n != HodochronePanel.this.xOrig) {
                this.drawLines(graphics, n, d);
            }
            graphics.setPaintMode();
            graphics.setColor(HodochronePanel.this.valuesColor);
            this.drawValues(graphics, n, d, 0);
            graphics.dispose();
            this.lastx = n;
            return true;
        }

        protected void drawLines(Graphics graphics, int n, double d) {
            graphics.setXORMode(this.getBackground());
            int n2 = this.sec2y(HodochronePanel.this.sTime(d));
            int n3 = this.sec2y(HodochronePanel.this.pTime(d));
            graphics.setColor(Color.gray);
            graphics.drawLine(n, HodochronePanel.this.yMax, n, n3);
            graphics.drawLine(n, n2, n, HodochronePanel.this.yOrig);
            graphics.setColor(HodochronePanel.this.valuesColor);
            graphics.fillRect(n - 2, n2, 5, n3 - n2);
        }

        protected void drawValues(Graphics graphics, int n, double d, int n2) {
            graphics.drawString("dist= " + (int)(0.5 + d) + " " + HodochronePanel.this.distanceUnits, n + n2, HodochronePanel.this.yOrig + 4 * HodochronePanel.this.fontSize);
            double d2 = HodochronePanel.this.sTime(d) - HodochronePanel.this.pTime(d);
            String string = "Ts-Tp= " + NumberFormat.decimalString(d2, -1, HodochronePanel.this.numTimeDecimals, true) + " " + HodochronePanel.this.timeUnits;
            if (HodochronePanel.this.timeMultiplier != 1.0) {
                string = string + " (" + NumberFormat.decimalString(d2 / HodochronePanel.this.timeMultiplier, -1, HodochronePanel.this.numTimeDecimals, true) + " s)";
            }
            int n3 = HodochronePanel.this.yMax - HodochronePanel.this.fontSize;
            graphics.drawString(string, HodochronePanel.this.xOrig + 2 * HodochronePanel.this.fontSize + n2, n3);
            string = "Tp-To= " + NumberFormat.decimalString(HodochronePanel.this.pTime(d), -1, HodochronePanel.this.numTimeDecimals, true) + " " + HodochronePanel.this.timeUnits;
            if (HodochronePanel.this.timeMultiplier != 1.0) {
                string = string + " (" + NumberFormat.decimalString(HodochronePanel.this.pTime(d) / HodochronePanel.this.timeMultiplier, -1, HodochronePanel.this.numTimeDecimals, true) + " s)";
            }
            graphics.drawString(string, HodochronePanel.this.xOrig + 2 * HodochronePanel.this.fontSize + n2, n3 += 2 * HodochronePanel.this.fontSize);
            if (HodochronePanel.this.plotTeleseismicRayleighWave) {
                double d3 = HodochronePanel.this.rayleighTime(d) - HodochronePanel.this.pTime(d);
                string = "Lr-Tp= " + NumberFormat.decimalString(d3, -1, HodochronePanel.this.numTimeDecimals, true) + " " + HodochronePanel.this.timeUnits;
                if (HodochronePanel.this.timeMultiplier != 1.0) {
                    string = string + " (" + NumberFormat.decimalString(d3 / HodochronePanel.this.timeMultiplier, -1, HodochronePanel.this.numTimeDecimals, true) + " s)";
                }
                graphics.drawString(string, HodochronePanel.this.xOrig + 2 * HodochronePanel.this.fontSize + n2, n3 += 2 * HodochronePanel.this.fontSize);
            }
        }

        protected void setXYbounds() {
            HodochronePanel.this.xOrig = 4 * HodochronePanel.this.fontSize;
            HodochronePanel.this.xMax = this.getSize().width - 2 * HodochronePanel.this.xOrig;
            HodochronePanel.this.yMax = 3 * HodochronePanel.this.fontSize;
            HodochronePanel.this.yOrig = this.getSize().height - 5 * HodochronePanel.this.fontSize;
        }

        public int dist2x(double d) {
            return HodochronePanel.this.xOrig + (int)((double)(HodochronePanel.this.xMax - HodochronePanel.this.xOrig) * d / HodochronePanel.this.distanceMax);
        }

        public int sec2y(double d) {
            return HodochronePanel.this.yMax + (int)((double)(HodochronePanel.this.yOrig - HodochronePanel.this.yMax) * (HodochronePanel.this.timeMax - d) / HodochronePanel.this.timeMax);
        }

        public double x2dist(int n) {
            return HodochronePanel.this.distanceMax * (double)(n - HodochronePanel.this.xOrig) / (double)(HodochronePanel.this.xMax - HodochronePanel.this.xOrig);
        }

        public double y2sec(int n) {
            return HodochronePanel.this.timeMax * (double)(n - HodochronePanel.this.yMax) / (double)(HodochronePanel.this.yOrig - HodochronePanel.this.yMax);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            HodochronePanel.this.hodoPanel.update(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            HodochronePanel.this.hodoPanel.update(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

