/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import JSci.awt.Graph2D;
import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.alomax.graphics2d.JGraphPanel;
import net.alomax.util.NumberFormat;

public abstract class JGraph2DAJL
extends JGraphPanel
implements GraphDataListener {
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final double INV_LOG_10 = 1.0 / Math.log(10.0);
    protected Graph2DModel model;
    protected Point origin = new Point();
    protected Graph2D.DataMarker dataMarker = Graph2D.DataMarker.NONE;
    protected Color[] seriesColor = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    protected boolean xNumbering = true;
    protected boolean yNumbering = true;
    protected boolean xAxisLine = true;
    protected boolean yAxisLine = true;
    protected boolean gridLines = false;
    protected Color gridLineColor = Color.lightGray;
    protected double xScale;
    protected double yScale;
    protected int xScaleType;
    protected int yScaleType;
    protected int scaledWidth;
    protected int scaledHeight;
    protected double minX;
    protected double minY;
    protected double maxX;
    protected double maxY;
    protected double scaledMinX;
    protected double scaledMinY;
    protected double scaledMaxX;
    protected double scaledMaxY;
    protected boolean autoXExtrema = true;
    protected boolean autoYExtrema = true;
    protected double xGrowth;
    protected double yGrowth;
    protected double xIncPixels = 40.0;
    protected double yIncPixels = 40.0;
    protected double xInc;
    protected double yInc;
    protected boolean autoXInc = true;
    protected boolean autoYInc = true;
    protected String title = "Title";
    protected String xAxisUnitsLabel = "X";
    protected String yAxisUnitsLabel = "Y";
    protected int scalePad = 5;
    protected int axisPad = 50;
    protected int leftAxisPad;
    protected int rightAxisPad;

    public JGraph2DAJL(Graph2DModel graph2DModel) {
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final void setModel(Graph2DModel graph2DModel) {
        this.model.removeGraphDataListener(this);
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        if (graphDataEvent.isIncremental()) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            int n = graphDataEvent.getSeries();
            if (n == -1) {
                this.model.firstSeries();
                int n2 = 0;
                do {
                    int n3 = this.model.seriesLength() - 1;
                    this.incrementalRescale(this.model.getXCoord(n3), this.model.getYCoord(n3));
                    graphics.setColor(this.seriesColor[n2]);
                    this.drawDataPoint(graphics, n3);
                    ++n2;
                } while (this.model.nextSeries());
            } else {
                int n4;
                this.model.firstSeries();
                for (n4 = 0; n4 < n; ++n4) {
                    this.model.nextSeries();
                }
                int n5 = this.model.seriesLength() - 1;
                this.incrementalRescale(this.model.getXCoord(n5), this.model.getYCoord(n5));
                graphics.setColor(this.seriesColor[n4]);
                this.drawDataPoint(graphics, n5);
            }
        } else {
            int n = 1;
            this.model.firstSeries();
            while (this.model.nextSeries()) {
                ++n;
            }
            if (n > this.seriesColor.length) {
                Color[] colorArray = this.seriesColor;
                this.seriesColor = new Color[n];
                System.arraycopy(colorArray, 0, this.seriesColor, 0, colorArray.length);
                for (int i = colorArray.length; i < n; ++i) {
                    this.seriesColor[i] = this.seriesColor[i - colorArray.length];
                }
            }
            if (this.autoXExtrema) {
                this.setXExtrema(0.0, 0.0);
            }
            if (this.autoYExtrema) {
                this.setYExtrema(0.0, 0.0);
            }
            this.repaint();
        }
    }

    protected void incrementalRescale(double d, double d2) {
        double d3 = d < this.minX ? (this.autoXExtrema ? Math.min(d, this.minX - this.xGrowth) : this.minX - this.xGrowth) : this.minX;
        double d4 = d > this.maxX ? (this.autoXExtrema ? Math.max(d, this.maxX + this.xGrowth) : this.maxX + this.xGrowth) : this.maxX;
        this.rescaleX(d3, d4);
        d3 = d2 < this.minY ? (this.autoYExtrema ? Math.min(d2, this.minY - this.yGrowth) : this.minY - this.yGrowth) : this.minY;
        d4 = d2 > this.maxY ? (this.autoYExtrema ? Math.max(d2, this.maxY + this.yGrowth) : this.maxY + this.yGrowth) : this.maxY;
        this.rescaleY(d3, d4);
    }

    public final void setNumbering(boolean bl) {
        this.setNumbering(bl, bl);
    }

    public final void setNumbering(boolean bl, boolean bl2) {
        this.xNumbering = bl;
        this.yNumbering = bl2;
        this.rescale();
    }

    public final void setAxisPad(FontMetrics fontMetrics) {
        int n = 0;
        if (fontMetrics != null) {
            n = 4 * fontMetrics.getHeight();
        }
        this.axisPad = Math.max(this.axisPad, n);
    }

    public final void setLeftAxisPad(FontMetrics fontMetrics) {
        this.leftAxisPad = this.axisPad;
        int n = 0;
        int n2 = 0;
        if (fontMetrics != null) {
            if (this.yNumbering) {
                int n3 = fontMetrics.stringWidth(NumberFormat.doubleString(this.maxY));
                int n4 = fontMetrics.stringWidth(NumberFormat.doubleString(this.minY));
                n = Math.max(n4, n3);
                if (this.scaledMinX < 0.0) {
                    int n5 = (int)((double)(Math.max(this.getSize().width, this.getMinimumSize().width) - 2 * (this.axisPad + this.scalePad)) * this.scaledMinX / (this.scaledMinX - this.scaledMaxX));
                    n = Math.max(n - n5, 0);
                }
            }
            if (this.yAxisUnitsLabel != null) {
                n2 = fontMetrics.stringWidth(this.yAxisUnitsLabel + "--");
            }
        }
        this.leftAxisPad = Math.max(this.axisPad, Math.max(n, n2));
    }

    public final void setRightAxisPad(FontMetrics fontMetrics) {
        this.rightAxisPad = this.axisPad;
        int n = 0;
        if (fontMetrics != null && this.xAxisUnitsLabel != null) {
            n = fontMetrics.stringWidth(this.xAxisUnitsLabel + "----");
        }
        this.rightAxisPad = Math.max(this.axisPad, n);
    }

    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.xNumbering, this.yNumbering);
    }

    public final void setAxisLines(boolean bl, boolean bl2) {
        this.xAxisLine = bl;
        this.yAxisLine = bl2;
        this.repaint();
    }

    public final void setGridLines(boolean bl) {
        this.gridLines = bl;
        this.repaint();
    }

    public final void setGridLineColor(Color color) {
        this.gridLineColor = color;
        this.repaint();
    }

    public final void setXScale(int n) {
        if (this.xScaleType != n) {
            this.xScaleType = n;
            this.dataChanged(new GraphDataEvent(this.model));
        }
    }

    public final void setYScale(int n) {
        if (this.yScaleType != n) {
            this.yScaleType = n;
            this.dataChanged(new GraphDataEvent(this.model));
        }
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public final void setXAxisUnitsLabel(String string) {
        this.xAxisUnitsLabel = string;
    }

    public final void setYAxisUnitsLabel(String string) {
        this.yAxisUnitsLabel = string;
    }

    public final void setXIncrement(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (d == 0.0) {
            if (!this.autoXInc) {
                this.autoXInc = true;
                this.rescale();
            }
        } else {
            this.autoXInc = false;
            if (d != this.xInc) {
                this.xInc = d;
                this.rescale();
            }
        }
    }

    public final double getXIncrement() {
        return this.xInc;
    }

    public final void setYIncrement(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (d == 0.0) {
            if (!this.autoYInc) {
                this.autoYInc = true;
                this.rescale();
            }
        } else {
            this.autoYInc = false;
            if (d != this.yInc) {
                this.yInc = d;
                this.rescale();
            }
        }
    }

    public final double getYIncrement() {
        return this.yInc;
    }

    public final void setXExtrema(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.autoXExtrema = true;
            d = Double.POSITIVE_INFINITY;
            d2 = Double.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    double d3 = this.model.getXCoord(i);
                    if (Double.isNaN(d3)) continue;
                    d = Math.min(d3, d);
                    d2 = Math.max(d3, d2);
                }
            } while (this.model.nextSeries());
            if (d == d2) {
                if (this.yScaleType == 1) {
                    d /= 10.0;
                    d2 *= 10.0;
                } else {
                    d -= 0.5;
                    d2 += 0.5;
                }
            }
            if (d == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                if (this.xScaleType == 1) {
                    d = 1.0;
                    d2 = 100.0;
                } else {
                    d = -5.0;
                    d2 = 5.0;
                }
            }
        } else {
            if (d2 < d) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + d2 + " and min = " + d);
            }
            if (d2 - d < Double.MIN_VALUE) {
                d2 += 1.0;
                d -= 1.0;
            } else {
                d -= (d2 - d) / 1000.0;
                d2 += (d2 - d) / 1000.0;
            }
            this.autoXExtrema = false;
        }
        this.rescaleX(d, d2);
    }

    public final void setXExtrema(double d, double d2, double d3) {
        this.setXExtrema(d, d2);
        this.xGrowth = d3;
    }

    public final double getXMinimum() {
        return this.minX;
    }

    public final double getXMaximum() {
        return this.maxX;
    }

    protected void rescaleX(double d, double d2) {
        if (d != this.minX || d2 != this.maxX) {
            this.minX = d;
            this.maxX = d2;
            if (this.xScaleType == 1) {
                this.scaledMinX = Math.log(this.minX) * INV_LOG_10;
                this.scaledMaxX = Math.log(this.maxX) * INV_LOG_10;
            } else {
                this.scaledMinX = this.minX;
                this.scaledMaxX = this.maxX;
            }
            this.setNumbering(this.xNumbering, this.yNumbering);
        }
    }

    public final void setYExtrema(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.autoYExtrema = true;
            d = Double.POSITIVE_INFINITY;
            d2 = Double.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    double d3 = this.model.getYCoord(i);
                    if (Double.isNaN(d3)) continue;
                    d = Math.min(d3, d);
                    d2 = Math.max(d3, d2);
                }
            } while (this.model.nextSeries());
            if (d == d2) {
                if (this.yScaleType == 1) {
                    d /= 10.0;
                    d2 *= 10.0;
                } else {
                    d -= 0.5;
                    d2 += 0.5;
                }
            }
            if (d == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                if (this.yScaleType == 1) {
                    d = 1.0;
                    d2 = 100.0;
                } else {
                    d = -5.0;
                    d2 = 5.0;
                }
            }
        } else {
            if (d2 < d) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + d2 + " and min = " + d);
            }
            if (d2 - d < Double.MIN_VALUE) {
                d2 += 1.0;
                d -= 1.0;
            } else {
                d -= (d2 - d) / 1000.0;
                d2 += (d2 - d) / 1000.0;
            }
            this.autoYExtrema = false;
        }
        this.rescaleY(d, d2);
    }

    public final void setYExtrema(double d, double d2, double d3) {
        this.setYExtrema(d, d2);
        this.yGrowth = d3;
    }

    public final double getYMinimum() {
        return this.minY;
    }

    public final double getYMaximum() {
        return this.maxY;
    }

    protected void rescaleY(double d, double d2) {
        if (d != this.minY || d2 != this.maxY) {
            this.minY = d;
            this.maxY = d2;
            if (this.yScaleType == 1) {
                this.scaledMinY = Math.log(this.minY) * INV_LOG_10;
                this.scaledMaxY = Math.log(this.maxY) * INV_LOG_10;
            } else {
                this.scaledMinY = this.minY;
                this.scaledMaxY = this.maxY;
            }
            this.setNumbering(this.xNumbering, this.yNumbering);
        }
    }

    public final Rectangle2D.Double getExtrema() {
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public final void setMarker(Graph2D.DataMarker dataMarker) {
        this.dataMarker = dataMarker;
        this.repaint();
    }

    public final void setColor(int n, Color color) {
        this.seriesColor[n] = color;
        this.repaint();
    }

    public final Color getColor(int n) {
        return this.seriesColor[n];
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(170, 170);
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        FontMetrics fontMetrics = null;
        if (this.getFont() != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
        }
        this.rescale(n, n2, fontMetrics);
    }

    protected final void rescale(int n, int n2, FontMetrics fontMetrics) {
        this.scaledWidth = n;
        this.scaledHeight = n2;
        this.axisPad = this.scaledWidth / 20;
        this.scalePad = this.axisPad / 10;
        this.setAxisPad(fontMetrics);
        this.setLeftAxisPad(fontMetrics);
        this.setRightAxisPad(fontMetrics);
        this.xScale = (double)(this.scaledWidth - (this.leftAxisPad + this.rightAxisPad)) / (this.scaledMaxX - this.scaledMinX);
        this.yScale = (double)(this.scaledHeight - 2 * this.axisPad) / (this.scaledMaxY - this.scaledMinY);
        this.xIncPixels = (double)this.scaledWidth / 5.0;
        if (this.autoXInc) {
            this.xInc = this.getTickSpace(this.scaledMinX, this.scaledMaxX, 4.0);
        }
        this.yIncPixels = (double)this.scaledHeight / 5.0;
        if (this.autoYInc) {
            this.yInc = this.getTickSpace(this.scaledMinY, this.scaledMaxY, 4.0);
        }
        this.origin.x = this.leftAxisPad - (int)Math.round(this.scaledMinX * this.xScale);
        this.origin.y = this.scaledHeight - this.axisPad + (int)Math.round(this.scaledMinY * this.yScale);
        this.repaint();
    }

    public final Point dataToScreen(double d, double d2) {
        if (this.xScaleType == 1) {
            d = Math.log(d) * INV_LOG_10;
        }
        if (this.yScaleType == 1) {
            d2 = Math.log(d2) * INV_LOG_10;
        }
        return this.scaledDataToScreen(d, d2);
    }

    protected final Point scaledDataToScreen(double d, double d2) {
        return new Point(this.origin.x + (int)Math.round(this.xScale * d), this.origin.y - (int)Math.round(this.yScale * d2));
    }

    public final Point2D.Double screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / this.xScale;
        double d2 = (double)(this.origin.y - point.y) / this.yScale;
        if (this.xScaleType == 1) {
            d = Math.exp(d);
        }
        if (this.yScaleType == 1) {
            d2 = Math.exp(d2);
        }
        return new Point2D.Double(d, d2);
    }

    protected final Point2D.Double screenToDataIgnoreLog(Point point) {
        double d = (double)(point.x - this.origin.x) / this.xScale;
        double d2 = (double)(this.origin.y - point.y) / this.yScale;
        return new Point2D.Double(d, d2);
    }

    protected final void drawAxes(Graphics graphics) {
        Point point;
        double d;
        double d2;
        double d3;
        double d4;
        int n = this.scaledWidth;
        int n2 = this.scaledHeight;
        graphics.setColor(this.getForeground());
        if (this.gridLines || this.xNumbering) {
            d4 = this.scaledMinY;
            d3 = this.getTickStart(this.scaledMinX, this.xInc);
            d2 = this.getTickStop(this.scaledMaxX, this.xInc);
            for (d = d3; d <= d2; d += this.xInc) {
                point = this.scaledDataToScreen(d, d4);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(point.x, this.axisPad - this.scalePad, point.x, n2 - (this.axisPad - this.scalePad));
                    graphics.setColor(this.getForeground());
                }
                if (!this.xNumbering) continue;
                this.drawXLabel(graphics, d, point);
            }
            if (this.xNumbering) {
                this.drawXAxisUnitsLabel(graphics, this.scaledDataToScreen(this.scaledMaxX, d4));
            }
        }
        if (this.gridLines || this.yNumbering) {
            d4 = this.scaledMinX;
            d3 = this.getTickStart(this.scaledMinY, this.yInc);
            d2 = this.getTickStop(this.scaledMaxY, this.yInc);
            for (d = d3; d <= d2; d += this.yInc) {
                point = this.scaledDataToScreen(d4, d);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(this.leftAxisPad - this.scalePad, point.y, n - (this.rightAxisPad - this.scalePad), point.y);
                    graphics.setColor(this.getForeground());
                }
                if (!this.yNumbering) continue;
                this.drawYLabel(graphics, d, point);
            }
            if (this.yNumbering) {
                this.drawYAxisUnitsLabel(graphics, this.scaledDataToScreen(d4, d2));
            }
        }
        if (this.xAxisLine) {
            graphics.drawLine(this.leftAxisPad - this.scalePad, n2 - this.axisPad, n - (this.rightAxisPad - this.scalePad), n2 - this.axisPad);
        }
        if (this.yAxisLine) {
            graphics.drawLine(this.leftAxisPad, this.axisPad - this.scalePad, this.leftAxisPad, n2 - (this.axisPad - this.scalePad));
        }
    }

    protected void drawXLabel(Graphics graphics, double d, Point point) {
        double d2 = this.xScaleType == 1 ? Math.exp(d) : d;
        String string = NumberFormat.doubleString(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x, point.y + 5);
        graphics.drawString(string, point.x - n / 2, point.y + 5 + n2);
    }

    protected void drawXAxisUnitsLabel(Graphics graphics, Point point) {
        String string = this.xAxisUnitsLabel;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth("--");
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x + n, point.y + 5 + n2);
    }

    protected void drawYLabel(Graphics graphics, double d, Point point) {
        double d2 = this.yScaleType == 1 ? Math.exp(d) : d;
        String string = NumberFormat.doubleString(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x - 5, point.y);
        graphics.drawString(string, point.x - 8 - n, point.y + n2 / 3);
    }

    protected void drawTitle(Graphics graphics) {
        String string = this.title;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, this.scaledWidth / 2 - n / 2, n2);
    }

    protected void drawYAxisUnitsLabel(Graphics graphics, Point point) {
        String string = this.yAxisUnitsLabel;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x - 8 - n, point.y - n2);
    }

    protected void drawData(Graphics graphics) {
        int n;
        this.model.firstSeries();
        graphics.setColor(this.seriesColor[0]);
        for (n = 0; n < this.model.seriesLength(); ++n) {
            this.drawDataPoint(graphics, n);
        }
        int n2 = 1;
        while (this.model.nextSeries()) {
            graphics.setColor(this.seriesColor[n2]);
            for (n = 0; n < this.model.seriesLength(); ++n) {
                this.drawDataPoint(graphics, n);
            }
            ++n2;
        }
    }

    protected void drawDataPoint(Graphics graphics, int n) {
        Point point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
        this.dataMarker.paint(graphics, point.x, point.y);
    }

    public void paint(Graphics graphics) {
        int n = graphics.getClipBounds().width;
        int n2 = graphics.getClipBounds().height;
        boolean bl = false;
        try {
            PrintGraphics printGraphics = (PrintGraphics)((Object)graphics);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl || n != this.scaledWidth || n2 != this.scaledHeight) {
            this.rescale(n, n2, graphics.getFontMetrics());
        }
        if (n < 4 * this.axisPad || n2 < 4 * this.axisPad) {
            return;
        }
        if (n < this.getMinimumSize().width || n2 < this.getMinimumSize().height) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.getForeground());
        this.drawTitle(graphics);
        this.drawAxes(graphics);
        graphics.setClip(this.leftAxisPad, this.axisPad, n - (this.leftAxisPad + this.rightAxisPad), n2 - 2 * this.axisPad);
        this.drawData(graphics);
    }

    public double getTickStart(double d, double d2) {
        double d3 = d2 * (double)((int)(d / d2));
        if (d3 < d) {
            d3 += d2;
        }
        return d3;
    }

    public double getTickStop(double d, double d2) {
        double d3 = d2 * (double)(1 + (int)(d / d2));
        if (d3 > d) {
            d3 -= d2;
        }
        return d3;
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = Math.pow(10.0, 1 + (int)(Math.log(d4) * INV_LOG_10));
        int n = 0;
        do {
            if (d5 > d4 / d3) {
                d5 /= 2.0;
            }
            if (d5 > d4 / d3) {
                d5 /= 2.5;
            }
            if (!(d5 > d4 / d3)) continue;
            d5 /= 2.0;
        } while (d5 > d4 / d3 && n++ < 1000);
        return d5;
    }

    public String dataToString(Point2D.Double double_) {
        return "x=" + NumberFormat.doubleString(double_.x) + ", y=" + NumberFormat.doubleString(double_.y);
    }
}

