/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import net.alomax.freq.FilterException;
import net.alomax.freq.FreqText;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.util.PhysicalUnits;

public class FrequencyProcesses
implements FrequencyDomainProcess {
    protected static int ndx = -1;
    public static final int UNDEF = ndx++;
    public static final int DIFFERENTIATE = ndx++;
    public static final int INTEGRATE = ndx++;
    public static final int HILBERT = ndx++;
    public static final int ENVELOPE = ndx++;
    public static final int REMOVE_ATTENUATION = ndx++;
    public int processID = UNDEF;
    protected float[] origSample;
    protected Object[] params = new Object[0];
    static final Cmplx cHalf = new Cmplx(0.5, 0.0);
    static final Cmplx cOne = new Cmplx(1.0, 0.0);
    static final Cmplx cNegOne = new Cmplx(-1.0, 0.0);

    public FrequencyProcesses(int n) {
        this.processID = n;
    }

    public void setParams(Object[] objectArray) {
        this.params = objectArray;
    }

    public float[] preProcess(double d, float[] fArray) {
        if (this.processID == ENVELOPE) {
            this.origSample = new float[fArray.length];
            System.arraycopy(fArray, 0, this.origSample, 0, fArray.length);
            return fArray;
        }
        return fArray;
    }

    public float[] postProcess(double d, float[] fArray) {
        if (this.processID == ENVELOPE) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)Math.sqrt(fArray[i] * fArray[i] + this.origSample[i] * this.origSample[i]);
            }
            return fArray;
        }
        return fArray;
    }

    public boolean sampleChangedInPreProcess() {
        return false;
    }

    public boolean sampleChangedInPostProcess() {
        return this.processID == ENVELOPE;
    }

    public Cmplx[] apply(double d, Cmplx[] cmplxArray) {
        if (this.processID == REMOVE_ATTENUATION) {
            return this.applyRemoveAttenuation(d, cmplxArray);
        }
        return this.applyBasic(d, cmplxArray);
    }

    public Cmplx[] applyBasic(double d, Cmplx[] cmplxArray) {
        int n = cmplxArray.length;
        double d2 = Math.PI * 2 / ((double)n * d);
        Cmplx cmplx = new Cmplx(0.0, 0.0);
        cmplx = new Cmplx(0.0, -1.0);
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            double d3 = d2 * (double)n3;
            if (this.processID == INTEGRATE) {
                cmplx = Cmplx.div(cNegOne, new Cmplx(0.0, d3));
            } else if (this.processID == DIFFERENTIATE) {
                cmplx = new Cmplx(0.0, -d3);
            }
            int n4 = n - 1 - i;
            if (n3 != n2) {
                cmplxArray[n3].mul(cmplx);
                cmplxArray[n4].mul(Cmplx.conjg(cmplx));
                continue;
            }
            cmplxArray[n3].mul(Cmplx.mul(Cmplx.conjg(cmplx), cHalf));
        }
        cmplxArray[0] = new Cmplx(0.0, 0.0);
        return cmplxArray;
    }

    public Cmplx[] applyRemoveAttenuation(double d, Cmplx[] cmplxArray) {
        int n = cmplxArray.length;
        double d2 = Math.PI * 2 / ((double)n * d);
        Cmplx cmplx = new Cmplx(1.0, 0.0);
        double d3 = (Double)this.params[0];
        double d4 = (Double)this.params[1] * (Math.PI * 2);
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            double d5 = d2 * (double)n3;
            cmplx = d5 < d4 ? new Cmplx(Math.exp(d5 * d3 / 2.0), 0.0) : cOne;
            int n4 = n - 1 - i;
            if (n3 != n2) {
                cmplxArray[n3].mul(cmplx);
                cmplxArray[n4].mul(Cmplx.conjg(cmplx));
                continue;
            }
            cmplxArray[n3].mul(Cmplx.mul(Cmplx.conjg(cmplx), cHalf));
        }
        cmplxArray[0] = new Cmplx(0.0, 0.0);
        return cmplxArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        if (this.processID == DIFFERENTIATE) {
            timeSeries.ampUnits = PhysicalUnits.timeDerivative(timeSeries.ampUnits);
        } else if (this.processID == INTEGRATE) {
            timeSeries.ampUnits = PhysicalUnits.timeIntegral(timeSeries.ampUnits);
        }
    }

    public void checkSettings() throws FilterException {
        String string = "";
        int n = 0;
        if (this.processID == UNDEF) {
            string = string + ": " + FreqText.invalid_frequency_process;
            ++n;
        }
        if (n > 0) {
            throw new FilterException(string + ".");
        }
    }
}

