/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import net.alomax.freq.FilterException;
import net.alomax.freq.FreqText;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;

public class Convolve
implements FrequencyDomainProcess {
    public static final int TYPE_CONV = 0;
    public static final int TYPE_DECONV = 1;
    private static final int NUM_TYPES = 2;
    public int type = this.type;
    public static final String CONVOLUTION = "CONVOLUTION";
    public static final String DECONVOLUTION = "DECONVOLUTION";
    TimeSeries[] masterTimeSeries = null;
    protected int masterChannel = -1;
    public Cmplx[][] masterSpectra = null;
    public double waterLevel = -1.0;
    public double taperPercent = 0.0;
    public String errorMessage;

    public Convolve(String string, TimeSeries[] timeSeriesArray) {
        this.masterTimeSeries = timeSeriesArray;
        this.errorMessage = " ";
        FreqText.setLocale(string);
    }

    public void setMasterTimeSeries(TimeSeries[] timeSeriesArray) throws FilterException {
        int n;
        if (timeSeriesArray == null || timeSeriesArray.length < 1) {
            throw new FilterException(FreqText.invalid_convolution_master_spectrum);
        }
        for (n = 0; n < timeSeriesArray.length; ++n) {
            if (timeSeriesArray[n] != null && timeSeriesArray[n].sampleLength() >= 2) continue;
            throw new FilterException(FreqText.invalid_convolution_master_spectrum);
        }
        this.masterTimeSeries = timeSeriesArray;
        this.masterSpectra = new Cmplx[timeSeriesArray.length][];
        for (n = 0; n < timeSeriesArray.length; ++n) {
            this.masterSpectra[n] = null;
        }
    }

    public TimeSeries[] getMasterTimeSeries() {
        return this.masterTimeSeries;
    }

    public void setMasterChannel(int n) throws FilterException {
        if (n < 0 || n >= this.masterTimeSeries.length) {
            throw new FilterException(FreqText.invalid_convolution_master_channel);
        }
        this.masterChannel = n;
    }

    public void setWaterLevel(double d) throws FilterException {
        this.waterLevel = d;
    }

    public double getWaterLevel() {
        return this.waterLevel;
    }

    public void setTaperPercent(double d) throws FilterException {
        if (d < 0.0) {
            throw new FilterException(FreqText.invalid_frequency_taper_values);
        }
        this.taperPercent = d;
    }

    public double getTaperPercent() {
        return this.taperPercent;
    }

    public void setType(String string) throws FilterException {
        if (CONVOLUTION.startsWith(string.toUpperCase())) {
            this.type = 0;
        } else if (DECONVOLUTION.startsWith(string.toUpperCase())) {
            this.type = 1;
        } else {
            throw new FilterException(FreqText.invalid_convolution_type);
        }
    }

    public void setType(int n) throws FilterException {
        if (n < 0 || n >= 2) {
            throw new FilterException(FreqText.invalid_convolution_type);
        }
        this.type = n;
    }

    public String getType() {
        if (this.type == 0) {
            return CONVOLUTION;
        }
        if (this.type == 1) {
            return DECONVOLUTION;
        }
        return null;
    }

    public void checkSettings() throws FilterException {
        String string = "";
        int n = 0;
        if (this.masterSpectra == null || this.masterSpectra.length < 1) {
            string = string + ": " + FreqText.invalid_convolution_master_spectrum;
            ++n;
        }
        if (n > 0) {
            throw new FilterException(string + ".");
        }
    }

    public final Cmplx[] apply(double d, Cmplx[] cmplxArray) {
        int n;
        double d2 = this.masterTimeSeries[this.masterChannel].sampleInt;
        if (Math.abs(d - d2) > d / (double)cmplxArray.length) {
            System.out.println(this.getClass().toString() + ": ERROR: target and master dt do not match: " + "dt target=" + d + ", dt master=" + d2);
            return cmplxArray;
        }
        Cmplx[] cmplxArray2 = this.masterSpectra[this.masterChannel];
        if (cmplxArray2 == null) {
            n = cmplxArray.length - this.masterTimeSeries[this.masterChannel].sampleLength();
            if (n >= 0) {
                cmplxArray2 = this.masterTimeSeries[this.masterChannel].getFFT(this.taperPercent, n);
            } else {
                System.out.println(this.getClass().toString() + ": ERROR: target length less than master length: " + "length target=" + cmplxArray.length);
                return cmplxArray;
            }
        }
        if (cmplxArray2.length != cmplxArray.length) {
            System.out.println(this.getClass().toString() + ": ERROR: target and master length do not match: " + "length target=" + cmplxArray.length + ", length master=" + cmplxArray2.length);
            return cmplxArray;
        }
        int n2 = cmplxArray.length;
        int n3 = n2 / 2;
        int n4 = cmplxArray2.length;
        int n5 = n4 / 2;
        int n6 = n2 < n4 ? n2 : n4;
        int n7 = n2 > n4 ? n2 : n4;
        Cmplx cmplx = new Cmplx(0.0, 0.0);
        if (this.type == 0) {
            for (int i = 0; i < n6 / 2; ++i) {
                n = n3 + i;
                int n8 = n3 - 1 - i;
                int n9 = n5 + i;
                int n10 = n5 - 1 - i;
                cmplxArray[n].mul(cmplxArray2[n9]);
                cmplxArray[n8].mul(cmplxArray2[n10]);
            }
        } else {
            boolean bl = false;
            double d3 = -1.0;
            double d4 = -1.0;
            double d5 = -1.0;
            if (this.waterLevel >= 0.0) {
                bl = true;
                d4 = Math.pow(10.0, this.waterLevel / 20.0);
                for (int i = 1; i < cmplxArray2.length; ++i) {
                    double d6 = cmplxArray2[i].mag();
                    d3 = d3 > d6 ? d3 : d6;
                }
            }
            for (int i = 0; i < n6 / 2; ++i) {
                n = n3 + i;
                int n11 = n3 - 1 - i;
                int n12 = n5 + i;
                int n13 = n5 - 1 - i;
                if (bl) {
                    double d7;
                    double d8;
                    d5 = d3 / cmplxArray2[n12].mag();
                    if (d8 > d4) {
                        cmplxArray[n].div(Cmplx.mul(cmplxArray2[n12], d5 / d4));
                    } else {
                        cmplxArray[n].div(cmplxArray2[n12]);
                    }
                    d5 = d3 / cmplxArray2[n13].mag();
                    if (d7 > d4) {
                        cmplxArray[n11].div(Cmplx.mul(cmplxArray2[n13], d5 / d4));
                        continue;
                    }
                    cmplxArray[n11].div(cmplxArray2[n13]);
                    continue;
                }
                cmplxArray[n].div(cmplxArray2[n12]);
                cmplxArray[n11].div(cmplxArray2[n13]);
            }
        }
        return cmplxArray;
    }

    public float[] preProcess(double d, float[] fArray) {
        return fArray;
    }

    public float[] postProcess(double d, float[] fArray) {
        return fArray;
    }

    public boolean sampleChangedInPreProcess() {
        return false;
    }

    public boolean sampleChangedInPostProcess() {
        return false;
    }

    public void updateFields(TimeSeries timeSeries) {
    }
}

