/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Pierce
extends TauP_Time {
    protected boolean onlyTurnPoints = false;
    protected boolean onlyRevPoints = false;
    protected boolean onlyUnderPoints = false;
    protected boolean onlyAddPoints = false;
    protected double[] addDepth = new double[0];

    protected TauP_Pierce() {
    }

    public TauP_Pierce(TauModel tauModel) throws TauModelException {
        super(tauModel);
    }

    public TauP_Pierce(String string) throws TauModelException {
        super(string);
    }

    public void setOnlyTurnPoints(boolean bl) {
        this.onlyTurnPoints = bl;
    }

    public void setOnlyRevPoints(boolean bl) {
        this.onlyRevPoints = bl;
    }

    public void setOnlyUnderPoints(boolean bl) {
        this.onlyUnderPoints = bl;
    }

    public void setOnlyAddPoints(boolean bl) {
        this.onlyAddPoints = bl;
    }

    public void setAddDepths(String string) {
        this.addDepth = this.parseAddDepthsList(string);
    }

    public void appendAddDepths(String string) {
        double[] dArray = this.parseAddDepthsList(string);
        double[] dArray2 = new double[this.addDepth.length + dArray.length];
        System.arraycopy(this.addDepth, 0, dArray2, 0, this.addDepth.length);
        System.arraycopy(dArray, 0, dArray2, this.addDepth.length, dArray.length);
        this.addDepth = dArray2;
    }

    protected double[] parseAddDepthsList(String string) {
        int n = 0;
        int n2 = 0;
        string = string.replace(' ', ',');
        int n3 = string.indexOf(",,", n);
        while (n3 != -1) {
            string = string.substring(0, n3) + string.substring(n3 + 1);
            n3 = string.indexOf(",,", n);
        }
        if (string.charAt(0) == ',') {
            if (string.length() > 1) {
                string = string.substring(1);
            } else {
                return new double[0];
            }
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        double[] dArray = new double[string.length()];
        while (n < string.length()) {
            String string2;
            n3 = string.indexOf(44, n);
            if (n3 != -1) {
                string2 = string.substring(n, n3);
                dArray[n2] = Double.valueOf(string2);
                n = n3 + 1;
                ++n2;
                continue;
            }
            string2 = string.substring(n);
            dArray[n2] = Double.valueOf(string2);
            n = string.length();
            ++n2;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        dArray = dArray2;
        return dArray;
    }

    public void depthCorrect(double d) throws TauModelException {
        TauModel tauModel = (TauModel)this.tMod.clone();
        TauModel tauModel2 = this.tModDepth;
        boolean bl = false;
        if (this.tModDepth.sourceDepth == d) {
            if (this.addDepth != null) {
                double[] dArray = this.tModDepth.getBranchDepths();
                for (int i = 0; i < this.addDepth.length; ++i) {
                    for (int j = 0; j < dArray.length && this.addDepth[i] != dArray[j]; ++j) {
                        bl = true;
                    }
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            super.depthCorrect(d);
            return;
        }
        this.tModDepth = null;
        try {
            if (this.addDepth != null) {
                for (int i = 0; i < this.addDepth.length; ++i) {
                    this.tMod = this.tMod.splitBranch(this.addDepth[i]);
                }
            }
        }
        catch (TauModelException tauModelException) {
            System.err.println("depthCorrect: caught TauModelException: " + tauModelException.getMessage() + "\nSkipping added depth" + " pierce points.");
            this.tMod = tauModel;
            this.tMod = tauModel2;
        }
        super.depthCorrect(d);
        this.tMod = tauModel;
    }

    public void calculate(double d) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPierce(d);
    }

    protected void calcPierce(double d) {
        this.degrees = d;
        for (int i = 0; i < this.phases.size(); ++i) {
            SeismicPhase seismicPhase = (SeismicPhase)this.phases.elementAt(i);
            try {
                seismicPhase.setDEBUG(this.DEBUG);
                seismicPhase.calcTime(d);
                if (!seismicPhase.hasArrivals()) continue;
                seismicPhase.calcPierce(this.tModDepth);
                Arrival[] arrivalArray = seismicPhase.getArrivals();
                for (int j = 0; j < arrivalArray.length; ++j) {
                    this.arrivals.addElement(arrivalArray[j]);
                }
                continue;
            }
            catch (TauModelException tauModelException) {
                System.err.println("Caught TauModelException: " + tauModelException.getMessage());
                System.err.println("Skipping phase " + seismicPhase.getName());
            }
        }
    }

    public void printResult(Writer writer) throws IOException {
        boolean bl = false;
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival arrival = (Arrival)this.arrivals.elementAt(i);
            writer.write("> " + arrival.name + " at " + this.outForms.formatTime(arrival.time) + " seconds at " + this.outForms.formatDistance(arrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(arrival.sourceDepth) + " km deep source in the " + this.modelName + " model.\n");
            bl = false;
            if (arrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                bl = true;
            }
            double d = arrival.pierce[0].depth;
            for (int j = 0; j < arrival.pierce.length; ++j) {
                double d2 = arrival.pierce[j].time;
                double d3 = arrival.pierce[j].dist * 180.0 / Math.PI;
                if (bl && d3 != 0.0) {
                    d3 *= -1.0;
                }
                double d4 = j < arrival.pierce.length - 1 ? arrival.pierce[j + 1].depth : arrival.pierce[j].depth;
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyAddPoints && this.isAddDepth(arrival.pierce[j].depth) || this.onlyRevPoints && (d - arrival.pierce[j].depth) * (arrival.pierce[j].depth - d4) < 0.0 || this.onlyTurnPoints && j != 0 && d - arrival.pierce[j].depth <= 0.0 && arrival.pierce[j].depth - d4 >= 0.0 || this.onlyUnderPoints && d - arrival.pierce[j].depth >= 0.0 && arrival.pierce[j].depth - d4 <= 0.0) {
                    double d5;
                    double d6;
                    writer.write(this.outForms.formatDistance(d3));
                    writer.write(this.outForms.formatDepth(arrival.pierce[j].depth));
                    if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
                        d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        d5 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
                        d6 = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - d3, this.backAzimuth);
                        d5 = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - d3, this.backAzimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
                        this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                        this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                        d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        d5 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d3, this.azimuth);
                        writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d5));
                    }
                    writer.write("\n");
                }
                d = arrival.pierce[j].depth;
            }
        }
    }

    public synchronized boolean isAddDepth(double d) {
        for (int i = 0; i < this.addDepth.length; ++i) {
            if (d != this.addDepth[i]) continue;
            return true;
        }
        return false;
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-az azimuth        -- sets the azimuth (event to station)\n                      used to output lat and lon of pierce points\n                      if the event lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.");
        System.out.println("-baz backazimuth   -- sets the back azimuth (station to event)\n                      used to output lat and lon of pierce points\n                      if the station lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.\n");
        System.out.println("-rev               -- only prints underside and bottom turn points, e.g. ^ and v");
        System.out.println("-turn              -- only prints bottom turning points, e.g. v");
        System.out.println("-under             -- only prints underside reflection points, e.g. ^\n");
        System.out.println("-pierce depth      -- adds depth for calculating pierce points");
        System.out.println("-nodiscon          -- only prints pierce points for the depths added with -pierce\n");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equalsIgnoreCase("-turn")) {
                this.onlyTurnPoints = true;
                continue;
            }
            if (stringArray2[i].equalsIgnoreCase("-rev")) {
                this.onlyRevPoints = true;
                continue;
            }
            if (stringArray2[i].equalsIgnoreCase("-under")) {
                this.onlyUnderPoints = true;
                continue;
            }
            if (stringArray2[i].equalsIgnoreCase("-pierce") && i < stringArray2.length - 1) {
                this.appendAddDepths(stringArray2[i + 1]);
                ++i;
                continue;
            }
            if (stringArray2[i].equalsIgnoreCase("-nodiscon")) {
                this.onlyAddPoints = true;
                continue;
            }
            stringArray3[n++] = stringArray2[i].equals("-help") ? stringArray2[i] : stringArray2[i];
        }
        if (n > 0) {
            String[] stringArray4 = new String[n];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n);
            return stringArray4;
        }
        return new String[0];
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Pierce tauP_Pierce = new TauP_Pierce();
            String[] stringArray2 = tauP_Pierce.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                int n;
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!stringArray2[n].equals("-help") && !stringArray2[n].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (n = 0; n < stringArray2.length; ++n) {
                    System.out.print(stringArray2[n] + " ");
                    if (!stringArray2[n].equals("-help") && !stringArray2[n].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                stringArray2 = null;
            }
            if (tauP_Pierce.DEBUG) {
                System.out.println("Done reading " + tauP_Pierce.modelName);
            }
            tauP_Pierce.init();
            tauP_Pierce.start();
            tauP_Pierce.destroy();
        }
        catch (TauModelException tauModelException) {
            System.out.println("Caught TauModelException: " + tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
        catch (TauPException tauPException) {
            System.out.println("Caught TauPException: " + tauPException.getMessage());
            tauPException.printStackTrace();
        }
    }
}

