/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.director.ReadBuffer;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class ImportDirector {
    protected boolean streamOpen = false;
    protected DataInputStream inStream = null;
    protected ReadBuffer readBuffer = null;
    protected byte[] record;
    protected int recCount = 0;
    protected int recLen = 0;
    protected int recordOffset = 0;
    protected ObjectBuilder builder = null;
    protected String outputString = null;
    protected int fixedRecordLength = 0;
    public int maxRecordLength = 32768;
    private PrintWriter printOutStream = null;

    public ImportDirector() {
    }

    public ImportDirector(ObjectBuilder objectBuilder) {
        this.assignBuilder(objectBuilder);
    }

    public abstract int getRecLen() throws Exception;

    public void assignBuilder(ObjectBuilder objectBuilder) {
        this.builder = objectBuilder;
    }

    public ObjectBuilder getBuilder() {
        return this.builder;
    }

    public void setRecLen(int n) {
        this.fixedRecordLength = n;
    }

    public int construct(InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
        if (this.builder == null) {
            throw new BuilderException("a builder has not been assigned to this director");
        }
        this.printOutStream = null;
        this.open(inputStream);
        if (outputStream != null) {
            this.printOutStream = new PrintWriter(outputStream, true);
        }
        while (this.read(bl)) {
            if (this.printOutStream == null || this.outputString == null) continue;
            this.printOutStream.print(this.outputString);
        }
        if (this.printOutStream != null) {
            this.printOutStream.close();
        }
        this.close();
        return this.recCount;
    }

    public int construct(InputStream inputStream) throws Exception {
        return this.construct(inputStream, null, true);
    }

    public void open(InputStream inputStream) throws Exception {
        this.inStream = new DataInputStream(inputStream);
        this.readBuffer = new ReadBuffer(this.maxRecordLength * 2);
        this.streamOpen = true;
        this.recCount = 0;
        this.incrementVolume();
    }

    public void close() {
        this.inStream = null;
        this.streamOpen = false;
    }

    public boolean read(boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("");
        this.outputString = null;
        if (this.streamOpen) {
            if (this.getRecord()) {
                while (this.recordOffset < this.recLen) {
                    String string;
                    int n = this.build();
                    if (n == 0) {
                        throw new BuilderException("call to builder resulted in 0 bytes being processed");
                    }
                    if (this.printOutStream != null && (string = this.builder.toString()).length() > 0) {
                        stringBuffer.append(string + "\n");
                    }
                    if (bl) {
                        this.builder.store();
                    }
                    this.recordOffset += n;
                }
                if (stringBuffer.length() > 0) {
                    this.outputString = stringBuffer.toString();
                }
                return true;
            }
            return false;
        }
        throw new SeedInputException("read called while input stream not open");
    }

    public boolean read() throws Exception {
        return this.read(true);
    }

    public abstract int build() throws Exception;

    private boolean getRecord() throws Exception {
        if (!this.readBuffer.reachedEOF()) {
            this.readBuffer.fill(this.inStream);
        }
        if (this.readBuffer.length() <= 0) {
            return false;
        }
        this.recLen = this.getRecLen();
        this.record = new byte[this.recLen];
        System.arraycopy(this.readBuffer.buffer, 0, this.record, 0, this.recLen);
        this.readBuffer.shift(this.recLen);
        ++this.recCount;
        this.recordOffset = 0;
        return true;
    }

    private void incrementVolume() throws Exception {
        this.builder.incrementVolume();
    }
}

