/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.container.ObjectContainer;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.util.Vector;

public abstract class ObjectBuilder {
    protected String builderType = "UNKNOWN";
    protected ObjectContainer buildContainer = null;
    protected Object currentObject = null;
    protected Vector buildFilterVector = new Vector(8, 8);
    protected char recordType = (char)32;
    protected boolean continuationFlag = false;
    protected boolean recordBeginFlag = false;
    protected int volumeNumber = 0;

    public void registerFilter(BuilderFilter builderFilter) throws BuilderException {
        if (!builderFilter.getType().equals(this.builderType)) {
            throw new BuilderException("attempted to assign filter type " + builderFilter.getType() + "to this builder of type " + this.builderType);
        }
        this.buildFilterVector.add(builderFilter);
    }

    public String getType() throws BuilderException {
        if (this.builderType.equals("UNKNOWN")) {
            throw new BuilderException("builder type is UNKNOWN");
        }
        return this.builderType;
    }

    public Object getObject() {
        return this.currentObject;
    }

    public ObjectContainer getContainer() throws BuilderException {
        if (this.buildContainer == null) {
            throw new BuilderException("unable to locate object container");
        }
        return this.buildContainer;
    }

    public String toString() {
        Object object = null;
        object = this.getObject();
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void setRecordType(byte by) {
        this.recordType = (char)by;
    }

    public void setContinuationFlag(boolean bl) {
        this.continuationFlag = bl;
    }

    public void setRecordBeginFlag(boolean bl) {
        this.recordBeginFlag = bl;
    }

    public void removeCurrent() {
        this.currentObject = null;
    }

    public void incrementVolume() {
        ++this.volumeNumber;
        this.reset();
    }

    public abstract int build(byte[] var1) throws Exception;

    public abstract int build(String var1) throws Exception;

    public abstract int store() throws Exception;

    public abstract void reset();
}

