
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class LocationUsage(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getLocationUsages(self,responseFields = None):
		""" Retrieves the configured site location usages for the location usage code specified in the request.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationUsageCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/locationUsages/?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getLocationUsage(self,code, responseFields = None):
		""" Retrieves the location usages for the site specified in the request header.
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationUsage 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/locationUsages/{code}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateLocationUsage(self,usage, code, responseFields = None):
		""" Updates the location usage for the site based on the location usage code specified in the request.
		
		Args:
			| usage(usage) - Configuration properties of a location usage type for a specified site. The direct ship location usage type consists of a single location that represents location that supports direct ship (DS) fulfillment. The in-store pickup location usage type consists of a list of location types that represent locations that support in-store pickup (SP) fulfillment. The store finder location usage type consists of a list of location codes, location types, or both.
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationUsage 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/locationUsages/{code}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(usage).execute();
		return self.client.result();

	
	
	