
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Payment(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getPayments(self,orderId, responseFields = None):
		""" Retrieves information about all payment transactions submitted for the specified order.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| PaymentCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/payments/?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAvailablePaymentActions(self,orderId, paymentId):
		""" Retrieves the list of all available payment actions dependent on the order payment status by specifying the order ID.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| paymentId (string) - Unique identifier of the payment for which to perform the action.
		
		Returns:
			| array of string 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/payments/{paymentId}/actions", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("paymentId", paymentId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPayment(self,orderId, paymentId, responseFields = None):
		""" Retrieves information about a specific payment transaction submitted for the specified order.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| paymentId (string) - Unique identifier of the payment for which to perform the action.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Payment 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/payments/{paymentId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("paymentId", paymentId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def performPaymentAction(self,action, orderId, paymentId, responseFields = None):
		""" Performs the specified action for an individual order payment transaction.
		
		Args:
			| action(action) - Properties of the payment action performed for an order.
			| orderId (string) - Unique identifier of the order.
			| paymentId (string) - Unique identifier of the payment for which to perform the action.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/payments/{paymentId}/actions?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("paymentId", paymentId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(action).execute();
		return self.client.result();

	
		
	def createPaymentAction(self,action, orderId, responseFields = None):
		""" Creates a new payment transaction for the specified order and performs the specified action.
		
		Args:
			| action(action) - Properties of the payment action performed for an order.
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/payments/actions?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(action).execute();
		return self.client.result();

	
	
	