
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Facet(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getFacet(self,facetId, validate = False, responseFields = None):
		""" Retrieves a facet specified by its unique identifier and displays its properties.
		
		Args:
			| facetId (int) - Unique identifier of the facet to retrieve.
			| validate (bool) - Validates that the product category associated with a facet is active. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Facet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/facets/{facetId}?validate={validate}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("facetId", facetId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("validate", validate);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getFacetCategoryList(self,categoryId, includeAvailable = False, validate = False, responseFields = None):
		""" Retrieves a list of the facets defined for the specified category.
		
		Args:
			| categoryId (int) - Unique identifier of the category to modify.
			| includeAvailable (bool) - If true, returns a list of the attributes and categories associated with a product type that have not been defined as a facet for the category.
			| validate (bool) - Validates that the product category associated with a facet is active. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| FacetSet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/facets/category/{categoryId}?includeAvailable={includeAvailable}&validate={validate}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("categoryId", categoryId);
		url.formatUrl("includeAvailable", includeAvailable);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("validate", validate);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addFacet(self,facet, responseFields = None):
		""" Creates a new category, price, or attribute facet. Define the category or attribute source to use for the facet values.
		
		Args:
			| facet(facet) - Properties of the facet used to retrieve documents.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Facet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/facets/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(facet).execute();
		return self.client.result();

	
		
	def updateFacet(self,facet, facetId, responseFields = None):
		""" Modifies one or more properties of a defined facet.
		
		Args:
			| facet(facet) - Properties of the facet used to retrieve documents.
			| facetId (int) - Unique identifier of the facet to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Facet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/facets/{facetId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("facetId", facetId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(facet).execute();
		return self.client.result();

	
		
	def deleteFacetById(self,facetId):
		""" Deletes the facet specified by its unique identifier.
		
		Args:
			| facetId (int) - Unique identifier of the facet to retrieve.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/facets/{facetId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("facetId", facetId);
		self.client.withResourceUrl(url).execute();

	
	
	