
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Attribute(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getAttributes(self,startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a paged list of attributes according to any specified filter criteria and sort options.
		
		Args:
			| startIndex (int) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - 
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAttribute(self,attributeFQN, responseFields = None):
		""" Retrieves the details of the specified product attribute.
		
		Args:
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Attribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addAttribute(self,attribute, responseFields = None):
		""" Creates a new attribute to describe one aspect of a product such as color or size, based on its defined product type. The attribute name, attribute type, input type, and data type are required.
		
		Args:
			| attribute(attribute) - Properties of an attribute used to describe customers or orders.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Attribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(attribute).execute();
		return self.client.result();

	
		
	def updateAttribute(self,attribute, attributeFQN, responseFields = None):
		""" Updates an existing attribute with attribute properties to set.
		
		Args:
			| attribute(attribute) - Properties of an attribute used to describe customers or orders.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Attribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(attribute).execute();
		return self.client.result();

	
		
	def deleteAttribute(self,attributeFQN):
		""" Deletes a defined product attribute. You cannot delete an attribute assigned a value for a product.
		
		Args:
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		self.client.withResourceUrl(url).execute();

	
	
	