
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ExtendedProperty(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getExtendedProperties(self,):
		""" carts-cartextendedproperties Get GetExtendedProperties description DOCUMENT_HERE 
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties", "GET", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addExtendedProperties(self,extendedProperties):
		""" carts-cartextendedproperties Post AddExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| extendedProperties(array|extendedProperties) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties", "POST", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).withBody(extendedProperties).execute();
		return self.client.result();

	
		
	def updateExtendedProperty(self,extendedProperty, key, upsert = False, responseFields = None):
		""" carts-cartextendedproperties Put UpdateExtendedProperty description DOCUMENT_HERE 
		
		Args:
			| extendedProperty(extendedProperty) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
			| key (string) - 
			| upsert (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties/{key}?upsert={upsert}&responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("key", key);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("upsert", upsert);
		self.client.withResourceUrl(url).withBody(extendedProperty).execute();
		return self.client.result();

	
		
	def updateExtendedProperties(self,extendedProperties, upsert = False):
		""" carts-cartextendedproperties Put UpdateExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| extendedProperties(array|extendedProperties) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
			| upsert (bool) - 
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties?upsert={upsert}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("upsert", upsert);
		self.client.withResourceUrl(url).withBody(extendedProperties).execute();
		return self.client.result();

	
		
	def deleteExtendedProperties(self,keys):
		""" carts-cartextendedproperties Delete DeleteExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| keys(array|keys) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties", "DELETE", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).withBody(keys).execute();

	
		
	def deleteExtendedProperty(self,key):
		""" carts-cartextendedproperties Delete DeleteExtendedProperty description DOCUMENT_HERE 
		
		Args:
			| key (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/extendedproperties/{key}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("key", key);
		self.client.withResourceUrl(url).execute();

	
	
	