# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Possible
     values include: 'InProgress', 'Failed', 'Succeeded', 'TimedOut', 'Created'
    :vartype migration_operation_status: str or :class:`OperationStatus
     <azure.mgmt.web.models.OperationStatus>`
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'OperationStatus'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(self, kind=None):
        super(MigrateMySqlStatus, self).__init__(kind=kind)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None
