# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: <code>true</code> if hostname is
     already verified; otherwise, <code>false</code>.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result.
     Possible values include: 'Passed', 'Failed', 'Skipped'
    :vartype custom_domain_verification_test: str or
     :class:`DnsVerificationTestResult
     <azure.mgmt.web.models.DnsVerificationTestResult>`
    :ivar custom_domain_verification_failure_info: Raw failure information if
     DNS verification fails.
    :vartype custom_domain_verification_failure_info: :class:`ErrorEntity
     <azure.mgmt.web.models.ErrorEntity>`
    :ivar has_conflict_on_scale_unit: <code>true</code> if there is a conflict
     on a scale unit; otherwise, <code>false</code>.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: <code>true</code> if htere is a
     conflict across subscriptions; otherwise, <code>false</code>.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale
     unit if it's within the same subscription.
    :vartype conflicting_app_resource_id: str
    :param c_name_records: CName records controller can see for this hostname.
    :type c_name_records: list of str
    :param txt_records: TXT records controller can see for this hostname.
    :type txt_records: list of str
    :param a_records: A records controller can see for this hostname.
    :type a_records: list of str
    :param alternate_cname_records: Alternate CName records controller can see
     for this hostname.
    :type alternate_cname_records: list of str
    :param alternate_txt_records: Alternate TXT records controller can see for
     this hostname.
    :type alternate_txt_records: list of str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'DnsVerificationTestResult'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_cname_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(self, kind=None, c_name_records=None, txt_records=None, a_records=None, alternate_cname_records=None, alternate_txt_records=None):
        super(CustomHostnameAnalysisResult, self).__init__(kind=kind)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_cname_records = alternate_cname_records
        self.alternate_txt_records = alternate_txt_records
