#!/usr/bin/python3

;----------------------------------------
; print multiple statements on new lines
;----------------------------------------

(defmacro println [&rest args]
  `(do
    (setv args (list ~args))
    (for [line args]
      (print line))))

;----------------------------------------------
; render html for the Jupyter Notebook document
; this is not mandatory for HyML other macros
; this is just for the html render in NB
;----------------------------------------------

(try 
  (do
    (import IPython)
    (if (in 'display (.__dir__ IPython))
        (do
          (defmacro ml> [&rest code]
            `(IPython.display.HTML (ml ~@code)))

          (defmacro xml> [&rest code]
            `(IPython.display.HTML (xml ~@code)))

          (defmacro xhtml> [&rest code]
            `(IPython.display.HTML (xhtml ~@code)))

          (defmacro xhtml5> [&rest code]
            `(IPython.display.HTML (xhtml5 ~@code)))

          (defmacro html4> [&rest code]
            `(IPython.display.HTML (html4 ~@code)))

          (defmacro html5> [&rest code]
            `(IPython.display.HTML (html5 ~@code))))))
  (except (e Exception)))

;----------------------------------------------------
; Indent xml code
; Works only with well defined root node xml content!
;----------------------------------------------------

(import xml.dom.minidom)

(setv dom xml.dom.minidom)

(defn indent [xmldoc]
  (try
    (do
      (setv pretty-lines (-> xmldoc dom.parseString .toprettyxml .splitlines))
      (try
      	(do
      	  (setv pretty-lines (.join "\n" (drop 1 pretty-lines)))
        ; if original code had xml start definitions, then we use it, else
        ; strip xml start tag generated by minidom
	      (if (= (.index xmldoc "<?xml") 0)
	          (+ (.join "" (take (+ (.index xmldoc "?>") 2) xmldoc)) "\n" pretty-lines)
	      	  pretty-lines))
	    (except (e Exception) pretty-lines)))
     (except (e Exception) e)))

;-----------------------------------------------------------------------
; List comprehension
; Use ordinary list and expression (list-comp expr args) arguments order
; vice versa: (list-comp* args expr). This serves as a kind of for each
; loop where list items and variables are introdused first, and then
; expression to handle each of items.
;-----------------------------------------------------------------------
(defmacro list-comp* [args expr]
  `(list-comp ~expr ~args))
