<%inherit file="/layouts/main.mako"/>
<%!
    import datetime
    import urllib
    import ntpath

    import sickrage
    from core.updaters import tz_updater
    from core.searchers import subtitle_searcher
    from core.common import SKIPPED, WANTED, UNAIRED, ARCHIVED, IGNORED, FAILED, DOWNLOADED
    from core.common import Quality, qualityPresets, statusStrings, Overview
    from core.helpers import anon_url, srdatetime, pretty_filesize, get_size
    from core.media.util import showImage


%>
<%block name="scripts">
    <script type="text/javascript" src="${srRoot}/js/lib/jquery.bookmarkscroll.js?${srPID}"></script>
    <script type="text/javascript" src="${srRoot}/js/new/displayShow.js"></script>
    <script type="text/javascript" src="${srRoot}/js/plotTooltip.js?${srPID}"></script>
    <script type="text/javascript" src="${srRoot}/js/sceneExceptionsTooltip.js?${srPID}"></script>
    <script type="text/javascript" src="${srRoot}/js/ratingTooltip.js?${srPID}"></script>
    <script type="text/javascript" src="${srRoot}/js/ajaxEpSearch.js?${srPID}"></script>
    <script type="text/javascript" src="${srRoot}/js/ajaxEpSubtitles.js?${srPID}"></script>
</%block>
<%block name="content">
    <%namespace file="/inc_defs.mako" import="renderQualityPill"/>
    <input type="hidden" id="srRoot" value="${srRoot}"/>
    <div class="pull-left form-inline">
        Change Show:
        <div class="navShow"><img id="prevShow" src="${srRoot}/images/prev.png" alt="&lt;&lt;" title="Prev Show"/></div>
        <select id="pickShow" class="form-control form-control-inline input-sm">
            % for curShowList in sortedShowLists:
                <% curShowType = curShowList[0] %>
                <% curShowList = curShowList[1] %>

                % if len(sortedShowLists) > 1:
                    <optgroup label="${curShowType}">
                % endif
                % for curShow in curShowList:
                    <option value="${curShow.indexerid}" ${('', 'selected="selected"')[curShow == show]}>${curShow.name}</option>
                % endfor
                % if len(sortedShowLists) > 1:
                    </optgroup>
                % endif
            % endfor
        </select>
        <div class="navShow"><img id="nextShow" src="${srRoot}/images/next.png" alt="&gt;&gt;" title="Next Show"/></div>
    </div>

    <div class="clearfix"></div>

    <div id="showtitle" data-showname="${show.name}">
        <h1 class="title" id="scene_exception_${show.indexerid}">${show.name}</h1>
    </div>

    % if seasonResults:
        ##There is a special/season_0?##
        % if int(seasonResults[-1][b"season"]) == 0:
                    <% season_special = 1 %>
        % else:
                    <% season_special = 0 %>
        % endif
        % if not sickrage.srConfig.DISPLAY_SHOW_SPECIALS and season_special:
            <% lastSeason = seasonResults.pop(-1) %>
        % endif
        <span class="h2footer displayspecials pull-right">
            % if season_special:
                Display Specials:
                <a class="inner"
                   href="${srRoot}/toggleDisplayShowSpecials/?show=${show.indexerid}">${('Show', 'Hide')[bool(sickrage.srConfig.DISPLAY_SHOW_SPECIALS)]}</a>
            % endif
        </span>

        <div class="h2footer pull-right">
            <span>
                % if (len(seasonResults) > 14):
                    <select id="seasonJump" class="form-control input-sm" style="position: relative; top: -4px;">
                        <option value="jump">Jump to Season</option>
                        % for seasonNum in seasonResults:
                            <option value="#season-${seasonNum[b"season"]}"
                                    data-season="${seasonNum[b"season"]}">${('Specials', 'Season ' + str(seasonNum[b"season"]))[int(seasonNum[b"season"]) > 0]}</option>
                        % endfor
                    </select>
                % else:
                    Season:
                % for seasonNum in seasonResults:
                    % if int(seasonNum[b"season"]) == 0:
                        <a href="#season-${seasonNum[b"season"]}">Specials</a>
                    % else:
                        <a href="#season-${seasonNum[b"season"]}">${str(seasonNum[b"season"])}</a>
                    % endif
                    % if seasonNum != seasonResults[-1]:
                        <span class="separator">|</span>
                    % endif
                % endfor
                % endif
            </span>

        </div>
    % endif


    <div class="clearfix"></div>

    % if show_message:
        <div class="alert alert-info">
            ${show_message}
        </div>
    % endif

    <div id="container">
        <div id="posterCol">
            <a href="${srRoot}${showImage(show.indexerid, 'poster')}" rel="dialog" title="View Poster for ${show.name}"><img
                    src="${srRoot}${showImage(show.indexerid, 'poster_thumb')}" class="tvshowImg" alt=""/></a>
        </div>

        <div id="showCol">

            <div id="showinfo">
                % if 'rating' in show.imdb_info:
                <% rating_tip = str(show.imdb_info[b'rating']) + " / 10" + " Stars" + "<br />" + str(show.imdb_info[b'votes']) + " Votes" %>
                    <span class="imdbstars" qtip-content="${rating_tip}">${show.imdb_info[b'rating']}</span>
                % endif

                <% _show = show %>
                % if not show.imdbid:
                    <span>(${show.startyear}) - ${show.runtime} minutes - </span>
                % else:
                % if 'country_codes' in show.imdb_info:
                    % for country in show.imdb_info[b'country_codes'].split('|'):
                        <img src="${srRoot}/images/blank.png" class="country-flag flag-${country}" width="16"
                             height="11" style="margin-left: 3px; vertical-align:middle;"/>
                    % endfor
                % endif
                % if 'year' in show.imdb_info:
                    <span>(${show.imdb_info[b'year']}) - ${show.imdb_info[b'runtimes']} minutes - </span>
                % endif
                    <a href="${anon_url('http://www.imdb.com/title/', _show.imdbid)}" rel="noreferrer"
                       onclick="window.open(this.href, '_blank'); return false;"
                       title="http://www.imdb.com/title/${show.imdbid}"><img alt="[imdb]" height="16" width="16"
                                                                             src="${srRoot}/images/imdb.png"
                                                                             style="margin-top: -1px; vertical-align:middle;"/></a>
                % endif
                <a href="${anon_url(sickrage.srCore.INDEXER_API(_show.indexer).config[b'show_url'], _show.indexerid)}"
                   onclick="window.open(this.href, '_blank'); return false;"
                   title="${sickrage.srCore.INDEXER_API(show.indexer).config[b"show_url"] + str(show.indexerid)}"><img
                        alt="${sickrage.srCore.INDEXER_API(show.indexer).name}" height="16" width="16"
                        src="${srRoot}/images/${sickrage.srCore.INDEXER_API(show.indexer).config[b"icon"]}"
                        style="margin-top: -1px; vertical-align:middle;"/></a>
                % if xem_numbering or xem_absolute_numbering:
                    <a href="${anon_url('http://thexem.de/search?q=', _show.name)}" rel="noreferrer"
                       onclick="window.open(this.href, '_blank'); return false;"
                       title="http://thexem.de/search?q-${show.name}"><img alt="[xem]" height="16" width="16"
                                                                           src="${srRoot}/images/xem.png"
                                                                           style="margin-top: -1px; vertical-align:middle;"/></a>
                % endif
            </div>

            <div id="tags">
                <ul class="tags">
                    % if not show.imdbid and show.genre:
                        % for genre in show.genre[1:-1].split('|'):
                            <a href="${anon_url('http://trakt.tv/shows/popular/?genres=', genre.lower())}"
                               target="_blank" title="View other popular ${genre} shows on trakt.tv.">
                                <li>${genre}</li>
                            </a>
                        % endfor
                    % endif
                    % if 'year' in show.imdb_info:
                        % for imdbgenre in show.imdb_info[b'genres'].replace('Sci-Fi','Science-Fiction').split('|'):
                            <a href="${anon_url('http://trakt.tv/shows/popular/?genres=', imdbgenre.lower())}"
                               target="_blank" title="View other popular ${imdbgenre} shows on trakt.tv.">
                                <li>${imdbgenre}</li>
                            </a>
                        % endfor
                    % endif
                </ul>
            </div>

            <div id="summary">
                <table class="summaryTable pull-left">
                    <% anyQualities, bestQualities = Quality.splitQuality(int(show.quality)) %>
                <tr>
                    <td class="showLegend">Quality:</td>
                <td>
                    % if show.quality in qualityPresets:
                        ${renderQualityPill(show.quality)}
                    % else:
                        % if anyQualities:
                            <i>Allowed:</i> ${", ".join([capture(renderQualityPill, x) for x in sorted(anyQualities)])}${("", "<br>")[bool(bestQualities)]}
                        % endif
                        % if bestQualities:
                            <i>Preferred:</i> ${", ".join([capture(renderQualityPill, x) for x in sorted(bestQualities)])}
                        % endif
                    % endif

                    % if show.network and show.airs:
                        <tr>
                            <td class="showLegend">Originally Airs:</td>
                            <td>${show.airs} ${("<font color='#FF0000'><b>(invalid Timeformat)</b></font> ", "")[tz_updater.test_timeformat(show.airs)]}
                                on ${show.network}</td>
                        </tr>
                    % elif show.network:
                        <tr>
                            <td class="showLegend">Originally Airs:</td>
                            <td>${show.network}</td>
                        </tr>
                    % elif show.airs:
                        <tr>
                            <td class="showLegend">Originally Airs:</td>
                            <td>${show.airs} ${("<font color='#FF0000'><b>(invalid Timeformat)</b></font>", "")[tz_updater.test_timeformat(show.airs)]}</td>
                        </tr>
                    % endif
                    <tr>
                        <td class="showLegend">Show Status:</td>
                        <td>${show.status}</td>
                    </tr>
                    <tr>
                        <td class="showLegend">Default EP Status:</td>
                        <td>${statusStrings[show.default_ep_status]}</td>
                    </tr>
                    % if showLoc[1]:
                        <tr>
                            <td class="showLegend">Location:</td>
                            <td>${showLoc[0]}</td>
                        </tr>
                    % else:
                        <tr>
                            <td class="showLegend"><span style="color: red;">Location: </span></td>
                            <td><span style="color: red;">${showLoc[0]}</span> (Missing)</td>
                        </tr>
                    % endif
                    <tr>
                        <td class="showLegend">Scene Name:</td>
                        <td>${(show.name, " | ".join(show.exceptions))[show.exceptions != 0]}</td>
                    </tr>

                    % if show.rls_require_words:
                        <tr>
                            <td class="showLegend">Required Words:</td>
                            <td>${show.rls_require_words}</td>
                        </tr>
                    % endif
                    % if show.rls_ignore_words:
                        <tr>
                            <td class="showLegend">Ignored Words:</td>
                            <td>${show.rls_ignore_words}</td>
                        </tr>
                    % endif
                    % if bwl and bwl.whitelist:
                        <tr>
                            <td class="showLegend">Wanted Group${("", "s")[len(bwl.whitelist) > 1]}:</td>
                            <td>${', '.join(bwl.whitelist)}</td>
                        </tr>
                    % endif
                    % if bwl and bwl.blacklist:
                        <tr>
                            <td class="showLegend">Unwanted Group${("", "s")[len(bwl.blacklist) > 1]}:</td>
                            <td>${', '.join(bwl.blacklist)}</td>
                        </tr>
                    % endif

                    <tr>
                        <td class="showLegend">Size:</td>
                        <td>${pretty_filesize(get_size(showLoc[0]))}</td>
                    </tr>

                </table>

                <table style="width:180px; float: right; vertical-align: middle; height: 100%;">
                    <% info_flag = subtitle_searcher.fromietf(show.lang).opensubtitles if show.lang else '' %>
                    <tr>
                        <td class="showLegend">Info Language:</td>
                        <td><img src="${srRoot}/images/subtitles/flags/${info_flag}.png" width="16" height="11"
                                 alt="${show.lang}" title="${show.lang}"
                                 onError="this.onerror=null;this.src='${srRoot}/images/flags/unknown.png';"/></td>
                    </tr>
                    % if sickrage.srConfig.USE_SUBTITLES:
                        <tr>
                            <td class="showLegend">Subtitles:</td>
                            <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.subtitles)]}"
                                     alt="${("N", "Y")[bool(show.subtitles)]}" width="16" height="16"/></td>
                        </tr>
                    % endif
                    <tr>
                        <td class="showLegend">Season Folders:</td>
                        <td><img
                                src="${srRoot}/images/${("no16.png", "yes16.png")[bool(not show.flatten_folders or sickrage.srConfig.NAMING_FORCE_FOLDERS)]}"
                                alt=="${("N", "Y")[bool(not show.flatten_folders or sickrage.srConfig.NAMING_FORCE_FOLDERS)]}"
                                width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Paused:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.paused)]}"
                                 alt="${("N", "Y")[bool(show.paused)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Air-by-Date:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.air_by_date)]}"
                                 alt="${("N", "Y")[bool(show.air_by_date)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Sports:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.is_sports)]}"
                                 alt="${("N", "Y")[bool(show.is_sports)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Anime:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.is_anime)]}"
                                 alt="${("N", "Y")[bool(show.is_anime)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">DVD Order:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.dvdorder)]}"
                                 alt="${("N", "Y")[bool(show.dvdorder)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Scene Numbering:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.scene)]}"
                                 alt="${("N", "Y")[bool(show.scene)]}" width="16" height="16"/></td>
                    </tr>
                    <tr>
                        <td class="showLegend">Archive First Match:</td>
                        <td><img src="${srRoot}/images/${("no16.png", "yes16.png")[bool(show.archive_firstmatch)]}"
                                 alt="${("N", "Y")[bool(show.archive_firstmatch)]}" width="16" height="16"/></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="clearfix"></div>

    <div class="pull-left">
        <div style="padding-bottom: 5px;">
            Change selected episodes to:</br>
            <select id="statusSelect" class="form-control form-control-inline input-sm">
                <% availableStatus = [WANTED, SKIPPED, IGNORED, FAILED] %>
                % if not sickrage.srConfig.USE_FAILED_DOWNLOADS:
                    <% availableStatus.remove(FAILED) %>
                % endif
                % for curStatus in availableStatus + sorted(Quality.DOWNLOADED) + sorted(Quality.ARCHIVED):
                    % if curStatus not in [DOWNLOADED, ARCHIVED]:
                        <option value="${curStatus}">${statusStrings[curStatus]}</option>
                    % endif
                % endfor
            </select>
            <input type="hidden" id="showID" value="${show.indexerid}"/>
            <input type="hidden" id="indexer" value="${show.indexer}"/>
        </div>

        <div class="pull-left">
            <input class="btn btn-inline" type="button" id="changeStatus" value="Go"/>
            <input class="btn btn-inline" type="button" id="deleteEpisode" value="Delete Episodes"/>
        </div>
    </div>

    </br>

    <div class="pull-right clearfix" id="checkboxControls">
        <div style="padding-bottom: 5px;">
            <label for="wanted"><span class="wanted"><input type="checkbox" id="wanted"
                                                            checked="checked"/> Wanted: <b>${epCounts[Overview.WANTED]}</b></span></label>
            <label for="qual"><span class="qual"><input type="checkbox" id="qual"
                                                        checked="checked"/> Low Quality: <b>${epCounts[Overview.QUAL]}</b></span></label>
            <label for="good"><span class="good"><input type="checkbox" id="good"
                                                        checked="checked"/> Downloaded: <b>${epCounts[Overview.GOOD]}</b></span></label>
            <label for="skipped"><span class="skipped"><input type="checkbox" id="skipped" checked="checked"/> Skipped: <b>${epCounts[Overview.SKIPPED]}</b></span></label>
            <label for="snatched"><span class="snatched"><input type="checkbox" id="snatched" checked="checked"/> Snatched: <b>${epCounts[Overview.SNATCHED]}</b></span></label>
        </div>

        <button id="popover" type="button" class="btn btn-xs">Select Columns <b class="caret"></b></button>
        <div class="pull-right">
            <button class="btn btn-xs seriesCheck">Select Filtered Episodes</button>
            <button class="btn btn-xs clearAll">Clear All</button>
        </div>
    </div>
    <br/>
    <br/>
    <br/>

    <table id="${("showTable", "animeTable")[bool(show.is_anime)]}" class="displayShowTable display_show"
           cellspacing="0" border="0" cellpadding="0">

        <% curSeason = -1 %>
        <% odd = 0 %>

        %  for epResult in sqlResults:
            <%
            epStr = str(epResult[b"season"]) + "x" + str(epResult[b"episode"])
            if not epStr in epCats:
                continue

            if not sickrage.srConfig.DISPLAY_SHOW_SPECIALS and int(epResult[b"season"]) == 0:
                continue

            scene = False
            scene_anime = False
            if not show.air_by_date and not show.is_sports and not show.is_anime and show.is_scene:
                scene = True
            elif not show.air_by_date and not show.is_sports and show.is_anime and show.is_scene:
                scene_anime = True

            (dfltSeas, dfltEpis, dfltAbsolute) = (0, 0, 0)
            if (epResult[b"season"], epResult[b"episode"]) in xem_numbering:
                (dfltSeas, dfltEpis) = xem_numbering[(epResult[b"season"], epResult[b"episode"])]

            if epResult[b"absolute_number"] in xem_absolute_numbering:
                dfltAbsolute = xem_absolute_numbering[epResult[b"absolute_number"]]

            if epResult[b"absolute_number"] in scene_absolute_numbering:
                scAbsolute = scene_absolute_numbering[epResult[b"absolute_number"]]
                dfltAbsNumbering = False
            else:
                scAbsolute = dfltAbsolute
                dfltAbsNumbering = True

            if (epResult[b"season"], epResult[b"episode"]) in scene_numbering:
                (scSeas, scEpis) = scene_numbering[(epResult[b"season"], epResult[b"episode"])]
                dfltEpNumbering = False
            else:
                (scSeas, scEpis) = (dfltSeas, dfltEpis)
                dfltEpNumbering = True

            epLoc = epResult[b"location"]
            if epLoc and show.location and epLoc.lower().startswith(show.location.lower()):
                epLoc = epLoc[len(show.location)+1:]
            %>
        % if int(epResult[b"season"]) != curSeason:
            % if curSeason == -1:
                <thead>
                <tr class="seasoncols" style="display:none;">
                    <th data-sorter="false" data-priority="critical" class="col-checkbox"><input type="checkbox"
                                                                                                 class="seasonCheck"/>
                    </th>
                    <th data-sorter="false" class="col-metadata">NFO</th>
                    <th data-sorter="false" class="col-metadata">TBN</th>
                    <th data-sorter="false" class="col-ep">Episode</th>
                    <th data-sorter="false" ${("class=\"col-ep columnSelector-false\"", "class=\"col-ep\"")[bool(show.is_anime)]}>
                        Absolute
                    </th>
                    <th data-sorter="false" ${("class=\"col-ep columnSelector-false\"", "class=\"col-ep\"")[bool(scene)]}>
                        Scene
                    </th>
                    <th data-sorter="false" ${("class=\"col-ep columnSelector-false\"", "class=\"col-ep\"")[bool(scene_anime)]}>
                        Scene Absolute
                    </th>
                    <th data-sorter="false" class="col-name">Name</th>
                    <th data-sorter="false" class="col-name columnSelector-false">File Name</th>
                    <th data-sorter="false" class="col-ep columnSelector-false">Size</th>
                    <th data-sorter="false" class="col-airdate">Airdate</th>
                    <th data-sorter="false" ${("class=\"col-ep columnSelector-false\"", "class=\"col-ep\"")[bool(sickrage.srConfig.DOWNLOAD_URL)]}>
                        Download
                    </th>
                    <th data-sorter="false" ${("class=\"col-ep columnSelector-false\"", "class=\"col-ep\"")[bool(sickrage.srConfig.USE_SUBTITLES)]}>
                        Subtitles
                    </th>
                    <th data-sorter="false" class="col-status">Status</th>
                    <th data-sorter="false" class="col-search">Search</th>
                </tr>
                </thead>
                <tbody class="tablesorter-no-sort">
                <tr style="height: 60px;">
                    <th class="row-seasonheader displayShowTable" colspan="13"
                        style="vertical-align: bottom; width: auto;">
                        <h3 style="display: inline;"><a
                                name="season-${epResult[b"season"]}"></a>${("Specials", "Season " + str(epResult[b"season"]))[int(epResult[b"season"]) > 0]}
                        </h3>
                        % if sickrage.srConfig.DISPLAY_ALL_SEASONS == False:
                            <button id="showseason-${epResult[b'season']}" type="button"
                                    class="btn btn-xs pull-right" data-toggle="collapse"
                                    data-target="#collapseSeason-${epResult[b'season']}">Show Episodes
                            </button>
                            <script type="text/javascript">
                                $(function () {
                                    $('#collapseSeason-${epResult[b'season']}').on('hide.bs.collapse', function () {
                                        $('#showseason-${epResult[b'season']}').text('Show Episodes');
                                    });
                                    $('#collapseSeason-${epResult[b'season']}').on('show.bs.collapse', function () {
                                        $('#showseason-${epResult[b'season']}').text('Hide Episodes');
                                    })
                                });
                            </script>
                        % endif
                    </th>
                </tr>
                </tbody>
            <tbody class="tablesorter-no-sort">
            <tr id="season-${epResult[b"season"]}-cols" class="seasoncols">
                <th class="col-checkbox"><input type="checkbox" class="seasonCheck" id="${epResult[b"season"]}"
                                                title=""/>
                </th>
                <th class="col-metadata">NFO</th>
                <th class="col-metadata">TBN</th>
                <th class="col-ep">Episode</th>
                <th class="col-ep">Absolute</th>
                <th class="col-ep">Scene</th>
                <th class="col-ep">Scene Absolute</th>
                <th class="col-name">Name</th>
                <th class="col-name">File Name</th>
                <th class="col-ep">Size</th>
                <th class="col-airdate">Airdate</th>
                <th class="col-ep">Download</th>
                <th class="col-ep">Subtitles</th>
                <th class="col-status">Status</th>
                <th class="col-search">Search</th>
            </tr>
            % else:
            </tbody>
                <tbody class="tablesorter-no-sort">
                <tr style="height: 60px;">
                    <th class="row-seasonheader displayShowTable" colspan="13"
                        style="vertical-align: bottom; width: auto;">
                        <h3 style="display: inline;"><a
                                name="season-${epResult[b"season"]}"></a>${("Specials", "Season " + str(epResult[b"season"]))[bool(int(epResult[b"season"]))]}
                        </h3>
                        % if sickrage.srConfig.DISPLAY_ALL_SEASONS == False:
                            <button id="showseason-${epResult[b'season']}" type="button"
                                    class="btn btn-xs pull-right" data-toggle="collapse"
                                    data-target="#collapseSeason-${epResult[b'season']}">Show Episodes
                            </button>
                            <script type="text/javascript">
                                $(function () {
                                    $('#collapseSeason-${epResult[b'season']}').on('hide.bs.collapse', function () {
                                        $('#showseason-${epResult[b'season']}').text('Show Episodes');
                                    });
                                    $('#collapseSeason-${epResult[b'season']}').on('show.bs.collapse', function () {
                                        $('#showseason-${epResult[b'season']}').text('Hide Episodes');
                                    })
                                });
                            </script>
                        % endif
                    </th>
                </tr>
                </tbody>
            <tbody class="tablesorter-no-sort">
            <tr id="season-${epResult[b"season"]}-cols" class="seasoncols">
                <th class="col-checkbox"><input type="checkbox" class="seasonCheck" id="${epResult[b"season"]}"
                                                title=""/>
                </th>
                <th class="col-metadata">NFO</th>
                <th class="col-metadata">TBN</th>
                <th class="col-ep">Episode</th>
                <th class="col-ep">Absolute</th>
                <th class="col-ep">Scene</th>
                <th class="col-ep">Scene Absolute</th>
                <th class="col-name">Name</th>
                <th class="col-name">File Name</th>
                <th class="col-ep">Size</th>
                <th class="col-airdate">Airdate</th>
                <th class="col-ep">Download</th>
                <th class="col-ep">Subtitles</th>
                <th class="col-status">Status</th>
                <th class="col-search">Search</th>
            </tr>
                % endif
            </tbody>
            % if sickrage.srConfig.DISPLAY_ALL_SEASONS == False:
                <tbody class="collapse${("", " in")[curSeason == -1]}" id="collapseSeason-${epResult[b'season']}">
            % else:


                <tbody>
                % endif
            <% curSeason = int(epResult[b"season"]) %>
            % endif
        <tr class="${Overview.overviewStrings[epCats[epStr]]} season-${curSeason} seasonstyle"
            id="${'S' + str(epResult[b"season"]) + 'E' + str(epResult[b"episode"])}">
            <td class="col-checkbox">
                % if int(epResult[b"status"]) != UNAIRED:
                    <input type="checkbox" class="epCheck"
                           id="${str(epResult[b"season"])+'x'+str(epResult[b"episode"])}"
                           name="${str(epResult[b"season"]) +"x"+str(epResult[b"episode"])}" title=""/>
                % endif
            </td>
            <td align="center"><img src="${srRoot}/images/${("nfo-no.gif", "nfo.gif")[epResult[b"hasnfo"]]}"
                                    alt="${("N", "Y")[epResult[b"hasnfo"]]}" width="23" height="11"/></td>
            <td align="center"><img src="${srRoot}/images/${("tbn-no.gif", "tbn.gif")[epResult[b"hastbn"]]}"
                                    alt="${("N", "Y")[epResult[b"hastbn"]]}" width="23" height="11"/></td>
            <td align="center">
                <%
                    text = str(epResult[b'episode'])
                    if epLoc != '' and epLoc is not None:
                            text = '<span title="' + epLoc + '" class="addQTip">' + text + "</span>"
                %>
                ${text}
            </td>
            <td align="center">${epResult[b"absolute_number"]}</td>
            <td align="center">
                <input type="text" placeholder="${str(dfltSeas) + 'x' + str(dfltEpis)}" size="6" maxlength="8"
                       class="sceneSeasonXEpisode form-control input-scene" data-for-season="${epResult[b"season"]}"
                       data-for-episode="${epResult[b"episode"]}"
                       id="sceneSeasonXEpisode_${show.indexerid}_${str(epResult[b"season"])}_${str(epResult[b"episode"])}"
                       title="Change the value here if scene numbering differs from the indexer episode numbering"
                    % if dfltEpNumbering:
                       value=""
                    % else:
                       value="${str(scSeas)}x${str(scEpis)}"
                    % endif
                       style="padding: 0; text-align: center; max-width: 60px;"/>
            </td>
            <td align="center">
                <input type="text" placeholder="${str(dfltAbsolute)}" size="6" maxlength="8"
                       class="sceneAbsolute form-control input-scene"
                       data-for-absolute="${epResult[b"absolute_number"]}"
                       id="sceneAbsolute_${show.indexerid}${"_"+str(epResult[b"absolute_number"])}"
                       title="Change the value here if scene absolute numbering differs from the indexer absolute numbering"
                    % if dfltAbsNumbering:
                       value=""
                    % else:
                       value="${str(scAbsolute)}"
                    % endif
                       style="padding: 0; text-align: center; max-width: 60px;"/>
            </td>
            <td class="col-name">
                % if epResult[b"description"] != "" and epResult[b"description"] is not None:
                    <img src="${srRoot}/images/info32.png" width="16" height="16" class="plotInfo" alt=""
                         id="plot_info_${str(show.indexerid)}_${str(epResult[b"season"])}_${str(epResult[b"episode"])}"/>
                    % else:
                    <img src="${srRoot}/images/info32.png" width="16" height="16" class="plotInfoNone" alt=""/>
                    % endif
                ${epResult[b"name"]}
            </td>
            <td class="col-name">${epLoc}</td>
            <td class="col-ep">
                % if epResult[b"file_size"]:
                    <% file_size = pretty_filesize(epResult[b"file_size"]) %>
                    ${file_size}
                % endif
            </td>
            <td class="col-airdate">
                % if int(epResult[b'airdate']) != 1:
                    ## Lets do this exactly like ComingEpisodes and History
                    ## Avoid issues with dateutil's _isdst on Windows but still provide air dates
                    <% airDate = datetime.datetime.fromordinal(epResult[b'airdate']) %>
                    % if airDate.year >= 1970 or show.network:
                        <% airDate = srdatetime.srDateTime.convert_to_setting(tz_updater.parse_date_time(epResult[b'airdate'], show.airs, show.network)) %>
                    % endif
                        <time datetime="${airDate.isoformat()}"
                              class="date">${srdatetime.srDateTime.srfdatetime(airDate)}</time>
                % else:
                    Never
                % endif
            </td>
            <td>
                % if sickrage.srConfig.DOWNLOAD_URL and epResult[b'location']:
                    <%
                        filename = epResult[b'location']
                        for rootDir in sickrage.srConfig.ROOT_DIRS.split('|'):
                            if rootDir.startswith('/'):
                                filename = filename.replace(rootDir, "")
                        filename = sickrage.srConfig.DOWNLOAD_URL + urllib.quote(filename.encode('utf8'))
                    %>
                        <div style="text-align: center;"><a href="${filename}">Download</a></div>
                % endif
            </td>
            <td class="col-subtitles" align="center">
                % for sub_lang in [subtitle_searcher.fromietf(x) for x in epResult[b"subtitles"].split(',') if epResult[b"subtitles"]]:
                <% flag = sub_lang.opensubtitles %>
                % if (not sickrage.srConfig.SUBTITLES_MULTI and len(subtitle_searcher.wantedLanguages()) is 1) and subtitle_searcher.wantedLanguages()[0] in sub_lang.opensubtitles:
                    <% flag = 'checkbox' %>
                % endif
                    <img src="${srRoot}/images/subtitles/flags/${flag}.png" width="16" height="11"
                         alt="${sub_lang.name}"
                         onError="this.onerror=null;this.src='${srRoot}/images/flags/unknown.png';"/>
                % endfor
            </td>
                <% curStatus, curQuality = Quality.splitCompositeStatus(int(epResult[b"status"])) %>
                % if curQuality != Quality.NONE:
                    <td class="col-status">${statusStrings[curStatus]} ${renderQualityPill(curQuality)}</td>
                % else:
                    <td class="col-status">${statusStrings[curStatus]}</td>
                % endif
            <td class="col-search">
                % if int(epResult[b"season"]) != 0:
                    % if ( int(epResult[b"status"]) in Quality.SNATCHED + Quality.DOWNLOADED ) and sickrage.srConfig.USE_FAILED_DOWNLOADS:
                        <a class="epRetry"
                           id="${str(show.indexerid)}x${str(epResult[b"season"])}x${str(epResult[b"episode"])}"
                           name="${str(show.indexerid)}x${str(epResult[b"season"])}x${str(epResult[b"episode"])}"
                           href="retryEpisode?show=${show.indexerid}&amp;season=${epResult[b"season"]}&amp;episode=${epResult[b"episode"]}"><img
                                src="${srRoot}/images/search16.png" height="16" alt="retry" title="Retry Download"/></a>
                    % else:
                        <a class="epSearch"
                           id="${str(show.indexerid)}x${str(epResult[b"season"])}x${str(epResult[b"episode"])}"
                           name="${str(show.indexerid)}x${str(epResult[b"season"])}x${str(epResult[b"episode"])}"
                           href="searchEpisode?show=${show.indexerid}&amp;season=${epResult[b"season"]}&amp;episode=${epResult[b"episode"]}"><img
                                src="${srRoot}/images/search16.png" width="16" height="16" alt="search"
                                title="Manual Search"/></a>
                    % endif
                    % endif
                % if sickrage.srConfig.USE_SUBTITLES and show.subtitles and epResult[b"location"] and frozenset(subtitle_searcher.wantedLanguages()).difference(epResult[b"subtitles"].split(',')):
                    <a class="epSubtitlesSearch"
                       href="searchEpisodeSubtitles?show=${show.indexerid}&amp;season=${epResult[b"season"]}&amp;episode=${epResult[b"episode"]}"><img
                            src="${srRoot}/images/closed_captioning.png" height="16" alt="search subtitles"
                            title="Search Subtitles"/></a>
                % endif
            </td>
        </tr>
        % endfor
    </tbody>
    </table>

    <!--Begin - Bootstrap Modal-->

    <div id="manualSearchModalFailed" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Manual Search</h4>
                </div>
                <div class="modal-body">
                    <p>Do you want to mark this episode as failed?</p>
                    <p class="text-warning">
                        <small>The episode release name will be added to the failed history, preventing it to be
                            downloaded again.
                        </small>
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
                    <button type="button" class="btn btn-success" data-dismiss="modal">Yes</button>
                </div>
            </div>
        </div>
    </div>

    <div id="manualSearchModalQuality" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Manual Search</h4>
                </div>
                <div class="modal-body">
                    <p>Do you want to include the current episode quality in the search?</p>
                    <p class="text-warning">
                        <small>Choosing No will ignore any releases with the same episode quality as the one currently
                            downloaded/snatched.
                        </small>
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
                    <button type="button" class="btn btn-success" data-dismiss="modal">Yes</button>
                </div>
            </div>
        </div>
    </div>

    <!--End - Bootstrap Modal-->

</%block>
