# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkerPool(Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values
     include: 'Shared', 'Dedicated', 'Dynamic'
    :type compute_mode: str or ~azure.mgmt.web.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read
     only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'computeMode', 'type': 'ComputeModeOptions'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_count': {'key': 'workerCount', 'type': 'int'},
        'instance_names': {'key': 'instanceNames', 'type': '[str]'},
    }

    def __init__(self, worker_size_id=None, compute_mode=None, worker_size=None, worker_count=None):
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None
