__author__ = 'Bruce Fenske'

import os
from setuptools import setup, find_packages

def read(*paths):
    """
    Build a file path from * paths and return the contents
    :param paths:
    :return:
    """
    with open(os.path.join(*paths), 'r') as f:
        return f.read()

setup(
    name='py-linq',
    version='0.4.0',
    description='Linq for Python. Now supports Python 3',
    long_description=(read('README.rst') + '\n\n' + read('HISTORY.rst') + '\n\n' + read('AUTHORS.rst') + '\n\n' + read('CONTRIBUTING.rst')),
    url='https://github.com/viralogic/py-enumerable',
    license='MIT',
    author='Bruce Fenske',
    author_email='bwfenske@ualberta.ca',
    packages=find_packages(exclude=['tests*']),
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.1',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]


)
