# -*- coding: utf-8 -*-
from 臺灣言語工具.語音合成.決策樹仔問題.公家決策樹仔 import 公家決策樹仔
from 臺灣言語工具.語音合成.生決策樹仔問題 import 生決策樹仔問題
import itertools
import os


class 南島語決策樹仔(公家決策樹仔):
    聲韻符號 = ('', '-', '+', '/調:')
    調符號 = ('/調:', '<', '>', '/詞:')
    詞符號 = ('/詞:', '!', '@', '/句:')
    句符號 = ('/句:', '^', '_', '')

    def __init__(self, 音標系統):
        self.音標系統 = 音標系統

    def 生(self, 輸出目的=open(os.devnull, 'w')):
        問題 = set()
        問題 |= self.孤聲韻()
        print(len(問題), file=輸出目的)
        問題 |= self.音韻組合()
        print(len(問題), file=輸出目的)
        問題 |= self.詞句長度(10, 20)
        print(len(問題), file=輸出目的)
        問題 |= self.孤雙數音節()
        print(len(問題), file=輸出目的)

        生決策樹仔問題.檢查(問題)
        return 問題

    def 孤聲韻(self):
        聲韻 = []
        for 實際音 in itertools.chain(
                ['sil', 'sp'],
                self.音標系統.國際音標對照表.values(),
        ):
            聲韻.append(('{0}'.format(實際音), [實際音]))
        return 生決策樹仔問題.問題集(聲韻, self.聲韻符號, '孤條')

    def 音韻組合(self):
        仝元音題目 = [
            ('a音', ['a', 'aː', ]),
            ('i音', ['i', 'iː', ]),
            ('u音', ['u', 'uː', ]),
            ('e音', ['e', 'eː', ]),
            ('o音', ['o', 'oː', ]),
            ('ə音', ['ə', 'əː', ]),
            ('œ音', ['œ', 'œː', ]),
            ('æ音', ['æ', 'æː', ]),
        ]
        長短元音題目 = [
            ('短音', ['a', 'i', 'u', 'e', 'o', 'ə', 'œ', 'æ', ]),
            ('長音', ['aː', 'iː', 'uː', 'eː', 'oː', 'əː', 'œ:', 'æ:', ]),
        ]
        滑音題目 = [
            ('ji音', ['j', 'i', 'iː', ]),
            ('wu音', ['w', 'u', 'uː', ]),
        ]
        發音方法 = [
            ('鼻音', ['m', 'n', 'ŋ', ]),
            ('清塞音', ['p', 't', 'k', 'q', 'ʔ', ]),
            ('濁塞音', ['b', 'd', 'g', ]),
            ('清擦音', ['β', 's', 'z', 'x', 'ʃ', ]),
            ('濁擦音', ['v', 'ð', 'ɣ', ]),
        ]
        發音所在 = [
            ('唇輔音', ['p', 'b', 'm', 'β', 'v']),
            ('舌尖輔音', ['t', 'd', 'n', 'l', 'r', 's', 'z', 'ʃ', 'ts', ]),
            ('舌根輔音', ['k', 'g', 'ŋ', 'x', 'ɣ', ]),
            ('小舌輔音', ['q', ]),
            ('咽輔音', ['h', ]),
            ('喉輔音', ['ʔ', ]),
        ]
        return (
            生決策樹仔問題.問題集(仝元音題目, self.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(長短元音題目, self.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(滑音題目, self.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(發音方法, self.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(發音所在, self.聲韻符號, '孤條')
        )
