# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ApiDefinitionInfo(Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class Resource(Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.type = None
        self.tags = kwargs.get('tags', None)


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param worker_tier_name: Target worker tier assigned to the App Service
     plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: 'Ready',
     'Pending', 'Creating'
    :vartype status: str or ~azure.mgmt.web.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service
     Environment to use for the App Service plan.
    :type hosting_environment_profile:
     ~azure.mgmt.web.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be
     assigned to this App Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If <code>true</code>, apps assigned to this App
     Service plan can be scaled independently.
     If <code>false</code>, apps assigned to this App Service plan will scale
     to all instances of the plan. Default value: False .
    :type per_site_scaling: bool
    :param maximum_elastic_worker_count: Maximum number of total workers
     allowed for this ElasticScaleEnabled App Service Plan
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If <code>true</code>, this App Service Plan owns spot
     instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid
     only if it is a spot server farm.
    :type spot_expiration_time: datetime
    :param free_offer_expiration_time: The time when the server farm free
     offer expires.
    :type free_offer_expiration_time: datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan <code>true</code>,
     <code>false</code> otherwise. Default value: False .
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan
     <code>true</code>, <code>false</code> otherwise. Default value: False .
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan <code>true</code>,
     <code>false</code> otherwise. Default value: False .
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service
     Environment. Possible values include: 'Succeeded', 'Failed', 'Canceled',
     'InProgress', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.models.ProvisioningState
    :param sku:
    :type sku: ~azure.mgmt.web.models.SkuDescription
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'StatusOptions'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
    }

    def __init__(self, **kwargs):
        super(AppServicePlan, self).__init__(**kwargs)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.maximum_elastic_worker_count = kwargs.get('maximum_elastic_worker_count', None)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.free_offer_expiration_time = kwargs.get('free_offer_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None
        self.sku = kwargs.get('sku', None)


class AutoHealActions(Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values
     include: 'Recycle', 'LogEvent', 'CustomAction'
    :type action_type: str or ~azure.mgmt.web.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'AutoHealActionType'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = kwargs.get('action_type', None)
        self.custom_action = kwargs.get('custom_action', None)
        self.min_process_execution_time = kwargs.get('min_process_execution_time', None)


class AutoHealCustomAction(Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = kwargs.get('exe', None)
        self.parameters = kwargs.get('parameters', None)


class AutoHealRules(Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal
     actions.
    :type triggers: ~azure.mgmt.web.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(self, **kwargs):
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = kwargs.get('triggers', None)
        self.actions = kwargs.get('actions', None)


class AutoHealTriggers(Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes: list[~azure.mgmt.web.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests: ~azure.mgmt.web.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(self, **kwargs):
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.private_bytes_in_kb = kwargs.get('private_bytes_in_kb', None)
        self.status_codes = kwargs.get('status_codes', None)
        self.slow_requests = kwargs.get('slow_requests', None)


class AzureStorageInfoValue(Model):
    """Azure Files or Blob Storage access information value for dictionary
    storage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: Type of storage. Possible values include: 'AzureFiles',
     'AzureBlob'
    :type type: str or ~azure.mgmt.web.models.AzureStorageType
    :param account_name: Name of the storage account.
    :type account_name: str
    :param share_name: Name of the file share (container name, for Blob
     storage).
    :type share_name: str
    :param access_key: Access key for the storage account.
    :type access_key: str
    :param mount_path: Path to mount the storage within the site's runtime
     environment.
    :type mount_path: str
    :ivar state: State of the storage account. Possible values include: 'Ok',
     'InvalidCredentials', 'InvalidShare'
    :vartype state: str or ~azure.mgmt.web.models.AzureStorageState
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'AzureStorageType'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'state': {'key': 'state', 'type': 'AzureStorageState'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageInfoValue, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.account_name = kwargs.get('account_name', None)
        self.share_name = kwargs.get('share_name', None)
        self.access_key = kwargs.get('access_key', None)
        self.mount_path = kwargs.get('mount_path', None)
        self.state = None


class Capability(Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :param name: Name of the SKU capability.
    :type name: str
    :param value: Value of the SKU capability.
    :type value: str
    :param reason: Reason of the SKU capability.
    :type reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Capability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.reason = kwargs.get('reason', None)


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: datetime
    :param password: Required. Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service
     Environment to use for the certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible
     values include: 'Initialized', 'WaitingOnCertificateOrder', 'Succeeded',
     'CertificateOrderFailed', 'OperationNotPermittedOnKeyVault',
     'AzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultDoesNotExist',
     'KeyVaultSecretDoesNotExist', 'UnknownError', 'ExternalPrivateKey',
     'Unknown'
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan,
     formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'password': {'required': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'KeyVaultSecretStatus'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Certificate, self).__init__(**kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = kwargs.get('password', None)
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)


class ProxyOnlyResource(Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource
    Manager.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.type = None


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: datetime
    :param password: Required. Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service
     Environment to use for the certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible
     values include: 'Initialized', 'WaitingOnCertificateOrder', 'Succeeded',
     'CertificateOrderFailed', 'OperationNotPermittedOnKeyVault',
     'AzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultDoesNotExist',
     'KeyVaultSecretDoesNotExist', 'UnknownError', 'ExternalPrivateKey',
     'Unknown'
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan,
     formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'password': {'required': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'KeyVaultSecretStatus'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CertificatePatchResource, self).__init__(**kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = kwargs.get('password', None)
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)


class CloningInfo(Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties
     multiple cloning operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: <code>true</code> to overwrite destination app;
     otherwise, <code>false</code>.
    :type overwrite: bool
    :param clone_custom_host_names: <code>true</code> to clone custom
     hostnames from source app; otherwise, <code>false</code>.
    :type clone_custom_host_names: bool
    :param clone_source_control: <code>true</code> to clone source control
     from source app; otherwise, <code>false</code>.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App
     resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param source_web_app_location: Location of source app ex: West US or
     North Europe
    :type source_web_app_location: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned
     app. If specified, these settings override the settings cloned
     from source app. Otherwise, application settings from source app are
     retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: <code>true</code> to configure load
     balancing for source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager
     profile to use, if it exists. Traffic Manager resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to
     create. This is only needed if Traffic Manager profile does not already
     exist.
    :type traffic_manager_profile_name: str
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'source_web_app_location': {'key': 'sourceWebAppLocation', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.clone_custom_host_names = kwargs.get('clone_custom_host_names', None)
        self.clone_source_control = kwargs.get('clone_source_control', None)
        self.source_web_app_id = kwargs.get('source_web_app_id', None)
        self.source_web_app_location = kwargs.get('source_web_app_location', None)
        self.hosting_environment = kwargs.get('hosting_environment', None)
        self.app_settings_overrides = kwargs.get('app_settings_overrides', None)
        self.configure_load_balancing = kwargs.get('configure_load_balancing', None)
        self.traffic_manager_profile_id = kwargs.get('traffic_manager_profile_id', None)
        self.traffic_manager_profile_name = kwargs.get('traffic_manager_profile_name', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConnStringInfo(Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: 'MySql',
     'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus',
     'EventHub', 'ApiHub', 'DocDb', 'RedisCache', 'PostgreSQL'
    :type type: str or ~azure.mgmt.web.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ConnectionStringType'},
    }

    def __init__(self, **kwargs):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.type = kwargs.get('type', None)


class CorsSettings(Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be
     allowed to make cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    :param support_credentials: Gets or sets whether CORS requests with
     credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :type support_credentials: bool
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'support_credentials': {'key': 'supportCredentials', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)
        self.support_credentials = kwargs.get('support_credentials', None)


class DefaultErrorResponse(Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(self, **kwargs):
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'DefaultErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(DefaultErrorResponseException, self).__init__(deserialize, response, 'DefaultErrorResponse', *args)


class DefaultErrorResponseError(Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :param details:
    :type details:
     list[~azure.mgmt.web.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = kwargs.get('details', None)
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedSite(ProxyOnlyResource):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site
    :vartype slot: str
    :ivar deleted_site_kind: Kind of site that was deleted
    :vartype deleted_site_kind: str
    :ivar geo_region_name: Geo Region of the deleted site
    :vartype geo_region_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deleted_site_id': {'readonly': True},
        'deleted_timestamp': {'readonly': True},
        'subscription': {'readonly': True},
        'resource_group': {'readonly': True},
        'deleted_site_name': {'readonly': True},
        'slot': {'readonly': True},
        'deleted_site_kind': {'readonly': True},
        'geo_region_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'int'},
        'deleted_timestamp': {'key': 'properties.deletedTimestamp', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'deleted_site_name': {'key': 'properties.deletedSiteName', 'type': 'str'},
        'slot': {'key': 'properties.slot', 'type': 'str'},
        'deleted_site_kind': {'key': 'properties.kind', 'type': 'str'},
        'geo_region_name': {'key': 'properties.geoRegionName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeletedSite, self).__init__(**kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.deleted_site_kind = None
        self.geo_region_name = None


class Experiments(Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(self, **kwargs):
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = kwargs.get('ramp_up_rules', None)


class GeoDistribution(Model):
    """A global distribution definition.

    :param location: Location.
    :type location: str
    :param number_of_workers: NumberOfWorkers.
    :type number_of_workers: int
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(GeoDistribution, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.number_of_workers = kwargs.get('number_of_workers', None)


class HandlerMapping(Model):
    """The IIS handler mappings used to define which handler processes HTTP
    requests with certain extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP
    requests with *.php extension.

    :param extension: Requests with this extension will be handled using the
     specified FastCGI application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script
     processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = kwargs.get('extension', None)
        self.script_processor = kwargs.get('script_processor', None)
        self.arguments = kwargs.get('arguments', None)


class HostingEnvironmentProfile(Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None


class HostNameSslState(Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: 'Disabled',
     'SniEnabled', 'IpBasedEnabled'
    :type ssl_state: str or ~azure.mgmt.web.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based
     SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to <code>true</code> to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or
     repository hostname. Possible values include: 'Standard', 'Repository'
    :type host_type: str or ~azure.mgmt.web.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'SslState'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'HostType'},
    }

    def __init__(self, **kwargs):
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.to_update = kwargs.get('to_update', None)
        self.host_type = kwargs.get('host_type', None)


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send
     permissions. This is used to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to
     authenticate to Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By
     default this is .servicebus.windows.net
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HybridConnection, self).__init__(**kwargs)
        self.service_bus_namespace = kwargs.get('service_bus_namespace', None)
        self.relay_name = kwargs.get('relay_name', None)
        self.relay_arm_uri = kwargs.get('relay_arm_uri', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.send_key_name = kwargs.get('send_key_name', None)
        self.send_key_value = kwargs.get('send_key_value', None)
        self.service_bus_suffix = kwargs.get('service_bus_suffix', None)


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a
    Hybrid Connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HybridConnectionKey, self).__init__(**kwargs)
        self.send_key_name = None
        self.send_key_value = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param identifier_id: String representation of the identity.
    :type identifier_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Identifier, self).__init__(**kwargs)
        self.identifier_id = kwargs.get('identifier_id', None)


class IpSecurityRestriction(Model):
    """IP security restriction on an app.

    :param ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the
     restriction is valid for.
    :type subnet_mask: str
    :param vnet_subnet_resource_id: Virtual network resource id
    :type vnet_subnet_resource_id: str
    :param vnet_traffic_tag: (internal) Vnet traffic tag
    :type vnet_traffic_tag: int
    :param subnet_traffic_tag: (internal) Subnet traffic tag
    :type subnet_traffic_tag: int
    :param action: Allow or Deny access for this IP range.
    :type action: str
    :param tag: Defines what this IP filter will be used for. This is to
     support IP filtering on proxies. Possible values include: 'Default',
     'XffProxy'
    :type tag: str or ~azure.mgmt.web.models.IpFilterTag
    :param priority: Priority of IP restriction rule.
    :type priority: int
    :param name: IP restriction rule name.
    :type name: str
    :param description: IP restriction rule description.
    :type description: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
        'vnet_subnet_resource_id': {'key': 'vnetSubnetResourceId', 'type': 'str'},
        'vnet_traffic_tag': {'key': 'vnetTrafficTag', 'type': 'int'},
        'subnet_traffic_tag': {'key': 'subnetTrafficTag', 'type': 'int'},
        'action': {'key': 'action', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'IpFilterTag'},
        'priority': {'key': 'priority', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.subnet_mask = kwargs.get('subnet_mask', None)
        self.vnet_subnet_resource_id = kwargs.get('vnet_subnet_resource_id', None)
        self.vnet_traffic_tag = kwargs.get('vnet_traffic_tag', None)
        self.subnet_traffic_tag = kwargs.get('subnet_traffic_tag', None)
        self.action = kwargs.get('action', None)
        self.tag = kwargs.get('tag', None)
        self.priority = kwargs.get('priority', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)


class ManagedServiceIdentity(Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: Type of managed service identity. Possible values include:
     'SystemAssigned', 'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or ~azure.mgmt.web.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :param user_assigned_identities: The list of user assigned identities
     associated with the resource. The user identity dictionary key references
     will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.web.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ManagedServiceIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, **kwargs):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ManagedServiceIdentityUserAssignedIdentitiesValue(Model):
    """ManagedServiceIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: Principal Id of user assigned identity
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedServiceIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class NameValuePair(Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Required. Gets or sets a flag indicating whether
     the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of
     tags that are whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list
     of tags that require user authentication to be used in the push
     registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of
     dynamic tags that will be evaluated from user claims in the push
     registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_push_enabled': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PushSettings, self).__init__(**kwargs)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.tag_whitelist_json = kwargs.get('tag_whitelist_json', None)
        self.tags_requiring_auth = kwargs.get('tags_requiring_auth', None)
        self.dynamic_tags_json = kwargs.get('dynamic_tags_json', None)


class RampUpRule(Model):
    """Routing rules for ramp up testing. This rule allows to redirect static
    traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be
     redirected if decided to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be
     redirected to <code>ActionHostName</code>.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to
     add/remove from <code>ReroutePercentage</code> until it reaches
     <code>MinReroutePercentage</code> or <code>MaxReroutePercentage</code>.
     Site metrics are checked every N minutes specified in
     <code>ChangeIntervalInMinutes</code>.
     Custom decision algorithm can be provided in TiPCallback site extension
     which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to
     reevaluate ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which
     ReroutePercentage will stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which
     ReroutePercentage will stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be
     provided in TiPCallback site extension which URL can be specified. See
     TiPCallback site extension for the scaffold and contracts.
     https://www.siteextensions.net/packages/TiPCallback/
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to
     point to the slot which will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = kwargs.get('action_host_name', None)
        self.reroute_percentage = kwargs.get('reroute_percentage', None)
        self.change_step = kwargs.get('change_step', None)
        self.change_interval_in_minutes = kwargs.get('change_interval_in_minutes', None)
        self.min_reroute_percentage = kwargs.get('min_reroute_percentage', None)
        self.max_reroute_percentage = kwargs.get('max_reroute_percentage', None)
        self.change_decision_callback_url = kwargs.get('change_decision_callback_url', None)
        self.name = kwargs.get('name', None)


class RequestsBasedTrigger(Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class ResourceMetricAvailability(Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric
     together with retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ResourceMetricDefinition, self).__init__(**kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota
     usage. Read-only. Possible values include: 'Normal', 'Exceeded'
    :vartype usage_state: str or ~azure.mgmt.web.models.UsageState
    :param enabled: <code>true</code> if the app is enabled; otherwise,
     <code>false</code>. Setting this value to false disables the app (takes
     the app offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to
     be assigned (see HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for
     the app. Possible values include: 'Normal', 'Limited',
     'DisasterRecoveryMode'
    :vartype availability_state: str or
     ~azure.mgmt.web.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the
     SSL bindings for app's hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan,
     formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: <code>true</code> if reserved; otherwise,
     <code>false</code>. Default value: False .
    :type reserved: bool
    :param is_xenon: Obsolete: Hyper-V sandbox. Default value: False .
    :type is_xenon: bool
    :param hyper_v: Hyper-V sandbox. Default value: False .
    :type hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC.
     Read-only.
    :vartype last_modified_time_utc: datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames
     associated with the app. Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: <code>true</code> to stop SCM (KUDU) site
     when the app is stopped; otherwise, <code>false</code>. The default is
     <code>false</code>. Default value: False .
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap
     into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the
     app.
    :type hosting_environment_profile:
     ~azure.mgmt.web.models.HostingEnvironmentProfile
    :param client_affinity_enabled: <code>true</code> to enable client
     affinity; <code>false</code> to stop sending session affinity cookies,
     which route client requests in the same session to the same instance.
     Default is <code>true</code>.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: <code>true</code> to enable client certificate
     authentication (TLS mutual authentication); otherwise, <code>false</code>.
     Default is <code>false</code>.
    :type client_cert_enabled: bool
    :param client_cert_exclusion_paths: client certificate authentication
     comma-separated exclusion paths
    :type client_cert_exclusion_paths: str
    :param host_names_disabled: <code>true</code> to disable the public
     hostnames of the app; otherwise, <code>false</code>.
     If <code>true</code>, the app is only accessible via API management
     process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for
     outbound connections (e.g. database access). Includes VIPs from tenants
     that site can be hosted with current settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app
     uses for outbound connections (e.g. database access). Includes VIPs from
     all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota
     (applicable on dynamic apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is
     exceeded.
    :vartype suspended_till: datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned
     from a source app.
    :type cloning_info: ~azure.mgmt.web.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to.
     Read-only.
    :vartype resource_group: str
    :ivar is_default_container: <code>true</code> if the app is a default
     container; otherwise, <code>false</code>.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https
     requests. Issues redirect for
     http requests
    :type https_only: bool
    :param redundancy_mode: Site redundancy mode. Possible values include:
     'None', 'Manual', 'Failover', 'ActiveActive', 'GeoRedundant'
    :type redundancy_mode: str or ~azure.mgmt.web.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has
     a pending operation.
    :vartype in_progress_operation_id: str
    :param geo_distributions: GeoDistributions for this site
    :type geo_distributions: list[~azure.mgmt.web.models.GeoDistribution]
    :param identity:
    :type identity: ~azure.mgmt.web.models.ManagedServiceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'UsageState'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'SiteAvailabilityState'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'RedundancyMode'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
        'geo_distributions': {'key': 'properties.geoDistributions', 'type': '[GeoDistribution]'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, **kwargs):
        super(Site, self).__init__(**kwargs)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.client_cert_exclusion_paths = kwargs.get('client_cert_exclusion_paths', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)
        self.redundancy_mode = kwargs.get('redundancy_mode', None)
        self.in_progress_operation_id = None
        self.geo_distributions = kwargs.get('geo_distributions', None)
        self.identity = kwargs.get('identity', None)


class SiteConfig(Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version. Default value:
     "v4.6" .
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param linux_fx_version: Linux App Framework and version
    :type linux_fx_version: str
    :param windows_fx_version: Xenon App Framework and version
    :type windows_fx_version: str
    :param request_tracing_enabled: <code>true</code> if request tracing is
     enabled; otherwise, <code>false</code>.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: datetime
    :param remote_debugging_enabled: <code>true</code> if remote debugging is
     enabled; otherwise, <code>false</code>.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: <code>true</code> if HTTP logging is enabled;
     otherwise, <code>false</code>.
    :type http_logging_enabled: bool
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: <code>true</code> if detailed error
     logging is enabled; otherwise, <code>false</code>.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.models.NameValuePair]
    :param azure_storage_accounts: User-provided Azure storage accounts.
    :type azure_storage_accounts: dict[str,
     ~azure.mgmt.web.models.AzureStorageInfoValue]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: 'None', 'Dropbox',
     'Tfs', 'LocalGit', 'GitHub', 'CodePlexGit', 'CodePlexHg', 'BitbucketGit',
     'BitbucketHg', 'ExternalGit', 'ExternalHg', 'OneDrive', 'VSO'
    :type scm_type: str or ~azure.mgmt.web.models.ScmType
    :param use32_bit_worker_process: <code>true</code> to use 32-bit worker
     process; otherwise, <code>false</code>.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: <code>true</code> if WebSocket is enabled;
     otherwise, <code>false</code>.
    :type web_sockets_enabled: bool
    :param always_on: <code>true</code> if Always On is enabled; otherwise,
     <code>false</code>.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values
     include: 'Integrated', 'Classic'
    :type managed_pipeline_mode: str or
     ~azure.mgmt.web.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications:
     list[~azure.mgmt.web.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include:
     'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime',
     'WeightedTotalTraffic', 'RequestHash'
    :type load_balancing: str or ~azure.mgmt.web.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.models.SiteLimits
    :param auto_heal_enabled: <code>true</code> if Auto Heal is enabled;
     otherwise, <code>false</code>.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.models.PushSettings
    :param api_definition: Information about the formal API definition for the
     app.
    :type api_definition: ~azure.mgmt.web.models.ApiDefinitionInfo
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: <code>true</code> to enable local MySQL;
     otherwise, <code>false</code>. Default value: False .
    :type local_my_sql_enabled: bool
    :param managed_service_identity_id: Managed Service Identity Id
    :type managed_service_identity_id: int
    :param x_managed_service_identity_id: Explicit Managed Service Identity Id
    :type x_managed_service_identity_id: int
    :param ip_security_restrictions: IP security restrictions for main.
    :type ip_security_restrictions:
     list[~azure.mgmt.web.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions: IP security restrictions for scm.
    :type scm_ip_security_restrictions:
     list[~azure.mgmt.web.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions_use_main: IP security restrictions for
     scm to use main.
    :type scm_ip_security_restrictions_use_main: bool
    :param http20_enabled: Http20Enabled: configures a web site to allow
     clients to connect over http2.0. Default value: True .
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of
     TLS required for SSL requests. Possible values include: '1.0', '1.1',
     '1.2'
    :type min_tls_version: str or ~azure.mgmt.web.models.SupportedTlsVersions
    :param ftps_state: State of FTP / FTPS service. Possible values include:
     'AllAllowed', 'FtpsOnly', 'Disabled'
    :type ftps_state: str or ~azure.mgmt.web.models.FtpsState
    :param reserved_instance_count: Number of reserved instances.
     This setting only applies to the Consumption Plan
    :type reserved_instance_count: int
    """

    _validation = {
        'machine_key': {'readonly': True},
        'reserved_instance_count': {'maximum': 10, 'minimum': 0},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'azure_storage_accounts': {'key': 'azureStorageAccounts', 'type': '{AzureStorageInfoValue}'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'ManagedPipelineMode'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'SiteLoadBalancing'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'xManagedServiceIdentityId', 'type': 'int'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'ftpsState', 'type': 'str'},
        'reserved_instance_count': {'key': 'reservedInstanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.windows_fx_version = kwargs.get('windows_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.azure_storage_accounts = kwargs.get('azure_storage_accounts', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.managed_service_identity_id = kwargs.get('managed_service_identity_id', None)
        self.x_managed_service_identity_id = kwargs.get('x_managed_service_identity_id', None)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.scm_ip_security_restrictions = kwargs.get('scm_ip_security_restrictions', None)
        self.scm_ip_security_restrictions_use_main = kwargs.get('scm_ip_security_restrictions_use_main', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)
        self.ftps_state = kwargs.get('ftps_state', None)
        self.reserved_instance_count = kwargs.get('reserved_instance_count', None)


class SiteLimits(Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = kwargs.get('max_percentage_cpu', None)
        self.max_memory_in_mb = kwargs.get('max_memory_in_mb', None)
        self.max_disk_size_in_mb = kwargs.get('max_disk_size_in_mb', None)


class SiteMachineKey(Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = kwargs.get('validation', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.decryption = kwargs.get('decryption', None)
        self.decryption_key = kwargs.get('decryption_key', None)


class SkuCapacity(Model):
    """Description of the App Service plan scale options.

    :param minimum: Minimum number of workers for this App Service plan SKU.
    :type minimum: int
    :param maximum: Maximum number of workers for this App Service plan SKU.
    :type maximum: int
    :param default: Default number of workers for this App Service plan SKU.
    :type default: int
    :param scale_type: Available scale configurations for an App Service plan.
    :type scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.default = kwargs.get('default', None)
        self.scale_type = kwargs.get('scale_type', None)


class SkuDescription(Model):
    """Description of a SKU for a scalable resource.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Current number of instances assigned to the resource.
    :type capacity: int
    :param sku_capacity: Min, max, and default scale values of the SKU.
    :type sku_capacity: ~azure.mgmt.web.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager
     enabled?
    :type capabilities: list[~azure.mgmt.web.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(self, **kwargs):
        super(SkuDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
        self.sku_capacity = kwargs.get('sku_capacity', None)
        self.locations = kwargs.get('locations', None)
        self.capabilities = kwargs.get('capabilities', None)


class SlotSwapStatus(Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap
     operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = kwargs.get('time_taken', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Snapshot, self).__init__(**kwargs)
        self.time = None


class StatusCodesBasedTrigger(Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.sub_status = kwargs.get('sub_status', None)
        self.win32_status = kwargs.get('win32_status', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param publishing_user_name: Required. Username used for publishing.
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing.
    :type publishing_password: str
    :param publishing_password_hash: Password hash used for publishing.
    :type publishing_password_hash: str
    :param publishing_password_hash_salt: Password hash salt used for
     publishing.
    :type publishing_password_hash_salt: str
    :param scm_uri: Url of SCM site.
    :type scm_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'publishing_user_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
        'scm_uri': {'key': 'properties.scmUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(User, self).__init__(**kwargs)
        self.publishing_user_name = kwargs.get('publishing_user_name', None)
        self.publishing_password = kwargs.get('publishing_password', None)
        self.publishing_password_hash = kwargs.get('publishing_password_hash', None)
        self.publishing_password_hash_salt = kwargs.get('publishing_password_hash_salt', None)
        self.scm_uri = kwargs.get('scm_uri', None)


class VirtualApplication(Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: <code>true</code> if preloading is enabled;
     otherwise, <code>false</code>.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories: list[~azure.mgmt.web.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(self, **kwargs):
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)
        self.preload_enabled = kwargs.get('preload_enabled', None)
        self.virtual_directories = kwargs.get('virtual_directories', None)


class VirtualDirectory(Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual
    Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: Required. The URI where the VPN package can be
     downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'vpn_package_uri': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VnetGateway, self).__init__(**kwargs)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vpn_package_uri = kwargs.get('vpn_package_uri', None)


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key
     of the private key used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: str
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.models.VnetRoute]
    :ivar resync_required: <code>true</code> if a resync is required;
     otherwise, <code>false</code>.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This
     should be a comma-separated list of IP addresses.
    :type dns_servers: str
    :param is_swift: Flag that is used to denote if this is VNET injection
    :type is_swift: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
        'is_swift': {'key': 'properties.isSwift', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VnetInfo, self).__init__(**kwargs)
        self.vnet_resource_id = kwargs.get('vnet_resource_id', None)
        self.cert_thumbprint = None
        self.cert_blob = kwargs.get('cert_blob', None)
        self.routes = None
        self.resync_required = None
        self.dns_servers = kwargs.get('dns_servers', None)
        self.is_swift = kwargs.get('is_swift', None)


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a
    Virtual Network.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_address: The starting address for this route. This may also
     include a CIDR notation, in which case the end address must not be
     specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start
     address is specified in CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges
     specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
     These values will be used for syncing an app's routes with those from a
     Virtual Network. Possible values include: 'DEFAULT', 'INHERITED', 'STATIC'
    :type route_type: str or ~azure.mgmt.web.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VnetRoute, self).__init__(**kwargs)
        self.start_address = kwargs.get('start_address', None)
        self.end_address = kwargs.get('end_address', None)
        self.route_type = kwargs.get('route_type', None)
