/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Element;
import be.re.css.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class InvalidPropertyFilter
extends XMLFilterImpl {
    private static final Set after = new HashSet<String>(Arrays.asList("change-bar-class", "content"));
    private static final Set alwaysValid = new HashSet<String>(Arrays.asList("background-attachment", "background-color", "background-image", "background-repeat", "border-top-color", "border-right-color", "border-bottom-color", "border-left-color", "border-top-style", "border-right-style", "border-bottom-style", "border-left-style", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "color", "counter-increment", "counter-reset", "direction", "display", "font", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "letter-spacing", "line-height", "margin-top", "margin-right", "margin-bottom", "margin-left", "padding-top", "padding-right", "padding-bottom", "padding-left", "position", "quotes", "region", "string-set", "text-decoration", "text-shadow", "text-transform", "unicode-bidi", "visibility", "word-spacing", "has-first-letter", "has-markers", "list-label-width"));
    private static final Set before = new HashSet<String>(Arrays.asList("change-bar-class", "change-bar-color", "change-bar-offset", "change-bar-placement", "change-bar-style", "change-bar-width", "content"));
    private static final Set blockLevel = new HashSet<String>(Arrays.asList("anchor", "background-position", "clear", "clip", "hyphenate", "link", "orphans", "overflow", "page", "page-break-after", "page-break-before", "page-break-inside", "text-align", "text-align-last", "text-indent", "white-space", "widows"));
    private static final Set blockLevelNotTable = new HashSet<String>(Arrays.asList("column-span"));
    private static final Set blockOrTableOrTableCell = new HashSet<String>(Arrays.asList("orientation"));
    private static final Set graphic = new HashSet<String>(Arrays.asList("background-position", "content-height", "content-type", "content-width", "height", "max-height", "max-width", "min-height", "min-width", "overflow", "scaling", "scaling-method", "src", "width"));
    private static final Set inline = new HashSet<String>(Arrays.asList("anchor", "hyphenate", "link", "vertical-align"));
    private static final Set leader = new HashSet<String>(Arrays.asList("leader-alignment", "leader-length", "leader-pattern", "leader-pattern-width", "rule-thickness"));
    private static final Set listItem = new HashSet<String>(Arrays.asList("list-style", "list-style-image", "list-style-position", "list-style-type"));
    private static final Set marker = new HashSet<String>(Arrays.asList("marker-offset"));
    private static final Set notInlineOrTable = new HashSet<String>(Arrays.asList("max-height", "max-width", "min-height", "min-width"));
    private static final Set notInlineOrTableColumnOrColumnGroup = new HashSet<String>(Arrays.asList("height"));
    private static final Set notInlineOrTableRowOrRowGroup = new HashSet<String>(Arrays.asList("width"));
    private static final Set notPositioned = new HashSet<String>(Arrays.asList("float"));
    private static final Set positioned = new HashSet<String>(Arrays.asList("bottom", "left", "right", "top", "z-index"));
    private static final Set table = new HashSet<String>(Arrays.asList("border-collapse", "border-spacing", "caption-side", "empty-cells", "table-layout", "table-omit-footer-at-break", "table-omit-header-at-break"));
    private static final Set tableCaption = new HashSet<String>(Arrays.asList("caption-side"));
    private static final Set tableCell = new HashSet<String>(Arrays.asList("colspan", "empty-cells", "rowspan", "vertical-align"));

    InvalidPropertyFilter() {
    }

    InvalidPropertyFilter(XMLReader parent) {
        super(parent);
    }

    private static boolean isBlockLevel(String display) {
        return display == Element.BLOCK || display == Element.COMPACT || display == Element.LIST_ITEM || display == Element.RUN_IN || display == Element.TABLE || display == Element.TABLE_CELL || display == Element.TABLE_ROW || display == Element.MARKER;
    }

    private static boolean isInline(String display) {
        return display == Element.INLINE || display == Element.GRAPHIC || display == Element.LEADER;
    }

    private static boolean isPositioned(Attributes atts) {
        String value = atts.getValue(Constants.CSS, "position");
        return value != null && !"static".equals(value);
    }

    private static boolean isValid(Attributes atts, int index, String display, boolean isBefore, boolean isAfter, boolean isPositioned) {
        String localName = atts.getLocalName(index);
        return !Constants.CSS.equals(atts.getURI(index)) || alwaysValid.contains(localName) || Util.isInherited(localName) || InvalidPropertyFilter.isBlockLevel(display) && blockLevel.contains(localName) || display == Element.LIST_ITEM && listItem.contains(localName) || (display == Element.TABLE || display == Element.INLINE_TABLE) && table.contains(localName) || display == Element.TABLE_CAPTION && tableCaption.contains(localName) || display == Element.TABLE_CELL && tableCell.contains(localName) || InvalidPropertyFilter.isInline(display) && inline.contains(localName) || !InvalidPropertyFilter.isInline(display) && display != Element.TABLE && notInlineOrTable.contains(localName) || !InvalidPropertyFilter.isInline(display) && display != Element.TABLE_COLUMN && display != Element.TABLE_COLUMN_GROUP && notInlineOrTableColumnOrColumnGroup.contains(localName) || !InvalidPropertyFilter.isInline(display) && display != Element.TABLE_ROW && display != Element.TABLE_ROW_GROUP && notInlineOrTableRowOrRowGroup.contains(localName) || display != Element.TABLE && InvalidPropertyFilter.isBlockLevel(display) && blockLevelNotTable.contains(localName) || display == Element.MARKER && marker.contains(localName) || display == Element.GRAPHIC && graphic.contains(localName) || display == Element.LEADER && leader.contains(localName) || (display == Element.BLOCK || display == Element.TABLE || display == Element.TABLE_CELL) && blockOrTableOrTableCell.contains(localName) || isAfter && after.contains(localName) || isBefore && before.contains(localName) || isPositioned && positioned.contains(localName) || !isPositioned && notPositioned.contains(localName);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String display = atts.getValue(Constants.CSS, "display");
        if (display == null || Constants.CSS.equals(namespaceURI) && !"after".equals(localName) && !"before".equals(localName)) {
            super.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        display = display.intern();
        boolean after = Constants.CSS.equals(namespaceURI) && "after".equals(localName);
        boolean before = Constants.CSS.equals(namespaceURI) && "before".equals(localName);
        AttributesImpl newAtts = new AttributesImpl();
        boolean positioned = InvalidPropertyFilter.isPositioned(atts);
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!InvalidPropertyFilter.isValid(atts, i, display, before, after, positioned)) continue;
            newAtts.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        super.startElement(namespaceURI, localName, qName, newAtts);
    }
}

