# PySNMP SMI module. Autogenerated from smidump -f python ENTITY-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:56 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( AutonomousType, DateAndTime, RowPointer, TAddress, TDomain, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "DateAndTime", "RowPointer", "TAddress", "TDomain", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class PhysicalClass(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(9,3,7,10,5,2,6,11,1,4,8,12,)
    namedValues = NamedValues(("other", 1), ("port", 10), ("stack", 11), ("cpu", 12), ("unknown", 2), ("chassis", 3), ("backplane", 4), ("container", 5), ("powerSupply", 6), ("fan", 7), ("sensor", 8), ("module", 9), )
    
class PhysicalIndex(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,2147483647)
    
class PhysicalIndexOrZero(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)
    
class SnmpEngineIdOrNone(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,32)
    

# Objects

entityMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 47)).setRevisions(("2005-08-10 00:00","1999-12-07 00:00","1996-10-31 00:00",))
if mibBuilder.loadTexts: entityMIB.setOrganization("IETF ENTMIB Working Group")
if mibBuilder.loadTexts: entityMIB.setContactInfo("        WG E-mail: entmib@ietf.org\nMailing list subscription info:\n  http://www.ietf.org/mailman/listinfo/entmib\n\nAndy Bierman\nietf@andybierman.com\n\nKeith McCloghrie\nCisco Systems Inc.\n170 West Tasman Drive\nSan Jose, CA 95134\n\n\n\n+1 408-526-5260\nkzm@cisco.com")
if mibBuilder.loadTexts: entityMIB.setDescription("The MIB module for representing multiple logical\nentities supported by a single SNMP agent.\n\nCopyright (C) The Internet Society (2005).  This\nversion of this MIB module is part of RFC 4133; see\nthe RFC itself for full legal notices.")
entityMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1))
entityPhysical = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 1))
entPhysicalTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 1, 1))
if mibBuilder.loadTexts: entPhysicalTable.setDescription("This table contains one row per physical base_entity.  There is\nalways at least one row for an 'overall' physical base_entity.")
entPhysicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1)).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"))
if mibBuilder.loadTexts: entPhysicalEntry.setDescription("Information about a particular physical base_entity.\n\nEach entry provides objects (entPhysicalDescr,\nentPhysicalVendorType, and entPhysicalClass) to help an NMS\nidentify and characterize the entry, and objects\n(entPhysicalContainedIn and entPhysicalParentRelPos) to help\nan NMS relate the particular entry to other entries in this\ntable.")
entPhysicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 1), PhysicalIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: entPhysicalIndex.setDescription("The index for this entry.")
entPhysicalDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalDescr.setDescription("A textual description of physical base_entity.  This object\nshould contain a string that identifies the manufacturer's\nname for the physical base_entity, and should be set to a\ndistinct value for each version or model of the physical\nbase_entity.")
entPhysicalVendorType = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalVendorType.setDescription("An indication of the vendor-specific hardware type of the\nphysical base_entity.  Note that this is different from the\ndefinition of MIB-II's sysObjectID.\n\nAn agent should set this object to an enterprise-specific\nregistration identifier value indicating the specific\nequipment type in detail.  The associated instance of\nentPhysicalClass is used to indicate the general type of\nhardware device.\n\nIf no vendor-specific registration identifier exists for\nthis physical base_entity, or the value is unknown by this agent,\nthen the value { 0 0 } is returned.")
entPhysicalContainedIn = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 4), PhysicalIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalContainedIn.setDescription("The value of entPhysicalIndex for the physical base_entity which\n'contains' this physical base_entity.  A value of zero indicates\nthis physical base_entity is not contained in any other physical\nbase_entity.  Note that the set of 'containment' relationships\ndefine a strict hierarchy; that is, recursion is not\nallowed.\n\nIn the event that a physical base_entity is contained by more\nthan one physical base_entity (e.g., double-wide modules), this\nobject should identify the containing base_entity with the lowest\nvalue of entPhysicalIndex.")
entPhysicalClass = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 5), PhysicalClass()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalClass.setDescription("An indication of the general hardware type of the physical\nbase_entity.\n\nAn agent should set this object to the standard enumeration\nvalue that most accurately indicates the general class of\nthe physical base_entity, or the primary class if there is more\nthan one base_entity.\n\nIf no appropriate standard registration identifier exists\nfor this physical base_entity, then the value 'other(1)' is\nreturned.  If the value is unknown by this agent, then the\nvalue 'unknown(2)' is returned.")
entPhysicalParentRelPos = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalParentRelPos.setDescription("An indication of the relative position of this 'child'\ncomponent among all its 'sibling' components.  Sibling\ncomponents are defined as entPhysicalEntries that share the\nsame instance values of each of the entPhysicalContainedIn\nand entPhysicalClass objects.\n\nAn NMS can use this object to identify the relative ordering\nfor all sibling components of a particular parent\n(identified by the entPhysicalContainedIn instance in each\nsibling entry).\n\nIf possible, this value should match any external labeling\nof the physical component.  For example, for a container\n(e.g., card slot) labeled as 'slot #3',\nentPhysicalParentRelPos should have the value '3'.  Note\nthat the entPhysicalEntry for the module plugged in slot 3\nshould have an entPhysicalParentRelPos value of '1'.\n\nIf the physical position of this component does not match\nany external numbering or clearly visible ordering, then\nuser documentation or other external reference material\nshould be used to determine the parent-relative position.\nIf this is not possible, then the agent should assign a\nconsistent (but possibly arbitrary) ordering to a given set\nof 'sibling' components, perhaps based on internal\nrepresentation of the components.\n\n\n\n\nIf the agent cannot determine the parent-relative position\nfor some reason, or if the associated value of\nentPhysicalContainedIn is '0', then the value '-1' is\nreturned.  Otherwise, a non-negative integer is returned,\nindicating the parent-relative position of this physical\nbase_entity.\n\nParent-relative ordering normally starts from '1' and\ncontinues to 'N', where 'N' represents the highest\npositioned child base_entity.  However, if the physical entities\n(e.g., slots) are labeled from a starting position of zero,\nthen the first sibling should be associated with an\nentPhysicalParentRelPos value of '0'.  Note that this\nordering may be sparse or dense, depending on agent\nimplementation.\n\nThe actual values returned are not globally meaningful, as\neach 'parent' component may use different numbering\nalgorithms.  The ordering is only meaningful among siblings\nof the same parent component.\n\nThe agent should retain parent-relative position values\nacross reboots, either through algorithmic assignment or use\nof non-volatile storage.")
entPhysicalName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 7), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalName.setDescription("The textual name of the physical base_entity.  The value of this\nobject should be the name of the component as assigned by\nthe local device and should be suitable for use in commands\nentered at the device's `console'.  This might be a text\nname (e.g., `console') or a simple component number (e.g.,\nport or module number, such as `1'), depending on the\nphysical component naming syntax of the device.\n\nIf there is no local name, or if this object is otherwise\nnot applicable, then this object contains a zero-length\nstring.\n\nNote that the value of entPhysicalName for two physical\nentities will be the same in the event that the console\ninterface does not distinguish between them, e.g., slot-1\nand the card in slot-1.")
entPhysicalHardwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalHardwareRev.setDescription("The vendor-specific hardware revision string for the\nphysical base_entity.  The preferred value is the hardware\nrevision identifier actually printed on the component itself\n(if present).\n\nNote that if revision information is stored internally in a\nnon-printable (e.g., binary) format, then the agent must\nconvert such information to a printable format, in an\nimplementation-specific manner.\n\nIf no specific hardware revision string is associated with\nthe physical component, or if this information is unknown to\nthe agent, then this object will contain a zero-length\nstring.")
entPhysicalFirmwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalFirmwareRev.setDescription("The vendor-specific firmware revision string for the\nphysical base_entity.\n\nNote that if revision information is stored internally in a\nnon-printable (e.g., binary) format, then the agent must\nconvert such information to a printable format, in an\nimplementation-specific manner.\n\nIf no specific firmware programs are associated with the\nphysical component, or if this information is unknown to the\nagent, then this object will contain a zero-length string.")
entPhysicalSoftwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalSoftwareRev.setDescription("The vendor-specific software revision string for the\nphysical base_entity.\n\nNote that if revision information is stored internally in a\n\n\n\nnon-printable (e.g., binary) format, then the agent must\nconvert such information to a printable format, in an\nimplementation-specific manner.\n\nIf no specific software programs are associated with the\nphysical component, or if this information is unknown to the\nagent, then this object will contain a zero-length string.")
entPhysicalSerialNum = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 11), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalSerialNum.setDescription("The vendor-specific serial number string for the physical\nbase_entity.  The preferred value is the serial number string\nactually printed on the component itself (if present).\n\nOn the first instantiation of an physical base_entity, the value\nof entPhysicalSerialNum associated with that base_entity is set\nto the correct vendor-assigned serial number, if this\ninformation is available to the agent.  If a serial number\nis unknown or non-existent, the entPhysicalSerialNum will be\nset to a zero-length string instead.\n\nNote that implementations that can correctly identify the\nserial numbers of all installed physical entities do not\nneed to provide write access to the entPhysicalSerialNum\nobject.  Agents which cannot provide non-volatile storage\nfor the entPhysicalSerialNum strings are not required to\nimplement write access for this object.\n\nNot every physical component will have a serial number, or\neven need one.  Physical entities for which the associated\nvalue of the entPhysicalIsFRU object is equal to 'false(2)'\n(e.g., the repeater ports within a repeater module), do not\nneed their own unique serial number.  An agent does not have\nto provide write access for such entities, and may return a\nzero-length string.\n\nIf write access is implemented for an instance of\nentPhysicalSerialNum, and a value is written into the\ninstance, the agent must retain the supplied value in the\nentPhysicalSerialNum instance (associated with the same\nphysical base_entity) for as long as that base_entity remains\ninstantiated.  This includes instantiations across all\nre-initializations/reboots of the network management system,\nincluding those resulting in a change of the physical\n\n\n\nbase_entity's entPhysicalIndex value.")
entPhysicalMfgName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 12), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalMfgName.setDescription("The name of the manufacturer of this physical component.\nThe preferred value is the manufacturer name string actually\nprinted on the component itself (if present).\n\nNote that comparisons between instances of the\nentPhysicalModelName, entPhysicalFirmwareRev,\nentPhysicalSoftwareRev, and the entPhysicalSerialNum\nobjects, are only meaningful amongst entPhysicalEntries with\nthe same value of entPhysicalMfgName.\n\nIf the manufacturer name string associated with the physical\ncomponent is unknown to the agent, then this object will\ncontain a zero-length string.")
entPhysicalModelName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 13), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalModelName.setDescription("The vendor-specific model name identifier string associated\nwith this physical component.  The preferred value is the\ncustomer-visible part number, which may be printed on the\ncomponent itself.\n\nIf the model name string associated with the physical\ncomponent is unknown to the agent, then this object will\ncontain a zero-length string.")
entPhysicalAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 14), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalAlias.setDescription("This object is an 'alias' name for the physical base_entity, as\nspecified by a network manager, and provides a non-volatile\n'handle' for the physical base_entity.\n\nOn the first instantiation of a physical base_entity, the value\n\n\n\nof entPhysicalAlias associated with that base_entity is set to\nthe zero-length string.  However, the agent may set the\nvalue to a locally unique default value, instead of a\nzero-length string.\n\nIf write access is implemented for an instance of\nentPhysicalAlias, and a value is written into the instance,\nthe agent must retain the supplied value in the\nentPhysicalAlias instance (associated with the same physical\nbase_entity) for as long as that base_entity remains instantiated.\nThis includes instantiations across all\nre-initializations/reboots of the network management system,\nincluding those resulting in a change of the physical\nbase_entity's entPhysicalIndex value.")
entPhysicalAssetID = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 15), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalAssetID.setDescription("This object is a user-assigned asset tracking identifier\n(as specified by a network manager) for the physical base_entity,\nand provides non-volatile storage of this information.\n\nOn the first instantiation of a physical base_entity, the value\nof entPhysicalAssetID associated with that base_entity is set to\nthe zero-length string.\n\nNot every physical component will have an asset tracking\nidentifier, or even need one.  Physical entities for which\nthe associated value of the entPhysicalIsFRU object is equal\nto 'false(2)' (e.g., the repeater ports within a repeater\nmodule), do not need their own unique asset tracking\nidentifier.  An agent does not have to provide write access\nfor such entities, and may instead return a zero-length\nstring.\n\nIf write access is implemented for an instance of\nentPhysicalAssetID, and a value is written into the\ninstance, the agent must retain the supplied value in the\nentPhysicalAssetID instance (associated with the same\nphysical base_entity) for as long as that base_entity remains\ninstantiated.  This includes instantiations across all\nre-initializations/reboots of the network management system,\nincluding those resulting in a change of the physical\nbase_entity's entPhysicalIndex value.\n\n\n\n\nIf no asset tracking information is associated with the\nphysical component, then this object will contain a\nzero-length string.")
entPhysicalIsFRU = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalIsFRU.setDescription("This object indicates whether or not this physical base_entity\nis considered a 'field replaceable unit' by the vendor.  If\nthis object contains the value 'true(1)' then this\nentPhysicalEntry identifies a field replaceable unit.  For\nall entPhysicalEntries that represent components\npermanently contained within a field replaceable unit, the\nvalue 'false(2)' should be returned for this object.")
entPhysicalMfgDate = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 17), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalMfgDate.setDescription("This object contains the date of manufacturing of the\nmanaged base_entity.  If the manufacturing date is unknown or not\nsupported, the object is not instantiated.  The special\nvalue '0000000000000000'H may also be returned in this\ncase.")
entPhysicalUris = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 18), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalUris.setDescription("This object contains additional identification information\nabout the physical base_entity.  The object contains URIs and,\ntherefore, the syntax of this object must conform to RFC\n3986, section 2.\n\nMultiple URIs may be present and are separated by white\nspace characters.  Leading and trailing white space\ncharacters are ignored.\n\nIf no additional identification information is known\nabout the physical base_entity or supported, the object is not\ninstantiated.  A zero length octet string may also be\n\n\n\nreturned in this case.")
entityLogical = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 2))
entLogicalTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 2, 1))
if mibBuilder.loadTexts: entLogicalTable.setDescription("This table contains one row per logical base_entity.  For agents\nthat implement more than one naming scope, at least one\nentry must exist.  Agents which instantiate all MIB objects\nwithin a single naming scope are not required to implement\nthis table.")
entLogicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1)).setIndexNames((0, "ENTITY-MIB", "entLogicalIndex"))
if mibBuilder.loadTexts: entLogicalEntry.setDescription("Information about a particular logical base_entity.  Entities\nmay be managed by this agent or other SNMP agents (possibly)\nin the same chassis.")
entLogicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: entLogicalIndex.setDescription("The value of this object uniquely identifies the logical\nbase_entity.  The value should be a small positive integer; index\nvalues for different logical entities are not necessarily\ncontiguous.")
entLogicalDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalDescr.setDescription("A textual description of the logical base_entity.  This object\nshould contain a string that identifies the manufacturer's\nname for the logical base_entity, and should be set to a distinct\nvalue for each version of the logical base_entity.")
entLogicalType = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalType.setDescription("An indication of the type of logical base_entity.  This will\ntypically be the OBJECT IDENTIFIER name of the node in the\nSMI's naming hierarchy which represents the major MIB\nmodule, or the majority of the MIB modules, supported by the\nlogical base_entity.  For example:\n   a logical base_entity of a regular host/router -> mib-2\n   a logical base_entity of a 802.1d bridge -> dot1dBridge\n   a logical base_entity of a 802.3 repeater -> snmpDot3RptrMgmt\nIf an appropriate node in the SMI's naming hierarchy cannot\nbe identified, the value 'mib-2' should be used.")
entLogicalCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalCommunity.setDescription("An SNMPv1 or SNMPv2C community-string, which can be used to\naccess detailed management information for this logical\nbase_entity.  The agent should allow read access with this\ncommunity string (to an appropriate subset of all managed\nobjects) and may also return a community string based on the\nprivileges of the request used to read this object.  Note\nthat an agent may return a community string with read-only\nprivileges, even if this object is accessed with a\nread-write community string.  However, the agent must take\n\n\n\ncare not to return a community string that allows more\nprivileges than the community string used to access this\nobject.\n\nA compliant SNMP agent may wish to conserve naming scopes by\nrepresenting multiple logical entities in a single 'default'\nnaming scope.  This is possible when the logical entities,\nrepresented by the same value of entLogicalCommunity, have\nno object instances in common.  For example, 'bridge1' and\n'repeater1' may be part of the main naming scope, but at\nleast one additional community string is needed to represent\n'bridge2' and 'repeater2'.\n\nLogical entities 'bridge1' and 'repeater1' would be\nrepresented by sysOREntries associated with the 'default'\nnaming scope.\n\nFor agents not accessible via SNMPv1 or SNMPv2C, the value\nof this object is the empty string.  This object may also\ncontain an empty string if a community string has not yet\nbeen assigned by the agent, or if no community string with\nsuitable access rights can be returned for a particular SNMP\nrequest.\n\nNote that this object is deprecated.  Agents which implement\nSNMPv3 access should use the entLogicalContextEngineID and\nentLogicalContextName objects to identify the context\nassociated with each logical base_entity.  SNMPv3 agents may\nreturn a zero-length string for this object, or may continue\nto return a community string (e.g., tri-lingual agent\nsupport).")
entLogicalTAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 5), TAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalTAddress.setDescription("The transport service address by which the logical base_entity\nreceives network management traffic, formatted according to\nthe corresponding value of entLogicalTDomain.\n\nFor snmpUDPDomain, a TAddress is 6 octets long: the initial\n4 octets contain the IP-address in network-byte order and\nthe last 2 contain the UDP port in network-byte order.\nConsult 'Transport Mappings for the Simple Network\nManagement Protocol' (STD 62, RFC 3417 [RFC3417]) for\nfurther information on snmpUDPDomain.")
entLogicalTDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 6), TDomain()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalTDomain.setDescription("Indicates the kind of transport service by which the\nlogical base_entity receives network management traffic.\nPossible values for this object are presently found in the\nTransport Mappings for Simple Network Management Protocol'\n(STD 62, RFC 3417 [RFC3417]).")
entLogicalContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 7), SnmpEngineIdOrNone()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalContextEngineID.setDescription("The authoritative contextEngineID that can be used to send\nan SNMP message concerning information held by this logical\nbase_entity, to the address specified by the associated\n'entLogicalTAddress/entLogicalTDomain' pair.\n\nThis object, together with the associated\nentLogicalContextName object, defines the context associated\nwith a particular logical base_entity, and allows access to SNMP\nengines identified by a contextEngineId and contextName\npair.\n\nIf no value has been configured by the agent, a zero-length\nstring is returned, or the agent may choose not to\ninstantiate this object at all.")
entLogicalContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalContextName.setDescription("The contextName that can be used to send an SNMP message\nconcerning information held by this logical base_entity, to the\naddress specified by the associated\n'entLogicalTAddress/entLogicalTDomain' pair.\n\nThis object, together with the associated\nentLogicalContextEngineID object, defines the context\nassociated with a particular logical base_entity, and allows\n\n\n\naccess to SNMP engines identified by a contextEngineId and\ncontextName pair.\n\nIf no value has been configured by the agent, a zero-length\nstring is returned, or the agent may choose not to\ninstantiate this object at all.")
entityMapping = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 3))
entLPMappingTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 1))
if mibBuilder.loadTexts: entLPMappingTable.setDescription("This table contains zero or more rows of logical base_entity to\nphysical equipment associations.  For each logical base_entity\nknown by this agent, there are zero or more mappings to the\nphysical resources, which are used to realize that logical\nbase_entity.\n\nAn agent should limit the number and nature of entries in\nthis table such that only meaningful and non-redundant\ninformation is returned.  For example, in a system that\ncontains a single power supply, mappings between logical\nentities and the power supply are not useful and should not\nbe included.\n\nAlso, only the most appropriate physical component, which is\nclosest to the root of a particular containment tree, should\nbe identified in an entLPMapping entry.\n\nFor example, suppose a bridge is realized on a particular\nmodule, and all ports on that module are ports on this\nbridge.  A mapping between the bridge and the module would\nbe useful, but additional mappings between the bridge and\neach of the ports on that module would be redundant (because\nthe entPhysicalContainedIn hierarchy can provide the same\ninformation).  On the other hand, if more than one bridge\nwere utilizing ports on this module, then mappings between\neach bridge and the ports it used would be appropriate.\n\nAlso, in the case of a single backplane repeater, a mapping\nfor the backplane to the single repeater base_entity is not\nnecessary.")
entLPMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1)).setIndexNames((0, "ENTITY-MIB", "entLogicalIndex"), (0, "ENTITY-MIB", "entLPPhysicalIndex"))
if mibBuilder.loadTexts: entLPMappingEntry.setDescription("Information about a particular logical base_entity to physical\nequipment association.  Note that the nature of the\nassociation is not specifically identified in this entry.\nIt is expected that sufficient information exists in the\nMIBs used to manage a particular logical base_entity to infer how\nphysical component information is utilized.")
entLPPhysicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1, 1), PhysicalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLPPhysicalIndex.setDescription("The value of this object identifies the index value of a\nparticular entPhysicalEntry associated with the indicated\nentLogicalEntity.")
entAliasMappingTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 2))
if mibBuilder.loadTexts: entAliasMappingTable.setDescription("This table contains zero or more rows, representing\nmappings of logical base_entity and physical component to\nexternal MIB identifiers.  Each physical port in the system\nmay be associated with a mapping to an external identifier,\nwhich itself is associated with a particular logical\nbase_entity's naming scope.  A 'wildcard' mechanism is provided\nto indicate that an identifier is associated with more than\none logical base_entity.")
entAliasMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1)).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"), (0, "ENTITY-MIB", "entAliasLogicalIndexOrZero"))
if mibBuilder.loadTexts: entAliasMappingEntry.setDescription("Information about a particular physical equipment, logical\n\n\n\nbase_entity to external identifier binding.  Each logical\nbase_entity/physical component pair may be associated with one\nalias mapping.  The logical base_entity index may also be used as\na 'wildcard' (refer to the entAliasLogicalIndexOrZero object\nDESCRIPTION clause for details.)\n\nNote that only entPhysicalIndex values that represent\nphysical ports (i.e., associated entPhysicalClass value is\n'port(10)') are permitted to exist in this table.")
entAliasLogicalIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: entAliasLogicalIndexOrZero.setDescription("The value of this object identifies the logical base_entity\nthat defines the naming scope for the associated instance\nof the 'entAliasMappingIdentifier' object.\n\nIf this object has a non-zero value, then it identifies the\nlogical base_entity named by the same value of entLogicalIndex.\n\nIf this object has a value of zero, then the mapping between\nthe physical component and the alias identifier for this\nentAliasMapping entry is associated with all unspecified\nlogical entities.  That is, a value of zero (the default\nmapping) identifies any logical base_entity that does not have\nan explicit entry in this table for a particular\nentPhysicalIndex/entAliasMappingIdentifier pair.\n\nFor example, to indicate that a particular interface (e.g.,\nphysical component 33) is identified by the same value of\nifIndex for all logical entities, the following instance\nmight exist:\n\n        entAliasMappingIdentifier.33.0 = ifIndex.5\n\nIn the event an entPhysicalEntry is associated differently\nfor some logical entities, additional entAliasMapping\nentries may exist, e.g.:\n\n\n\n\n        entAliasMappingIdentifier.33.0 = ifIndex.6\n        entAliasMappingIdentifier.33.4 =  ifIndex.1\n        entAliasMappingIdentifier.33.5 =  ifIndex.1\n        entAliasMappingIdentifier.33.10 = ifIndex.12\n\nNote that entries with non-zero entAliasLogicalIndexOrZero\nindex values have precedence over zero-indexed entries.  In\nthis example, all logical entities except 4, 5, and 10,\nassociate physical base_entity 33 with ifIndex.6.")
entAliasMappingIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1, 2), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entAliasMappingIdentifier.setDescription("The value of this object identifies a particular conceptual\nrow associated with the indicated entPhysicalIndex and\nentLogicalIndex pair.\n\nBecause only physical ports are modeled in this table, only\nentries that represent interfaces or ports are allowed.  If\nan ifEntry exists on behalf of a particular physical port,\nthen this object should identify the associated 'ifEntry'.\nFor repeater ports, the appropriate row in the\n'rptrPortGroupTable' should be identified instead.\n\nFor example, suppose a physical port was represented by\nentPhysicalEntry.3, entLogicalEntry.15 existed for a\nrepeater, and entLogicalEntry.22 existed for a bridge.  Then\nthere might be two related instances of\nentAliasMappingIdentifier:\n   entAliasMappingIdentifier.3.15 == rptrPortGroupIndex.5.2\n   entAliasMappingIdentifier.3.22 == ifIndex.17\nIt is possible that other mappings (besides interfaces and\nrepeater ports) may be defined in the future, as required.\n\nBridge ports are identified by examining the Bridge MIB and\nappropriate ifEntries associated with each 'dot1dBasePort',\nand are thus not represented in this table.")
entPhysicalContainsTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 3))
if mibBuilder.loadTexts: entPhysicalContainsTable.setDescription("A table that exposes the container/'containee'\nrelationships between physical entities.  This table\nprovides all the information found by constructing the\nvirtual containment tree for a given entPhysicalTable, but\nin a more direct format.\n\nIn the event a physical base_entity is contained by more than one\nother physical base_entity (e.g., double-wide modules), this\ntable should include these additional mappings, which cannot\nbe represented in the entPhysicalTable virtual containment\ntree.")
entPhysicalContainsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1)).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"), (0, "ENTITY-MIB", "entPhysicalChildIndex"))
if mibBuilder.loadTexts: entPhysicalContainsEntry.setDescription("A single container/'containee' relationship.")
entPhysicalChildIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1, 1), PhysicalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalChildIndex.setDescription("The value of entPhysicalIndex for the contained physical\nbase_entity.")
entityGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 4))
entLastChangeTime = MibScalar((1, 3, 6, 1, 2, 1, 47, 1, 4, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLastChangeTime.setDescription("The value of sysUpTime at the time a conceptual row is\ncreated, modified, or deleted in any of these tables:\n        - entPhysicalTable\n        - entLogicalTable\n        - entLPMappingTable\n        - entAliasMappingTable\n\n\n\n        - entPhysicalContainsTable")
entityMIBTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 2))
entityMIBTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 2, 0))
entityConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3))
entityCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3, 1))
entityGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3, 2))

# Augmentions

# Notifications

entConfigChange = NotificationType((1, 3, 6, 1, 2, 1, 47, 2, 0, 1)).setObjects(*() )
if mibBuilder.loadTexts: entConfigChange.setDescription("An entConfigChange notification is generated when the value\nof entLastChangeTime changes.  It can be utilized by an NMS\nto trigger logical/physical base_entity table maintenance polls.\n\nAn agent should not generate more than one entConfigChange\n'notification-event' in a given time interval (five seconds\nis the suggested default).  A 'notification-event' is the\ntransmission of a single trap or inform PDU to a list of\nnotification destinations.\n\nIf additional configuration changes occur within the\nthrottling period, then notification-events for these\nchanges should be suppressed by the agent until the current\nthrottling period expires.  At the end of a throttling\nperiod, one notification-event should be generated if any\nconfiguration changes occurred since the start of the\nthrottling period.  In such a case, another throttling\nperiod is started right away.\n\nAn NMS should periodically check the value of\nentLastChangeTime to detect any missed entConfigChange\nnotification-events, e.g., due to throttling or transmission\nloss.")

# Groups

entityPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 1)).setObjects(*(("ENTITY-MIB", "entPhysicalParentRelPos"), ("ENTITY-MIB", "entPhysicalVendorType"), ("ENTITY-MIB", "entPhysicalClass"), ("ENTITY-MIB", "entPhysicalName"), ("ENTITY-MIB", "entPhysicalContainedIn"), ("ENTITY-MIB", "entPhysicalDescr"), ) )
if mibBuilder.loadTexts: entityPhysicalGroup.setDescription("The collection of objects used to represent physical\nsystem components, for which a single agent provides\nmanagement information.")
entityLogicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 2)).setObjects(*(("ENTITY-MIB", "entLogicalDescr"), ("ENTITY-MIB", "entLogicalCommunity"), ("ENTITY-MIB", "entLogicalType"), ("ENTITY-MIB", "entLogicalTAddress"), ("ENTITY-MIB", "entLogicalTDomain"), ) )
if mibBuilder.loadTexts: entityLogicalGroup.setDescription("The collection of objects used to represent the list of\nlogical entities, for which a single agent provides\nmanagement information.")
entityMappingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 3)).setObjects(*(("ENTITY-MIB", "entAliasMappingIdentifier"), ("ENTITY-MIB", "entLPPhysicalIndex"), ("ENTITY-MIB", "entPhysicalChildIndex"), ) )
if mibBuilder.loadTexts: entityMappingGroup.setDescription("The collection of objects used to represent the\nassociations between multiple logical entities, physical\ncomponents, interfaces, and port identifiers, for which a\nsingle agent provides management information.")
entityGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 4)).setObjects(*(("ENTITY-MIB", "entLastChangeTime"), ) )
if mibBuilder.loadTexts: entityGeneralGroup.setDescription("The collection of objects used to represent general base_entity\ninformation, for which a single agent provides management\ninformation.")
entityNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 5)).setObjects(*(("ENTITY-MIB", "entConfigChange"), ) )
if mibBuilder.loadTexts: entityNotificationsGroup.setDescription("The collection of notifications used to indicate Entity MIB\ndata consistency and general status information.")
entityPhysical2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 6)).setObjects(*(("ENTITY-MIB", "entPhysicalSoftwareRev"), ("ENTITY-MIB", "entPhysicalHardwareRev"), ("ENTITY-MIB", "entPhysicalAlias"), ("ENTITY-MIB", "entPhysicalIsFRU"), ("ENTITY-MIB", "entPhysicalSerialNum"), ("ENTITY-MIB", "entPhysicalFirmwareRev"), ("ENTITY-MIB", "entPhysicalAssetID"), ("ENTITY-MIB", "entPhysicalModelName"), ("ENTITY-MIB", "entPhysicalMfgName"), ) )
if mibBuilder.loadTexts: entityPhysical2Group.setDescription("The collection of objects used to represent physical\nsystem components, for which a single agent provides\nmanagement information.  This group augments the objects\ncontained in the entityPhysicalGroup.")
entityLogical2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 7)).setObjects(*(("ENTITY-MIB", "entLogicalTDomain"), ("ENTITY-MIB", "entLogicalType"), ("ENTITY-MIB", "entLogicalContextEngineID"), ("ENTITY-MIB", "entLogicalTAddress"), ("ENTITY-MIB", "entLogicalDescr"), ("ENTITY-MIB", "entLogicalContextName"), ) )
if mibBuilder.loadTexts: entityLogical2Group.setDescription("The collection of objects used to represent the\nlist of logical entities, for which a single SNMP base_entity\nprovides management information.")
entityPhysical3Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 8)).setObjects(*(("ENTITY-MIB", "entPhysicalMfgDate"), ("ENTITY-MIB", "entPhysicalUris"), ) )
if mibBuilder.loadTexts: entityPhysical3Group.setDescription("The collection of objects used to represent physical\nsystem components, for which a single agent provides\nmanagement information.  This group augments the objects\ncontained in the entityPhysicalGroup.")

# Compliances

entityCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 1)).setObjects(*(("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityMappingGroup"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityNotificationsGroup"), ("ENTITY-MIB", "entityLogicalGroup"), ) )
if mibBuilder.loadTexts: entityCompliance.setDescription("The compliance statement for SNMP entities that implement\nversion 1 of the Entity MIB.")
entity2Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 2)).setObjects(*(("ENTITY-MIB", "entityMappingGroup"), ("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityPhysical2Group"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityLogical2Group"), ("ENTITY-MIB", "entityNotificationsGroup"), ) )
if mibBuilder.loadTexts: entity2Compliance.setDescription("The compliance statement for SNMP entities that implement\nversion 2 of the Entity MIB.")
entity3Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 3)).setObjects(*(("ENTITY-MIB", "entityMappingGroup"), ("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityPhysical2Group"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityLogical2Group"), ("ENTITY-MIB", "entityNotificationsGroup"), ("ENTITY-MIB", "entityPhysical3Group"), ) )
if mibBuilder.loadTexts: entity3Compliance.setDescription("The compliance statement for SNMP entities that implement\nversion 3 of the Entity MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("ENTITY-MIB", PYSNMP_MODULE_ID=entityMIB)

# Types
mibBuilder.exportSymbols("ENTITY-MIB", PhysicalClass=PhysicalClass, PhysicalIndex=PhysicalIndex, PhysicalIndexOrZero=PhysicalIndexOrZero, SnmpEngineIdOrNone=SnmpEngineIdOrNone)

# Objects
mibBuilder.exportSymbols("ENTITY-MIB", entityMIB=entityMIB, entityMIBObjects=entityMIBObjects, entityPhysical=entityPhysical, entPhysicalTable=entPhysicalTable, entPhysicalEntry=entPhysicalEntry, entPhysicalIndex=entPhysicalIndex, entPhysicalDescr=entPhysicalDescr, entPhysicalVendorType=entPhysicalVendorType, entPhysicalContainedIn=entPhysicalContainedIn, entPhysicalClass=entPhysicalClass, entPhysicalParentRelPos=entPhysicalParentRelPos, entPhysicalName=entPhysicalName, entPhysicalHardwareRev=entPhysicalHardwareRev, entPhysicalFirmwareRev=entPhysicalFirmwareRev, entPhysicalSoftwareRev=entPhysicalSoftwareRev, entPhysicalSerialNum=entPhysicalSerialNum, entPhysicalMfgName=entPhysicalMfgName, entPhysicalModelName=entPhysicalModelName, entPhysicalAlias=entPhysicalAlias, entPhysicalAssetID=entPhysicalAssetID, entPhysicalIsFRU=entPhysicalIsFRU, entPhysicalMfgDate=entPhysicalMfgDate, entPhysicalUris=entPhysicalUris, entityLogical=entityLogical, entLogicalTable=entLogicalTable, entLogicalEntry=entLogicalEntry, entLogicalIndex=entLogicalIndex, entLogicalDescr=entLogicalDescr, entLogicalType=entLogicalType, entLogicalCommunity=entLogicalCommunity, entLogicalTAddress=entLogicalTAddress, entLogicalTDomain=entLogicalTDomain, entLogicalContextEngineID=entLogicalContextEngineID, entLogicalContextName=entLogicalContextName, entityMapping=entityMapping, entLPMappingTable=entLPMappingTable, entLPMappingEntry=entLPMappingEntry, entLPPhysicalIndex=entLPPhysicalIndex, entAliasMappingTable=entAliasMappingTable, entAliasMappingEntry=entAliasMappingEntry, entAliasLogicalIndexOrZero=entAliasLogicalIndexOrZero, entAliasMappingIdentifier=entAliasMappingIdentifier, entPhysicalContainsTable=entPhysicalContainsTable, entPhysicalContainsEntry=entPhysicalContainsEntry, entPhysicalChildIndex=entPhysicalChildIndex, entityGeneral=entityGeneral, entLastChangeTime=entLastChangeTime, entityMIBTraps=entityMIBTraps, entityMIBTrapPrefix=entityMIBTrapPrefix, entityConformance=entityConformance, entityCompliances=entityCompliances, entityGroups=entityGroups)

# Notifications
mibBuilder.exportSymbols("ENTITY-MIB", entConfigChange=entConfigChange)

# Groups
mibBuilder.exportSymbols("ENTITY-MIB", entityPhysicalGroup=entityPhysicalGroup, entityLogicalGroup=entityLogicalGroup, entityMappingGroup=entityMappingGroup, entityGeneralGroup=entityGeneralGroup, entityNotificationsGroup=entityNotificationsGroup, entityPhysical2Group=entityPhysical2Group, entityLogical2Group=entityLogical2Group, entityPhysical3Group=entityPhysical3Group)

# Compliances
mibBuilder.exportSymbols("ENTITY-MIB", entityCompliance=entityCompliance, entity2Compliance=entity2Compliance, entity3Compliance=entity3Compliance)
