# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageAnalysis(Model):
    """Result of AnalyzeImage operation.

    :param categories: An array indicating identified categories.
    :type categories:
     list[~azure.cognitiveservices.vision.computervision.models.Category]
    :param adult: A property scoring on whether the image is adult-oriented
     and/or racy.
    :type adult:
     ~azure.cognitiveservices.vision.computervision.models.AdultInfo
    :param color: A property scoring on color spectrums.
    :type color:
     ~azure.cognitiveservices.vision.computervision.models.ColorInfo
    :param image_type: A property indicating type of image (whether it's
     clipart or line drawing)
    :type image_type:
     ~azure.cognitiveservices.vision.computervision.models.ImageType
    :param tags: A list of tags with confidence level.
    :type tags:
     list[~azure.cognitiveservices.vision.computervision.models.ImageTag]
    :param description: Description of the image.
    :type description:
     ~azure.cognitiveservices.vision.computervision.models.ImageDescriptionDetails
    :param faces: An array of possible faces within the image.
    :type faces:
     list[~azure.cognitiveservices.vision.computervision.models.FaceDescription]
    :param request_id: Id of the request for tracking purposes.
    :type request_id: str
    :param metadata: Image metadata
    :type metadata:
     ~azure.cognitiveservices.vision.computervision.models.ImageMetadata
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[Category]'},
        'adult': {'key': 'adult', 'type': 'AdultInfo'},
        'color': {'key': 'color', 'type': 'ColorInfo'},
        'image_type': {'key': 'imageType', 'type': 'ImageType'},
        'tags': {'key': 'tags', 'type': '[ImageTag]'},
        'description': {'key': 'description', 'type': 'ImageDescriptionDetails'},
        'faces': {'key': 'faces', 'type': '[FaceDescription]'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'ImageMetadata'},
    }

    def __init__(self, categories=None, adult=None, color=None, image_type=None, tags=None, description=None, faces=None, request_id=None, metadata=None):
        super(ImageAnalysis, self).__init__()
        self.categories = categories
        self.adult = adult
        self.color = color
        self.image_type = image_type
        self.tags = tags
        self.description = description
        self.faces = faces
        self.request_id = request_id
        self.metadata = metadata
