# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PriceSchedule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, apply_tax=None, apply_shipping=None, max_quantity=None, use_cumulative_quantity=None, restricted_quantity=None, order_type=None, price_breaks=None, xp=None):
        """
        PriceSchedule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'apply_tax': 'bool',
            'apply_shipping': 'bool',
            'max_quantity': 'int',
            'use_cumulative_quantity': 'bool',
            'restricted_quantity': 'bool',
            'order_type': 'str',
            'price_breaks': 'list[ShipmentItem]',
            'xp': 'object'
        }

        self.attribute_map = {
            'id': 'ID',
            'name': 'Name',
            'apply_tax': 'ApplyTax',
            'apply_shipping': 'ApplyShipping',
            'max_quantity': 'MaxQuantity',
            'use_cumulative_quantity': 'UseCumulativeQuantity',
            'restricted_quantity': 'RestrictedQuantity',
            'order_type': 'OrderType',
            'price_breaks': 'PriceBreaks',
            'xp': 'xp'
        }

        self._id = id
        self._name = name
        self._apply_tax = apply_tax
        self._apply_shipping = apply_shipping
        self._max_quantity = max_quantity
        self._use_cumulative_quantity = use_cumulative_quantity
        self._restricted_quantity = restricted_quantity
        self._order_type = order_type
        self._price_breaks = price_breaks
        self._xp = xp

    @property
    def id(self):
        """
        Gets the id of this PriceSchedule.


        :return: The id of this PriceSchedule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PriceSchedule.


        :param id: The id of this PriceSchedule.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this PriceSchedule.


        :return: The name of this PriceSchedule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PriceSchedule.


        :param name: The name of this PriceSchedule.
        :type: str
        """

        self._name = name

    @property
    def apply_tax(self):
        """
        Gets the apply_tax of this PriceSchedule.


        :return: The apply_tax of this PriceSchedule.
        :rtype: bool
        """
        return self._apply_tax

    @apply_tax.setter
    def apply_tax(self, apply_tax):
        """
        Sets the apply_tax of this PriceSchedule.


        :param apply_tax: The apply_tax of this PriceSchedule.
        :type: bool
        """

        self._apply_tax = apply_tax

    @property
    def apply_shipping(self):
        """
        Gets the apply_shipping of this PriceSchedule.


        :return: The apply_shipping of this PriceSchedule.
        :rtype: bool
        """
        return self._apply_shipping

    @apply_shipping.setter
    def apply_shipping(self, apply_shipping):
        """
        Sets the apply_shipping of this PriceSchedule.


        :param apply_shipping: The apply_shipping of this PriceSchedule.
        :type: bool
        """

        self._apply_shipping = apply_shipping

    @property
    def max_quantity(self):
        """
        Gets the max_quantity of this PriceSchedule.


        :return: The max_quantity of this PriceSchedule.
        :rtype: int
        """
        return self._max_quantity

    @max_quantity.setter
    def max_quantity(self, max_quantity):
        """
        Sets the max_quantity of this PriceSchedule.


        :param max_quantity: The max_quantity of this PriceSchedule.
        :type: int
        """

        self._max_quantity = max_quantity

    @property
    def use_cumulative_quantity(self):
        """
        Gets the use_cumulative_quantity of this PriceSchedule.


        :return: The use_cumulative_quantity of this PriceSchedule.
        :rtype: bool
        """
        return self._use_cumulative_quantity

    @use_cumulative_quantity.setter
    def use_cumulative_quantity(self, use_cumulative_quantity):
        """
        Sets the use_cumulative_quantity of this PriceSchedule.


        :param use_cumulative_quantity: The use_cumulative_quantity of this PriceSchedule.
        :type: bool
        """

        self._use_cumulative_quantity = use_cumulative_quantity

    @property
    def restricted_quantity(self):
        """
        Gets the restricted_quantity of this PriceSchedule.


        :return: The restricted_quantity of this PriceSchedule.
        :rtype: bool
        """
        return self._restricted_quantity

    @restricted_quantity.setter
    def restricted_quantity(self, restricted_quantity):
        """
        Sets the restricted_quantity of this PriceSchedule.


        :param restricted_quantity: The restricted_quantity of this PriceSchedule.
        :type: bool
        """

        self._restricted_quantity = restricted_quantity

    @property
    def order_type(self):
        """
        Gets the order_type of this PriceSchedule.


        :return: The order_type of this PriceSchedule.
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """
        Sets the order_type of this PriceSchedule.


        :param order_type: The order_type of this PriceSchedule.
        :type: str
        """

        self._order_type = order_type

    @property
    def price_breaks(self):
        """
        Gets the price_breaks of this PriceSchedule.


        :return: The price_breaks of this PriceSchedule.
        :rtype: list[ShipmentItem]
        """
        return self._price_breaks

    @price_breaks.setter
    def price_breaks(self, price_breaks):
        """
        Sets the price_breaks of this PriceSchedule.


        :param price_breaks: The price_breaks of this PriceSchedule.
        :type: list[ShipmentItem]
        """

        self._price_breaks = price_breaks

    @property
    def xp(self):
        """
        Gets the xp of this PriceSchedule.


        :return: The xp of this PriceSchedule.
        :rtype: object
        """
        return self._xp

    @xp.setter
    def xp(self, xp):
        """
        Sets the xp of this PriceSchedule.


        :param xp: The xp of this PriceSchedule.
        :type: object
        """

        self._xp = xp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
