# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class SpendingAccountApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create(self, buyer_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create(buyer_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_with_http_info(buyer_id, spending_account, **kwargs)
        else:
            (data) = self.create_with_http_info(buyer_id, spending_account, **kwargs)
            return data

    def create_with_http_info(self, buyer_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_with_http_info(buyer_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `create`")
        # verify the required parameter 'spending_account' is set
        if ('spending_account' not in params) or (params['spending_account'] is None):
            raise ValueError("Missing the required parameter `spending_account` when calling `create`")

        resource_path = '/buyers/{buyerID}/spendingaccounts'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spending_account' in params:
            body_params = params['spending_account']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_with_http_info(buyer_id, spending_account_id, **kwargs)
        else:
            (data) = self.delete_with_http_info(buyer_id, spending_account_id, **kwargs)
            return data

    def delete_with_http_info(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_with_http_info(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `delete`")
        # verify the required parameter 'spending_account_id' is set
        if ('spending_account_id' not in params) or (params['spending_account_id'] is None):
            raise ValueError("Missing the required parameter `spending_account_id` when calling `delete`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/{spendingAccountID}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'spending_account_id' in params:
            path_params['spendingAccountID'] = params['spending_account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_assignment(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assignment(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param str user_id: ID of the user.
        :param str user_group_id: ID of the user group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_assignment_with_http_info(buyer_id, spending_account_id, **kwargs)
        else:
            (data) = self.delete_assignment_with_http_info(buyer_id, spending_account_id, **kwargs)
            return data

    def delete_assignment_with_http_info(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assignment_with_http_info(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param str user_id: ID of the user.
        :param str user_group_id: ID of the user group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id', 'user_id', 'user_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `delete_assignment`")
        # verify the required parameter 'spending_account_id' is set
        if ('spending_account_id' not in params) or (params['spending_account_id'] is None):
            raise ValueError("Missing the required parameter `spending_account_id` when calling `delete_assignment`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/{spendingAccountID}/assignments'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'spending_account_id' in params:
            path_params['spendingAccountID'] = params['spending_account_id']

        query_params = {}
        if 'user_id' in params:
            query_params['userID'] = params['user_id']
        if 'user_group_id' in params:
            query_params['userGroupID'] = params['user_group_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_with_http_info(buyer_id, spending_account_id, **kwargs)
        else:
            (data) = self.get_with_http_info(buyer_id, spending_account_id, **kwargs)
            return data

    def get_with_http_info(self, buyer_id, spending_account_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_with_http_info(buyer_id, spending_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `get`")
        # verify the required parameter 'spending_account_id' is set
        if ('spending_account_id' not in params) or (params['spending_account_id'] is None):
            raise ValueError("Missing the required parameter `spending_account_id` when calling `get`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/{spendingAccountID}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'spending_account_id' in params:
            path_params['spendingAccountID'] = params['spending_account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list(self, buyer_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list(buyer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_with_http_info(buyer_id, **kwargs)
        else:
            (data) = self.list_with_http_info(buyer_id, **kwargs)
            return data

    def list_with_http_info(self, buyer_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_with_http_info(buyer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'search', 'search_on', 'sort_by', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `list`")

        resource_path = '/buyers/{buyerID}/spendingaccounts'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']

        query_params = {}
        if 'search' in params:
            query_params['search'] = params['search']
        if 'search_on' in params:
            query_params['searchOn'] = params['search_on']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_assignments(self, buyer_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignments(buyer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account.
        :param str user_id: ID of the user.
        :param str user_group_id: ID of the user group.
        :param str level: Level of the spending account.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_assignments_with_http_info(buyer_id, **kwargs)
        else:
            (data) = self.list_assignments_with_http_info(buyer_id, **kwargs)
            return data

    def list_assignments_with_http_info(self, buyer_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignments_with_http_info(buyer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account.
        :param str user_id: ID of the user.
        :param str user_group_id: ID of the user group.
        :param str level: Level of the spending account.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id', 'user_id', 'user_group_id', 'level', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `list_assignments`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/assignments'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']

        query_params = {}
        if 'spending_account_id' in params:
            query_params['spendingAccountID'] = params['spending_account_id']
        if 'user_id' in params:
            query_params['userID'] = params['user_id']
        if 'user_group_id' in params:
            query_params['userGroupID'] = params['user_group_id']
        if 'level' in params:
            query_params['level'] = params['level']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def patch(self, buyer_id, spending_account_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch(buyer_id, spending_account_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_with_http_info(buyer_id, spending_account_id, spending_account, **kwargs)
        else:
            (data) = self.patch_with_http_info(buyer_id, spending_account_id, spending_account, **kwargs)
            return data

    def patch_with_http_info(self, buyer_id, spending_account_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_with_http_info(buyer_id, spending_account_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id', 'spending_account']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `patch`")
        # verify the required parameter 'spending_account_id' is set
        if ('spending_account_id' not in params) or (params['spending_account_id'] is None):
            raise ValueError("Missing the required parameter `spending_account_id` when calling `patch`")
        # verify the required parameter 'spending_account' is set
        if ('spending_account' not in params) or (params['spending_account'] is None):
            raise ValueError("Missing the required parameter `spending_account` when calling `patch`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/{spendingAccountID}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'spending_account_id' in params:
            path_params['spendingAccountID'] = params['spending_account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spending_account' in params:
            body_params = params['spending_account']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def save_assignment(self, buyer_id, assignment, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_assignment(buyer_id, assignment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param SpendingAccountAssignment assignment:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.save_assignment_with_http_info(buyer_id, assignment, **kwargs)
        else:
            (data) = self.save_assignment_with_http_info(buyer_id, assignment, **kwargs)
            return data

    def save_assignment_with_http_info(self, buyer_id, assignment, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_assignment_with_http_info(buyer_id, assignment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param SpendingAccountAssignment assignment:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'assignment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `save_assignment`")
        # verify the required parameter 'assignment' is set
        if ('assignment' not in params) or (params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `save_assignment`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/assignments'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'assignment' in params:
            body_params = params['assignment']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update(self, buyer_id, spending_account_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(buyer_id, spending_account_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(buyer_id, spending_account_id, spending_account, **kwargs)
        else:
            (data) = self.update_with_http_info(buyer_id, spending_account_id, spending_account, **kwargs)
            return data

    def update_with_http_info(self, buyer_id, spending_account_id, spending_account, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(buyer_id, spending_account_id, spending_account, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str spending_account_id: ID of the spending account. (required)
        :param SpendingAccount spending_account:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'spending_account_id', 'spending_account']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `update`")
        # verify the required parameter 'spending_account_id' is set
        if ('spending_account_id' not in params) or (params['spending_account_id'] is None):
            raise ValueError("Missing the required parameter `spending_account_id` when calling `update`")
        # verify the required parameter 'spending_account' is set
        if ('spending_account' not in params) or (params['spending_account'] is None):
            raise ValueError("Missing the required parameter `spending_account` when calling `update`")

        resource_path = '/buyers/{buyerID}/spendingaccounts/{spendingAccountID}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'spending_account_id' in params:
            path_params['spendingAccountID'] = params['spending_account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spending_account' in params:
            body_params = params['spending_account']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
