# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class EmailTemplateApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get(self, buyer_id, email_template_type, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(buyer_id, email_template_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_with_http_info(buyer_id, email_template_type, **kwargs)
        else:
            (data) = self.get_with_http_info(buyer_id, email_template_type, **kwargs)
            return data

    def get_with_http_info(self, buyer_id, email_template_type, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_with_http_info(buyer_id, email_template_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'email_template_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `get`")
        # verify the required parameter 'email_template_type' is set
        if ('email_template_type' not in params) or (params['email_template_type'] is None):
            raise ValueError("Missing the required parameter `email_template_type` when calling `get`")

        resource_path = '/buyers/{buyerID}/emailtemplates/{emailTemplateType}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'email_template_type' in params:
            path_params['emailTemplateType'] = params['email_template_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def patch(self, buyer_id, email_template_type, email_template, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch(buyer_id, email_template_type, email_template, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :param EmailTemplate email_template:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_with_http_info(buyer_id, email_template_type, email_template, **kwargs)
        else:
            (data) = self.patch_with_http_info(buyer_id, email_template_type, email_template, **kwargs)
            return data

    def patch_with_http_info(self, buyer_id, email_template_type, email_template, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_with_http_info(buyer_id, email_template_type, email_template, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :param EmailTemplate email_template:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'email_template_type', 'email_template']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `patch`")
        # verify the required parameter 'email_template_type' is set
        if ('email_template_type' not in params) or (params['email_template_type'] is None):
            raise ValueError("Missing the required parameter `email_template_type` when calling `patch`")
        # verify the required parameter 'email_template' is set
        if ('email_template' not in params) or (params['email_template'] is None):
            raise ValueError("Missing the required parameter `email_template` when calling `patch`")

        resource_path = '/buyers/{buyerID}/emailtemplates/{emailTemplateType}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'email_template_type' in params:
            path_params['emailTemplateType'] = params['email_template_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_template' in params:
            body_params = params['email_template']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def reset_to_default(self, buyer_id, email_template_type, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_to_default(buyer_id, email_template_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reset_to_default_with_http_info(buyer_id, email_template_type, **kwargs)
        else:
            (data) = self.reset_to_default_with_http_info(buyer_id, email_template_type, **kwargs)
            return data

    def reset_to_default_with_http_info(self, buyer_id, email_template_type, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_to_default_with_http_info(buyer_id, email_template_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'email_template_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_to_default" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `reset_to_default`")
        # verify the required parameter 'email_template_type' is set
        if ('email_template_type' not in params) or (params['email_template_type'] is None):
            raise ValueError("Missing the required parameter `email_template_type` when calling `reset_to_default`")

        resource_path = '/buyers/{buyerID}/emailtemplates/{emailTemplateType}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'email_template_type' in params:
            path_params['emailTemplateType'] = params['email_template_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update(self, buyer_id, email_template_type, email_template, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(buyer_id, email_template_type, email_template, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :param EmailTemplate email_template:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(buyer_id, email_template_type, email_template, **kwargs)
        else:
            (data) = self.update_with_http_info(buyer_id, email_template_type, email_template, **kwargs)
            return data

    def update_with_http_info(self, buyer_id, email_template_type, email_template, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(buyer_id, email_template_type, email_template, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str buyer_id: ID of the buyer. (required)
        :param str email_template_type: Email template type of the email template. Possible values: OrderSubmittedForApproval, CustomerOrderSubmitted, OrderToApprove, OrderDeclined, OrderApproved, PriceRequestSubmitted, CustomerOrderShipped, ProductRequiresAttachment, InventoryPointReached, LineItemExceedsInventory, PriceRequestResponse, CustomerOrderUpdated, OrderCanceled, PriceRequestCanceled, NewOrderReceived, ApprovalNotification, EmailLoginVerificationCode. (required)
        :param EmailTemplate email_template:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['buyer_id', 'email_template_type', 'email_template']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'buyer_id' is set
        if ('buyer_id' not in params) or (params['buyer_id'] is None):
            raise ValueError("Missing the required parameter `buyer_id` when calling `update`")
        # verify the required parameter 'email_template_type' is set
        if ('email_template_type' not in params) or (params['email_template_type'] is None):
            raise ValueError("Missing the required parameter `email_template_type` when calling `update`")
        # verify the required parameter 'email_template' is set
        if ('email_template' not in params) or (params['email_template'] is None):
            raise ValueError("Missing the required parameter `email_template` when calling `update`")

        resource_path = '/buyers/{buyerID}/emailtemplates/{emailTemplateType}'.replace('{format}', 'json')
        path_params = {}
        if 'buyer_id' in params:
            path_params['buyerID'] = params['buyer_id']
        if 'email_template_type' in params:
            path_params['emailTemplateType'] = params['email_template_type']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_template' in params:
            body_params = params['email_template']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
