/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class LongPacker {
    public static final int packLong(DataOutput os, long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v >> 56 != 0L) {
            os.write((byte)(0xFFL & v >> 56 | 0x80L));
            os.write((byte)(0xFFL & v >> 48));
            os.write((byte)(0xFFL & v >> 40));
            os.write((byte)(0xFFL & v >> 32));
            os.write((byte)(0xFFL & v >> 24));
            os.write((byte)(0xFFL & v >> 16));
            os.write((byte)(0xFFL & v >> 8));
            os.write((byte)(0xFFL & v));
            return 8;
        }
        int nnibbles = LongPacker.getNibbleLength(v);
        boolean evenNibbleCount = nnibbles == nnibbles >> 1 << 1;
        int nbytes = (nnibbles + 1 >> 1) + (evenNibbleCount ? 1 : 0);
        int nwritten = 0;
        if (evenNibbleCount) {
            byte b = (byte)(nbytes << 4);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 2 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        } else {
            byte highByte = (byte)(0xFFL & v >> (nbytes - 1) * 8);
            byte b = (byte)(nbytes << 4 | highByte);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 3 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        }
        return nwritten;
    }

    protected static final int getNibbleLength(long v) {
        int i = 56;
        int j = 16;
        while (i >= 0) {
            if ((0xF0L & v >> i) != 0L) {
                return j;
            }
            if ((0xFL & v >> i) != 0L) {
                return j - 1;
            }
            i -= 8;
            j -= 2;
        }
        if (v != 0L) {
            throw new AssertionError((Object)("v=" + v));
        }
        return 1;
    }

    public static final long unpackLong(DataInput is) throws IOException {
        long l;
        int nbytes;
        byte b = is.readByte();
        if ((b & 0x80) != 0) {
            nbytes = 8;
            l = b & 0x7F;
        } else {
            nbytes = b >> 4;
            l = b & 0xF;
        }
        for (int i = 1; i < nbytes; ++i) {
            b = is.readByte();
            l = (l << 8) + (long)(0xFF & b);
        }
        return l;
    }

    public static final int packInt(DataOutput os, int v) throws IOException {
        return LongPacker.packLong(os, v);
    }

    public static final int unpackInt(DataInput is) throws IOException {
        long val = LongPacker.unpackLong(is);
        if (val > Integer.MAX_VALUE) {
            throw new InternalError("too big int: " + val);
        }
        return (int)val;
    }
}

