import os
import imp
from setuptools import setup, find_packages

def get_version():
    " Get version & version_info without importing md2slides.__init__ "
    path = os.path.join(os.path.dirname(__file__), 'md2slides')
    fp, pathname, desc = imp.find_module('__version__', [path])
    try:
        v = imp.load_module('__version__', fp, pathname, desc)
        return v.version, v.version_info
    finally:
        fp.close()

version, version_info = get_version()

# Get development Status for classifiers
dev_status_map = {
    'alpha': '3 - Alpha',
    'beta' : '4 - Beta',
    'rc'   : '4 - Beta',
    'final': '5 - Production/Stable'
}
if version_info[3] == 'alpha' and version_info[4] == 0:
    DEVSTATUS = '2 - Pre-Alpha'
else:
    DEVSTATUS = dev_status_map[version_info[3]]

long_description = \
'''md2slides convert a presentation written in a markdown file into an html
   file suitable for browser presentations. Currently it supports Deck.js 
   and Impress.js Javascript presentation suites. It can automatically
   include LaTeX in the html presentation through MathJax.
   
   Markdown Syntax Extensions
   --------------------------
   - You can provide metadata for you presentation using a YAML front-matter
     format text at the top of the markdown file.
   
   - The end of a slide and the beginning of a new one is indicated by the
     string -*-. The rest of the text contained in the line with this
     keyword will be included in the html element of the slide as attributes.
   
'''

setup(
    name =              'md2slides',
    version =           version,
    url =               'http://packages.python.org/md2slides/',
    description =       'Python package to convert mardown files into html presentations.',
    long_description =  long_description,
    author =            'Jacopo Sabbatini',
    author_email =      'dedalusj [at] gmail.com',
    license =           'BSD License',
    packages =          find_packages(),
    package_data =      {'': ['*.html','*.js',],},
    classifiers =       ['Development Status :: %s' % DEVSTATUS,
                         'License :: OSI Approved :: BSD License',
                         'Operating System :: OS Independent',
                         'Programming Language :: Python',
                         'Programming Language :: Python :: 2',
                         'Programming Language :: Python :: 2.6',
                         'Programming Language :: Python :: 2.7',
                         'Topic :: Text Processing :: Markup :: HTML',
                        ],
     install_requires = ['markdown',
                         'tornado',
                         'GitPython==0.3.2.RC1',
                         'pyyaml',
                         'jinja2',
                        ],
     entry_points     = {'console_scripts': ['md2slides = md2slides.md2slides:run',],},
    )