/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Element;
import be.re.css.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class NormalizeTableFilter
extends XMLFilterImpl {
    private Stack columnStack = new Stack();
    private Stack elementStack = new Stack();

    NormalizeTableFilter() {
    }

    NormalizeTableFilter(XMLReader parent) {
        super(parent);
    }

    private void addColumn(Attributes atts) {
        List columns = (List)this.columnStack.peek();
        int span = NormalizeTableFilter.getSpan(atts, "span");
        for (int i = 0; i < span; ++i) {
            columns.add(atts);
        }
    }

    private void addTableCellRowContributions(Element element) {
        int rowSpan = NormalizeTableFilter.getSpan(element.atts, "rowspan");
        if (rowSpan > 1) {
            int colSpan = NormalizeTableFilter.getSpan(element.atts, "colspan");
            Element group = this.getGroup();
            for (int i = 1; i < rowSpan; ++i) {
                if (i == ((List)group.extra).size()) {
                    ((List)group.extra).add(new Integer(colSpan));
                    continue;
                }
                ((List)group.extra).set(i, new Integer((Integer)((List)group.extra).get(i) + colSpan));
            }
        }
    }

    private void bookKeeping(Element element, Element parent) {
        if (element.isDisplay(Element.TABLE)) {
            this.columnStack.push(new ArrayList());
        } else if (element.isDisplay(Element.TABLE_COLUMN)) {
            this.addColumn(new AttributesImpl(element.atts));
        } else if (element.isDisplay(Element.TABLE_ROW)) {
            if (NormalizeTableFilter.isGroup(parent) && parent.extra == null) {
                parent.extra = new ArrayList();
                ((List)parent.extra).add(new Integer(0));
            }
        } else if (element.isDisplay(Element.TABLE_CELL)) {
            int currentCellCount = parent.extra == null ? 0 : (Integer)parent.extra;
            parent.extra = new Integer(currentCellCount + NormalizeTableFilter.getSpan(element.atts, "colspan"));
            this.addTableCellRowContributions(element);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element parent;
        Element element = (Element)this.elementStack.pop();
        if (element.isDisplay(Element.TABLE_ROW_GROUP) && Constants.CSS.equals(element.namespaceURI) && "synthetic".equals(element.localName)) {
            super.endElement(Constants.CSS, "synthetic", "css:synthetic");
            this.endElement(namespaceURI, localName, qName);
            return;
        }
        Element element2 = parent = this.elementStack.empty() ? null : (Element)this.elementStack.peek();
        if (element.isDisplay(Element.TABLE_COLUMN_GROUP)) {
            this.synthesizeColumns(element);
        } else if (element.isDisplay(Element.TABLE_ROW)) {
            this.synthesizeCells(element, parent);
        } else if (element.isDisplay(Element.TABLE)) {
            this.columnStack.pop();
        }
        if (!(element.isDisplay(Element.TABLE_COLUMN_GROUP) || element.isDisplay(Element.TABLE_COLUMN) && parent != null && parent.isDisplay(Element.TABLE_COLUMN_GROUP))) {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    private Element getAncestor(String[] oneOf, String[] upTo) {
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            int j;
            Element element = (Element)this.elementStack.get(i);
            for (j = 0; j < oneOf.length; ++j) {
                if (!element.isDisplay(oneOf[j])) continue;
                return element;
            }
            for (j = 0; j < upTo.length; ++j) {
                if (!element.isDisplay(upTo[j])) continue;
                return null;
            }
        }
        return null;
    }

    private Attributes getColumn() {
        List columns = (List)this.columnStack.peek();
        Integer position = (Integer)((Element)this.elementStack.peek()).extra;
        return position == null && columns.size() > 0 ? (Attributes)columns.get(0) : (columns.size() == 0 || position >= columns.size() ? null : (Attributes)columns.get(position));
    }

    private Element getGroup() {
        return this.getAncestor(new String[]{Element.TABLE_ROW_GROUP, Element.TABLE_HEADER_GROUP, Element.TABLE_FOOTER_GROUP}, new String[]{Element.TABLE});
    }

    private static int getSpan(Attributes atts, String name) {
        String span = atts.getValue(Constants.CSS, name);
        return span == null ? 1 : Integer.parseInt(span);
    }

    private Attributes getTableCellAttributes(Element element, Element parent) {
        Element table = this.getAncestor(new String[]{Element.TABLE}, new String[0]);
        if (table == null) {
            return element.atts;
        }
        Attributes column = this.getColumn();
        Attributes atts = Constants.XHTML.equals(parent.namespaceURI) ? this.inheritXHTMLAlign(element.atts, column, parent) : element.atts;
        int index = table.atts.getIndex(Constants.CSS, "border-collapse");
        if (index == -1 || "collapse".equals(table.atts.getValue(index))) {
            if (parent.isDisplay(Element.TABLE_ROW)) {
                atts = Util.mergeAttributes(parent.atts, atts, new String[]{"border*"}, true);
            }
            if (column != null) {
                atts = Util.mergeAttributes(column, atts, new String[]{"border*"}, true);
            }
        }
        return atts;
    }

    private Attributes getTableRowAttributes(Attributes atts, Attributes parentAtts) {
        return Util.mergeAttributes(parentAtts, atts, new String[]{"border-before*", "border-top*"}, true);
    }

    private Attributes inheritXHTMLAlign(Attributes atts, Attributes columnAtts, Element parent) {
        String verticalAlign;
        AttributesImpl result = new AttributesImpl(atts);
        String textAlign = atts.getIndex(Constants.SPECIF, "text-align") != -1 ? null : atts.getValue(Constants.CSS, "text-align");
        String string = verticalAlign = atts.getIndex(Constants.SPECIF, "vertical-align") != -1 ? null : atts.getValue(Constants.CSS, "vertical-align");
        if (textAlign == null && columnAtts != null) {
            textAlign = columnAtts.getValue(Constants.CSS, "text-align");
        }
        if ((textAlign == null || verticalAlign == null) && parent.isDisplay(Element.TABLE_ROW)) {
            Element group;
            if (textAlign == null) {
                textAlign = parent.atts.getValue(Constants.CSS, "text-align");
            }
            if (verticalAlign == null) {
                verticalAlign = parent.atts.getValue(Constants.CSS, "vertical-align");
            }
            if ((textAlign == null || verticalAlign == null) && (group = this.getGroup()) != null) {
                Element table;
                if (textAlign == null) {
                    textAlign = group.atts.getValue(Constants.CSS, "text-align");
                }
                if (verticalAlign == null && (verticalAlign = group.atts.getValue(Constants.CSS, "vertical-align")) == null && columnAtts != null) {
                    verticalAlign = columnAtts.getValue(Constants.CSS, "vertical-align");
                }
                if ((textAlign == null || verticalAlign == null) && (table = this.getAncestor(new String[]{Element.TABLE}, new String[0])) != null) {
                    if (textAlign == null) {
                        textAlign = table.atts.getValue(Constants.CSS, "text-align");
                    }
                    if (verticalAlign == null) {
                        verticalAlign = table.atts.getValue(Constants.CSS, "vertical-align");
                    }
                }
            }
        }
        if (textAlign != null) {
            Util.setAttribute(result, Constants.CSS, "text-align", "css:text-align", textAlign);
        }
        if (verticalAlign != null) {
            Util.setAttribute(result, Constants.CSS, "vertical-align", "css:vertical-align", verticalAlign);
        }
        return result;
    }

    private static boolean isGroup(Element element) {
        return element.isDisplay(Element.TABLE_HEADER_GROUP) || element.isDisplay(Element.TABLE_FOOTER_GROUP) || element.isDisplay(Element.TABLE_ROW_GROUP);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element = new Element(namespaceURI, localName, qName, atts);
        if (!element.isDisplay(Element.TABLE_COLUMN_GROUP)) {
            Element parent;
            Element element2 = parent = this.elementStack.empty() ? null : (Element)this.elementStack.peek();
            if (element.isDisplay(Element.TABLE_COLUMN) && parent.isDisplay(Element.TABLE_COLUMN_GROUP)) {
                parent.addChild(element);
            } else {
                if (element.isDisplay(Element.TABLE_ROW) && parent.isDisplay(Element.TABLE)) {
                    this.synthesizeGroup();
                    parent = (Element)this.elementStack.peek();
                } else if (NormalizeTableFilter.isGroup(element) && parent.isDisplay(Element.TABLE_ROW_GROUP)) {
                    this.elementStack.pop();
                    super.endElement(Constants.CSS, "synthetic", "css:synthetic");
                }
                element.atts = element.isDisplay(Element.TABLE_CELL) ? this.getTableCellAttributes(element, parent) : (element.isDisplay(Element.TABLE_ROW) && NormalizeTableFilter.isGroup(parent) && parent.extra == null ? this.getTableRowAttributes(atts, parent.atts) : atts);
                super.startElement(namespaceURI, localName, qName, element.atts);
                this.bookKeeping(element, parent);
            }
        }
        this.elementStack.push(element);
    }

    private void synthesizeCells(Element element, Element parent) throws SAXException {
        if (element.extra != null) {
            int contribution;
            List columns = (List)this.columnStack.peek();
            List rowContributions = (List)parent.extra;
            int n = contribution = rowContributions.size() > 0 ? (Integer)rowContributions.get(0) : 0;
            if (rowContributions.size() > 0) {
                rowContributions.remove(0);
            }
            if (rowContributions.size() == 0) {
                rowContributions.add(new Integer(0));
            }
            if ((Integer)element.extra + contribution < columns.size()) {
                for (int i = ((Integer)element.extra).intValue(); i < columns.size(); ++i) {
                    super.startElement(Constants.CSS, "synthetic", "css:synthetic", NormalizeTableFilter.synthesizeColumnAttributes((Attributes)columns.get(i), "table-cell", new String[]{"border*"}));
                    super.endElement(Constants.CSS, "synthetic", "css:synthetic");
                }
            }
        }
    }

    private static Attributes synthesizeColumnAttributes(Attributes source, String display, String[] include) {
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < source.getLength(); ++i) {
            if (!Util.inArray(include, source.getLocalName(i))) continue;
            atts.addAttribute(source.getURI(i), source.getLocalName(i), source.getQName(i), source.getType(i), source.getValue(i));
        }
        atts.addAttribute(Constants.CSS, "display", "css:display", "CDATA", display);
        return atts;
    }

    private void synthesizeColumns(Element element) throws SAXException {
        if (element.children == null) {
            int span = NormalizeTableFilter.getSpan(element.atts, "span");
            for (int i = 0; i < span; ++i) {
                String[] stringArray;
                Attributes attributes = element.atts;
                if (i == 0) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "border-left*";
                    stringArray2[1] = "text-align";
                    stringArray = stringArray2;
                    stringArray2[2] = "vertical-align";
                } else if (i == span - 1) {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "border-right*";
                    stringArray3[1] = "text-align";
                    stringArray = stringArray3;
                    stringArray3[2] = "vertical-align";
                } else {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "text-align";
                    stringArray = stringArray4;
                    stringArray4[1] = "vertical-align";
                }
                Attributes atts = NormalizeTableFilter.synthesizeColumnAttributes(attributes, "table-column", stringArray);
                this.addColumn(atts);
                super.startElement(Constants.CSS, "synthetic", "css:synthetic", atts);
                super.endElement(Constants.CSS, "synthetic", "css:synthetic");
            }
        } else {
            for (int i = 0; i < element.children.size(); ++i) {
                String[] stringArray;
                Element child = (Element)element.children.get(i);
                Attributes attributes = element.atts;
                Attributes attributes2 = child.atts;
                if (i == 0) {
                    String[] stringArray5 = new String[3];
                    stringArray5[0] = "border-left*";
                    stringArray5[1] = "text-align";
                    stringArray = stringArray5;
                    stringArray5[2] = "vertical-align";
                } else if (i == element.children.size() - 1) {
                    String[] stringArray6 = new String[3];
                    stringArray6[0] = "border-right*";
                    stringArray6[1] = "text-align";
                    stringArray = stringArray6;
                    stringArray6[2] = "vertical-align";
                } else {
                    String[] stringArray7 = new String[2];
                    stringArray7[0] = "text-align";
                    stringArray = stringArray7;
                    stringArray7[1] = "vertical-align";
                }
                Attributes atts = Util.mergeAttributes(attributes, attributes2, stringArray, true);
                this.addColumn(atts);
                super.startElement(child.namespaceURI, child.localName, child.qName, atts);
                super.endElement(child.namespaceURI, child.localName, child.qName);
            }
        }
    }

    private void synthesizeGroup() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(Constants.CSS, "display", "css:display", "CDATA", "table-row-group");
        super.startElement(Constants.CSS, "synthetic", "css:synthetic", atts);
        this.elementStack.push(new Element(Constants.CSS, "synthetic", "css:synthetic", atts));
    }
}

