/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.exception;

import java.util.Stack;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;

@PublicAPI
public class JobCreationException
extends SchedulerException {
    private String taskName = null;
    private Stack<XMLTags> tags = new Stack();
    private XMLAttributes attribute = null;
    private boolean isSchemaException = false;
    private static final long serialVersionUID = 1L;

    public JobCreationException(String message) {
        super(message);
    }

    public JobCreationException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public JobCreationException(String message, Throwable cause) {
        super(message, cause);
    }

    public JobCreationException(boolean schemaException, Throwable cause) {
        super(cause.getMessage(), cause);
        this.isSchemaException = schemaException;
    }

    public JobCreationException(String tag, String attribute, Exception cause) {
        this(tag == null ? null : XMLTags.getFromXMLName(tag), attribute, cause);
    }

    public JobCreationException(XMLTags tag, String attribute, Exception cause) {
        super(cause.getMessage(), cause);
        if (tag != null) {
            this.tags.push(tag);
        }
        if (attribute != null) {
            this.attribute = XMLAttributes.getFromXMLName(attribute);
        }
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void pushTag(String currentTag) {
        this.pushTag(XMLTags.getFromXMLName(currentTag));
    }

    public void pushTag(XMLTags currentTag) {
        this.tags.push(currentTag);
    }

    public Stack<XMLTags> getXMLTagsStack() {
        return this.tags;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.taskName != null) {
            sb.append("[task=" + this.taskName + "] ");
        }
        if (this.tags != null && this.tags.size() > 0) {
            sb.append("[tag:" + this.tags.elementAt(this.tags.size() - 1));
            for (int i = this.tags.size() - 2; i >= 0; --i) {
                sb.append("/" + this.tags.elementAt(i));
            }
            sb.append("] ");
        }
        if (this.attribute != null) {
            sb.append("[attribute:" + (Object)((Object)this.attribute) + "] ");
        }
        if (sb.length() > 0) {
            sb = new StringBuilder("At " + sb.toString() + ": ");
        }
        sb.append(this.getShortMessage());
        return sb.toString();
    }

    public String getShortMessage() {
        return super.getMessage();
    }

    public boolean isSchemaException() {
        return this.isSchemaException;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public XMLAttributes getAttribute() {
        return this.attribute;
    }
}

