#!/usr/bin/env python
from comtypes import COMError
import string
from ctypes import c_uint32, byref

def com_stringgetter(fun):
    """decorator for a function that has a COM signature like
    COMMETHOD([], HRESULT, 'GetName',
              ( ['in', 'out'], WSTRING, 'pwszName' ),
              ( ['in'], c_uint, 'nMaxChars' ))
    
    Use:    @com_stringgetter
            def: GetName(self)
                pass
    """
    def newfun(self):
        strlen = 128
        succeeded = False
        while not succeeded:
            try:
                str = u' '*strlen
                str = getattr(self, '_'+fun.__name__)(str, strlen)
                str = str[0:string.find(str, '\x00')]
                str = string.rstrip(str)
                return str
            except COMError, ce:
                if ce.hresult in [-2147024882, -2147201016]:
                    strlen = strlen*2
                else:
                    raise ce
    newfun.__name__ = fun.__name__
    return newfun

def com_dwordgetter(fun):
    def newfun(self):
        int = c_uint32()
        getattr(self, '_'+fun.__name__)(byref(int))
        return int.value
    newfun.__name__ = fun.__name__
    return newfun