#!/usr/bin/env python
from setuptools import setup, find_packages
setup(
    name = "wmdlib",
    version = "0.1",
    packages = find_packages(),
    #scripts = ['say_hello.py'],

    install_requires = ['comtypes>=0.3.3a', 'ctypes>=1.0.2'],

    #package_data = {
    #    # If any package contains *.txt or *.rst files, include them:
    #    '': ['*.txt', '*.rst'],
    #    # And include any *.msg files found in the 'hello' package, too:
    #    'hello': ['*.msg'],
    #},

    package_data = {
        '':['README.txt','LICENSE.txt'],
        'wmdlib.lowlevel' : ['WPD_noDRM_com.dll']
    },
    
    entry_points = {
        'console_scripts': [
            'wmdlib-sample-app = wmdlib.samples.app:main'
        ]
    },

    # metadata for upload to PyPI
    author = "Hanno Stock",
    author_email = "hanno.stock@gmx.net",
    description = "A library to interface with the Windows Media Devices API",
    license = "BSD with additional restrictions",
    keywords = "wmd media mobile devices windows mtp",
    url = "http://blog.hanno-stock.de/projects/",   # project home page, if any
    classifiers = ['Development Status :: 2 - Pre-Alpha',
        'Environment :: Win32 (MS Windows)',
        'Intended Audience :: Developers',
        'License :: Other/Proprietary License',
        'Operating System :: Microsoft :: Windows :: Windows NT/2000',
        'Programming Language :: Python',
        'Topic :: Multimedia :: Sound/Audio']


    # could also include long_description, download_url, classifiers, etc.
)
