# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KeyVaultCredentialSettings(Model):
    """Configure your SQL virtual machine to be able to connect to the Azure Key
    Vault service.

    :param enable: Enable or disable key vault credential setting.
    :type enable: bool
    :param credential_name: Credential name.
    :type credential_name: str
    :param azure_key_vault_url: Azure Key Vault url.
    :type azure_key_vault_url: str
    :param service_principal_name: Service principal name to access key vault.
    :type service_principal_name: str
    :param service_principal_secret: Service principal name secret to access
     key vault.
    :type service_principal_secret: str
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'credential_name': {'key': 'credentialName', 'type': 'str'},
        'azure_key_vault_url': {'key': 'azureKeyVaultUrl', 'type': 'str'},
        'service_principal_name': {'key': 'servicePrincipalName', 'type': 'str'},
        'service_principal_secret': {'key': 'servicePrincipalSecret', 'type': 'str'},
    }

    def __init__(self, *, enable: bool=None, credential_name: str=None, azure_key_vault_url: str=None, service_principal_name: str=None, service_principal_secret: str=None, **kwargs) -> None:
        super(KeyVaultCredentialSettings, self).__init__(**kwargs)
        self.enable = enable
        self.credential_name = credential_name
        self.azure_key_vault_url = azure_key_vault_url
        self.service_principal_name = service_principal_name
        self.service_principal_secret = service_principal_secret
