#
# Unit Tests for util/method
#
#

import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+"/../..")

import unittest
from nose.tools import nottest
import pyutilib

class MethodDebug(unittest.TestCase):

    def test_add_method(self):
        """Verify that we can add a method to a class"""
        class A(object):
            def __init__(self):
                pass
        def foo(self, x):
            return (x,)
        a=A()
        pyutilib.add_method(a,foo)
        self.failUnlessEqual(a.foo("a"),("a",))
        pyutilib.add_method(a,foo,"bar")
        self.failUnlessEqual(a.bar("b"),("b",))

    def test_add_method_by_name(self):
        """Verify that we can add a method to a class"""
        class A(object):
            def __init__(self):
                pass
        def foo(self, x):
            return (x,)
        a=A()
        pyutilib.add_method_by_name(a,"foo",locals=locals())
        self.failUnlessEqual(a.foo("a"),("a",))
        pyutilib.add_method_by_name(a,"foo","bar",locals=locals())
        self.failUnlessEqual(a.bar("b"),("b",))

if __name__ == "__main__":
   unittest.main()
