#
# Unit Tests for util/math
#
#

import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+"/../..")
pkgdir = dirname(abspath(__file__))+"/../.."

import unittest
from nose.tools import nottest
import pyutilib

class FactoryDebug(unittest.TestCase):

    class A(object):
        def __init__(self,*args,**kargs):
            pass

    class B(object):
        def __init__(self,*args,**kargs):
            pass

    def Afunc(*args, **kargs):
        return FactoryDebug.A(*args,**kargs)

    def Bfunc(*args, **kargs):
        return FactoryDebug.B(*args,**kargs)

    def setUp(self):
        self.factory = pyutilib.Factory()
        self.factory.register("classA", self.Afunc, None, None)
        self.factory.register("classB", self.Bfunc, None, None)

    def test_kyes(self):
        self.failUnlessEqual( self.factory.keys(), ["classA", "classB"])

    def test_len(self):
        self.failUnlessEqual( len(self.factory), 2)

    def test_iter(self):
        ans = {0:"classA", 1:"classB"}
        i=0
        for name in self.factory:
          self.failUnlessEqual( name, ans[i] )
          i=i+1  

    def test_getitem(self):
        self.failUnlessEqual( self.factory[0], "classA" )
        self.failUnlessEqual( self.factory[1], "classB" )

    def test_unregister(self):
        self.factory.unregister("classA")
        self.failUnlessEqual( len(self.factory), 1)
        self.failUnlessEqual( self.factory[0], "classB" )

    def test_call(self):
        a = self.factory("classA")
        self.failUnlessEqual( FactoryDebug.A, type(a) )
        b = self.factory("classB")
        self.failUnlessEqual( FactoryDebug.B, type(b) )
        c = self.factory("classC")
        self.failUnlessEqual( None, c )

if __name__ == "__main__":
   unittest.main()
