from twisted.internet import reactor, error


def listen_tcp(portrange, host, factory):
    '''Like reactor.listenTCP but tries different ports in a range.'''
    assert len(portrange) <= 2, 'invalid portrange: %s' % portrange
    if not hasattr(portrange, '__iter__'):
        return reactor.listenTCP(portrange, factory, interface=host)
    if not portrange:
        return reactor.listenTCP(0, factory, interface=host)
    if len(portrange) == 1:
        return reactor.listenTCP(portrange[0], factory, interface=host)
    for x in range(portrange[0], portrange[1]+1):
        try:
            return reactor.listenTCP(x, factory, interface=host)
        except error.CannotListenError:
            if x == portrange[1]:
                raise
