# This script generates the mapping between MS Windows timezone names and
# Olsen timezone names, by retrieving a file:
# http://unicode.org/cldr/data/common/supplemental/supplementalData.xml
# and parsing it, and from this generating the file windows_tz.py.
# It must be run with Python 3.

XML_SOURCE = 'http://unicode.org/cldr/data/common/supplemental/windowsZones.xml'
from urllib.request import urlopen
from xml.dom import minidom
from pprint import pprint

source = urlopen(XML_SOURCE).read()
dom = minidom.parseString(source)

for element in dom.getElementsByTagName('mapTimezones'):
    if element.getAttribute('type') == 'windows':
        break

mappings = {}
for mapping in element.getElementsByTagName('mapZone'):
    if mapping.getAttribute('territory') == '001':
        mappings[mapping.getAttribute('other')] = mapping.getAttribute('type').split(' ')[0]
    

with open('tzlocal/windows_tz.py', "wt") as out:
    out.write("# This file is autogenerated by the get_windows_info.py script\n"
              "# Do not edit.\ntz_names = ")
    pprint(mappings, out)
