# -*- coding: utf-8 -*- 
"""
# Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
# 
#  This file was generated and any changes will be overwritten.
"""

from __future__ import unicode_literals
from .thumbnail_request import ThumbnailRequest
from ..request_builder_base import RequestBuilderBase
from ..request.thumbnail_content_request import ThumbnailContentRequestBuilder


class ThumbnailRequestBuilder(RequestBuilderBase):

    def __init__(self, request_url, client):
        """Initialize the ThumbnailRequestBuilder

        Args:
            request_url (str): The url to perform the ThumbnailRequest
                on
            client (:class:`GraphClient<microsoft.msgraph.request.graph_client.GraphClient>`):
                The client which will be used for the request
        """
        super(ThumbnailRequestBuilder, self).__init__(request_url, client)

    def request(self, expand=None, select=None, options=None):
        """Builds the ThumbnailRequest

        Args:
            expand (str): Default None, comma-separated list of relationships
                to expand in the response.
            select (str): Default None, comma-separated list of properties to
                include in the response.
            options (list of :class:`Option<microsoft.msgraph.options.Option>`):
                A list of options to pass into the request. Defaults to None.

        Returns:
            :class:`ThumbnailRequest<microsoft.msgraph.request.thumbnail_request.ThumbnailRequest>`:
                The ThumbnailRequest
        """
        req = ThumbnailRequest(self._request_url, self._client, options)
        req._set_query_options(expand=expand, select=select)
        return req

    def delete(self):
        """Deletes the specified Thumbnail."""
        self.request().delete()

    def get(self):
        """Gets the specified Thumbnail.
        
        Returns:
            :class:`Thumbnail<microsoft.msgraph.model.thumbnail.Thumbnail>`:
                The Thumbnail.
        """
        return self.request().get()

    def update(self, thumbnail):
        """Updates the specified Thumbnail.
        
        Args:
            thumbnail (:class:`Thumbnail<microsoft.msgraph.model.thumbnail.Thumbnail>`):
                The Thumbnail to update.

        Returns:
            :class:`Thumbnail<microsoft.msgraph.model.thumbnail.Thumbnail>`:
                The updated Thumbnail
        """
        return self.request().update(thumbnail)


    def download(self, local_path):
        """Downloads the specified entity.

        Args:
            local_path (str): The path where the entity should be
                downloaded to
        """
        return self.content.request().download(local_path)


    @property
    def content(self):
        """The content for the ThumbnailRequestBuilder

        Returns: 
            :class:`ThumbnailContentRequestBuilder<microsoft.msgraph.request.thumbnail_content.ThumbnailContentRequestBuilder>`:
                A request builder created from the ThumbnailRequestBuilder
        """
        return ThumbnailContentRequestBuilder(self.append_to_request_url("content"), self._client)

