/*! Perseus | http://github.com/Khan/perseus */
// commit 0eb282635bfe7fcb4d30f73934a182b7fc80923a
// branch browserify_this
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define(factory);
	else if(typeof exports === 'object')
		exports["Perseus"] = factory();
	else
		root["Perseus"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(1);

	var version = __webpack_require__(53);

	module.exports = {
	    apiVersion:         version.apiVersion,
	    itemDataVersion:    version.itemDataVersion,
	    itemVersion:        __webpack_require__(2),
	    init:               __webpack_require__(3),
	    renderability:      __webpack_require__(6),
	    accessibility:      __webpack_require__(4),
	    i18n:               __webpack_require__(7),
	    AnswerAreaRenderer: __webpack_require__(8),
	    ArticleEditor:      __webpack_require__(9),
	    ArticleRenderer:    __webpack_require__(10),
	    Editor:             __webpack_require__(11),
	    EditorPage:         __webpack_require__(12),
	    ItemRenderer:       __webpack_require__(13),
	    HintsRenderer:      __webpack_require__(14),
	    Renderer:           __webpack_require__(15),
	    RevisionDiff:       __webpack_require__(18),
	    StatefulEditorPage: __webpack_require__(16),
	    ClassNames:         __webpack_require__(17).ClassNames,
	    Util:               __webpack_require__(5)
	};


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var Widgets = __webpack_require__(19);

	_.each([
	    __webpack_require__(21),
	    __webpack_require__(22),
	    __webpack_require__(23),
	    __webpack_require__(24),
	    __webpack_require__(25),
	    __webpack_require__(26),
	    __webpack_require__(27),
	    __webpack_require__(28),
	    __webpack_require__(29),
	    __webpack_require__(30),
	    __webpack_require__(31),
	    __webpack_require__(32),
	    __webpack_require__(33),
	    __webpack_require__(34),
	    __webpack_require__(35),
	    __webpack_require__(36),
	    __webpack_require__(37),
	    __webpack_require__(38),
	    __webpack_require__(39),
	    __webpack_require__(40),
	    __webpack_require__(41),
	    __webpack_require__(42),
	    __webpack_require__(43),
	    __webpack_require__(44),
	    __webpack_require__(45),
	    __webpack_require__(46),
	    __webpack_require__(47),
	    __webpack_require__(48),
	    __webpack_require__(49),
	    __webpack_require__(50),
	    __webpack_require__(51),
	    __webpack_require__(52)
	], function(widget) {
	    Widgets.register(widget.name, widget);
	});

	Widgets.validateAlignments();

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(1);
	var Version = __webpack_require__(53);
	var Widgets = __webpack_require__(19);

	var ItemVersion = _.clone(Widgets.getVersionVector());
	ItemVersion['::renderer::'] = Version.itemDataVersion;

	module.exports = ItemVersion;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var init = function(options) {
	    _.defaults(options, {
	        // Pass skipMathJax: true if MathJax is already loaded and configured.
	        skipMathJax: false
	    });

	    var deferred = $.Deferred();

	    if (options.skipMathJax) {
	        deferred.resolve();
	    } else {
	        MathJax.Hub.Config({
	            messageStyle: "none",
	            skipStartupTypeset: "none",
	            "HTML-CSS": {
	                availableFonts: ["TeX"],
	                imageFont: null,
	                scale: 100,
	                showMathMenu: false
	            }
	        });

	        MathJax.Hub.Configured();
	        MathJax.Hub.Queue(deferred.resolve);
	    }

	    return deferred;
	};

	module.exports = init;


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Identifies whether or not a given perseus item requires the use of a mouse
	 * or screen, based on the widgets it contains.
	 */

	var _ = __webpack_require__(67);

	var Traversal = __webpack_require__(20);
	var Widgets = __webpack_require__(19);

	module.exports = {
	    // Returns a list of widgets that cause a given perseus item to require
	    // the use of a screen or mouse.
	    //
	    // For now we'll just check the `accessible` field on each of the widgets
	    // in the item data, but in the future we may specify accessibility on
	    // each widget with higher granularity.
	    violatingWidgets: function(itemData) {
	        // TODO(jordan): Hints as well
	        var widgets = [];

	        // Traverse the question data
	        Traversal.traverseRendererDeep(
	            itemData.question,
	            null,
	            function(info) {
	                if (info.type && !Widgets.isAccessible(info)) {
	                    widgets.push(info.type);
	                }
	            }
	        );

	        // Uniquify the list of widgets (by type)
	        return _.uniq(widgets);
	    }
	};


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var nestedMap = function(children, func, context) {
	    if (_.isArray(children)) {
	        return _.map(children, function(child) {
	            return nestedMap(child, func);
	        });
	    } else {
	        return func.call(context, children);
	    }
	};

	var Util = {
	    nestedMap: nestedMap,

	    rWidgetParts: /^\[\[\u2603 (([a-z-]+) ([0-9]+))\]\]$/,
	    rWidgetRule:  /^\[\[\u2603 (([a-z-]+) ([0-9]+))\]\]/,
	    rTypeFromWidgetId: /^([a-z-]+) ([0-9]+)$/,
	    snowman: "\u2603",

	    noScore: {
	        type: "points",
	        earned: 0,
	        total: 0,
	        message: null
	    },

	    seededRNG: function(seed) {
	        var randomSeed = seed;

	        return function() {
	            // Robert Jenkins' 32 bit integer hash function.
	            var seed = randomSeed;
	            seed = ((seed + 0x7ed55d16) + (seed << 12)) & 0xffffffff;
	            seed = ((seed ^ 0xc761c23c) ^ (seed >>> 19)) & 0xffffffff;
	            seed = ((seed + 0x165667b1) + (seed << 5)) & 0xffffffff;
	            seed = ((seed + 0xd3a2646c) ^ (seed << 9)) & 0xffffffff;
	            seed = ((seed + 0xfd7046c5) + (seed << 3)) & 0xffffffff;
	            seed = ((seed ^ 0xb55a4f09) ^ (seed >>> 16)) & 0xffffffff;
	            return (randomSeed = (seed & 0xfffffff)) / 0x10000000;
	        };
	    },

	    // Shuffle an array using a given random seed or function.
	    // If `ensurePermuted` is true, the input and ouput are guaranteed to be
	    // distinct permutations.
	    shuffle: function(array, randomSeed, ensurePermuted) {
	        // Always return a copy of the input array
	        var shuffled = _.clone(array);

	        // Handle edge cases (input array is empty or uniform)
	        if (!shuffled.length || _.all(shuffled, function(value) {
	                                    return _.isEqual(value, shuffled[0]);
	                                })) {
	            return shuffled;
	        }

	        var random;
	        if (_.isFunction(randomSeed)) {
	            random = randomSeed;
	        } else {
	            random = Util.seededRNG(randomSeed);
	        }

	        do {
	            // Fischer-Yates shuffle
	            for (var top = shuffled.length; top > 0; top--) {
	                var newEnd = Math.floor(random() * top),
	                    temp = shuffled[newEnd];

	                shuffled[newEnd] = shuffled[top - 1];
	                shuffled[top - 1] = temp;
	            }
	        } while (ensurePermuted && _.isEqual(array, shuffled));

	        return shuffled;
	    },

	    // In IE8, split doesn't work right. Implement it ourselves.
	    split: "x".split(/(.)/g).length ?
	        function(str, r) { return str.split(r); } :
	        function(str, r) {
	            // Based on Steven Levithan's MIT-licensed split, available at
	            // http://blog.stevenlevithan.com/archives/cross-browser-split
	            var output = [];
	            var lastIndex = r.lastIndex = 0;
	            var match;

	            while ((match = r.exec(str))) {
	                output.push(str.slice(lastIndex, match.index));
	                output.push.apply(output, match.slice(1));
	                lastIndex = match.index + match[0].length;
	            }

	            output.push(str.slice(lastIndex));
	            return output;
	        },

	    /**
	     * Given two score objects for two different widgets, combine them so that
	     * if one is wrong, the total score is wrong, etc.
	     */
	    combineScores: function(scoreA, scoreB) {
	        var message;

	        if (scoreA.type === "points" && scoreB.type === "points") {
	            if (scoreA.message && scoreB.message &&
	                    scoreA.message !== scoreB.message) {
	                // TODO(alpert): Figure out how to combine messages usefully
	                message = null;
	            } else {
	                message = scoreA.message || scoreB.message;
	            }

	            return {
	                type: "points",
	                earned: scoreA.earned + scoreB.earned,
	                total: scoreA.total + scoreB.total,
	                message: message
	            };

	        } else if (scoreA.type === "points" && scoreB.type === "invalid") {
	            return scoreB;

	        } else if (scoreA.type === "invalid" && scoreB.type === "points") {
	            return scoreA;

	        } else if (scoreA.type === "invalid" && scoreB.type === "invalid") {
	            if (scoreA.message && scoreB.message &&
	                    scoreA.message !== scoreB.message) {
	                // TODO(alpert): Figure out how to combine messages usefully
	                message = null;
	            } else {
	                message = scoreA.message || scoreB.message;
	            }

	            return {
	                type: "invalid",
	                message: message
	            };
	        }
	    },

	    keScoreFromPerseusScore: function(score, guess) {
	        if (score.type === "points") {
	            return {
	                empty: false,
	                correct: score.earned >= score.total,
	                message: score.message,
	                guess: guess
	            };
	        } else if (score.type === "invalid") {
	            return {
	                empty: true,
	                correct: false,
	                message: score.message,
	                guess: guess
	            };
	        } else {
	            throw new Error("Invalid score type: " + score.type);
	        }
	    },

	    /**
	     * Return the first valid interpretation of 'text' as a number, in the form
	     * {value: 2.3, exact: true}.
	     */
	    firstNumericalParse: function(text) {
	        // TODO(alpert): This is sort of hacky...
	        var first;
	        var val = Khan.answerTypes.predicate.createValidatorFunctional(
	            function(ans) {
	                first = ans;
	                return true;  /* break */
	            }, {
	                simplify: "optional",
	                inexact: true,
	                forms: "integer, proper, improper, pi, log, mixed, decimal"
	            });

	        val(text);
	        return first;
	    },

	    stringArrayOfSize: function(size) {
	        return _(size).times(function() {
	            return "";
	        });
	    },

	    /**
	     * For a graph's x or y dimension, given the tick step,
	     * the ranges extent (e.g. [-10, 10]), the pixel dimension constraint,
	     * and the grid step, return a bunch of configurations for that dimension.
	     *
	     * Example:
	     *      gridDimensionConfig(10, [-50, 50], 400, 5)
	     *
	     * Returns: {
	     *      scale: 4,
	     *      snap: 2.5,
	     *      tickStep: 2,
	     *      unityLabel: true
	     * };
	     */
	    gridDimensionConfig: function(absTickStep, extent, dimensionConstraint,
	                                     gridStep) {
	        var scale = Util.scaleFromExtent(extent, dimensionConstraint);
	        var stepPx = absTickStep * scale;
	        var unityLabel = stepPx > 30;
	        return {
	            scale: scale,
	            tickStep: absTickStep / gridStep,
	            unityLabel: unityLabel
	        };
	    },

	    /**
	     * Given the range, step, and boxSize, calculate the reasonable gridStep.
	     * Used for when one was not given explicitly.
	     *
	     * Example:
	     *      getGridStep([[-10, 10], [-10, 10]], [1, 1], 340)
	     *
	     * Returns: [1, 1]
	     */
	    getGridStep: function(range, step, boxSize) {
	        return _(2).times(function(i) {
	            var scale = Util.scaleFromExtent(range[i], boxSize);
	            var gridStep = Util.gridStepFromTickStep(step[i], scale);
	            return gridStep;
	        });
	    },

	    snapStepFromGridStep: function(gridStep) {
	        return _.map(gridStep, function(step) { return step / 2; });
	    },

	    /**
	     * Given the range and a dimension, come up with the appropriate
	     * scale.
	     * Example:
	     *      scaleFromExtent([-25, 25], 500) // returns 10
	     */
	    scaleFromExtent: function(extent, dimensionConstraint) {
	        var span = extent[1] - extent[0];
	        var scale = dimensionConstraint / span;
	        return scale;
	    },

	    /**
	     * Return a reasonable tick step given extent and dimension.
	     * (extent is [begin, end] of the domain.)
	     * Example:
	     *      tickStepFromExtent([-10, 10], 300) // returns 2
	     */
	    tickStepFromExtent: function(extent, dimensionConstraint) {
	        var span = extent[1] - extent[0];

	        var tickFactor;
	        // If single number digits
	        if (15 < span && span <= 20) {
	            tickFactor = 23;

	        // triple digit or decimal
	        } else if (span > 100 || span < 5) {
	            tickFactor = 10;

	        // double digit
	        } else {
	            tickFactor = 16;
	        }
	        var constraintFactor = dimensionConstraint / 500;
	        var desiredNumTicks = tickFactor * constraintFactor;
	        return Util.tickStepFromNumTicks(span, desiredNumTicks);
	    },

	    /**
	     * Given the tickStep and the graph's scale, find a
	     * grid step.
	     * Example:
	     *      gridStepFromTickStep(200, 0.2) // returns 100
	     */
	    gridStepFromTickStep: function(tickStep, scale) {
	        var tickWidth = tickStep * scale;
	        var x = tickStep;
	        var y = Math.pow(10, Math.floor(Math.log(x) / Math.LN10));
	        var leadingDigit = Math.floor(x / y);
	        if (tickWidth < 25) {
	            return tickStep;
	        }
	        if (tickWidth < 50) {
	            if (leadingDigit === 5) {
	                return tickStep;
	            } else {
	                return tickStep / 2;
	            }
	        }
	        if (leadingDigit === 1) {
	            return tickStep / 2;
	        }
	        if (leadingDigit === 2) {
	            return tickStep / 4;
	        }
	        if (leadingDigit === 5) {
	            return tickStep / 5;
	        }
	    },

	    /**
	     * Find a good tick step for the desired number of ticks in the range
	     * Modified from d3.scale.linear: d3_scale_linearTickRange.
	     * Thanks, mbostock!
	     * Example:
	     *      tickStepFromNumTicks(50, 6) // returns 10
	     */
	    tickStepFromNumTicks: function(span, numTicks) {
	        var step = Math.pow(10, Math.floor(Math.log(span / numTicks) / Math.LN10));
	        var err = numTicks / span * step;

	        // Filter ticks to get closer to the desired count.
	        if (err <= 0.15) {
	            step *= 10;
	        } else if (err <= 0.35) {
	            step *= 5;
	        } else if (err <= 0.75) {
	            step *= 2;
	        }

	        // Round start and stop values to step interval.
	        return step;
	    },

	    /**
	     * Transparently update deprecated props so that the code to deal
	     * with them only lives in one place: (Widget).deprecatedProps
	     *
	     * For example, if a boolean `foo` was deprecated in favor of a
	     * number 'bar':
	     *      deprecatedProps: {
	     *          foo: function(props) {
	     *              return {bar: props.foo ? 1 : 0};
	     *          }
	     *      }
	     */
	    DeprecationMixin: {
	        // This lifecycle stage is only called before first render
	        componentWillMount: function() {
	            var newProps = {};

	            _.each(this.deprecatedProps, function(func, prop) {
	                if (_.has(this.props, prop)) {
	                    _.extend(newProps, func(this.props));
	                }
	            }, this);

	            if (!_.isEmpty(newProps)) {
	                // Set new props directly so that widget renders correctly
	                // when it first mounts, even though these will be overwritten
	                // almost immediately afterwards...
	                _.extend(this.props, newProps);

	                // ...when we propagate the new props upwards and they come
	                // back down again.
	                setTimeout(this.props.onChange, 0, newProps);
	            }
	        }
	    },

	    /**
	     * Approximate equality on numbers and primitives.
	     */
	    eq: function(x, y) {
	        if (_.isNumber(x) && _.isNumber(y)) {
	            return Math.abs(x - y) < 1e-9;
	        } else {
	            return x === y;
	        }
	    },

	    /**
	     * Deep approximate equality on primitives, numbers, arrays, and objects.
	     */
	    deepEq: function(x, y) {
	        if (_.isArray(x) && _.isArray(y)) {
	            if (x.length !== y.length) {
	                return false;
	            }
	            for (var i = 0; i < x.length; i++) {
	                if (!Util.deepEq(x[i], y[i])) {
	                    return false;
	                }
	            }
	            return true;
	        } else if (_.isArray(x) || _.isArray(y)) {
	            return false;
	        } else if (_.isFunction(x) && _.isFunction(y)) {
	            return Util.eq(x, y);
	        } else if (_.isFunction(x) || _.isFunction(y)) {
	            return false;
	        } else if (_.isObject(x) && _.isObject(y)) {
	            return x === y || (
	                _.all(x, function(v, k) { return Util.deepEq(y[k], v); }) &&
	                _.all(y, function(v, k) { return Util.deepEq(x[k], v); })
	            );
	        } else if (_.isObject(x) || _.isObject(y)) {
	            return false;
	        } else {
	            return Util.eq(x, y);
	        }
	    },

	    /**
	     * Query String Parser
	     *
	     * Original from:
	     * http://stackoverflow.com/questions/901115/get-querystring-values-in-javascript/2880929#2880929
	     */
	    parseQueryString: function(query) {
	        query = query || window.location.search.substring(1);
	        var urlParams = {},
	            e,
	            a = /\+/g,  // Regex for replacing addition symbol with a space
	            r = /([^&=]+)=?([^&]*)/g,
	            d = function(s) { return decodeURIComponent(s.replace(a, " ")); };

	        while ((e = r.exec(query))) {
	            urlParams[d(e[1])] = d(e[2]);
	        }

	        return urlParams;
	    },

	    /** 
	     * Query string adder
	     * Works for URLs without #.
	     * Original from:
	     * http://stackoverflow.com/questions/5999118/add-or-update-query-string-parameter
	     */
	    updateQueryString: function(uri, key, value) {
	        value = encodeURIComponent(value);
	        var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
	        var separator = uri.indexOf('?') !== -1 ? "&" : "?";
	        if (uri.match(re)) {
	            return uri.replace(re, '$1' + key + "=" + value + '$2');
	        } else {
	            return uri + separator + key + "=" + value;
	        }
	    },

	    /**
	     * A more strict encodeURIComponent that escapes `()'!`s
	     * Especially useful for creating URLs that are embeddable in markdown
	     *
	     * Adapted from
	     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent
	     * This function and the above original available under the
	     * CC-BY-SA 2.5 license.
	     */
	    strongEncodeURIComponent: function(str) {
	        return encodeURIComponent(str)
	            // Note that although RFC3986 reserves "!", RFC5987 does not,
	            // so we do not need to escape it
	            .replace(/['()!]/g, window.escape) // i.e., %27 %28 %29
	            .replace(/\*/g, '%2A');
	    },

	    // There are certain widgets where we don't want to provide the "answered"
	    // highlight indicator.
	    // The issue with just using the `graded` flag on questions is that showing
	    // that a certain widget is ungraded can sometimes reveal the answer to a
	    // question ("is this transformation possible? if so, do it")
	    // This is kind of a hack to get around this.
	    widgetShouldHighlight: function(widget) {
	        if (!widget) {
	            return false;
	        }
	        var HIGHLIGHT_BAR_BLACKLIST = ["measurer", "protractor"];
	        return !_.contains(HIGHLIGHT_BAR_BLACKLIST, widget.type);
	    },

	    /**
	     * If a widget says that it is empty once it is graded.
	     * Trying to encapsulate references to the score format.
	     */
	    scoreIsEmpty: function(score) {
	        return score.type === "invalid";
	    },

	    /**
	     * Extracts the location of a touch or mouse event, allowing you to pass
	     * in a "mouseup", "mousedown", or "mousemove" event and receive the
	     * correct coordinates. Shouldn't be used with "vmouse" events.
	     *
	     * The Util.touchHandlers are used to track the current state of the touch
	     * event, such as whether or not the user is currently pressed down (either
	     * through touch or mouse) on the screen.
	     */

	    touchHandlers: {
	        pointerDown: false,
	        currentTouchIdentifier: null
	    },

	    resetTouchHandlers: function() {
	        _.extend(Util.touchHandlers, {
	            pointerDown: false,
	            currentTouchIdentifier: null
	        });
	    },

	    extractPointerLocation: function(event) {
	        var touchOrEvent;

	        if (Util.touchHandlers.pointerDown) {
	            // Look for the touch matching the one we're tracking; ignore others
	            if (Util.touchHandlers.currentTouchIdentifier != null) {
	                var len = event.changedTouches ? event.changedTouches.length : 0;
	                for (var i = 0; i < len; i++) {
	                    if (event.changedTouches[i].identifier ===
	                            Util.touchHandlers.currentTouchIdentifier) {
	                        touchOrEvent = event.changedTouches[i];
	                    }
	                }
	            } else {
	                touchOrEvent = event;
	            }

	            var isEndish =
	                    event.type === "touchend" || event.type === "touchcancel";
	            if (touchOrEvent && isEndish) {
	                Util.touchHandlers.pointerDown = false;
	                Util.touchHandlers.currentTouchIdentifier = null;
	            }
	        } else {
	            // touchstart or mousedown
	            Util.touchHandlers.pointerDown = true;
	            if (event.changedTouches) {
	                touchOrEvent = event.changedTouches[0];
	                Util.touchHandlers.currentTouchIdentifier = touchOrEvent.identifier;
	            } else {
	                touchOrEvent = event;
	            }
	        }

	        if (touchOrEvent) {
	            return {
	                left: touchOrEvent.pageX,
	                top: touchOrEvent.pageY
	            };
	        }
	    },

	    /**
	     * Pass this function as the touchstart for an element to
	     * avoid sending the touch to the mobile scratchpad
	     */
	    captureScratchpadTouchStart: function(e) {
	        e.stopPropagation();
	    },

	    getImageSize: function(url, callback) {
	        var img = new Image();
	        img.onload = function() {
	            // IE 11 seems to have problems calculating the heights of svgs
	            // if they're not in the DOM. To solve this, we add the element to
	            // the dom, wait for a rerender, and use `.clientWidth` and
	            // `.clientHeight`. I think we could also solve the problem by
	            // adding the image to the document before setting the src, but then
	            // the experience would be worse for other browsers.
	            if (img.width === 0 && img.height === 0) {
	                document.body.appendChild(img);
	                _.defer(function() {
	                    callback(img.clientWidth, img.clientHeight);
	                    document.body.removeChild(img);
	                });
	            } else {
	                callback(img.width, img.height);
	            }
	        };

	        // Require here to prevent recursive imports
	        var SvgImage = __webpack_require__(64);
	        img.src = SvgImage.getRealImageUrl(url);
	    },

	    textarea: {

	        /**
	         * Gets the word right before where the textarea cursor is
	         *
	         * @param {Element} textarea - The textarea DOM element
	         * @return {JSON} - An object with the word and its starting and ending positions in the textarea
	         */
	        getWordBeforeCursor: function(textarea) {
	            var text = textarea.value;

	            var endPos = textarea.selectionStart - 1;
	            var startPos = Math.max(text.lastIndexOf("\n", endPos), text.lastIndexOf(' ', endPos)) + 1;

	            return {
	                string: text.substring(startPos, endPos + 1),
	                pos: {
	                    start: startPos,
	                    end: endPos
	                }
	            };
	        },

	        /**
	         * Moves the textarea cursor at the specified position
	         *
	         * @param {Element} textarea - The textarea DOM element
	         * @param {int} pos - The position where the cursor will be moved
	         */
	        moveCursor: function(textarea, pos) {
	            textarea.selectionStart = pos;
	            textarea.selectionEnd = pos;
	        }
	    }
	};

	Util.random = Util.seededRNG(new Date().getTime() & 0xffffffff);

	module.exports = Util;


/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Calculates whether a perseus item is renderable by a specific
	 * perseus-item-data version.
	 *
	 * This is done inside of the perseus repo so that it can traverse
	 * widget-specific data that might need to do a sub-traversal.
	 * This supports widgets that contain renderers, such as the
	 * group or sequence widgets.
	 */

	var _ = __webpack_require__(67);

	var Traversal = __webpack_require__(20);
	var Widgets = __webpack_require__(19);

	var isUpgradedWidgetInfoRenderableBy =
	        function(widgetInfo, widgetRendererVersion) {
	    if (widgetRendererVersion == null) {
	        // If the widget does not exist in this version, this will
	        // be null, and that version of perseus cannot render the
	        // widget (it doesn't even know the widget exists!)
	        return false;
	    }

	    var widgetVersion = widgetInfo.version || {major: 0, minor: 0};
	    if (widgetRendererVersion.major > widgetVersion.major) {
	        return true;
	    } else if (widgetRendererVersion.major < widgetVersion.major) {
	        return false;
	    } else {
	        // If the major versions are the same, the minor version acts
	        // like a tie-breaker.
	        // For example, input-number 3.2 can render an input-number
	        // 2.4, 3.0, or 3.2, but not an input number 3.3 or 4.0.
	        return widgetRendererVersion.minor >= widgetVersion.minor;
	    }
	};

	var isRawWidgetInfoRenderableBy = function(widgetInfo,
	        rendererContentVersion) {
	    // Empty/non-existant widgets are always safe to render
	    if (widgetInfo == null || widgetInfo.type == null) {
	        return true;
	    }

	    // NOTE: This doesn't modify the widget info if the widget info
	    // is at a later version than is supported.
	    var upgradedWidgetInfo = Widgets.upgradeWidgetInfoToLatestVersion(
	        widgetInfo
	    );
	    return isUpgradedWidgetInfoRenderableBy(
	        upgradedWidgetInfo,
	        rendererContentVersion[upgradedWidgetInfo.type]
	    );
	};

	var isRendererContentRenderableBy =
	        function(rendererOptions, rendererContentVersion) {
	    var isRenderable = true;
	    Traversal.traverseRendererDeep(
	        rendererOptions,
	        null,
	        function(widgetInfo) {
	            isRenderable = isRenderable && isRawWidgetInfoRenderableBy(
	                widgetInfo,
	                rendererContentVersion
	            );
	        }
	    );
	    return isRenderable;
	};

	var isItemRenderableBy = function(itemData, rendererContentVersion) {
	    if (itemData == null || rendererContentVersion == null) {
	        throw new Error("missing parameter to Perseus.isRenderable.item");
	    }
	    return isRendererContentRenderableBy(
	        itemData.question,
	        rendererContentVersion
	    );
	};

	module.exports = {
	    isItemRenderableByVersion: isItemRenderableBy
	};


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Functions for extracting data from items for use in i18n.
	 */
	var _ = __webpack_require__(67);

	var traversal = __webpack_require__(20);
	var PerseusMarkdown = __webpack_require__(57);

	// Takes a renderer content and parses the markdown for images
	function findImagesInContent(content, images) {
	    var parsed = PerseusMarkdown.parse(content);

	    PerseusMarkdown.traverseContent(parsed, function(node) {
	        if (node.type === "image") {
	            images.push(node.target);
	        }
	    });
	}

	// Background images in some widgets are annoying to deal with because
	// sometimes the objects aren't full when there isn't an image. So, we do some
	// extra checking to make sure we don't cause an error or push an empty image.
	function handleBackgroundImage(graph, images) {
	    if (graph && graph.backgroundImage && graph.backgroundImage.url) {
	        images.push(graph.backgroundImage.url);
	    }
	}

	// The callback called for each widget. We check each of the areas of each
	// widget where they contain a renderer for images by calling
	// findImagesInContent. We don't have to recurse through child widgets, because
	// traverseRendererDeep does that for us.
	function widgetCallback(widgetInfo, images) {
	    if (!widgetInfo.options) {
	        return;
	    }

	    // TODO(emily/aria): Move this into the widget files, so we don't have the
	    // logic out here.
	    if (widgetInfo.type === "categorizer") {
	        _.each(widgetInfo.options.items, function(item) {
	            findImagesInContent(item, images);
	        });
	        _.each(widgetInfo.options.categories, function(category) {
	            findImagesInContent(category, images);
	        });
	    } else if (widgetInfo.type === "image") {
	        findImagesInContent(widgetInfo.options.title, images);
	        findImagesInContent(widgetInfo.options.caption, images);
	    } else if (widgetInfo.type === "matcher") {
	        _.each(widgetInfo.options.left, function(option) {
	            findImagesInContent(option, images);
	        });
	        _.each(widgetInfo.options.right, function(option) {
	            findImagesInContent(option, images);
	        });
	        _.each(widgetInfo.options.labels, function(label) {
	            findImagesInContent(label, images);
	        });
	    } else if (widgetInfo.type === "matrix") {
	        findImagesInContent(widgetInfo.options.prefix, images);
	        findImagesInContent(widgetInfo.options.suffix, images);
	    } else if (widgetInfo.type === "orderer") {
	        _.each(widgetInfo.options.options, function(option) {
	            findImagesInContent(option.content, images);
	        });
	    } else if (widgetInfo.type === "passage") {
	        findImagesInContent(widgetInfo.options.passageTitle, images);
	    } else if (widgetInfo.type === "radio") {
	        _.each(widgetInfo.options.choices, function(choice) {
	            findImagesInContent(choice.content, images);
	        });
	    } else if (widgetInfo.type === "sorter") {
	        _.each(widgetInfo.options.correct, function(option) {
	            findImagesInContent(option, images);
	        });
	    } else if (widgetInfo.type === "table") {
	        _.each(widgetInfo.options.headers, function(header) {
	            findImagesInContent(header, images);
	        });
	    }

	    if (widgetInfo.type === "grapher") {
	        handleBackgroundImage(widgetInfo.options.graph, images);
	    } else if (widgetInfo.type === "image") {
	        handleBackgroundImage(widgetInfo.options, images);
	    } else if (widgetInfo.type === "interactive-graph") {
	        handleBackgroundImage(widgetInfo.options, images);
	    } else if (widgetInfo.type === "measurer" && widgetInfo.options.image) {
	        images.push(widgetInfo.options.image.url);
	    } else if (widgetInfo.type === "plotter") {
	        images.push(widgetInfo.options.picUrl);
	    } else if (widgetInfo.type === "transformer") {
	        handleBackgroundImage(widgetInfo.options.graph, images);
	    }
	}

	// Calls findImagesInContent on all of the different content areas
	function findImagesInItemData(itemData) {
	    var images = [];

	    var renderers = [itemData.question].concat(itemData.hints);

	    _.each(renderers, function(renderer)  {
	        traversal.traverseRendererDeep(
	            renderer,
	            function(content)  {
	                findImagesInContent(content, images);
	            },
	            function(widget)  {return widgetCallback(widget, images);}
	        );
	    });

	    return images;
	}

	module.exports = {
	    findImagesInItemData: findImagesInItemData
	};


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Renderer = __webpack_require__(15);
	var QuestionParagraph = __webpack_require__(54);
	var WidgetContainer = __webpack_require__(55);
	var Widgets = __webpack_require__(19);

	var Util = __webpack_require__(5);
	var EnabledFeatures = __webpack_require__(56);
	var ApiOptions = __webpack_require__(17).Options;

	var SINGLE_ITEM_WIDGET_ID = "answer-area";
	var PT = React.PropTypes;

	var AnswerAreaRenderer = React.createClass({displayName: 'AnswerAreaRenderer',
	    propTypes: {
	        type: PT.string,
	        options: PT.object,
	        calculator: PT.bool,
	        periodicTable: PT.bool,
	        problemNum: PT.number,
	        onInteractWithWidget: PT.func.isRequired,
	        enabledFeatures: EnabledFeatures.propTypes,
	        highlightedWidgets: PT.array.isRequired,
	        apiOptions: ApiOptions.propTypes
	    },

	    getDefaultProps: function() {
	        return {
	            problemNum: 0,
	            onInteractWithWidget: function() {},
	            enabledFeatures: EnabledFeatures.defaults,
	            highlightedWidgets: [],
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    getInitialState: function() {
	        // TODO(alpert): Move up to parent props?
	        return {
	            widget: {},
	            cls: this.getClass(this.props.type)
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.setState({cls: this.getClass(nextProps.type)});
	    },

	    getWidgetInstance: function() {
	        // Half the time this is a Renderer; the other half of the time it's a
	        // real widget.
	        if (this.props.type === "multiple") {
	            return this.refs.widget;
	        } else {
	            return this.refs.container.getWidget();
	        }
	    },

	    getClass: function(type) {
	        if (type === "multiple") {
	            return Renderer;
	        } else {
	            return Widgets.getWidget(type, this.props.enabledFeatures);
	        }
	    },

	    render: function() {
	        if (this.props.type === "multiple") {
	            return this.renderMultiple();
	        } else {
	            return this.renderSingle();
	        }
	    },

	    emptyWidgets: function() {
	        if (this.props.type === "multiple") {
	            return this.getWidgetInstance().emptyWidgets();
	        } else {
	            return Util.scoreIsEmpty(
	                this.getWidgetInstance().simpleValidate(this.props.options)) ?
	                [SINGLE_ITEM_WIDGET_ID] : [];
	        }
	    },

	    // Gets a focus object fixed up with an "answer-" prefix for
	    // onFocusChange when type === "multiple"
	    _getAnswerAreaFocusObj: function(rendererFocusPath) {
	        if (rendererFocusPath == null) {
	            return rendererFocusPath;
	        }
	        // TODO(jack): make "answer" the first element of the prefix
	        // array, rather than modifying the widgetId, once we have
	        // expunged widgetIds from the rest of the api calls in
	        // favor of focus paths
	        var answerPath = ["answer-" + _.first(rendererFocusPath)].concat(
	            _.rest(rendererFocusPath));
	        return answerPath;
	    },

	    renderMultiple: function() {
	        var parentOnFocusChange = this.props.apiOptions.onFocusChange;
	        var apiOptions = _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions,
	            parentOnFocusChange && {
	                onFocusChange: function(newFocus, oldFocus)  {
	                    // If we have an apiOptions.onFocusChange, call
	                    // it with an "answer-" prefix on our widget id
	                    parentOnFocusChange(
	                        this._getAnswerAreaFocusObj(newFocus),
	                        this._getAnswerAreaFocusObj(oldFocus)
	                    );
	                }.bind(this)
	            }
	        );

	        return React.createElement(this.state.cls, React.__spread({
	            ref: "widget", 
	            problemNum: this.props.problemNum, 
	            onChange: this.handleChangeRenderer, 
	            onInteractWithWidget: this.props.onInteractWithWidget, 
	            highlightedWidgets: this.props.highlightedWidgets, 
	            enabledFeatures: _.extend({}, this.props.enabledFeatures, {
	                // Hide answer area tooltip formats,
	                // the "Acceptable formats" box already works
	                toolTipFormats: false
	            }), 
	            apiOptions: apiOptions}, 
	            this.props.options, 
	            this.state.widget)
	        );
	    },

	    renderSingle: function() {
	        var shouldHighlight = _.contains(this.props.highlightedWidgets,
	                                    SINGLE_ITEM_WIDGET_ID);

	        return React.createElement(QuestionParagraph, null, 
	            React.createElement(WidgetContainer, {
	                ref: "container", 
	                key: this.props.type, 
	                enabledFeatures: this.props.enabledFeatures, 
	                type: this.props.type, 
	                initialProps: this.getSingleWidgetProps(), 
	                shouldHighlight: shouldHighlight})
	        );
	    },

	    getSingleWidgetProps: function() {
	        var apiOptions = _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions
	        );

	        // Pass onFocus/onBlur handlers to each widget, so they
	        // can trigger `onFocusChange`s if/when those happen.
	        // Since we're just a single widget, any focusing has
	        // to be from nothing (path: null), and any blurring has
	        // to be to nothing. Our parent ItemRenderer will handle
	        // connecting the dots between these events and any
	        // focusing/blurring between elements in the question
	        // area to combine this event with those into a single
	        // onChangeFocus at the ItemRenderer level.
	        var onFocus = function(path, elem)  {
	            this._isFocused = true;
	            apiOptions.onFocusChange(
	                [SINGLE_ITEM_WIDGET_ID].concat(path),
	                // we're pretending we're a renderer, so if we got
	                // focus, we must not have had it before
	                null);
	        }.bind(this);
	        var onBlur = function(path, elem)  {
	            this._isFocused = false;
	            apiOptions.onFocusChange(null,
	                [SINGLE_ITEM_WIDGET_ID].concat(path));
	        }.bind(this);

	        var initialWidgetProps = Widgets.getRendererPropsForWidgetInfo(
	            this.props,
	            this.props.problemNum
	        );

	        return _.extend({
	            widgetId: SINGLE_ITEM_WIDGET_ID,
	            problemNum: this.props.problemNum,
	            onChange: this.handleChangeRenderer,
	            enabledFeatures: _.extend({}, this.props.enabledFeatures, {
	                // Hide answer area tooltip formats,
	                // the "Acceptable formats" box already works
	                toolTipFormats: false
	            }),
	            apiOptions: apiOptions,
	            onFocus: onFocus,
	            onBlur: onBlur
	        }, initialWidgetProps, this.state.widget);
	    },

	    _setWidgetProps: function(widgetId, newProps, cb) {
	        // "area" -> global id "answer-area" ;)
	        if (widgetId === "area" && this.props.type !== "multiple") {
	            // We have a single widget
	            this.handleChangeRenderer(newProps, cb);
	        } else if (this.props.type === "multiple") {
	            // We have a `Renderer`
	            this.getWidgetInstance()._setWidgetProps(widgetId, newProps, cb);
	        } else if ((typeof console) !== "undefined" && console.error) {
	            // We have a widget id other than area in a non-renderer area
	            console.error(
	                "Sent invalid widget id `answer-" + widgetId +
	                "` to an answerArea of type `" + this.props.type + "`."
	            );
	        }
	    },

	    handleChangeRenderer: function(newProps, cb) {
	        var widget = _.extend({}, this.state.widget, newProps);
	        this.setState({widget: widget}, function()  {
	            if (this.props.type !== "multiple") {
	                var cbResult = cb && cb();
	                this.props.onInteractWithWidget(SINGLE_ITEM_WIDGET_ID);
	                // If we're not type === "multiple", send an onFocusChange
	                // event to focus to this widget if we aren't already focused.
	                // For type "multiple" these events are handled in the
	                // multiple's Renderer

	                if (cbResult !== false &&
	                        this.props.apiOptions.onFocusChange &&
	                        !this._isFocused) {
	                    this._isFocused = true;
	                    this.props.apiOptions.onFocusChange(
	                        [SINGLE_ITEM_WIDGET_ID],
	                        // we're pretending we're a renderer, so if we got
	                        // focus, we must not have had it before
	                        null);
	                }
	            }
	        }.bind(this));
	    },

	    componentDidMount: function() {
	        // Storing things directly on components should be avoided!
	        this._isFocused = false;
	        this.update();
	    },

	    componentDidUpdate: function(prevProps) {
	        this.update();

	        if (this.props.type !== "multiple" &&
	                prevProps.type === this.props.type) {
	            this.refs.container.replaceWidgetProps(
	                this.getSingleWidgetProps());
	        }
	    },

	    update: function() {
	        $("#calculator").toggle(this.props.calculator);
	        $(".periodic-table-info-box").toggle(this.props.periodicTable);
	    },

	    componentWillUnmount: function() {
	        if (this.props.calculator) {
	            $("#calculator").hide();
	        }
	        if (this.props.periodicTable) {
	            $(".periodic-table-info-box").hide();
	        }
	    },

	    getDOMNodeForPath: function(path) {
	        var prefixedWidgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        if (this.props.type === "multiple") {
	            var widgetId = prefixedWidgetId.replace('answer-', '');
	            var relativePath = [widgetId].concat(interWidgetPath);

	            // Answer-area is a renderer, so we can pass down the path
	            return this.getWidgetInstance().getDOMNodeForPath(relativePath);
	        } else {
	            // Answer-area is a widget, so we treat it like a widget, returning
	            // the outer node in the special-case that there is no remaining
	            // path.
	            var widget = this.getWidgetInstance();
	            var getNode = widget.getDOMNodeForPath;
	            if (getNode) {
	                return getNode(interWidgetPath);
	            } else if (interWidgetPath.length === 0) {
	                return widget.getDOMNode();
	            }
	        }
	    },

	    getGrammarTypeForPath: function(path) {
	        // TODO(emily): refactor this kind of logic out, or wait until alex
	        // kills the answer-area-renderer and solves it for me.
	        var prefixedWidgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        if (this.props.type === "multiple") {
	            var widgetId = prefixedWidgetId.replace('answer-', '');
	            var relativePath = [widgetId].concat(interWidgetPath);

	            // Answer-area is a renderer, so we can pass down the path
	            return this.getWidgetInstance().getGrammarTypeForPath(
	                relativePath);
	        } else {
	            // Answer-area is a widget, so we treat it like a widget.
	            var widget = this.getWidgetInstance();
	            return widget.getGrammarTypeForPath(interWidgetPath);
	        }
	    },

	    getInputPaths: function() {
	        if (this.props.type === "multiple") {
	            var inputPaths = this.getWidgetInstance().getInputPaths();
	            // We need to prefix our widgetIds with 'answer-' to preserve
	            // uniqueness when we return these to the item-renderer.
	            return _.map(inputPaths, function(path)  {
	                var prefixedWidget = 'answer-' + _.first(path);
	                return [prefixedWidget].concat(_.rest(path));
	            });
	        } else {
	            var widgetId = "answer-area";
	            var inputPaths = [];
	            var widget = this.getWidgetInstance();
	            if (widget.getInputPaths) {
	                // Grab all input paths and add widgetID to the front
	                var widgetInputPaths = widget.getInputPaths();

	                if (widgetInputPaths === widget) {
	                    // Special case: we allow you to just return the widget
	                    inputPaths.push([
	                        widgetId
	                    ]);
	                } else {
	                    // Add to collective list of inputs
	                    _.each(widgetInputPaths, function(inputPath)  {
	                        var relativeInputPath = [widgetId].concat(inputPath);
	                        inputPaths.push(relativeInputPath);
	                    });
	                }
	            }
	            return inputPaths;
	        }
	    },

	    focusPath: function(path) {
	        var prefixedWidgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        if (this.props.type === "multiple") {
	            var widgetId = prefixedWidgetId.replace('answer-', '');
	            var relativePath = [widgetId].concat(interWidgetPath);

	            // Answer-area is a renderer, so we can pass down the path
	            this.getWidgetInstance().focusPath(relativePath);
	        } else {
	            // Answer-area is a widget
	            var focusWidget = this.getWidgetInstance().focusInputPath;
	            focusWidget && focusWidget(interWidgetPath);
	        }
	    },

	    blurPath: function(path) {
	        var prefixedWidgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        if (this.props.type === "multiple") {
	            var widgetId = prefixedWidgetId.replace('answer-', '');
	            var relativePath = [widgetId].concat(interWidgetPath);

	            // Answer-area is a renderer, so we can pass down the path
	            this.getWidgetInstance().blurPath(relativePath);
	        } else {
	            // Answer-area is a widget
	            var blurWidget = this.getWidgetInstance().blurInputPath;
	            blurWidget && blurWidget(interWidgetPath);
	        }
	    },

	    focus: function() {
	        var focusContents = this.getWidgetInstance().focus;
	        focusContents && focusContents();
	    },

	    blur: function() {
	        var blurContents = this.getWidgetInstance().blur;
	        blurContents && blurContents();
	    },

	    setInputValue: function(path, newValue, focus) {
	        var prefixedWidgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        var newPath;
	        if (this.props.type === "multiple") {
	            var widgetId = prefixedWidgetId.replace('answer-', '');
	            var relativePath = [widgetId].concat(interWidgetPath);
	            newPath = relativePath;
	        } else {
	            newPath = interWidgetPath;
	        }

	        // Thankfully, the API is agnostic! So it doesn't matter if this is a
	        // renderer or a widget.
	        this.getWidgetInstance().setInputValue(newPath, newValue, focus);
	    },

	    guessAndScore: function() {
	        // TODO(alpert): These should probably have the same signature...
	        if (this.props.type === "multiple") {
	            return this.getWidgetInstance().guessAndScore();
	        } else {
	            var guess = this.getWidgetInstance().getUserInput();

	            var score;
	            if (this.props.graded == null || this.props.graded) {
	                // props.graded is unset or true
	                // TODO(alpert): Separate out the rubric
	                score = this.getWidgetInstance().simpleValidate(
	                    this.props.options);
	            } else {
	                score = Util.noScore;
	            }

	            return [guess, score];
	        }
	    }
	});

	module.exports = AnswerAreaRenderer;


/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var ArticleRenderer = __webpack_require__(10);
	var Editor = __webpack_require__(11);
	var EnabledFeatures = __webpack_require__(56);
	var JsonEditor = __webpack_require__(58);
	var Renderer = __webpack_require__(15);

	var rendererProps = React.PropTypes.shape({
	    content: React.PropTypes.string,
	    widgets: React.PropTypes.object,
	    images: React.PropTypes.object,
	});

	var SectionControlButton = React.createClass({displayName: 'SectionControlButton',
	    render: function() {
	        return React.createElement("a", {
	                href: "#", 
	                className: 
	                    "section-control-button " +
	                    "simple-button " +
	                    "simple-button--small " +
	                    "orange", 
	                
	                onClick: function(e)  {
	                    e.preventDefault();
	                    this.props.onClick();
	                }.bind(this)}, 
	            React.createElement("span", {className: this.props.icon})
	        );
	    }
	});

	var ArticleEditor = React.createClass({displayName: 'ArticleEditor',

	    propTypes: {
	        json: React.PropTypes.oneOfType([
	            rendererProps,
	            React.PropTypes.arrayOf(rendererProps)
	        ]),
	        apiOptions: React.PropTypes.object,
	        developerMode: React.PropTypes.bool,
	        enabledFeatures: EnabledFeatures.propTypes,
	        imageUploader: React.PropTypes.func,
	        onChange: React.PropTypes.func.isRequired,
	    },

	    getDefaultProps: function() {
	        return {
	            developerMode: false,
	            json: [{}],
	            enabledFeatures: {
	                toolTipFormats: true,
	                useMathQuill: true
	            },
	        };
	    },

	    getInitialState: function() {
	        return {
	            mode: "edit"
	        };
	    },

	    render: function() {

	        return React.createElement("div", {className: "framework-perseus perseus-article-editor"}, 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Mode:", " ", 
	                    React.createElement("select", {
	                            value: this.state.mode, 
	                            onChange: this._changeMode}, 
	                        React.createElement("option", {value: "edit"}, "Edit"), 
	                        React.createElement("option", {value: "preview"}, "Preview"), 
	                        this.props.developerMode &&
	                            React.createElement("option", {value: "json"}, 
	                                "Dev-only JSON"
	                            )
	                        
	                    )
	                )
	            ), 

	            (this.state.mode === "edit") &&
	                this._renderEditor(), 
	            

	            (this.state.mode === "preview") &&
	                this._renderPreviewMode(), 
	            

	            (this.props.developerMode && this.state.mode === "json") &&
	                React.createElement("div", null, 
	                    React.createElement(JsonEditor, {
	                        multiLine: true, 
	                        value: this.props.json, 
	                        onChange: this._handleJsonChange})
	                )
	            
	        );
	    },

	    _sections: function() {
	        return _.isArray(this.props.json) ?
	            this.props.json :
	            [this.props.json];
	    },

	    _renderEditor: function() {
	        return React.createElement("div", null, 
	            this._renderSections(), 
	            this._renderAddSection()
	        );
	    },

	    _renderSections: function() {
	        var apiOptions = _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions,
	            {
	                // Alignment options are always available in article editors
	                showAlignmentOptions: true
	            }
	        );

	        var sections = this._sections();

	        return React.createElement("div", {className: "perseus-editor-table"}, 
	            sections.map(function(section, i)  {
	                return [
	                    React.createElement("div", {className: "perseus-editor-row"}, 
	                        React.createElement("div", {className: "perseus-editor-left-cell"}, 
	                            React.createElement("div", {className: "pod-title"}, 
	                                "Section ", i+1, 
	                                React.createElement("div", {style: {
	                                    display: "inline-block",
	                                    float: "right"
	                                }}, 
	                                    (i + 1 < sections.length) &&
	                                        React.createElement(SectionControlButton, {
	                                            icon: "icon-circle-arrow-down", 
	                                            onClick: function()  {
	                                                this._handleMoveSectionLater(i);
	                                            }.bind(this)}), 
	                                    
	                                    (i > 0) &&
	                                        React.createElement(SectionControlButton, {
	                                            icon: "icon-circle-arrow-up", 
	                                            onClick: function()  {
	                                                this._handleMoveSectionEarlier(i);
	                                            }.bind(this)}), 
	                                    
	                                    React.createElement(SectionControlButton, {
	                                        icon: "icon-trash", 
	                                        onClick: function()  {
	                                            var msg = "Are you sure you " +
	                                                "want to remove section " +
	                                                (i + 1) + "?";
	                                            if (confirm(msg)) {
	                                                this._handleRemoveSection(i);
	                                            }
	                                        }.bind(this)}), 
	                                    React.createElement(SectionControlButton, {
	                                        icon: "icon-plus", 
	                                        onClick: function()  {
	                                            this._handleAddSectionAfter(i);
	                                        }.bind(this)})
	                                )
	                            ), 
	                            React.createElement(Editor, React.__spread({}, 
	                                section, 
	                                {ref: "editor" + i, 
	                                placeholder: "Type your section text here...", 
	                                imageUploader: this.props.imageUploader, 
	                                onChange: 
	                                    _.partial(this._handleEditorChange, i), 
	                                
	                                apiOptions: apiOptions, 
	                                enabledFeatures: this.props.enabledFeatures}))
	                        ), 

	                        React.createElement("div", {className: "perseus-editor-right-cell"}, 
	                            React.createElement(ArticleRenderer, {
	                                json: section, 
	                                ref: "renderer" + i, 
	                                apiOptions: apiOptions, 
	                                enabledFeatures: 
	                                    this.props.enabledFeatures
	                                })
	                        )
	                    )
	                ];
	            }.bind(this))
	        );
	    },

	    _renderAddSection: function() {
	        return React.createElement("div", {className: "perseus-editor-row"}, 
	            React.createElement("div", {className: "perseus-editor-left-cell"}, 
	                React.createElement("a", {href: "#", className: "simple-button orange", 
	                        onClick: function()  {
	                            this._handleAddSectionAfter(
	                                this._sections().length - 1
	                            );
	                        }.bind(this)}, 
	                    React.createElement("span", {className: "icon-plus"}), " Add a section"
	                )
	            ), 
	            React.createElement("div", {className: "perseus-editor-right-cell"})
	        );
	    },

	    _renderPreviewMode: function() {
	        return React.createElement(ArticleRenderer, {
	            json: this.props.json, 
	            apiOptions: this.props.apiOptions, 
	            enabledFeatures: this.props.enabledFeatures});
	    },

	    _changeMode: function(e) {
	        var newMode = e.target.value;
	        this.props.onChange({
	            json: this.serialize()
	        }, function()  {
	            this.setState({mode: newMode});
	        }.bind(this));
	    },

	    _handleJsonChange: function(newJson) {
	        this.props.onChange({json: newJson});
	    },

	    _handleEditorChange: function(i, newProps) {
	        var sections = _.clone(this._sections());
	        sections[i] = _.extend({}, sections[i], newProps);
	        this.props.onChange({json: sections});
	    },

	    _handleMoveSectionEarlier: function(i) {
	        if (i === 0) {
	            return;
	        }
	        var sections = _.clone(this._sections());
	        var section = sections[i];
	        sections.splice(i, 1);
	        sections.splice(i - 1, 0, section);
	        this.props.onChange({
	            json: sections
	        });
	    },

	    _handleMoveSectionLater: function(i) {
	        var sections = _.clone(this._sections());
	        if (i + 1 === sections.length) {
	            return;
	        }
	        var section = sections[i];
	        sections.splice(i, 1);
	        sections.splice(i + 1, 0, section);
	        this.props.onChange({
	            json: sections
	        });
	    },

	    _handleAddSectionAfter: function(i) {
	        // We do a full serialization here because we
	        // might be copying widgets:
	        var sections = _.clone(this.serialize());
	        // Here we do magic to allow you to copy-paste
	        // things from the previous section into the new
	        // section while preserving widgets.
	        // To enable this, we preserve the widgets
	        // object for the new section, but wipe out
	        // the content.
	        var newSection = (i >= 0) ? {
	            widgets: sections[i].widgets
	        } : {};
	        sections.splice(i + 1, 0, newSection);
	        this.props.onChange({
	            json: sections
	        });
	    },

	    _handleRemoveSection: function(i) {
	        var sections = _.clone(this._sections());
	        sections.splice(i, 1);
	        this.props.onChange({
	            json: sections
	        });
	    },

	    serialize: function() {
	        if (this.state.mode === "edit") {
	            return this._sections().map(function(section, i)  {
	                return this.refs["editor" + i].serialize();
	            }.bind(this));
	        } else if (this.state.mode === "preview" ||
	                this.state.mode === "json") {
	            return this.props.json;
	        } else {
	            throw new Error("Could not serialize; mode " +
	                this.state.mode + " not found"
	            );
	        }
	    },
	});

	module.exports = ArticleEditor;


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var Renderer = __webpack_require__(15);
	var Util = __webpack_require__(5);

	var rendererProps = React.PropTypes.shape({
	    content: React.PropTypes.string,
	    widgets: React.PropTypes.object,
	    images: React.PropTypes.object,
	});

	var ArticleRenderer = React.createClass({displayName: 'ArticleRenderer',

	    propTypes: {
	        json: React.PropTypes.oneOfType([
	            rendererProps,
	            React.PropTypes.arrayOf(rendererProps)
	        ]).isRequired,
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        return nextProps !== this.props || nextState !== this.state;
	    },

	    render: function() {
	        // TODO(alex): Make this render in multiple Renderers vs. in one
	        var content = this._sections().map(function(section, i)  {
	            return "[[" + Util.snowman + " group " + i + "]]";
	        }).join("\n\n");
	        
	        var widgets = {};
	        _.each(this._sections(), function(section, i)  {
	            var widgetId = "group " + i;
	            widgets[widgetId] = {
	                type: "group",
	                graded: true,
	                version: {major: 0, minor: 0},
	                options: section
	            };
	        });

	        return React.createElement("div", {className: "framework-perseus perseus-article"}, 
	            React.createElement(Renderer, {
	                content: content, 
	                widgets: widgets, 
	                apiOptions: this.props.apiOptions, 
	                enabledFeatures: this.props.enabledFeatures})
	        );
	    },

	    _sections: function() {
	        return _.isArray(this.props.json) ?
	            this.props.json :
	            [this.props.json];
	    },
	});

	module.exports = ArticleRenderer;


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var DragTarget = __webpack_require__(72);
	var EnabledFeatures = __webpack_require__(56);
	var PerseusMarkdown = __webpack_require__(57);
	var PropCheckBox = __webpack_require__(65);
	var Util = __webpack_require__(5);
	var Widgets = __webpack_require__(19);

	var WIDGET_PROP_BLACKLIST = __webpack_require__(69);

	// like [[snowman input-number 1]]
	var widgetPlaceholder = "[[\u2603 {id}]]";
	var widgetRegExp = "(\\[\\[\u2603 {id}\\]\\])";
	var rWidgetSplit = new RegExp(widgetRegExp.replace('{id}', '[a-z-]+ [0-9]+'),
	                              'g');

	var shortcutRegexp = /^\[\[([a-z\-]+)$/; // like [[nu, [[int, etc

	var ENDS_WITH_A_PARAGRAPH = /(?:\n{2,}|^\n*)$/;
	var TRAILING_NEWLINES = /(\n*)$/;
	var LEADING_NEWLINES = /^(\n*)/;

	var commafyInteger = function(n)  {
	    var str = n.toString();
	    if (str.length >= 5) {
	        str = str.replace(/(\d)(?=(\d{3})+$)/g, "$1{,}");
	    }
	    return str;
	};
	var makeEndWithAParagraphIfNecessary = function(content)  {
	    if (!ENDS_WITH_A_PARAGRAPH.test(content)) {
	        var newlines = TRAILING_NEWLINES.exec(content)[1];
	        return content + "\n\n".slice(0, 2 - newlines.length);
	    } else {
	        return content;
	    }
	};
	var makeStartWithAParagraphAlways = function(content)  {
	    var newlines = LEADING_NEWLINES.exec(content)[1];
	    return "\n\n".slice(0, 2 - newlines.length) + content;
	};

	var WidgetSelect = React.createClass({displayName: 'WidgetSelect',
	    shouldComponentUpdate: function() {
	        return false;
	    },

	    render: function() {
	        var widgets = Widgets.getPublicWidgets();
	        var orderedWidgetNames = _.sortBy(_.keys(widgets), function(name)  {
	            return widgets[name].displayName;
	        });

	        return React.createElement("select", {value: "", onChange: this.handleChange}, 
	            React.createElement("option", {value: ""}, "Add a widget", "\u2026"), 
	            React.createElement("option", {disabled: true}, "--"), 
	            _.map(orderedWidgetNames, function(name)  {
	                return React.createElement("option", {key: name, value: name}, 
	                    widgets[name].displayName
	                );
	            })
	        );
	    },

	    handleChange: function(e) {
	        var widgetType = e.target.value;
	        if (widgetType === "") {
	            // TODO(alpert): Not sure if change will trigger here
	            // but might as well be safe
	            return;
	        }
	        if (this.props.onChange) {
	            this.props.onChange(widgetType);
	        }
	    },
	});

	// This component handles upgading widget editor props via prop
	// upgrade transforms. Widget editors will always be rendered
	// with all available transforms applied, but the results of those
	// transforms will not be propogated upwards until serialization.
	var WidgetEditor = React.createClass({displayName: 'WidgetEditor',
	    propTypes: {
	        // Unserialized props
	        id: React.PropTypes.string.isRequired,
	        onChange: React.PropTypes.func.isRequired,
	        onRemove: React.PropTypes.func.isRequired,
	        apiOptions: ApiOptions.propTypes,

	        // Serialized props
	        type: React.PropTypes.string.isRequired,
	        graded: React.PropTypes.bool,
	        options: React.PropTypes.object,
	        version: React.PropTypes.shape({
	            major: React.PropTypes.number.isRequired,
	            minor: React.PropTypes.number.isRequired,
	        }),
	    },

	    getInitialState: function() {
	        return {
	            showWidget: true
	        };
	    },

	    componentWillMount: function() {
	        this._upgradeWidgetInfo(this.props);
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this._upgradeWidgetInfo(nextProps);
	    },

	    _upgradeWidgetInfo: function(props) {
	        // We can't call serialize here because this.refs.widget
	        // doesn't exist before this component is mounted.
	        var filteredProps = _.omit(props, WIDGET_PROP_BLACKLIST);
	        this.setState({
	            widgetInfo: Widgets.upgradeWidgetInfoToLatestVersion(filteredProps)
	        });
	    },

	    render: function() {
	        var widgetInfo = this.state.widgetInfo;

	        var Ed = Widgets.getEditor(widgetInfo.type);
	        var supportedAlignments;
	        if (this.props.apiOptions.showAlignmentOptions) {
	            supportedAlignments =
	                Widgets.getSupportedAlignments(widgetInfo.type);
	        } else {
	            supportedAlignments = ["default"];
	        }

	        var isUngradedEnabled = (widgetInfo.type === "transformer");
	        var gradedPropBox = React.createElement(PropCheckBox, {label: "Graded:", 
	                                graded: widgetInfo.graded, 
	                                onChange: this.props.onChange});

	        return React.createElement("div", {className: "perseus-widget-editor"}, 
	            React.createElement("div", {className: "perseus-widget-editor-title " +
	                    (this.state.showWidget ? "open" : "closed")}, 
	                React.createElement("a", {href: "#", onClick: this._toggleWidget}, 
	                    this.props.id, 
	                    React.createElement("i", {className: "icon-chevron-" +
	                            (this.state.showWidget ? "down" : "right")})
	                ), 
	                supportedAlignments.length > 1 && 
	                React.createElement("select", {
	                        className: "alignment", 
	                        value: widgetInfo.alignment, 
	                        onChange: this._handleAlignmentChange}, 
	                    supportedAlignments.map(function(alignment) 
	                        {return React.createElement("option", {key: alignment}, alignment);})
	                ), 
	                React.createElement("a", {href: "#", className: 
	                            "remove-widget " +
	                            "simple-button simple-button--small orange", 
	                        
	                        onClick: function(e)  {
	                            e.preventDefault();
	                            this.props.onRemove();
	                        }.bind(this)}, 
	                    React.createElement("span", {className: "icon-trash"})
	                )
	            ), 
	            React.createElement("div", {className: "perseus-widget-editor-content " +
	                    (this.state.showWidget ? "enter" : "leave")}, 
	                isUngradedEnabled && gradedPropBox, 
	                React.createElement(Ed, React.__spread({
	                    ref: "widget", 
	                    onChange: this._handleWidgetChange, 
	                    apiOptions: this.props.apiOptions}, 
	                    widgetInfo.options))
	            )
	        );
	    },

	    _toggleWidget: function(e) {
	        e.preventDefault();
	        this.setState({showWidget: !this.state.showWidget});
	    },

	    _handleWidgetChange: function(newProps, cb, silent) {
	        var newWidgetInfo = _.clone(this.state.widgetInfo);
	        newWidgetInfo.options = _.extend(
	            this.refs.widget.serialize(),
	            newProps
	        );
	        this.props.onChange(newWidgetInfo, cb, silent);
	    },

	    _handleAlignmentChange: function (e) {
	        var newAlignment = e.target.value;
	        var newWidgetInfo = _.clone(this.state.widgetInfo);
	        newWidgetInfo.alignment = newAlignment;
	        this.props.onChange(newWidgetInfo);
	    },

	    getSaveWarnings: function() {
	        var issuesFunc = this.refs.widget.getSaveWarnings;
	        return issuesFunc ? issuesFunc() : [];
	    },

	    serialize: function() {
	        // TODO(alex): Make this properly handle the case where we load json
	        // with a more recent widget version than this instance of Perseus
	        // knows how to handle.
	        var widgetInfo = this.state.widgetInfo;
	        return {
	            type: widgetInfo.type,
	            alignment: widgetInfo.alignment,
	            graded: widgetInfo.graded,
	            options: this.refs.widget.serialize(),
	            version: widgetInfo.version,
	        };
	    }
	});

	// This is more general than the actual markdown image parsing regex,
	// which is fine for correctness since it should only mean we could
	// store extra image dimensions, unless the question is insanely
	// formatted.
	// A simplified regex here should hopefully be easier to keep in
	// sync if the markdown parsing changes, though if it becomes
	// easy to hook into the actual markdown regex without copy-pasting
	// it, we should do that.
	var IMAGE_REGEX = /!\[[^\]]*\]\(([^\s\)]+)[^\)]*\)/g;

	/**
	 * Find all the matches to a /g regex.
	 *
	 * Returns an array of the regex matches. Infinite loops if `regex` does not
	 * have a /g modifier.
	 *
	 * Note: Returns an array of the capture objects, whereas String::match
	 * ignores captures. If you don't need captures, use String::match
	 */
	var allMatches = function(regex, str) {
	    var result = [];
	    while (true) {
	        var match = regex.exec(str);
	        if (!match) {
	            break;
	        }
	        result.push(match);
	    }
	    return result;
	};

	/**
	 * Return an array of URLs of all the images in the given renderer
	 * markdown.
	 */
	var imageUrlsFromContent = function(content) {
	    return _.map(
	        allMatches(IMAGE_REGEX, content),
	        function(capture)  {return capture[1];}
	    );
	};

	var Editor = React.createClass({displayName: 'Editor',
	    propTypes: {
	        imageUploader: React.PropTypes.func,
	        apiOptions: ApiOptions.propTypes,
	    },

	    getDefaultProps: function() {
	        return {
	            content: "",
	            placeholder: "",
	            widgets: {},
	            images: {},
	            disabled: false,
	            widgetEnabled: true,
	            immutableWidgets: false,
	            showWordCount: false,
	            apiOptions: ApiOptions.defaults,
	        };
	    },

	    getWidgetEditor: function(id, type) {
	        if (!Widgets.getEditor(type)) {
	            return;
	        }
	        return React.createElement(WidgetEditor, React.__spread({
	            ref: id, 
	            id: id, 
	            type: type, 
	            onChange: this._handleWidgetEditorChange.bind(this, id), 
	            onRemove: this._handleWidgetEditorRemove.bind(this, id), 
	            apiOptions: this.props.apiOptions}, 
	            this.props.widgets[id]));
	    },

	    _handleWidgetEditorChange: function(id, newProps, cb, silent) {
	        var widgets = _.clone(this.props.widgets);
	        widgets[id] = _.extend({}, widgets[id], newProps);
	        this.props.onChange({widgets: widgets}, cb, silent);
	    },

	    _handleWidgetEditorRemove: function(id) {
	        var re = new RegExp(widgetRegExp.replace('{id}', id), 'gm');
	        var textarea = this.refs.textarea.getDOMNode();

	        this.props.onChange({content: textarea.value.replace(re, '')});
	    },

	    /**
	     * Calculate the size of all the images in props.content, and send
	     * those sizes to this.props.images using props.onChange.
	     */
	    _sizeImages: function(props) {
	        var imageUrls = imageUrlsFromContent(props.content);

	        // Discard any images in our dimension table that no
	        // longer exist in content.
	        var images = _.pick(props.images, imageUrls);

	        // Only calculate sizes for images that were not present previously.
	        // Most content edits shouldn't have new images.
	        // This could get weird in the case of multiple images with the same
	        // URL, if you've changed the backing image size, but given graphie
	        // hashes it's probably an edge case.
	        var newImageUrls = _.filter(imageUrls, function(url)  {return !images[url];});

	        // TODO(jack): Q promises would make this nicer and only
	        // fire once.
	        _.each(newImageUrls, function(url)  {
	            Util.getImageSize(url, function(width, height)  {
	                // We keep modifying the same image object rather than a new
	                // copy from this.props because all changes here are additive.
	                // Maintaining old changes isn't strictly necessary if
	                // props.onChange calls are not batched, but would be if they
	                // were, so this is nice from that anti-race-condition
	                // perspective as well.
	                images[url] = {
	                    width: width,
	                    height: height
	                };
	                props.onChange({
	                        images: _.clone(images)
	                    },
	                    null, // callback
	                    true // silent
	                );
	            });
	        });
	    },

	    render: function() {
	        var pieces;
	        var widgets;
	        var underlayPieces;
	        var widgetsDropDown;
	        var templatesDropDown;
	        var widgetsAndTemplates;
	        var wordCountDisplay;

	        if (this.props.showWordCount) {
	            var numChars = PerseusMarkdown.characterCount(this.props.content);
	            var numWords = Math.floor(numChars / 6);
	            wordCountDisplay = React.createElement("span", {
	                    className: "perseus-editor-word-count", 
	                    title: '~' + commafyInteger(numWords) + ' words (' +
	                                 commafyInteger(numChars) + ' characters)'}, 
	                commafyInteger(numWords)
	            );
	        }

	        if (this.props.widgetEnabled) {
	            pieces = Util.split(this.props.content, rWidgetSplit);
	            widgets = {};
	            underlayPieces = [];

	            for (var i = 0; i < pieces.length; i++) {
	                var type = i % 2;
	                if (type === 0) {
	                    // Normal text
	                    underlayPieces.push(pieces[i]);
	                } else {
	                    // Widget reference
	                    var match = Util.rWidgetParts.exec(pieces[i]);
	                    var id = match[1];
	                    var type = match[2];

	                    var selected = false;
	                    // TODO(alpert):
	                    // var selected = focused && selStart === selEnd &&
	                    //         offset <= selStart &&
	                    //         selStart < offset + text.length;
	                    // if (selected) {
	                    //     selectedWidget = id;
	                    // }

	                    var duplicate = id in widgets;

	                    widgets[id] = this.getWidgetEditor(id, type);
	                    var classes = (duplicate || !widgets[id] ? "error " : "") +
	                            (selected ? "selected " : "");
	                    var key = duplicate ? i : id;
	                    underlayPieces.push(
	                            React.createElement("b", {className: classes, key: key}, pieces[i]));
	                }
	            }

	            // TODO(alpert): Move this to the content-change event handler
	            // _.each(_.keys(this.props.widgets), function(id) {
	            //     if (!(id in widgets)) {
	            //         // It's strange if these preloaded options stick around
	            //         // since it's inconsistent with how things work if you
	            //         // don't have the serialize/deserialize step in the
	            //         // middle
	            //         // TODO(alpert): Save options in a consistent manner so
	            //         // that you can undo the deletion of a widget
	            //         delete this.props.widgets[id];
	            //     }
	            // }, this);

	            this.widgetIds = _.keys(widgets);
	            widgetsDropDown = React.createElement(WidgetSelect, {
	                    ref: "widgetSelect", 
	                    onChange: this._addWidget});

	            templatesDropDown = React.createElement("select", {onChange: this.addTemplate}, 
	                React.createElement("option", {value: ""}, "Insert template", "\u2026"), 
	                React.createElement("option", {disabled: true}, "--"), 
	                React.createElement("option", {value: "table"}, "Table"), 
	                React.createElement("option", {value: "titledTable"}, "Titled table"), 
	                React.createElement("option", {value: "alignment"}, "Aligned equations"), 
	                React.createElement("option", {value: "piecewise"}, "Piecewise function")
	            );

	            if (!this.props.immutableWidgets) {
	                widgetsAndTemplates = React.createElement("div", {className: "perseus-editor-widgets"}, 
	                    React.createElement("div", {className: "perseus-editor-widgets-selectors"}, 
	                        widgetsDropDown, 
	                        templatesDropDown, 
	                        wordCountDisplay
	                    ), 
	                    React.addons.createFragment(widgets)
	                );
	                // Prevent word count from being displayed elsewhere
	                wordCountDisplay = null;
	            }
	        } else {
	            underlayPieces = [this.props.content];
	        }

	        // Without this, the underlay isn't the proper size when the text ends
	        // with a newline.
	        underlayPieces.push(React.createElement("br", {key: "end"}));

	        var completeTextarea = [
	                React.createElement("div", {className: "perseus-textarea-underlay", 
	                     ref: "underlay", 
	                     key: "underlay"}, 
	                    underlayPieces
	                ),
	                React.createElement("textarea", {ref: "textarea", 
	                          key: "textarea", 
	                          onChange: this.handleChange, 
	                          onKeyDown: this._handleKeyDown, 
	                          placeholder: this.props.placeholder, 
	                          disabled: this.props.disabled, 
	                          value: this.props.content})
	            ];
	        var textareaWrapper;
	        if (this.props.imageUploader) {
	            textareaWrapper = React.createElement(DragTarget, {
	                    onDrop: this.handleDrop, 
	                    className: "perseus-textarea-pair"}, 
	                completeTextarea
	            );
	        } else {
	            textareaWrapper = React.createElement("div", {className: "perseus-textarea-pair"}, 
	                completeTextarea
	            );
	        }

	        return React.createElement("div", {className: "perseus-single-editor " +
	                (this.props.className || "")}, 
	            textareaWrapper, 
	            wordCountDisplay, 
	            widgetsAndTemplates
	        );
	    },

	    componentDidMount: function() {
	        // This can't be in componentWillMount because that's happening during
	        // the middle of our parent's render, so we can't call
	        // this.props.onChange during that, since it calls our parent's
	        // setState
	        this._sizeImages(this.props);
	    },

	    componentDidUpdate: function(prevProps) {
	        // TODO(alpert): Maybe fix React so this isn't necessary
	        var textarea = this.refs.textarea.getDOMNode();
	        textarea.value = this.props.content;

	        // This can't be in componentWillReceiveProps because that's happening
	        // during the middle of our parent's render.
	        if (this.props.content !== prevProps.content) {
	            this._sizeImages(this.props);
	        }
	    },

	    handleDrop: function(e) {
	        var content = this.props.content;
	        var dataTransfer = e.nativeEvent.dataTransfer;

	        // files will hold something if the drag was from the desktop or a file
	        // located on the user's computer.
	        var files = dataTransfer.files;

	        // ... but we only get a url if the drag originated in another window
	        if (files.length === 0) {
	            var imageUrl = dataTransfer.getData("URL");

	            if (imageUrl) {
	                // TODO(joel) - relocate when the image upload dialog lands
	                var newContent = content + "\n\n![](" + imageUrl + ")";
	                this.props.onChange({ content: newContent });
	            }

	            return;
	        }

	        /* For each file we make sure it's an image, then create a sentinel -
	         * snowman + identifier to insert into the current text. The sentinel
	         * only lives there temporarily until we get a response back from the
	         * server that the image is now hosted on AWS, at which time we replace
	         * the temporary sentinel with the permanent url for the image.
	         *
	         * There is an abuse of tap in the middle of the pipeline to make sure
	         * everything is sequenced in the correct order. We want to modify the
	         * content (given any number of images) at the same time, i.e. only
	         * once, so we do that step with the tap. After the content has been
	         * changed we send off the request for each image.
	         *
	         * Note that the snowman doesn't do anything special in this case -
	         * it's effectively just part of a broken link. Perseus could be
	         * extended to recognize this sentinel and highlight it like for
	         * widgets.
	         */
	        _(files)
	            .chain()
	            .map(function(file) {
	                if (!file.type.match('image.*')) {
	                    return null;
	                }

	                var sentinel = "\u2603 " + _.uniqueId("image_");
	                // TODO(joel) - figure out how to temporarily include the image
	                // before the server returns.
	                content += "\n\n![](" + sentinel + ")";

	                return { file: file, sentinel: sentinel };
	            })
	            .reject(_.isNull)
	            .tap(function()  { this.props.onChange({ content: content }); }.bind(this))
	            .each(function(fileAndSentinel)  {
	                this.props.imageUploader(fileAndSentinel.file, function(url)  {
	                    this.props.onChange({
	                        content: this.props.content.replace(
	                            fileAndSentinel.sentinel, url)
	                    });
	                }.bind(this));
	            }.bind(this));
	    },

	    handleChange: function() {
	        var textarea = this.refs.textarea.getDOMNode();
	        this.props.onChange({content: textarea.value});
	    },

	    _handleKeyDown: function(e) {
	        if (e.key === "Tab") {
	            var textarea = this.refs.textarea.getDOMNode();

	            var word = Util.textarea.getWordBeforeCursor(textarea);
	            var matches = word.string.toLowerCase().match(shortcutRegexp);

	            if (matches != null) {
	                var text = matches[1];
	                var widgets = Widgets.getAllWidgetTypes();
	                var matchingWidgets = _.filter(widgets, function(name)  {
	                    return name.substring(0, text.length) === text;
	                });

	                if (matchingWidgets.length === 1) {
	                    var widgetType = matchingWidgets[0];

	                    this._addWidgetToContent(
	                        this.props.content,
	                        [word.pos.start, word.pos.end + 1],
	                        widgetType
	                    );
	                }

	                e.preventDefault();
	            }
	        }
	    },

	    _addWidgetToContent: function(oldContent, cursorRange, widgetType) {
	        var textarea = this.refs.textarea.getDOMNode();

	        // Note: we have to use _.map here instead of Array::map
	        // because the results of a .match might be null if no
	        // widgets were found.
	        var allWidgetIds = _.map(oldContent.match(rWidgetSplit), function(syntax)  {
	            var match = Util.rWidgetParts.exec(syntax);
	            var type = match[2];
	            var num = +match[3];
	            return [type, num];
	        });

	        var widgetNum = _.reduce(allWidgetIds, function(currentNum, otherId)  {
	            var $__0=   otherId,otherType=$__0[0],otherNum=$__0[1];
	            if (otherType === widgetType) {
	                return Math.max(otherNum + 1, currentNum);
	            } else {
	                return currentNum;
	            }
	        }, 1);

	        var id = widgetType + " " + widgetNum;
	        var widgetContent = widgetPlaceholder.replace("{id}", id);

	        // Add newlines before block-display widgets like graphs
	        var isBlock = Widgets.getDefaultAlignment(widgetType, 
	            this.props.enabledFeatures || EnabledFeatures.defaults) ===
	            "block";
	        
	        var prelude = oldContent.slice(0, cursorRange[0]);
	        var postlude = oldContent.slice(cursorRange[1]);

	        var newPrelude = isBlock ?
	            makeEndWithAParagraphIfNecessary(prelude) :
	            prelude;
	        var newPostlude = isBlock ?
	            makeStartWithAParagraphAlways(postlude) :
	            postlude;

	        var newContent = newPrelude + widgetContent + newPostlude;

	        var newWidgets = _.clone(this.props.widgets);
	        newWidgets[id] = {
	            options: {},
	            type: widgetType,
	            // Track widget version on creation, so that a widget editor
	            // without a valid version prop can only possibly refer to a
	            // pre-versioning creation time.
	            version: Widgets.getVersion(widgetType),
	        };

	        this.props.onChange({
	            content: newContent,
	            widgets: newWidgets,
	        }, function() {
	            Util.textarea.moveCursor(
	                textarea,
	                // We want to put the cursor after the widget
	                // and after any added newlines
	                newContent.length - postlude.length
	            );
	        });
	    },

	    _addWidget: function(widgetType) {
	        var textarea = this.refs.textarea.getDOMNode();
	        this._addWidgetToContent(
	            this.props.content,
	            [textarea.selectionStart, textarea.selectionEnd],
	            widgetType
	        );
	        textarea.focus();
	    },

	    addTemplate: function(e) {
	        var templateType = e.target.value;
	        if (templateType === "") {
	            return;
	        }
	        e.target.value = "";

	        var oldContent = this.props.content;

	        // Force templates to have a blank line before them,
	        // as they are usually used as block elements
	        // (especially important for tables)
	        oldContent = oldContent.replace(/\n*$/, "\n\n");

	        var template;
	        if (templateType === "table") {
	            template = "header 1 | header 2 | header 3\n" +
	                       "- | - | -\n" +
	                       "data 1 | data 2 | data 3\n" +
	                       "data 4 | data 5 | data 6\n" +
	                       "data 7 | data 8 | data 9";
	        } else if (templateType === "titledTable") {
	            template = "|| **Table title** ||\n" +
	                       "header 1 | header 2 | header 3\n" +
	                       "- | - | -\n" +
	                       "data 1 | data 2 | data 3\n" +
	                       "data 4 | data 5 | data 6\n" +
	                       "data 7 | data 8 | data 9";
	        } else if (templateType === "alignment") {
	            template = "$\\begin{align} x+5 &= 30 \\\\\n" +
	                       "x+5-5 &= 30-5 \\\\\n" +
	                       "x &= 25 \\end{align}$";
	        } else if (templateType === "piecewise") {
	            template = "$f(x) = \\begin{cases}\n" +
	                       "7 & \\text{if $x=1$} \\\\\n" +
	                       "f(x-1)+5 & \\text{if $x > 1$}\n" +
	                       "\\end{cases}$";
	        } else {
	            throw new Error("Invalid template type: " + templateType);
	        }

	        var newContent = oldContent + template;

	        this.props.onChange({content: newContent}, this.focusAndMoveToEnd);
	    },

	    getSaveWarnings: function() {
	        var parsed = PerseusMarkdown.parse(this.props.content);

	        var noAltImages = [];
	        PerseusMarkdown.traverseContent(parsed, function(node)  {
	            if (node.type === "image" && !node.alt) {
	                var shortUrl = node.target.length < 9 ? node.target :
	                        node.target.slice(0, 3) + "..." +
	                        node.target.slice(-3);

	                noAltImages.push(
	                    "Image '" + node.target +
	                    "' doesn't have alt text: ![add alt text here](" +
	                    shortUrl + ")");
	            }
	        });

	        var widgetIds = _.intersection(this.widgetIds, _.keys(this.refs));
	        var widgetWarnings = _(widgetIds)
	            .chain()
	            .map(function(id)  {
	                var issuesFunc = this.refs[id].getSaveWarnings;
	                var issues = issuesFunc ? issuesFunc() : [];
	                return _.map(issues, function(issue)  {return id + ": " + issue;});
	            }.bind(this))
	            .flatten(true)
	            .value();

	        return noAltImages.concat(widgetWarnings);
	    },

	    serialize: function(options) {
	        // need to serialize the widgets since the state might not be
	        // completely represented in props. ahem //transformer// (and
	        // interactive-graph and plotter).
	        var widgets = {};
	        var widgetIds = _.intersection(this.widgetIds, _.keys(this.refs));
	        _.each(widgetIds, function(id)  {
	            widgets[id] = this.refs[id].serialize();
	        }.bind(this));

	        // Preserve the data associated with deleted widgets in their last
	        // modified form. This is only intended to be useful in the context of
	        // immediate cut and paste operations if Editor.serialize() is called
	        // in between the two (which ideally should not be happening).
	        // TODO(alex): Remove this once all widget.serialize() methods
	        //             have been fixed to only return props,
	        //             and the above no longer applies.
	        if (options && options.keepDeletedWidgets) {
	            _.chain(this.props.widgets)
	                .keys()
	                .reject(function(id)  {return _.contains(widgetIds, id);})
	                .each(function(id)  { widgets[id] = this.props.widgets[id]; }.bind(this));
	        }

	        return {
	            content: this.props.content,
	            images: this.props.images,
	            widgets: widgets,
	        };
	    },

	    focus: function() {
	        this.refs.textarea.getDOMNode().focus();
	    },

	    focusAndMoveToEnd: function() {
	        this.focus();
	        var textarea = this.refs.textarea.getDOMNode();
	        textarea.selectionStart = textarea.value.length;
	        textarea.selectionEnd = textarea.value.length;
	    }
	});

	module.exports = Editor;


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var CombinedHintsEditor = __webpack_require__(59);
	var EnabledFeatures = __webpack_require__(56);
	var FixPassageRefs = __webpack_require__(70);
	var ItemEditor = __webpack_require__(60);
	var ItemRenderer = __webpack_require__(13);
	var JsonEditor = __webpack_require__(58);

	var EditorPage = React.createClass({displayName: 'EditorPage',
	    propTypes: {
	        // A function which takes a file object (guaranteed to be an image) and
	        // a callback, then calls the callback with the url where the image
	        // will be hosted. Image drag and drop is disabled when imageUploader
	        // is null.
	        imageUploader: React.PropTypes.func,
	        enabledFeatures: EnabledFeatures.propTypes,
	        // We don't specify a more specific type here because it's valid
	        // for a client of Perseus to specify a subset of the API options,
	        // in which case we default the rest in `this._apiOptions()`
	        apiOptions: React.PropTypes.object,
	    },

	    getDefaultProps: function() {
	        return {
	            developerMode: false,
	            jsonMode: false,
	            enabledFeatures: {
	                toolTipFormats: true,
	                useMathQuill: true
	            },
	            apiOptions: {} // deep defaults on updateRenderer
	        };
	    },

	    getInitialState: function() {
	        return {
	            json: {
	                question: this.props.question,
	                answer: this.props.answerArea,
	                hints: this.props.hints
	            },
	            gradeMessage: "",
	            wasAnswered: false
	        };
	    },

	    render: function() {

	        return React.createElement("div", {id: "perseus", className: "framework-perseus"}, 
	            this.props.developerMode &&
	                React.createElement("div", null, 
	                    React.createElement("label", null, 
	                        ' ', "Developer JSON Mode:", ' ', 
	                        React.createElement("input", {type: "checkbox", 
	                            checked: this.props.jsonMode, 
	                            onChange: this.toggleJsonMode})
	                    ), 
	                    " ", 
	                    React.createElement("button", {type: "button", onClick: this._fixPassageRefs}, 
	                        "Fix passage-refs"
	                    )
	                ), 
	            

	            this.props.developerMode && this.props.jsonMode &&
	                React.createElement("div", null, 
	                    React.createElement(JsonEditor, {
	                        multiLine: true, 
	                        value: this.state.json, 
	                        onChange: this.changeJSON})
	                ), 
	            

	            (!this.props.developerMode || !this.props.jsonMode) &&
	                React.createElement(ItemEditor, {
	                    ref: "itemEditor", 
	                    rendererOnly: this.props.jsonMode, 
	                    question: this.props.question, 
	                    answerArea: this.props.answerArea, 
	                    imageUploader: this.props.imageUploader, 
	                    onChange: this.handleChange, 
	                    wasAnswered: this.state.wasAnswered, 
	                    gradeMessage: this.state.gradeMessage, 
	                    onCheckAnswer: this.handleCheckAnswer, 
	                    apiOptions: this._apiOptions()}), 
	            

	            (!this.props.developerMode || !this.props.jsonMode) &&
	                React.createElement(CombinedHintsEditor, {
	                    ref: "hintsEditor", 
	                    hints: this.props.hints, 
	                    imageUploader: this.props.imageUploader, 
	                    onChange: this.handleChange})
	            
	        );

	    },

	    handleCheckAnswer: function() {
	        var result = this.scorePreview();
	        this.setState({
	            gradeMessage: result.message,
	            wasAnswered: result.correct
	        });
	    },

	    toggleJsonMode: function() {
	        this.setState({
	            json: this.serialize({keepDeletedWidgets: true})
	        }, function() {
	            this.props.onChange({
	                jsonMode: !this.props.jsonMode
	            });
	        });
	    },

	    componentDidMount: function() {
	        this.rendererMountNode = document.createElement("div");
	        this.updateRenderer();
	    },

	    componentDidUpdate: function() {
	        this.updateRenderer();
	    },

	    updateRenderer: function(cb) {
	        // Some widgets (namely the image widget) like to call onChange before
	        // anything has actually been mounted, which causes problems here. We
	        // just ensure don't update until we've mounted
	        if (this.rendererMountNode == null || this.props.jsonMode) {
	            return;
	        }
	        var rendererConfig = _({
	            item: this.serialize(),
	            enabledFeatures: {
	                toolTipFormats: true
	            },
	            apiOptions: this._apiOptions(),
	            initialHintsVisible: 0  /* none; to be displayed below */
	        }).extend(
	            _(this.props).pick("workAreaSelector",
	                               "solutionAreaSelector",
	                               "hintsAreaSelector",
	                               "problemNum",
	                               "enabledFeatures")
	        );

	        this.renderer = React.render(
	            React.createElement(ItemRenderer, React.__spread({},  rendererConfig)),
	            this.rendererMountNode,
	            cb);
	    },

	    _apiOptions: function() {
	        return _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions
	        );
	    },

	    handleChange: function(toChange, cb, silent) {
	        var newProps = _(this.props).pick("question", "hints", "answerArea");
	        _(newProps).extend(toChange);
	        this.props.onChange(newProps, cb, silent);
	    },

	    changeJSON: function(newJson) {
	        this.setState({
	            json: newJson,
	        });
	        this.props.onChange(newJson);
	    },

	    _fixPassageRefs: function() {
	        var itemData = this.serialize();
	        var newItemData = FixPassageRefs(itemData);
	        this.setState({
	            json: newItemData,
	        });
	        this.props.onChange(newItemData);
	    },

	    scorePreview: function() {
	        if (this.renderer) {
	            return this.renderer.scoreInput();
	        } else {
	            return null;
	        }
	    },

	    getSaveWarnings: function() {
	        var issues1 = this.refs.itemEditor.getSaveWarnings();
	        var issues2 = this.refs.hintsEditor.getSaveWarnings();
	        return issues1.concat(issues2);
	    },

	    serialize: function(options) {
	        if (this.props.jsonMode) {
	            return this.state.json;
	        } else {
	            return _.extend(this.refs.itemEditor.serialize(options), {
	                hints: this.refs.hintsEditor.serialize(options)
	            });
	        }
	    }

	});

	module.exports = EditorPage;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var AnswerAreaRenderer = __webpack_require__(8);
	var ApiOptions = __webpack_require__(17).Options;
	var EnabledFeatures = __webpack_require__(56);
	var HintsRenderer = __webpack_require__(14);
	var Renderer = __webpack_require__(15);
	var Util = __webpack_require__(5);

	var $__0=  __webpack_require__(71),mapObject=$__0.mapObject;

	var ItemRenderer = React.createClass({displayName: 'ItemRenderer',
	    getDefaultProps: function() {
	        return {
	            initialHintsVisible: 0,

	            // TODO(joel) - handle this differently. Pass around nodes or
	            // something half reasonable.
	            workAreaSelector: "#workarea",
	            solutionAreaSelector: "#solutionarea",
	            hintsAreaSelector: "#hintsarea",

	            enabledFeatures: {},  // a deep default is done in `this.update()`
	            apiOptions: {}  // likewise ^
	        };
	    },

	    getInitialState: function() {
	        return {
	            hintsVisible: this.props.initialHintsVisible,
	            questionCompleted: false,
	            questionHighlightedWidgets: [],
	            answerHighlightedWidgets: []
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.setState({
	            questionHighlightedWidgets: [],
	            answerHighlightedWidgets: []
	        });
	    },

	    componentDidMount: function() {
	        if (Khan.scratchpad) {
	            Khan.scratchpad.enable();
	        }
	        this._currentFocus = null;
	        this.update();
	    },

	    componentDidUpdate: function() {
	        this.update();
	    },

	    update: function() {
	        var enabledFeatures = _.extend(
	            {},
	            EnabledFeatures.defaults,
	            this.props.enabledFeatures
	        );

	        var apiOptions = _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions,
	            {
	                onFocusChange: this._handleFocusChange
	            }
	        );

	        // Since the item renderer works by rendering things into three divs
	        // that have completely different places in the DOM, we have to do this
	        // strangeness instead of relying on React's normal render() method.
	        // TODO(alpert): Figure out how to clean this up somehow
	        this.questionRenderer = React.render(
	                React.createElement(Renderer, React.__spread({
	                    problemNum: this.props.problemNum, 
	                    onInteractWithWidget: this.handleInteractWithWidget, 
	                    highlightedWidgets: this.state.questionHighlightedWidgets, 
	                    enabledFeatures: enabledFeatures, 
	                    apiOptions: apiOptions, 
	                    questionCompleted: this.state.questionCompleted, 
	                    savedState: this.props.savedState}, 
	                    this.props.item.question)
	                ),
	                document.querySelector(this.props.workAreaSelector));

	        this.answerAreaRenderer = React.render(
	                React.createElement(AnswerAreaRenderer, {
	                    type: this.props.item.answerArea.type, 
	                    options: this.props.item.answerArea.options, 
	                    calculator: this.props.item.answerArea.calculator || false, 
	                    periodicTable: this.props.item.answerArea.periodicTable ||
	                        false, 
	                    problemNum: this.props.problemNum, 
	                    onInteractWithWidget: this.handleInteractWithAnswerWidget, 
	                    highlightedWidgets: this.state.answerHighlightedWidgets, 
	                    enabledFeatures: enabledFeatures, 
	                    apiOptions: apiOptions}
	                ),
	                document.querySelector(this.props.solutionAreaSelector));

	        this.hintsRenderer = React.render(
	                React.createElement(HintsRenderer, {
	                    hints: this.props.item.hints, 
	                    hintsVisible: this.state.hintsVisible, 
	                    enabledFeatures: enabledFeatures, 
	                    apiOptions: apiOptions}
	                ),
	                document.querySelector(this.props.hintsAreaSelector));
	    },

	    _handleFocusChange: function(newFocus, oldFocus) {
	        if (newFocus != null) {
	            this._setCurrentFocus(newFocus);
	        } else {
	            this._onRendererBlur(oldFocus);
	        }
	    },

	    // Sets the current focus path and element and
	    // send an onChangeFocus event back to our parent.
	    _setCurrentFocus: function(newFocus) {
	        // By the time this happens, newFocus cannot be a prefix of
	        // prevFocused, since we must have either been called from
	        // an onFocusChange within a renderer, which is only called when
	        // this is not a prefix, or between the question and answer areas,
	        // which can never prefix each other.
	        var prevFocus = this._currentFocus;
	        this._currentFocus = newFocus;
	        if (this.props.apiOptions.onFocusChange != null) {
	            this.props.apiOptions.onFocusChange(this._currentFocus, prevFocus);
	        }
	    },

	    _onRendererBlur: function(blurPath) {
	        var blurringFocusPath = this._currentFocus;

	        // Failsafe: abort if ID is different, because focus probably happened
	        // before blur
	        if (!_.isEqual(blurPath, blurringFocusPath)) {
	            return;
	        }

	        // Wait until after any new focus events fire this tick before
	        // declaring that nothing is focused.
	        // If a different widget was focused, we'll see an onBlur event
	        // now, but then an onFocus event on a different element before
	        // this callback is executed
	        _.defer(function()  {
	            if (_.isEqual(this._currentFocus, blurringFocusPath)) {
	                this._setCurrentFocus(null);
	            }
	        }.bind(this));
	    },

	    /**
	     * Accepts a question area widgetId, or an answer area widgetId of
	     * the form "answer-input-number 1", or the string "answer-area"
	     * for the whole answer area (if the answer area is a single widget).
	     */
	    _setWidgetProps: function(widgetId, newProps, callback) {
	        var maybeAnswerAreaWidget = widgetId.match(/^answer-(.*)$/);

	        if (maybeAnswerAreaWidget) {
	            var answerAreaWidgetId = maybeAnswerAreaWidget[1];
	            this.answerAreaRenderer._setWidgetProps(
	                answerAreaWidgetId,
	                newProps,
	                callback
	            );
	        } else {
	            this.questionRenderer._setWidgetProps(
	                widgetId,
	                newProps,
	                callback
	            );
	        }
	    },

	    _handleAPICall: function(functionName, path) {
	        // Get arguments to pass to function, including `path`
	        var functionArgs = _.rest(arguments);

	        // Decide on which caller should handle the API call
	        var caller;
	        var isAnswerArea = path[0].match(/^answer-(.*)$/);
	        if (isAnswerArea) {
	            caller = this.answerAreaRenderer;
	        } else {
	            caller = this.questionRenderer;
	        }

	        return caller[functionName].apply(caller, functionArgs);
	    },

	    setInputValue: function(path, newValue, focus) {
	        return this._handleAPICall('setInputValue', path, newValue, focus);
	    },

	    focusPath: function(path) {
	        // TODO(charlie): Find a better way to handle blurring between answer-
	        // and question-area.
	        if (path && path.length > 0) {
	            var focusAnswer = path[0].match(/^answer-(.*)$/);
	            if (focusAnswer) {
	                this.questionRenderer.blur();
	            } else {
	                this.answerAreaRenderer.blur();
	            }
	        }

	        return this._handleAPICall('focusPath', path);
	    },

	    blurPath: function(path) {
	        return this._handleAPICall('blurPath', path);
	    },

	    getDOMNodeForPath: function(path) {
	        return this._handleAPICall('getDOMNodeForPath', path);
	    },

	    getGrammarTypeForPath: function(path) {
	        return this._handleAPICall('getGrammarTypeForPath', path);
	    },

	    getInputPaths: function() {
	        var questionAreaInputPaths = this.questionRenderer.getInputPaths();
	        var answerAreaInputPaths = this.answerAreaRenderer.getInputPaths();
	        return questionAreaInputPaths.concat(answerAreaInputPaths);
	    },

	    handleInteractWithWidget: function(widgetId) {
	        var withRemoved = _.difference(this.state.questionHighlightedWidgets,
	                                       [widgetId]);
	        this.setState({
	            questionCompleted: false,
	            questionHighlightedWidgets: withRemoved
	        });
	    },

	    handleInteractWithAnswerWidget: function(widgetId) {
	        var withRemoved = _.difference(this.state.answerHighlightedWidgets,
	                                       [widgetId]);
	        this.setState({
	            answerHighlightedWidgets: withRemoved
	        });
	    },

	    render: function() {
	        return React.createElement("div", null);
	    },

	    focus: function() {
	        return this.questionRenderer.focus() ||
	                this.answerAreaRenderer.focus();
	    },

	    componentWillUnmount: function() {
	        React.unmountComponentAtNode(
	                document.querySelector(this.props.workAreaSelector));
	        React.unmountComponentAtNode(
	                document.querySelector(this.props.solutionAreaSelector));
	        React.unmountComponentAtNode(
	                document.querySelector(this.props.hintsAreaSelector));
	    },

	    showHint: function() {
	        if (this.state.hintsVisible < this.getNumHints()) {
	            this.setState({
	                hintsVisible: this.state.hintsVisible + 1
	            });
	        }
	    },

	    getNumHints: function() {
	        return this.props.item.hints.length;
	    },

	    /**
	     * Grades the item.
	     *
	     * Returns a KE-style score of {
	     *     empty: bool,
	     *     correct: bool,
	     *     message: string|null,
	     *     guess: Array
	     * }
	     */
	    scoreInput: function() {
	        var qGuessAndScore = this.questionRenderer.guessAndScore();
	        var aGuessAndScore = this.answerAreaRenderer.guessAndScore();

	        var qGuess = qGuessAndScore[0], qScore = qGuessAndScore[1];
	        var aGuess = aGuessAndScore[0], aScore = aGuessAndScore[1];

	        var emptyQuestionAreaWidgets = this.questionRenderer.emptyWidgets();
	        var emptyAnswerAreaWidgets = this.answerAreaRenderer.emptyWidgets();
	        this.setState({
	            questionHighlightedWidgets: emptyQuestionAreaWidgets,
	            answerHighlightedWidgets: emptyAnswerAreaWidgets
	        });

	        var guess, score;
	        if (qGuess.length === 0) {
	            // No widgets in question. For compatability with old guess format,
	            // leave it out here completely.
	            guess = aGuess;
	            score = aScore;
	        } else {
	            guess = [qGuess, aGuess];
	            score = Util.combineScores(qScore, aScore);
	        }

	        var keScore = Util.keScoreFromPerseusScore(score, guess);
	        this.setState({
	            questionCompleted: keScore.correct
	        });

	        return keScore;
	    },

	    /**
	     * Returns an array of all widget IDs in the order they occur in
	     * the question content.
	     *
	     * NOTE: This ignores the answer area.
	     */
	    getWidgetIds: function() {
	        return this.questionRenderer.getWidgetIds();
	    },

	    /**
	     * Returns an object mapping from widget ID to KE-style score.
	     * The keys of this object are the values of the array returned
	     * from `getWidgetIds`.
	     *
	     * NOTE: This ignores the answer area.
	     */
	    scoreWidgets: function() {
	        var qScore = this.questionRenderer.scoreWidgets();
	        var qGuess = this.questionRenderer.getUserInputForWidgets();
	        return mapObject(qScore, function(score, id)  {
	            return Util.keScoreFromPerseusScore(score, qGuess[id]);
	        });
	    },

	    /**
	     * Get a representation of the current state of the item.
	     *
	     * Note: this ignores the answer area.
	     */
	    getSerializedState: function() {
	        return {
	            question: this.questionRenderer.getSerializedState(),
	            hints: this.hintsRenderer.getSerializedState(),
	        };
	    },

	    restoreSerializedState: function(state, callback) {
	        // We need to wait for both the question renderer and the hints
	        // renderer to finish restoring their states.
	        var numCallbacks = 2;
	        var fireCallback = function()  {
	            --numCallbacks;
	            if (callback && numCallbacks === 0) {
	                callback();
	            }
	        };

	        this.questionRenderer.restoreSerializedState(
	            state.question, fireCallback);
	        this.hintsRenderer.restoreSerializedState(state.hints, fireCallback);
	    },
	});

	module.exports = ItemRenderer;


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var HintRenderer = __webpack_require__(61);
	var SvgImage = __webpack_require__(64);

	var HintsRenderer = React.createClass({displayName: 'HintsRenderer',
	    render: function() {
	        var hintsVisible = this._hintsVisible();
	        var hints = this.props.hints
	            .slice(0, hintsVisible)
	            .map(function(hint, i) {
	                var shouldBold = i === this.props.hints.length - 1 &&
	                                 !(/\*\*/).test(hint.content);
	                return React.createElement(HintRenderer, {
	                            bold: shouldBold, 
	                            hint: hint, 
	                            pos: i, 
	                            ref: "hintRenderer" + i, 
	                            key: "hintRenderer" + i, 
	                            enabledFeatures: this.props.enabledFeatures, 
	                            apiOptions: this.props.apiOptions});
	            }, this);

	        return React.createElement("div", {className: this.props.className}, hints);
	    },

	    _hintsVisible: function() {
	        if (this.props.hintsVisible == null ||
	                this.props.hintsVisible === -1) {
	            return this.props.hints.length;
	        } else {
	            return this.props.hintsVisible;
	        }
	    },

	    componentDidMount: function() {
	        this._cacheHintImages();
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        if (!_.isEqual(prevProps.hints, this.props.hints) ||
	            prevProps.hintsVisible !== this.props.hintsVisible) {
	            this._cacheHintImages();
	        }

	        // When a new hint is displayed we immediately focus it
	        if (prevProps.hintsVisible < this.props.hintsVisible) {
	            var pos = this.props.hintsVisible - 1;
	            React.findDOMNode(this.refs["hintRenderer" + pos]).focus();
	        }
	    },

	    _cacheImagesInHint: function(hint) {
	        _.each(hint.images, function(data, src)  {
	            var image = new Image();
	            image.src = SvgImage.getRealImageUrl(src);
	        });
	    },

	    _cacheHintImages: function() {
	        // Only cache images in the first hint at the start. When hints are
	        // taken, cache images in the rest of the hints
	        if (this._hintsVisible() > 0) {
	            _.each(this.props.hints, this._cacheImagesInHint);
	        } else if (this.props.hints.length > 0) {
	            this._cacheImagesInHint(this.props.hints[0]);
	        }
	    },

	    getSerializedState: function() {
	        return _.times(this._hintsVisible(), function(i)  {
	            return this.refs["hintRenderer" + i].getSerializedState();
	        }.bind(this));
	    },

	    restoreSerializedState: function(state, callback) {
	        // We need to wait until all the renderers are finished restoring their
	        // state before we fire our callback.
	        var numCallbacks = 1;
	        var fireCallback = function()  {
	            --numCallbacks;
	            if (callback && numCallbacks === 0) {
	                callback();
	            }
	        };

	        _.each(state, function(hintState, i)  {
	            var hintRenderer = this.refs["hintRenderer" + i];
	            // This is not ideal in that it doesn't restore state
	            // if the hint isn't visible, but we can't exactly restore
	            // the state to an unmounted renderer, so...
	            // If you want to restore state to hints, make sure to
	            // have the appropriate number of hints visible already.
	            if (hintRenderer) {
	                ++numCallbacks;
	                hintRenderer.restoreSerializedState(hintState, fireCallback);
	            }
	        }.bind(this));

	        // This makes sure that the callback is fired if there aren't any
	        // mounted renderers.
	        fireCallback();
	    },
	});

	module.exports = HintsRenderer;


/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var PerseusMarkdown = __webpack_require__(57);
	var QuestionParagraph = __webpack_require__(54);
	var SvgImage = __webpack_require__(64);
	var TeX = __webpack_require__(73);
	var WidgetContainer = __webpack_require__(55);
	var Widgets = __webpack_require__(19);

	var Util = __webpack_require__(5);
	var EnabledFeatures = __webpack_require__(56);
	var ApiOptions = __webpack_require__(17).Options;
	var ApiClassNames = __webpack_require__(17).ClassNames;

	var $__0=   __webpack_require__(71),mapObject=$__0.mapObject,mapObjectFromArray=$__0.mapObjectFromArray;

	var specialChars = {
	    // escaped: original
	    "\\a": "\u0007", // \a isn't valid javascript
	    "\\b": "\b",
	    "\\t": "\t",
	    "\\n": "\n",
	    "\\v": "\v",
	    "\\f": "\f",
	    "\\r": "\r",
	    "\\\\": "\\"
	};

	var rEscapedChars = /\\a|\\b|\\t|\\n|\\v|\\f|\\r|\\\\/g;
	var rContainsNonWhitespace = /\S/;

	if (typeof KA !== "undefined" && KA.language === "en-pt") {
	    // When using crowdin's jipt (Just in place translation), we need to keep a
	    // registry of crowdinId's to component so that we can update the
	    // component's state as the translator enters their translation.
	    window.PerseusTranslationComponents = [];

	    if (!KA.jipt_dom_insert_checks) {
	        KA.jipt_dom_insert_checks = [];
	    }

	    // We add a function that will get called whenever jipt says the dom needs
	    // to be updated
	    KA.jipt_dom_insert_checks.push(function(text, node, attribute) {
	        var index = $(node).data("perseus-component-index");
	        // We only update if we had added an index onto the node's data.
	        if (node && typeof index !== "undefined") {
	            var component = window.PerseusTranslationComponents[index];

	            if (!component) {
	                // The component has disappeared, so we tell jipt not to try
	                // and insert anything
	                return false;
	            }
	            // Jipt sends down the escaped translation, so we need to
	            // unescape \\t to \t among other characters here
	            text = text.replace(
	                rEscapedChars,
	                function(ch) {
	                    return specialChars[ch];
	                });

	            component.setState({
	                jiptContent: text
	            });

	            // Return false to tell jipt not to insert anything into the DOM
	            // itself, otherwise it will mess up what React expects there to be
	            return false;
	        }
	        // The string updated wasn't part of perseus, so we tell jipt to just
	        // insert the translation as-is.
	        return text;
	    });
	}

	var SHOULD_CLEAR_WIDGETS_PROP_LIST = [
	    "content",
	    "problemNum",
	    "widgets"
	];

	// Check if one focus path / id path is a prefix of another
	// The focus path null will never be a prefix of any non-null
	// path, since it represents no focus.
	// Otherwise, prefix is calculated by whether every array
	// element in the prefix is present in the same position in the
	// wholeArray path.
	var isIdPathPrefix = function(prefixArray, wholeArray) {
	    if (prefixArray === null || wholeArray === null) {
	        return prefixArray === wholeArray;
	    }
	    return _.every(prefixArray, function(elem, i)  {
	        return _.isEqual(elem, wholeArray[i]);
	    });
	};

	var Renderer = React.createClass({displayName: 'Renderer',
	    propTypes: {
	        highlightedWidgets: React.PropTypes.array,
	        enabledFeatures: EnabledFeatures.propTypes,
	        apiOptions: React.PropTypes.object,
	        questionCompleted: React.PropTypes.bool,
	        onInteractWithWidget: React.PropTypes.func,
	        interWidgets: React.PropTypes.func,
	        alwaysUpdate: React.PropTypes.bool,
	        reviewMode: React.PropTypes.bool,
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (!_.isEqual(_.pick(this.props, SHOULD_CLEAR_WIDGETS_PROP_LIST),
	                       _.pick(nextProps, SHOULD_CLEAR_WIDGETS_PROP_LIST))) {
	            this.setState(this._getInitialWidgetState(nextProps));
	        }
	    },

	    getDefaultProps: function() {
	        return {
	            content: "",
	            widgets: {},
	            images: {},
	            // TODO(aria): Remove this now that it is true everywhere
	            // (here and in perseus-i18n)
	            ignoreMissingWidgets: true,
	            highlightedWidgets: [],
	            enabledFeatures: EnabledFeatures.defaults,
	            apiOptions: {},  // we'll do a deep defaults in render()
	            // onRender may be called multiple times per render, for example
	            // if there are multiple images or TeX pieces within `content`.
	            // It is a good idea to debounce any functions passed here.
	            questionCompleted: false,
	            onRender: function() {},
	            onInteractWithWidget: function() {},
	            interWidgets: function()  {return null;},
	            alwaysUpdate: false,
	            reviewMode: false,
	        };
	    },

	    getInitialState: function() {
	        return _.extend(
	            {jiptContent: null},
	            this._getInitialWidgetState());
	    },

	    _getInitialWidgetState: function(props) {
	        props = props || this.props;
	        var allWidgetInfo = this._getAllWidgetsInfo(props);
	        return {
	            widgetInfo: allWidgetInfo,
	            widgetProps: this._getAllWidgetsStartProps(allWidgetInfo, props),
	        };
	    },

	    _getAllWidgetsInfo: function(props) {
	        props = props || this.props;
	        return mapObject(props.widgets, function(widgetInfo, widgetId)  {
	            if (!widgetInfo.type || !widgetInfo.alignment) {
	                var newValues = {};

	                if (!widgetInfo.type) {
	                    newValues.type = widgetId.split(" ")[0];
	                }
	                if (!widgetInfo.alignment) {
	                    newValues.alignment = "default";
	                }

	                widgetInfo = _.extend({}, widgetInfo, newValues);
	            }
	            return Widgets.upgradeWidgetInfoToLatestVersion(widgetInfo);
	        });
	    },

	    _getAllWidgetsStartProps: function(allWidgetInfo, props) {
	        return mapObject(allWidgetInfo, function(editorProps)  {
	            return Widgets.getRendererPropsForWidgetInfo(
	                editorProps,
	                props.problemNum
	            );
	        });
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        if (this.props.alwaysUpdate) {
	            // TOTAL hacks so that interWidgets doesn't break
	            // when one widget updates without the other.
	            // See passage-refs inside radios, which was why
	            // this was introduced.
	            // I'm sorry!
	            // TODO(aria): cry
	            return true;
	        }
	        var stateChanged = !_.isEqual(this.state, nextState);
	        var propsChanged = !_.isEqual(this.props, nextProps);
	        return propsChanged || stateChanged;
	    },

	    _getDefaultWidgetInfo: function(widgetId) {
	        var widgetIdParts = Util.rTypeFromWidgetId.exec(widgetId);
	        if (widgetIdParts == null) {
	            return {};
	        }
	        return {
	            type: widgetIdParts[1],
	            graded: true,
	            options: {}
	        };
	    },

	    _getWidgetInfo: function(widgetId) {
	        return this.state.widgetInfo[widgetId] ||
	            this._getDefaultWidgetInfo(widgetId);
	    },

	    renderWidget: function(impliedType, id, state) {
	        var widgetInfo = this.state.widgetInfo[id];
	        if (widgetInfo || this.props.ignoreMissingWidgets) {

	            var type = (widgetInfo && widgetInfo.type) || impliedType;
	            var shouldHighlight = _.contains(
	                this.props.highlightedWidgets,
	                id
	            );
	            
	            // By this point we should have no duplicates, which are
	            // filtered out in this.render(), so we shouldn't have to
	            // worry about using this widget key and ref:
	            return React.createElement(WidgetContainer, {
	                    ref: "container:" + id, 
	                    key: "container:" + id, 
	                    enabledFeatures: this.props.enabledFeatures, 
	                    type: type, 
	                    initialProps: this.getWidgetProps(id), 
	                    shouldHighlight: shouldHighlight});
	        } else {
	            return null;
	        }
	    },

	    getApiOptions: function(props) {
	        return _.extend(
	            {},
	            ApiOptions.defaults,
	            props.apiOptions
	        );
	    },

	    getWidgetProps: function(id) {
	        var widgetProps = this.state.widgetProps[id] || {};

	        // The widget needs access to its "rubric" at all times when in review
	        // mode (which is really just part of its widget info).
	        var reviewModeRubric = null;
	        if (this.props.reviewMode && this.state.widgetInfo[id]) {
	            reviewModeRubric = this.state.widgetInfo[id].options;
	        }

	        return _.extend({}, widgetProps, {
	            ref: id,
	            widgetId: id,
	            alignment: this.state.widgetInfo[id] &&
	                       this.state.widgetInfo[id].alignment,
	            problemNum: this.props.problemNum,
	            enabledFeatures: this.props.enabledFeatures,
	            apiOptions: this.getApiOptions(this.props),
	            questionCompleted: this.props.questionCompleted,
	            onFocus: _.partial(this._onWidgetFocus, id),
	            onBlur: _.partial(this._onWidgetBlur, id),
	            interWidgets: this.interWidgets,
	            reviewModeRubric: reviewModeRubric,
	            onChange: function(newProps, cb)  {
	                this._setWidgetProps(id, newProps, cb);
	            }.bind(this)
	        });
	    },

	    /**
	    * Serializes the questions state so it can be recovered.
	    *
	    * The return value of this function can be sent to the
	    * `restoreSerializedState` method to restore this state.
	    */
	    getSerializedState: function() {
	        return mapObject(this.state.widgetProps, function(props, widgetId)  {
	            var widget = this.getWidgetInstance(widgetId);
	            if (widget && widget.getSerializedState) {
	                return widget.getSerializedState();
	            } else {
	                return props;
	            }
	        }.bind(this));
	    },

	    restoreSerializedState: function(serializedState, callback) {
	        // We want to wait until any children widgets who have a
	        // restoreSerializedState function also call their own callbacks before
	        // we declare that the operation is finished.
	        var numCallbacks = 1;
	        var fireCallback = function()  {
	            --numCallbacks;
	            if (callback && numCallbacks === 0) {
	                callback();
	            }
	        };

	        this.setState({
	            widgetProps: mapObject(serializedState, function(props, widgetId)  {
	                var widget = this.getWidgetInstance(widgetId);
	                if (widget && widget.restoreSerializedState) {
	                    // Note that we probably can't call
	                    // `this.change()/this.props.onChange()` in this
	                    // function, so we take the return value and use
	                    // that as props if necessary so that
	                    // `restoreSerializedState` in a widget can
	                    // change the props as well as state.
	                    // If a widget has no props to change, it can
	                    // safely return null.
	                    ++numCallbacks;
	                    var restoreResult =
	                        widget.restoreSerializedState(props, fireCallback);
	                    return _.extend(
	                        {},
	                        this.state.widgetProps[widgetId],
	                        restoreResult
	                    );
	                } else {
	                    return props;
	                }
	            }.bind(this))
	        }, fireCallback);
	    },

	    /**
	     * Allows inter-widget communication.
	     *
	     * Each widget can access this function using `this.props.interWidgets`
	     * Takes a `filterCriterion` on which widgets to return.
	     * `filterCriterion` can be one of:
	     *  * A string widget id
	     *  * A string widget type
	     *  * a function from (id, widgetInfo, widgetComponent) to true or false
	     *
	     * Returns an array of the matching widget components.
	     *
	     * If you need to do logic with more than the components, it is possible
	     * to do such logic inside the filter, rather than on the result array.
	     *
	     * See the passage-ref widget for an example.
	     *
	     * "Remember: abilities are not inherently good or evil, it's how you use
	     * them." ~ Kyle Katarn
	     * Please use this one with caution.
	     */
	    interWidgets: function(filterCriterion) {
	        var filterFunc;
	        // Convenience filters:
	        // "interactive-graph 3" will give you [[interactive-graph 3]]
	        // "interactive-graph" will give you all interactive-graphs
	        if (typeof filterCriterion === "string") {
	            if (filterCriterion.indexOf(' ') !== -1) {
	                var widgetId = filterCriterion;
	                filterFunc = function(id, widgetInfo)  {return id === widgetId;};
	            } else {
	                var widgetType = filterCriterion;
	                filterFunc = function(id, widgetInfo)  {
	                    return widgetInfo.type === widgetType;
	                };
	            }
	        } else {
	            filterFunc = filterCriterion;
	        }

	        var results = this.widgetIds.filter(function(id)  {
	            var widgetInfo = this._getWidgetInfo(id);
	            var widget = this.getWidgetInstance(id);
	            return filterFunc(id, widgetInfo, widget);
	        }.bind(this)).map(this.getWidgetInstance);

	        // We allow the parent of our renderer to intercept our
	        // interwidgets call.
	        var propsInterWidgetResult = this.props.interWidgets(
	            filterCriterion,
	            results // allow our parent to inspect the local
	                    // interwidget results before acting
	        );

	        if (propsInterWidgetResult) {
	            return propsInterWidgetResult;
	        } else {
	            return results;
	        }
	    },

	    getWidgetInstance: function(id) {
	        var ref = this.refs["container:" + id];
	        if (!ref) {
	            return null;
	        }
	        return ref.getWidget();
	    },

	    _onWidgetFocus: function(id, focusPath) {
	        if (focusPath === undefined) {
	            focusPath = [];
	        } else {
	            if (!_.isArray(focusPath)) {
	                throw new Error(
	                    "widget props.onFocus focusPath must be an Array, " +
	                    "but was" + JSON.stringify(focusPath)
	                );
	            }
	        }
	        this._setCurrentFocus([id].concat(focusPath));
	    },

	    _onWidgetBlur: function(id, blurPath) {
	        var blurringFocusPath = this._currentFocus;

	        // Failsafe: abort if ID is different, because focus probably happened
	        // before blur
	        var fullPath = [id].concat(blurPath);
	        if (!_.isEqual(fullPath, blurringFocusPath)) {
	            return;
	        }

	        // Wait until after any new focus events fire this tick before
	        // declaring that nothing is focused.
	        // If a different widget was focused, we'll see an onBlur event
	        // now, but then an onFocus event on a different element before
	        // this callback is executed
	        _.defer(function()  {
	            if (_.isEqual(this._currentFocus, blurringFocusPath)) {
	                this._setCurrentFocus(null);
	            }
	        }.bind(this));
	    },

	    componentWillUpdate: function(nextProps, nextState) {
	        var oldJipt = this.shouldRenderJiptPlaceholder(this.props, this.state);
	        var newJipt = this.shouldRenderJiptPlaceholder(nextProps, nextState);
	        var oldContent = this.getContent(this.props, this.state);
	        var newContent = this.getContent(nextProps, nextState);
	        var oldHighlightedWidgets = this.props.highlightedWidgets;
	        var newHighlightedWidgets = nextProps.highlightedWidgets;

	        this.reuseMarkdown = !oldJipt && !newJipt &&
	            oldContent === newContent &&
	            // yes, this is identity array comparison, but these are passed
	            // in from state in the item-renderer, so they should be
	            // identity equal unless something changed, and it's expensive
	            // to loop through them to look for differences.
	            // Technically, we could reuse the markdown when this changes, but
	            // to do that we'd have to do more expensive checking of whether
	            // a widget should be highlighted in the common case where
	            // this array hasn't changed, so we just redo the whole
	            // render if this changed
	            oldHighlightedWidgets === newHighlightedWidgets;
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        this.handleRender(prevProps);
	        // We even do this if we did reuse the markdown because
	        // we might need to update the widget props on this render,
	        // even though we have the same widgets.
	        // WidgetContainers don't update their widgets' props when
	        // they are re-rendered, so even if they've been
	        // re-rendered we need to call these methods on them.
	        _.each(this.widgetIds, function(id)  {
	            var container = this.refs["container:" + id];
	            container.replaceWidgetProps(
	                this.getWidgetProps(id)
	            );
	        }.bind(this));
	    },

	    getContent: function(props, state) {
	        return state.jiptContent || props.content;
	    },

	    shouldRenderJiptPlaceholder: function(props, state) {
	        return typeof KA !== "undefined" && KA.language === "en-pt" &&
	                    state.jiptContent == null &&
	                    props.content.indexOf('crwdns') !== -1;
	    },

	    render: function() {
	        if (this.reuseMarkdown) {
	            return this.lastRenderedMarkdown;
	        }

	        var content = this.getContent(this.props, this.state);
	        // `this.widgetIds` is appended to in `this.outputMarkdown`:
	        this.widgetIds = [];

	        if (this.shouldRenderJiptPlaceholder(this.props, this.state)) {
	            // Crowdin's JIPT (Just in place translation) uses a fake language
	            // with language tag "en-pt" where the value of the translations
	            // look like: {crwdns2657085:0}{crwdne2657085:0} where it keeps the
	            // {crowdinId:ngettext variant}. We detect whether the current
	            // content matches this, so we can take over rendering of
	            // the perseus content as the translators interact with jipt.
	            // We search for only part of the tag that crowdin uses to guard
	            // against them changing the format on us. The full tag it looks
	            // for can be found in https://cdn.crowdin.net/jipt/jipt.js
	            // globalPhrase var.

	            // If we haven't already added this component to the registry do so
	            // now. showHints() may cause this component to be rerendered
	            // before jipt has a chance to replace its contents, so this check
	            // will keep us from adding the component to the registry a second
	            // time.
	            if (!this.translationIndex) {
	                this.translationIndex =
	                    window.PerseusTranslationComponents.push(this) - 1;
	            }
	            // We now need to output this tag, as jipt looks for it to be
	            // able to replace it with a translation that it runs an ajax
	            // call to get.  We add a data attribute with the index to the
	            // Persues.TranslationComponent registry so that when jipt
	            // calls its before_dom_insert we can lookup this component by
	            // this attribute and render the text with markdown.
	            return React.createElement("div", {
	                    'data-perseus-component-index': this.translationIndex}, 
	                content
	            );
	        }

	        // Hacks:
	        // We use mutable state here to figure out whether the output
	        // had two columns.
	        // It is updated to true by `this.outputMarkdown` if a
	        // column break is found
	        // TODO(aria): Add a state variable to simple-markdown's output
	        // functions so that we can do this in a less hacky way.
	        this._isTwoColumn = false;

	        var parsedMardown = PerseusMarkdown.parse(content);
	        var markdownContents = this.outputMarkdown(parsedMardown);

	        var className = this._isTwoColumn ?
	            ApiClassNames.RENDERER + " " + ApiClassNames.TWO_COLUMN_RENDERER :
	            ApiClassNames.RENDERER;

	        this.lastRenderedMarkdown = React.createElement("div", {className: className}, 
	            markdownContents
	        );
	        return this.lastRenderedMarkdown;
	    },

	    // wrap top-level elements in a QuestionParagraph, mostly
	    // for appropriate spacing and other css
	    outputMarkdown: function(ast, state) {
	        var state = state || {};
	        if (_.isArray(ast)) {
	            // This is duplicated from simple-markdown
	            // TODO(aria): Don't duplicate this logic
	            var oldKey = state.key;
	            var result = [];

	            // map nestedOutput over the ast, except group any text
	            // nodes together into a single string output.
	            var lastWasString = false;
	            for (var i = 0; i < ast.length; i++) {
	                state.key = i;
	                var nodeOut = this.outputMarkdown(ast[i], state);
	                var isString = (typeof nodeOut === "string");
	                if (isString && lastWasString) {
	                    result[result.length - 1] += nodeOut;
	                } else {
	                    result.push(nodeOut);
	                }
	                lastWasString = isString;
	            }

	            state.key = oldKey;
	            return result;
	        } else {
	            // !!! WARNING: Mutative hacks! mutates `this._foundTextNodes`:
	            // because I wrote a bad interface to simple-markdown.js' `output`
	            this._foundTextNodes = false;
	            var output = this.outputNested(ast, state);
	            var className = this._foundTextNodes ?
	                "" :
	                "perseus-paragraph-centered";

	            return React.createElement(QuestionParagraph, {key: state.key, className: className}, 
	                output
	            );
	        }
	    },

	    // output non-top-level nodes or arrays
	    outputNested: function(ast, state) {
	        if (_.isArray(ast)) {
	            // This is duplicated from simple-markdown
	            // TODO(aria): Don't duplicate this logic
	            var oldKey = state.key;
	            var result = [];

	            // map nestedOutput over the ast, except group any text
	            // nodes together into a single string output.
	            var lastWasString = false;
	            for (var i = 0; i < ast.length; i++) {
	                state.key = i;
	                var nodeOut = this.outputNested(ast[i], state);
	                var isString = (typeof nodeOut === "string");
	                if (isString && lastWasString) {
	                    result[result.length - 1] += nodeOut;
	                } else {
	                    result.push(nodeOut);
	                }
	                lastWasString = isString;
	            }

	            state.key = oldKey;
	            return result;
	        } else {
	            return this.outputNode(ast, this.outputNested, state);
	        }
	    },

	    // output individual AST nodes [not arrays]
	    outputNode: function(node, nestedOutput, state) {
	        if (node.type === "widget") {
	            // Widgets can contain text nodes, so we don't center them with
	            // markdown magic here.
	            // Instead, we center them with css magic in articles.less
	            // /cry(aria)
	            this._foundTextNodes = true;

	            if (_.contains(this.widgetIds, node.id)) {
	                // We don't want to render a duplicate widget key/ref,
	                // as this causes problems with react (for obvious
	                // reasons). Instead we just notify the
	                // hopefully-content-creator that they need to change the
	                // widget id.
	                return React.createElement("span", {key: state.key, className: "renderer-widget-error"}, 
	                    "Widget [[", '\u2603', " ", node.id, "]] already exists."
	                );

	            } else {
	                this.widgetIds.push(node.id);
	                return this.renderWidget(node.widgetType, node.id, state);
	            }

	        } else if (node.type === "math") {
	            // We render math here instead of in perseus-markdown.jsx
	            // because we need to pass it our onRender callback.
	            return React.createElement("span", {
	                        key: state.key, 
	                        style: {
	                            // If math is directly next to text, don't let it
	                            // wrap to the next line
	                            "whiteSpace": "nowrap"
	                        }}, 
	                /* We add extra empty spans around the math to make it not
	                    wrap (I don't know why this works, but it does) */
	                React.createElement("span", null), 
	                React.createElement(TeX, {onRender: this.props.onRender}, 
	                    node.content
	                ), 
	                React.createElement("span", null)
	            );

	        } else if (node.type === "image") {
	            // We need to add width and height to images from our
	            // props.images mapping.

	            // We do a _.has check here to avoid weird things like
	            // 'toString' or '__proto__' as a url.
	            var extraAttrs = (_.has(this.props.images, node.target)) ?
	                this.props.images[node.target] :
	                null;

	            return React.createElement(SvgImage, React.__spread({
	                key: state.key, 
	                src: PerseusMarkdown.sanitizeUrl(node.target), 
	                alt: node.alt, 
	                title: node.title}, 
	                extraAttrs));

	        } else if (node.type === "columns") {
	            // Note that we have two columns. This is so we can put
	            // a className on the outer renderer content for SAT.
	            // TODO(aria): See if there is a better way we can do
	            // things like this
	            this._isTwoColumn = true;
	            // but then render normally:
	            return PerseusMarkdown.ruleOutput(node, nestedOutput, state);

	        } else if (node.type === "text") {
	            if (rContainsNonWhitespace.test(node.content)) {
	                this._foundTextNodes = true;
	            }
	            return node.content;

	        } else {
	            // If it's a "normal" or "simple" markdown node, just
	            // output it using its output rule.
	            return PerseusMarkdown.ruleOutput(node, nestedOutput, state);
	        }
	    },

	    handleRender: function(prevProps) {
	        var onRender = this.props.onRender;
	        var oldOnRender = prevProps.onRender;
	        var $images = $(this.getDOMNode()).find("img");

	        // Fire callback on image load...
	        // TODO (jack): make this call happen exactly once through promises!
	        if (oldOnRender) {
	            $images.off("load", oldOnRender);
	        }
	        $images.on("load", onRender);

	        // ...as well as right now (non-image, non-TeX or image from cache)
	        onRender();
	    },

	    componentDidMount: function() {
	        this.handleRender({});
	        this._currentFocus = null;
	    },

	    componentWillUnmount: function() {
	        if (this.translationIndex != null) {
	            window.PerseusTranslationComponents[this.translationIndex] = null;
	        }
	    },

	    // Sets the current focus path
	    // If the new focus path is not a prefix of the old focus path,
	    // we send an onChangeFocus event back to our parent.
	    _setCurrentFocus: function(path) {
	        // We don't do this when the new path is a prefix because
	        // that prefix is already focused (we're just in a more specific
	        // area of it). This makes it safe to call _setCurrentFocus
	        // whenever a widget is interacted with--we won't wipe out
	        // our focus state if we are already focused on a subpart
	        // of that widget (i.e. a transformation NumberInput inside
	        // of a transformer widget).
	        if (!isIdPathPrefix(path, this._currentFocus)) {
	            var prevFocus = this._currentFocus;

	            if (prevFocus) {
	                this.blurPath(prevFocus);
	            }

	            this._currentFocus = path;
	            if (this.props.apiOptions.onFocusChange != null) {
	                this.props.apiOptions.onFocusChange(
	                    this._currentFocus,
	                    prevFocus
	                );
	            }
	        }
	    },

	    focus: function() {
	        var id;
	        var focusResult;
	        for (var i = 0; i < this.widgetIds.length; i++) {
	            var widgetId = this.widgetIds[i];
	            var widget = this.getWidgetInstance(widgetId);
	            var widgetFocusResult = widget && widget.focus && widget.focus();
	            if (widgetFocusResult) {
	                id = widgetId;
	                focusResult = widgetFocusResult;
	                break;
	            }
	        }

	        if (id) {
	            // reconstruct a {path, element} focus object
	            var path;
	            if (_.isObject(focusResult)) {
	                // The result of focus was a {path, id} object itself
	                path = [id].concat(focusResult.path || []);
	            } else {
	                // The result of focus was true or the like; just
	                // construct a root focus object
	                path = [id];
	            }

	            this._setCurrentFocus(path);
	            return true;
	        }
	    },

	    getDOMNodeForPath: function(path) {
	        var widgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        // Widget handles parsing of the interWidgetPath. If the path is empty
	        // beyond the widgetID, as a special case we just return the widget's
	        // DOM node.
	        var widget = this.getWidgetInstance(widgetId);
	        var getNode = widget.getDOMNodeForPath;
	        if (getNode) {
	            return getNode(interWidgetPath);
	        } else if (interWidgetPath.length === 0) {
	            return widget.getDOMNode();
	        }
	    },

	    getGrammarTypeForPath: function(path) {
	        var widgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        var widget = this.getWidgetInstance(widgetId);
	        return widget.getGrammarTypeForPath(interWidgetPath);
	    },

	    getInputPaths: function() {
	        var inputPaths = [];
	        _.each(this.widgetIds, function(widgetId)  {
	            var widget = this.getWidgetInstance(widgetId);
	            if (widget.getInputPaths) {
	                // Grab all input paths and add widgetID to the front
	                var widgetInputPaths = widget.getInputPaths();
	                // Prefix paths with their widgetID and add to collective
	                // list of paths.
	                _.each(widgetInputPaths, function(inputPath)  {
	                    var relativeInputPath = [widgetId].concat(inputPath);
	                    inputPaths.push(relativeInputPath);
	                });
	            }
	        }.bind(this));

	        return inputPaths;
	    },

	    focusPath: function(path) {
	        // No need to focus if it's already focused
	        if (_.isEqual(this._currentFocus, path)) {
	            return;
	        } else if (this._currentFocus) {
	            // Unfocus old path, if exists
	            this.blurPath(this._currentFocus);
	        }

	        var widgetId = _.first(path);
	        var interWidgetPath = _.rest(path);

	        // Widget handles parsing of the interWidgetPath
	        var focusWidget = this.getWidgetInstance(widgetId).focusInputPath;
	        focusWidget && focusWidget(interWidgetPath);
	    },

	    blurPath: function(path) {
	        // No need to blur if it's not focused
	        if (!_.isEqual(this._currentFocus, path)) {
	            return;
	        }

	        var widgetId = _.first(path);
	        var interWidgetPath = _.rest(path);
	        var widget = this.getWidgetInstance(widgetId);
	        // We might be in the editor and blurring a widget that no
	        // longer exists, so only blur if we actually found the widget
	        if (widget) {
	            var blurWidget = this.getWidgetInstance(widgetId).blurInputPath;
	            // Widget handles parsing of the interWidgetPath
	            blurWidget && blurWidget(interWidgetPath);
	        }
	    },

	    blur: function() {
	        if (this._currentFocus) {
	            this.blurPath(this._currentFocus);
	        }
	    },

	    serialize: function() {
	        var state = {};
	        _.each(this.state.widgetInfo, function(info, id) {
	            var widget = this.getWidgetInstance(id);
	            var s = widget.serialize();
	            if (!_.isEmpty(s)) {
	                state[id] = s;
	            }
	        }, this);
	        return state;
	    },

	    emptyWidgets: function () {
	        return _.filter(this.widgetIds, function(id)  {
	            var widgetInfo = this._getWidgetInfo(id);
	            var score = this.getWidgetInstance(id).simpleValidate(
	                widgetInfo.options,
	                null
	            );
	            return Util.scoreIsEmpty(score);
	        }.bind(this));
	    },

	    _setWidgetProps: function(id, newProps, cb) {
	        var widgetProps = _.clone(this.state.widgetProps);
	        widgetProps[id] = _.extend({}, widgetProps[id], newProps);
	        this.setState({widgetProps: widgetProps}, function()  {
	            var cbResult = cb && cb();
	            this.props.onInteractWithWidget(id);
	            if (cbResult !== false) {
	                // TODO(jack): For some reason, some widgets don't always end
	                // up in refs here, which is repro-able if you make an
	                // [[ orderer 1 ]] and copy-paste this, then change it to be
	                // an [[ orderer 2 ]]. The resulting Renderer ends up with
	                // an "orderer 2" ref but not an "orderer 1" ref. @_@??
	                // TODO(jack): Figure out why this is happening and fix it
	                // As far as I can tell, this is only an issue in the
	                // editor-page, so doing this shouldn't break clients hopefully
	                this._setCurrentFocus([id]);
	            }
	        }.bind(this));
	    },

	    setInputValue: function(path, newValue, focus) {
	        var widgetId = _.first(path);
	        var interWidgetPath = _.rest(path);
	        var widget = this.getWidgetInstance(widgetId);

	        // Widget handles parsing of the interWidgetPath.
	        widget.setInputValue(interWidgetPath, newValue, focus);
	    },

	    /**
	     * Returns an array of the widget `.getUserInput()` results
	     */
	    getUserInput: function() {
	        return _.map(this.widgetIds, function(id)  {
	            return this.getWidgetInstance(id).getUserInput();
	        }.bind(this));
	    },

	    /**
	     * Returns an array of all widget IDs in the order they occur in
	     * the content.
	     */
	    getWidgetIds: function() {
	        return this.widgetIds;
	    },

	    /**
	     * WARNING: This is an experimental/temporary API and should not be relied
	     *     upon in production code. This function may change its behavior or
	     *     disappear without notice.
	     *
	     * Returns a treelike structure containing all widget IDs (this will
	     * descend into group widgets as well).
	     *
	     * An example of what the structure looks like:
	     *
	     * [
	     *    {id: "radio 1", children: []},
	     *    {
	     *        id: "group 1",
	     *        children: [
	     *            {id: "radio 1", children: []}
	     *            {id: "radio 2", children: []}
	     *        ]
	     *    }
	     * ]
	     *
	     * Widgets will be listed in the order that they appear in their renderer.
	     *
	     * Note: If a group hasn't been rendered yet, though, then its children
	     * ids will not be returned.
	     * TODO(marcia): We should figure out a way to either return the widget ids
	     * without needing to render all-the-things, or we should probably have a
	     * better pattern for requesting widget ids so we are more likely to get
	     * one true answer.
	     */
	    getAllWidgetIds: function() {
	        // Recursively builds our result
	        return _.map(this.getWidgetIds(), function(id)  {
	            var groupPrefix = "group";
	            if (id.substring(0, groupPrefix.length) === groupPrefix &&
	                    this.getWidgetInstance(id)) {
	                return {
	                    id: id,
	                    children:
	                        this.getWidgetInstance(id)
	                            .getRenderer()
	                            .getAllWidgetIds(),
	                };
	            }

	            // This is our base case
	            return {id: id, children: []};
	        }.bind(this));
	    },

	    /**
	     * Returns the result of `.getUserInput()` for each widget, in
	     * a map from widgetId to userInput.
	     */
	    getUserInputForWidgets: function() {
	        return mapObjectFromArray(this.widgetIds, function(id)  {
	            return this.getWidgetInstance(id).getUserInput();
	        }.bind(this));
	    },

	    /**
	     * Returns an object mapping from widget ID to perseus-style score.
	     * The keys of this object are the values of the array returned
	     * from `getWidgetIds`.
	     */
	    scoreWidgets: function() {
	        var widgetProps = this.state.widgetInfo;
	        var onInputError = this.props.apiOptions.onInputError ||
	                function() { };

	        var gradedWidgetIds = _.filter(this.widgetIds, function(id)  {
	            var props = widgetProps[id];
	            // props.graded is unset or true
	            return props.graded == null || props.graded;
	        });

	        var widgetScores = {};
	        _.each(gradedWidgetIds, function(id)  {
	            var props = widgetProps[id];
	            var widget = this.getWidgetInstance(id);
	            if (!widget) {
	                // This can occur if the widget has not yet been rendered
	                return;
	            }
	            widgetScores[id] = widget.simpleValidate(props.options,
	                                                      onInputError);
	        }.bind(this));

	        return widgetScores;
	    },

	    /**
	     * Grades the content.
	     *
	     * Returns a perseus-style score of {
	     *     type: "invalid"|"points",
	     *     message: string,
	     *     earned: undefined|number,
	     *     total: undefined|number
	     * }
	     */
	    score: function() {
	        return _.reduce(this.scoreWidgets(), Util.combineScores, Util.noScore);
	    },

	    guessAndScore: function() {
	        var totalGuess = this.getUserInput();
	        var totalScore = this.score();

	        return [totalGuess, totalScore];
	    },

	    examples: function() {
	        var widgets = this.widgetIds;
	        var examples = _.compact(_.map(widgets, function(widget) {
	            return widget.examples ? widget.examples() : null;
	        }));

	        // no widgets with examples
	        if (!examples.length) {
	            return null;
	        }

	        var allEqual = _.all(examples, function(example) {
	            return _.isEqual(examples[0], example);
	        });

	        // some widgets have different examples
	        // TODO(alex): handle this better
	        if (!allEqual) {
	            return null;
	        }

	        return examples[0];
	    },
	});

	module.exports = Renderer;


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var EditorPage = __webpack_require__(12);

	/* Renders an EditorPage (or an ArticleEditor) as a non-controlled component.
	 *
	 * Normally the parent of EditorPage must pass it an onChange callback and then
	 * respond to any changes by modifying the EditorPage props to reflect those
	 * changes. With StatefulEditorPage changes are stored in state so you can
	 * query them with serialize.
	 */
	var StatefulEditorPage = React.createClass({displayName: 'StatefulEditorPage',

	    propTypes: {
	        componentClass: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            componentClass: EditorPage
	        };
	    },

	    render: function() {
	        return React.createElement(this.props.componentClass, React.__spread({},  this.state));
	    },

	    getInitialState: function() {
	        return _({}).extend(_.omit(this.props, 'componentClass'), {
	            onChange: this.handleChange,
	            ref: "editor"
	        });
	    },

	    // getInitialState isn't called if the react component is re-rendered
	    // in-place on the dom, in which case this is called instead, so we
	    // need to update the state here.
	    // (This component is currently re-rendered by the "Add image" button.)
	    componentWillReceiveProps: function(nextProps) {
	        // be careful not to overwrite our onChange and ref
	        this.setState(_(nextProps).omit("onChange", "ref"));
	    },

	    getSaveWarnings: function() {
	        return this.refs.editor.getSaveWarnings();
	    },

	    serialize: function() {
	        return this.refs.editor.serialize();
	    },

	    handleChange: function(newState, cb) {
	        if (this.isMounted()) {
	            this.setState(newState, cb);
	        }
	    },

	    scorePreview: function() {
	        return this.refs.editor.scorePreview();
	    }
	});

	module.exports = StatefulEditorPage;


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * [Most of] the Perseus client API.
	 *
	 * If making a change to this file, or otherwise to the perseus
	 * API, you should increment:
	 *  * the perseus api major version if it is a breaking change
	 *  * the perseus api minor version if it is an additive-only change
	 *  * nothing if it is purely a bug fix.
	 *
	 * Callbacks passed to Renderer/ItemRenderer:
	 *  * onInputError:
	 *    Called when there is an error grading a widget
	 *  * onFocusChange: (newFocus, oldFocus)
	 *    Called when the user focus changes. Each parameter is an object
	 *    containing two fields, `path` and `element`.
	 *    `path` is an array uniquely identifying the input to perseus
	 *    `element` is a DOM element representing the area covered by
	 *    the input (but is not necessarily an `<input>` element).
	 *    When focus changes to or from nothing being selected, `path`
	 *    will be null.
	 *
	 * Stable CSS ClassNames:
	 * These are css class names that will continue to preserve their
	 * semantic meaning across the same perseus api major version.
	 */

	var StubTagEditor = __webpack_require__(66);

	module.exports = {
	    Options: {
	        propTypes: React.PropTypes.shape({
	            fancyDropdowns: React.PropTypes.bool.isRequired,
	            onInputError: React.PropTypes.func.isRequired,
	            onFocusChange: React.PropTypes.func.isRequired,
	            staticRender: React.PropTypes.bool.isRequired,
	            GroupMetadataEditor: React.PropTypes.func.isRequired,
	            showAlignmentOptions: React.PropTypes.bool.isRequired,
	            // Enable old answer types in test.html
	            // TODO(aria) Remove when Alex kills the answer area
	            enableOldAnswerTypes: React.PropTypes.bool.isRequired,
	            readOnly: React.PropTypes.bool.isRequired,

	            // A function that takes in the relative problem number (starts at
	            // 0 and is incremented for each group widget), and the ID of the
	            // group widget, then returns a react component that will be added
	            // immediately above the renderer in the group widget. If the
	            // function returns null, no annotation will be added.
	            groupAnnotator: React.PropTypes.func.isRequired,
	        }).isRequired,

	        defaults: {
	            fancyDropdowns: false,
	            onInputError: function() { },
	            onFocusChange: function() { },
	            staticRender: false,
	            GroupMetadataEditor: StubTagEditor,
	            showAlignmentOptions: false,
	            enableOldAnswerTypes: false,
	            readOnly: false,
	            groupAnnotator: function() { return null; },
	        }
	    },
	    ClassNames: {
	        RENDERER: "perseus-renderer",
	        TWO_COLUMN_RENDERER: "perseus-renderer-two-columns",
	        INPUT: "perseus-input",
	        FOCUSED: "perseus-focused",
	        RADIO: {
	            OPTION: "perseus-radio-option",
	            SELECTED: "perseus-radio-selected",
	            OPTION_CONTENT: "perseus-radio-option-content"
	        },
	        INTERACTIVE: "perseus-interactive",
	        CORRECT: "perseus-correct",
	        INCORRECT: "perseus-incorrect",
	        UNANSWERED: "perseus-unanswered",
	    }
	};



/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	// Responsible for combining the text diffs from text-diff and the widget
	// diffs from widget-differ.

	var TextDiff = __webpack_require__(62);
	var WidgetDiff = __webpack_require__(63);

	// Deeply look up a property in an object,
	// -> getPath(obj, ["a", "b", "c"]) === obj["a"]["b"]["c"]
	var getPath = function(obj, path, defaultValue) {
	    var returningDefault = false;
	    var result = _(path).reduce(function(obj, key) {
	        if (returningDefault || !obj.hasOwnProperty(key)) {
	            returningDefault = true;
	            return defaultValue;
	        }
	        return obj[key];
	    }, obj);
	    return result;
	};

	var widgetsIn = function(item) {
	    var question = item.question || {};
	    var widgets = question.widgets || {};

	    return _.keys(widgets);
	};

	var hintWidgetsIn = function(item, n) {
	    var hints = item.hints || [];
	    var hint = hints[n] || {};
	    var widgets = hint.widgets || {};
	    return _.keys(widgets);
	};



	var isWidget = function(obj)  {return _.isObject(obj) && !("content" in obj);};

	var RevisionDiff = React.createClass({displayName: 'RevisionDiff',
	    propTypes: {
	        beforeItem: React.PropTypes.object.isRequired,
	        afterItem: React.PropTypes.object.isRequired
	    },

	    render: function() {
	        var before = this.props.beforeItem;
	        var after = this.props.afterItem;
	        // Not going to handle inserting hints in the middle so well, but
	        // that's pretty complicated to handle nicely.
	        // This will do for now.
	        var hintCount = 0;
	        if (_(before).has("hints") && _(after).has("hints")) {
	            hintCount = Math.max(before.hints.length, after.hints.length);
	        }

	        var widgets = _.union(widgetsIn(before), widgetsIn(after));

	        var sections = [
	            {
	                title: "Question Area",
	                path: ["question"]
	            },
	            {
	                title: "Answer Area",
	                path: ["answerArea", "options"]
	            }
	        ].concat(
	            _.times(hintCount, function(n) {
	                return {
	                    title: "Hint #" + (n + 1),
	                    path: ["hints", n]
	                };
	            })
	        ).concat(
	            _.map(widgets, function(widget) {
	                return {
	                    title: widget,
	                    path: ["question", "widgets", widget, "options"]
	                };
	            })
	        ).concat( 
	            _.flatten(
	                _.times(hintCount, function(n) {

	                var hintWidgets = _.union(hintWidgetsIn(before, n), 
	                                          hintWidgetsIn(after, n));

	                return _.map(hintWidgets, function(widget) {
	                    return {
	                        title: "Hint #"+(n+1)+"."+widget,
	                        path: ["hints", n, "widgets", widget, "options"]
	                    };
	                });

	            })
	           
	        ));


	        var result = [];

	        _(sections).each(function(section, i) {
	            var path = section.path;
	            var beforeValue = getPath(before, path, "");
	            var afterValue = getPath(after, path, "");
	            var displayedDiff;
	            if (isWidget(beforeValue) || isWidget(afterValue)) {
	                if (!isWidget(beforeValue)) {
	                    beforeValue = {};
	                }
	                if (!isWidget(afterValue)) {
	                    afterValue = {};
	                }
	                displayedDiff = React.createElement(WidgetDiff, {
	                    key: section.title, 
	                    title: section.title, 
	                    before: beforeValue, 
	                    after: afterValue});
	            } else {
	                displayedDiff = React.createElement(TextDiff, {
	                    key: section.title, 
	                    title: section.title, 
	                    before: beforeValue.content, 
	                    after: afterValue.content});
	            }
	            result.push(React.createElement("div", {key: i}, 
	                React.createElement("div", {className: "diff-header"}, section.title), 
	                React.createElement("div", {className: "diff-header"}, section.title), 
	                React.createElement("div", {className: "diff-body ui-helper-clearfix"}, 
	                    displayedDiff
	                )
	            ));
	        });

	        return React.createElement("div", null, result);
	    }
	});

	module.exports = RevisionDiff;


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var DEFAULT_ALIGNMENT = "block";
	var DEFAULT_SUPPORTED_ALIGNMENTS = ["default"];

	var widgets = {};

	var Widgets = {
	    // Widgets must be registered to avoid circular dependencies with the
	    // core Editor and Renderer components.
	    register: function(name, data) {
	        widgets[name] = data;
	    },

	    getWidget: function(name, enabledFeatures) {
	        // TODO(alex): Consider referring to these as renderers to avoid
	        // overloading "widget"
	        if (!_.has(widgets, name)) {
	            return null;
	        }

	        // Allow widgets to specify a widget directly or via a function
	        if (widgets[name].getWidget) {
	            return widgets[name].getWidget(enabledFeatures);
	        } else {
	            return widgets[name].widget;
	        }
	    },

	    getEditor: function(name) {
	        return _.has(widgets, name) ? widgets[name].editor : null;
	    },

	    getTransform: function(name) {
	        return _.has(widgets, name) ?
	            widgets[name].transform || _.identity :
	            null;
	    },

	    getVersion: function(name) {
	        var widgetInfo = widgets[name];
	        if (widgetInfo) {
	            return widgets[name].version || {major: 0, minor: 0};
	        } else {
	            return null;
	        }
	    },

	    getVersionVector: function() {
	        var version = {};
	        _.each(_.keys(widgets), function(name) {
	            version[name] = Widgets.getVersion(name);
	        });
	        return version;
	    },

	    getPublicWidgets: function() {
	        // TODO(alex): Update underscore.js so that _.pick can take a function.
	        return _.pick(widgets, _.reject(_.keys(widgets), function(name) {
	            return widgets[name].hidden;
	        }));
	    },

	    isAccessible: function(widgetInfo) {
	        var accessible = widgets[widgetInfo.type].accessible;
	        if (typeof accessible === "function") {
	            return accessible(widgetInfo.options);
	        } else {
	            return !!accessible;
	        }
	    },

	    getAllWidgetTypes: function() {
	        return _.keys(widgets);
	    },

	    upgradeWidgetInfoToLatestVersion: function(oldWidgetInfo) {
	        var type = oldWidgetInfo.type;
	        if (!_.isString(type)) {
	            throw new Error("widget type must be a string, but was: " + type);
	        }
	        var widgetExports = widgets[type];

	        if (widgetExports == null) {
	            // If we have a widget that isn't registered, we can't upgrade it
	            // TODO(aria): Figure out what the best thing to do here would be
	            return oldWidgetInfo;
	        }

	        // Unversioned widgets (pre-July 2014) are all implicitly 0.0
	        var initialVersion = oldWidgetInfo.version || {major: 0, minor: 0};
	        var latestVersion = widgetExports.version || {major: 0, minor: 0};
	        // Actual version. Only updated if we did an upgrade. If we didn't,
	        // it might be because the actual version is already greater than
	        // the latest version (we might be looking at the props from
	        // a later version of perseus, sent in via isRenderable)
	        var actualVersion = initialVersion;

	        // We do a clone here so that it's safe to mutate the input parameter
	        // in propUpgrades functions (which I will probably accidentally do at
	        // some point, and we would like to not break when that happens).
	        var newEditorProps = _.clone(oldWidgetInfo.options) || {};

	        var upgradePropsMap = widgetExports.propUpgrades || {};

	        // Empty props usually mean a newly created widget by the editor,
	        // and are always considerered up-to-date.
	        // Mostly, we'd rather not run upgrade functions on props that are
	        // not complete.
	        if (_.keys(newEditorProps).length !== 0) {

	            // We loop through all the versions after the current version of
	            // the loaded widget, up to and including the latest version of the
	            // loaded widget, and run the upgrade function to bring our loaded
	            // widget's props up to that version.
	            // There is a little subtlety here in that we call
	            // upgradePropsMap[1] to upgrade *to* version 1,
	            // (not from version 1).
	            for (var nextVersion = initialVersion.major + 1;
	                    nextVersion <= latestVersion.major;
	                    nextVersion++) {

	                if (upgradePropsMap[nextVersion]) {
	                    newEditorProps = upgradePropsMap[nextVersion](
	                        newEditorProps
	                    );

	                } else if ((typeof console !== 'undefined') && console.warn) {
	                    // This is a warning because it is unlikely to be hit in
	                    // local testing, and a warning is slightly less scary in
	                    // prod than a `throw new Error`
	                    console.warn(
	                        "No upgrade found for widget `" + type + "` from " +
	                        "major version `" + (nextVersion - 1) + "` to " +
	                        "major version `" + nextVersion + "` found. This " +
	                        "is necessary to render this `" + type + "` correctly."
	                    );
	                    // But try to keep going anyways (yolo!)
	                    // (Throwing an error here would just break the page
	                    // silently anyways, so that doesn't seem much better
	                    // than a halfhearted attempt to continue, however
	                    // shallow...)
	                }

	                // we are updating this widget to the latest version (after
	                // all the iterations of this loop)
	                // We do this inside the loop so that if the widget is at a
	                // version later than what we understand, this loop will run
	                // zero times, and the actualVersion won't be changed from
	                // the initialVersion.
	                actualVersion = latestVersion;
	            }
	        }

	        var alignment = oldWidgetInfo.alignment;

	        // Widgets that support multiple alignments will "lock in" the
	        // alignment to the alignment that would be listed first in the
	        // select box. If the widget only supports one alignment, the
	        // alignment value will likely just end up as "default".
	        if (alignment == null || alignment === "default") {
	            alignment = Widgets.getSupportedAlignments(type)[0];
	        }

	        return _.extend({}, oldWidgetInfo, {  // maintain other info, like type
	            version: actualVersion,
	            // Default graded to true (so null/undefined becomes true):
	            graded: (
	                (oldWidgetInfo.graded != null) ? oldWidgetInfo.graded : true
	            ),
	            alignment: alignment,
	            options: newEditorProps
	        });
	    },

	    getRendererPropsForWidgetInfo: function(widgetInfo, problemNum) {
	        var type = widgetInfo.type;
	        var widgetExports = widgets[type];
	        if (widgetExports == null) {
	            // The widget is not a registered widget
	            // It shouldn't matter what we return here, but for consistency
	            // we return the untransformed options, as if the widget did
	            // not have a transform defined.
	            return widgetInfo.options;
	        }
	        var transform = widgetExports.transform || _.identity;
	        // widgetInfo.options are the widgetEditor's props:
	        return transform(widgetInfo.options, problemNum);
	    },

	    traverseChildWidgets: function(
	            widgetInfo,
	            traverseRenderer) {

	        if (!traverseRenderer) {
	            throw new Error("traverseRenderer must be provided, but was not");
	        }

	        if (!widgetInfo || !widgetInfo.type || !widgets[widgetInfo.type]) {
	            return widgetInfo;
	        }

	        var widgetExports = widgets[widgetInfo.type];
	        var props = widgetInfo.options;

	        if (widgetExports.traverseChildWidgets && props) {
	            var newProps = widgetExports.traverseChildWidgets(
	                props,
	                traverseRenderer
	            );
	            return _.extend({}, widgetInfo, {options: newProps});
	        } else {
	            return widgetInfo;
	        }
	    },

	    /**
	     * Handling for the optional alignments for widgets
	     * The following alignments are supported (see widget-container.jsx for 
	     * details on how alignments are implemented):
	     *
	     * * default: If this alignment is selected, the default alignment provided
	     *     by the widget's code will be used.
	     * * block
	     * * inline-block
	     * * inline
	     * * float-left
	     * * float-right
	     */

	    /**
	     * Returns the list of supported alignments for the given (string) widget
	     * type. This is used primarily at editing time to display the choices 
	     * for the user.
	     *
	     * Support alignments are given as an array of strings in the exports of
	     * a widget's module.
	     */
	    getSupportedAlignments: function(type) {
	        var widgetInfo = widgets[type];
	        return (widgetInfo && widgetInfo.supportedAlignments) || DEFAULT_SUPPORTED_ALIGNMENTS;
	    },

	    /**
	     * For the given (string) widget type and enabledFeatures, determine the
	     * default alignment for the widget. This is used at rendering time to
	     * go from "default" alignment to the actual alignment displayed on the
	     * screen.
	     *
	     * The default alignment is given either as a string (called
	     * `defaultAlignment`) or a function (called `getDefaultAlignment`) on
	     * the exports of a widget's module.
	     */
	    getDefaultAlignment: function(type, enabledFeatures) {
	        var widgetInfo = widgets[type];
	        if (!widgetInfo) {
	            return DEFAULT_ALIGNMENT;
	        }

	        if (widgetInfo.getDefaultAlignment) {
	            alignment = widgetInfo.getDefaultAlignment(enabledFeatures);
	        } else {
	            alignment = widgetInfo.defaultAlignment;
	        }
	        return alignment || DEFAULT_ALIGNMENT;
	    },

	    validAlignments: ["block", "inline-block", "inline", "float-left", "float-right"],

	    /**
	     * Used at startup to fail fast if an alignment given by a widget is
	     * invalid.
	     */
	    validateAlignments: function () {
	        _.each(widgets, function (widgetInfo) {
	            if (widgetInfo.defaultAlignment && 
	                !_.contains(Widgets.validAlignments,
	                            widgetInfo.defaultAlignment)) {
	                throw new Error("Widget '" + widgetInfo.displayName +
	                    "' has an invalid defaultAlignment value: " +
	                    widgetInfo.defaultAlignment);
	            }

	            if (widgetInfo.supportedAlignments) {
	                var unknownAlignments = _.difference(
	                     widgetInfo.supportedAlignments, 
	                     Widgets.validAlignments);

	                if (unknownAlignments.length) {
	                    throw new Error("Widget '" + widgetInfo.displayName +
	                        "' has an invalid value for supportedAlignments: " +
	                        unknownAlignments.join(" "));
	                }
	            }
	        });
	    }
	};

	module.exports = Widgets;


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Traverses a {content, widgets, images} renderer props object,
	 * such as `itemData.question`
	 *
	 * This traversal is deep and handles some widget prop upgrades
	 * (TODO(aria): Handle minor prop upgrades :) )
	 *
	 * This is the right way to traverse itemData.
	 *
	 * NOTE: We should not expose this on the perseus API yet. Instead,
	 * build the traversal method you want inside perseus, and use this
	 * from that. We might eventually expose this, but I'd like to be
	 * more confident in the interface provided first.
	 */

	var _ = __webpack_require__(67);
	// TODO(aria): Pull this out of interactive2 / replace with new _.mapObject
	var objective_ = __webpack_require__(71);

	var Widgets = __webpack_require__(19);

	var noop = function() { };

	var deepCallbackFor = function(
	        contentCallback,
	        widgetCallback,
	        optionsCallback) {
	    var deepCallback = function(widgetInfo, widgetId) {
	        // This doesn't modify the widget info if the widget info
	        // is at a later version than is supported, which is important
	        // for our latestVersion test below.
	        var upgradedWidgetInfo = Widgets.upgradeWidgetInfoToLatestVersion(
	            widgetInfo
	        );
	        var latestVersion = Widgets.getVersion(upgradedWidgetInfo.type);

	        // Only traverse our children if we can understand this version
	        // of the widget props.
	        // TODO(aria): This will break if the traversal code assumes that
	        // any props that usually get defaulted in are present. That is,
	        // it can fail on minor version upgrades.
	        // For this reason, and because the upgrade code doesn't handle
	        // minor versions correctly (it doesn't report anything useful
	        // about what minor version a widget is actually at, since it
	        // doesn't have meaning in the context of upgrades), we
	        // just check the major version here.
	        // TODO(aria): This is seriously quirky and would be unpleasant
	        // to think about while writing traverseChildWidgets code. Please
	        // make all of this a little tighter.
	        // I think once we use react class defaultProps instead of relying
	        // on getDefaultProps, this will become easier.
	        var newWidgetInfo;
	        if (latestVersion && (
	                upgradedWidgetInfo.version.major === latestVersion.major)) {
	            newWidgetInfo = Widgets.traverseChildWidgets(
	                upgradedWidgetInfo,
	                function(rendererOptions)  {
	                    return traverseRenderer(
	                        rendererOptions,
	                        contentCallback,
	                        // so that we traverse grandchildren, too:
	                        deepCallback,
	                        optionsCallback
	                    );
	                }
	            );
	        } else {
	            newWidgetInfo = upgradedWidgetInfo;
	        }

	        var userWidgetInfo = widgetCallback(newWidgetInfo, widgetId);
	        if (userWidgetInfo !== undefined) {
	            return userWidgetInfo;
	        } else {
	            return newWidgetInfo;
	        }
	    };
	    return deepCallback;
	};

	var traverseRenderer = function(
	        rendererOptions,
	        contentCallback,
	        deepWidgetCallback,
	        optionsCallback) {

	    var newContent = rendererOptions.content;
	    if (rendererOptions.content != null) {
	        var modifiedContent = contentCallback(rendererOptions.content);
	        if (modifiedContent !== undefined) {
	            newContent = modifiedContent;
	        }
	    }

	    var newWidgets = objective_.mapObject(rendererOptions.widgets || {},
	            function(widgetInfo, widgetId) {
	        // Widgets without info or a type are empty widgets, and
	        // should always be renderable. It's also annoying to write
	        // checks for this everywhere, so we just filter them out once and
	        // for all!
	        if (widgetInfo == null || widgetInfo.type == null) {
	            return widgetInfo;
	        }
	        return deepWidgetCallback(widgetInfo, widgetId);
	    });

	    var newOptions = _.extend({}, rendererOptions, {
	        content: newContent,
	        widgets: newWidgets,
	    });
	    var userOptions = optionsCallback(newOptions);
	    if (userOptions !== undefined) {
	        return userOptions;
	    } else {
	        return newOptions;
	    }
	};

	var traverseRendererDeep = function(
	        rendererOptions,
	        contentCallback,
	        widgetCallback,
	        optionsCallback) {

	    contentCallback = contentCallback || noop;
	    widgetCallback = widgetCallback || noop;
	    optionsCallback = optionsCallback || noop;

	    return traverseRenderer(
	        rendererOptions,
	        contentCallback,
	        deepCallbackFor(contentCallback, widgetCallback, optionsCallback),
	        optionsCallback
	    );
	};

	module.exports = {
	    traverseRendererDeep: traverseRendererDeep,
	};



/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var WidgetJsonifyDeprecated = __webpack_require__(78);
	var _ = __webpack_require__(67);

	var ApiClassNames = __webpack_require__(17).ClassNames;
	var PropCheckBox = __webpack_require__(65);
	var Renderer = __webpack_require__(15);
	var TextListEditor = __webpack_require__(79);
	var Util = __webpack_require__(5);

	var Categorizer = React.createClass({displayName: 'Categorizer',
	    mixins: [WidgetJsonifyDeprecated, Changeable],

	    propTypes: {
	        // List of items that are being categorized (along the left side)
	        items: React.PropTypes.arrayOf(React.PropTypes.string),
	        // List of categories (across the top)
	        categories: React.PropTypes.arrayOf(React.PropTypes.string),
	        // Ordered list of correct answers, mapping items to categories thusly:
	        //   values[<items_index>] == <categories_index>
	        values: React.PropTypes.arrayOf(React.PropTypes.number)
	    },

	    getDefaultProps: function() {
	        return {
	            items: [],
	            categories: [],
	            values: []
	        };
	    },

	    getInitialState: function() {
	        return {
	            uniqueId: _.uniqueId("perseus_radio_")
	        };
	    },

	    render: function() {
	        var self = this;

	        var indexedItems = _.map(this.props.items, function(item, n)  {return [item, n];});
	        if (this.props.randomizeItems) {
	            indexedItems = Util.shuffle(indexedItems, this.props.problemNum);
	        }

	        return React.createElement("div", {className: "categorizer-container clearfix"}, React.createElement("table", null, 
	            React.createElement("thead", null, React.createElement("tr", null, 
	                React.createElement("th", null, " "), 
	                _.map(this.props.categories, function(category, i)  {
	                    // Array index is the correct key here, as that's how
	                    // category grading actually works -- no way to add or
	                    // remove categories or items in the middle. (If we later
	                    // add that, this should be fixed.)
	                    return React.createElement("th", {className: "category", key: i}, 
	                        React.createElement(Renderer, {content: category})
	                    );
	                })
	            )), 
	            React.createElement("tbody", null, _.map(indexedItems, function(indexedItem)  {
	                var item = indexedItem[0];
	                var itemNum = indexedItem[1];
	                var uniqueId = self.state.uniqueId + "_" + itemNum;
	                return React.createElement("tr", {key: itemNum}, 
	                    React.createElement("td", null, React.createElement(Renderer, {content: item})), 
	                    _.range(self.props.categories.length).map(function(catNum)  {
	                        return React.createElement("td", {className: "category", key: catNum}, 
	                            /* a pseudo-label: toggle the value of the
	                                checkbox when this div or the checkbox is
	                                clicked */
	                            React.createElement("div", {className: ApiClassNames.INTERACTIVE, 
	                                    onClick: this.onChange.bind(
	                                        this,
	                                        itemNum,
	                                        catNum
	                                    )}, 
	                                React.createElement("input", {
	                                    type: "radio", 
	                                    name: uniqueId, 
	                                    checked: 
	                                        self.props.values[itemNum] === catNum, 
	                                    
	                                    onChange: this.onChange.bind(
	                                        this,
	                                        itemNum,
	                                        catNum
	                                    ), 
	                                    onClick: function(e)  {return e.stopPropagation();}}
	                                    ), 
	                                React.createElement("span", null)
	                            )
	                        );
	                    }.bind(this))
	                );
	            }.bind(this)))
	        ));
	    },

	    onChange: function(itemNum, catNum) {
	        var values = _.clone(this.props.values);
	        values[itemNum] = catNum;
	        this.change("values", values);
	    },

	    simpleValidate: function(rubric) {
	        return Categorizer.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(Categorizer, {
	    validate: function(state, rubric) {
	        var completed = true;
	        var allCorrect = true;
	        _.each(rubric.values, function(value, i) {
	            if (state.values[i] == null) {
	                completed = false;
	            }
	            if (state.values[i] !== value) {
	                allCorrect = false;
	            }
	        });
	        if (!completed) {
	            return {
	                type: "invalid",
	                message: $._("Make sure you select something for every row.")
	            };
	        }
	        return {
	            type: "points",
	            earned: allCorrect ? 1 : 0,
	            total: 1,
	            message: null
	        };
	    }
	});


	var CategorizerEditor = React.createClass({displayName: 'CategorizerEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        items: React.PropTypes.arrayOf(React.PropTypes.string),
	        categories: React.PropTypes.arrayOf(React.PropTypes.string),
	        values: React.PropTypes.arrayOf(React.PropTypes.number),
	        randomizeItems: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            items: [],
	            categories: [],
	            values: [],
	            randomizeItems: false
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(PropCheckBox, {
	                    label: "Randomize item order", 
	                    labelAlignment: "right", 
	                    randomizeItems: this.props.randomizeItems, 
	                    onChange: this.props.onChange})
	            ), 

	            "Categories:", 
	            React.createElement(TextListEditor, {
	                options: this.props.categories, 
	                onChange: function(cat)  {this.change("categories", cat);}.bind(this), 
	                layout: "horizontal"}), 

	            "Items:", 
	            React.createElement(TextListEditor, {
	                options: this.props.items, 
	                onChange: function(items)  {this.change({
	                        items: items,
	                        // TODO(eater): This truncates props.values so there
	                        // are never more correct answers than items, ensuring
	                        // the widget is possible to answer correctly.
	                        // It doesn't necessarly keep each answer with
	                        // its corresponding item if an item is deleted from
	                        // the middle. Inconvenient, but it's at least possible
	                        // for content creators to catch and fix.
	                        values: _.first(this.props.values, items.length)
	                    });}.bind(this), 
	                layout: "vertical"}), 

	            React.createElement(Categorizer, {
	                items: this.props.items, 
	                categories: this.props.categories, 
	                values: this.props.values, 
	                onChange: function(newProps)  {this.props.onChange(newProps);}.bind(this)}
	                )
	        );
	    },
	});

	module.exports = {
	    name: "categorizer",
	    displayName: "Categorizer",
	    widget: Categorizer,
	    editor: CategorizerEditor,
	    transform: function(editorProps)  {
	        return _.pick(editorProps, "items", "categories", "randomizeItems");
	    }
	};



/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var FancySelect = __webpack_require__(74);
	var InfoTip = __webpack_require__(75);
	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var FancyOption = FancySelect.Option;

	var EditorJsonify = __webpack_require__(76);
	var ApiClassNames = __webpack_require__(17).ClassNames;
	var ApiOptions = __webpack_require__(17).Options;

	var captureScratchpadTouchStart =
	        __webpack_require__(5).captureScratchpadTouchStart;

	var Dropdown = React.createClass({displayName: 'Dropdown',
	    propTypes: {
	        choices: React.PropTypes.arrayOf(React.PropTypes.string),
	        selected: React.PropTypes.number,
	        placeholder: React.PropTypes.string,
	        apiOptions: ApiOptions.propTypes
	    },

	    getDefaultProps: function() {
	        return {
	            choices: [],
	            selected: 0,
	            placeholder: "",
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    render: function() {
	        var choices = this.props.choices.slice();

	        var selectClasses = classNames({
	            "perseus-widget-dropdown": true,
	            "perseus-fancy-dropdown": this.props.apiOptions.fancyDropdowns
	        });

	        if (this.props.apiOptions.fancyDropdowns) {
	            return React.createElement(FancySelect, {
	                    onChange: this._handleChange, 
	                    className: selectClasses + " " + ApiClassNames.INTERACTIVE, 
	                    value: this.props.selected}, 
	                React.createElement(FancyOption, {value: 0, visible: false}, 
	                    React.createElement("span", {className: "placeholder"}, 
	                        this.props.placeholder
	                    )
	                ), 
	                choices.map(function(choice, i)  {
	                    // Always visible so we can animate them with css
	                    return React.createElement(FancyOption, {key: i + 1, value: i + 1, visible: true}, 
	                        choice
	                    );
	                })
	            );

	        } else {
	            return React.createElement("select", {
	                    onChange: this._handleChangeEvent, 
	                    onTouchStart: captureScratchpadTouchStart, 
	                    className: selectClasses + " " + ApiClassNames.INTERACTIVE, 
	                    value: this.props.selected}, 
	                React.createElement("option", {value: 0, disabled: true}, 
	                    this.props.placeholder
	                ), 
	                choices.map(function(choice, i)  {
	                    return React.createElement("option", {
	                            key: "" + (i + 1), 
	                            value: i + 1}, 
	                        choice
	                    );
	                })
	            );
	        }
	    },

	    focus: function() {
	        this.getDOMNode().focus();
	        return true;
	    },

	    _handleChangeEvent: function(e) {
	        this._handleChange(parseInt(e.target.value));
	    },

	    _handleChange: function(selected) {
	        this.props.onChange({selected: selected});
	    },

	    getUserInput: function() {
	        return {value: this.props.selected};
	    },

	    simpleValidate: function(rubric) {
	        return Dropdown.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Dropdown, {
	    validate: function(state, rubric) {
	        var selected = state.value;
	        if (selected === 0) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        } else {
	            var correct = rubric.choices[selected - 1].correct;
	            return {
	                type: "points",
	                earned: correct ? 1 : 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});

	var DropdownEditor = React.createClass({displayName: 'DropdownEditor',
	    mixins: [EditorJsonify],

	    propTypes: {
	        choices: React.PropTypes.arrayOf(React.PropTypes.shape({
	            content: React.PropTypes.string,
	            correct: React.PropTypes.bool
	        })),
	        placeholder: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            placeholder: "",
	            choices: [{
	                content: "",
	                correct: false
	            }]
	        };
	    },

	    render: function() {
	        var dropdownGroupName = _.uniqueId("perseus_dropdown_");
	        return React.createElement("div", {className: "perseus-widget-dropdown"}, 
	            React.createElement("div", {className: "dropdown-info"}, "Dropdown", 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "The drop down is useful for making inequalities in a" + ' ' +
	                    "custom format. We normally use the symbols ", "<", ", ", ">", "," + ' ' +
	                    "≤, ≥ (in that order) which you can copy into the" + ' ' +
	                    "choices. When possible, use the \"multiple choice\" answer" + ' ' +
	                    "type instead.")
	                )
	            ), 
	            React.createElement("div", {className: "dropdown-placeholder"}, 
	                React.createElement("input", {
	                    type: "text", 
	                    placeholder: "Placeholder value", 
	                    value: this.props.placeholder, 
	                    onChange: this.onPlaceholderChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "This value will appear as the drop down default. It should" + ' ' +
	                    "give the user some indication of the values available in the" + ' ' +
	                    "drop down itself, e.g., Yes/No/Maybe.")
	                )
	            ), 
	            React.createElement("div", {className: "clearfix"}), 
	            React.createElement("ul", {className: "dropdown-choices"}, 
	                this.props.choices.map(function(choice, i) {
	                    var checkedClass = choice.correct ? 'correct' : 'incorrect'

	                    return React.createElement("li", {key: "" + i}, 
	                        React.createElement("div", null, 
	                            React.createElement("input", {
	                                ref: "radio" + i, 
	                                type: "radio", 
	                                name: dropdownGroupName, 
	                                checked: choice.correct ? "checked" : "", 
	                                onChange: this.onCorrectChange.bind(this, i), 
	                                value: i}), 
	                            React.createElement("input", {
	                                type: "text", 
	                                ref: "editor" + i, 
	                                onChange: this.onContentChange.bind(this, i), 
	                                className: checkedClass, 
	                                value: choice.content}), 
	                            React.createElement("a", {href: "#", className: "simple-button orange", 
	                                    onClick: this.removeChoice.bind(this, i)}, 
	                                React.createElement("span", {className: "icon-trash remove-choice"})
	                            )
	                        )
	                    );
	                }, this)
	            ), 

	            React.createElement("div", {className: "add-choice-container"}, 
	                React.createElement("a", {href: "#", className: "simple-button orange", 
	                        onClick: this.addChoice}, 
	                    React.createElement("span", {className: "icon-plus"}), 
	                    ' ', "Add a choice", ' '
	                )
	            )
	        );
	    },

	    onPlaceholderChange: function(e) {
	        var placeholder = e.target.value;
	        this.props.onChange({placeholder: placeholder});
	    },

	    onCorrectChange: function(choiceIndex) {
	        var choices = _.map(this.props.choices, function (choice, i) {
	            return _.extend({}, choice, {
	                correct: i === choiceIndex
	            });
	        });
	        this.props.onChange({choices: choices});
	    },

	    onContentChange: function(choiceIndex, e) {
	        var choices = this.props.choices.slice();
	        var choice = _.clone(choices[choiceIndex]);
	        choice.content = e.target.value;
	        choices[choiceIndex] = choice;
	        this.props.onChange({choices: choices});
	    },

	    addChoice: function(e) {
	        e.preventDefault();

	        var choices = this.props.choices;
	        var blankChoice = {content: "", correct: false};
	        this.props.onChange({
	            choices: choices.concat([blankChoice])
	        }, this.focus.bind(this, choices.length));
	    },

	    removeChoice: function(choiceIndex, e) {
	        e.preventDefault();
	        var choices = _(this.props.choices).clone();
	        choices.splice(choiceIndex, 1);
	        this.props.onChange({
	            choices: choices
	        });
	    },

	    focus: function(i) {
	        this.refs["editor" + i].getDOMNode().focus();
	        return true;
	    }
	});

	var propTransform = function(editorProps)  {
	    return {
	        placeholder: editorProps.placeholder,
	        choices: _.map(editorProps.choices, function(choice)  {return choice.content;})
	    };
	};

	module.exports = {
	    name: "dropdown",
	    displayName: "Drop down",
	    defaultAlignment: "inline-block",
	    accessible: true,
	    widget: Dropdown,
	    editor: DropdownEditor,
	    transform: propTransform
	};


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * This is a simple number-entry widget
	 * It is not as powerful as number-input, but has a simpler, more
	 * representative structure as an example widget, and is easier to
	 * test new ideas on.
	 *
	 * TODO(jack): Add more comments
	 */

	var React = __webpack_require__(68);
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var _ = __webpack_require__(67);

	var TextInput = React.createClass({displayName: 'TextInput',
	    render: function() {
	        return React.createElement("input", {
	            ref: "input", 
	            value: this.props.value || "", 
	            onChange: this.changeValue});
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    changeValue: function(e) {
	        // Translating from the js event e to the value
	        // of the textbox to send to onChange
	        this.props.onChange(e.target.value);
	    }
	});

	/**
	 * This is the widget's renderer. It shows up in the right column
	 * in test.html, and is what is visible to users, and where
	 * users enter their answers.
	 */
	var ExampleWidget = React.createClass({displayName: 'ExampleWidget',
	    propTypes: {
	        value: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            value: ""
	        };
	    },

	    /**
	     * Changeable creates this.change() to tell our parent to update our props
	     */
	    mixins: [Changeable],

	    render: function() {
	        return React.createElement(TextInput, {
	            ref: "input", 
	            value: this.props.value, 
	            onChange: this.change("value")});
	    },

	    getUserInput: function() {
	        return this.props.value;
	    },

	    /**
	     * Widgets that are focusable should add a focus method that returns
	     * true if focusing succeeded. The first such widget found will be
	     * focused on page load.
	     */
	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    /**
	     * simpleValidate is called for grading. Rubric is the result of calling
	     * getUserInput() on the editor that created this widget.
	     *
	     * Should return an object representing the grading result, such as
	     * {
	     *     type: "points",
	     *     earned: 1,
	     *     total: 1,
	     *     message: null
	     * }
	     */
	    simpleValidate: function(rubric) {
	        return ExampleWidget.validate(this.getUserInput(), rubric);
	    }
	});


	/**
	 * This is the widget's grading function
	 */
	_.extend(ExampleWidget, {
	    /**
	     * simpleValidate generally defers to this function
	     *
	     * value is usually the result of getUserInput on the widget
	     * rubric is the result of calling serialize() on the editor
	     */
	    validate: function(value, rubric) {
	        if (value === "") {
	            return {
	                type: "invalid",
	                message: "It looks like you haven't answered all of the " +
	                    "question yet."
	            };
	        } else if (value === rubric.correct) {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});


	/**
	 * This is the widget's editor. This is what shows up on the left side
	 * of the screen in test.html. Only the question writer sees this.
	 */
	var ExampleWidgetEditor = React.createClass({displayName: 'ExampleWidgetEditor',
	    mixins: [Changeable, EditorJsonify],

	    getDefaultProps: function() {
	        return {
	            correct: ""
	        };
	    },

	    handleAnswerChange: function(event) {
	        this.change({
	            correct: event.target.value
	        });
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("label", null, 
	                "Correct answer:", 
	                React.createElement("input", {
	                    value: this.props.correct, 
	                    onChange: this.handleAnswerChange, 
	                    ref: "input"})
	            )
	        );
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    }
	});


	/**
	 * For this widget to work, we must require() this file in src/all-widgets.js
	 */
	module.exports = {
	    name: "example-widget",
	    displayName: "Example Widget",

	    // Tell the renderer what type of `display:` style we would like
	    // for the component wrapping this one.
	    defaultAlignment: "inline-block", 
	    
	    hidden: true,   // Hides this widget from the Perseus.Editor widget select
	    widget: ExampleWidget,
	    editor: ExampleWidgetEditor
	};


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * This is an example graphie-using widget
	 *
	 * TODO(jack): Add more comments
	 */

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Util = __webpack_require__(5);
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var WidgetJsonifyDeprecated = __webpack_require__(78);

	var Graphie = __webpack_require__(80);
	var MovablePoint = Graphie.MovablePoint;

	var knumber = __webpack_require__(113).number;
	var kpoint = __webpack_require__(113).point;

	/**
	 * This is the widget's renderer. It shows up in the right column
	 * in test.html, and is what is visible to users, and where
	 * users enter their answers.
	 */
	var ExampleGraphieWidget = React.createClass({displayName: 'ExampleGraphieWidget',
	    mixins: [Changeable, WidgetJsonifyDeprecated],

	    propTypes: {
	        graph: React.PropTypes.object.isRequired,
	        coord: React.PropTypes.arrayOf(React.PropTypes.number)
	    },

	    getDefaultProps: function() {
	        return {
	            // We want to allow our coord to be null to test if the
	            // user has interacted with this widget yet when grading it
	            coord: null,
	            graph: {
	                box: [400, 400],
	                labels: ["x", "y"],
	                range: [[-10, 10], [-10, 10]],
	                step: [1, 1],
	                gridStep: [1, 1],
	                valid: true,
	                backgroundImage: null,
	                markings: "grid",
	                showProtractor: false
	            }
	        };
	    },

	    render: function() {
	        return React.createElement(Graphie, {
	                ref: "graphie", 
	                box: this.props.graph.box, 
	                range: this.props.graph.range, 
	                options: this.props.graph, 
	                setup: this.setupGraphie}, 
	            React.createElement(MovablePoint, {
	                    pointSize: 5, 
	                    coord: this.props.coord || [0, 0], 
	                    constraints: [
	                        MovablePoint.constraints.snap(),
	                        MovablePoint.constraints.bound()
	                    ], 
	                    onMove: this.movePoint})
	        );
	    },

	    movePoint: function(newCoord) {
	        this.change({
	            coord: newCoord
	        });
	    },

	    _getGridConfig: function(options) {
	        return _.map(options.step, function(step, i) {
	            return Util.gridDimensionConfig(
	                    step,
	                    options.range[i],
	                    options.box[i],
	                    options.gridStep[i]);
	        });
	    },

	    setupGraphie: function(graphie, options) {
	        var gridConfig = this._getGridConfig(options);
	        graphie.graphInit({
	            range: options.range,
	            scale: _.pluck(gridConfig, "scale"),
	            axisArrows: "<->",
	            labelFormat: function(s) { return "\\small{" + s + "}"; },
	            gridStep: options.gridStep,
	            tickStep: _.pluck(gridConfig, "tickStep"),
	            labelStep: 1,
	            unityLabels: _.pluck(gridConfig, "unityLabel")
	        });
	        graphie.label([0, options.range[1][1]], options.labels[1], "above");
	    },

	    simpleValidate: function(rubric) {
	        return ExampleGraphieWidget.validate(this.getUserInput(), rubric);
	    }
	});


	/**
	 * This is the widget's grading function
	 */
	_.extend(ExampleGraphieWidget, {
	    validate: function(state, rubric) {
	        if (state.coord == null) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        } else if (kpoint.equal(state.coord, rubric.correct)) {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});


	/**
	 * This is the widget's editor. This is what shows up on the left side
	 * of the screen in test.html. Only the question writer sees this.
	 */
	var ExampleGraphieWidgetEditor = React.createClass({displayName: 'ExampleGraphieWidgetEditor',
	    mixins: [Changeable, EditorJsonify],

	    getDefaultProps: function() {
	        return {
	            correct: [4, 4],
	            graph: {
	                box: [340, 340],
	                labels: ["x", "y"],
	                range: [[-10, 10], [-10, 10]],
	                step: [1, 1],
	                gridStep: [1, 1],
	                valid: true,
	                backgroundImage: null,
	                markings: "grid",
	                showProtractor: false
	            }
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement(ExampleGraphieWidget, {
	                graph: this.props.graph, 
	                coord: this.props.correct, 
	                onChange: this.handleChange})
	        );
	    },

	    handleChange: function(newProps) {
	        if (newProps.coord) {
	            this.change({
	                correct: newProps.coord
	            });
	        }
	    }
	});


	/**
	 * For this widget to work, we must export it.
	 * We also must require() this file in src/all-widgets.js
	 */
	module.exports = {
	    name: "example-graphie-widget",
	    displayName: "Example Graphie Widget",
	    hidden: true,   // Hides this widget from the Perseus.Editor widget select
	    widget: ExampleGraphieWidget,
	    editor: ExampleGraphieWidgetEditor
	};


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	var Changeable = __webpack_require__(77);
	var Editor = __webpack_require__(11);
	var EditorJsonify = __webpack_require__(76);
	var Renderer = __webpack_require__(15);
	var TextInput = __webpack_require__(81);
	var _ = __webpack_require__(67);


	var defaultExplanationProps = {
	    showPrompt: "Explain",
	    hidePrompt: "Hide explanation",
	    explanation: "explanation goes here\n\nmore explanation",
	};

	var Explanation = React.createClass({displayName: 'Explanation',
	    mixins: [Changeable],

	    propTypes: {
	        showPrompt: React.PropTypes.string,
	        hidePrompt: React.PropTypes.string,
	        explanation: React.PropTypes.string,
	    },

	    getDefaultProps: function() {
	        return defaultExplanationProps;
	    },

	    getInitialState: function() {
	        return {
	            expanded: false,
	            contentHeight: 0,
	        };
	    },

	    _onClick: function() {
	        this.setState({
	            expanded: !this.state.expanded
	        });
	    },

	    // After rendering, we want to measure the height of the explanation so we
	    // know what to animate the height to/from when showing/hiding the
	    // explanation.
	    _updateHeight: function() {
	        contentElement = React.findDOMNode(this.refs.content);

	        // Add up the heights of all the the child nodes
	        var contentHeight = Array.prototype.reduce.call(
	            contentElement.childNodes,
	            function(memo, el) {
	                return memo + (el.offsetHeight || 0);
	            },
	            0);

	        // Add the height of the renderer's top and bottom margins
	        var $renderer = $(contentElement).children(".perseus-renderer").eq(0);
	        contentHeight += $renderer.outerHeight(true) - $renderer.outerHeight();

	        // Only update state if the height is different, otherwise we'll end
	        // up calling componentDidUpdate in an infinite loop!
	        if (contentHeight !== this.state.contentHeight) {
	            this.setState({
	                contentHeight: contentHeight
	            });
	        }
	    },

	    componentDidMount: function() {
	        this._updateHeight();
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        this._updateHeight();
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-widget-explanation"}, 
	            React.createElement("a", {className: "perseus-widget-explanation-link", 
	                href: "javascript:void(0)", 
	                onClick: this._onClick}, 

	                this.state.expanded ?
	                    this.props.hidePrompt : this.props.showPrompt
	            ), 
	            React.createElement("div", {className: "perseus-widget-explanation-content", style: {
	                    height: this.state.expanded ? this.state.contentHeight : 0,
	                    overflow: "hidden"
	                }, ref: "content"}, 
	                React.createElement(Renderer, {content: this.props.explanation})
	            )
	        );
	    },

	    getUserInput: function() {
	        return {};
	    },

	    simpleValidate: function(rubric) {
	        return Explanation.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(Explanation, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});




	var ExplanationEditor = React.createClass({displayName: 'ExplanationEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        showPrompt: React.PropTypes.string,
	        hidePrompt: React.PropTypes.string,
	        explanation: React.PropTypes.string,
	    },

	    getDefaultProps: function() {
	        return defaultExplanationProps;
	    },

	    getInitialState: function() {
	        return {
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-widget-explanation-editor"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, React.createElement("label", null, 
	                "Prompt to show explanation: ", React.createElement(TextInput, {
	                    value: this.props.showPrompt, 
	                    onChange: this.change("showPrompt")})
	            )), 
	            React.createElement("div", {className: "perseus-widget-row"}, React.createElement("label", null, 
	                "Prompt to hide explanation: ", React.createElement(TextInput, {
	                    value: this.props.hidePrompt, 
	                    onChange: this.change("hidePrompt")})
	            )), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(Editor, {
	                    content: this.props.explanation, 
	                    onChange: function(props)  {
	                        this.change("explanation", props.content);
	                    }.bind(this), 
	                    widgetEnabled: false})
	            )
	        );
	    }
	});


	module.exports = {
	    name: "explanation",
	    displayName: "Explanation (for hints)",
	    defaultAlignment: "inline",
	    widget: Explanation,
	    editor: ExplanationEditor,
	    transform: _.identity
	};


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var InfoTip = __webpack_require__(75);
	var React = __webpack_require__(68);
	var SortableArea     = __webpack_require__(82);
	var Tooltip = __webpack_require__(83);
	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var WidgetJsonifyDeprecated = __webpack_require__(78);
	var ApiOptions = __webpack_require__(17).Options;
	var ApiClassNames = __webpack_require__(17).ClassNames;

	var EnabledFeatures = __webpack_require__(56);
	var PropCheckBox = __webpack_require__(65);

	var InputWithExamples = __webpack_require__(84);
	var MathInput = __webpack_require__(85);
	var TeX = __webpack_require__(73); // OldExpression only
	var TexButtons = __webpack_require__(86);

	var EnabledFeatures = __webpack_require__(56);

	var lens = __webpack_require__(114);

	var ERROR_MESSAGE = $._("Sorry, I don't understand that!");

	// TODON'T(emily): Don't delete these.
	var NO_ANSWERS_WARNING = [
	    "An expression without an answer",
	    "is no expression to me.",
	    "Who can learn from an input",
	    "like the one that I see?",
	    "Put something in there",
	    "won't you please?",
	    "A few digits will do -",
	    "might I suggest some threes?"
	    ].join("\n");
	var NO_CORRECT_ANSWERS_WARNING = "This question is probably going to be too " +
	    "hard because the expression has no correct answer.";
	var SIMPLIFY_WARNING = function(str)  {
	    return ("\"" + str + "\" is required to be simplified but is not considered ") +
	        "simplified by our fancy computer algebra system. This will be " +
	        "graded as incorrect.";
	};
	var PARSE_WARNING = function(str)  {return ("\"" + str + "\" <- you sure that's math?");};
	var NOT_SPECIFIED_WARNING = function(ix)  {
	    return ("mind filling in answer " + ix + "? (the blank one)");
	};

	// The new, MathQuill input expression widget
	var Expression = React.createClass({displayName: 'Expression',
	    mixins: [Changeable],

	    propTypes: {
	        value: React.PropTypes.string,
	        times: React.PropTypes.bool,
	        functions: React.PropTypes.arrayOf(React.PropTypes.string),
	        buttonSets: TexButtons.buttonSetsType,
	        buttonsVisible: React.PropTypes.oneOf(['always', 'never', 'focused']),
	        enabledFeatures: EnabledFeatures.propTypes,
	        apiOptions: ApiOptions.propTypes
	    },

	    getDefaultProps: function() {
	        return {
	            value: "",
	            times: false,
	            functions: [],
	            buttonSets: ["basic", "trig", "prealgebra", "logarithms"],
	            onFocus: function() { },
	            onBlur: function() { },
	            enabledFeatures: EnabledFeatures.defaults,
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    getInitialState: function() {
	        return {
	            showErrorTooltip: false,
	            showErrorText: false
	        };
	    },

	    parse: function(value, props) {
	        // TODO(jack): Disable icu for content creators here, or
	        // make it so that solution answers with ','s or '.'s work
	        var options = _.pick(props || this.props, "functions");
	        if (window.icu && window.icu.getDecimalFormatSymbols) {
	            _.extend(options, window.icu.getDecimalFormatSymbols());
	        }
	        return KAS.parse(value, options);
	    },

	    render: function() {
	        if (this.props.apiOptions.staticRender) {
	            // To make things slightly easier, we just use an InputWithExamples
	            // component to handle the static rendering, which is the same
	            // component used by InputNumber and NumericInput
	            return React.createElement(InputWithExamples, {
	                        ref: "input", 
	                        value: this.props.value, 
	                        type: "tex", 
	                        examples: [], 
	                        shouldShowExamples: false, 
	                        onChange: this.change("value"), 
	                        onFocus: this._handleFocus, 
	                        onBlur: this._handleBlur});
	        } else {
	            // TODO(alex): Style this tooltip to be more consistent with other
	            // tooltips on the site; align to left middle (once possible)
	            var errorTooltip = React.createElement("span", {className: "error-tooltip"}, 
	                React.createElement(Tooltip, {
	                        className: "error-text-container", 
	                        horizontalPosition: "right", 
	                        horizontalAlign: "left", 
	                        verticalPosition: "top", 
	                        arrowSize: 10, 
	                        borderColor: "#fcc335", 
	                        show: this.state.showErrorText}, 
	                    React.createElement("i", {
	                        className: "icon-exclamation-sign error-icon", 
	                        onMouseEnter: function()  {
	                            this.setState({showErrorText: true});
	                        }.bind(this), 
	                        onMouseLeave: function()  {
	                            this.setState({showErrorText: false});
	                        }.bind(this), 
	                        onClick: function()  {
	                            // TODO(alex): Better error feedback for mobile
	                            this.setState({
	                                showErrorText: !this.state.showErrorText
	                            });
	                        }.bind(this)}), 
	                    React.createElement("div", {className: "error-text"}, 
	                        ERROR_MESSAGE
	                    )
	                )
	            );

	            var className = classNames({
	                "perseus-widget-expression": true,
	                "show-error-tooltip": this.state.showErrorTooltip
	            });

	            return React.createElement("span", {className: className}, 
	                React.createElement(MathInput, {
	                    ref: "input", 
	                    className: ApiClassNames.INTERACTIVE, 
	                    value: this.props.value, 
	                    onChange: this.change("value"), 
	                    convertDotToTimes: this.props.times, 
	                    buttonsVisible: this.props.buttonsVisible || "focused", 
	                    buttonSets: this.props.buttonSets, 
	                    onFocus: this._handleFocus, 
	                    onBlur: this._handleBlur}), 
	                this.state.showErrorTooltip && errorTooltip
	            );
	        }
	    },

	    _handleFocus: function() {
	        this.props.onFocus([]);
	    },

	    _handleBlur: function() {
	        this.props.onBlur([]);
	    },

	    errorTimeout: null,

	    // Whenever the input value changes, attempt to parse it.
	    //
	    // Clear any errors if this parse succeeds, show an error within a second
	    // if it fails.
	    componentWillReceiveProps: function(nextProps) {
	        if (!_.isEqual(this.props.value, nextProps.value) ||
	            !_.isEqual(this.props.functions, nextProps.functions)) {

	            clearTimeout(this.errorTimeout);

	            if (this.parse(nextProps.value, nextProps).parsed) {
	                this.setState({showErrorTooltip: false});
	            } else {
	                // Store timeout ID so that we can clear it above
	                this.errorTimeout = setTimeout(function()  {
	                    var apiResult = this.props.apiOptions.onInputError(
	                        null, // reserved for some widget identifier
	                        this.props.value,
	                        ERROR_MESSAGE
	                    );
	                    if (apiResult !== false) {
	                        this.setState({showErrorTooltip: true});
	                    }
	                }.bind(this), 2000);
	            }
	        }
	    },

	    componentWillUnmount: function() {
	        clearTimeout(this.errorTimeout);
	    },

	    focus: function() {
	        // The buttons are often on top of text you're trying to read, so don't
	        // focus the editor automatically.
	        return true;
	    },

	    focusInputPath: function(inputPath) {
	        this.refs.input.focus();
	    },

	    blurInputPath: function(inputPath) {
	        this.refs.input.blur();
	    },

	    // HACK(joel)
	    insert: function(text) {
	        if (!this.props.apiOptions.staticRender) {
	            this.refs.input.insert(text);
	        }
	    },

	    getInputPaths: function() {
	        // The widget itself is an input, so we return a single empty list to
	        // indicate this.
	        return [[]];
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "expression";
	    },

	    setInputValue: function(path, newValue, cb) {
	        this.props.onChange({
	            value: newValue
	        }, cb);
	    },

	    getAcceptableFormatsForInputPath: function() {
	        // TODO(charlie): What format does the mobile team want this in?
	        return null;
	    },

	    getUserInput: function() {
	        return this.props.value;
	    },

	    simpleValidate: function(rubric, onInputError) {
	        onInputError = onInputError || function() { };
	        return Expression.validate(this.getUserInput(), rubric, onInputError);
	    }
	});

	/* Content creators input a list of answers which are matched from top to
	 * bottom. The intent is that they can include spcific solutions which should
	 * be graded as correct or incorrect (or ungraded!) first, then get more
	 * general.
	 *
	 * We iterate through each answer, trying to match it with the user's input
	 * using the following angorithm:
	 * - Try to parse the user's input. If it doesn't parse then return "not
	 *   graded".
	 * - For each answer:
	 *   ~ Try to validate the user's input against the answer. The answer is
	 *     expected to parse.
	 *   ~ If the user's input validates (the validator judges it "correct"), we've
	 *     matched and can stop considering answers.
	 * - If there were no matches or the matching answer is considered "ungraded",
	 *   show the user an error. TODO(joel) - what error?
	 * - Otherwise, pass through the resulting points and message.
	 */
	_.extend(Expression, {
	    validate: function(state, rubric, onInputError) {
	        var options = _.clone(rubric);
	        if (window.icu && window.icu.getDecimalFormatSymbols) {
	            _.extend(options, window.icu.getDecimalFormatSymbols());
	        }

	        var createValidator = function(answer)  {
	            return Khan.answerTypes.expression.createValidatorFunctional(
	                // We don't give options to KAS.parse here because that is
	                // parsing the solution answer, not the student answer, and we
	                // don't want a solution to work if the student is using a
	                // different language but not in english.
	                KAS.parse(answer.value, rubric).expr,
	                _({}).extend(options, {
	                    simplify: answer.simplify,
	                    form: answer.form
	                })
	            );
	        };

	        // find the first result to match the user's input
	        var result;
	        var matchingAnswer;
	        var allEmpty = true;
	        var foundMatch = !!_(rubric.answerForms).find(function(answer)  {
	            var validate = createValidator(answer);

	            // save these because they'll be needed if this answer matches
	            result = validate(state);
	            matchingAnswer = answer;
	            allEmpty = allEmpty && result.empty;

	            // short-circuit as soon as an answer matches
	            return result.correct;
	        });

	        var message = "" || (result && result.message);

	        // now check to see whether it's considered correct, incorrect, or
	        // ungraded
	        if (!foundMatch) {
	            if (allEmpty) {
	                // If everything graded as empty, it's invalid.
	                return {
	                    type: "invalid",
	                    message: null
	                };
	            } else {
	                // We fell through all the possibilities and we're not empty,
	                // so the answer is considered incorrect.
	                return {
	                    type: "points",
	                    earned: 0,
	                    total: 1
	                };
	            }

	        // we matched an ungraded answer - return "invalid"
	        } else if (matchingAnswer.considered === "ungraded") {
	            var apiResult = onInputError(
	                null, // reserved for some widget identifier
	                state,
	                message
	            );
	            return {
	                type: "invalid",
	                message: apiResult === false ? null : message
	            };

	        // The user's input matched one of the answers - is it correct or
	        // incorrect?
	        } else {

	            // TODO(eater): Seems silly to translate result to this
	            // invalid/points thing and immediately translate it back in
	            // ItemRenderer.scoreInput()
	            return {
	                type: "points",
	                earned: matchingAnswer.considered === "correct" ? 1 : 0,
	                total: 1,
	                message: message
	            };
	        }
	    }
	});

	// The old, plain-text input expression widget
	var OldExpression = React.createClass({displayName: 'OldExpression',
	    propTypes: {
	        value: React.PropTypes.string,
	        times: React.PropTypes.bool,
	        functions: React.PropTypes.arrayOf(React.PropTypes.string),
	        enabledFeatures: EnabledFeatures.propTypes
	    },

	    getDefaultProps: function() {
	        return {
	            value: "",
	            times: false,
	            functions: [],
	            onFocus: function() { },
	            onBlur: function() { },
	            enabledFeatures: EnabledFeatures.defaults,
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    getInitialState: function() {
	        return {
	            lastParsedTex: ""
	        };
	    },

	    parse: function(value, props) {
	        // TODO(jack): Disable icu for content creators here, or
	        // make it so that solution answers with ','s or '.'s work
	        var options = _.pick(props || this.props, "functions");
	        if (window.icu && window.icu.getDecimalFormatSymbols) {
	            _.extend(options, window.icu.getDecimalFormatSymbols());
	        }
	        return KAS.parse(value, options);
	    },

	    componentWillMount: function() {
	        this.updateParsedTex(this.props.value);
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.updateParsedTex(nextProps.value, nextProps);
	    },

	    render: function() {
	        var result = this.parse(this.props.value);
	        var shouldShowExamples = this.props.enabledFeatures.toolTipFormats;

	        return React.createElement("span", {className: "perseus-widget-expression-old"}, 
	            React.createElement("span", {className: "output"}, 
	                React.createElement("span", {className: "tex", 
	                        style: {opacity: result.parsed ? 1.0 : 0.5}}, 
	                    React.createElement(TeX, null, this.state.lastParsedTex)
	                ), 
	                React.createElement("span", {className: "placeholder"}, 
	                    React.createElement("span", {ref: "error", className: "error", 
	                            style: {display: "none"}}, 
	                        React.createElement("span", {className: "buddy"}), 
	                        React.createElement("span", {className: "message"}, React.createElement("span", null, 
	                            ERROR_MESSAGE
	                        ))
	                    )
	                )
	            ), 
	            React.createElement(InputWithExamples, {
	                    ref: "input", 
	                    value: this.props.value, 
	                    onKeyDown: this.handleKeyDown, 
	                    onKeyPress: this.handleKeyPress, 
	                    onChange: this.handleChange, 
	                    examples: this.examples(), 
	                    shouldShowExamples: shouldShowExamples, 
	                    onFocus: this._handleFocus, 
	                    onBlur: this._handleBlur})
	        );
	    },

	    _handleFocus: function() {
	        this.props.onFocus([]);
	    },

	    _handleBlur: function() {
	        this.props.onBlur([]);
	    },

	    errorTimeout: null,

	    componentDidMount: function() {
	        this.componentDidUpdate();
	    },

	    componentDidUpdate: function() {
	        clearTimeout(this.errorTimeout);
	        if (this.parse(this.props.value).parsed) {
	            this.hideError();
	        } else {
	            this.errorTimeout = setTimeout(this.showError, 2000);
	        }
	    },

	    componentWillUnmount: function() {
	        clearTimeout(this.errorTimeout);
	    },

	    showError: function() {
	        var apiResult = this.props.apiOptions.onInputError(
	            null, // reserved for some widget identifier
	            this.props.value,
	            ERROR_MESSAGE
	        );
	        if (apiResult !== false) {
	            var $error = $(this.refs.error.getDOMNode());
	            if (!$error.is(":visible")) {
	                $error.css({ top: 50, opacity: 0.1 }).show()
	                    .animate({ top: 0, opacity: 1.0 }, 300);
	            }
	        } else {
	            this.hideError();
	        }
	    },

	    hideError: function() {
	        var $error = $(this.refs.error.getDOMNode());
	        if ($error.is(":visible")) {
	            $error.animate({ top: 50, opacity: 0.1 }, 300, function() {
	                $(this).hide();
	            });
	        }
	    },

	    /**
	     * The keydown handler handles clearing the error timeout, telling
	     * props.value to update, and intercepting the backspace key when
	     * appropriate...
	     */
	    handleKeyDown: function(event) {
	        var input = this.refs.input.getDOMNode();
	        var text = input.value;

	        var start = input.selectionStart;
	        var end = input.selectionEnd;
	        var supported = start !== undefined;

	        var which = event.nativeEvent.keyCode;

	        if (supported && which === 8 /* backspace */) {
	            if (start === end && text.slice(start - 1, start + 1) === "()") {
	                event.preventDefault();
	                var val = text.slice(0, start - 1) + text.slice(start + 1);

	                // this.props.onChange will update the value for us, but
	                // asynchronously, making it harder to set the selection
	                // usefully, so we just set .value directly here as well.
	                input.value = val;
	                input.selectionStart = start - 1;
	                input.selectionEnd = end - 1;
	                this.props.onChange({value: val});
	            }
	        }
	    },

	    /**
	     * ...whereas the keypress handler handles the parentheses because keyCode
	     * is more useful for actual character insertions (keypress gives 40 for an
	     * open paren '(' instead of keydown which gives 57, the code for '9').
	     */
	    handleKeyPress: function(event) {
	        var input = this.refs.input.getDOMNode();
	        var text = input.value;

	        var start = input.selectionStart;
	        var end = input.selectionEnd;
	        var supported = start !== undefined;

	        var which = event.nativeEvent.charCode;

	        if (supported && which === 40 /* left paren */) {
	            event.preventDefault();

	            var val;
	            if (start === end) {
	                var insertMatched = _.any([" ", ")", ""], function(val) {
	                    return text.charAt(start) === val;
	                });

	                val = text.slice(0, start) +
	                        (insertMatched ? "()" : "(") + text.slice(end);
	            } else {
	                val = text.slice(0, start) +
	                        "(" + text.slice(start, end) + ")" + text.slice(end);
	            }

	            input.value = val;
	            input.selectionStart = start + 1;
	            input.selectionEnd = end + 1;
	            this.props.onChange({value: val});

	        } else if (supported && which === 41 /* right paren */) {
	            if (start === end && text.charAt(start) === ")") {
	                event.preventDefault();
	                input.selectionStart = start + 1;
	                input.selectionEnd = end + 1;
	            }
	        }
	    },

	    handleChange: function(newValue) {
	        this.props.onChange({value: newValue});
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    getInputPaths: function() {
	        // The widget itself is an input, so we return a single empty list to
	        // indicate this.
	        return [[]];
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "expression";
	    },

	    getUserInput: function() {
	        return this.props.value;
	    },

	    updateParsedTex: function(value, props) {
	        var result = this.parse(value, props);
	        var options = _.pick(this.props, "times");
	        if (result.parsed) {
	            this.setState({lastParsedTex: result.expr.asTex(options)});
	        }
	    },

	    simpleValidate: function(rubric, onInputError) {
	        onInputError = onInputError || function() { };
	        return Expression.validate(this.getUserInput(), rubric, onInputError);
	    },

	    examples: function() {
	        var mult = $._("For $2\\cdot2$, enter **2*2**");
	        if (this.props.times) {
	            mult = mult.replace(/\\cdot/g, "\\times");
	        }

	        return [
	            $._("**Acceptable Formats**"),
	            mult,
	            $._("For $3y$, enter **3y** or **3*y**"),
	            $._("For $\\dfrac{1}{x}$, enter **1/x**"),
	            $._("For $\\dfrac{1}{xy}$, enter **1/(xy)**"),
	            $._("For $\\dfrac{2}{x + 3}$, enter **2/(x + 3)**"),
	            $._("For $x^{y}$, enter **x^y**"),
	            $._("For $x^{2/3}$, enter **x^(2/3)**"),
	            $._("For $\\sqrt{x}$, enter **sqrt(x)**"),
	            $._("For $\\pi$, enter **pi**"),
	            $._("For $\\sin \\theta$, enter **sin(theta)**"),
	            $._("For $\\le$ or $\\ge$, enter **<=** or **>=**"),
	            $._("For $\\neq$, enter **=/=**")
	        ];
	    }
	});

	// An answer can be considered correct, wrong, or ungraded.
	var CONSIDERED = ["correct", "wrong", "ungraded"];

	var answerFormType = React.PropTypes.shape({
	    considered: React.PropTypes.oneOf(CONSIDERED).isRequired,
	    value: React.PropTypes.string.isRequired,
	    form: React.PropTypes.bool.isRequired,
	    simplify: React.PropTypes.bool.isRequired
	});

	var ExpressionEditor = React.createClass({displayName: 'ExpressionEditor',
	    mixins: [Changeable],

	    propTypes: {
	        answerForms: React.PropTypes.arrayOf(answerFormType),
	        times: React.PropTypes.bool,
	        buttonSets: TexButtons.buttonSetsType,
	        functions: React.PropTypes.arrayOf(React.PropTypes.string)
	    },

	    getDefaultProps: function() {
	        return {
	            answerForms: [],
	            times: false,
	            buttonSets: ["basic"],
	            functions: ["f", "g", "h"]
	        };
	    },

	    getInitialState: function() {
	        // Is the format of `value` TeX or plain text?
	        // TODO(alex): Remove after backfilling everything to TeX
	        // TODO(joel) - sucks if you edit some expression without
	        // backslashes or curly braces, then come back to the question and
	        // it's surprisingly not TeX anymore.

	        var isTex;
	        // default to TeX if new;
	        if (this.props.answerForms.length === 0) {
	            isTex = true;
	        } else {
	            isTex = _(this.props.answerForms).any(function(form)  {
	                var $__0=    form,value=$__0.value;
	                // only TeX has backslashes and curly braces
	                return _.indexOf(value, "\\") !== -1 ||
	                       _.indexOf(value, "{")  !== -1;
	            });
	        }

	        return { isTex:isTex };
	    },

	    render: function() {

	        var expression = this.state.isTex ? Expression : OldExpression;

	        var answerOptions = this.props.answerForms
	            .map(function(obj, ix)  {
	                var expressionProps = {
	                        // note we're using
	                        // *this.props*.{times,functions,buttonSets} since each
	                        // answer area has the same settings for those
	                        times: this.props.times,
	                        functions: this.props.functions,
	                        buttonSets: this.props.buttonSets,

	                        buttonsVisible: "focused",
	                        form: obj.form,
	                        simplify: obj.simplify,
	                        value: obj.value,

	                        onChange: function(props)  {return this.updateForm(ix, props);}.bind(this),
	                };

	                return lens(obj)
	                    .merge([], {
	                        draggable: true,
	                        onChange: function(props)  {return this.updateForm(ix, props);}.bind(this),
	                        onDelete: function()  {return this.handleRemoveForm(ix);}.bind(this),
	                        expressionProps: expressionProps
	                    })
	                    .freeze();
	            }.bind(this))
	            .map(function(obj)  {return React.createElement(AnswerOption, React.__spread({},  obj));});

	        var sortable = React.createElement(SortableArea, {components: answerOptions, 
	                                     onReorder: this.handleReorder, 
	                                     className: "answer-options-list"});

	        var Expr = this.state.isTex ? Expression : OldExpression;

	        // checkboxes to choose which sets of input buttons are shown
	        var buttonSetChoices = _(TexButtons.buttonSets).map(function(set, name)  {
	            // The first one gets special cased to always be checked, disabled,
	            // and float left.
	            var isFirst = name === "basic";
	            var checked = _.contains(this.props.buttonSets, name) || isFirst;
	            var className = isFirst ?
	                "button-set-label-float" :
	                "button-set-label";
	            return React.createElement("label", {className: className, key: name}, 
	                React.createElement("input", {type: "checkbox", 
	                       checked: checked, 
	                       disabled: isFirst, 
	                       onChange: function()  {return this.handleButtonSet(name);}.bind(this)}), 
	                name
	            );
	        }.bind(this));

	        buttonSetChoices.splice(1, 1, React.createElement("label", {key: "show-div"}, 
	            React.createElement("input", {type: "checkbox", 
	                   onChange: this.handleToggleDiv}), 
	            React.createElement("span", {className: "show-div-button"}, 
	                "show ", React.createElement(TeX, null, "\\div"), " button"
	            )
	        ));

	        return React.createElement("div", {className: "perseus-widget-expression-editor"}, 
	            React.createElement("h3", {className: "expression-editor-h3"}, "Global Options"), 

	            React.createElement("div", null, 
	                React.createElement(PropCheckBox, {
	                    times: this.props.times, 
	                    onChange: this.props.onChange, 
	                    labelAlignment: "right", 
	                    label: "Use × for rendering multiplication instead of a" + ' ' +
	                        "center dot."}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "For pre-algebra problems this option displays" + ' ' +
	                    "multiplication as \\times instead of \\cdot in both the" + ' ' +
	                    "rendered output and the acceptable formats examples.")
	                )
	            ), 

	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                "Function variables: ", 
	                React.createElement("input", {type: "text", 
	                    defaultValue: this.props.functions.join(" "), 
	                    onChange: this.handleFunctions})
	                ), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "Single-letter variables listed here will be" + ' ' +
	                    "interpreted as functions. This let us know that f(x) means" + ' ' +
	                    "\"f of x\" and not \"f times x\"."
	                ))
	            ), 

	            React.createElement("div", null, 
	                React.createElement("div", null, "Button sets:"), 
	                buttonSetChoices
	            ), 

	            this.state.isTex && React.createElement(TexButtons, {
	                className: "math-input-buttons", 
	                sets: this.props.buttonSets, 
	                convertDotToTimes: this.props.times, 
	                onInsert: this.handleTexInsert}), 

	            React.createElement("h3", {className: "expression-editor-h3"}, "Answers"), 

	            React.createElement("p", {style: {margin: "4px 0"}}, 
	                "student responses area matched against these from top to bottom"
	            ), 

	            sortable, 

	            React.createElement("div", null, 
	                React.createElement("button", {className: "simple-button orange", 
	                        style: {fontSize: 13}, 
	                        onClick: this.newAnswer, 
	                        type: "button"}, 
	                    "Add new answer"
	                )
	            )

	        );
	    },

	    serialize: function() {
	        var formSerializables = ["value", "form", "simplify", "considered",
	            // it's a little weird to serialize the react key, but saves some
	            // effort reconstructing them when this item is loaded later.
	            "key"];
	        var serializables = ["answerForms", "buttonSets", "functions",
	            "times"];

	        var answerForms = this.props.answerForms.map(function(form)  {
	            return _(form).pick(formSerializables);
	        });

	        return lens(this.props)
	            .set(["answerForms"], answerForms)
	            .mod([], function(props)  {return _(props).pick(serializables);})
	            .freeze();
	    },

	    getSaveWarnings: function() {
	        var issues = [];

	        if (this.props.answerForms.length === 0) {
	            issues.push("No answers specified");
	        } else {

	            var hasCorrect = !!_(this.props.answerForms).find(function(form)  {
	                return form.considered === "correct";
	            });
	            if (!hasCorrect) {
	                issues.push("No correct answer specified");
	            }

	            _(this.props.answerForms).each(function(form, ix)  {
	                if (this.props.value === "") {
	                    issues.push(("Answer " + (ix+1) + " is empty"));
	                } else {
	                    // note we're not using icu for content creators
	                    var expression = KAS.parse(form.value);
	                    if (!expression.parsed) {
	                        issues.push(("Couldn't parse " + form.value));
	                    } else if (form.simplify &&
	                               !expression.expr.isSimplified()) {
	                        issues.push(
	                            (form.value + " isn't simplified, but is required\" +\n                            \" to be"
	));
	                    }
	                }
	            }.bind(this));

	            // TODO(joel) - warn about:
	            //   - unreachable answers (how??)
	            //   - specific answers following unspecific answers
	            //   - incorrect answers as the final form
	        }

	        return issues;
	    },

	    _newEmptyAnswerForm: function() {
	        return {
	            considered: 'correct',
	            form: false,

	            // note: the key means "n-th form created" - not "form in
	            // position n" and will stay the same for the life of this form
	            key: this.props.answerForms.length,

	            simplify: false,
	            value: "",
	        };
	    },

	    newAnswer: function() {
	        var answerForms = this.props.answerForms.slice();
	        answerForms.push(this._newEmptyAnswerForm());
	        this.change({ answerForms:answerForms });
	    },

	    handleRemoveForm: function(i) {
	        var answerForms = this.props.answerForms.slice(0, -1);
	        this.change({ answerForms:answerForms });
	    },

	    // called when the options (including the expression itself) to an answer
	    // form change
	    updateForm: function(i, props) {
	        var answerForms = lens(this.props.answerForms)
	            .merge([i], props)
	            .freeze();

	        this.change({ answerForms:answerForms });
	    },

	    handleReorder: function(components) {
	        var answerForms = _(components).map(function(component)  {
	            var form = _(component.props)
	                .pick("considered", "form", "simplify", "value");
	            form.key = component.key;
	            return form;
	        });

	        this.change({ answerForms:answerForms });
	    },

	    // called when the selected buttonset changes
	    handleButtonSet: function(changingName) {
	        var buttonSetNames = _(TexButtons.buttonSets).keys();

	        // Filter to preserve order - using .union and .difference would always
	        // move the last added button set to the end.
	        var buttonSets = _(buttonSetNames).filter(function(set)  {
	            return _(this.props.buttonSets).contains(set) !==
	                   (set === changingName);
	        }.bind(this));

	        this.props.onChange({ buttonSets:buttonSets });
	    },

	    handleToggleDiv: function() {
	        // We always want buttonSets to contain exactly one of "basic" and
	        // "basic+div". Toggle between the two of them.
	        // If someone can think of a more elegant formulation of this (there
	        // must be one!) feel free to change it.
	        var keep, remove;
	        if (_(this.props.buttonSets).contains("basic+div")) {
	            keep = "basic";
	            remove = "basic+div";
	        } else {
	            keep = "basic+div";
	            remove = "basic";
	        }

	        var buttonSets = _(this.props.buttonSets)
	            .reject(function(set)  {return set === remove;})
	            .concat(keep);

	        this.change("buttonSets", buttonSets);
	    },

	    // called when the correct answer changes
	    handleTexInsert: function(str) {
	        this.refs.expression.insert(str);
	    },

	    // called when the function variables change
	    handleFunctions: function(e) {
	        var newProps = {};
	        newProps.functions = _.compact(e.target.value.split(/[ ,]+/));
	        this.props.onChange(newProps);
	    }
	});

	// Find the next element in arr after val, wrapping around to the first.
	var findNextIn = function(arr, val) {
	    var ix = _(arr).indexOf(val);
	    ix = (ix + 1) % arr.length;
	    return arr[ix];
	};

	var AnswerOption = React.createClass({displayName: 'AnswerOption',
	    mixins: [Changeable],

	    propTypes: {
	        considered: React.PropTypes.oneOf(CONSIDERED).isRequired,
	        expressionProps: React.PropTypes.object.isRequired,

	        // Must the answer have the same form as this answer.
	        form: React.PropTypes.bool.isRequired,

	        // Must the answer be simplified.
	        simplify: React.PropTypes.bool.isRequired,

	        onChange: React.PropTypes.func.isRequired,
	        onDelete: React.PropTypes.func.isRequired
	    },

	    getInitialState: function() {
	        return { deleteFocused: false };
	    },

	    handleDeleteBlur: function() {
	        this.setState({ deleteFocused: false });
	    },

	    render: function() {
	        var removeButton = null;
	        if (this.state.deleteFocused) {
	            removeButton = React.createElement("button", {type: "button", 
	                                   className: "simple-button orange", 
	                                   onClick: this.handleImSure, 
	                                   onBlur: this.handleDeleteBlur}, 
	                                "I'm sure!"
	                           );
	        } else {
	            removeButton = React.createElement("button", {type: "button", 
	                                   className: "simple-button orange", 
	                                   onClick: this.handleDelete}, 
	                                "Delete"
	                           );
	        }

	        return React.createElement("div", {className: "expression-answer-option"}, 

	            React.createElement("div", {className: "answer-handle"}), 

	            React.createElement("div", {className: "answer-body"}, 

	                React.createElement("div", {className: "answer-considered"}, 
	                    React.createElement("div", {onClick: this.toggleConsidered, 
	                         className: "answer-status " + this.props.considered}, 
	                        this.props.considered
	                    ), 

	                    React.createElement("div", {className: "answer-expression"}, 
	                        React.createElement(Expression, React.__spread({},  this.props.expressionProps))
	                    )
	                ), 

	                React.createElement("div", {className: "answer-option"}, 
	                    React.createElement(PropCheckBox, {
	                        form: this.props.form, 
	                        onChange: this.props.onChange, 
	                        labelAlignment: "right", 
	                        label: "Answer expression must have the same form."}), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, 
	                            "The student's answer must be in the same form." + ' ' +
	                            "Commutativity and excess negative signs are" + ' ' +
	                            "ignored."
	                        )
	                    )
	                ), 

	                React.createElement("div", {className: "answer-option"}, 
	                    React.createElement(PropCheckBox, {
	                        simplify: this.props.simplify, 
	                        onChange: this.props.onChange, 
	                        labelAlignment: "right", 
	                        label: "Answer expression must be fully expanded and" + ' ' +
	                            "simplified."}), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, 
	                            "The student's answer must be fully expanded and" + ' ' +
	                            "simplified. Answering this equation (x^2+2x+1) with" + ' ' +
	                            "this factored equation (x+1)^2 will render this" + ' ' +
	                            "response \"Your answer is not fully expanded and" + ' ' +
	                            "simplified.\""
	                        )
	                    )
	                ), 

	                React.createElement("div", {className: "remove-container"}, removeButton)

	            )

	        );
	    },

	    handleImSure: function() {
	        this.props.onDelete();
	    },

	    handleDelete: function() {
	        this.setState({ deleteFocused: true });
	    },

	    toggleConsidered: function() {
	        var newVal = findNextIn(CONSIDERED, this.props.considered);
	        this.change({ considered: newVal });
	    },
	});

	/*
	 * v0 props follow this schema:
	 *
	 *     times: bool
	 *     buttonSets: [string]
	 *     functions: [string]
	 *     buttonsVisible: "always" | "focused" | "never"
	 *
	 *     value: string
	 *     form: bool
	 *     simplify: bool
	 *
	 * v1 props follow this schema:
	 *
	 *     times: bool
	 *     buttonSets: [string]
	 *     functions: [string]
	 *     buttonsVisible: "always" | "focused" | "never"
	 *
	 *     answerForms: [{
	 *         considered: "correct" | "ungraded" | "incorrect"
	 *         form: bool
	 *         simplify: bool
	 *         value: string
	 *     }]
	 */
	propUpgrades = {
	    1: function(v0props)  {return {
	        times: v0props.times,
	        buttonSets: v0props.buttonSets,
	        functions: v0props.functions,
	        buttonsVisible: v0props.buttonsVisible,

	        answerForms: [{
	            considered: "correct",
	            form: v0props.form,
	            simplify: v0props.simplify,
	            value: v0props.value,
	            key: 0,
	        }]
	    };}
	};

	module.exports = {
	    name: "expression",
	    displayName: "Expression / Equation",
	    getDefaultAlignment: function (enabledFeatures) {
	        // Each version of the widget has different alignments
	        return enabledFeatures.useMathQuill ? "inline-block" : "block";
	    },
	    getWidget: function(enabledFeatures)  {
	        // Allow toggling between the two versions of the widget
	        return enabledFeatures.useMathQuill ? Expression : OldExpression;
	    },
	    editor: ExpressionEditor,
	    transform: function(editorProps)  {
	        return _.pick(editorProps, "times", "functions", "buttonSets",
	                      "buttonsVisible", "answerForms");
	    },
	    version: { major: 1, minor: 0 },
	    propUpgrades: propUpgrades,
	};


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var ButtonGroup      = __webpack_require__(87);
	var GraphSettings    = __webpack_require__(88);
	var InfoTip          = __webpack_require__(75);
	var Interactive2     = __webpack_require__(89);
	var MultiButtonGroup = __webpack_require__(90);
	var SvgImage         = __webpack_require__(64);
	var Util             = __webpack_require__(5);

	/* Graphie and relevant components. */
	var Graphie      = __webpack_require__(80);
	var MovablePoint = Graphie.MovablePoint;
	var Plot         = Graphie.Plot;
	var MovableLine  = Graphie.MovableLine;

	var knumber = __webpack_require__(113).number;
	var kvector = __webpack_require__(113).vector;
	var kpoint = __webpack_require__(113).point;

	/* Mixins. */
	var Changeable   = __webpack_require__(77);

	/* Utility objects and functions. */
	var defaultBoxSize = 400;
	var defaultEditorBoxSize = 340;
	var defaultBackgroundImage = {
	    url: null
	};
	var defaultType = "linear";

	function typeToButton(type) {
	    var capitalized = type.charAt(0).toUpperCase() + type.substring(1);
	    return {
	        value: type,
	        title: capitalized,
	        content: React.createElement("img", {src: functionForType(type).url, alt: capitalized})
	    };
	}

	function isFlipped(newCoord, oldCoord, line) {
	    var CCW = function(a, b, c)  {
	        return (b[0] - a[0]) * (c[1] - a[1]) - (c[0] - a[0]) * (b[1] - a[1]);
	    };
	    return (CCW(line[0], line[1], oldCoord) > 0) !==
	        (CCW(line[0], line[1], newCoord) > 0);
	}

	// TODO(charlie): These really need to go into a utility file as they're being
	// used by both interactive-graph and now grapher.
	function canonicalSineCoefficients(coeffs) {
	    // For a curve of the form f(x) = a * Sin(b * x - c) + d,
	    // this function ensures that a, b > 0, and c is its
	    // smallest possible positive value.
	    var amplitude = coeffs[0];
	    var angularFrequency = coeffs[1];
	    var phase = coeffs[2];
	    var verticalOffset = coeffs[3];

	    // Guarantee a > 0
	    if (amplitude < 0) {
	        amplitude *= -1;
	        angularFrequency *= -1;
	        phase *= -1;
	    }

	    var period = 2 * Math.PI;
	    // Guarantee b > 0
	    if (angularFrequency < 0) {
	        angularFrequency *= -1;
	        phase *= -1;
	        phase += period / 2;
	    }

	    // Guarantee c is smallest possible positive value
	    while (phase > 0) {
	        phase -= period;
	    }
	    while (phase < 0) {
	        phase += period;
	    }

	    return [amplitude, angularFrequency, phase, verticalOffset];
	}

	function canonicalTangentCoefficients(coeffs) {
	    // For a curve of the form f(x) = a * Tan(b * x - c) + d,
	    // this function ensures that a, b > 0, and c is its
	    // smallest possible positive value.
	    var amplitude = coeffs[0];
	    var angularFrequency = coeffs[1];
	    var phase = coeffs[2];
	    var verticalOffset = coeffs[3];

	    // Guarantee a > 0
	    if (amplitude < 0) {
	        amplitude *= -1;
	        angularFrequency *= -1;
	        phase *= -1;
	    }

	    var period = Math.PI;
	    // Guarantee b > 0
	    if (angularFrequency < 0) {
	        angularFrequency *= -1;
	        phase *= -1;
	        phase += period / 2;
	    }

	    // Guarantee c is smallest possible positive value
	    while (phase > 0) {
	        phase -= period;
	    }
	    while (phase < 0) {
	        phase += period;
	    }

	    return [amplitude, angularFrequency, phase, verticalOffset];
	}

	/* Styles */
	var typeSelectorStyle = {
	    padding: "5px 5px"
	};

	/* Graphing interface. */
	var FunctionGrapher = React.createClass({displayName: 'FunctionGrapher',
	    mixins: [Changeable],

	    _coords: function(props) {
	        // Coords are usually based on props, but should fall back to the
	        // model's default whenever they're not provided (if there's a model)
	        props = props || this.props;
	        var defaultModelCoords = props.model && props.model.defaultCoords &&
	            Grapher.pointsFromNormalized(props.graph.range, props.graph.step,
	                props.graph.snapStep, props.model.defaultCoords);
	        return props.coords || defaultModelCoords || null;
	    },

	    _asymptote: function(props) {
	        // Coords are usually based on props, but should fall back to the
	        // model's default whenever they're not provided (if there's a model)
	        props = props || this.props;
	        var defaultModelAsymptote = props.model &&
	            props.model.defaultAsymptote &&
	            Grapher.pointsFromNormalized(props.graph.range, props.graph.step,
	                props.graph.snapStep, props.model.defaultAsymptote);
	        return props.asymptote || defaultModelAsymptote || null;
	    },

	    getDefaultProps: function() {
	        return {
	            graph: {
	                range: [[-10, 10], [-10, 10]],
	                step: [1, 1]
	            },
	            coords: null,
	            asymptote: null
	        };
	    },

	    render: function() {
	        var pointForCoord = function(coord, i)  {
	            return React.createElement(MovablePoint, {
	                key: i, 
	                coord: coord, 
	                constraints: [
	                    Interactive2.MovablePoint.constraints.bound(),
	                    Interactive2.MovablePoint.constraints.snap(),
	                    function(coord)  {
	                        // Always enforce that this is a function
	                        var isFunction = _.all(this._coords(),
	                            function(otherCoord, j)  {
	                                return i === j  || !otherCoord ||
	                                    !knumber.equal(coord[0], otherCoord[0]);
	                            });

	                        // Evaluate this criteria before per-point constraints
	                        if (!isFunction) {
	                            return false;
	                        }

	                        // Specific functions have extra per-point constraints
	                        if (this.props.model &&
	                                this.props.model.extraCoordConstraint) {
	                            var extraConstraint =
	                                this.props.model.extraCoordConstraint;
	                            // Calculat resulting coords and verify that
	                            // they're valid for this graph
	                            var proposedCoords = _.clone(this._coords());
	                            var oldCoord = _.clone(proposedCoords[i]);
	                            proposedCoords[i] = coord;
	                            return extraConstraint(coord, oldCoord,
	                                proposedCoords, this._asymptote(),
	                                this.props.graph);
	                        }

	                        return isFunction;
	                    }.bind(this)
	                ], 
	                onMove: function(newCoord, oldCoord)  {
	                    var coords;
	                    // Reflect over asymptote, if allowed
	                    var asymptote = this._asymptote();
	                    if (asymptote &&
	                            this.props.model.allowReflectOverAsymptote &&
	                            isFlipped(newCoord, oldCoord, asymptote)) {
	                        coords = _.map(this._coords(), function(coord)  {
	                            return kpoint.reflectOverLine(coord, asymptote);
	                        });
	                    } else {
	                        coords = _.clone(this._coords());
	                    }
	                    coords[i] = newCoord;
	                    this.props.onChange({
	                        coords: coords
	                    });
	                }.bind(this)});
	        }.bind(this);
	        var points = _.map(this._coords(), pointForCoord);
	        var box = this.props.graph.box;

	        var imageDescription = this.props.graph.backgroundImage;
	        var image = null;
	        if (imageDescription.url) {
	            var scale = box[0] / defaultBoxSize;
	            image = React.createElement(SvgImage, {src: imageDescription.url, 
	                              width: imageDescription.width, 
	                              height: imageDescription.height, 
	                              scale: scale});
	        }

	        return React.createElement("div", {
	                    className: "perseus-widget " + "perseus-widget-grapher", 
	                    style: {
	                        width: box[0],
	                        height: this.props.flexibleType ? "auto" : box[1]
	                    }}, 
	                React.createElement("div", {
	                    className: "graphie-container above-scratchpad", 
	                    style: {
	                        width: box[0],
	                        height: box[1]
	                    }}, 
	                image, 
	                React.createElement(Graphie, React.__spread({},  this.props.graph), 
	                    this.props.model && this.renderPlot(), 
	                    this.props.model && this.renderAsymptote(), 
	                    this.props.model && points
	                )
	            )
	        );
	    },

	    renderPlot: function() {
	        var model = this.props.model;
	        var xRange = this.props.graph.range[0];
	        var style = { stroke: KhanUtil.DYNAMIC };

	        var coeffs = model.getCoefficients(this._coords(), this._asymptote());
	        if (!coeffs) {
	            return;
	        }

	        var functionProps = model.getPropsForCoeffs(coeffs, xRange);
	        return React.createElement(model.Movable, React.__spread({}, 
	                    functionProps, 
	                    {key: this.props.model.url, 
	                    range: xRange, 
	                    style: style}));
	    },

	    renderAsymptote: function() {
	        var model = this.props.model;
	        var graph = this.props.graph;
	        var asymptote = this._asymptote();
	        var dashed = {
	            strokeDasharray: "- "
	        };
	        return asymptote &&
	            React.createElement(MovableLine, {onMove: function(newCoord, oldCoord)  {
	                // Calculate and apply displacement
	                var delta = kvector.subtract(newCoord, oldCoord);
	                var newAsymptote = _.map(this._asymptote(), function(coord) 
	                    {return kvector.add(coord, delta);});
	                this.props.onChange({
	                    asymptote: newAsymptote
	                });
	            }.bind(this), constraints: [
	                Interactive2.MovableLine.constraints.bound(),
	                Interactive2.MovableLine.constraints.snap(),
	                function(newCoord, oldCoord)  {
	                    // Calculate and apply proposed displacement
	                    var delta = kvector.subtract(newCoord, oldCoord);
	                    var proposedAsymptote = _.map(this._asymptote(), function(coord) 
	                        {return kvector.add(coord, delta);});
	                    // Verify that resulting asymptote is valid for graph
	                    if (model.extraAsymptoteConstraint) {
	                        return model.extraAsymptoteConstraint(newCoord,
	                            oldCoord, this._coords(), proposedAsymptote,
	                            graph);
	                    }
	                    return true;
	            }.bind(this)], normalStyle: dashed, 
	                highlightStyle: dashed}, 
	                _.map(asymptote, function(coord) 
	                    {return React.createElement(MovablePoint, {coord: coord, 
	                        static: true, 
	                        draw: null, 
	                        extendLine: true});}
	                )
	        );
	    }
	});

	var PlotDefaults = {
	    areEqual: function(coeffs1, coeffs2) {
	        return Util.deepEq(coeffs1, coeffs2);
	    },

	    Movable: Plot,

	    getPropsForCoeffs: function(coeffs) {
	        return {
	            fn: _.partial(this.getFunctionForCoeffs, coeffs)
	        };
	    }
	};

	var Linear = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/67aaf581e6d9ef9038c10558a1f70ac21c11c9f8.png",

	    defaultCoords: [[0.25, 0.75], [0.75, 0.75]],

	    getCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        var denom = p2[0] - p1[0];
	        var num = p2[1] - p1[1];

	        if (denom === 0) {
	            return;
	        }

	        var m = num / denom;
	        var b = p2[1] - m * p2[0];
	        return [m, b];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var m = coeffs[0], b = coeffs[1];
	        return m * x + b;
	    },

	    getEquationString: function(coords) {
	        var coeffs = this.getCoefficients(coords);
	        var m = coeffs[0], b = coeffs[1];
	        return "y = " + m.toFixed(3) + "x + " + b.toFixed(3);
	    }
	});

	var Quadratic = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/e23d36e6fc29ee37174e92c9daba2a66677128ab.png",

	    defaultCoords: [[0.5, 0.5], [0.75, 0.75]],

	    Movable: Graphie.Parabola,

	    getCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        // Parabola with vertex (h, k) has form: y = a * (h - k)^2 + k
	        var h = p1[0];
	        var k = p1[1];

	        // Use these to calculate familiar a, b, c
	        var a = (p2[1] - k) / ((p2[0] - h) * (p2[0] - h));
	        var b = - 2 * h * a;
	        var c = a * h * h + k;

	        return [a, b, c];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return (a * x + b) * x + c;
	    },

	    getPropsForCoeffs: function(coeffs) {
	        return {
	            a: coeffs[0],
	            b: coeffs[1],
	            c: coeffs[2]
	        };
	    },

	    getEquationString: function(coords) {
	        var coeffs = this.getCoefficients(coords);
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return "y = " + a.toFixed(3) + "x^2 + " + b.toFixed(3) +
	               "x + " + c.toFixed(3);
	    }
	});

	var Sinusoid = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/3d68e7718498475f53b206c2ab285626baf8857e.png",

	    defaultCoords: [[0.5, 0.5], [0.6, 0.6]],

	    Movable: Graphie.Sinusoid,

	    getCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        var a = (p2[1] - p1[1]);
	        var b = Math.PI / (2 * (p2[0] - p1[0]));
	        var c = p1[0] * b;
	        var d = p1[1];

	        return [a, b, c, d];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2], d = coeffs[3];
	        return a * Math.sin(b * x - c) + d;
	    },

	    getPropsForCoeffs: function(coeffs) {
	        return {
	            a: coeffs[0],
	            b: coeffs[1],
	            c: coeffs[2],
	            d: coeffs[3]
	        };
	    },

	    getEquationString: function(coords) {
	        var coeffs = this.getCoefficients(coords);
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2], d = coeffs[3];
	        return "y = " + a.toFixed(3) + " sin(" + b.toFixed(3) +
	               "x - " + c.toFixed(3) + ") + " + d.toFixed(3);
	    },

	    areEqual: function(coeffs1, coeffs2) {
	        return Util.deepEq(canonicalSineCoefficients(coeffs1),
	                canonicalSineCoefficients(coeffs2));
	    }
	});

	var Tangent = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/7db80d23c35214f98659fe1cf0765811c1bbfbba.png",

	    defaultCoords: [[0.5, 0.5], [0.75, 0.75]],

	    getCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        var a = (p2[1] - p1[1]);
	        var b = Math.PI / (4 * (p2[0] - p1[0]));
	        var c = p1[0] * b;
	        var d = p1[1];

	        return [a, b, c, d];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2], d = coeffs[3];
	        return a * Math.tan(b * x - c) + d;
	    },

	    getEquationString: function(coords) {
	        var coeffs = this.getCoefficients(coords);
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2], d = coeffs[3];
	        return "y = " + a.toFixed(3) + " sin(" + b.toFixed(3) +
	               "x - " + c.toFixed(3) + ") + " + d.toFixed(3);
	    },

	    areEqual: function(coeffs1, coeffs2) {
	        return Util.deepEq(canonicalTangentCoefficients(coeffs1),
	                canonicalTangentCoefficients(coeffs2));
	    }
	});

	var Exponential = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/9cbfad55525e3ce755a31a631b074670a5dad611.png",

	    defaultCoords: [[0.5, 0.55], [0.75, 0.75]],

	    defaultAsymptote: [[0, 0.5], [1.0, 0.5]],

	    /**
	     * Add extra constraints for movement of the points or asymptote (below):
	     *   newCoord: [x, y]
	     *     The end position of the point or asymptote endpoint
	     *   oldCoord: [x, y]
	     *     The old position of the point or asymptote endpoint
	     *   coords:
	     *     An array of coordinates representing the proposed end configuration
	     *     of the plot coordinates.
	     *   asymptote:
	     *     An array of coordinates representing the proposed end configuration
	     *     of the asymptote.
	     *
	     * Return: either a coordinate (to be used as the resulting coordinate of
	     * the move) or a boolean, where `true` uses newCoord as the resulting
	     * coordinate, and `false` uses oldCoord as the resulting coordinate.
	     */
	    extraCoordConstraint: function(newCoord, oldCoord, coords, asymptote,
	            graph) {
	        var y = _.head(asymptote)[1];
	        return _.all(coords, function(coord)  {return coord[1] !== y;});
	    },

	    extraAsymptoteConstraint: function(newCoord, oldCoord, coords, asymptote,
	            graph) {
	        var y = newCoord[1];
	        var isValid = _.all(coords, function(coord)  {return coord[1] > y;}) ||
	            _.all(coords, function(coord)  {return coord[1] < y;});

	        if (isValid) {
	            return [oldCoord[0], y];
	        } else {
	            // Snap the asymptote as close as possible, i.e., if the user moves
	            // the mouse really quickly into an invalid region
	            var oldY = oldCoord[1];
	            var wasBelow = _.all(coords, function(coord)  {return coord[1] > oldY;});
	            if (wasBelow) {
	                var bottomMost = _.min(_.map(coords, function(coord)  {return coord[1];}));
	                return [oldCoord[0], bottomMost - graph.snapStep[1]];
	            } else {
	                var topMost = _.max(_.map(coords, function(coord)  {return coord[1];}));
	                return [oldCoord[0], topMost + graph.snapStep[1]];
	            }
	        }
	    },

	    allowReflectOverAsymptote: true,

	    getCoefficients: function(coords, asymptote) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        var c = _.head(asymptote)[1];
	        var b = Math.log((p1[1] - c) / (p2[1] - c)) / (p1[0] - p2[0]);
	        var a = (p1[1] - c) / Math.exp(b * p1[0]);
	        return [a, b, c];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return a * Math.exp(b * x) + c;
	    },

	    getEquationString: function(coords, asymptote) {
	        if (!asymptote) {
	            return null;
	        }
	        var coeffs = this.getCoefficients(coords, asymptote);
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return "y = " + a.toFixed(3) + "e^(" + b.toFixed(3) + "x) + " +
	            c.toFixed(3);
	    }
	});

	var Logarithm = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/f6491e99d34af34d924bfe0231728ad912068dc3.png",

	    defaultCoords: [[0.55, 0.5], [0.75, 0.75]],

	    defaultAsymptote: [[0.5, 0], [0.5, 1.0]],

	    extraCoordConstraint: function(newCoord, oldCoord, coords, asymptote,
	            graph) {
	        var x = _.head(asymptote)[0];
	        return _.all(coords, function(coord)  {return coord[0] !== x;}) &&
	            coords[0][1] !== coords[1][1];
	    },

	    extraAsymptoteConstraint: function(newCoord, oldCoord, coords, asymptote,
	            graph) {
	        var x = newCoord[0];
	        var isValid = _.all(coords, function(coord)  {return coord[0] > x;}) ||
	            _.all(coords, function(coord)  {return coord[0] < x;});

	        if (isValid) {
	            return [x, oldCoord[1]];
	        } else {
	            // Snap the asymptote as close as possible, i.e., if the user moves
	            // the mouse really quickly into an invalid region
	            var oldX = oldCoord[0];
	            var wasLeft = _.all(coords, function(coord)  {return coord[0] > oldX;});
	            if (wasLeft) {
	                var leftMost = _.min(_.map(coords, function(coord)  {return coord[0];}));
	                return [leftMost - graph.snapStep[0], oldCoord[1]];
	            } else {
	                var rightMost = _.max(_.map(coords, function(coord)  {return coord[0];}));
	                return [rightMost + graph.snapStep[0], oldCoord[1]];
	            }
	        }
	    },

	    allowReflectOverAsymptote: true,

	    getCoefficients: function(coords, asymptote) {
	        // It's easiest to calculate the logarithm's coefficients by thinking
	        // about it as the inverse of the exponential, so we flip x and y and
	        // perform some algebra on the coefficients. This also unifies the
	        // logic between the two 'models'.
	        var flip = function(coord)  {return [coord[1], coord[0]];};
	        var inverseCoeffs = Exponential.getCoefficients(_.map(coords, flip),
	            _.map(asymptote, flip));
	        var c = - inverseCoeffs[2] / inverseCoeffs[0];
	        var b = 1 / inverseCoeffs[0];
	        var a = 1 / inverseCoeffs[1];
	        return [a, b, c];
	    },

	    getFunctionForCoeffs: function(coeffs, x, asymptote) {
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return a * Math.log(b * x + c);
	    },

	    getEquationString: function(coords, asymptote) {
	        if (!asymptote) {
	            return null;
	        }
	        var coeffs = this.getCoefficients(coords, asymptote);
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];
	        return "y = ln(" + a.toFixed(3) + "x + " + b.toFixed(3) + ") + " +
	            c.toFixed(3);
	    }
	});

	var AbsoluteValue = _.extend({}, PlotDefaults, {
	    url: "https://ka-perseus-graphie.s3.amazonaws.com/8256a630175a0cb1d11de223d6de0266daf98721.png",

	    defaultCoords: [[0.5, 0.5], [0.75, 0.75]],

	    getCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];

	        var denom = p2[0] - p1[0];
	        var num = p2[1] - p1[1];

	        if (denom === 0) {
	            return;
	        }

	        var m = Math.abs(num / denom);
	        if (p2[1] < p1[1]) {
	            m *= -1;
	        }
	        var horizontalOffset = p1[0];
	        var verticalOffset = p1[1];

	        return [m, horizontalOffset, verticalOffset];
	    },

	    getFunctionForCoeffs: function(coeffs, x) {
	        var m = coeffs[0],
	            horizontalOffset = coeffs[1],
	            verticalOffset = coeffs[2];
	        return m * Math.abs(x - horizontalOffset) + verticalOffset;
	    },

	    getEquationString: function(coords) {
	        var coeffs = this.getCoefficients(coords);
	        var m = coeffs[0],
	            horizontalOffset = coeffs[1],
	            verticalOffset = coeffs[2];
	        return "y = " + m.toFixed(3) + "| x - " +
	            horizontalOffset.toFixed(3) + "| + " +
	            verticalOffset.toFixed(3);
	    }
	});

	/* Utility functions for dealing with graphing interfaces. */
	var functionTypeMapping = {
	    "linear": Linear,
	    "quadratic": Quadratic,
	    "sinusoid": Sinusoid,
	    "tangent": Tangent,
	    "exponential": Exponential,
	    "logarithm": Logarithm,
	    "absolute_value": AbsoluteValue
	};

	var allTypes = _.keys(functionTypeMapping);

	function functionForType(type) {
	    return functionTypeMapping[type];
	}

	/* Widget and editor. */
	var Grapher = React.createClass({displayName: 'Grapher',
	    getDefaultProps: function() {
	        return {
	            plot: {
	                type: defaultType,
	                coords: null,
	                asymptote: null
	            },
	            graph: {
	                box: [defaultBoxSize, defaultBoxSize],
	                labels: ["x", "y"],
	                range: [[-10, 10], [-10, 10]],
	                step: [1, 1],
	                backgroundImage: defaultBackgroundImage,
	                markings: "graph",
	                rulerLabel: "",
	                rulerTicks: 10,
	                valid: true
	            },
	            availableTypes: [defaultType],
	        };
	    },

	    render: function() {
	        var type = this.props.plot.type;
	        var coords = this.props.plot.coords;
	        var asymptote = this.props.plot.asymptote;

	        var typeSelector = React.createElement("div", {style: typeSelectorStyle, 
	                className: "above-scratchpad"}, 
	            React.createElement(ButtonGroup, {
	                value: type, 
	                allowEmpty: true, 
	                buttons: _.map(this.props.availableTypes, typeToButton), 
	                onChange: this.handleActiveTypeChange})
	        );

	        var box = this.props.graph.box;

	        // Calculate additional graph properties so that the same values are
	        // passed in to both FunctionGrapher and Graphie.
	        var options = _.extend({}, this.props.graph,
	            this._getGridAndSnapSteps(this.props.graph));
	        _.extend(options, {
	            gridConfig: this._getGridConfig(options)
	        });

	        // The `graph` prop will eventually be passed to the <Graphie>
	        // component. In fact, if model is `null`, this is functionalliy
	        // identical to a <Graphie>. Otherwise, some points and a plot will be
	        // overlayed.
	        var grapherProps = {
	            graph: {
	                box: box,
	                range: options.range,
	                step: options.step,
	                snapStep: options.snapStep,
	                backgroundImage: options.backgroundImage,
	                options: options,
	                setup: this._setupGraphie
	            },
	            onChange: this.handlePlotChanges,
	            model: type && functionForType(type),
	            coords: coords,
	            asymptote: asymptote
	        };

	        return React.createElement("div", null, 
	            React.createElement(FunctionGrapher, React.__spread({},  grapherProps)), 
	            this.props.availableTypes.length > 1 && typeSelector
	        );
	    },

	    handlePlotChanges: function(newPlot) {
	        var plot = _.extend({}, this.props.plot, newPlot);
	        this.props.onChange({
	            plot: plot
	        });
	    },

	    handleActiveTypeChange: function(newType) {
	        var plot = _.extend({}, this.props.plot, {
	            type: newType,
	            coords: null,
	            asymptote: null
	        });
	        this.props.onChange({
	            plot: plot
	        });
	    },

	    _getGridAndSnapSteps: function(options) {
	        var gridStep = options.gridStep ||
	                Util.getGridStep(options.range, options.step, defaultBoxSize);
	        var snapStep = options.snapStep ||
	                Util.snapStepFromGridStep(gridStep);
	        return {
	            gridStep: gridStep,
	            snapStep: snapStep
	        };
	    },

	    _getGridConfig: function(options) {
	        return _.map(options.step, function(step, i) {
	            return Util.gridDimensionConfig(
	                    step,
	                    options.range[i],
	                    options.box[i],
	                    options.gridStep[i]);
	        });
	    },

	    _setupGraphie: function(graphie, options) {
	        if (options.markings === "graph") {
	            graphie.graphInit({
	                range: options.range,
	                scale: _.pluck(options.gridConfig, "scale"),
	                axisArrows: "<->",
	                labelFormat: function(s) { return "\\small{" + s + "}"; },
	                gridStep: options.gridStep,
	                snapStep: options.snapStep,
	                tickStep: _.pluck(options.gridConfig, "tickStep"),
	                labelStep: 1,
	                unityLabels: _.pluck(options.gridConfig, "unityLabel")
	            });
	            graphie.label([0, options.range[1][1]], options.labels[1],
	                "above");
	            graphie.label([options.range[0][1], 0], options.labels[0],
	                "right");
	        } else if (options.markings === "grid") {
	            graphie.graphInit({
	                range: options.range,
	                scale: _.pluck(options.gridConfig, "scale"),
	                gridStep: options.gridStep,
	                axes: false,
	                ticks: false,
	                labels: false
	            });
	        } else if (options.markings === "none") {
	            graphie.init({
	                range: options.range,
	                scale: _.pluck(options.gridConfig, "scale")
	            });
	        }
	    },

	    simpleValidate: function(rubric) {
	        return Grapher.validate(this.getUserInput(), rubric);
	    },

	    getUserInput: function() {
	        return this.props.plot;
	    },

	    focus: $.noop
	});

	_.extend(Grapher, {
	    validate: function(state, rubric) {
	        if (state.type !== rubric.correct.type) {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }

	        // We haven't moved the coords
	        if (state.coords == null) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        }

	        // Get new function handler for grading
	        var grader = functionForType(state.type);
	        var guessCoeffs = grader.getCoefficients(state.coords,
	            state.asymptote);
	        var correctCoeffs = grader.getCoefficients(rubric.correct.coords,
	            rubric.correct.asymptote);

	        if (guessCoeffs == null || correctCoeffs == null) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        }
	        else if (grader.areEqual(guessCoeffs, correctCoeffs)) {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    },

	    getEquationString: function(props) {
	        var plot = props.plot;
	        if (plot.type && plot.coords) {
	            var handler = functionForType(plot.type);
	            var result =
	                handler.getEquationString(plot.coords, plot.asymptote);
	            return result || "";
	        } else {
	            return "";
	        }
	    },

	    pointsFromNormalized: function(range, step, snapStep, coordsList) {
	        var numSteps = function(range, step) {
	            return Math.floor((range[1] - range[0]) / step);
	        };

	        return _.map(coordsList, function(coords) {
	            var unsnappedPoint = _.map(coords, function(coord, i) {
	                var currRange = range[i];
	                var currStep = step[i];
	                var nSteps = numSteps(currRange, currStep);
	                var tick = Math.round(coord * nSteps);
	                return currRange[0] + currStep * tick;
	            });
	            // In some graphing widgets, e.g. interactive-graph, you can rely
	            // on the Graphie to handle snapping. Here, we need the points
	            // returned to already be snapped so that the plot that goes
	            // through them is correct.
	            return kpoint.roundTo(unsnappedPoint, snapStep);
	        });
	    }
	});

	var GrapherEditor = React.createClass({displayName: 'GrapherEditor',
	    mixins: [Changeable],

	    getDefaultProps: function() {
	        return {
	            correct: {
	                type: defaultType,
	                coords: null,
	                asymptote: null
	            },
	            graph: {
	                labels: ["x", "y"],
	                range: [[-10, 10], [-10, 10]],
	                step: [1, 1],
	                backgroundImage: defaultBackgroundImage,
	                markings: "graph",
	                rulerLabel: "",
	                rulerTicks: 10,
	                valid: true
	            },
	            availableTypes: [defaultType]
	        };
	    },

	    render: function() {
	        var graph;
	        var equationString;
	        var graph = _.extend(this.props.graph, {
	            box: [defaultEditorBoxSize, defaultEditorBoxSize]
	        });

	        if (this.props.graph.valid === true) {
	            var graphProps = {
	                graph: this.props.graph,
	                plot: this.props.correct,
	                availableTypes: this.props.availableTypes,
	                onChange: function(newProps, cb)  {
	                    var correct = this.props.correct;
	                    if (correct.type === newProps.plot.type) {
	                        correct = _.extend({}, correct, newProps.plot);
	                    } else {
	                        // Clear options from previous graph
	                        correct = newProps.plot;
	                    }
	                    this.props.onChange({correct: correct}, cb);
	                }.bind(this)
	            };

	            graph = React.createElement(Grapher, React.__spread({},  graphProps));
	            equationString = Grapher.getEquationString(graphProps);
	        } else {
	            graph = React.createElement("div", {className: "perseus-error"}, 
	                        this.props.graph.valid
	                    );
	        }

	        return React.createElement("div", null, 
	            React.createElement("div", null, "Correct answer", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Graph the correct answer in the graph below and ensure" + ' ' +
	                    "the equation or point coordinates displayed represent the" + ' ' +
	                    "correct answer.")
	                ), 
	                ' ', ": ", equationString), 

	            React.createElement(GraphSettings, {
	                editableSettings: ["graph", "snap", "image"], 
	                box: this.props.graph.box, 
	                range: this.props.graph.range, 
	                labels: this.props.graph.labels, 
	                step: this.props.graph.step, 
	                gridStep: this.props.graph.gridStep, 
	                snapStep: this.props.graph.snapStep, 
	                valid: this.props.graph.valid, 
	                backgroundImage: this.props.graph.backgroundImage, 
	                markings: this.props.graph.markings, 
	                rulerLabel: this.props.graph.rulerLabel, 
	                rulerTicks: this.props.graph.rulerTicks, 
	                onChange: this.change("graph")}), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, "Available functions:", ' ', " "), 
	                React.createElement(MultiButtonGroup, {
	                    allowEmpty: false, 
	                    values: this.props.availableTypes, 
	                    buttons: _.map(allTypes, typeToButton), 
	                    onChange: this.handleAvailableTypesChange})
	            ), 
	            graph
	        );
	    },

	    handleAvailableTypesChange: function(newAvailableTypes) {
	        var correct = this.props.correct;

	        // If the currently 'correct' type is removed from the list of types,
	        // we need to change it to avoid impossible questions.
	        if (!_.contains(newAvailableTypes, this.props.correct.type)) {
	            var correct = {
	                type: _.first(newAvailableTypes),
	                coords: null,
	                asymptote: null
	            };
	        }
	        this.props.onChange({
	            availableTypes: newAvailableTypes,
	            correct: correct
	        });
	    },

	    serialize: function() {
	        return _.chain(this.props)
	                .pick("correct", "availableTypes")
	                .extend({ graph: _.omit(this.props.graph, "box") })
	                .value();
	    }
	});

	var propTransform = function(editorProps)  {
	    var widgetProps = _.pick(editorProps, "availableTypes");
	    widgetProps.graph = _.extend(editorProps.graph, {
	        box: [defaultBoxSize, defaultBoxSize]
	    });

	    // If there's only one type, the graph type is deterministic
	    if (widgetProps.availableTypes.length === 1) {
	        var plot = {
	            type: _.first(widgetProps.availableTypes),
	            coords: null,
	            asymptote: null
	        };
	        widgetProps.plot = plot;
	    }

	    return widgetProps;
	};

	module.exports = {
	    name: "grapher",
	    displayName: "Grapher",
	    widget: Grapher,
	    editor: GrapherEditor,
	    transform: propTransform
	};


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var Changeable   = __webpack_require__(77);
	var Editor = __webpack_require__(11);
	var Renderer = __webpack_require__(15);

	var Group = React.createClass({displayName: 'Group',
	    mixins: [Changeable],

	    propTypes: {
	        content: React.PropTypes.string,
	        widgets: React.PropTypes.object,
	        images: React.PropTypes.object,
	        icon: React.PropTypes.object,
	        reviewModeRubric: React.PropTypes.object,
	    },

	    getDefaultProps: function() {
	        return {
	            content: "",
	            widgets: {},
	            images: {},
	            icon: null
	        };
	    },

	    componentDidMount: function() {
	        // TODO(marcia): See comment in render method about our cyclical
	        // numbering scheme. We force another render so that we can annotate
	        // the group with the correct number.
	        this.forceUpdate();
	    },

	    render: function() {
	        var apiOptions = _.extend(
	            {},
	            ApiOptions.defaults,
	            this.props.apiOptions,
	            {
	                // Api Rewriting to support correct onFocus/onBlur
	                // events for the mobile API
	                onFocusChange: function(newFocus, oldFocus)  {
	                    if (oldFocus) {
	                        this.props.onBlur(oldFocus);
	                    }
	                    if (newFocus) {
	                        this.props.onFocus(newFocus);
	                    }
	                }.bind(this)
	            }
	        );

	        // Allow a problem number annotation to be added.
	        // This is cyclical and should probably be reconsidered. In order to
	        // render the annotation ("Question 3 of 10"), we call interWidgets to
	        // figure out our index in the list of all fellow group widgets. On
	        // first render, though, we don't exist yet in this list, and so we
	        // give ourselves number -1. To combat this, we forceUpdate in
	        // componentDidMount so that we can number ourselves properly. But,
	        // really we should have a more unidirectional flow. TODO(marcia): fix.
	        var number = _.indexOf(this.props.interWidgets("group"), this);
	        var problemNumComponent = this.props.apiOptions.groupAnnotator(
	            number, this.props.widgetId);

	        // This is a little strange because the id of the widget that actually
	        // changed is going to be lost in favor of the group widget's id. The
	        // widgets prop also wasn't actually changed, and this only serves to
	        // alert our renderer (our parent) of the fact that some interaction
	        // has occurred.
	        var onInteractWithWidget = function(id)  {
	            if (this.refs.renderer) {
	                this.change("widgets", this.refs.renderer.props.widgets);
	            }
	        }.bind(this);

	        return React.createElement("div", {className: "perseus-group"}, 
	            problemNumComponent, 
	            React.createElement(Renderer, React.__spread({}, 
	                this.props, 
	                {ref: "renderer", 
	                apiOptions: apiOptions, 
	                interWidgets: this._interWidgets, 
	                reviewMode: !!this.props.reviewModeRubric, 
	                onInteractWithWidget: onInteractWithWidget})), 
	            this.props.icon && React.createElement("div", {className: "group-icon"}, 
	                this.props.icon
	            )
	        );
	    },

	    _interWidgets: function(filterCriterion, localResults) {
	        if (localResults.length) {
	            return localResults;
	        } else {
	            return this.props.interWidgets(filterCriterion);
	        }
	    },

	    getUserInput: function() {
	        return this.refs.renderer.getUserInput();
	    },

	    getSerializedState: function() {
	        return this.refs.renderer.getSerializedState();
	    },

	    restoreSerializedState: function(state, callback) {
	        this.refs.renderer.restoreSerializedState(state, callback);
	        // Tell our renderer that we have no props to change
	        // (all our changes were in state):
	        return null;
	    },

	    simpleValidate: function(rubric) {
	        return this.refs.renderer.score();
	    },

	    // Mobile API:
	    getInputPaths: function() {
	        return this.refs.renderer.getInputPaths();
	    },

	    setInputValue: function(path, newValue, cb) {
	        return this.refs.renderer.setInputValue(path, newValue, cb);
	    },

	    getAcceptableFormatsForInputPath: function(path) {
	        return this.refs.renderer.getAcceptableFormatsForInputPath(path);
	    },

	    /**
	     * WARNING: This is an experimental/temporary API and should not be relied
	     *     upon in production code. This function may change its behavior or
	     *     disappear without notice.
	     *
	     * This function was created to allow Renderer.getAllWidgetIds to descend
	     * into our renderer.
	     */
	    getRenderer: function() {
	        return this.refs.renderer;
	    },

	    focus: function(path) {
	        if (path == null) {
	            return this.refs.renderer.focus();
	        } else {
	            this.refs.renderer.focusPath(path);
	        }
	    },

	    blur: function(path) {
	        this.refs.renderer.blurPath(path);
	    }
	});

	var GroupEditor = React.createClass({displayName: 'GroupEditor',
	    mixins: [Changeable],

	    propTypes: {
	        content: React.PropTypes.string,
	        widgets: React.PropTypes.object,
	        images: React.PropTypes.object,
	        metadata: React.PropTypes.any,
	        apiOptions: ApiOptions.propTypes,
	    },

	    getDefaultProps: function() {
	        return {
	            content: "",
	            widgets: {},
	            images: {},
	            // `undefined` instead of `null` so that getDefaultProps works for
	            // `the GroupMetadataEditor`
	            metadata: undefined
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-group-editor"}, 
	            React.createElement("div", null, 
	                /* the metadata editor; used for tags on khanacademy.org */
	                this._renderMetadataEditor()
	            ), 
	            React.createElement(Editor, {
	                ref: "editor", 
	                content: this.props.content, 
	                widgets: this.props.widgets, 
	                apiOptions: this.props.apiOptions, 
	                images: this.props.images, 
	                widgetEnabled: true, 
	                immutableWidgets: false, 
	                onChange: this.props.onChange})
	        );
	    },

	    _renderMetadataEditor: function() {
	        var GroupMetadataEditor = this.props.apiOptions.GroupMetadataEditor;
	        return React.createElement(GroupMetadataEditor, {
	            value: this.props.metadata, 
	            onChange: this.change("metadata")});
	    },

	    getSaveWarnings: function() {
	        return this.refs.editor.getSaveWarnings();
	    },

	    serialize: function() {
	        return _.extend({}, this.refs.editor.serialize(), {
	            metadata: this.props.metadata
	        });
	    },
	});

	var traverseChildWidgets = function(
	        props,
	        traverseRenderer) {

	    return _.extend({}, props, traverseRenderer(props));
	};

	module.exports = {
	    name: "group",
	    displayName: "Group",
	    widget: Group,
	    editor: GroupEditor,
	    traverseChildWidgets: traverseChildWidgets,
	    hidden: false,
	};



/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * This is an iframe widget. It is used for rendering an iframe that
	 *  then communicates its state via window.postMessage
	 * This is useful for embedding arbitrary visualizations/simulations with
	 *  completed conditions, such as the mazes and games in Algorithms.
	 * It's particularly well suited for embedding our ProcessingJS programs,
	 *  but could also be used for embedding viz's hosted elsewhere.
	 */

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var BlurInput    = __webpack_require__(91);
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var PropCheckBox  = __webpack_require__(65);
	var WidgetJsonifyDeprecated = __webpack_require__(78);
	var updateQueryString = __webpack_require__(5).updateQueryString;


	/* This renders the iframe and handles validation via window.postMessage */
	var Iframe = React.createClass({displayName: 'Iframe',

	    mixins: [Changeable, WidgetJsonifyDeprecated],

	    propTypes: {
	        width: React.PropTypes.string,
	        height: React.PropTypes.string,
	        url: React.PropTypes.string,
	        settings: React.PropTypes.array,
	        status: React.PropTypes.oneOf(['incomplete', 'incorrect', 'correct']),
	        message: React.PropTypes.string,
	        allowFullScreen: React.PropTypes.bool,
	    },

	    getDefaultProps: function() {
	        return {
	            status: "incomplete",
	            // optional message
	            message: null,
	            allowFullScreen: false,
	        };
	    },
	    handleMessageEvent: function(e) {
	        // We receive data from the iframe that contains {passed: true/false}
	        //  and use that to set the status
	        // It could also contain an optional message
	        var data = {};
	        try {
	            data = JSON.parse(e.originalEvent.data);
	        } catch (err) {
	            return;
	        }

	        if (_.isUndefined(data.testsPassed)) {
	            return;
	        }

	        var status = (data.testsPassed ? "correct" : "incorrect");
	        this.change({
	            status: status,
	            message: data.message
	        });
	    },
	    componentDidMount: function() {
	        $(window).on("message", this.handleMessageEvent);
	    },

	    componentWillUnmount: function() {
	        $(window).off("message", this.handleMessageEvent);
	    },

	    render: function() {
	        var style = {
	            width: this.props.width,
	            height: this.props.height
	        };
	        var url = this.props.url;

	        // If the URL doesnt start with http, it must be a program ID
	        if (url && url.length && url.indexOf("http") !== 0) {
	            url = "https://www.khanacademy.org/computer-programming/program/" + url +
	                    "/embedded?buttons=no&embed=yes&editor=no&author=no";
	            url = updateQueryString(url, "width", this.props.width);
	            url = updateQueryString(url, "height", this.props.height);
	            // Origin is used by output.js in deciding to send messages
	            url = updateQueryString(url, "origin", window.location.origin);
	        }

	        // Turn array of [{name: "", value: ""}] into object
	        if (this.props.settings) {
	            var settings = {};
	            _.each(this.props.settings, function(setting) {
	                if (setting.name && setting.value) {
	                    settings[setting.name] = setting.value;
	                }
	            });
	            // This becomes available to programs as Program.settings()
	            url = updateQueryString(url, "settings", JSON.stringify(settings));
	        }

	        // We sandbox the iframe so that we whitelist only the functionality
	        //  that we need. This makes it a bit safer in case some content
	        //  creator "went wild".
	        // http://www.html5rocks.com/en/tutorials/security/sandboxed-iframes/
	        return React.createElement("iframe", {sandbox: "allow-same-origin allow-scripts", 
	                       style: style, src: url, 
	                       allowFullScreen: this.props.allowFullScreen});
	    },

	    simpleValidate: function(rubric) {
	        return Iframe.validate(this.getUserInput(), rubric);
	    }
	});


	/**
	 * This is the widget's grading function
	 */
	_.extend(Iframe, {
	    validate: function(state, rubric) {
	        // The iframe can tell us whether it's correct or incorrect,
	        //  and pass an optional message
	        if (state.status === "correct") {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: state.message || null
	            };
	        } else if (state.status === "incorrect") {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: state.message || null
	            };
	        } else {
	            return {
	                type: "invalid",
	                message: "Keep going, you're not there yet!"
	            };
	        }
	    }
	});


	/**
	 * This is used for editing a name/value pair.
	 */
	var PairEditor = React.createClass({displayName: 'PairEditor',

	    mixins: [Changeable, EditorJsonify],

	    propTypes: {
	        name: React.PropTypes.string,
	        value: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            name:  "",
	            value: ""
	        };
	    },

	    render: function() {
	        return React.createElement("fieldset", null, 
	                React.createElement("label", null, "Name:", 
	                    React.createElement(BlurInput, {value: this.props.name, 
	                           onChange: this.change("name")})
	                ), 
	                React.createElement("label", null, "Value:", 
	                    React.createElement(BlurInput, {value: this.props.value, 
	                           onChange: this.change("value")})
	                )
	            );
	    }
	});

	/**
	 * This is used for editing a set of name/value pairs.
	 */
	var PairsEditor = React.createClass({displayName: 'PairsEditor',

	    mixins: [Changeable, EditorJsonify],

	    propTypes: {
	        pairs: React.PropTypes.arrayOf(React.PropTypes.shape({
	            name: React.PropTypes.string,
	            value: React.PropTypes.string
	        })).isRequired
	    },

	    render: function() {
	        var editors = _.map(this.props.pairs, function(pair, i)  {
	            return React.createElement(PairEditor, {key: i, name: pair.name, value: pair.value, 
	                     onChange: this.handlePairChange.bind(this, i)});
	        }.bind(this));
	        return React.createElement("div", null, 
	            editors
	            );
	    },

	    handlePairChange: function(pairIndex, pair) {
	        // If they're both non empty, add a new one
	        var pairs = this.props.pairs.slice();
	        pairs[pairIndex] = pair;

	        var lastPair = pairs[pairs.length-1];
	        if (lastPair.name && lastPair.value) {
	            pairs.push({name: "", value: ""});
	        }
	        this.change("pairs", pairs);
	    }
	});

	/**
	 * This is the main editor for this widget, to specify all the options.
	 */
	var IframeEditor = React.createClass({displayName: 'IframeEditor',

	    mixins: [Changeable, EditorJsonify],

	    getDefaultProps: function() {
	        return {
	            url: "",
	            settings: [{name: "", value: ""}],
	            width: 400,
	            height: 400,
	            allowFullScreen: false,
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("label", null, "Url or Program ID:", 
	                React.createElement(BlurInput, {name: "url", 
	                           value: this.props.url, 
	                           onChange: this.change("url")})
	            ), 
	            React.createElement("br", null), 
	            React.createElement("label", null, "Settings:", 
	                React.createElement(PairsEditor, {name: "settings", 
	                           pairs: this.props.settings, 
	                           onChange: this.handleSettingsChange})
	            ), 
	            React.createElement("br", null), 
	            React.createElement("label", null, "Width:", 
	                React.createElement(BlurInput, {name: "width", 
	                           value: this.props.width, 
	                           onChange: this.change("width")})
	            ), 
	            React.createElement("label", null, "Height:", 
	                React.createElement(BlurInput, {name: "height", 
	                           value: this.props.height, 
	                           onChange: this.change("height")})
	            ), 
	            React.createElement(PropCheckBox, {label: "Allow full screen", 
	                allowFullScreen: this.props.allowFullScreen, 
	                onChange: this.props.onChange})
	        );
	    },

	    handleSettingsChange: function(settings) {
	        this.change({settings: settings.pairs});
	    }
	});


	module.exports = {
	    name: "iframe",
	    displayName: "Iframe",
	    widget: Iframe,
	    // Let's not expose it to all content creators yet
	    hidden: true,
	    editor: IframeEditor
	};


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);
	var Util = __webpack_require__(5);

	var BlurInput    = __webpack_require__(91);
	var Editor       = __webpack_require__(11);
	var InfoTip      = __webpack_require__(75);
	var Renderer     = __webpack_require__(15);

	var Changeable    = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var Graphie      = __webpack_require__(80);
	var RangeInput   = __webpack_require__(92);
	var SvgImage     = __webpack_require__(64);

	var defaultBoxSize = 400;
	var defaultRange = [0, 10];
	var defaultBackgroundImage = {
	    url: null,
	    width: 0,
	    height: 0
	};

	/**
	 * Alignment option for captions, relative to specified coordinates.
	 */
	var captionAlignments = [
	    "center",
	    "above",
	    "above right",
	    "right",
	    "below right",
	    "below",
	    "below left",
	    "left",
	    "above left"
	];

	function blankLabel() {
	    return {
	        content: "",
	        coordinates: [0, 0],
	        alignment: "center"
	    };
	}

	var ImageWidget = React.createClass({displayName: 'ImageWidget',
	    mixins: [Changeable],

	    propTypes: {
	        title: React.PropTypes.string,
	        box: React.PropTypes.arrayOf(React.PropTypes.number),

	        // TODO(alex): Rename to something else, e.g. "image", perhaps flatten
	        backgroundImage: React.PropTypes.shape({
	            url: React.PropTypes.string,
	            width: React.PropTypes.number,
	            height: React.PropTypes.number
	        }),

	        // TODO(alex): Convert uses of this widget's labeling functionality to
	        // SvgImage wherever possible (almost certainly requires a backfill)
	        labels: React.PropTypes.arrayOf(
	            React.PropTypes.shape({
	                content: React.PropTypes.string,
	                coordinates: React.PropTypes.arrayOf(React.PropTypes.number),
	                alignment: React.PropTypes.string
	            })
	        ),
	        range: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(React.PropTypes.number)
	        ),

	        alt: React.PropTypes.string,
	        caption: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            title: "",
	            range: [defaultRange, defaultRange],
	            box: [defaultBoxSize, defaultBoxSize],
	            backgroundImage: defaultBackgroundImage,
	            labels: [],
	            alt: "",
	            caption: ""
	        };
	    },

	    render: function() {
	        var title;
	        var image;
	        var alt;
	        var caption;

	        if (this.props.title) {
	            title = React.createElement("div", {className: "perseus-image-title"}, 
	                React.createElement(Renderer, {
	                    content: this.props.title, 
	                    apiOptions: this.props.apiOptions})
	            );
	        }

	        var backgroundImage = this.props.backgroundImage;

	        if (backgroundImage.url) {
	            image = React.createElement(SvgImage, {
	                        src: backgroundImage.url, 
	                        alt: 
	                            /* alt text is formatted in a sr-only
	                               div next to the image, so we make
	                               this empty here.
	                               If there is no alt text at all,
	                               we don't put an alt attribute on
	                               the image, so that screen readers
	                               know there's something they can't
	                               read there :(.
	                               NOTE: React <=0.13 (maybe later)
	                               has a bug where it won't ever
	                               remove an attribute, so if this
	                               alt node is ever defined it's
	                               not removed. This is sort of
	                               dangerous, but we usually re-key
	                               new renderers so that they're
	                               rendered from scratch anyways,
	                               so this shouldn't be a problem
	                               in practice right now, although
	                               it will exhibit weird behaviour
	                               while editing. */
	                            this.props.alt ? "" : undefined, 
	                        
	                        width: backgroundImage.width, 
	                        height: backgroundImage.height, 
	                        extraGraphie: {
	                            box: this.props.box,
	                            range: this.props.range,
	                            labels: this.props.labels,
	                        }});
	        }

	        if (this.props.alt) {
	            alt = React.createElement("span", {className: "perseus-sr-only"}, 
	                React.createElement(Renderer, {
	                    content: this.props.alt, 
	                    apiOptions: this.props.apiOptions})
	            );
	        }

	        if (this.props.caption) {
	            caption = React.createElement("div", {className: "perseus-image-caption"}, 
	                React.createElement(Renderer, {content: this.props.caption})
	            );
	        }

	        return React.createElement("div", {className: "perseus-image-widget"}, 
	            title, 
	            image, 
	            alt, 
	            caption
	        );
	    },

	    getUserInput: function() {
	        return null;
	    },

	    simpleValidate: function(rubric) {
	        return ImageWidget.validate(this.getUserInput(), rubric);
	    },

	    focus: $.noop
	});

	_.extend(ImageWidget, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});

	var ImageEditor = React.createClass({displayName: 'ImageEditor',
	    mixins: [Changeable, EditorJsonify],

	    componentDidMount: function() {
	        // defer this because it can call a change handler synchronously
	        _.defer(function()  {
	            var url = this.props.backgroundImage.url;
	            this.onUrlChange(url, true);
	        }.bind(this));
	    },

	    getDefaultProps: function() {
	        return {
	            title: "",
	            range: [defaultRange, defaultRange],
	            box: [defaultBoxSize, defaultBoxSize],
	            backgroundImage: defaultBackgroundImage,
	            labels: [],
	            alt: "",
	            caption: "",
	        };
	    },

	    render: function() {
	        var backgroundImage = this.props.backgroundImage;

	        var imageSettings = React.createElement("div", {className: "image-settings"}, 
	            React.createElement("div", null, "Background image:"), 
	            React.createElement("div", null, 
	                React.createElement("label", null, "Url:", ' ', 
	                    React.createElement(BlurInput, {
	                        value: backgroundImage.url || '', 
	                        style: {width: 290}, 
	                        onChange: function(url)  {return this.onUrlChange(url, false);}.bind(this)}), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, "Create an image in graphie, or use the \"Add image\"" + ' ' +
	                        "function to create a background.")
	                    )
	                )
	            ), 
	            backgroundImage.url && React.createElement("div", null, 
	                React.createElement("div", null, 
	                    React.createElement("label", null, "Graphie X range:", ' ', 
	                        React.createElement(RangeInput, {
	                            value: this.props.range[0], 
	                            onChange: _.partial(this.onRangeChange, 0)})
	                    )
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("label", null, "Graphie Y range:", ' ', 
	                        React.createElement(RangeInput, {
	                            value: this.props.range[1], 
	                            onChange: _.partial(this.onRangeChange, 1)})
	                    )
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("label", null, 
	                        React.createElement("div", null, 
	                            "Alt text:", 
	                            React.createElement(InfoTip, null, 
	                                React.createElement("p", null, 
	                                    "Add alt text to the image." + ' ' +
	                                    "This is important for screenreaders." + ' ' +
	                                    "The content of this alt text will be" + ' ' +
	                                    "formatted as markdown (tables, emphasis," + ' ' +
	                                    "etc. are supported)."
	                                )
	                            )
	                        ), 
	                        React.createElement(Editor, {
	                            content: this.props.alt, 
	                            onChange: function(props)  {
	                                if (props.content != null) {
	                                    this.change("alt", props.content);
	                                }
	                            }.bind(this), 
	                            widgetEnabled: false})
	                    )
	                )
	            )
	        );

	        var graphSettings = React.createElement("div", {className: "graph-settings"}, 
	                React.createElement("div", {className: "add-label"}, 
	                    React.createElement("button", {onClick: this.addLabel}, 
	                        ' ', "Add a label", ' '
	                    )
	                ), 
	                this.props.labels.length > 0 &&
	                React.createElement("table", {className: "label-settings"}, 
	                    React.createElement("thead", null, 
	                    React.createElement("tr", null, 
	                        React.createElement("th", null, "Coordinates"), 
	                        React.createElement("th", null, "Content"), 
	                        React.createElement("th", null, "Alignment"), 
	                        React.createElement("th", null)
	                    )
	                    ), 
	                    React.createElement("tbody", null, 
	                        this.props.labels.map(this._renderRowForLabel)
	                    )
	                )
	        );

	        return React.createElement("div", {className: "perseus-image-editor"}, 
	            React.createElement("div", null, "Title:"), 
	            React.createElement(Editor, {
	                content: this.props.title, 
	                onChange: function(props)  {
	                    if (props.content != null) {
	                        this.change("title", props.content);
	                    }
	                }.bind(this), 
	                widgetEnabled: false}), 
	            imageSettings, 
	            graphSettings, 
	            React.createElement("div", null, "Caption:"), 
	            React.createElement(Editor, {
	                content: this.props.caption, 
	                onChange: function(props)  {
	                    if (props.content != null) {
	                        this.change("caption", props.content);
	                    }
	                }.bind(this), 
	                widgetEnabled: false})
	        );
	    },

	    _renderRowForLabel: function(label, i) {
	        return React.createElement("tr", {key: i}, 
	            React.createElement("td", null, 
	                React.createElement(RangeInput, {
	                    value: label.coordinates, 
	                    onChange: this.onCoordinateChange.bind(this, i)})
	            ), 
	            React.createElement("td", {style: {verticalAlign: "bottom", width: "5px"}}, 
	                React.createElement("input", {
	                    type: "text", 
	                    className: "graph-settings-axis-label", 
	                    value: label.content, 
	                    onChange: this.onContentChange.bind(this, i)})
	            ), 
	            React.createElement("td", null, 
	                React.createElement("select", {
	                    className: "perseus-widget-dropdown", 
	                    value: label.alignment, 
	                    onChange: this.onAlignmentChange.bind(this, i)}, 
	                    captionAlignments.map(function(alignment, i) {
	                        return React.createElement("option", {key: "" + i, value: alignment}, 
	                            alignment
	                        );
	                    }, this)
	                )
	            ), 
	            React.createElement("td", null, 
	                React.createElement("a", {
	                    href: "#", 
	                    className: "simple-button orange delete-label", 
	                    title: "Remove this label", 
	                    onClick: this.removeLabel.bind(this, i)}, 
	                    React.createElement("span", {className: "icon-trash"})
	                )
	            )
	        );
	    },

	    addLabel: function(e) {
	        e.preventDefault();
	        var labels = this.props.labels.slice();
	        var label = blankLabel();
	        labels.push(label);
	        this.props.onChange({
	            labels: labels,
	        });
	    },

	    removeLabel: function(labelIndex, e) {
	        e.preventDefault();
	        var labels = _(this.props.labels).clone();
	        labels.splice(labelIndex, 1);
	        this.props.onChange({labels: labels});
	    },

	    onCoordinateChange: function(labelIndex, newCoordinates) {
	        var labels = this.props.labels.slice();
	        labels[labelIndex] = _.extend({}, labels[labelIndex], {
	            coordinates: newCoordinates
	        });
	        this.props.onChange({labels: labels});
	    },

	    onContentChange: function(labelIndex, e) {
	        var newContent = e.target.value;
	        var labels = this.props.labels.slice();
	        labels[labelIndex] = _.extend({}, labels[labelIndex], {
	            content: newContent
	        });
	        this.props.onChange({labels: labels});
	    },

	    onAlignmentChange: function(labelIndex, e) {
	        var newAlignment = e.target.value;
	        var labels = this.props.labels.slice();
	        labels[labelIndex] = _.extend({}, labels[labelIndex], {
	            alignment: newAlignment
	        });
	        this.props.onChange({labels: labels});
	    },

	    setUrl: function(url, width, height, silent) {
	        // Because this calls into WidgetEditor._handleWidgetChange, which
	        // checks for this widget's ref to serialize it.
	        //
	        // Errors if you switch items before the `Image` from `onUrlChange`
	        // loads.
	        if (!this.isMounted()) {
	            return;
	        }

	        var image = _.clone(this.props.backgroundImage);
	        image.url = url;
	        image.width = width;
	        image.height = height;
	        var box = [image.width, image.height];
	        this.props.onChange({
	                backgroundImage: image,
	                box: box,
	            },
	            null,
	            silent
	        );
	    },

	    // silently load the image when the component mounts
	    // silently update url and sizes when the image loads
	    // noisily load the image in response to the author changing it
	    onUrlChange: function(url, silent) {
	        // We update our background image prop after the image loads below. To
	        // avoid weirdness when we change to a very slow URL, then a much
	        // faster URL, we keep track of the URL we're trying to change to.
	        this._leadingUrl = url;

	        if (!url) {
	            this.setUrl(url, 0, 0, silent);
	            return;
	        }

	        Util.getImageSize(
	            url,
	            function(width, height)  {
	                if (this._leadingUrl !== url) {
	                    return;
	                }

	                this.setUrl(url, width, height, true);
	            }.bind(this));
	    },

	    onRangeChange: function(type, newRange) {
	        var range = this.props.range.slice();
	        range[type] = newRange;
	        this.props.onChange({range: range});
	    },

	    getSaveWarnings: function() {
	        var warnings = [];

	        if (this.props.backgroundImage.url && !this.props.alt) {
	            warnings.push("No alt text");
	        }

	        return warnings;
	    },
	});

	module.exports = {
	    name: "image",
	    // This widget's accessibility depends on its contents: if the image has
	    // has a background but no alt text, it is not accessible
	    accessible: function(props)  {
	        var bgImage = props.backgroundImage;
	        return !(bgImage && bgImage.url && !props.alt);
	    },
	    supportedAlignments: ["block", "float-left", "float-right"],
	    displayName: "Image",
	    widget: ImageWidget,
	    editor: ImageEditor
	};


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var BlurInput         = __webpack_require__(91);
	var InfoTip           = __webpack_require__(75);
	var InputWithExamples = __webpack_require__(84);
	var ParseTex          = __webpack_require__(93).parseTex;

	var ApiClassNames = __webpack_require__(17).ClassNames;
	var ApiOptions = __webpack_require__(17).Options;
	var Util = __webpack_require__(5);
	var EnabledFeatures = __webpack_require__(56);

	var answerTypes = {
	    number: {
	        name: "Numbers",
	        forms: "integer, decimal, proper, improper, mixed"
	    },
	    decimal: {
	        name: "Decimals",
	        forms: "decimal"
	    },
	    integer: {
	        name: "Integers",
	        forms: "integer"
	    },
	    rational: {
	        name: "Fractions and mixed numbers",
	        forms: "integer, proper, improper, mixed"
	    },
	    improper: {
	        name: "Improper numbers (no mixed)",
	        forms: "integer, proper, improper"
	    },
	    mixed: {
	        name: "Mixed numbers (no improper)",
	        forms: "integer, proper, mixed"
	    },
	    percent: {
	        name: "Numbers or percents",
	        forms: "integer, decimal, proper, improper, mixed, percent"
	    },
	    pi: {
	        name: "Numbers with pi", forms: "pi"
	    }
	};

	var formExamples = {
	    "integer": function(options) { return $._("an integer, like $6$"); },
	    "proper": function(options) {
	        if (options.simplify === "optional") {
	            return $._("a *proper* fraction, like $1/2$ or $6/10$");
	        } else {
	            return $._("a *simplified proper* fraction, like $3/5$");
	        }
	    },
	    "improper": function(options) {
	        if (options.simplify === "optional") {
	            return $._("an *improper* fraction, like $10/7$ or $14/8$");
	        } else {
	            return $._("a *simplified improper* fraction, like $7/4$");
	        }
	    },
	    "mixed": function(options) {
	        return $._("a mixed number, like $1\\ 3/4$");
	    },
	    "decimal": function(options) {
	        return $._("an *exact* decimal, like $0.75$");
	    },
	    "percent": function(options) {
	        return $._("a percent, like $12.34\\%$");
	    },
	    "pi": function(options) {
	        return $._("a multiple of pi, like $12\\ \\text{pi}$ or " +
	                "$2/3\\ \\text{pi}$");
	    }
	};

	var InputNumber = React.createClass({displayName: 'InputNumber',
	    propTypes: {
	        currentValue: React.PropTypes.string,
	        enabledFeatures: EnabledFeatures.propTypes,
	        reviewModeRubric: React.PropTypes.object,
	    },

	    getDefaultProps: function() {
	        return {
	            currentValue: "",
	            size: "normal",
	            answerType: "number",
	            enabledFeatures: EnabledFeatures.defaults,
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    shouldShowExamples: function() {
	        return this.props.enabledFeatures.toolTipFormats &&
	                this.props.answerType !== "number" &&
	                !this.props.apiOptions.staticRender;
	    },

	    render: function() {
	        // HACK(johnsullivan): Create a function with shared logic between this
	        // and NumericInput.
	        var rubric = this.props.reviewModeRubric;
	        var correct = null;
	        var answerBlurb = null;
	        if (rubric) {
	            var score = this.simpleValidate(rubric);
	            correct = score.type === "points" &&
	                          score.earned === score.total;

	            if (!correct) {
	                // TODO(johnsullivan): Make this a little more human-friendly.
	                var answerString = String(rubric.value);
	                if (rubric.inexact && rubric.maxError) {
	                    answerString += " \u00B1 " + rubric.maxError;
	                }
	                answerBlurb = React.createElement("span", {className: "perseus-possible-answers"}, 
	                    React.createElement("span", {className: "perseus-possible-answer"}, 
	                        answerString
	                    )
	                );
	            }
	        }

	        var classes = {};
	        classes["perseus-input-size-" + this.props.size] = true;
	        classes[ApiClassNames.CORRECT] =
	            rubric && correct && this.props.currentValue;
	        classes[ApiClassNames.INCORRECT] =
	            rubric && !correct && this.props.currentValue;
	        classes[ApiClassNames.UNANSWERED] = rubric && !this.props.currentValue;

	        var input = React.createElement(InputWithExamples, {
	            ref: "input", 
	            value: this.props.currentValue, 
	            onChange: this.handleChange, 
	            className: classNames(classes), 
	            type: this._getInputType(), 
	            examples: this.examples(), 
	            shouldShowExamples: this.shouldShowExamples(), 
	            onFocus: this._handleFocus, 
	            onBlur: this._handleBlur});

	        if (answerBlurb) {
	            return React.createElement("span", {className: "perseus-input-with-answer-blurb"}, 
	                input, 
	                answerBlurb
	            );
	        } else {
	            return input;
	        }
	    },

	    handleChange: function(newValue) {
	        this.props.onChange({ currentValue: newValue });
	    },

	    _getInputType: function() {
	        if (this.props.apiOptions.staticRender) {
	            return "tex";
	        } else {
	            return "text";
	        }
	    },

	    _handleFocus: function() {
	        this.props.onFocus([]);
	    },

	    _handleBlur: function() {
	        this.props.onBlur([]);
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    focusInputPath: function(inputPath) {
	        this.refs.input.focus();
	    },

	    blurInputPath: function(inputPath) {
	        this.refs.input.blur();
	    },

	    getInputPaths: function() {
	        // The widget itself is an input, so we return a single empty list to
	        // indicate this.
	        return [[]];
	    },

	    getGrammarTypeForPath: function(path) {
	        return "number";
	    },

	    setInputValue: function(path, newValue, cb) {
	        this.props.onChange({
	            currentValue: newValue
	        }, cb);
	    },

	    getUserInput: function() {
	        return {
	            currentValue: this.props.currentValue
	        };
	    },

	    simpleValidate: function(rubric, onInputError) {
	        onInputError = onInputError || function() { };
	        return InputNumber.validate(
	            this.getUserInput(),
	            rubric,
	            onInputError
	        );
	    },

	    examples: function() {
	        var type = this.props.answerType;
	        var forms = answerTypes[type].forms.split(/\s*,\s*/);

	        var examples = _.map(forms, function(form) {
	            return formExamples[form](this.props);
	        }, this);

	        return [$._("**Acceptable Formats**")].concat(examples);
	    }
	});

	_.extend(InputNumber, {
	    validate: function(state, rubric, onInputError) {
	        if (rubric.answerType == null) {
	            rubric.answerType = "number";
	        }
	        var val = Khan.answerTypes.number.createValidatorFunctional(
	            rubric.value, {
	                simplify: rubric.simplify,
	                inexact: rubric.inexact || undefined,
	                maxError: rubric.maxError,
	                forms: answerTypes[rubric.answerType].forms
	            });

	        // We may have received TeX; try to parse it before grading.
	        // If `currentValue` is not TeX, this should be a no-op.
	        var currentValue = ParseTex(state.currentValue);

	        var result = val(currentValue);

	        // TODO(eater): Seems silly to translate result to this invalid/points
	        // thing and immediately translate it back in ItemRenderer.scoreInput()
	        if (result.empty) {
	            var apiResult = onInputError(
	                null, // reserved for some widget identifier
	                state.currentValue,
	                result.message
	            );
	            return {
	                type: "invalid",
	                message: (apiResult === false) ? null : result.message
	            };
	        } else {
	            return {
	                type: "points",
	                earned: result.correct ? 1 : 0,
	                total: 1,
	                message: result.message
	            };
	        }
	    }
	});

	var InputNumberEditor = React.createClass({displayName: 'InputNumberEditor',
	    propTypes: {
	        value: React.PropTypes.number,
	        simplify: React.PropTypes.oneOf(['required', 'optional', 'enforced']),
	        size: React.PropTypes.oneOf(['normal', 'small']),
	        inexact: React.PropTypes.bool,
	        maxError: React.PropTypes.number,
	        answerType: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            value: 0,
	            simplify: "required",
	            size: "normal",
	            inexact: false,
	            maxError: 0.1,
	            answerType: "number"
	        };
	    },

	    handleAnswerChange: function(str) {
	        var value = Util.firstNumericalParse(str) || 0;
	        this.props.onChange({value: value});
	    },

	    render: function() {
	        var answerTypeOptions = _.map(answerTypes, function(v, k) {
	            return React.createElement("option", {value: k, key: k}, v.name);
	        }, this);

	        return React.createElement("div", null, 
	            React.createElement("div", null, React.createElement("label", null, 
	                "Correct answer:", ' ', 
	                React.createElement(BlurInput, {value: "" + this.props.value, 
	                           onChange: this.handleAnswerChange, 
	                           ref: "input"})
	            )), 

	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Unsimplified answers", ' ', 
	                    React.createElement("select", {value: this.props.simplify, 
	                            onChange: function(e)  {
	                                this.props.onChange({simplify:
	                                e.target.value});
	                            }.bind(this)}, 
	                        React.createElement("option", {value: "required"}, "will not be graded"), 
	                        React.createElement("option", {value: "optional"}, "will be accepted"), 
	                        React.createElement("option", {value: "enforced"}, "will be marked wrong")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Normally select \"will not be graded\". This will give the" + ' ' +
	                    "user a message saying the answer is correct but not" + ' ' +
	                    "simplified. The user will then have to simplify it and" + ' ' +
	                    "re-enter, but will not be penalized. (5th grade and" + ' ' +
	                    "anything after)"), 
	                    React.createElement("p", null, "Select \"will be accepted\" only if the user is not" + ' ' +
	                    "expected to know how to simplify fractions yet. (Anything" + ' ' +
	                    "prior to 5th grade)"), 
	                    React.createElement("p", null, "Select \"will be marked wrong\" only if we are" + ' ' +
	                    "specifically assessing the ability to simplify.")
	                )
	            ), 

	            React.createElement("div", null, React.createElement("label", null, 
	                React.createElement("input", {type: "checkbox", 
	                    checked: this.props.inexact, 
	                    onChange: function(e)  {
	                        this.props.onChange({inexact: e.target.checked});
	                    }.bind(this)}), 
	                ' ', "Allow inexact answers"
	            ), 

	            React.createElement("label", null, 
	            React.createElement("input", {/* TODO(emily): don't use a hidden checkbox for alignment */
	                type: "checkbox", style: {visibility: "hidden"}}), 
	            "Max error:", ' ', 
	            React.createElement("input", {type: "text", disabled: !this.props.inexact, 
	                defaultValue: this.props.maxError, 
	                onBlur: function(e)  {
	                    var ans = "" + (Util.firstNumericalParse(
	                            e.target.value) || 0);
	                    e.target.value = ans;
	                    this.props.onChange({maxError: ans});
	                }.bind(this)})
	            )), 

	            React.createElement("div", null, 
	            "Answer type:", ' ', 
	            React.createElement("select", {
	                value: this.props.answerType, 
	                onChange: function(e)  {
	                    this.props.onChange({answerType: e.target.value});
	                }.bind(this)}, 
	                answerTypeOptions
	            ), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "Use the default \"Numbers\" unless the answer must be in a" + ' ' +
	                "specific form (e.g., question is about converting decimals to" + ' ' +
	                "fractions).")
	            )
	            ), 

	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Width", ' ', 
	                    React.createElement("select", {value: this.props.size, 
	                            onChange: function(e)  {
	                                this.props.onChange({size: e.target.value});
	                            }.bind(this)}, 
	                        React.createElement("option", {value: "normal"}, "Normal (80px)"), 
	                        React.createElement("option", {value: "small"}, "Small (40px)")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use size \"Normal\" for all text boxes, unless there are" + ' ' +
	                    "multiple text boxes in one line and the answer area is too" + ' ' +
	                    "narrow to fit them.")
	                )
	            )
	        );
	    },

	    focus: function() {
	        this.refs.input.getDOMNode().focus();
	        return true;
	    },

	    serialize: function() {
	        return _.pick(this.props,
	                "value", "simplify", "size", "inexact", "maxError",
	                "answerType");
	    }
	});

	var propTransform = function(editorProps)  {
	    return _.pick(editorProps, "simplify", "size", "answerType");
	};

	module.exports = {
	    name: "input-number",
	    displayName: "Number text box (old)",
	    defaultAlignment: "inline-block",
	    hidden: true,
	    widget: InputNumber,
	    editor: InputNumberEditor,
	    transform: propTransform
	};


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var ArrowPicker = __webpack_require__(105);
	var ColorPicker = __webpack_require__(106);
	var ConstraintEditor = __webpack_require__(107);
	var DashPicker = __webpack_require__(108);
	var ElementContainer = __webpack_require__(109);
	var Graphie = __webpack_require__(80);
	var GraphSettings = __webpack_require__(88);
	var MathInput = __webpack_require__(85);
	var NumberInput = __webpack_require__(94);
	var TeX = __webpack_require__(73);
	var TextInput = __webpack_require__(81);

	var Label = Graphie.Label;
	var Line = Graphie.Line;
	var MovablePoint = Graphie.MovablePoint;
	var MovableLine = Graphie.MovableLine;
	var Plot = Graphie.Plot;
	var PlotParametric = Graphie.PlotParametric;
	var Point = Graphie.Point;
	var Rect = Graphie.Rect;

	var kvector = __webpack_require__(113).vector;

	// Memoize KAS parsing
	var KAShashFunc = function(expr, options)  {
	    options = options || {};
	    var result = expr + "||" + options.decimal_separatpr + "||";
	    var functions = options.functions;
	    var functionsLength = functions ? functions.length : 0;
	    for (var i = 0; i < functionsLength; i++) {
	        result += functions[i] + "|";
	    }
	    return result;
	};

	var _parseCache = Object.create(null);
	var KASparse = function(expr, options)  {
	    var hash = KAShashFunc(expr, options);
	    var cached = _parseCache[hash];
	    if (cached) {
	        return cached;
	    }
	    cached = KAS.parse(expr, options);
	    _parseCache[hash] = cached;
	    return cached;
	};

	_compileCache = Object.create(null);
	var KAScompile = function(expr, options)  {
	    var hash = KAShashFunc(expr, options);
	    var cached = _compileCache[hash];
	    if (cached) {
	        return cached;
	    }
	    var parsed = KAS.parse(expr, options).expr;
	    cached = parsed ? parsed.compile() : function() { return 0; };
	    _compileCache[hash] = cached;
	    return cached;
	};

	var defaultInteractionProps = {
	    graph: {
	        box: [400, 400],
	        labels: ["x", "y"],
	        range: [[-10, 10], [-10, 10]],
	        tickStep: [1, 1],
	        gridStep: [1, 1],
	        markings: "graph",
	    },
	    elements: []
	};

	var Interaction = React.createClass({displayName: 'Interaction',
	    mixins: [Changeable],

	    // TODO(eater): Make more better
	    propTypes: {
	        graph: React.PropTypes.object,
	        elements: React.PropTypes.arrayOf(React.PropTypes.object)
	    },

	    getDefaultProps: function() {
	        return defaultInteractionProps;
	    },

	    getInitialState: function() {
	        return {
	            variables: this._getInitialVariables(this.props.elements),
	            functions: this._getInitialFunctions(this.props.elements)
	        };
	    },

	    _getInitialVariables: function(elements) {
	        var variables = {};
	        // TODO(eater): look at all this copypasta! refactor this!
	        _.each(_.where(elements, {type: "movable-point"}), function(element) {
	            var subscript = element.options.varSubscript;
	            var startXExpr = KASparse(element.options.startX || "0").expr;
	            var startYExpr = KASparse(element.options.startY || "0").expr;
	            var startX = 0;
	            var startY = 0;
	            if (startXExpr) {
	                startX = startXExpr.eval({}) || 0;
	            }
	            if (startYExpr) {
	                startY = startYExpr.eval({}) || 0;
	            }
	            variables["x_" + subscript] = startX;
	            variables["y_" + subscript] = startY;
	        }, this);
	        _.each(_.where(elements, {type: "movable-line"}), function(element) {
	            var startSubscript = element.options.startSubscript;
	            var endSubscript = element.options.endSubscript;
	            var startXExpr = KASparse(element.options.startX || "0").expr;
	            var startYExpr = KASparse(element.options.startY || "0").expr;
	            var endXExpr = KASparse(element.options.endX || "0").expr;
	            var endYExpr = KASparse(element.options.endY || "0").expr;
	            var startX = 0;
	            var startY = 0;
	            var endX = 0;
	            var endY = 0;
	            if (startXExpr) {
	                startX = startXExpr.eval({}) || 0;
	            }
	            if (startYExpr) {
	                startY = startYExpr.eval({}) || 0;
	            }
	            if (endXExpr) {
	                endX = endXExpr.eval({}) || 0;
	            }
	            if (endYExpr) {
	                endY = endYExpr.eval({}) || 0;
	            }
	            variables["x_" + startSubscript] = startX;
	            variables["y_" + startSubscript] = startY;
	            variables["x_" + endSubscript] = endX;
	            variables["y_" + endSubscript] = endY;
	        }, this);
	        _.each(_.where(elements, {type: "function"}), function(element) {
	            variables[element.options.funcName] = element.options.value;
	        });
	        return variables;
	    },

	    _getInitialFunctions: function(elements) {
	        return _.map(_.where(elements, {type: "function"}),
	            function(element)  {return element.options.funcName;});
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.setState({
	            variables: this._getInitialVariables(nextProps.elements),
	            functions: this._getInitialFunctions(nextProps.elements)
	        });
	    },

	    _setupGraphie: function(graphie, options) {
	        graphie.graphInit(_.extend({}, options, {
	            grid: _.contains(["graph", "grid"], this.props.graph.markings),
	            axes: _.contains(["graph"], this.props.graph.markings),
	            ticks: _.contains(["graph"], this.props.graph.markings),
	            labels: _.contains(["graph"], this.props.graph.markings),
	            labelFormat: function(s) { return "\\small{" + s + "}"; },
	            axisArrows: "<->",
	            unityLabels: false
	        }));
	        if (this.props.graph.markings === "graph") {
	            var labels = this.props.graph.labels;
	            var range = this.props.graph.range;
	            graphie.label([0, range[1][1]], labels[1], "above");
	            graphie.label([range[0][1], 0], labels[0], "right");
	        }

	    },

	    _updatePointLocation: function(subscript, coord) {
	        var variables = _.clone(this.state.variables);
	        variables["x_" + subscript] = coord[0];
	        variables["y_" + subscript] = coord[1];
	        this.setState({variables: variables});
	    },

	    _updateLineLocation: function(options, startCoord) {
	        var xDiff = this._eval("(" + options.endX +
	            ")-(" + options.startX + ")");
	        var yDiff = this._eval("(" + options.endY +
	            ")-(" + options.startY + ")");
	        var endCoord = kvector.add(startCoord, [xDiff, yDiff]);
	        var variables = _.clone(this.state.variables);
	        variables["x_" + options.startSubscript] = startCoord[0];
	        variables["y_" + options.startSubscript] = startCoord[1];
	        variables["x_" + options.endSubscript] = endCoord[0];
	        variables["y_" + options.endSubscript] = endCoord[1];
	        this.setState({variables: variables});
	    },

	    _eval: function(expression, variables) {
	        var func = KAScompile(expression,
	            {functions: this.state.functions});
	        var compiledVars = _.extend({}, this.state.variables, variables);
	        _.each(_.keys(compiledVars), function(name)  {
	            if (_.isString(compiledVars[name])) {
	                var func = KAScompile(compiledVars[name], {
	                    functions: this.state.functions
	                });
	                compiledVars[name] = function(x) {
	                    return func(_.extend({}, compiledVars, {
	                        x: x
	                    }));
	                };
	            }
	        }.bind(this));
	        val = func(compiledVars);
	        // Default to 0 if the expression couldn't be parsed
	        return val || 0;
	    },

	    // Return an array of all the variables in an expression
	    _extractVars: function(expr) {
	        if (expr == null) {
	            return [];
	        }
	        var vars = [];
	        _.each(expr.args(), function(arg) {
	            if (arg && arg.constructor.name === "Expr") {
	                vars = vars.concat(this._extractVars(arg));
	            }
	        }, this);

	        if (expr.name() === "Var") {
	            vars.push(expr.prettyPrint());
	        }
	        return vars;
	    },


	    render: function() {
	        return React.createElement(Graphie, {
	                box: this.props.graph.box, 
	                range: this.props.graph.range, 
	                options: this.props.graph, 
	                setup: this._setupGraphie}, 
	            _.map(this.props.elements, function(element, n) {
	                if (element.type === "point") {
	                    return React.createElement(Point, {
	                        key: element.key, 
	                        coord: [this._eval(element.options.coordX),
	                            this._eval(element.options.coordY)], 
	                        color: element.options.color});
	                } else if (element.type === "line") {
	                    var start = [this._eval(element.options.startX),
	                                 this._eval(element.options.startY)];
	                    var end = [this._eval(element.options.endX),
	                               this._eval(element.options.endY)];
	                    return React.createElement(Line, {
	                        key: element.key, 
	                        start: start, 
	                        end: end, 
	                        style: {
	                            stroke: element.options.color,
	                            strokeWidth: element.options.strokeWidth,
	                            strokeDasharray: element.options.strokeDasharray,
	                            arrows: element.options.arrows
	                        }});
	                } else if (element.type === "movable-point") {
	                    // TODO(eater): Would be nice if the constraint system
	                    // were more flexible.
	                    var constraints = [function(coord)  {
	                        var coordX =
	                            Math.max(this._eval(
	                                element.options.constraintXMin),
	                            Math.min(this._eval(
	                                element.options.constraintXMax),
	                            coord[0]));
	                        var coordY =
	                            Math.max(this._eval(
	                                element.options.constraintYMin),
	                            Math.min(this._eval(
	                                element.options.constraintYMax),
	                            coord[1]));
	                        return [coordX, coordY];
	                    }.bind(this)];
	                    if (element.options.constraint === "snap") {
	                        constraints.push(MovablePoint.constraints.snap(
	                            element.options.snap));
	                    } else if (element.options.constraint === "x") {
	                        constraints.push(function(coord)  {
	                            return [this._eval(
	                                element.options.constraintFn,
	                                {y: coord[1]}), coord[1]];
	                        }.bind(this));
	                    } else if (element.options.constraint === "y") {
	                        constraints.push(function(coord)  {
	                            return [coord[0], this._eval(
	                                element.options.constraintFn, {x: coord[0]})];
	                        }.bind(this));
	                    }

	                    // TODO(eater): foo_[xyz] are hacky non-props to get the
	                    // component to update when constraints change
	                    return React.createElement(MovablePoint, {
	                        key: element.key, 
	                        coord: [
	                            this.state.variables["x_" +
	                            element.options.varSubscript],
	                            this.state.variables["y_" +
	                            element.options.varSubscript]], 
	                        constraints: constraints, 
	                        foo_x: element.options.constraint, 
	                        foo_y: element.options.constraintFn, 
	                        foo_z: element.options.snap, 
	                        onMove: _.partial(this._updatePointLocation,
	                            element.options.varSubscript)}
	                        );
	                } else if (element.type === "movable-line") {
	                    // TODO(eater): Would be nice if the constraint system
	                    // were more flexible.
	                    // TODO(eater): Don't duplicate this code from
	                    // movable-point above
	                    var constraints = [function(coord)  {
	                        var coordX =
	                            Math.max(this._eval(
	                                element.options.constraintXMin),
	                            Math.min(this._eval(
	                                element.options.constraintXMax),
	                            coord[0]));
	                        var coordY =
	                            Math.max(this._eval(
	                                element.options.constraintYMin),
	                            Math.min(this._eval(
	                                element.options.constraintYMax),
	                            coord[1]));
	                        return [coordX, coordY];
	                    }.bind(this)];
	                    if (element.options.constraint === "snap") {
	                        constraints.push(MovablePoint.constraints.snap(
	                            element.options.snap));
	                    } else if (element.options.constraint === "x") {
	                        constraints.push(function(coord)  {
	                            return [this._eval(
	                                element.options.constraintFn,
	                                {y: coord[1]}), coord[1]];
	                        }.bind(this));
	                    } else if (element.options.constraint === "y") {
	                        constraints.push(function(coord)  {
	                            return [coord[0], this._eval(
	                                element.options.constraintFn,
	                                {x: coord[0]})];
	                        }.bind(this));
	                    }
	                    var start = [
	                            this.state.variables["x_" +
	                                element.options.startSubscript],
	                            this.state.variables["y_" +
	                                element.options.startSubscript]
	                        ];
	                    var end = [
	                            this.state.variables["x_" +
	                                element.options.endSubscript],
	                            this.state.variables["y_" +
	                                element.options.endSubscript]
	                        ];
	                    return React.createElement(MovableLine, {
	                        key: element.key, 
	                        constraints: constraints, 
	                        onMove: _.bind(this._updateLineLocation, this,
	                            element.options), 
	                        foo_x: element.options.constraint, 
	                        foo_y: element.options.constraintFn, 
	                        foo_z: element.options.snap}, 
	                            React.createElement(MovablePoint, {coord: start, 
	                                static: true, 
	                                normalStyle: {stroke: "none", fill: "none"}}), 
	                            React.createElement(MovablePoint, {coord: end, 
	                                static: true, 
	                                normalStyle: {stroke: "none", fill: "none"}})
	                        );
	                } else if (element.type === "function") {
	                    var fn = function(x)  {
	                        return this._eval(element.options.value, {x: x});
	                    }.bind(this);
	                    // find all the variables referenced by this function
	                    var vars = _.without(this._extractVars(
	                        KASparse(element.options.value).expr), "x");
	                    // and find their values, so we redraw if any change
	                    var varValues = _.object(vars,
	                        _.map(vars, function(v)  {return this.state.variables[v];}.bind(this)));

	                    var range=[this._eval(element.options.rangeMin,
	                        this.state.variables),
	                        this._eval(element.options.rangeMax,
	                        this.state.variables)];

	                    return React.createElement(Plot, {
	                        key: element.key, 
	                        fn: fn, 
	                        foo_fn: element.options.value, 
	                        foo_varvalues: varValues, 
	                        range: range, 
	                        style: {
	                            stroke: element.options.color,
	                            strokeWidth: element.options.strokeWidth,
	                            strokeDasharray: element.options.strokeDasharray,
	                            plotPoints: 100// TODO(eater): why so slow?
	                        }});
	                } else if (element.type === "parametric") {
	                    var fn = function(t)  {
	                        return [
	                            this._eval(element.options.x, {t: t}),
	                            this._eval(element.options.y, {t: t})];
	                    }.bind(this);
	                    // find all the variables referenced by this function
	                    var vars = _.without(this._extractVars(
	                        KASparse(element.options.x).expr).concat(
	                        this._extractVars(
	                        KASparse(element.options.y).expr)), "t");
	                    // and find their values, so we redraw if any change
	                    var varValues = _.object(vars,
	                        _.map(vars, function(v)  {return this.state.variables[v];}.bind(this)));

	                    var range = [this._eval(element.options.rangeMin,
	                        this.state.variables),
	                        this._eval(element.options.rangeMax,
	                        this.state.variables)];

	                    return React.createElement(PlotParametric, {
	                        key: element.key, 
	                        fn: fn, 
	                        foo_fnx: element.options.x, 
	                        foo_fny: element.options.y, 
	                        foo_varvalues: varValues, 
	                        range: range, 
	                        style: {
	                            stroke: element.options.color,
	                            strokeWidth: element.options.strokeWidth,
	                            strokeDasharray: element.options.strokeDasharray,
	                            plotPoints: 100// TODO(eater): why so slow?
	                        }});
	                } else if (element.type === "label") {
	                    var coord = [this._eval(element.options.coordX),
	                                 this._eval(element.options.coordY)];
	                    return React.createElement(Label, {
	                        key: n + 1, 
	                        coord: coord, 
	                        text: element.options.label, 
	                        style: {
	                            color: element.options.color
	                        }});
	                } else if (element.type === "rectangle") {
	                    return React.createElement(Rect, {
	                        key: n + 1, 
	                        x: this._eval(element.options.coordX), 
	                        y: this._eval(element.options.coordY), 
	                        width: _.max([this._eval(element.options.width), 0]), 
	                        height: _.max([this._eval(element.options.height), 0]), 
	                        style: {
	                            stroke: "none",
	                            fill: element.options.color
	                        }});
	                }
	            }, this)
	        );
	    },

	    getUserInput: function() {
	        // TODO(eater): Perhaps we want to be able to record the state of the
	        // user's interaction. Unfortunately sending all the props will
	        // probably make the attempt payload too large. So for now, don't send
	        // anything.
	        return {};
	    },

	    simpleValidate: function(rubric) {
	        return Interaction.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(Interaction, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});


	//
	// Editor for non-interactive points
	//
	// TODO(eater): Factor this out
	//
	var PointEditor = React.createClass({displayName: 'PointEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        coordX: React.PropTypes.string,
	        coordY: React.PropTypes.string,
	        color: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            coordX: "0",
	            coordY: "0",
	            color: KhanUtil.BLACK
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Coordinate: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordX, 
	                    onChange: this.change("coordX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordY, 
	                    onChange: this.change("coordY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    onChange: this.change("color")})
	            )
	        );
	    }
	});


	//
	// Editor for non-interactive line segments
	//
	// TODO(eater): Factor this out
	//
	var LineEditor = React.createClass({displayName: 'LineEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        startX: React.PropTypes.string,
	        startY: React.PropTypes.string,
	        endX: React.PropTypes.string,
	        endY: React.PropTypes.string,
	        color: React.PropTypes.string,
	        strokeDasharray: React.PropTypes.string,
	        arrows: React.PropTypes.string,
	        strokeWidth: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            startX: "-5",
	            startY: "5",
	            endX: "5",
	            endY: "5",
	            color: KhanUtil.BLACK,
	            strokeDasharray: "",
	            arrows: "",
	            strokeWidth: 2
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Start: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startX, 
	                    onChange: this.change("startX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startY, 
	                    onChange: this.change("startY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "End: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.endX, 
	                    onChange: this.change("endX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.endY, 
	                    onChange: this.change("endY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    onChange: this.change("color")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(DashPicker, {
	                    value: this.props.strokeDasharray, 
	                    onChange: this.change("strokeDasharray")}), 
	                "   ", 
	                React.createElement(ArrowPicker, {
	                    value: this.props.arrows, 
	                    onChange: this.change("arrows")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    "Width: ", React.createElement(NumberInput, {
	                        value: this.props.strokeWidth, 
	                        placeholder: 2, 
	                        onChange: this.change("strokeWidth")})
	                )
	            )
	        );
	    }
	});


	//
	// Editor for interactive movable points
	//
	// TODO(eater): Factor this out
	// TODO(eater): Rethink how constraints are represented
	//
	var MovablePointEditor = React.createClass({displayName: 'MovablePointEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        startX: React.PropTypes.string,
	        startY: React.PropTypes.string,
	        constraint: React.PropTypes.string,
	        snap: React.PropTypes.number,
	        constraintFn: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            startX: "0",
	            startY: "0",
	            constraint: "none",
	            snap: 0.5,
	            constraintFn: "0",
	            constraintXMin: "-10",
	            constraintXMax: "10",
	            constraintYMin: "-10",
	            constraintYMax: "10"
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Start: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startX, 
	                    onChange: this.change("startX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startY, 
	                    onChange: this.change("startY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Update ", React.createElement(TeX, null, "(x_n, y_n)"), " for ", React.createElement(TeX, null, "n ="), " ", React.createElement(NumberInput, {
	                    value: this.props.varSubscript, 
	                    placeholder: 0, 
	                    onChange: this.change("varSubscript")})
	            ), 
	            React.createElement(ConstraintEditor, React.__spread({},  this.props))
	        );
	    }
	});


	//
	// Editor for interactive movable line segments
	//
	// TODO(eater): Factor this out
	// TODO(eater): Rethink how constraints are represented
	//
	var MovableLineEditor = React.createClass({displayName: 'MovableLineEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        startX: React.PropTypes.string,
	        startY: React.PropTypes.string,
	        endX: React.PropTypes.string,
	        endY: React.PropTypes.string,
	        constraint: React.PropTypes.string,
	        snap: React.PropTypes.number,
	        constraintFn: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            startX: "-5",
	            startY: "5",
	            endX: "5",
	            endY: "5",
	            constraint: "none",
	            snap: 0.5,
	            constraintFn: "0",
	            constraintXMin: "-10",
	            constraintXMax: "10",
	            constraintYMin: "-10",
	            constraintYMax: "10"
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            "Initial position:", 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Start: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startX, 
	                    onChange: this.change("startX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.startY, 
	                    onChange: this.change("startY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "End: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.endX, 
	                    onChange: this.change("endX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.endY, 
	                    onChange: this.change("endY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Start updates ", React.createElement(TeX, null, "(x_n, y_n)"), " for ", React.createElement(TeX, null, "n ="), 
	                    React.createElement(NumberInput, {
	                        value: this.props.startSubscript, 
	                        placeholder: 0, 
	                        onChange: this.change("startSubscript")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "End updates ", React.createElement(TeX, null, "(x_m, y_m)"), " for ", React.createElement(TeX, null, "m ="), 
	                    React.createElement(NumberInput, {
	                        value: this.props.endSubscript, 
	                        placeholder: 0, 
	                        onChange: this.change("endSubscript")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "All constraints are applied to the start point."
	            ), 
	            React.createElement(ConstraintEditor, React.__spread({},  this.props))
	        );
	    }
	});


	//
	// Editor for function plots
	//
	// TODO(eater): Factor this out
	//
	var FunctionEditor = React.createClass({displayName: 'FunctionEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        value: React.PropTypes.string,
	        rangeMin: React.PropTypes.string,
	        rangeMax: React.PropTypes.string,
	        color: React.PropTypes.string,
	        strokeDashArray: React.PropTypes.string,
	        strokeWidth: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            value: "x",
	            rangeMin: "-10",
	            rangeMax: "10",
	            color: KhanUtil.BLUE,
	            strokeDasharray: "",
	            strokeWidth: 2
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(TeX, null, this.props.funcName + "(x)="), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.value, 
	                    onChange: this.change("value")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Range: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.rangeMin, 
	                    onChange: this.change("rangeMin")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.rangeMax, 
	                    onChange: this.change("rangeMax")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    onChange: this.change("color")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(DashPicker, {
	                    value: this.props.strokeDasharray, 
	                    onChange: this.change("strokeDasharray")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    "Width: ", React.createElement(NumberInput, {
	                        value: this.props.strokeWidth, 
	                        placeholder: 2, 
	                        onChange: this.change("strokeWidth")})
	                )
	            )
	        );
	    }
	});


	//
	// Editor for parametric plots
	//
	// TODO(eater): Factor this out
	//
	var ParametricEditor = React.createClass({displayName: 'ParametricEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        x: React.PropTypes.string,
	        y: React.PropTypes.string,
	        rangeMin: React.PropTypes.string,
	        rangeMax: React.PropTypes.string,
	        color: React.PropTypes.string,
	        strokeDashArray: React.PropTypes.string,
	        strokeWidth: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            x: "cos(t)",
	            y: "sin(t)",
	            rangeMin: "0",
	            rangeMax: "2\\pi",
	            color: KhanUtil.BLUE,
	            strokeDasharray: "",
	            strokeWidth: 2
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(TeX, null, "X(t) ="), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.x, 
	                    onChange: this.change("x")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(TeX, null, "Y(t) ="), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.y, 
	                    onChange: this.change("y")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Range: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.rangeMin, 
	                    onChange: this.change("rangeMin")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.rangeMax, 
	                    onChange: this.change("rangeMax")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    onChange: this.change("color")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(DashPicker, {
	                    value: this.props.strokeDasharray, 
	                    onChange: this.change("strokeDasharray")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    "Width: ", React.createElement(NumberInput, {
	                        value: this.props.strokeWidth, 
	                        placeholder: 2, 
	                        onChange: this.change("strokeWidth")})
	                )
	            )
	        );
	    }
	});


	//
	// Editor for labels
	//
	// TODO(eater): Factor this out maybe?
	// TODO(eater): Add text direction
	//
	var LabelEditor = React.createClass({displayName: 'LabelEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	    },

	    getDefaultProps: function() {
	        return {
	            coordX: "0",
	            coordY: "0",
	            color: KhanUtil.BLACK,
	            label: "\\phi"
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(TextInput, {
	                    value: this.props.label, 
	                    onChange: this.change("label"), 
	                    style: {
	                        width: "100%"
	                    }}
	                    )
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Location: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordX, 
	                    onChange: this.change("coordX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordY, 
	                    onChange: this.change("coordY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    onChange: this.change("color")})
	            )
	        );
	    }
	});


	//
	// Editor for rectangles
	//
	// TODO(eater): Factor this out maybe?
	//
	var RectangleEditor = React.createClass({displayName: 'RectangleEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	    },

	    getDefaultProps: function() {
	        return {
	            coordX: "-5",
	            coordY: "5",
	            width: "2",
	            height: "3",
	            color: KhanUtil.LIGHT_BLUE
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "graph-settings"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Top left: ", React.createElement(TeX, null, "\\Large("), React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordX, 
	                    onChange: this.change("coordX")}), 
	                React.createElement(TeX, null, ","), " ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.coordY, 
	                    onChange: this.change("coordY")}), 
	                React.createElement(TeX, null, "\\Large)")
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Width: ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.width, 
	                    onChange: this.change("width")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Height: ", React.createElement(MathInput, {
	                    buttonSets: [], 
	                    buttonsVisible: "never", 
	                    value: this.props.height, 
	                    onChange: this.change("height")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(ColorPicker, {
	                    value: this.props.color, 
	                    lightColors: true, 
	                    onChange: this.change("color")})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "You want a border? Sorry, draw your own."
	            )
	        );
	    }
	});



	var InteractionEditor = React.createClass({displayName: 'InteractionEditor',
	    mixins: [EditorJsonify, Changeable],

	    // TODO(eater): Make more better
	    propTypes: {
	        graph: React.PropTypes.object,
	        elements: React.PropTypes.arrayOf(React.PropTypes.object)
	    },

	    getDefaultProps: function() {
	        return defaultInteractionProps;
	    },

	    getInitialState: function() {
	        return {
	            usedVarSubscripts: this._getAllVarSubscripts(this.props.elements),
	            usedFunctionNames: this._getAllFunctionNames(this.props.elements)
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.setState({
	            usedVarSubscripts: this._getAllVarSubscripts(nextProps.elements),
	            usedFunctionNames: this._getAllFunctionNames(nextProps.elements)
	        });
	    },

	    _getAllVarSubscripts: function(elements) {
	        return _.map(_.where(elements, {type: "movable-point"}),
	            function(element)  {return element.options.varSubscript;}).concat(
	            _.map(_.where(elements, {type: "movable-line"}),
	            function(element)  {return element.options.startSubscript;})).concat(
	            _.map(_.where(elements, {type: "movable-line"}),
	            function(element)  {return element.options.endSubscript;}));
	    },

	    _getAllFunctionNames: function(elements) {
	        return _.map(_.where(elements, {type: "function"}),
	            function(element)  {return element.options.funcName;});
	    },

	    _updateGraphProps: function(newProps) {
	        // TODO(eater): GraphSettings should name this tickStep instead
	        // of step. Grr..
	        this.change({
	            graph: _.extend(_.omit(newProps, "step"), {
	                    tickStep: newProps.step
	                })
	        });
	    },

	    _addNewElement: function(e) {
	        var elementType = e.target.value;
	        if (elementType === "") {
	            return;
	        }
	        e.target.value = "";
	        var newElement = {
	            type: elementType,
	            key: elementType + "-" + (Math.random()*0xffffff<<0).toString(16),
	            options: elementType === "point" ?
	                        _.clone(PointEditor.defaultProps) :
	                        elementType === "line" ?
	                        _.clone(LineEditor.defaultProps) :
	                        elementType === "movable-point" ?
	                        _.clone(MovablePointEditor.defaultProps) :
	                        elementType === "movable-line" ?
	                        _.clone(MovableLineEditor.defaultProps) :
	                        elementType === "function" ?
	                        _.clone(FunctionEditor.defaultProps) :
	                        elementType === "parametric" ?
	                        _.clone(ParametricEditor.defaultProps) :
	                        elementType === "label" ?
	                        _.clone(LabelEditor.defaultProps) :
	                        elementType === "rectangle" ?
	                        _.clone(RectangleEditor.defaultProps) : {}
	        };
	        if (elementType === "movable-point") {
	            var nextSubscript =
	                _.max([_.max(this.state.usedVarSubscripts), -1]) + 1;
	            newElement.options.varSubscript = nextSubscript;
	        } else if (elementType === "movable-line") {
	            var nextSubscript =
	                _.max([_.max(this.state.usedVarSubscripts), -1]) + 1;
	            newElement.options.startSubscript = nextSubscript;
	            newElement.options.endSubscript = nextSubscript + 1;
	        } else if (elementType === "function") {
	            // TODO(eater): The 22nd function added will be {(x) since '{'
	            // comes after 'z'
	            var nextLetter = String.fromCharCode(_.max([_.max(_.map(
	                this.state.usedFunctionNames, function(c) {
	                return c.charCodeAt(0); })),
	                "e".charCodeAt(0)]) + 1);
	            newElement.options.funcName = nextLetter;
	        }
	        this.change({
	            elements: this.props.elements.concat(newElement)
	        });
	    },

	    _deleteElement: function(index) {
	        var element = this.props.elements[index];
	        this.change({elements: _.without(this.props.elements, element)});
	    },

	    _moveElementUp: function(index) {
	        var element = this.props.elements[index];
	        var newElements = _.without(this.props.elements, element);
	        newElements.splice(index - 1, 0, element);
	        this.change({elements: newElements});
	    },

	    _moveElementDown: function(index) {
	        var element = this.props.elements[index];
	        var newElements = _.without(this.props.elements, element);
	        newElements.splice(index + 1, 0, element);
	        this.change({elements: newElements});
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-widget-interaction-editor"}, 
	            React.createElement(ElementContainer, {
	                    title: "Grid settings"}, 
	                React.createElement(GraphSettings, {
	                    editableSettings: ["canvas", "graph"], 
	                    box: this.props.graph.box, 
	                    labels: this.props.graph.labels, 
	                    range: this.props.graph.range, 
	                    step: this.props.graph.tickStep, /*TODO(eater): grr names*/
	                    gridStep: this.props.graph.gridStep, 
	                    markings: this.props.graph.markings, 
	                    onChange: this._updateGraphProps}), 
	                (this.props.graph.valid === true) || React.createElement("div", null, 
	                    this.props.graph.valid
	                )
	            ), 
	            _.map(this.props.elements, function(element, n) {
	                if (element.type === "movable-point") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Movable point ", React.createElement(TeX, null, 
	                                    "(x_{" + element.options.varSubscript +
	                                    "}, y_{" + element.options.varSubscript +
	                                    "})")
	                                ), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement.bind(this, n), 
	                            key: element.key}, 
	                        React.createElement(MovablePointEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "movable-line") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Movable line ", React.createElement(TeX, null, 
	                                    "(x_{" + element.options.startSubscript +
	                                    "}, y_{" + element.options.startSubscript +
	                                    "})"), " to ", React.createElement(TeX, null, 
	                                    "(x_{" + element.options.endSubscript +
	                                    "}, y_{" + element.options.endSubscript +
	                                    "})")
	                                ), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement.bind(this, n), 
	                            key: element.key}, 
	                        React.createElement(MovableLineEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "point") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Point ", React.createElement(TeX, null, 
	                                    "(" + element.options.coordX +
	                                    ", " + element.options.coordY +
	                                    ")")
	                                ), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement.bind(this, n), 
	                            key: element.key}, 
	                        React.createElement(PointEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "line") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Line ", React.createElement(TeX, null, 
	                                    "(" + element.options.startX +
	                                    ", " + element.options.startY +
	                                    ")"), " to ", React.createElement(TeX, null, 
	                                    "(" + element.options.endX +
	                                    ", " + element.options.endY +
	                                    ")")
	                                ), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement.bind(this, n), 
	                            key: element.key}, 
	                        React.createElement(LineEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "function") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Function ", React.createElement(TeX, null, 
	                                element.options.funcName + "(x) = " +
	                                element.options.value
	                            )), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement, 
	                            key: element.key}, 
	                        React.createElement(FunctionEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "parametric") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Parametric"), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement, 
	                            key: element.key}, 
	                        React.createElement(ParametricEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)})
	                        )
	                    );
	                } else if (element.type === "label") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Label ", React.createElement(TeX, null, 
	                                element.options.label), " "), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement, 
	                            key: element.key}, 
	                        React.createElement(LabelEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)}))
	                    );
	                } else if (element.type === "rectangle") {
	                    return React.createElement(ElementContainer, {
	                            title: React.createElement("span", null, "Rectangle ", React.createElement(TeX, null, "(" +
	                                element.options.coordX + ", " +
	                                element.options.coordY + ")"), 
	                                " — ", 
	                                React.createElement(TeX, null, element.options.width + " \\times " +
	                                element.options.height)
	                                ), 
	                            onUp: n === 0 ?
	                                null : this._moveElementUp.bind(this, n), 
	                            onDown: n === this.props.elements.length - 1 ?
	                                null : this._moveElementDown.bind(this, n), 
	                            onDelete: this._deleteElement, 
	                            key: element.key}, 
	                        React.createElement(RectangleEditor, React.__spread({}, 
	                            element.options, 
	                            {onChange: function(newProps)  {
	                                var elements = JSON.parse(JSON.stringify(
	                                    this.props.elements));
	                                _.extend(elements[n].options, newProps);
	                                this.change({elements: elements});
	                            }.bind(this)}))
	                    );
	                }
	            }, this), 
	            React.createElement("div", {className: "perseus-widget-interaction-editor-select-element"}, 
	                React.createElement("select", {onChange: this._addNewElement}, 
	                    React.createElement("option", {value: ""}, "Add an element", "\u2026"), 
	                    React.createElement("option", {disabled: true}, "--"), 
	                    React.createElement("option", {value: "point"}, "Point"), 
	                    React.createElement("option", {value: "line"}, "Line segment"), 
	                    React.createElement("option", {value: "function"}, "Function plot"), 
	                    React.createElement("option", {value: "parametric"}, "Parametric plot"), 
	                    React.createElement("option", {value: "label"}, "Label"), 
	                    React.createElement("option", {value: "rectangle"}, "Rectangle"), 
	                    React.createElement("option", {value: "movable-point"}, 
	                        "★ Movable point"), 
	                    React.createElement("option", {value: "movable-line"}, 
	                        "★ Movable line segment")
	                )
	            )
	        );
	    }
	});


	module.exports = {
	    name: "interaction",
	    displayName: "Interaction",
	    widget: Interaction,
	    editor: InteractionEditor,
	    transform: _.identity
	};


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Graph         = __webpack_require__(95);
	var GraphSettings = __webpack_require__(88);
	var InfoTip       = __webpack_require__(75);
	var Interactive2  = __webpack_require__(89);
	var NumberInput   = __webpack_require__(94);
	var Util          = __webpack_require__(5);

	var knumber = __webpack_require__(113).number;
	var kpoint = __webpack_require__(113).point;

	var DeprecationMixin = Util.DeprecationMixin;


	var TRASH_ICON_URI = 'https://ka-perseus-graphie.s3.amazonaws.com/b1452c0d79fd0f7ff4c3af9488474a0a0decb361.png';

	var defaultBoxSize = 400;
	var defaultEditorBoxSize = 340;
	var defaultBackgroundImage = {
	    url: null
	};

	var eq = Util.eq;
	var deepEq = Util.deepEq;

	var UNLIMITED = "unlimited";

	// Sample background image:
	// https://ka-perseus-graphie.s3.amazonaws.com/29c1b0fcd17fe63df0f148fe357044d5d5c7d0bb.png

	function ccw(a, b, c) {
	    return (b[0] - a[0]) * (c[1] - a[1]) - (c[0] - a[0]) * (b[1] - a[1]);
	}

	function collinear(a, b, c) {
	    return eq(ccw(a, b, c), 0);
	}

	function sign(val) {
	    if (eq(val, 0)) {
	        return 0;
	    } else {
	        return val > 0 ? 1 : -1;
	    }
	}

	// default to defaultValue if actual is null or undefined
	function defaultVal(actual, defaultValue) {
	    return (actual == null) ? defaultValue : actual;
	}

	// Given rect bounding points A and B, whether point C is inside the rect
	function pointInRect(a, b, c) {
	    return (c[0] <= Math.max(a[0], b[0]) && c[0] >= Math.min(a[0], b[0]) &&
	            c[1] <= Math.max(a[1], b[1]) && c[1] >= Math.min(a[1], b[1]));
	}

	// Whether line segment AB intersects line segment CD
	// http://www.geeksforgeeks.org/check-if-two-given-line-segments-intersect/
	function intersects(ab, cd) {
	    var triplets = [
	        [ab[0], ab[1], cd[0]],
	        [ab[0], ab[1], cd[1]],
	        [cd[0], cd[1], ab[0]],
	        [cd[0], cd[1], ab[1]]
	    ];

	    var orientations = _.map(triplets, function(triplet) {
	        return sign(ccw.apply(null, triplet));
	    });

	    if (orientations[0] !== orientations[1] &&
	        orientations[2] !== orientations[3]) {
	        return true;
	    }

	    for (var i = 0; i < 4; i++) {
	        if (orientations[i] === 0 && pointInRect.apply(null, triplets[i])) {
	            return true;
	        }
	    }

	    return false;
	}

	function vector(a, b) {
	    return _.map(_.zip(a, b), function(pair) {
	        return pair[0] - pair[1];
	    });
	}

	function magnitude(v) {
	    return Math.sqrt(_.reduce(v, function(memo, el) {
	        return memo + Math.pow(el, 2);
	    }, 0));
	}

	function dotProduct(a, b) {
	    return _.reduce(_.zip(a, b), function(memo, pair) {
	        return memo + pair[0] * pair[1];
	    }, 0);
	}

	function sideLengths(coords) {
	    var segments = _.zip(coords, rotate(coords));
	    return _.map(segments, function(segment) {
	        return magnitude(vector.apply(null, segment));
	    });
	}

	// Based on http://math.stackexchange.com/a/151149
	function angleMeasures(coords) {
	    var triplets = _.zip(rotate(coords, -1), coords, rotate(coords, 1));

	    var offsets = _.map(triplets, function(triplet) {
	        var p = vector(triplet[1], triplet[0]);
	        var q = vector(triplet[2], triplet[1]);
	        var raw = Math.acos(dotProduct(p, q) / (magnitude(p) * magnitude(q)));
	        return sign(ccw.apply(null, triplet)) > 0 ? raw : -raw;
	    });

	    var sum = _.reduce(offsets, function(memo, arg) { return memo + arg; }, 0);

	    return _.map(offsets, function(offset) {
	        return sum > 0 ? Math.PI - offset : Math.PI + offset;
	    });
	}

	// Whether two polygons are similar (or if specified, congruent)
	function similar(coords1, coords2, tolerance) {
	    if (coords1.length !== coords2.length) {
	        return false;
	    }

	    var n = coords1.length;

	    var angles1 = angleMeasures(coords1);
	    var angles2 = angleMeasures(coords2);

	    var sides1 = sideLengths(coords1);
	    var sides2 = sideLengths(coords2);

	    for (var i = 0; i < 2 * n; i++) {
	        var angles = angles2.slice();
	        var sides = sides2.slice();

	        // Reverse angles and sides to allow matching reflected polygons
	        if (i >= n) {
	            angles.reverse();
	            sides.reverse();
	            // Since sides are calculated from two coordinates,
	            // simply reversing results in an off by one error
	            sides = rotate(sides, 1);
	        }

	        angles = rotate(angles, i);
	        sides = rotate(sides, i);

	        if (deepEq(angles1, angles)) {
	            var sidePairs = _.zip(sides1, sides);

	            var factors = _.map(sidePairs, function(pair) {
	                return pair[0] / pair[1];
	            });

	            var same = _.all(factors, function(factor) {
	                return eq(factors[0], factor);
	            });

	            var congruentEnough = _.all(sidePairs, function(pair) {
	                return knumber.equal(pair[0], pair[1], tolerance);
	            });

	            if (same && congruentEnough) {
	                return true;
	            }
	        }
	    }

	    return false;
	}

	// Less than or approximately equal
	function leq(a, b) {
	    return a < b || eq(a, b);
	}

	// Given triangle with sides ABC return angle opposite side C in degrees
	function lawOfCosines(a, b, c) {
	    return Math.acos((a * a + b * b - c * c) / (2 * a * b)) * 180 / Math.PI;
	}

	function canonicalSineCoefficients(coeffs) {
	    // For a curve of the form f(x) = a * Sin(b * x - c) + d,
	    // this function ensures that a, b > 0, and c is its
	    // smallest possible positive value.
	    var amplitude = coeffs[0];
	    var angularFrequency = coeffs[1];
	    var phase = coeffs[2];
	    var verticalOffset = coeffs[3];

	    // Guarantee a > 0
	    if (amplitude < 0) {
	        amplitude *= -1;
	        angularFrequency *= -1;
	        phase *= -1;
	    }

	    var period = 2 * Math.PI;
	    // Guarantee b > 0
	    if (angularFrequency < 0) {
	        angularFrequency *= -1;
	        phase *= -1;
	        phase += period / 2;
	    }

	    // Guarantee c is smallest possible positive value
	    while (phase > 0) {
	        phase -= period;
	    }
	    while (phase < 0) {
	        phase += period;
	    }

	    return [amplitude, angularFrequency, phase, verticalOffset];
	}

	// e.g. rotate([1, 2, 3]) -> [2, 3, 1]
	function rotate(array, n) {
	    n = (typeof n === "undefined") ? 1 : (n % array.length);
	    return array.slice(n).concat(array.slice(0, n));
	}

	function capitalize(str) {
	    return str.replace(/(?:^|-)(.)/g, function(match, letter) {
	        return letter.toUpperCase();
	    });
	}

	function getLineEquation(first, second) {
	    if (eq(first[0], second[0])) {
	        return "x = " + first[0].toFixed(3);
	    } else {
	        var m = (second[1] - first[1]) /
	                (second[0] - first[0]);
	        var b = first[1] - m * first[0];
	        return "y = " + m.toFixed(3) + "x + " + b.toFixed(3);
	    }
	}

	// Stolen from the wikipedia article
	// http://en.wikipedia.org/wiki/Line-line_intersection
	function getLineIntersection(firstPoints, secondPoints) {
	    var x1 = firstPoints[0][0],
	        y1 = firstPoints[0][1],
	        x2 = firstPoints[1][0],
	        y2 = firstPoints[1][1],
	        x3 = secondPoints[0][0],
	        y3 = secondPoints[0][1],
	        x4 = secondPoints[1][0],
	        y4 = secondPoints[1][1];

	    var determinant = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);

	    if (Math.abs(determinant) < 1e-9) {
	        return "Lines are parallel";
	    } else {
	        var x = ((x1 * y2 - y1 * x2) * (x3 - x4) -
	                 (x1 - x2) * (x3 * y4 - y3 * x4)) / determinant;
	        var y = ((x1 * y2 - y1 * x2) * (y3 - y4) -
	                 (y1 - y2) * (x3 * y4 - y3 * x4)) / determinant;
	        return "Intersection: (" + x.toFixed(3) + ", " + y.toFixed(3) + ")";
	    }
	}

	function numSteps(range, step) {
	    return Math.floor((range[1] - range[0]) / step);
	}

	var deprecatedProps = {
	    showGraph: function(props) {
	        return {markings: props.showGraph ? "graph" : "none"};
	    }
	};


	var InteractiveGraph = React.createClass({displayName: 'InteractiveGraph',

	    getInitialState: function() {
	        return {
	            shouldShowInstructions: this._getShouldShowInstructions()
	        };
	    },

	    getDefaultProps: function() {
	        return {
	            labels: ["x", "y"],
	            range: [[-10, 10], [-10, 10]],
	            box: [defaultBoxSize, defaultBoxSize],
	            step: [1, 1],
	            backgroundImage: defaultBackgroundImage,
	            markings: "graph",
	            showProtractor: false,
	            showRuler: false,
	            rulerLabel: "",
	            rulerTicks: 10,
	            graph: {
	                type: "linear"
	            }
	        };
	    },

	    mixins: [DeprecationMixin],
	    deprecatedProps: deprecatedProps,

	    _getShouldShowInstructions: function(props) {
	        props = props || this.props;
	        return this.isClickToAddPoints(props) && (
	            props.graph.coords == null || props.graph.coords.length === 0
	        );
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        var oldType = prevProps.graph.type;
	        var newType = this.props.graph.type;
	        if (oldType !== newType ||
	                prevProps.graph.allowReflexAngles !==
	                    this.props.graph.allowReflexAngles ||
	                prevProps.graph.angleOffsetDeg !==
	                    this.props.graph.angleOffsetDeg ||
	                prevProps.graph.numPoints !== this.props.graph.numPoints ||
	                prevProps.graph.numSides !== this.props.graph.numSides ||
	                prevProps.graph.numSegments !== this.props.graph.numSegments ||
	                prevProps.graph.showAngles !== this.props.graph.showAngles ||
	                prevProps.graph.showSides !== this.props.graph.showSides ||
	                prevProps.graph.snapTo !== this.props.graph.snapTo ||
	                prevProps.graph.snapDegrees !== this.props.graph.snapDegrees) {
	            this["remove" + capitalize(oldType) + "Controls"]();
	            this["add" + capitalize(newType) + "Controls"]();
	        }
	        if (this.shouldResetGraphie) {
	            this.resetGraphie();
	        }
	    },

	    render: function() {
	        var typeSelect;
	        var extraOptions;
	        if (this.props.flexibleType) {
	            typeSelect = React.createElement("select", {
	                    value: this.props.graph.type, 
	                    onChange: function(e)  {
	                        var type = e.target.value;
	                        this.props.onChange({
	                            graph: {type: type}
	                        });
	                    }.bind(this)}, 
	                React.createElement("option", {value: "linear"}, "Linear function"), 
	                React.createElement("option", {value: "quadratic"}, "Quadratic function"), 
	                React.createElement("option", {value: "sinusoid"}, "Sinusoid function"), 
	                React.createElement("option", {value: "circle"}, "Circle"), 
	                React.createElement("option", {value: "point"}, "Point(s)"), 
	                React.createElement("option", {value: "linear-system"}, "Linear System"), 
	                React.createElement("option", {value: "polygon"}, "Polygon"), 
	                React.createElement("option", {value: "segment"}, "Line Segment(s)"), 
	                React.createElement("option", {value: "ray"}, "Ray"), 
	                React.createElement("option", {value: "angle"}, "Angle")
	            );

	            if (this.props.graph.type === "point") {
	                extraOptions = React.createElement("select", {
	                        key: "point-select", 
	                        value: this.props.graph.numPoints || 1, 
	                        onChange: function(e)  {
	                            // Convert numbers, leave UNLIMITED intact:
	                            var num = +e.target.value || e.target.value;
	                            this.props.onChange({
	                                graph: {
	                                    type: "point",
	                                    numPoints: num,
	                                    coords: null
	                                }
	                            });
	                        }.bind(this)}, 
	                    _.map(_.range(1, 7), function(n) {
	                        return React.createElement("option", {value: n}, 
	                            n, " point", n > 1 && "s"
	                        );
	                    }), 
	                    React.createElement("option", {value: UNLIMITED}, "unlimited")
	                );
	            } else if (this.props.graph.type === "polygon") {
	                extraOptions = React.createElement("div", null, 
	                    React.createElement("div", null, 
	                        React.createElement("select", {
	                            key: "polygon-select", 
	                            value: this.props.graph.numSides || 3, 
	                            onChange: function(e)  {
	                                // Convert numbers, leave UNLIMITED intact:
	                                var num = +e.target.value || e.target.value;
	                                var graph = _.extend({}, this.props.graph, {
	                                    numSides: num,
	                                    coords: null,
	                                    snapTo: "grid" // reset the snap for
	                                                   // UNLIMITED, which only
	                                                   // supports "grid"
	                                });
	                                this.props.onChange({graph: graph});
	                            }.bind(this)}, 
	                            _.map(_.range(3, 13), function(n) {
	                                return React.createElement("option", {value: n}, n, " sides");
	                            }), 
	                            React.createElement("option", {value: UNLIMITED}, "unlimited sides")
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, " Snap to", ' ', 
	                            React.createElement("select", {
	                                key: "polygon-snap", 
	                                value: this.props.graph.snapTo, 
	                                onChange: function(e)  {
	                                    var graph = _.extend({},
	                                        this.props.graph,
	                                        {
	                                            snapTo: e.target.value,
	                                            coords: null
	                                        });
	                                    this.props.onChange({graph: graph});
	                                }.bind(this)}, 
	                                React.createElement("option", {value: "grid"}, "grid"), 
	                                (this.props.graph.numSides !== UNLIMITED) && [
	                                    React.createElement("option", {value: "angles"}, 
	                                        ' ', "interior angles", ' '
	                                    ),
	                                    React.createElement("option", {value: "sides"}, 
	                                        ' ', "side measures", ' '
	                                    )
	                                ]
	                            )
	                        ), 
	                        React.createElement(InfoTip, null, 
	                            React.createElement("p", null, "These options affect the movement of the vertex" + ' ' +
	                            "points. The grid option will guide the points to" + ' ' +
	                            "the nearest half step along the grid."), 

	                            React.createElement("p", null, "The interior angle and side measure options" + ' ' +
	                            "guide the points to the nearest whole angle or" + ' ' +
	                            "side"), " measure respectively.", ' '
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, "Show angle measures:", ' ', 
	                            React.createElement("input", {type: "checkbox", 
	                                checked: this.props.graph.showAngles, 
	                                onChange: this.toggleShowAngles})
	                        ), 
	                        React.createElement(InfoTip, null, 
	                            React.createElement("p", null, "Displays the interior angle measures.")
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, "Show side measures:", ' ', 
	                            React.createElement("input", {type: "checkbox", 
	                                checked: this.props.graph.showSides, 
	                                onChange: this.toggleShowSides})
	                        ), 
	                        React.createElement(InfoTip, null, 
	                            React.createElement("p", null, "Displays the side lengths.")
	                        )
	                    )
	                );
	            } else if (this.props.graph.type === "segment") {
	                extraOptions = React.createElement("select", {
	                        key: "segment-select", 
	                        value: this.props.graph.numSegments || 1, 
	                        onChange: function(e)  {
	                            var num = +e.target.value;
	                            this.props.onChange({
	                                graph: {
	                                    type: "segment",
	                                    numSegments: num,
	                                    coords: null
	                                }
	                            });
	                        }.bind(this)}, 
	                    _.map(_.range(1, 7), function(n) {
	                        return React.createElement("option", {value: n}, 
	                            n, " segment", n > 1 && "s"
	                        );
	                    })
	                );
	            } else if (this.props.graph.type === "angle") {
	                var allowReflexAngles = defaultVal(
	                    this.props.graph.allowReflexAngles,
	                    true
	                );
	                extraOptions = React.createElement("div", null, 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, "Show angle measure:", ' ', 
	                            React.createElement("input", {type: "checkbox", 
	                                checked: this.props.graph.showAngles, 
	                                onChange: this.toggleShowAngles})
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, "Allow reflex angles:", ' ', 
	                            React.createElement("input", {type: "checkbox", 
	                                checked: allowReflexAngles, 
	                                onChange: function(newVal)  {
	                                    this.props.onChange({
	                                        graph: _.extend({}, this.props.graph, {
	                                            allowReflexAngles:
	                                                    !allowReflexAngles,
	                                            coords: null
	                                        })
	                                    });
	                                }.bind(this)})
	                        ), 
	                        React.createElement(InfoTip, null, 
	                            React.createElement("p", null, 
	                                "Reflex angles are angles with a measure" + ' ' +
	                                "greater than 180 degrees."
	                            ), 
	                            React.createElement("p", null, 
	                                "By default, these should remain enabled."
	                            )
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, "Snap to increments of", ' ', 
	                            React.createElement(NumberInput, {
	                                key: "degree-snap", 
	                                placeholder: 1, 
	                                value: this.props.graph.snapDegrees, 
	                                onChange: function(newVal)  {
	                                    this.props.onChange({
	                                        graph: _.extend({}, this.props.graph, {
	                                            snapDegrees: Math.abs(newVal),
	                                            coords: null
	                                        })
	                                    });
	                                }.bind(this)}), 
	                            ' ', "degrees", ' '
	                        )
	                    ), 
	                    React.createElement("div", null, 
	                        React.createElement("label", null, 
	                            ' ', "With an offset of", ' ', 
	                            React.createElement(NumberInput, {
	                                key: "angle-offset", 
	                                placeholder: 0, 
	                                value: this.props.graph.angleOffsetDeg, 
	                                onChange: function(newVal)  {
	                                    this.props.onChange({
	                                        graph: _.extend({}, this.props.graph, {
	                                            angleOffsetDeg: newVal,
	                                            coords: null
	                                        })
	                                    });
	                                }.bind(this)}), 
	                            ' ', "degrees", ' '
	                        )
	                    )
	                );
	            }
	        }

	        var box = this.props.box;

	        var instructions;
	        if (this.isClickToAddPoints() && this.state.shouldShowInstructions) {
	            if  (this.props.graph.type === "point") {
	                instructions = $._("Click to add points");
	            } else if (this.props.graph.type === "polygon") {
	                instructions = $._("Click to add vertices");
	            }
	        } else {
	            instructions = undefined;
	        }

	        var onMouseDown = this.isClickToAddPoints() ?
	            this.handleAddPointsMouseDown :
	            null;

	        var gridStep = this.props.gridStep || Util.getGridStep(
	                this.props.range,
	                this.props.step,
	                defaultBoxSize
	        );
	        var snapStep = this.props.snapStep || Util.snapStepFromGridStep(
	            gridStep
	        );

	        return React.createElement("div", {className: "perseus-widget " +
	                    "perseus-widget-interactive-graph", 
	                    style: {
	                        width: box[0],
	                        height: this.props.flexibleType ? "auto" : box[1]
	                    }}, 
	            React.createElement(Graph, {
	                instructions: instructions, 
	                ref: "graph", 
	                box: this.props.box, 
	                labels: this.props.labels, 
	                range: this.props.range, 
	                step: this.props.step, 
	                gridStep: gridStep, 
	                snapStep: snapStep, 
	                markings: this.props.markings, 
	                backgroundImage: this.props.backgroundImage, 
	                showProtractor: this.props.showProtractor, 
	                showRuler: this.props.showRuler, 
	                rulerLabel: this.props.rulerLabel, 
	                rulerTicks: this.props.rulerTicks, 
	                onMouseDown: onMouseDown, 
	                onGraphieUpdated: this.setGraphie}), 
	            typeSelect, extraOptions
	        );
	    },

	    componentDidMount: function() {
	        this.setGraphie(this.refs.graph.graphie());
	    },

	    setGraphie: function(newGraphie) {
	        this.graphie = newGraphie;
	        this.setupGraphie();
	    },

	    handleAddPointsMouseDown: function(coord) {
	        // This function should only be called when this.isClickToAddPoints()
	        // is true
	        if (!this.isClickToAddPoints()) {
	            throw new Error("handleAddPointsClick should not be registered" +
	                "when isClickToAddPoints() is false");
	        }
	        if (!this.isCoordInTrash(coord)) {
	            var point;
	            if (this.props.graph.type === "point") {
	                point = this.createPointForPointsType(
	                    coord,
	                    this.points.length
	                );
	                if (!point.constrain()) {
	                    point.remove();
	                    return;
	                }
	                this.points.push(point);

	                // interactive2 allows us to grab the point
	                var idx = this.points.length - 1;
	                this.points[idx].grab(coord);

	                this.updateCoordsFromPoints();
	            } else if (this.props.graph.type === "polygon") {
	                if (this.polygon.closed()) {
	                    return;
	                }
	                point = this.createPointForPolygonType(
	                    coord,
	                    this.points.length
	                );
	                this.points.push(point);

	                var idx = this.points.length - 1;
	                this.points[idx].grab(coord);

	                // We don't call updateCoordsFromPoints for
	                // polygons, since the polygon won't be
	                // closed yet.
	                this.updatePolygon();
	            }

	            this.setState({
	                shouldShowInstructions: false
	            });
	        }
	    },

	    resetGraphie: function() {
	        this.shouldResetGraphie = false;
	        this.refs.graph.reset();
	    },

	    setupGraphie: function() {
	        this.setTrashCanVisibility(0);
	        if (this.isClickToAddPoints()) {
	            this.setTrashCanVisibility(0.5);
	        }

	        var type = this.props.graph.type;
	        this["add" + capitalize(type) + "Controls"]();
	    },

	    setTrashCanVisibility: function(opacity) {
	        var graphie = this.graphie;

	        if (knumber.equal(opacity, 0)) {
	            if (this.trashCan) {
	                this.trashCan.remove();
	                this.trashCan = null;
	            }
	        } else {
	            if (!this.trashCan) {
	                this.trashCan = graphie.raphael.image(TRASH_ICON_URI,
	                    graphie.xpixels - 40,
	                    graphie.ypixels - 40,
	                    40,
	                    40
	                );
	            }
	            this.trashCan.attr({
	                opacity: opacity
	            });
	        }
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (this.isClickToAddPoints() !== this.isClickToAddPoints(nextProps)) {
	            this.shouldResetGraphie = true;
	            this.setState({
	                shouldShowInstructions:
	                        this._getShouldShowInstructions(nextProps)
	            });
	        }
	    },

	    isClickToAddPoints: function(props) {
	        props = props || this.props;
	        return (props.graph.type === "point" &&
	                props.graph.numPoints === UNLIMITED) ||
	               (props.graph.type === "polygon" &&
	                props.graph.numSides === UNLIMITED);
	    },

	    addLine: function(type) {
	        var self = this;
	        var graphie = self.graphie;
	        var coords = InteractiveGraph.getLineCoords(
	            self.props.graph,
	            self.props
	        );

	        var points = self.points = _.map(coords, function(coord)  {
	            return Interactive2.addMovablePoint(graphie, {
	                coord: coord,
	                constraints: [
	                    Interactive2.MovablePoint.constraints.bound(),
	                    Interactive2.MovablePoint.constraints.snap()
	                ],
	                onMove: function()  {
	                    var graph = _.extend({}, self.props.graph, {
	                        coords: _.invoke(points, "coord")
	                    });
	                    self.props.onChange({graph: graph});
	                },
	                normalStyle: {
	                    stroke: KhanUtil.INTERACTIVE,
	                    fill: KhanUtil.INTERACTIVE
	                }
	            });
	        });

	        var lineConfig = {
	            points: points,
	            static: true
	        };

	        if (type === "line") {
	            lineConfig.extendLine = true;
	        } else if (type === "ray") {
	            lineConfig.extendRay = true;
	        }

	        var line = self.line = Interactive2.addMovableLine(
	            graphie,
	            lineConfig
	        );

	        // A and B can't be in the same place
	        points[0].listen("constraints", "isLine", function(coord)  {
	            return !kpoint.equal(coord, points[1].coord());
	        });
	        points[1].listen("constraints", "isLine", function(coord)  {
	            return !kpoint.equal(coord, points[0].coord());
	        });
	    },

	    removeLine: function() {
	        _.invoke(this.points, "remove");
	        this.line.remove();
	    },

	    addLinearControls: function() {
	        this.addLine("line");
	    },

	    removeLinearControls: function() {
	        this.removeLine();
	    },

	    addQuadraticControls: function() {
	        var graphie = this.graphie;
	        var coords = this.props.graph.coords;
	        if (!coords) {
	            coords = InteractiveGraph.defaultQuadraticCoords(this.props);
	        }

	        var pointA;
	        var pointB;
	        var pointC;
	        var onMoveHandler = function()  {
	            var graph = _.extend({}, this.props.graph, {
	                coords: [pointA.coord(), pointB.coord(), pointC.coord()]
	            });
	            this.props.onChange({graph: graph});
	            this.updateQuadratic();
	        }.bind(this);

	        pointA = this.pointA = Interactive2.addMovablePoint(graphie, {
	            coord: coords[0],
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord)  {
	                    return !pointA || (coord[0] !== pointB.coord()[0] &&
	                                coord[0] !== pointC.coord()[0]);
	                }
	            ],
	            onMove: onMoveHandler
	        });

	        pointB = this.pointB = Interactive2.addMovablePoint(graphie, {
	            coord: coords[1],
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord)  {
	                    return !pointB || (coord[0] !== pointA.coord()[0] &&
	                                coord[0] !== pointC.coord()[0]);
	                }
	            ],
	            onMove: onMoveHandler
	        });

	        pointC = this.pointC = Interactive2.addMovablePoint(graphie, {
	            coord: coords[2],
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord)  {
	                    return !pointC || (coord[0] !== pointA.coord()[0] &&
	                                coord[0] !== pointB.coord()[0]);
	                }
	            ],
	            onMove: onMoveHandler
	        });

	        this.updateQuadratic();
	    },

	    updateQuadratic: function() {
	        var coeffs = InteractiveGraph.getCurrentQuadraticCoefficients(
	                this.props);
	        if (!coeffs) {
	            return;
	        }

	        // Extract coefficients the parabola
	        var a = coeffs[0], b = coeffs[1], c = coeffs[2];

	        // Plot and style
	        if (this.parabola) {
	            var path = this.graphie.svgParabolaPath(a, b, c);
	            this.parabola.attr({ path: path });
	        } else {
	            this.parabola = this.graphie.parabola(a, b, c);
	            this.parabola.attr({ stroke: KhanUtil.DYNAMIC });
	            this.parabola.toBack();
	        }
	    },

	    removeQuadraticControls: function() {
	        this.pointA.remove();
	        this.pointB.remove();
	        this.pointC.remove();
	        if (this.parabola) {
	            this.parabola.remove();
	            this.parabola = null;
	        }
	    },

	    addSinusoidControls: function() {
	        var graphie = this.graphie;
	        var coords = this.props.graph.coords;
	        if (!coords) {
	            coords = InteractiveGraph.defaultSinusoidCoords(this.props);
	        }

	        var pointA;
	        var pointB;
	        var onMoveHandler = function()  {
	            var graph = _.extend({}, this.props.graph, {
	                coords: [pointA.coord(), pointB.coord()]
	            });
	            this.props.onChange({graph: graph});
	            this.updateSinusoid();
	        }.bind(this);

	        pointA = this.pointA = Interactive2.addMovablePoint(graphie, {
	            coord: coords[0],
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord)  {
	                    return !pointA || coord[0] !== pointB.coord()[0];
	                }
	            ],
	            onMove: onMoveHandler
	        });

	        pointB = this.pointB = Interactive2.addMovablePoint(graphie, {
	            coord: coords[1],
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord)  {
	                    return !pointA || coord[0] !== pointA.coord()[0];
	                }
	            ],
	            onMove: onMoveHandler
	        });

	        this.updateSinusoid();
	    },

	    updateSinusoid: function() {
	        var coeffs = InteractiveGraph.getCurrentSinusoidCoefficients(
	                this.props);
	        if (!coeffs) {
	            return;
	        }

	        var a = coeffs[0], b = coeffs[1], c = coeffs[2], d = coeffs[3];

	        // Plot and style
	        if (this.sinusoid) {
	            var path = this.graphie.svgSinusoidPath(a, b, c, d);
	            this.sinusoid.attr({ path: path });
	        } else {
	            this.sinusoid = this.graphie.sinusoid(a, b, c, d);
	            this.sinusoid.attr({ stroke: KhanUtil.DYNAMIC });
	            this.sinusoid.toBack();
	        }
	    },

	    removeSinusoidControls: function() {
	        this.pointA.remove();
	        this.pointB.remove();
	        if (this.sinusoid) {
	            this.sinusoid.remove();
	            this.sinusoid = null;
	        }
	    },

	    addCircleControls: function() {
	        var graphie = this.graphie;
	        var minSnap = _.min(graphie.snap);

	        var circle = this.circle = graphie.addCircleGraph({
	            center: this.props.graph.center || [0, 0],
	            radius: this.props.graph.radius || _.min(this.props.step),
	            snapX: graphie.snap[0],
	            snapY: graphie.snap[1],
	            minRadius: minSnap * 2,
	            snapRadius: minSnap
	        });

	        $(circle).on("move", function()  {
	            var graph = _.extend({}, this.props.graph, {
	                center: circle.center,
	                radius: circle.radius
	            });
	            this.props.onChange({graph: graph});
	        }.bind(this));
	    },

	    removeCircleControls: function() {
	        this.circle.remove();
	    },

	    addLinearSystemControls: function() {
	        var graphie = this.graphie;
	        var coords = InteractiveGraph.getLinearSystemCoords(this.props.graph,
	            this.props);

	        var segmentColors = [KhanUtil.INTERACTIVE, KhanUtil.GREEN];
	        var points = this.points = _.map(coords,
	                function(segmentCoords, segmentIndex)  {
	            var segmentPoints = _.map(segmentCoords, function(coord, i)  {
	                return Interactive2.addMovablePoint(graphie, {
	                    coord: coord,
	                    constraints: [
	                        Interactive2.MovablePoint.constraints.bound(),
	                        Interactive2.MovablePoint.constraints.snap(),
	                        function(coord)  {
	                            if (!segmentPoints) {
	                                // points hasn't been defined yet because
	                                // we're still creating them
	                                return;
	                            }
	                            return !kpoint.equal(
	                                coord,
	                                segmentPoints[1 - i].coord()
	                            );
	                        }
	                    ],
	                    onMove: function()  {
	                        var graph = _.extend({}, this.props.graph, {
	                            coords: _.map(
	                                this.points,
	                                function(segment)  {return _.invoke(segment, "coord");}
	                            )
	                        });
	                        this.props.onChange({graph: graph});
	                    }.bind(this),
	                    normalStyle: {
	                        stroke: segmentColors[segmentIndex],
	                        fill: segmentColors[segmentIndex]
	                    }
	                });
	            }.bind(this));
	            return segmentPoints;
	        }.bind(this));

	        var lines = this.lines = _.map(points,
	                function(segmentPoints, segmentIndex)  {
	            return Interactive2.addMovableLine(graphie, {
	                points: segmentPoints,
	                static: true,
	                extendLine: true,
	                normalStyle: {
	                    stroke: segmentColors[segmentIndex]
	                }
	            });
	        });
	    },

	    removeLinearSystemControls: function() {
	        _.invoke(this.lines, "remove");
	        _.map(this.points, function(segment)  {return _.invoke(segment, "remove");});
	    },

	    isCoordInTrash: function(coord) {
	        var graphie = this.graphie;
	        var screenPoint = graphie.scalePoint(coord);
	        return screenPoint[0] >= graphie.xpixels - 40 &&
	                screenPoint[1] >= graphie.ypixels - 40;
	    },

	    createPointForPointsType: function(coord, i) {
	        var self = this;
	        var graphie = self.graphie;
	        var point = Interactive2.addMovablePoint(graphie, {
	            coord: coord,
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                Interactive2.MovablePoint.constraints.snap(),
	                function(coord) {
	                    // TODO(jack): There ought to be a
	                    // MovablePoint.constraints.avoid
	                    // default that lets you do things like this
	                    return _.all(self.points, function(pt) {
	                        return point === pt ||
	                            !kpoint.equal(coord, pt.coord());
	                    });
	                }
	            ],
	            onMoveStart: function() {
	                if (self.isClickToAddPoints()) {
	                    self.setTrashCanVisibility(1);
	                }
	            },
	            onMove: self.updateCoordsFromPoints,
	            onMoveEnd: function(coord) {
	                if (self.isClickToAddPoints()) {
	                    if (self.isCoordInTrash(coord)) {
	                        // remove this point from points
	                        self.points = _.filter(self.points, function(pt) {
	                            return pt !== point;
	                        });
	                        // update the correct answer box
	                        self.updateCoordsFromPoints();

	                        // remove this movablePoint from graphie.
	                        // we wait to do this until we're not inside of
	                        // said point's onMoveEnd method so its state is
	                        // consistent throughout this method call
	                        setTimeout(point.remove.bind(point), 0);
	                    }
	                    // In case we mouseup'd off the graphie and that
	                    // stopped the move (in which case, we might not
	                    // be in isCoordInTrash()
	                    self.setTrashCanVisibility(0.5);
	                }
	            },
	            normalStyle: {
	                stroke: KhanUtil.INTERACTIVE,
	                fill: KhanUtil.INTERACTIVE
	            }
	        });

	        return point;
	    },

	    removePoint: function(point) {
	        var index = null;
	        this.points = _.filter(this.points, function(pt, i) {
	            if (pt === point) {
	                index = i;
	                return false;
	            } else {
	                return true;
	            }
	        });
	        return index;
	    },

	    createPointForPolygonType: function(coord, i) {
	        var graphie = this.graphie;

	        // TODO(alex): check against "grid" instead, use constants
	        var snapToGrid = !_.contains(["angles", "sides"],
	            this.props.graph.snapTo);

	        // Index relative to current point -> absolute index
	        // NOTE: This does not work when isClickToAddPoints() == true,
	        // as `i` can be changed by dragging a point to the trash
	        // Currently this function is only called when !isClickToAddPoints()
	        var rel = function(j)  {
	            return (i + j + this.points.length) % this.points.length;
	        }.bind(this);

	        var onMoveEndHandler = function(coord)  {
	            if (this.isClickToAddPoints()) {
	                if (this.isCoordInTrash(coord)) {
	                    // remove this point from points
	                    var index = this.removePoint(point);
	                    if (this.polygon.closed()) {
	                        this.points = rotate(this.points, index);
	                        this.polygon.update({closed: false});
	                    }
	                    this.updatePolygon();
	                    // the polygon is now unclosed, so we need to
	                    // remove any points props
	                    this.clearCoords();

	                    // remove this movablePoint from graphie.
	                    // wait to do this until we're not inside of
	                    // said point's onMoveEnd method so state is
	                    // consistent throughout the method call
	                    setTimeout(point.remove.bind(point), 0);
	                } else if (this.points.length > 1 && ((
	                            point === this.points[0] &&
	                            kpoint.equal(
	                                coord,
	                                _.last(this.points).coord()
	                            )
	                        ) || (
	                            point === _.last(this.points) &&
	                            kpoint.equal(
	                                coord,
	                                this.points[0].coord()
	                            )
	                        ))) {
	                    // If the user clicked and dragged a point over endpoint,
	                    // join the them
	                    var pointToRemove = this.points.pop();
	                    if (this.points.length > 2) {
	                        this.polygon.update({closed: true});
	                        this.updateCoordsFromPoints();
	                    } else {
	                        this.polygon.update({closed: false});
	                        this.clearCoords();
	                    }
	                    this.updatePolygon();
	                    // remove this movablePoint from graphie.
	                    // wait to do this until we're not inside of
	                    // said point's onMoveEnd method so state is
	                    // consistent throughout the method call
	                    setTimeout(pointToRemove.remove.bind(
	                        pointToRemove), 0);
	                } else {
	                    // If the user clicked and dragged a point over any other
	                    // existing point, fix shape
	                    var shouldRemove = _.any(this.points, function(pt) {
	                        return pt !== point && kpoint.equal(
	                            pt.coord(), coord);
	                    });
	                    if (shouldRemove) {
	                        this.removePoint(point);

	                        if (this.points.length < 3) {
	                            this.polygon.update({closed: false});
	                            this.clearCoords();
	                        } else if (this.polygon.closed()) {
	                            this.updateCoordsFromPoints();
	                        }
	                        this.updatePolygon();
	                        // remove this movablePoint from graphie.
	                        // wait to do this until we're not inside
	                        // said point's onMoveEnd method so state
	                        // is consistent throughout the method call
	                        setTimeout(point.remove.bind(point), 0);
	                    } else {
	                        // If this was
	                        //  * not a deletion
	                        //  * and a click on the first or last point
	                        //  * and not a drag,
	                        //  * and not a creation of a new point
	                        //    (see !point.state.isInitialMove, below),
	                        //  * and our polygon is not closed,
	                        //  * and we can close it (we need at least 3 points),
	                        // then close it
	                        if ((point === this.points[0] ||
	                                point === _.last(this.points)) &&
	                                !point.hasMoved() &&
	                                !point.state.isInitialMove &&
	                                !this.polygon.closed() &&
	                                this.points.length > 2) {

	                            this.polygon.update({closed: true});
	                            this.updatePolygon();

	                            // We finally have a closed polygon, so save our
	                            // points to props
	                            this.updateCoordsFromPoints();
	                        }
	                    }
	                }

	                // In case we mouseup'd off the graphie and that
	                // stopped the move
	                this.setTrashCanVisibility(0.5);
	            }

	            point.state.isInitialMove = false;
	        }.bind(this);

	        var graphConstraint = function(coord)  {
	            // These constraints are all relative to the other points, so if
	            // we're creating the initial points and haven't added any others
	            // to the graph, we can't enforce them.
	            if (this.points == null || this.points.length === 0) {
	                return true;
	            }

	            var coords = _.invoke(this.points, "coord");
	            coords[i] = coord;

	            // Check for invalid positioning, but only if we aren't adding
	            // points one click at a time, since those added points could
	            // have already violated these constraints
	            if (!this.isClickToAddPoints()) {
	                // Polygons can't have consecutive collinear points
	                if (collinear(coords[rel(-2)], coords[rel(-1)], coords[i]) ||
	                    collinear(coords[rel(-1)], coords[i],  coords[rel(1)]) ||
	                    collinear(coords[i],  coords[rel(1)],  coords[rel(2)])) {
	                    return false;
	                }

	                var segments = _.zip(coords, rotate(coords));

	                if (this.points.length > 3) {
	                    // Constrain to simple (non self-intersecting) polygon by
	                    // testing whether adjacent segments intersect any others
	                    for (var j = -1; j <= 0; j++) {
	                        var segment = segments[rel(j)];
	                        var others = _.without(segments,
	                            segment, segments[rel(j-1)], segments[rel(j+1)]);

	                        for (var k = 0; k < others.length; k++) {
	                            var other = others[k];
	                            if (intersects(segment, other)) {
	                                return false;
	                            }
	                        }
	                    }
	                }
	            }

	            if (this.props.graph.snapTo === "angles" &&
	                    this.points.length > 2) {
	                // Snap to whole degree interior angles

	                var angles = _.map(angleMeasures(coords), function(rad) {
	                    return rad * 180 / Math.PI;
	                });

	                _.each([-1, 1], function(j) {
	                    angles[rel(j)] = Math.round(angles[rel(j)]);
	                });

	                var getAngle = function(a, vertex, b) {
	                    var angle = KhanUtil.findAngle(
	                        coords[rel(a)], coords[rel(b)], coords[rel(vertex)]
	                    );
	                    return (angle + 360) % 360;
	                };

	                var innerAngles = [
	                    angles[rel(-1)] - getAngle(-2, -1, 1),
	                    angles[rel(1)] - getAngle(-1, 1, 2)
	                ];
	                innerAngles[2] = 180 - (innerAngles[0] + innerAngles[1]);

	                // Avoid degenerate triangles
	                if (_.any(innerAngles, function(angle) {
	                            return leq(angle, 1);
	                        })) {
	                    return false;
	                }

	                var knownSide = magnitude(vector(coords[rel(-1)],
	                    coords[rel(1)]));

	                var onLeft = sign(ccw(
	                    coords[rel(-1)], coords[rel(1)], coords[i]
	                )) === 1;

	                // Solve for side by using the law of sines
	                var side = Math.sin(innerAngles[1] * Math.PI / 180) /
	                    Math.sin(innerAngles[2] * Math.PI / 180) * knownSide;

	                var outerAngle = KhanUtil.findAngle(coords[rel(1)],
	                    coords[rel(-1)]);

	                var offset = this.graphie.polar(
	                    side,
	                    outerAngle + (onLeft? 1 : -1) * innerAngles[0]
	                );

	                return this.graphie.addPoints(coords[rel(-1)], offset);
	            } else if (this.props.graph.snapTo === "sides" &&
	                    this.points.length > 1) {
	                // Snap to whole unit side measures

	                var sides = _.map([
	                    [coords[rel(-1)], coords[i]],
	                    [coords[i], coords[rel(1)]],
	                    [coords[rel(-1)], coords[rel(1)]]
	                ], function(coords) {
	                    return magnitude(vector.apply(null, coords));
	                });

	                _.each([0, 1], function(j) {
	                    sides[j] = Math.round(sides[j]);
	                });

	                // Avoid degenerate triangles
	                if (leq(sides[1] + sides[2], sides[0]) ||
	                        leq(sides[0] + sides[2], sides[1]) ||
	                        leq(sides[0] + sides[1], sides[2])) {
	                    return false;
	                }

	                // Solve for angle by using the law of cosines
	                var innerAngle = lawOfCosines(sides[0],
	                    sides[2], sides[1]);

	                var outerAngle = KhanUtil.findAngle(coords[rel(1)],
	                    coords[rel(-1)]);

	                var onLeft = sign(ccw(
	                    coords[rel(-1)], coords[rel(1)], coords[i]
	                )) === 1;

	                var offset = this.graphie.polar(
	                    sides[0],
	                    outerAngle + (onLeft ? 1 : -1) * innerAngle
	                );

	                return this.graphie.addPoints(coords[rel(-1)], offset);
	            } else {
	                // Snap to grid (already done)
	                return true;
	            }
	        }.bind(this);

	        var point = Interactive2.addMovablePoint(graphie, {
	            coord: coord,
	            constraints: [
	                Interactive2.MovablePoint.constraints.bound(),
	                snapToGrid ? Interactive2.MovablePoint.constraints.snap() :
	                             null,
	                graphConstraint
	            ],
	            onMoveStart: function()  {
	                if (this.isClickToAddPoints()) {
	                    this.setTrashCanVisibility(1);
	                }
	            }.bind(this),
	            onMove: function()  {
	                if (this.polygon.closed()) {
	                    this.updateCoordsFromPoints();
	                }
	            }.bind(this),
	            onMoveEnd: onMoveEndHandler,
	            normalStyle: {
	                stroke: KhanUtil.INTERACTIVE,
	                fill: KhanUtil.INTERACTIVE
	            }
	        });
	        point.state.isInitialMove = true;

	        return point;
	    },

	    updateCoordsFromPoints: function() {
	        var graph = _.extend({}, this.props.graph, {
	            // Handle old movable points with .coord, or
	            // Interactive2.MovablePoint's with .coord()
	            coords: _.map(this.points, function(point) {
	                return _.result(point, "coord");
	            })
	        });
	        this.props.onChange({graph: graph});
	    },

	    clearCoords: function() {
	        var graph = _.extend({}, this.props.graph, {
	            coords: null
	        });
	        this.props.onChange({graph: graph});
	    },

	    addPointControls: function() {
	        var coords = InteractiveGraph.getPointCoords(
	            this.props.graph,
	            this.props
	        );
	        // Clear out our old points so that newly added points don't
	        // "collide" with them and reposition when being added
	        // Without this, when added, each point checks whether it is on top
	        // of a point in this.points, which (a) shouldn't matter since
	        // we're clearing out this.points anyways, and (b) can cause problems
	        // if each of this.points is a MovablePoint instead of an
	        // Interactive2.MovablePoint, since one has a .coord and the other
	        // has .coord()
	        // TODO(jack): Figure out a better way to do this
	        this.points = [];
	        this.points = _.map(coords, this.createPointForPointsType, this);
	    },

	    removePointControls: function() {
	        _.invoke(this.points, "remove");
	    },

	    addSegmentControls: function() {
	        var self = this;
	        var graphie = this.graphie;

	        var coords = InteractiveGraph.getSegmentCoords(
	            this.props.graph,
	            this.props
	        );

	        this.points = [];
	        this.lines = _.map(coords, function(segment, i) {
	            var updateCoordProps = function() {
	                var graph = _.extend({}, self.props.graph, {
	                    coords: _.invoke(self.lines, "coords")
	                });
	                self.props.onChange({graph: graph});
	            };

	            var points = _.map(segment, function(coord, i) {
	                return Interactive2.addMovablePoint(graphie, {
	                    coord: coord,
	                    normalStyle: {
	                        stroke: KhanUtil.INTERACTIVE,
	                        fill: KhanUtil.INTERACTIVE
	                    },
	                    constraints: [
	                        Interactive2.MovablePoint.constraints.bound(),
	                        Interactive2.MovablePoint.constraints.snap(),
	                        function(coord)  {
	                            if (!points) {
	                                // points hasn't been defined yet because
	                                // we're still creating them
	                                return;
	                            }
	                            return !kpoint.equal(coord, points[1 - i].coord());
	                        }
	                    ],
	                    onMove: updateCoordProps
	                });
	            });

	            self.points = self.points.concat(points);
	            var line = Interactive2.addMovableLine(graphie, {
	                points: points,
	                static: false,
	                constraints: [
	                    Interactive2.MovableLine.constraints.bound(),
	                    Interactive2.MovableLine.constraints.snap()
	                ],
	                onMove: [
	                    Interactive2.MovableLine.onMove.updatePoints,
	                    updateCoordProps
	                ],
	                normalStyle: {
	                    stroke: KhanUtil.INTERACTIVE
	                },
	                highlightStyle: {
	                    stroke: KhanUtil.INTERACTING
	                }
	            });
	            _.invoke(points, "toFront");

	            return line;
	        }, this);
	    },

	    removeSegmentControls: function() {
	        _.invoke(this.points, "remove");
	        _.invoke(this.lines, "remove");
	    },

	    addRayControls: function() {
	        this.addLine("ray");
	    },

	    removeRayControls: function() {
	        this.removeLine();
	    },

	    addPolygonControls: function() {
	        this.polygon = null;
	        var coords = InteractiveGraph.getPolygonCoords(
	            this.props.graph,
	            this.props
	        );
	        // Clear out our old points so that newly added points don't
	        // "collide", as in `addPointControls`
	        this.points = [];
	        this.points = _.map(coords, this.createPointForPolygonType, this);
	        this.updatePolygon();
	    },

	    updatePolygon: function() {
	        var closed;
	        if (this.polygon) {
	            closed = this.polygon.closed();
	        } else if (this.points.length >= 3) {
	            closed = true;
	        } else {
	            // There will only be fewer than 3 points in click-to-add-vertices
	            // mode, so we don't need to explicitly check for that here.
	            closed = false;
	        }

	        var graphie = this.graphie;
	        var n = this.points.length;

	        // TODO(alex): check against "grid" instead, use constants
	        var snapToGrid = !_.contains(["angles", "sides"],
	            this.props.graph.snapTo);

	        var angleLabels = _.times(n, function(i) {
	            if (!this.props.graph.showAngles ||
	                    (!closed && (i === 0 || i === n - 1))) {
	                return "";
	            } else if (this.props.graph.snapTo === "angles") {
	                return "$deg0";
	            } else {
	                return "$deg1";
	            }
	        }, this);

	        var showRightAngleMarkers = _.times(n, function(i) {
	            return closed || (i !== 0 && i !== n - 1);
	        }, this);

	        var numArcs = _.times(n, function(i) {
	            if (this.props.graph.showAngles &&
	                    (closed || (i !== 0 && i !== n - 1))) {
	                return 1;
	            } else {
	                return 0;
	            }
	        }, this);

	        var sideLabels = _.times(n, function(i) {
	            if (!this.props.graph.showSides ||
	                (!closed && i === n - 1)) {
	                return "";
	            } else if (this.props.graph.snapTo === "sides") {
	                return "$len0";
	            } else {
	                return "$len1";
	            }
	        }, this);

	        if (this.polygon == null) {
	            var self = this;
	            self.polygon = Interactive2.addMovablePolygon(graphie, {
	                constraints: [
	                    Interactive2.MovablePolygon.constraints.bound(),
	                    snapToGrid ? Interactive2.MovablePolygon.constraints.snap()
	                               : null
	                ],
	                closed: closed,
	                points: self.points,
	                angleLabels: angleLabels,
	                showRightAngleMarkers: showRightAngleMarkers,
	                numArcs: numArcs,
	                sideLabels: sideLabels,
	                onMove: [
	                    Interactive2.MovablePolygon.onMove.updatePoints,
	                    function() {
	                        if (this.closed()) {
	                            self.updateCoordsFromPoints();
	                        }
	                    }
	                ]
	            });
	        } else {
	            // We only need to pass in the properties that might've changed
	            this.polygon.update({
	                closed: closed,
	                points: this.points,
	                angleLabels: angleLabels,
	                showRightAngleMarkers: showRightAngleMarkers,
	                numArcs: numArcs,
	                sideLabels: sideLabels
	            });
	        }
	    },

	    removePolygonControls: function() {
	        _.invoke(this.points, "remove");
	        this.polygon.remove();
	    },

	    addAngleControls: function() {
	        var graphie = this.graphie;

	        var coords = InteractiveGraph.getAngleCoords(
	            this.props.graph,
	            this.props
	        );

	        // The vertex snaps to the grid, but the rays don't...
	        this.points = _.map(coords, function(coord, i) {
	            return graphie.addMovablePoint(_.extend({
	                coord: coord,
	                normalStyle: {
	                    stroke: KhanUtil.INTERACTIVE,
	                    fill: KhanUtil.INTERACTIVE
	                }
	            }, i === 1 ? {
	                snapX: graphie.snap[0],
	                snapY: graphie.snap[1]
	            } : {}));
	        });

	        // ...they snap to whole-degree angles from the vertex.
	        this.angle = graphie.addMovableAngle({
	            points: this.points,
	            snapDegrees: this.props.graph.snapDegrees || 1,
	            snapOffsetDeg: this.props.graph.angleOffsetDeg || 0,
	            angleLabel: this.props.graph.showAngles ? "$deg0" : "",
	            pushOut: 2,
	            allowReflex: defaultVal(this.props.graph.allowReflexAngles, true)
	        });

	        $(this.angle).on("move", function()  {
	            var graph = _.extend({}, this.props.graph, {
	                coords: this.angle.getClockwiseCoords()
	            });
	            this.props.onChange({graph: graph});
	        }.bind(this));
	    },

	    removeAngleControls: function() {
	        _.invoke(this.points, "remove");
	        this.angle.remove();
	    },

	    toggleShowAngles: function() {
	        var graph = _.extend({}, this.props.graph, {
	            showAngles: !this.props.graph.showAngles
	        });
	        this.props.onChange({graph: graph});
	    },

	    toggleShowSides: function() {
	        var graph = _.extend({}, this.props.graph, {
	            showSides: !this.props.graph.showSides
	        });
	        this.props.onChange({graph: graph});
	    },

	    getUserInput: function() {
	        return this.props.graph;
	    },

	    simpleValidate: function(rubric) {
	        return InteractiveGraph.validate(this.getUserInput(), rubric, this);
	    },

	    focus: $.noop
	});


	_.extend(InteractiveGraph, {
	    getQuadraticCoefficients: function(coords) {
	        var p1 = coords[0];
	        var p2 = coords[1];
	        var p3 = coords[2];

	        var denom = (p1[0] - p2[0]) * (p1[0] - p3[0]) * (p2[0] - p3[0]);
	        if (denom === 0) {
	            return;
	        }
	        var a = (p3[0] * (p2[1] - p1[1]) +
	                 p2[0] * (p1[1] - p3[1]) +
	                 p1[0] * (p3[1] - p2[1])) / denom;
	        var b = ((p3[0] * p3[0]) * (p1[1] - p2[1]) +
	                 (p2[0] * p2[0]) * (p3[1] - p1[1]) +
	                 (p1[0] * p1[0]) * (p2[1] - p3[1])) / denom;
	        var c = (p2[0] * p3[0] * (p2[0] - p3[0]) * p1[1] +
	                 p3[0] * p1[0] * (p3[0] - p1[0]) * p2[1] +
	                 p1[0] * p2[0] * (p1[0] - p2[0]) * p3[1]) / denom;
	        return [a, b, c];
	    },

	    getSinusoidCoefficients: function(coords) {
	        // It's assumed that p1 is the root and p2 is the first peak
	        var p1 = coords[0];
	        var p2 = coords[1];

	        // Resulting coefficients are canonical for this sine curve
	        var amplitude = (p2[1] - p1[1]);
	        var angularFrequency = Math.PI / (2 * (p2[0] - p1[0]));
	        var phase = p1[0] * angularFrequency;
	        var verticalOffset = p1[1];

	        return [amplitude, angularFrequency, phase, verticalOffset];
	    },


	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getLineCoords: function(graph, props) {
	        return graph.coords || InteractiveGraph.pointsFromNormalized(
	            props,
	            [
	                [0.25, 0.75],
	                [0.75, 0.75]
	            ]
	        );
	    },

	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getPointCoords: function(graph, props) {
	        var numPoints = graph.numPoints || 1;
	        var coords = graph.coords;

	        if (coords) {
	            return coords;
	        } else {
	            switch (numPoints) {
	                case 1:
	                    // Back in the day, one point's coords were in graph.coord
	                    coords = [graph.coord || [0, 0]];
	                    break;
	                case 2:
	                    coords = [[-5, 0], [5, 0]];
	                    break;
	                case 3:
	                    coords = [[-5, 0], [0, 0], [5, 0]];
	                    break;
	                case 4:
	                    coords = [[-6, 0], [-2, 0], [2, 0], [6, 0]];
	                    break;
	                case 5:
	                    coords = [[-6, 0], [-3, 0], [0, 0], [3, 0], [6, 0]];
	                    break;
	                case 6:
	                    coords = [[-5, 0], [-3, 0], [-1, 0], [1, 0], [3, 0],
	                              [5, 0]];
	                    break;
	                case UNLIMITED:
	                    coords = [];
	                    break;
	            }
	            // Transform coords from their -10 to 10 space to 0 to 1
	            // because of the old graph.coord, and also it's easier.
	            var range = [[-10, 10], [-10, 10]];
	            coords = InteractiveGraph.normalizeCoords(coords, range);

	            var coords = InteractiveGraph.pointsFromNormalized(props, coords);
	            return coords;
	        }
	    },

	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getLinearSystemCoords: function(graph, props) {
	        return graph.coords ||
	            _.map([
	                [[0.25, 0.75], [0.75, 0.75]],
	                [[0.25, 0.25], [0.75, 0.25]]
	            ], function(coords)  {
	                return InteractiveGraph.pointsFromNormalized(props, coords);
	            });
	    },

	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getPolygonCoords: function(graph, props) {
	        var coords = graph.coords;
	        if (coords) {
	            return coords;
	        }

	        var n = graph.numSides || 3;

	        if (n === UNLIMITED) {
	            coords = [];
	        } else {
	            var angle = 2 * Math.PI / n;
	            var offset = (1 / n - 1 / 2) * Math.PI;

	            // TODO(alex): Generalize this to more than just triangles so that
	            // all polygons have whole number side lengths if snapping to sides
	            var radius = graph.snapTo === "sides" ? Math.sqrt(3) / 3 * 7: 4;

	            // Generate coords of a regular polygon with n sides
	            coords = _.times(n, function(i) {
	                return [
	                    radius * Math.cos(i * angle + offset),
	                    radius * Math.sin(i * angle + offset)
	                ];
	            });
	        }

	        var range = [[-10, 10], [-10, 10]];
	        coords = InteractiveGraph.normalizeCoords(coords, range);

	        var snapToGrid = !_.contains(["angles", "sides"], graph.snapTo);
	        coords = InteractiveGraph.pointsFromNormalized(props, coords,
	            /* noSnap */ !snapToGrid);

	        return coords;
	    },

	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getSegmentCoords: function(graph, props) {
	        var coords = graph.coords;
	        if (coords) {
	            return coords;
	        }

	        var n = graph.numSegments || 1;
	        var ys = {
	            1: [5],
	            2: [5, -5],
	            3: [5, 0, -5],
	            4: [6, 2, -2, -6],
	            5: [6, 3, 0, -3, -6],
	            6: [5, 3, 1, -1, -3, -5]
	        }[n];
	        var range = [[-10, 10], [-10, 10]];

	        return _.map(ys, function(y) {
	            var segment = [[-5, y], [5, y]];
	            segment = InteractiveGraph.normalizeCoords(segment, range);
	            segment = InteractiveGraph.pointsFromNormalized(props, segment);
	            return segment;
	        });
	    },

	    /**
	     * @param {object} graph Like props.graph or props.correct
	     * @param {object} props of an InteractiveGraph instance
	     */
	    getAngleCoords: function(graph, props) {
	        var coords = graph.coords;
	        if (coords) {
	            return coords;
	        }

	        var snap = graph.snapDegrees || 1;
	        var angle = snap;
	        while (angle < 20) {
	            angle += snap;
	        }
	        angle = angle * Math.PI / 180;
	        var offset = (graph.angleOffsetDeg || 0) * Math.PI / 180;

	        coords = InteractiveGraph.pointsFromNormalized(props, [
	            [0.85, 0.50],
	            [0.5, 0.50]
	        ]);

	        var radius = magnitude(vector.apply(null, coords));

	        // Adjust the lower point by angleOffsetDeg degrees
	        coords[0] = [
	            coords[1][0] + radius * Math.cos(offset),
	            coords[1][1] + radius * Math.sin(offset)
	        ];
	        // Position the upper point angle radians from the
	        // lower point
	        coords[2] = [
	            coords[1][0] + radius * Math.cos(angle + offset),
	            coords[1][1] + radius * Math.sin(angle + offset)
	        ];

	        return coords;
	    },

	    normalizeCoords: function(coordsList, range) {
	        return _.map(coordsList, function(coords) {
	            return _.map(coords, function(coord, i) {
	                var extent = range[i][1] - range[i][0];
	                return ((coord + range[i][1]) / extent);
	            });
	        });
	    },

	    getEquationString: function(props) {
	        var type = props.graph.type;
	        var funcName = "get" + capitalize(type) + "EquationString";
	        return InteractiveGraph[funcName](props);
	    },

	    pointsFromNormalized: function(props, coordsList, noSnap) {
	        return _.map(coordsList, function(coords) {
	            return _.map(coords, function(coord, i) {
	                var range = props.range[i];
	                if (noSnap) {
	                    return range[0] + (range[1] - range[0]) * coord;
	                } else {
	                    var step = props.step[i];
	                    var nSteps = numSteps(range, step);
	                    var tick = Math.round(coord * nSteps);
	                    return range[0] + step * tick;
	                }
	            });
	        });
	    },

	    getLinearEquationString: function(props) {
	        var coords = InteractiveGraph.getLineCoords(props.graph, props);
	        if (eq(coords[0][0], coords[1][0])) {
	            return "x = " + coords[0][0].toFixed(3);
	        } else {
	            var m = (coords[1][1] - coords[0][1]) /
	                    (coords[1][0] - coords[0][0]);
	            var b = coords[0][1] - m * coords[0][0];
	            if (eq(m, 0)) {
	                return "y = " + b.toFixed(3);
	            } else {
	                return "y = " + m.toFixed(3) + "x + " + b.toFixed(3);
	            }
	        }
	    },

	    getCurrentQuadraticCoefficients: function(props) {
	        // TODO(alpert): Don't duplicate
	        var coords = props.graph.coords ||
	                InteractiveGraph.defaultQuadraticCoords(props);
	        return InteractiveGraph.getQuadraticCoefficients(coords);
	    },

	    defaultQuadraticCoords: function(props) {
	        var coords = [[0.25, 0.75], [0.5, 0.25], [0.75, 0.75]];
	        return InteractiveGraph.pointsFromNormalized(props, coords);
	    },

	    getQuadraticEquationString: function(props) {
	        var coeffs = InteractiveGraph.getCurrentQuadraticCoefficients(
	                props);
	        return "y = " + coeffs[0].toFixed(3) + "x^2 + " +
	                        coeffs[1].toFixed(3) + "x + " +
	                        coeffs[2].toFixed(3);
	    },

	    getCurrentSinusoidCoefficients: function(props) {
	        var coords = props.graph.coords ||
	                InteractiveGraph.defaultSinusoidCoords(props);
	        return InteractiveGraph.getSinusoidCoefficients(coords);
	    },

	    defaultSinusoidCoords: function(props) {
	        var coords = [[0.5, 0.5], [0.65, 0.60]];
	        return InteractiveGraph.pointsFromNormalized(props, coords);
	    },

	    getSinusoidEquationString: function(props) {
	        var coeffs = InteractiveGraph.getCurrentSinusoidCoefficients(
	                props);
	        return "y = " + coeffs[0].toFixed(3) + "sin(" +
	                        coeffs[1].toFixed(3) + "x - " +
	                        coeffs[2].toFixed(3) + ") + " +
	                        coeffs[3].toFixed(3);
	    },

	    getCircleEquationString: function(props) {
	        var graph = props.graph;
	        // TODO(alpert): Don't duplicate
	        var center = graph.center || [0, 0];
	        var radius = graph.radius || 2;
	        return "center (" + center[0] + ", " + center[1] + "), radius " +
	                radius;
	    },

	    getLinearSystemEquationString: function(props) {
	        var coords = InteractiveGraph.getLinearSystemCoords(
	            props.graph,
	            props
	        );
	        return "\n" +
	            getLineEquation(coords[0][0], coords[0][1]) +
	            "\n" +
	            getLineEquation(coords[1][0], coords[1][1]) +
	            "\n" +
	            getLineIntersection(coords[0], coords[1]);
	    },

	    getPointEquationString: function(props) {
	        var coords = InteractiveGraph.getPointCoords(props.graph, props);
	        return coords.map(function(coord) {
	            return "(" + coord[0] + ", " + coord[1] + ")";
	        }).join(", ");
	    },

	    getSegmentEquationString: function(props) {
	        var segments = InteractiveGraph.getSegmentCoords(props.graph,
	            props);
	        return _.map(segments, function(segment) {
	            return "[" +
	                _.map(segment, function(coord) {
	                    return "(" + coord.join(", ") + ")";
	                }).join(" ") +
	            "]";
	        }).join(" ");
	    },

	    getRayEquationString: function(props) {
	        var coords = InteractiveGraph.getLineCoords(props.graph, props);
	        var a = coords[0];
	        var b = coords[1];
	        var eq = InteractiveGraph.getLinearEquationString(props);

	        if (a[0] > b[0]) {
	            eq += " (for x <= " + a[0].toFixed(3) + ")";
	        } else if (a[0] < b[0]) {
	            eq += " (for x >= " + a[0].toFixed(3) + ")";
	        } else if (a[1] > b[1]) {
	            eq += " (for y <= " + a[1].toFixed(3) + ")";
	        } else {
	            eq += " (for y >= " + a[1].toFixed(3) + ")";
	        }

	        return eq;
	    },

	    getPolygonEquationString: function(props) {
	        var coords = InteractiveGraph.getPolygonCoords(
	            props.graph,
	            props
	        );
	        return _.map(coords, function(coord) {
	            return "(" + coord.join(", ") + ")";
	        }).join(" ");
	    },

	    getAngleEquationString: function(props) {
	        var coords = InteractiveGraph.getAngleCoords(props.graph, props);
	        var angle = KhanUtil.findAngle(coords[2], coords[0], coords[1]);
	        return angle.toFixed(0) + "\u00B0 angle" +
	                " at (" + coords[1].join(", ") + ")";
	    },

	    validate: function(state, rubric, component) {
	        // TODO(alpert): Because this.props.graph doesn't always have coords,
	        // check that .coords exists here, which is always true when something
	        // has moved
	        if (state.type === rubric.correct.type && state.coords) {
	            if (state.type === "linear") {
	                var guess = state.coords;
	                var correct = rubric.correct.coords;
	                // If both of the guess points are on the correct line, it's
	                // correct.
	                if (collinear(correct[0], correct[1], guess[0]) &&
	                        collinear(correct[0], correct[1], guess[1])) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "linear-system") {
	                var guess = state.coords;
	                var correct = rubric.correct.coords;

	                if ((
	                        collinear(correct[0][0], correct[0][1], guess[0][0]) &&
	                        collinear(correct[0][0], correct[0][1], guess[0][1]) &&
	                        collinear(correct[1][0], correct[1][1], guess[1][0]) &&
	                        collinear(correct[1][0], correct[1][1], guess[1][1])
	                    ) || (
	                        collinear(correct[0][0], correct[0][1], guess[1][0]) &&
	                        collinear(correct[0][0], correct[0][1], guess[1][1]) &&
	                        collinear(correct[1][0], correct[1][1], guess[0][0]) &&
	                        collinear(correct[1][0], correct[1][1], guess[0][1])
	                    )) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }

	            } else if (state.type === "quadratic") {
	                // If the parabola coefficients match, it's correct.
	                var guessCoeffs = this.getQuadraticCoefficients(state.coords);
	                var correctCoeffs = this.getQuadraticCoefficients(
	                        rubric.correct.coords);
	                if (deepEq(guessCoeffs, correctCoeffs)) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "sinusoid") {
	                var guessCoeffs = this.getSinusoidCoefficients(
	                    state.coords);
	                var correctCoeffs = this.getSinusoidCoefficients(
	                        rubric.correct.coords);

	                var canonicalGuessCoeffs = canonicalSineCoefficients(
	                                                guessCoeffs);
	                var canonicalCorrectCoeffs = canonicalSineCoefficients(
	                                                correctCoeffs);
	                // If the canonical coefficients match, it's correct.
	                if (deepEq(canonicalGuessCoeffs, canonicalCorrectCoeffs)) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "circle") {
	                if (deepEq(state.center, rubric.correct.center) &&
	                        eq(state.radius, rubric.correct.radius)) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "point") {
	                var guess = state.coords;
	                var correct = InteractiveGraph.getPointCoords(
	                        rubric.correct, component);
	                guess = guess.slice();
	                correct = correct.slice();
	                // Everything's already rounded so we shouldn't need to do an
	                // eq() comparison but _.isEqual(0, -0) is false, so we'll use
	                // eq() anyway. The sort should be fine because it'll stringify
	                // it and -0 converted to a string is "0"
	                guess.sort();
	                correct.sort();
	                if (deepEq(guess, correct)) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "polygon") {
	                var guess = state.coords.slice();
	                var correct = rubric.correct.coords.slice();

	                var match;
	                if (rubric.correct.match === "similar") {
	                    match = similar(guess, correct, Number.POSITIVE_INFINITY);
	                } else if (rubric.correct.match === "congruent") {
	                    match = similar(guess, correct, knumber.DEFAULT_TOLERANCE);
	                } else if (rubric.correct.match === "approx") {
	                    match = similar(guess, correct, 0.1);
	                } else { /* exact */
	                    guess.sort();
	                    correct.sort();
	                    match = deepEq(guess, correct);
	                }

	                if (match) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "segment") {
	                var guess = state.coords.slice();
	                var correct = rubric.correct.coords.slice();
	                guess = _.invoke(guess, "sort").sort();
	                correct = _.invoke(correct, "sort").sort();
	                if (deepEq(guess, correct)) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "ray") {
	                var guess = state.coords;
	                var correct = rubric.correct.coords;
	                if (deepEq(guess[0], correct[0]) &&
	                        collinear(correct[0], correct[1], guess[1])) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            } else if (state.type === "angle") {
	                var guess = state.coords;
	                var correct = rubric.correct.coords;

	                var match;
	                if (rubric.correct.match === "congruent") {
	                    var angles = _.map([guess, correct], function(coords) {
	                        var angle = KhanUtil.findAngle(
	                            coords[2], coords[0], coords[1]);
	                        return (angle + 360) % 360;
	                    });
	                    match = eq.apply(null, angles);
	                } else { /* exact */
	                    match = deepEq(guess[1], correct[1]) &&
	                            collinear(correct[1], correct[0], guess[0]) &&
	                            collinear(correct[1], correct[2], guess[2]);
	                }

	                if (match) {
	                    return {
	                        type: "points",
	                        earned: 1,
	                        total: 1,
	                        message: null
	                    };
	                }
	            }
	        }

	        // The input wasn't correct, so check if it's a blank input or if it's
	        // actually just wrong
	        if (!state.coords || _.isEqual(state, rubric.graph)) {
	            // We're where we started.
	            return {
	                type: "invalid",
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});

	var InteractiveGraphEditor = React.createClass({displayName: 'InteractiveGraphEditor',
	    className: "perseus-widget-interactive-graph",

	    getDefaultProps: function() {
	        return {
	            box: [defaultEditorBoxSize, defaultEditorBoxSize],
	            labels: ["x", "y"],
	            range: [[-10, 10], [-10, 10]],
	            step: [1, 1],
	            valid: true,
	            backgroundImage: defaultBackgroundImage,
	            markings: "graph",
	            showProtractor: false,
	            showRuler: false,
	            rulerLabel: "",
	            rulerTicks: 10,
	            correct: {
	                type: "linear",
	                coords: null
	            }
	        };
	    },

	    // TODO(jack): Use versioning instead of DeprecationMixin
	    mixins: [DeprecationMixin],
	    deprecatedProps: deprecatedProps,

	    render: function() {
	        var graph;
	        var equationString;

	        var gridStep = this.props.gridStep || Util.getGridStep(
	                this.props.range,
	                this.props.step,
	                defaultBoxSize
	        );
	        var snapStep = this.props.snapStep || Util.snapStepFromGridStep(
	            gridStep
	        );

	        if (this.props.valid === true) {
	            // TODO(aria): send these down all at once
	            var graphProps = {
	                ref: "graph",
	                box: this.props.box,
	                range: this.props.range,
	                labels: this.props.labels,
	                step: this.props.step,
	                gridStep: gridStep,
	                snapStep: snapStep,
	                graph: this.props.correct,
	                backgroundImage: this.props.backgroundImage,
	                markings: this.props.markings,
	                showProtractor: this.props.showProtractor,
	                showRuler: this.props.showRuler,
	                rulerLabel: this.props.rulerLabel,
	                rulerTicks: this.props.rulerTicks,
	                flexibleType: true,
	                onChange: function(newProps)  {
	                    var correct = this.props.correct;
	                    if (correct.type === newProps.graph.type) {
	                        correct = _.extend({}, correct, newProps.graph);
	                    } else {
	                        // Clear options from previous graph
	                        correct = newProps.graph;
	                    }
	                    this.props.onChange({correct: correct});
	                }.bind(this)
	            };
	            graph = React.createElement(InteractiveGraph, React.__spread({},  graphProps));
	            equationString = InteractiveGraph.getEquationString(graphProps);
	        } else {
	            graph = React.createElement("div", {className: "perseus-error"}, this.props.valid);
	        }

	        return React.createElement("div", {className: "perseus-widget-interactive-graph"}, 
	            React.createElement("div", null, "Correct answer", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Graph the correct answer in the graph below and ensure" + ' ' +
	                    "the equation or point coordinates displayed represent the" + ' ' +
	                    "correct answer.")
	                ), 
	                ' ', ": ", equationString), 


	            React.createElement(GraphSettings, {
	                box: this.props.box, 
	                range: this.props.range, 
	                labels: this.props.labels, 
	                step: this.props.step, 
	                gridStep: gridStep, 
	                snapStep: snapStep, 
	                valid: this.props.valid, 
	                backgroundImage: this.props.backgroundImage, 
	                markings: this.props.markings, 
	                showProtractor: this.props.showProtractor, 
	                showRuler: this.props.showRuler, 
	                rulerLabel: this.props.rulerLabel, 
	                rulerTicks: this.props.rulerTicks, 
	                onChange: this.props.onChange}), 


	            this.props.correct.type === "polygon" &&
	            React.createElement("div", {className: "type-settings"}, 
	                React.createElement("label", null, 
	                    ' ', "Student answer must", ' ', 
	                    React.createElement("select", {
	                            value: this.props.correct.match, 
	                            onChange: this.changeMatchType}, 
	                        React.createElement("option", {value: "exact"}, "match exactly"), 
	                        React.createElement("option", {value: "congruent"}, "be congruent"), 
	                        React.createElement("option", {value: "approx"}, 
	                            "be approximately congruent"), 
	                        React.createElement("option", {value: "similar"}, "be similar")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("ul", null, 
	                        React.createElement("li", null, 
	                            React.createElement("p", null, React.createElement("b", null, "Match Exactly:"), " Match exactly in size," + ' ' +
	                            "orientation, and location on the grid even if it is" + ' ' +
	                            "not shown in the background.")
	                        ), 
	                        React.createElement("li", null, 
	                            React.createElement("p", null, React.createElement("b", null, "Be Congruent:"), " Be congruent in size and" + ' ' +
	                            "shape, but can be located anywhere on the grid.")
	                        ), 
	                        React.createElement("li", null, 
	                            React.createElement("p", null, 
	                                React.createElement("b", null, "Be Approximately Congruent:"), " Be exactly" + ' ' +
	                                "similar, and congruent in size and shape to" + ' ' +
	                                "within 0.1 units, but can be located anywhere" + ' ' +
	                                "on the grid. ", React.createElement("em", null, "Use this with snapping to" + ' ' +
	                                "angle measure.")
	                            )
	                        ), 
	                        React.createElement("li", null, 
	                            React.createElement("p", null, React.createElement("b", null, "Be Similar:"), " Be similar with matching" + ' ' +
	                            "interior angles, and side measures that are" + ' ' +
	                            "matching or a multiple of the correct side" + ' ' +
	                            "measures. The figure can be located anywhere on the" + ' ' +
	                            "grid.")
	                        )
	                    )
	                )
	            ), 
	            this.props.correct.type === "angle" &&
	            React.createElement("div", {className: "type-settings"}, 
	                React.createElement("div", null, 
	                    React.createElement("label", null, 
	                        ' ', "Student answer must", ' ', 
	                        React.createElement("select", {
	                                value: this.props.correct.match, 
	                                onChange: this.changeMatchType}, 
	                            React.createElement("option", {value: "exact"}, "match exactly"), 
	                            React.createElement("option", {value: "congruent"}, "be congruent")
	                        )
	                    ), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, "Congruency requires only that the angle measures are" + ' ' +
	                        "the same. An exact match implies congruency, but also" + ' ' +
	                        "requires that the angles have the same orientation and" + ' ' +
	                        "that the vertices are in the same position.")
	                    )
	                )
	            ), 
	            graph
	        );
	    },

	    changeMatchType: function(e) {
	        var correct = _.extend({}, this.props.correct, {
	            match: e.target.value
	        });
	        this.props.onChange({correct: correct});
	    },

	    serialize: function() {
	        var json = _.pick(this.props, "step", "backgroundImage", "markings",
	            "labels", "showProtractor", "showRuler", "rulerLabel",
	            "rulerTicks", "range", "gridStep", "snapStep");

	        var graph = this.refs.graph;
	        if (graph) {
	            var correct = graph && graph.getUserInput();
	            _.extend(json, {
	                // TODO(alpert): Allow specifying flexibleType (whether the
	                // graph type should be a choice or not)
	                graph: {type: correct.type},
	                correct: correct
	            });

	            _.each(["allowReflexAngles", "angleOffsetDeg", "numPoints",
	                        "numSides", "numSegments", "showAngles", "showSides",
	                        "snapTo", "snapDegrees"],
	                    function(key) {
	                        if (_.has(correct, key)) {
	                            json.graph[key] = correct[key];
	                        }
	                    });
	        }
	        return json;
	    }
	});

	module.exports = {
	    name: "interactive-graph",
	    displayName: "Interactive graph",
	    widget: InteractiveGraph,
	    editor: InteractiveGraphEditor
	};


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var WidgetJsonifyDeprecated = __webpack_require__(78);

	var NumberInput = __webpack_require__(94);
	var PropCheckBox = __webpack_require__(65);
	var InfoTip = __webpack_require__(75);

	var MAX_SIZE = 8;

	// Styling
	var CELL_PADDING = 5;

	var TABLE_STYLE = {
	    display: "table",
	    tableLayout: "fixed"
	};

	var ROW_STYLE = {
	    display: "table-row"
	};

	var CELL_STYLE = {
	    display: "table-cell",
	    padding: CELL_PADDING
	};

	var BASE_TILE_STYLE = {
	    borderRadius: 10,
	    cursor: "pointer"
	};

	var MOVE_COUNT_STYLE = {
	    padding: CELL_PADDING,
	    display: "inline-block"
	};

	var RESET_BUTTON_STYLE = {
	    "float": "right",
	    paddingRight: CELL_PADDING
	};

	var MAIN_TILE_SIZE = 50;

	var mapCells = function(cells, func)  {
	    return _.map(cells, function(row, y)  {
	        return _.map(row, function(value, x)  {
	            return func(value, y, x);
	        });
	    });
	};

	var genCells = function(height, width, func)  {
	    return _.times(height, function(y)  {
	        return _.times(width, function(x)  {
	            return func(y, x);
	        });
	    });
	};

	var PATTERNS = {
	    plus: function()  {return [
	        [false, true, false],
	        [true,  true, true ],
	        [false, true, false]
	    ];},
	    x: function()  {return [
	        [true,  false, true ],
	        [false, true,  false],
	        [true,  false, true ]
	    ];},
	    "plus/x": function(iter)  {
	        return (iter % 2) ? PATTERNS.x() : PATTERNS.plus();
	    }
	};


	/**
	 * Clamps value to an integer in the range [min, max]
	 */
	var clampToInt = function(value, min, max) {
	    value = Math.floor(value);
	    value = Math.max(value, min);
	    value = Math.min(value, max);
	    return value;
	};

	// A single glowy cell
	var Tile = React.createClass({displayName: 'Tile',
	    propTypes: {
	        value: React.PropTypes.bool.isRequired,
	        size: React.PropTypes.number.isRequired
	    },

	    render: function() {
	        var color = this.props.value ? "#55dd55" : "#115511";
	        var style = _.extend({}, BASE_TILE_STYLE, {
	            width: this.props.size,
	            height: this.props.size,
	            backgroundColor: color
	        });
	        return React.createElement("div", {
	            style: style, 
	            onClick: this._flip});
	    },

	    _flip: function() {
	        this.props.onChange(!this.props.value);
	    },
	});

	// A grid of glowy cells
	var TileGrid = React.createClass({displayName: 'TileGrid',
	    propTypes: {
	        cells: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(React.PropTypes.bool)
	        ).isRequired,
	        size: React.PropTypes.number.isRequired
	    },

	    render: function() {
	        return React.createElement("div", {style: TABLE_STYLE, className: "no-select"}, 
	            _.map(this.props.cells, function(row, y)  {
	                return React.createElement("div", {key: y, style: ROW_STYLE}, 
	                    _.map(row, function(cell, x)  {
	                        return React.createElement("div", {key: x, style: CELL_STYLE}, 
	                            React.createElement(Tile, {
	                                value: cell, 
	                                size: this.props.size, 
	                                onChange: _.partial(this.props.onChange, y, x)}
	                                )
	                        );
	                    }.bind(this))
	                );
	            }.bind(this))
	        );
	    },
	});

	// Returns a copy of the tiles, with tiles flipped according to
	// whether or not their y, x position satisfies the predicate
	var flipTilesPredicate = function(oldCells, predicate)  {
	    return _.map(oldCells, function(row, y)  {
	        return _.map(row, function(cell, x)  {
	            return predicate(y, x) ? !cell : cell;
	        });
	    });
	};

	var flipTilesPattern = function(oldCells, tileY, tileX, pattern)  {
	    return flipTilesPredicate(oldCells, function(y, x)  {
	        var offsetY = y - tileY;
	        var offsetX = x - tileX;
	        if (Math.abs(offsetY) <= 1 && Math.abs(offsetX) <= 1) {
	            return pattern[offsetY + 1][offsetX + 1];
	        } else {
	            return false;
	        }
	    });
	};

	// The lights puzzle widget
	var LightsPuzzle = React.createClass({displayName: 'LightsPuzzle',
	    mixins: [Changeable, WidgetJsonifyDeprecated],

	    propTypes: {
	        cells: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(React.PropTypes.bool)
	        ),
	        startCells: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(React.PropTypes.bool)
	        ),
	        flipPattern: React.PropTypes.string.isRequired,
	        moveCount: React.PropTypes.number.isRequired
	    },

	    getDefaultProps: function() {
	        return {
	            cells: [
	                [false, false, false],
	                [false, false, false],
	                [false, false, false]
	            ],
	            startCells: [
	                [false, false, false],
	                [false, false, false],
	                [false, false, false]
	            ],
	            flipPattern: "plus",
	            moveCount: 0
	        };
	    },

	    render: function() {
	        var width = this._width();
	        var tileSize = MAIN_TILE_SIZE;
	        var pxWidth = width * (tileSize + 2 * CELL_PADDING);
	        return React.createElement("div", null, 
	            React.createElement(TileGrid, {
	                cells: this.props.cells, 
	                size: tileSize, 
	                onChange: this._flipTile}), 
	            React.createElement("div", {style: {width: pxWidth}}, 
	                React.createElement("div", {style: MOVE_COUNT_STYLE}, 
	                    "Moves: ", this.props.moveCount
	                ), 
	                React.createElement("div", {style: RESET_BUTTON_STYLE}, 
	                React.createElement("input", {
	                    type: "button", 
	                    value: "Reset", 
	                    onClick: this._reset, 
	                    className: "simple-button"})
	                )
	            ), 
	            React.createElement("div", {className: "clearfix"})
	        );
	    },

	    _width: function() {
	        if (this.props.cells.length !== 0) {
	            return this.props.cells[0].length;
	        } else {
	            return 0; // default to 0
	        }
	    },

	    componentDidMount: function() {
	        this._initNextPatterns();
	    },

	    componentDidUpdate: function(prevProps) {
	        if (prevProps.flipPattern !== this.props.flipPattern) {
	            this._initNextPatterns();
	        }
	    },

	    _initNextPatterns: function() {
	        this._currPattern = PATTERNS[this.props.flipPattern](0);
	        this._nextPattern = PATTERNS[this.props.flipPattern](1);
	        this._patternIndex = 2;
	    },

	    _shiftPatterns: function() {
	        this._currPattern = this._nextPattern;
	        this._nextPattern = PATTERNS[this.props.flipPattern](
	            this._patternIndex
	        );
	        this._patternIndex++;
	    },

	    _flipTile: function(tileY, tileX) {
	        var newCells = flipTilesPattern(
	            this.props.cells,
	            tileY,
	            tileX,
	            this._currPattern
	        );
	        this._shiftPatterns();

	        this.change({
	            cells: newCells,
	            moveCount: this.props.moveCount + 1
	        });
	    },

	    _reset: function() {
	        this.change({
	            cells: this.props.startCells,
	            moveCount: 0
	        });
	    },

	    simpleValidate: function(rubric) {
	        return validate(rubric, this.getUserInput());
	    }
	});

	// The widget editor
	var LightsPuzzleEditor = React.createClass({displayName: 'LightsPuzzleEditor',
	    mixins: [Changeable, EditorJsonify],

	    propTypes: {
	        startCells: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(React.PropTypes.bool)
	        ),
	        flipPattern: React.PropTypes.string.isRequired,
	        gradeIncompleteAsWrong: React.PropTypes.bool.isRequired
	    },

	    getDefaultProps: function() {
	        return {
	            startCells: [
	                [false, false, false],
	                [false, false, false],
	                [false, false, false]
	            ],
	            flipPattern: "plus",
	            gradeIncompleteAsWrong: false
	        };
	    },

	    _height: function() {
	        return this.props.startCells.length;
	    },

	    _width: function() {
	        if (this.props.startCells.length !== 0) {
	            return this.props.startCells[0].length;
	        } else {
	            return 0; // default to 0
	        }
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("div", null, 
	                "Width:", 
	                React.createElement(NumberInput, {
	                    value: this._width(), 
	                    placeholder: 5, 
	                    onChange: this._changeWidth}), 
	                ", ", 
	                "Height:", 
	                React.createElement(NumberInput, {
	                    value: this._height(), 
	                    placeholder: 5, 
	                    onChange: this._changeHeight})
	            ), 
	            React.createElement("div", null, 
	                "Flip pattern:", 
	                React.createElement("select", {
	                        value: this.props.flipPattern, 
	                        onChange: this._handlePatternChange}, 
	                    _.map(_.keys(PATTERNS), function(pattern, i)  {
	                        return React.createElement("option", {value: pattern, key: i}, 
	                            pattern
	                        );
	                    })
	                )
	            ), 
	            React.createElement("div", null, 
	                "Grade incomplete puzzles as wrong:", 
	                " ", 
	                React.createElement(PropCheckBox, {
	                    gradeIncompleteAsWrong: this.props.gradeIncompleteAsWrong, 
	                    onChange: this.props.onChange}), 
	                    React.createElement(InfoTip, null, 
	                        "By default, incomplete puzzles are graded as empty."
	                    )
	                ), 
	            React.createElement("div", null, 
	                "Starting configuration:"
	            ), 
	            React.createElement("div", {style: {overflowX: "auto"}}, 
	                React.createElement(TileGrid, {
	                    cells: this.props.startCells, 
	                    size: 50, 
	                    onChange: this._switchTile})
	            )
	        );
	    },

	    _handlePatternChange: function(e) {
	        this.change("flipPattern", e.target.value);
	    },

	    _changeWidth: function(newWidth) {
	        newWidth = clampToInt(newWidth, 1, MAX_SIZE);
	        this._truncateCells(newWidth, this._height());
	    },

	    _changeHeight: function(newHeight) {
	        newHeight = clampToInt(newHeight, 1, MAX_SIZE);
	        this._truncateCells(this._width(), newHeight);
	    },

	    _truncateCells: function(newWidth, newHeight) {
	        var newCells = _.times(newHeight, function(y)  {
	            return _.times(newWidth, function(x)  {
	                // explicitly cast the result to a boolean with !!
	                return !!(this.props.startCells[y] &&
	                        this.props.startCells[y][x]);
	            }.bind(this));
	        }.bind(this));

	        this.change({startCells: newCells});
	    },

	    _switchTile: function(tileY, tileX) {
	        var newCells = flipTilesPredicate(this.props.startCells, function(y, x)  {
	            return y === tileY && x === tileX;
	        });

	        this.change({startCells: newCells});
	    }
	});

	// grading function
	var validate = function(rubric, state) {
	    var empty = _.all(state.cells, function(row, y)  {
	        return _.all(row, function(cell, x)  {
	            return cell === rubric.startCells[y][x];
	        });
	    });
	    if (empty) {
	        return {
	            type: "invalid",
	            message: $._("Click on the tiles to change the lights.")
	        };
	    }

	    var correct = _.all(state.cells, function(row)  {
	        return _.all(row, function(cell)  {
	            return cell;
	        });
	    });

	    if (correct) {
	        return {
	            type: "points",
	            earned: 1,
	            total: 1,
	            message: null
	        };
	    } else if (rubric.gradeIncompleteAsWrong) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 1,
	            message: null
	        };
	    } else {
	        return {
	            type: "invalid",
	            message: $._("You must turn on all of the lights to continue.")
	        };
	    }
	};

	// The function run on the editor props to create the widget props
	var transformProps = function(editorProps) {
	    return {
	        cells: editorProps.startCells,
	        startCells: editorProps.startCells,
	        flipPattern: editorProps.flipPattern
	    };
	};

	module.exports = {
	    name: "lights-puzzle",
	    displayName: "Lights Puzzle",
	    hidden: true,
	    widget: LightsPuzzle,
	    editor: LightsPuzzleEditor,
	    transform: transformProps
	};


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var Editor = __webpack_require__(11);
	var NumberInput = __webpack_require__(94);
	var RangeInput = __webpack_require__(92);
	var Renderer = __webpack_require__(15);
	var TextInput = __webpack_require__(81);
	var MathOutput = __webpack_require__(96);

	var ApiOptions = __webpack_require__(17).Options;

	var assert = __webpack_require__(97).assert;
	var stringArrayOfSize = __webpack_require__(5).stringArrayOfSize;

	// Really large matrices will cause issues with question formatting, so we
	// have to cap it at some point.
	var MAX_BOARD_SIZE = 6;

	// We store two sets of dimensions for the brackets, because mobile formatting
	// is different. These dimensions come from `matrix.less`.
	var MOBILE_DIMENSIONS = {
	    INPUT_MARGIN: 4,
	    INPUT_HEIGHT: 38,
	    INPUT_WIDTH: 82
	};

	var NORMAL_DIMENSIONS = {
	    INPUT_MARGIN: 3,
	    INPUT_HEIGHT: 30,
	    INPUT_WIDTH: 40
	};

	/* Input handling: Maps a (row, column) pair to a unique ref used by React,
	 * and extracts (row, column) pairs from input paths, used to allow outsiders
	 * to focus, blur, set input values, etc. */
	var getInputPath = function(row, column) {
	    return ["" + row, "" + column];
	};

	var getDefaultPath = function() {
	    return getInputPath(0, 0);
	};

	var getRowFromPath = function(path) {
	    // 'path' should be a (row, column) pair
	    assert(_.isArray(path) && path.length === 2);
	    return +path[0];
	};

	var getColumnFromPath = function(path) {
	    // 'path' should be a (row, column) pair
	    assert(_.isArray(path) && path.length === 2);
	    return +path[1];
	};

	var getRefForPath = function(path) {
	    var row = getRowFromPath(path);
	    var column = getColumnFromPath(path);
	    return "answer" + row + "," + column;
	};

	var getMatrixSize = function(matrix) {
	    var matrixSize = [1, 1];

	    // We need to find the widest row and tallest column to get the correct
	    // matrix size.
	    _(matrix).each(function(matrixRow, row)  {
	        var rowWidth = 0;
	        _(matrixRow).each(function(matrixCol, col)  {
	            if (matrixCol != null && matrixCol.toString().length) {
	                rowWidth = col + 1;
	            }
	        });

	        // Matrix width:
	        matrixSize[1] = Math.max(matrixSize[1], rowWidth);

	        // Matrix height:
	        if (rowWidth > 0) {
	            matrixSize[0] = Math.max(matrixSize[0], row + 1);
	        }
	    });
	    return matrixSize;
	};

	var Matrix = React.createClass({displayName: 'Matrix',
	    propTypes: {
	        matrixBoardSize: React.PropTypes.arrayOf(
	            React.PropTypes.number
	        ).isRequired,
	        answers: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(
	                React.PropTypes.oneOfType([
	                    React.PropTypes.string,
	                    React.PropTypes.number
	                ])
	            )
	        ),
	        prefix: React.PropTypes.string,
	        suffix: React.PropTypes.string,
	        cursorPosition: React.PropTypes.arrayOf(
	            React.PropTypes.number
	        )
	    },

	    getDefaultProps: function() {
	        return {
	            matrixBoardSize: [3, 3],
	            answers: [[]],
	            prefix: "",
	            suffix: "",
	            cursorPosition: [0, 0],
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    getInitialState: function() {
	        return {
	            enterTheMatrix: 0
	        };
	    },

	    componentDidMount: function() {
	        // Used in the `onBlur` and `onFocus` handlers
	        this.cursorPosition = [0, 0];
	    },

	    render: function() {
	        // Set the input sizes through JS so we can control the size of the
	        // brackets. (If we set them in CSS we won't know values until the
	        // inputs are rendered.)
	        var dimensions = this.props.apiOptions.staticRender ?
	                MOBILE_DIMENSIONS : NORMAL_DIMENSIONS;
	        var $__0=      dimensions,INPUT_MARGIN=$__0.INPUT_MARGIN,INPUT_HEIGHT=$__0.INPUT_HEIGHT,INPUT_WIDTH=$__0.INPUT_WIDTH;

	        var matrixSize = getMatrixSize(this.props.answers);
	        var maxRows = this.props.matrixBoardSize[0];
	        var maxCols = this.props.matrixBoardSize[1];
	        var cursorRow = this.props.cursorPosition[0];
	        var cursorCol = this.props.cursorPosition[1];

	        var highlightedRow = Math.max(cursorRow, matrixSize[0] - 1);
	        var highlightedCol = Math.max(cursorCol, matrixSize[1] - 1);
	        var bracketHeight = (highlightedRow + 1) *
	                (INPUT_HEIGHT + 2 * INPUT_MARGIN);
	        var bracketOffset = (highlightedCol + 1) *
	                (INPUT_WIDTH + 2 * INPUT_MARGIN);

	        var className = classNames({
	            "perseus-matrix": true,
	            "the-matrix": this.state.enterTheMatrix >= 5
	        });

	        return React.createElement("div", {className: className}, 
	            this.props.prefix && React.createElement("div", {className: "matrix-prefix"}, 
	                React.createElement(Renderer, {content: this.props.prefix})
	            ), 
	            React.createElement("div", {className: "matrix-input"}, 
	                React.createElement("div", {
	                    className: "matrix-bracket bracket-left", 
	                    style: {
	                        height: bracketHeight
	                    }}
	                ), 
	                React.createElement("div", {
	                    className: "matrix-bracket bracket-right", 
	                    style: {
	                        height: bracketHeight,
	                        left: bracketOffset
	                    }}
	                ), 
	                _(maxRows).times(function(row)  {
	                    var rowVals = this.props.answers[row];
	                    return React.createElement("div", {className: "matrix-row", key: row}, 
	                        _(maxCols).times(function(col)  {
	                            var outside = row > highlightedRow ||
	                                    col > highlightedCol;
	                            var inputProps = {
	                                className: outside ? "outside" : "inside",
	                                ref: getRefForPath(getInputPath(row, col)),
	                                value: rowVals ? rowVals[col] : null,
	                                style: {
	                                    height: INPUT_HEIGHT,
	                                    width: INPUT_WIDTH,
	                                    margin: INPUT_MARGIN
	                                },
	                                onFocus: function()  {
	                                    // We store this locally so that we can use
	                                    // the new information in the `onBlur`
	                                    // handler, which happens before the props
	                                    // change has time to propagate.
	                                    // TODO(emily): Try to fix `MathOutput` so
	                                    // it correctly sends blur events before
	                                    // focus events.
	                                    this.cursorPosition = [row, col];
	                                    this.props.onChange({
	                                        cursorPosition: [row, col]
	                                    }, function()  {
	                                        // This isn't a user interaction, so
	                                        // return false to signal that the
	                                        // matrix shouldn't be focused
	                                        return false;
	                                    });
	                                    this._handleFocus(row, col);
	                                }.bind(this),
	                                onBlur: function()  {
	                                    if (row === this.cursorPosition[0] &&
	                                        col === this.cursorPosition[1]) {
	                                        this.props.onChange({
	                                            cursorPosition: [0, 0]
	                                        }, function()  {
	                                            // This isn't a user interaction,
	                                            // so return false to signal that
	                                            // the matrix shouldn't be focused
	                                            return false;
	                                        });
	                                    }
	                                    this._handleBlur(row, col);
	                                }.bind(this),
	                                onKeyDown: function(e)  {
	                                    this.handleKeyDown(row, col, e);
	                                }.bind(this),
	                                onChange: function(value)  {
	                                    this.onValueChange(row, col, value);
	                                }.bind(this)
	                            };

	                            var MatrixInput;
	                            if (this.props.apiOptions.staticRender) {
	                                MatrixInput = React.createElement(MathOutput, React.__spread({},  inputProps));
	                            } else if (this.props.numericInput) {
	                                MatrixInput = React.createElement(NumberInput, React.__spread({},  inputProps));
	                            } else {
	                                MatrixInput = React.createElement(TextInput, React.__spread({},  inputProps));
	                            }
	                            return React.createElement("span", {
	                                        key: col, 
	                                        className: "matrix-input-field"}, 
	                                MatrixInput
	                            );
	                        }.bind(this))
	                    );
	                }.bind(this))
	            ), 
	            this.props.suffix && React.createElement("div", {className: "matrix-suffix"}, 
	                React.createElement(Renderer, {content: this.props.suffix})
	            )
	        );
	    },

	    getInputPaths: function() {
	        var inputPaths = [];
	        var maxRows = this.props.matrixBoardSize[0];
	        var maxCols = this.props.matrixBoardSize[1];

	        _(maxRows).times(function(row)  {
	            _(maxCols).times(function(col)  {
	                var inputPath = getInputPath(row, col);
	                inputPaths.push(inputPath);
	            });
	        });

	        return inputPaths;
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "number";
	    },

	    _handleFocus: function(row, col) {
	        this.props.onFocus(getInputPath(row, col));
	    },

	    _handleBlur: function(row, col) {
	        this.props.onBlur(getInputPath(row, col));
	    },

	    focus: function() {
	        this.focusInputPath(getDefaultPath());
	        return true;
	    },

	    focusInputPath: function(path) {
	        var inputID = getRefForPath(path);
	        this.refs[inputID].focus();
	    },

	    blurInputPath: function(path) {
	        if (path.length === 0) {
	            path = getDefaultPath();
	        }

	        var inputID = getRefForPath(path);
	        this.refs[inputID].blur();
	    },

	    getDOMNodeForPath: function(inputPath) {
	        var inputID = getRefForPath(inputPath);
	        return this.refs[inputID].getDOMNode();
	    },

	    setInputValue: function(inputPath, value, callback) {
	        var row = getRowFromPath(inputPath);
	        var col = getColumnFromPath(inputPath);
	        this.onValueChange(row, col, value, callback);
	    },

	    handleKeyDown: function (row, col, e) {
	        var maxRow = this.props.matrixBoardSize[0];
	        var maxCol = this.props.matrixBoardSize[1];
	        var enterTheMatrix = null;

	        var curInput = this.refs[getRefForPath(getInputPath(row, col))];
	        var curValueString = curInput.getStringValue();
	        var cursorStartPosition = curInput.getSelectionStart();
	        var cursorEndPosition = curInput.getSelectionEnd();

	        var nextPath = null;
	        if (e.key === "ArrowUp" && row > 0) {
	            nextPath = getInputPath(row - 1, col);
	        } else if (e.key === "ArrowDown" && row + 1 < maxRow) {
	            nextPath = getInputPath(row + 1, col);
	        } else if (e.key === "ArrowLeft" && col > 0) {
	            if (cursorStartPosition === 0 && cursorEndPosition === 0) {
	                // Only go to next input if we're at the *start* of the content
	                nextPath = getInputPath(row, col - 1);
	            }
	        } else if (e.key === "ArrowRight" && col + 1 < maxCol) {
	            if (cursorStartPosition === curValueString.length) {
	                // Only go to next input if we're at the *end* of the content
	                nextPath = getInputPath(row, col + 1);
	            }
	        } else if (e.key === "Enter") {
	            enterTheMatrix = this.state.enterTheMatrix + 1;
	        } else if (e.key === "Escape") {
	            enterTheMatrix = 0;
	        }

	        if (nextPath) {
	            // Prevent the cursor from jumping again inside the next input
	            e.preventDefault();

	            // Focus the input and move the cursor to the end of it.
	            var input = this.refs[getRefForPath(nextPath)];

	            // Multiply by 2 to ensure the cursor always ends up at the end;
	            // Opera sometimes sees a carriage return as 2 characters.
	            var inputValString = input.getStringValue();
	            var valueLength = inputValString.length * 2;

	            input.focus();
	            if (e.key === "ArrowRight") {
	                input.setSelectionRange(0, 0);
	            } else {
	                input.setSelectionRange(valueLength, valueLength);
	            }
	        }

	        if (enterTheMatrix != null) {
	            this.setState({
	                enterTheMatrix: enterTheMatrix
	            });
	        }
	    },

	    onValueChange: function(row, column, value, cb) {
	        var answers = _.map(this.props.answers, _.clone);
	        if (!answers[row]) {
	            answers[row] = [];
	        }
	        answers[row][column] = value;
	        this.props.onChange({
	            answers: answers
	        }, cb);
	    },

	    getUserInput: function() {
	        return {
	            answers: this.props.answers
	        };
	    },

	    simpleValidate: function(rubric) {
	        return Matrix.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Matrix, {
	    validate: function(state, rubric) {
	        var solution = rubric.answers;
	        var supplied = state.answers;
	        var solutionSize = getMatrixSize(solution);
	        var suppliedSize = getMatrixSize(supplied);

	        var incorrectSize = solutionSize[0] !== suppliedSize[0] ||
	                solutionSize[1] !== suppliedSize[1];

	        var createValidator = Khan.answerTypes
	                                  .number.createValidatorFunctional;
	        var message = null;
	        var hasEmptyCell = false;
	        var incorrect = false;
	        _(suppliedSize[0]).times(function(row)  {
	            _(suppliedSize[1]).times(function(col)  {
	                if (supplied[row][col] == null ||
	                        supplied[row][col].toString().length === 0) {
	                    hasEmptyCell = true;
	                }
	                var validator = createValidator(
	                        solution[row][col],
	                        { simplify: true }
	                    );
	                var result = validator(supplied[row][col]);
	                if (result.message) {
	                    message = result.message;
	                }
	                if (!result.correct) {
	                    incorrect = true;
	                }
	            });
	        });

	        if (hasEmptyCell) {
	            return {
	                type: "invalid",
	                message: $._("Make sure you fill in all cells in the matrix.")
	            };
	        }

	        if (incorrectSize) {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }

	        return {
	            type: "points",
	            earned: incorrect ? 0 : 1,
	            total: 1,
	            message: message
	        };
	    }
	});

	var MatrixEditor = React.createClass({displayName: 'MatrixEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        matrixBoardSize: React.PropTypes.arrayOf(
	            React.PropTypes.number
	        ).isRequired,
	        answers: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(
	                React.PropTypes.number
	            )
	        ),
	        prefix: React.PropTypes.string,
	        suffix: React.PropTypes.string,
	        cursorPosition: React.PropTypes.arrayOf(
	            React.PropTypes.number
	        )
	    },

	    getDefaultProps: function() {
	        return {
	            matrixBoardSize: [3, 3],
	            answers: [[]],
	            prefix: "",
	            suffix: "",
	            cursorPosition: [0, 0]
	        };
	    },

	    render: function() {
	        var matrixProps = _.extend({
	            numericInput: true,
	            onBlur: function()  {},
	            onFocus: function()  {}
	        }, this.props);
	        return React.createElement("div", {className: "perseus-matrix-editor"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                " ", "Max matrix size:", " ", 
	                React.createElement(RangeInput, {
	                    value: this.props.matrixBoardSize, 
	                    onChange: this.onMatrixBoardSizeChange, 
	                    format: this.props.labelStyle, 
	                    useArrowKeys: true})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(Matrix, React.__spread({},  matrixProps))
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                " ", "Matrix prefix:", " ", 
	                React.createElement(Editor, {
	                    ref: "prefix", 
	                    content: this.props.prefix, 
	                    widgetEnabled: false, 
	                    onChange: function(newProps)  {
	                        this.change({ prefix: newProps.content });
	                    }.bind(this)})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                " ", "Matrix suffix:", " ", 
	                React.createElement(Editor, {
	                    ref: "suffix", 
	                    content: this.props.suffix, 
	                    widgetEnabled: false, 
	                    onChange: function(newProps)  {
	                        this.change({ suffix: newProps.content });
	                    }.bind(this)})
	            )
	        );
	    },

	    onMatrixBoardSizeChange: function (range) {
	        var matrixSize = getMatrixSize(this.props.answers);
	        if (range[0] !== null && range[1] !== null) {
	            range = [
	                Math.round(Math.min(Math.max(range[0], 1), MAX_BOARD_SIZE)),
	                Math.round(Math.min(Math.max(range[1], 1), MAX_BOARD_SIZE))
	            ];
	            var answers = _(Math.min(range[0], matrixSize[0])).times(function(row)  {
	                return _(Math.min(range[1], matrixSize[1])).times(function(col)  {
	                    return this.props.answers[row][col];
	                }.bind(this));
	            }.bind(this));
	            this.props.onChange({
	                matrixBoardSize: range,
	                answers: answers
	            });
	        }
	    }
	});

	var propTransform = function(editorProps)  {
	    // Remove answers before passing to widget
	    var blankAnswers = _(editorProps.matrixBoardSize[0]).times(function() {
	        return stringArrayOfSize(editorProps.matrixBoardSize[1]);
	    });
	    editorProps = _.pick(editorProps, "matrixBoardSize", "prefix", "suffix");
	    return _.extend(editorProps, {
	        answers: blankAnswers
	    });
	};

	module.exports = {
	    name: "matrix",
	    displayName: "Matrix",
	    widget: Matrix,
	    editor: MatrixEditor,
	    transform: propTransform
	};


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var InfoTip        = __webpack_require__(75);
	var PropCheckBox   = __webpack_require__(65);
	var Renderer       = __webpack_require__(15);
	var Sortable       = __webpack_require__(98);
	var TextListEditor = __webpack_require__(79);

	var shuffle = __webpack_require__(5).shuffle;
	var seededRNG = __webpack_require__(5).seededRNG;

	var Matcher = React.createClass({displayName: 'Matcher',
	    propTypes: {
	        left: React.PropTypes.array,
	        right: React.PropTypes.array,
	        labels: React.PropTypes.array,
	        orderMatters: React.PropTypes.bool,
	        padding: React.PropTypes.bool,
	        problemNum: React.PropTypes.number,
	        onChange: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            left: [],
	            right: [],
	            labels: ["", ""],
	            orderMatters: false,
	            padding: true,
	            problemNum: 0,
	            onChange: function() {}
	        };
	    },

	    getInitialState: function() {
	        return {
	            leftHeight: 0,
	            rightHeight: 0
	        };
	    },

	    render: function() {
	        // Use the same random() function to shuffle both columns sequentially
	        var rng = seededRNG(this.props.problemNum);

	        var left;
	        if (!this.props.orderMatters) {
	            // If the order doesn't matter, don't shuffle the left column
	            left = this.props.left;
	        } else {
	            left = shuffle(this.props.left, rng, /* ensurePermuted */ true);
	        }

	        var right = shuffle(this.props.right, rng, /* ensurePermuted */ true);

	        var showLabels = _.any(this.props.labels);
	        var constraints = {height: _.max([this.state.leftHeight,
	            this.state.rightHeight])};

	        return React.createElement("div", {className: "perseus-widget-matcher ui-helper-clearfix"}, 
	            React.createElement("div", {className: "column"}, 
	                showLabels && React.createElement("div", {className: "column-label"}, 
	                    React.createElement(Renderer, {content: this.props.labels[0] || "..."})
	                ), 
	                React.createElement(Sortable, {
	                    options: left, 
	                    layout: "vertical", 
	                    padding: this.props.padding, 
	                    disabled: !this.props.orderMatters, 
	                    constraints: constraints, 
	                    onMeasure: this.onMeasureLeft, 
	                    onChange: this.props.onChange, 
	                    ref: "left"})
	            ), 
	            React.createElement("div", {className: "column"}, 
	                showLabels && React.createElement("div", {className: "column-label"}, 
	                    React.createElement(Renderer, {content: this.props.labels[1] || "..."})
	                ), 
	                React.createElement(Sortable, {
	                    options: right, 
	                    layout: "vertical", 
	                    padding: this.props.padding, 
	                    constraints: constraints, 
	                    onMeasure: this.onMeasureRight, 
	                    onChange: this.props.onChange, 
	                    ref: "right"})
	            )
	        );
	    },

	    onMeasureLeft: function(dimensions) {
	        var height = _.max(dimensions.heights);
	        this.setState({leftHeight: height});
	    },

	    onMeasureRight: function(dimensions) {
	        var height = _.max(dimensions.heights);
	        this.setState({rightHeight: height});
	    },

	    getUserInput: function() {
	        return {
	            left: this.refs.left.getOptions(),
	            right: this.refs.right.getOptions()
	        };
	    },

	    simpleValidate: function(rubric) {
	        return Matcher.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(Matcher, {
	    validate: function(state, rubric) {
	        var correct = _.isEqual(state.left, rubric.left) &&
	                      _.isEqual(state.right, rubric.right);

	        return {
	            type: "points",
	            earned: correct ? 1 : 0,
	            total: 1,
	            message: null
	        };
	    }
	});


	var MatcherEditor = React.createClass({displayName: 'MatcherEditor',
	    propTypes: {
	        left: React.PropTypes.array,
	        right: React.PropTypes.array,
	        labels: React.PropTypes.array,
	        orderMatters: React.PropTypes.bool,
	        padding: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            left: ["$x$", "$y$", "$z$"],
	            right: ["$1$", "$2$", "$3$"],
	            labels: ["test", "label"],
	            orderMatters: false,
	            padding: true
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-matcher-editor"}, 
	            React.createElement("div", null, 
	                ' ', "Correct answer:", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Enter the correct answers here. The preview on the right" + ' ' +
	                    "will show the cards in a randomized order, which is how the" + ' ' +
	                    "student will see them.")
	                )
	            ), 
	            React.createElement("div", {className: "ui-helper-clearfix"}, 
	                React.createElement(TextListEditor, {
	                    options: this.props.left, 
	                    onChange: function(options, cb)  {
	                        this.props.onChange({left: options}, cb);
	                    }.bind(this), 
	                    layout: "vertical"}), 
	                React.createElement(TextListEditor, {
	                    options: this.props.right, 
	                    onChange: function(options, cb)  {
	                        this.props.onChange({right: options}, cb);
	                    }.bind(this), 
	                    layout: "vertical"})
	            ), 
	            React.createElement("span", null, 
	                ' ', "Labels:", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "These are entirely optional.")
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("input", {type: "text", 
	                    defaultValue: this.props.labels[0], 
	                    onChange: this.onLabelChange.bind(this, 0)}), 
	                React.createElement("input", {type: "text", 
	                    defaultValue: this.props.labels[1], 
	                    onChange: this.onLabelChange.bind(this, 1)})
	            ), 
	            React.createElement("div", null, 
	                React.createElement(PropCheckBox, {
	                    label: "Order of the matched pairs matters:", 
	                    orderMatters: this.props.orderMatters, 
	                    onChange: this.props.onChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "With this option enabled, only the order provided above" + ' ' +
	                    "will be treated as correct. This is useful when ordering is" + ' ' +
	                    "significant, such as in the context of a proof."), 
	                    React.createElement("p", null, "If disabled, pairwise matching is sufficient. To make" + ' ' +
	                    "this clear, the left column becomes fixed in the provided" + ' ' +
	                    "order and only the cards in the right column can be" + ' ' +
	                    "moved.")
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement(PropCheckBox, {
	                    label: "Padding:", 
	                    padding: this.props.padding, 
	                    onChange: this.props.onChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Padding is good for text, but not needed for images.")
	                )
	            )
	        );
	    },

	    onLabelChange: function(index, e) {
	        var labels = _.clone(this.props.labels);
	        labels[index] = e.target.value;
	        this.props.onChange({labels: labels});
	    },

	    getSaveWarnings: function() {
	        if (this.props.left.length !== this.props.right.length) {
	            return [
	                "The two halves of the matcher have different numbers" +
	                " of cards."
	            ];
	        }
	        return [];
	    },

	    serialize: function() {
	        return _.pick(this.props,
	            "left", "right", "labels", "orderMatters", "padding"
	        );
	    }
	});

	module.exports = {
	    name: "matcher",
	    displayName: "Two column matcher",
	    widget: Matcher,
	    editor: MatcherEditor
	};


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var React        = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var InfoTip       = __webpack_require__(75);
	var NumberInput   = __webpack_require__(94);
	var PropCheckBox  = __webpack_require__(65);
	var RangeInput    = __webpack_require__(92);

	var defaultImage = {
	    url: null,
	    top: 0,
	    left: 0
	};

	var Measurer = React.createClass({displayName: 'Measurer',
	    propTypes: {
	        box: React.PropTypes.arrayOf(React.PropTypes.number),
	        image: React.PropTypes.shape({
	            url: React.PropTypes.string,
	            top: React.PropTypes.number,
	            left: React.PropTypes.number
	        }),
	        showProtractor: React.PropTypes.bool,
	        protractorX: React.PropTypes.number,
	        protractorY: React.PropTypes.number,
	        showRuler: React.PropTypes.bool,
	        rulerLabel: React.PropTypes.string,
	        rulerTicks: React.PropTypes.number,
	        rulerPixels: React.PropTypes.number,
	        rulerLength: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            box: [480, 480],
	            image: {},
	            showProtractor: true,
	            protractorX: 7.5,
	            protractorY: 0.5,
	            showRuler: false,
	            rulerLabel: "",
	            rulerTicks: 10,
	            rulerPixels: 40,
	            rulerLength: 10
	        };
	    },

	    getInitialState: function() {
	        return {};
	    },

	    render: function() {
	        var image = _.extend({}, defaultImage, this.props.image);
	        return React.createElement("div", {
	                className: 
	                    "perseus-widget perseus-widget-measurer " +
	                    "graphie-container above-scratchpad", 
	                
	                style: {width: this.props.box[0], height: this.props.box[1]}}, 
	            image.url &&
	                React.createElement("img", {
	                    src: image.url, 
	                    style: {
	                        top: image.top,
	                        left: image.left
	                    }}), 
	            
	            React.createElement("div", {className: "graphie", ref: "graphieDiv"})
	        );
	    },

	    componentDidMount: function() {
	        this.setupGraphie();
	    },

	    componentDidUpdate: function(prevProps) {
	        var shouldSetupGraphie = _.any([
	                "box", "showProtractor", "showRuler", "rulerLabel",
	                "rulerTicks", "rulerPixels", "rulerLength"
	            ],
	            function(prop) {
	                return prevProps[prop] !== this.props[prop];
	            },
	            this
	        );

	        if (shouldSetupGraphie) {
	            this.setupGraphie();
	        }
	    },

	    setupGraphie: function() {
	        var graphieDiv = this.refs.graphieDiv.getDOMNode();
	        $(graphieDiv).empty();
	        var graphie = this.graphie = KhanUtil.createGraphie(graphieDiv);

	        var scale = [40, 40];
	        var range = [
	            [0, this.props.box[0] / scale[0]],
	            [0, this.props.box[1] / scale[1]]
	        ];
	        graphie.init({
	            range: range,
	            scale: scale
	        });
	        graphie.addMouseLayer({
	            allowScratchpad: true
	        });

	        if (this.protractor) {
	            this.protractor.remove();
	        }

	        if (this.props.showProtractor) {
	            this.protractor = graphie.protractor([
	                this.props.protractorX,
	                this.props.protractorY
	            ]);
	        }

	        if (this.ruler) {
	            this.ruler.remove();
	        }

	        if (this.props.showRuler) {
	            this.ruler = graphie.ruler({
	                center: [
	                    (range[0][0] + range[0][1]) / 2,
	                    (range[1][0] + range[1][1]) / 2
	                ],
	                label: this.props.rulerLabel,
	                pixelsPerUnit: this.props.rulerPixels,
	                ticksPerUnit: this.props.rulerTicks,
	                units: this.props.rulerLength
	            });
	        }
	    },

	    getUserInput: function() {
	        return {};
	    },

	    simpleValidate: function(rubric) {
	        // TODO(joel) - I don't understand how this is useful!
	        return Measurer.validate(this.getUserInput(), rubric);
	    },

	    focus: $.noop
	});


	_.extend(Measurer, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 1,
	            total: 1,
	            message: null
	        };
	    }
	});


	var MeasurerEditor = React.createClass({displayName: 'MeasurerEditor',
	    mixins: [Changeable, EditorJsonify],
	    className: "perseus-widget-measurer",

	    propTypes: {
	        box: React.PropTypes.arrayOf(React.PropTypes.number),
	        image: React.PropTypes.shape({
	            url: React.PropTypes.string,
	            top: React.PropTypes.number,
	            left: React.PropTypes.number
	        }),
	        showProtractor: React.PropTypes.bool,
	        showRuler: React.PropTypes.bool,
	        rulerLabel: React.PropTypes.string,
	        rulerTicks: React.PropTypes.number,
	        rulerPixels: React.PropTypes.number,
	        rulerLength: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            box: [480, 480],
	            image: {},
	            showProtractor: true,
	            showRuler: false,
	            rulerLabel: "",
	            rulerTicks: 10,
	            rulerPixels: 40,
	            rulerLength: 10
	        };
	    },

	    render: function() {
	        var image = _.extend({}, defaultImage, this.props.image);

	        return React.createElement("div", {className: "perseus-widget-measurer"}, 
	            React.createElement("div", null, "Image displayed under protractor and/or ruler:"), 
	            React.createElement("div", null, "URL:", ' ', 
	                React.createElement("input", {type: "text", 
	                        className: "perseus-widget-measurer-url", 
	                        ref: "image-url", 
	                        defaultValue: image.url, 
	                        onChange: this._changeUrl}), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "Create an image in graphie, or use the \"Add image\" function" + ' ' +
	                "to create a background.")
	            )
	            ), 
	            image.url && React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", {className: "perseus-widget-left-col"}, 
	                    "Pixels from top:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        placeholder: 0, 
	                        onChange: this._changeTop, 
	                        value: image.top, 
	                        useArrowKeys: true})
	                ), 
	                React.createElement("label", {className: "perseus-widget-right-col"}, 
	                    "Pixels from left:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        placeholder: 0, 
	                        onChange: this._changeLeft, 
	                        value: image.left, 
	                        useArrowKeys: true})
	                )
	            ), 
	            React.createElement("div", null, "Containing area [width, height]:", ' ', 
	                React.createElement(RangeInput, {
	                    onChange: this.change("box"), 
	                    value: this.props.box, 
	                    useArrowKeys: true})
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    React.createElement(PropCheckBox, {label: "Show ruler", 
	                        showRuler: this.props.showRuler, 
	                        onChange: this.props.onChange})
	                ), 
	                React.createElement("div", {className: "perseus-widget-right-col"}, 
	                    React.createElement(PropCheckBox, {label: "Show protractor", 
	                        showProtractor: this.props.showProtractor, 
	                        onChange: this.props.onChange})
	                )
	            ), 
	            this.props.showRuler && React.createElement("div", null, 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    ' ', "Ruler label:", ' ', 
	                    React.createElement("select", {
	                        onChange: function(e) 
	                            {return this.change("rulerLabel", e.target.value);}.bind(this), 
	                        value: this.props.rulerLabel}, 
	                            React.createElement("option", {value: ""}, "None"), 
	                            React.createElement("optgroup", {label: "Metric"}, 
	                                this.renderLabelChoices([
	                                    ["milimeters", "mm"],
	                                    ["centimeters", "cm"],
	                                    ["meters", "m"],
	                                    ["kilometers", "km"]
	                                ])
	                            ), 
	                            React.createElement("optgroup", {label: "Imperial"}, 
	                                this.renderLabelChoices([
	                                    ["inches", "in"],
	                                    ["feet", "ft"],
	                                    ["yards", "yd"],
	                                    ["miles", "mi"]
	                                ])
	                            )
	                    )
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    ' ', "Ruler ticks:", ' ', 
	                    React.createElement("select", {
	                        onChange: function(e) 
	                            {return this.change("rulerTicks", +e.target.value);}.bind(this), 
	                        value: this.props.rulerTicks}, 
	                            _.map([1, 2, 4, 8, 10, 16], function(n) {
	                                return React.createElement("option", {key: n, value: n}, n);
	                            })
	                    )
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Ruler pixels per unit:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        placeholder: 40, 
	                        onChange: this.change("rulerPixels"), 
	                        value: this.props.rulerPixels, 
	                        useArrowKeys: true})
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Ruler length in units:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        placeholder: 10, 
	                        onChange: this.change("rulerLength"), 
	                        value: this.props.rulerLength, 
	                        useArrowKeys: true})
	                )
	            )
	            )
	        );
	    },

	    _changeUrl: function(e) {
	        this._changeImage("url", e.target.value);
	    },

	    _changeTop: function(newTop) {
	        this._changeImage("top", newTop);
	    },

	    _changeLeft: function(newLeft) {
	        this._changeImage("left", newLeft);
	    },

	    _changeImage: function(subProp, newValue) {
	        var image = _.clone(this.props.image);
	        image[subProp] = newValue;
	        this.change("image", image);
	    },

	    renderLabelChoices: function(choices) {
	        return _.map(choices, function(nameAndValue) {
	            var $__0=   nameAndValue,name=$__0[0],value=$__0[1];
	            return React.createElement("option", {key: value, value: value}, name);
	        });
	    }
	});

	propUpgrades = {
	    1: function(v0props)  {
	        var v1props = _(v0props).chain()
	            .omit("imageUrl", "imageTop", "imageLeft")
	            .extend({
	                image: {
	                    url: v0props.imageUrl,
	                    top: v0props.imageTop,
	                    left: v0props.imageLeft
	                }
	            })
	            .value();
	        return v1props;
	    }
	};

	module.exports = {
	    name: "measurer",
	    displayName: "Measurer",
	    widget: Measurer,
	    editor: MeasurerEditor,
	    version: {major: 1, minor: 0},
	    propUpgrades: propUpgrades
	};


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var ButtonGroup  = __webpack_require__(87);
	var InfoTip      = __webpack_require__(75);
	var Interactive2 = __webpack_require__(89);
	var NumberInput  = __webpack_require__(94);
	var PropCheckBox = __webpack_require__(65);
	var RangeInput   = __webpack_require__(92);
	var MathOutput   = __webpack_require__(96);

	var ApiOptions = __webpack_require__(17).Options;

	var Graphie = __webpack_require__(80);
	var MovablePoint = Graphie.MovablePoint;
	var Line = Graphie.Line;
	var Label = Graphie.Label;

	var knumber = __webpack_require__(113).number;
	var kpoint = __webpack_require__(113).point;

	var bound = function(x, gt, lt)  {return Math.min(Math.max(x, gt), lt);};
	var deepEq = __webpack_require__(5).deepEq;
	var assert = __webpack_require__(97).assert;

	var EN_DASH = "\u2013";

	var reverseRel = {
	    ge: "le",
	    gt: "lt",
	    le: "ge",
	    lt: "gt"
	};

	var toggleStrictRel = {
	    ge: "gt",
	    gt: "ge",
	    le: "lt",
	    lt: "le"
	};

	function formatImproper(n, d) {
	    if (d === 1) {
	        return "" + n;
	    } else {
	        return n + "/" + d;
	    }
	}

	function formatMixed(n, d) {
	    if (n < 0) {
	        return "-" + formatMixed(-n, d);
	    }
	    var w = Math.floor(n / d);
	    if (w === 0) {
	        return formatImproper(n, d);
	    } else if (n - w * d === 0) {
	        return "" + w;
	    } else {
	        return w + "\\:" + formatImproper(n - w * d, d);
	    }
	}

	function formatNonReduced(n, d, base) {
	    var factor = Math.floor(base / d);
	    return formatImproper(n * factor, base);
	}

	_label = function(graphie, labelStyle, pos, value, base)  {
	    value = value || pos;

	    // TODO(jack): Find out if any exercises have "decimal ticks" set,
	    // and if so, re-save them and remove this check.
	    if (labelStyle === "decimal" || labelStyle === "decimal ticks") {
	        return graphie.label([pos, -0.53],
	            Math.round(value * 100) / 100, "center");
	    } else if (labelStyle === "improper") {
	        var frac = KhanUtil.toFraction(value);
	        return graphie.label([pos, -0.53],
	                formatImproper(frac[0], frac[1]), "center");
	    } else if (labelStyle === "mixed") {
	        var frac = KhanUtil.toFraction(value);
	        return graphie.label([pos, -0.53],
	                formatMixed(frac[0], frac[1]), "center");
	    } else if (labelStyle === "non-reduced") {
	        var frac = KhanUtil.toFraction(value);
	        return graphie.label([pos, -0.53],
	                formatNonReduced(frac[0], frac[1], base), "center");
	    }
	};

	TickMarks = Graphie.createSimpleClass(function(graphie, props)  {
	    // Avoid infinite loop
	    if (!_.isFinite(props.tickStep) || props.tickStep <= 0) {
	        return []; // this has screwed me for the last time!
	    }

	    var results = [];

	    // For convenience, extract some props into separate variables
	    var range = props.range;
	    var labelRange = props.labelRange;
	    var range = props.range;
	    var leftLabel = labelRange[0] == null ? range[0] : labelRange[0];
	    var rightLabel = labelRange[1] == null ? range[1] : labelRange[1];

	    // Find base via GCD for non-reduced fractions
	    var base;
	    if (props.labelStyle === "non-reduced") {
	        var fractions = [leftLabel, rightLabel];
	        for (var i = 0; i <= props.numDivisions; i++) {
	            var x = range[0] + i * props.tickStep;
	            fractions.push(x);
	        }
	        var getDenom = function(x)  {return knumber.toFraction(x)[1];};
	        var denoms = _.map(fractions, getDenom);
	        base = _.reduce(denoms, function(x, y)  {return KhanUtil.getLCM(x, y);});
	    } else {
	        base = undefined;
	    }

	    // Draw and save the tick marks and tick labels
	    for (var i = 0; i <= props.numDivisions; i++) {
	        var x = range[0] + i * props.tickStep;
	        results.push(graphie.line([x, -0.2], [x, 0.2]));

	        var labelTicks = props.labelTicks;
	        if (labelTicks || props.labelStyle === "decimal ticks") {
	            results.push(_label(graphie, props.labelStyle, x, x, base));
	        }
	    }

	    // Render the text labels
	    graphie.style({color: KhanUtil.DYNAMIC}, function()  {
	        results.push(_label(graphie, props.labelStyle, leftLabel, leftLabel,
	            base));
	        results.push(_label(graphie, props.labelStyle, rightLabel, rightLabel,
	            base));
	    });

	    // Render the labels' lines
	    graphie.style(
	        {
	            stroke: KhanUtil.DYNAMIC,
	            strokeWidth: 3.5
	        },
	        function()  {
	            results.push(graphie.line([leftLabel, -0.2], [leftLabel, 0.2]));
	            results.push(graphie.line([rightLabel, -0.2], [rightLabel, 0.2]));
	        }
	    );

	    return results;
	});


	var NumberLine = React.createClass({displayName: 'NumberLine',
	    mixins: [Changeable],

	    propTypes: {
	        range: React.PropTypes.arrayOf(React.PropTypes.number).isRequired,

	        labelRange: React.PropTypes.array.isRequired,
	        labelStyle: React.PropTypes.string.isRequired,
	        labelTicks: React.PropTypes.bool.isRequired,

	        divisionRange: React.PropTypes.arrayOf(
	            React.PropTypes.number
	        ).isRequired,
	        numDivisions: React.PropTypes.number.isRequired,
	        snapDivisions: React.PropTypes.number.isRequired,

	        isTickCtrl: React.PropTypes.bool.isRequired,
	        isInequality: React.PropTypes.bool.isRequired,

	        numLinePosition: React.PropTypes.number.isRequired,
	        rel: React.PropTypes.oneOf(["lt", "gt", "le", "ge"])
	    },

	    getDefaultProps: function() {
	        return {
	            range: [0, 10],
	            labelStyle: "decimal",
	            labelRange: [null, null],
	            divisionRange: [1, 12],
	            labelTicks: true,
	            isTickCtrl: false,
	            isInequality: false,
	            numLinePosition: 0,
	            snapDivisions: 2,
	            rel: "ge",
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    isValid: function() {
	        var range = this.props.range;
	        var initialX = this.props.numLinePosition;
	        var divisionRange = this.props.divisionRange;

	        initialX = initialX == null ? range[0] : initialX;

	        return range[0] <  range[1] &&
	               initialX >= range[0] &&
	               initialX <= range[1] &&
	               divisionRange[0] < divisionRange[1] &&
	               0 < this.props.numDivisions &&
	               0 < this.props.snapDivisions;
	    },

	    render: function() {
	        var range = this.props.range;
	        var width = range[1] - range[0];
	        var divisionRange = this.props.divisionRange;
	        var divRangeString = divisionRange[0] + EN_DASH + divisionRange[1];
	        var invalidNumDivisions = this.props.numDivisions < divisionRange[0] ||
	                this.props.numDivisions > divisionRange[1];

	        var inequalityControls = React.createElement("div", null, 
	            React.createElement("input", {
	                type: "button", 
	                className: "simple-button", 
	                value: $._("Switch direction"), 
	                onClick: this.handleReverse}), 
	            React.createElement("input", {
	                type: "button", 
	                className: "simple-button", 
	                value: _(["le", "ge"]).contains(this.props.rel) ?
	                        $._("Make circle open") :
	                        $._("Make circle filled"), 
	                onClick: this.handleToggleStrict})
	        );

	        var tickCtrl;
	        if (this.props.isTickCtrl) {
	            var Input;
	            if (this.props.apiOptions.staticRender) {
	                Input = MathOutput;
	            } else {
	                Input = NumberInput;
	            }
	            tickCtrl = React.createElement("label", null, $_(null, "Number of divisions:"), " ", 
	                React.createElement(Input, {
	                    ref: "tick-ctrl", 
	                    value: this.props.numDivisions || divisionRange[0], 
	                    checkValidity: function(val) 
	                        {return val >= divisionRange[0] && val <= divisionRange[1];}, 
	                    onChange: this.onNumDivisionsChange, 
	                    onFocus: this._handleTickCtrlFocus, 
	                    onBlur: this._handleTickCtrlBlur, 
	                    useArrowKeys: true})
	            );
	        }

	        return React.createElement("div", {className: "perseus-widget " +
	                "perseus-widget-interactive-number-line"}, 
	            tickCtrl, 
	            !this.isValid() ?
	                React.createElement("div", {className: "perseus-error"}, 
	                    "Invalid number line configuration."
	                ) :
	                (this.props.isTickCtrl && invalidNumDivisions ?
	                    React.createElement("div", {className: "perseus-error"}, 
	                        $_({divRangeString: divRangeString}, 
	                            "Please make sure the number of divisions is in the" + ' ' +
	                            "range %(divRangeString)s."
	                        )
	                    ) : this._renderGraphie()), 
	            this.props.isInequality && inequalityControls
	        );
	    },

	    onNumDivisionsChange: function(numDivisions, cb) {
	        var divRange = this.props.divisionRange.slice();
	        var width = this.props.range[1] - this.props.range[0];

	        // Don't allow a fraction for the number of divisions
	        numDivisions = Math.round(numDivisions);

	        // Don't allow negative numbers for the number of divisions
	        numDivisions = numDivisions < 0 ? numDivisions * -1 : numDivisions;

	        // If the number of divisions isn't blank, update the number line
	        if (numDivisions) {
	            var nextProps = _.extend({}, this.props, {
	                tickStep: width / numDivisions
	            });

	            var newNumLinePosition = this.snapNumLinePosition(
	                nextProps,
	                this.props.numLinePosition
	            );

	            this.props.onChange({
	                divisionRange: divRange,
	                numDivisions: numDivisions,
	                numLinePosition: newNumLinePosition
	            }, cb);
	        }
	    },

	    _handleTickCtrlFocus: function() {
	        this.props.onFocus(["tick-ctrl"]);
	    },

	    _handleTickCtrlBlur: function() {
	        this.props.onBlur(["tick-ctrl"]);
	    },

	    focus: function() {
	        if (this.props.isTickCtrl) {
	            this.refs["tick-ctrl"].focus();
	            return true;
	        }
	    },

	    focusInputPath: function(path) {
	        if (path.length === 1) {
	            this.refs[path[0]].focus();
	        }
	    },

	    blurInputPath: function(path) {
	        if (path.length === 1) {
	            this.refs[path[0]].blur();
	        }
	    },

	    getInputPaths: function() {
	        if (this.props.isTickCtrl) {
	            return [["tick-ctrl"]];
	        } else {
	            return [];
	        }
	    },

	    getDOMNodeForPath: function(inputPath) {
	        if (inputPath.length === 1) {
	            return this.refs[inputPath[0]].getDOMNode();
	        }
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        if (inputPath.length === 1 && inputPath[0] === "tick-ctrl") {
	            return "number";
	        }
	    },

	    setInputValue: function(inputPath, value, callback) {
	        if (inputPath.length === 1 && inputPath[0] === "tick-ctrl") {
	            this.onNumDivisionsChange(value, callback);
	        }
	    },

	    _renderGraphie: function() {
	        // Position variables
	        var widthInPixels = 400;
	        var range = this.props.range;
	        var width = range[1] - range[0];
	        var scale = width / widthInPixels;
	        var buffer = 30 * scale;

	        // Initiate the graphie without actually drawing anything
	        var left = range[0] - buffer;
	        var right = range[1] + buffer;
	        var bottom = -1;
	        var top = 1;

	        var options = _.pick(this.props, [
	            "range",
	            "isTickCtrl",
	        ]);

	        // TODO(aria): Maybe save this as `this.calculatedProps`?
	        var props = _.extend({}, this.props, {
	            tickStep: width / this.props.numDivisions
	        });

	        return React.createElement(Graphie, {
	                ref: "graphie", 
	                box: [460, 80], 
	                options: options, 
	                onMouseDown: function(coord)  {
	                    this.refs.graphie.movables.numberLinePoint.grab(coord);
	                }.bind(this), 
	                setup: this._setupGraphie}, 
	            React.createElement(TickMarks, React.__spread({},  _.pick(props, [
	                "range",
	                "numDivisions",
	                "labelTicks",
	                "labelStyle",
	                "labelRange",
	                "tickStep"
	            ]))), 
	            this._renderInequality(props), 
	            this._renderNumberLinePoint(props)
	        );
	    },

	    snapNumLinePosition: function(props, numLinePosition) {
	        var left = props.range[0];
	        var right = props.range[1];
	        var snapX = props.tickStep / props.snapDivisions;

	        x = bound(numLinePosition, left, right);
	        x = left + knumber.roundTo(x - left, snapX);
	        assert(_.isFinite(x));
	        return x;
	    },

	    _renderNumberLinePoint: function(props) {
	        var isOpen = _(["lt", "gt"]).contains(props.rel);
	        var normalStyle = {
	            fill: isOpen ? KhanUtil._BACKGROUND : KhanUtil.INTERACTIVE,
	            "stroke-width": isOpen ? 3 : 1
	        };
	        var highlightStyle = {
	            fill: isOpen ? KhanUtil._BACKGROUND : KhanUtil.INTERACTING,
	            "stroke-width": isOpen ? 3 : 1
	        };

	        return React.createElement(MovablePoint, {
	            ref: "numberLinePoint", 
	            pointSize: 6, 
	            coord: [props.numLinePosition, 0], 
	            constraints: [
	                function(coord, prevCoord)  {  // constrain-y
	                    return [coord[0], prevCoord[1]];
	                },
	                function(coord, prevCoord)  {  // snap X
	                    var x = this.snapNumLinePosition(props, coord[0]);
	                    return [x, coord[1]];
	                }.bind(this)
	            ], 
	            normalStyle: normalStyle, 
	            highlightStyle: highlightStyle, 
	            onMove: function(coord)  {
	                this.change({numLinePosition: coord[0]});
	            }.bind(this)});
	    },

	    handleReverse: function() {
	        var newRel = reverseRel[this.props.rel];
	        this.props.onChange({rel: newRel});
	    },

	    handleToggleStrict: function() {
	        var newRel = toggleStrictRel[this.props.rel];
	        this.props.onChange({rel: newRel});
	    },

	    _getInequalityEndpoint: function(props) {
	        var isGreater = _(["ge","gt"]).contains(props.rel);
	        var widthInPixels = 400;
	        var range = props.range;
	        var scale = (range[1] - range[0]) / widthInPixels;
	        var buffer = 30 * scale;
	        var left = range[0] - buffer;
	        var right = range[1] + buffer;
	        var end = isGreater ? [right, 0] : [left, 0];
	        return end;
	    },

	    _renderInequality: function(props) {
	        if (props.isInequality) {
	            var end = this._getInequalityEndpoint(props);
	            var style = {
	                arrows: "->",
	                stroke: KhanUtil.DYNAMIC,
	                strokeWidth: 3.5
	            };

	            return React.createElement(Line, {
	                start: [props.numLinePosition, 0], 
	                end: end, 
	                style: style});
	        } else {
	            return null;
	        }
	    },

	    _setupGraphie: function(graphie, options) {
	        // Ensure a sane configuration to avoid infinite loops
	        if (!this.isValid()) {return;}

	        // Position variables
	        var widthInPixels = 400;
	        var range = options.range;
	        var scale = (range[1] - range[0]) / widthInPixels;
	        var buffer = 30 * scale;

	        // Initiate the graphie without actually drawing anything
	        var left = range[0] - buffer;
	        var right = range[1] + buffer;
	        var bottom = -1;
	        var top = 1;

	        graphie.init({
	            range: [[left, right], [bottom, top]],
	            scale: [1 / scale, 40]
	        });

	        // Draw the number line
	        var center = (range[0] + range[1]) / 2;
	        graphie.line([center, 0], [right, 0], {arrows: "->"});
	        graphie.line([center, 0], [left, 0], {arrows: "->"});
	    },

	    getUserInput: function() {
	        return {
	            numLinePosition: this.props.numLinePosition,
	            rel: this.props.isInequality ? this.props.rel : "eq",
	            numDivisions: this.props.numDivisions,
	            divisionRange: this.props.divisionRange
	        };
	    },

	    simpleValidate: function(rubric) {
	        return NumberLine.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(NumberLine, {
	    validate: function(state, rubric) {
	        var range = rubric.range;
	        var divisionRange = state.divisionRange;
	        var start = rubric.initialX != null ? rubric.initialX : range[0];
	        var startRel = rubric.isInequality ? "ge" : "eq";
	        var correctRel = rubric.correctRel || "eq";
	        var correctPos = knumber.equal(
	                state.numLinePosition,
	                rubric.correctX || 0);
	        var outsideAllowedRange = state.numDivisions > divisionRange[1] ||
	                state.numDivisions < divisionRange[0];

	        if (state.isTickCrtl && outsideAllowedRange) {
	            return {
	                type: "invalid",
	                message: "Number of divisions is outside the allowed range."
	            };
	        } else if (correctPos && correctRel === state.rel) {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: null
	            };
	        } else if (state.numLinePosition === start && state.rel === startRel) {
	            // We're where we started.
	            return {
	                type: "invalid",
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});


	var NumberLineEditor = React.createClass({displayName: 'NumberLineEditor',
	    getDefaultProps: function() {
	        return {
	            range: [0, 10],
	            labelRange: [null, null],
	            divisionRange: [1, 12],
	            labelStyle: "decimal",
	            labelTicks: true,
	            numDivisions: 5,
	            tickStep: null,
	            snapDivisions: 2,
	            correctRel: "eq",
	            correctX: null,
	            initialX: null
	        };
	    },

	    mixins: [EditorJsonify],

	    render: function() {
	        var range = this.props.range;
	        var labelRange = this.props.labelRange;
	        var divisionRange = this.props.divisionRange;

	        range[0] = +range[0]; range[1] = +range[1];

	        var width = range[1] - range[0];
	        var numDivisions = this.props.numDivisions;
	        var snapDivisions = this.props.snapDivisions;
	        var tickStep = this.props.tickStep;
	        var isTickCtrl = this.props.isTickCtrl;

	        if (!isTickCtrl) {
	            // this will help constrain the answer to what is reachable
	            step = tickStep ? tickStep / snapDivisions :
	                  (width / numDivisions) / snapDivisions;
	        } else {
	            // but if tickCtrl is on, the range of what is reachable is
	            // rather large, and it becomes obnoxious to check for this
	            step = null;
	        }

	        var labelStyleEditorButtons = [
	              {value: "decimal", content: "0.75", title: "Decimals",},
	              {value: "improper", content: "\u2077\u2044\u2084",
	                title: "Improper fractions"},
	              {value: "mixed", content: "1\u00BE",
	                title: "Mixed numbers"},
	              {value: "non-reduced", content: "\u2078\u2044\u2084",
	                title: "Non-reduced"}];

	        return React.createElement("div", {className: "perseus-widget-number-line-editor"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Correct x", 
	                " ", 
	                React.createElement("select", {value: this.props.correctRel, 
	                  onChange: this.onChangeRelation}, 
	                    React.createElement("option", {value: "eq"}, " = "), 
	                    React.createElement("option", {value: "lt"}, " < "), 
	                    React.createElement("option", {value: "gt"}, " > "), 
	                    React.createElement("option", {value: "le"}, " ≤ "), 
	                    React.createElement("option", {value: "ge"}, " ≥ ")
	                ), 
	                " ", 
	                React.createElement(NumberInput, {
	                    value: this.props.correctX, 
	                    format: this.props.labelStyle, 
	                    onChange: this.onNumChange.bind(this, "correctX"), 
	                    checkValidity: function(val) 
	                        {return val >= range[0] && val <= range[1] &&
	                        (!step || knumber.isInteger((val - range[0]) / step));}, 
	                    
	                    placeholder: "answer", size: "normal", 
	                    useArrowKeys: true}), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "This is the correct answer. The answer is validated" + ' ' +
	                    "(as right or wrong) by using only the end position of the" + ' ' +
	                    "point and the relation (=, <, >, ≤, ≥)"
	                ))
	            ), 

	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, 
	                    "Position:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        value: this.props.initialX, 
	                        format: this.props.labelStyle, 
	                        onChange: this.onNumChange.bind(this, "initialX"), 
	                        placeholder: range[0], 
	                        checkValidity: function(val)  {
	                            return (val >= range[0]) && (val <= range[1]);
	                        }, 
	                        useArrowKeys: true})
	                ), 
	                " \u2208 ", /* element of (little E) symbol */
	                React.createElement(RangeInput, {
	                    value: range, 
	                    onChange: this.onRangeChange, 
	                    format: this.props.labelStyle, 
	                    useArrowKeys: true}), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "This controls the initial position of the point along the" + ' ' +
	                    "number line and the ", React.createElement("strong", null, "range"), ", the position" + ' ' +
	                    "of the endpoints of the number line. Setting the range" + ' ' +
	                    "constrains the position of the answer and the labels."
	                ))
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    "Labels:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        value: labelRange[0], placeholder: range[0], 
	                        format: this.props.labelStyle, 
	                        checkValidity: function(val) 
	                            {return val >= range[0] && val <= range[1];}, 
	                        onChange: this.onLabelRangeChange.bind(this, 0), 
	                        useArrowKeys: true}), 
	                    React.createElement("span", null, " & "), 
	                    React.createElement(NumberInput, {
	                        value: labelRange[1], placeholder: range[1], 
	                        format: this.props.labelStyle, 
	                        checkValidity: function(val) 
	                            {return val >= range[0] && val <= range[1];}, 
	                        onChange: this.onLabelRangeChange.bind(this, 1), 
	                        useArrowKeys: true}), 
	                    React.createElement(InfoTip, null, React.createElement("p", null, 
	                        "This controls the position of the left / right labels." + ' ' +
	                        "By default, the labels are set by the range ", React.createElement("br", null), 
	                        React.createElement("strong", null, "Note:"), " Ensure that the labels line up" + ' ' +
	                        "with the tick marks, or it may be confusing for users."
	                    ))
	                )
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                "Style:", 
	                " ", 
	                React.createElement(ButtonGroup, {
	                    allowEmpty: false, 
	                    value: this.props.labelStyle, 
	                    buttons: labelStyleEditorButtons, 
	                    onChange: this.onLabelStyleChange}), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "This controls the styling of the labels for the two" + ' ' +
	                    "main labels as well as all the tick mark labels," + ' ' +
	                    "if applicable. Your choices are decimal," + ' ' +
	                    "improper fractions, mixed fractions, and non-reduced" + ' ' +
	                    "fractions."
	                ))
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    React.createElement(PropCheckBox, {
	                        label: "Show tick controller", 
	                        isTickCtrl: this.props.isTickCtrl, 
	                        onChange: this.props.onChange})
	                ), 
	                React.createElement("div", {className: "perseus-widget-right-col"}, 
	                    React.createElement(PropCheckBox, {
	                        label: "Show label ticks", 
	                        labelTicks: this.props.labelTicks, 
	                        onChange: this.props.onChange})
	                )
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                isTickCtrl && React.createElement("span", null, 
	                    React.createElement("label", null, 
	                        "Start num divisions at", 
	                        " ", 
	                        React.createElement(NumberInput, {
	                            value: this.props.numDivisions || null, 
	                            format: "decimal", 
	                            onChange: this.onNumDivisionsChange, 
	                            checkValidity: function(val)  {
	                                return (val >= divisionRange[0]) &&
	                                    (val <= divisionRange[1]);
	                            }, 
	                            placeholder: width / this.props.tickStep, 
	                            useArrowKeys: true})
	                    ), 
	                    React.createElement(InfoTip, null, React.createElement("p", null, 
	                        "This controls the number (and position) of the tick" + ' ' +
	                        "marks. The number of divisions is constrained to", 
	                        " " + divisionRange[0] + EN_DASH + divisionRange[1], ".", 
	                        React.createElement("br", null), 
	                        React.createElement("strong", null, "Note:"), " The user will be able to specify" + ' ' +
	                        "the number of divisions in a number input."
	                    ))), 
	                !isTickCtrl && React.createElement("span", null, 
	                    React.createElement("label", null, 
	                        "Num divisions:", 
	                        " ", 
	                        React.createElement(NumberInput, {
	                            value: this.props.numDivisions || null, 
	                            format: "decimal", 
	                            onChange: this.onNumDivisionsChange, 
	                            checkValidity: function(val)  {
	                                return (val >= divisionRange[0]) &&
	                                    (val <= divisionRange[1]);
	                            }, 
	                            placeholder: width / this.props.tickStep, 
	                            useArrowKeys: true})
	                    ), 
	                    " ", 
	                    React.createElement("label", null, 
	                        "or tick step:", 
	                        " ", 
	                        React.createElement(NumberInput, {
	                            value: this.props.tickStep || null, 
	                            format: this.props.labelStyle, 
	                            onChange: this.onTickStepChange, 
	                            checkValidity: function(val)  {
	                                return val > 0 && val <= width;
	                            }, 
	                            placeholder: width / this.props.numDivisions, 
	                            useArrowKeys: true})
	                    ), 
	                    React.createElement(InfoTip, null, React.createElement("p", null, 
	                        "This controls the number (and position) of the tick" + ' ' +
	                        "marks; you can either set the number of divisions (2" + ' ' +
	                        "divisions would split the entire range in two halves)," + ' ' +
	                        "or the tick step (the distance between ticks) and the" + ' ' +
	                        "other value will be updated accordingly. ", React.createElement("br", null), 
	                        React.createElement("strong", null, "Note:"), " There is no check to see if" + ' ' +
	                        "labels coordinate with the tick marks, which may be" + ' ' +
	                        "confusing for users if the blue labels and black ticks" + ' ' +
	                        "are off-step."
	                    )))
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, 
	                    "Snap increments per tick:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        value: snapDivisions, 
	                        checkValidity: function(val)  {return val > 0;}, 
	                        format: this.props.labelStyle, 
	                        onChange: this.onNumChange.bind(this, "snapDivisions"), 
	                        useArrowKeys: true})
	                ), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "This determines the number of different places the point" + ' ' +
	                    "will snap between two adjacent tick marks. ", React.createElement("br", null), 
	                    React.createElement("strong", null, "Note:"), "Ensure the required number of" + ' ' +
	                    "snap increments is provided to answer the question."
	                ))
	            )

	        );
	    },

	    onRangeChange: function(range) {
	        // Changing the range constrains the initial position, as well as the
	        // position of the answer and labels. Atm, it just marks them as
	        // invalid and prevents the number line from showing; it was annoying
	        // to change it for them, because if they're typing in fractions,
	        // it registers one-at-a-time and messes things up.
	        this.props.onChange({range: range});
	    },

	    onLabelRangeChange: function(i, num) {
	        var range = this.props.range.slice(),
	            labelRange = this.props.labelRange.slice(),
	            otherNum = labelRange[1-i];

	        if (num == null || otherNum == null) {
	            labelRange[i] = num;
	        } else {
	            // If both labels have values, this updates the "appropriate" one.
	            // It enforces that the position of the left label <= right label.
	            // If left otherwise, it makes certain aspects of validation hard.
	            labelRange = [Math.min(num, otherNum), Math.max(num, otherNum)];
	        }

	        this.props.onChange({labelRange: labelRange});
	    },

	    onDivisionRangeChange: function(divisionRange) {
	        var numDivisions = this.props.numDivisions;
	        numDivisions = bound(numDivisions, divisionRange[0], divisionRange[1]);
	        this.props.onChange({
	            divisionRange: divisionRange,
	            numDivisions: numDivisions});
	    },

	    onNumChange: function(key, value) {
	        var opts = {};
	        opts[key] = value;
	        this.props.onChange(opts);
	    },

	    onNumDivisionsChange: function(numDivisions) {
	        var divRange = this.props.divisionRange.slice();

	        if (!_.isFinite(numDivisions)) {
	            numDivisions = null;
	        }

	        // Don't allow a fraction for the number of divisions
	        numDivisions = Math.round(numDivisions);

	        // Don't allow negative numbers for the number of divisions
	        numDivisions = numDivisions < 0 ? numDivisions * -1 : numDivisions;

	        // If the number of divisions isn't blank, update the number line
	        if (numDivisions) {
	            // Constrain numDivisions to be within the allowed range
	            numDivisions = Math.min(
	                divRange[1],
	                Math.max(divRange[0], numDivisions)
	            );

	            this.props.onChange({
	                tickStep: null,
	                divisionRange: divRange,
	                numDivisions: numDivisions,
	            });
	        }
	    },

	    onTickStepChange: function(tickStep) {
	        this.props.onChange({
	            numDivisions: null,
	            tickStep: tickStep,
	        });
	    },

	    onChangeRelation: function(e) {
	        value = e.target.value;
	        this.props.onChange({
	            correctRel: value,
	            isInequality: value !== "eq",
	        });
	    },

	    onLabelStyleChange: function(labelStyle) {
	        this.props.onChange({
	            labelStyle: labelStyle
	        });
	    }
	});

	var NumberLineTransform = function(editorProps)  {
	    var props = _.pick(editorProps, [
	        "range",

	        "labelRange",
	        "labelStyle",
	        "labelTicks",

	        "divisionRange",
	        "snapDivisions",

	        "isTickCtrl",
	        "isInequality"
	    ]);

	    var numLinePosition = (editorProps.initialX != null) ?
	            editorProps.initialX :
	            editorProps.range[0];

	    var width = editorProps.range[1] - editorProps.range[0];

	    var numDivisions;
	    if (editorProps.numDivisions != null) {
	        numDivisions = editorProps.numDivisions;
	    } else if (editorProps.tickStep != null) {
	        numDivisions = width / editorProps.tickStep;
	    } else {
	        numDivisions = undefined; // send to getDefaultProps()
	    }

	    _.extend(props, {
	        numLinePosition: numLinePosition,
	        numDivisions: numDivisions
	    });

	    return props;
	};

	module.exports = {
	    name: "number-line",
	    displayName: "Number line",
	    widget: NumberLine,
	    editor: NumberLineEditor,
	    transform: NumberLineTransform
	};


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable    = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var ButtonGroup = __webpack_require__(87);
	var InfoTip = __webpack_require__(75);
	var InputWithExamples = __webpack_require__(84);
	var MultiButtonGroup = __webpack_require__(90);
	var NumberInput = __webpack_require__(94);
	var ParseTex = __webpack_require__(93).parseTex;
	var PropCheckBox = __webpack_require__(65);
	var TextInput = __webpack_require__(81);

	var ApiClassNames   = __webpack_require__(17).ClassNames;
	var ApiOptions      = __webpack_require__(17).Options;
	var EnabledFeatures = __webpack_require__(56);

	var Editor = __webpack_require__(11);

	var firstNumericalParse = __webpack_require__(5).firstNumericalParse;

	var answerFormButtons = [
	    {title: "Integers", value: "integer", content: "6"},
	    {title: "Decimals", value: "decimal", content: "0.75"},
	    {title: "Proper fractions", value: "proper", content: "\u2157"},
	    {title: "Improper fractions", value: "improper",
	        content: "\u2077\u2044\u2084"},
	    {title: "Mixed numbers", value: "mixed", content: "1\u00BE"},
	    {title: "Numbers with \u03C0", value: "pi", content: "\u03C0"}
	];

	var formExamples = {
	    "integer": function()  {return $._("an integer, like $6$");},
	    "proper": function(form)  {return form.simplify === "optional" ?
	        $._("a *proper* fraction, like $1/2$ or $6/10$") :
	        $._("a *simplified proper* fraction, like $3/5$");},
	    "improper": function(form)  {return form.simplify === "optional" ?
	        $._("an *improper* fraction, like $10/7$ or $14/8$") :
	        $._("a *simplified improper* fraction, like $7/4$");},
	    "mixed": function()  {return $._("a mixed number, like $1\\ 3/4$");},
	    "decimal": function()  {return $._("an *exact* decimal, like $0.75$");},
	    "pi": function()  {return $._("a multiple of pi, like $12\\ \\text{pi}$ or " +
	                "$2/3\\ \\text{pi}$");}
	};

	var NumericInput = React.createClass({displayName: 'NumericInput',
	    propTypes: {
	        currentValue: React.PropTypes.string,
	        size: React.PropTypes.oneOf(["normal", "small"]),
	        enabledFeatures: EnabledFeatures.propTypes,
	        apiOptions: ApiOptions.propTypes,
	        coefficient: React.PropTypes.bool,
	        answerForms: React.PropTypes.arrayOf(React.PropTypes.shape({
	            name: React.PropTypes.string.isRequired,
	            simplify: React.PropTypes.oneOf([
	                "required",
	                "optional"
	            ]).isRequired,
	        })),
	        labelText: React.PropTypes.string,
	        reviewModeRubric: React.PropTypes.object,
	    },

	    getDefaultProps: function() {
	        return {
	            currentValue: "",
	            size: "normal",
	            enabledFeatures: EnabledFeatures.defaults,
	            apiOptions: ApiOptions.defaults,
	            coefficient: false,
	            answerForms: [],
	            labelText: "",
	        };
	    },

	    render: function() {
	        // HACK(johnsullivan): Create a function with shared logic between this
	        // and InputNumber.
	        var rubric = this.props.reviewModeRubric;
	        if (rubric) {
	            var score = this.simpleValidate(rubric);
	            var correct = score.type === "points" &&
	                          score.earned === score.total;

	            var answerBlurb = null;
	            if (!correct) {
	                var correctAnswers = _.filter(
	                    rubric.answers, function(answer)  {return answer.status === "correct";});
	                var answerComponents = _.map(correctAnswers, function(answer, key)  {
	                    // Figure out how this answer is supposed to be displayed
	                    var format = "decimal";
	                    if (answer.answerForms && answer.answerForms[0]) {
	                        // NOTE(johnsullivan): This isn't exactly ideal, but
	                        // it does behave well for all the currently known
	                        // problems. See D14742 for some discussion on
	                        // alternate strategies.
	                        format = answer.answerForms[0]
	                    }

	                    var answerString = KhanUtil.toNumericString(answer.value,
	                                                                format);
	                    if (answer.maxError) {
	                        answerString += " \u00B1 " +
	                            KhanUtil.toNumericString(answer.maxError, format);
	                    }
	                    return React.createElement("span", {key: key, className: "perseus-possible-answer"}, 
	                        answerString
	                    )
	                });
	                answerBlurb = React.createElement("span", {className: "perseus-possible-answers"}, 
	                    answerComponents
	                );
	            }
	        }

	        var classes = {};
	        classes["perseus-input-size-" + this.props.size] = true;
	        classes[ApiClassNames.CORRECT] =
	            rubric && correct && this.props.currentValue;
	        classes[ApiClassNames.INCORRECT] =
	            rubric && !correct && this.props.currentValue;
	        classes[ApiClassNames.UNANSWERED] = rubric && !this.props.currentValue;

	        var input = React.createElement(InputWithExamples, {
	            ref: "input", 
	            value: this.props.currentValue, 
	            onChange: this.handleChange, 
	            className: classNames(classes), 
	            type: this._getInputType(), 
	            examples: this.examples(), 
	            shouldShowExamples: this.shouldShowExamples(), 
	            onFocus: this._handleFocus, 
	            onBlur: this._handleBlur});

	        var inputWithLabel;
	        if (this.props.labelText) {
	            inputWithLabel = React.createElement("label", null, 
	                React.createElement("span", {className: "perseus-sr-only"}, this.props.labelText), 
	                input
	            );
	        } else {
	            inputWithLabel = input;
	        }

	        if (answerBlurb) {
	            return React.createElement("span", {className: "perseus-input-with-answer-blurb"}, 
	                inputWithLabel, 
	                answerBlurb
	            );
	        } else {
	            return inputWithLabel;
	        }
	    },

	    handleChange: function(newValue) {
	        // TODO(johnsullivan): It would be better to support this lower down so
	        // that the input element actually gets marked with the disabled
	        // attribute. Because of how many layers of widgets are below us
	        // though, and because we're using CSS to disable click events (only
	        // unsupported on IE 10), I'm calling this sufficient for now.
	        if (!this.props.apiOptions.readOnly) {
	            this.props.onChange({ currentValue: newValue });
	        }
	    },

	    _getInputType: function() {
	        if (this.props.apiOptions.staticRender) {
	            return "tex";
	        } else {
	            return "text";
	        }
	    },

	    _handleFocus: function() {
	        this.props.onFocus([]);
	    },

	    _handleBlur: function() {
	        this.props.onBlur([]);
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    focusInputPath: function(inputPath) {
	        this.refs.input.focus();
	    },

	    blurInputPath: function(inputPath) {
	        this.refs.input.blur();
	    },

	    getInputPaths: function() {
	        // The widget itself is an input, so we return a single empty list to
	        // indicate this.
	        return [[]];
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "number";
	    },

	    setInputValue: function(path, newValue, cb) {
	        this.props.onChange({
	            currentValue: newValue
	        }, cb);
	    },

	    getUserInput: function() {
	        return {currentValue: this.props.currentValue};
	    },

	    simpleValidate: function(rubric) {
	        return NumericInput.validate(this.getUserInput(), rubric);
	    },

	    shouldShowExamples: function() {
	        var noFormsAccepted = this.props.answerForms.length === 0;
	        var allFormsAccepted = this.props.answerForms.length >=
	                _.size(formExamples);
	        return this.props.enabledFeatures.toolTipFormats &&
	                !noFormsAccepted && !allFormsAccepted;
	    },

	    examples: function() {
	        // if the set of specified forms are empty, allow all forms
	        var forms = this.props.answerForms.length !== 0 ?
	                        this.props.answerForms :
	                        _.map(_.keys(formExamples), function(name)  {
	                            return {
	                                name: name,
	                                simplify: "required"
	                            };
	                        });

	        return _.map(forms, function(form)  {
	            return formExamples[form.name](form);
	        });
	    }
	});

	_.extend(NumericInput, {
	    validate: function(state, rubric) {
	        var allAnswerForms = _.pluck(answerFormButtons, "value");

	        var createValidator = function(answer) 
	            {return Khan.answerTypes.number.createValidatorFunctional(
	                answer.value, {
	                    message: answer.message,
	                    simplify: answer.status === "correct" ?
	                        answer.simplify : "optional",
	                    inexact: true, // TODO(merlob) backfill / delete
	                    maxError: answer.maxError,
	                    forms: (answer.strict && answer.answerForms 
	                            && answer.answerForms.length !== 0) ?
	                            answer.answerForms : allAnswerForms
	            });};

	        // We may have received TeX; try to parse it before grading.
	        // If `currentValue` is not TeX, this should be a no-op.
	        var currentValue = ParseTex(state.currentValue);

	        // Look through all correct answers for one that matches either
	        // precisely or approximately and return the appropriate message:
	        // - if precise, return the message that the answer came with
	        // - if it needs to be simplified, etc., show that message
	        var correctAnswers = _.where(rubric.answers, {status: "correct"});
	        var result = _.find(_.map(correctAnswers, function(answer)  {
	            // The coefficient is an attribute of the widget
	            var localValue = currentValue;
	            if (rubric.coefficient) {
	                if (localValue == "") {
	                    localValue = 1;
	                }
	                else if (localValue == "-") {
	                    localValue = -1;
	                }
	            }

	            var validate = createValidator(answer);
	            return validate(localValue);
	        }), function(match)  {return match.correct || match.empty;});

	        if (!result) { // Otherwise, if the guess is not correct
	            var otherAnswers = ([]).concat(
	                _.where(rubric.answers, {status: "ungraded"}),
	                _.where(rubric.answers, {status: "wrong"})
	            );

	            // Look through all other answers and if one matches either
	            // precisely or approximately return the answer's message
	            match = _.find(otherAnswers, function(answer)  {
	                 var validate = createValidator(answer);
	                 return validate(currentValue).correct;
	             });
	            result = {
	                empty: match ? match.status === "ungraded" : false,
	                correct: match ? match.status === "correct" : false,
	                message: match ? match.message : null,
	                guess: currentValue
	            };
	        }

	        // TODO(eater): Seems silly to translate result to this invalid/points
	        // thing and immediately translate it back in ItemRenderer.scoreInput()
	        if (result.empty) {
	            return {
	                type: "invalid",
	                message: result.message
	            };
	        } else {
	            return {
	                type: "points",
	                earned: result.correct ? 1 : 0,
	                total: 1,
	                message: result.message
	            };
	        }
	    }
	});

	var initAnswer = function(status)  {
	    return {
	        value: null,
	        status: status,
	        message: "",
	        simplify: "required",
	        answerForms: [],
	        strict: false,
	        maxError: null
	    };
	};

	var NumericInputEditor = React.createClass({displayName: 'NumericInputEditor',
	    mixins: [EditorJsonify, Changeable],

	    getDefaultProps: function() {
	        return {
	            answers: [initAnswer("correct")],
	            size: "normal",
	            coefficient: false,
	            labelText: "",
	        };
	    },

	    getInitialState: function() {
	        return {
	            lastStatus: "wrong",
	            showOptions: _.map(this.props.answers, function()  {return false;})
	        };
	    },

	    render: function() {
	        var lastStatus = this.state.lastStatus; // for a phantom last answer
	        var answers = this.props.answers;

	        var unsimplifiedAnswers = function(i)  {return React.createElement("div", {className: "perseus-widget-row"}, 
	            React.createElement("label", null, "Unsimplified answers are"), 
	            React.createElement(ButtonGroup, {value: answers[i]["simplify"], 
	                         allowEmpty: false, 
	                         buttons: [
	                            {value: "required", content: "ungraded"},
	                            {value: "optional", content: "accepted"},
	                            {value: "enforced", content: "wrong"}], 
	                         onChange: this.updateAnswer(i, "simplify")}), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "Normally select \"ungraded\". This will give the" + ' ' +
	                "user a message saying the answer is correct but not" + ' ' +
	                "simplified. The user will then have to simplify it and" + ' ' +
	                "re-enter, but will not be penalized. (5th grade and after)"), 
	                React.createElement("p", null, "Select \"accepted\" only if the user is not" + ' ' +
	                "expected to know how to simplify fractions yet. (Anything" + ' ' +
	                "prior to 5th grade)"), 
	                React.createElement("p", null, "Select \"wrong\" ", React.createElement("em", null, "only"), " if we are" + ' ' +
	                "specifically assessing the ability to simplify.")
	            )
	        );}.bind(this);

	        var suggestedAnswerTypes = function(i)  {return React.createElement("div", null, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, "Choose the suggested answer formats"), 
	                React.createElement(MultiButtonGroup, {buttons: answerFormButtons, 
	                    values: answers[i]["answerForms"], 
	                    onChange: this.updateAnswer(i, "answerForms")}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Formats will be autoselected for you based on the" + ' ' +
	                        "given answer; to show no suggested formats and" + ' ' +
	                        "accept all types, simply have a decimal/integer be" + ' ' +
	                        "the answer. Values with π will have format \"pi\"," + ' ' +
	                        "and values that are fractions will have some subset" + ' ' +
	                        "(mixed will be \"mixed\" and \"proper\"; improper/proper" + ' ' +
	                        "will both be \"improper\" and \"proper\"). If you would" + ' ' +
	                        "like to specify that it is only a proper fraction" + ' ' +
	                        "(or only a mixed/improper fraction), deselect the" + ' ' +
	                        "other format. Except for specific cases, you should" + ' ' +
	                        "not need to change the autoselected formats."), 
	                    React.createElement("p", null, "To restrict the answer to ", React.createElement("em", null, "only"), " an improper" + ' ' +
	                        "fraction (i.e. 7/4), select the" + ' ' +
	                        "improper fraction and toggle \"strict\" to true." + ' ' +
	                        "This ", React.createElement("b", null, "will not"), " accept 1.75 as an answer. "), 
	                    React.createElement("p", null, "Unless you are testing that specific skill, please" + ' ' +
	                        "do not restrict the answer format.")
	                )
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(PropCheckBox, {label: "Strictly match only these formats", 
	                    strict: answers[i]["strict"], 
	                    onChange: this.updateAnswer.bind(this, i)})
	            )
	        );}.bind(this);

	        var maxError = function(i)  {return React.createElement("div", {className: "perseus-widget-row"}, 
	            React.createElement("label", null, 
	                "Max error", 
	                " ", 
	                React.createElement(NumberInput, {
	                    className: "max-error", 
	                    value: answers[i]["maxError"], 
	                    onChange: this.updateAnswer(i, "maxError"), 
	                    placeholder: "0"})
	            )
	        );}.bind(this);

	        var inputSize = React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, "Width:", ' ', " "), 
	                React.createElement(ButtonGroup, {value: this.props.size, allowEmpty: false, 
	                    buttons: [
	                        {value: "normal", content: "Normal (80px)"},
	                        {value: "small", content: "Small (40px)"}], 
	                    onChange: this.change("size")}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use size \"Normal\" for all text boxes, unless there are" + ' ' +
	                    "multiple text boxes in one line and the answer area is too" + ' ' +
	                    "narrow to fit them.")
	                )
	            );

	        var labelText = React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, 
	                    "Label text:", ' ', 
	                    React.createElement(TextInput, {
	                        value: this.props.labelText, 
	                        onChange: this.change("labelText")})
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Text to describe this input. This will be shown to users" + ' ' +
	                    "using screenreaders.")
	                )
	            );

	        var coefficientCheck = React.createElement("div", null, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(PropCheckBox, {label: "Coefficient", 
	                    coefficient: this.props.coefficient, 
	                    onChange: this.props.onChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "A coefficient style number allows the student to use - for -1 and an empty string to mean 1.")
	                )
	            )
	        );

	        var addAnswerButton = React.createElement("div", null, 
	            React.createElement("a", {
	                href: "javascript:void(0)", 
	                className: "simple-button orange", 
	                onClick: function()  {return this.addAnswer();}.bind(this), 
	                onKeyDown: function(e)  {return this.onSpace(e, this.addAnswer);}.bind(this)}, 
	              React.createElement("span", null, "Add new answer")
	            )
	        );

	        var instructions = {
	            "wrong":    "(address the mistake/misconception)",
	            "ungraded": "(explain in detail to avoid confusion)",
	            "correct":  "(reinforce the user's understanding)"
	        };

	        var generateInputAnswerEditors = function()  {return answers.map(function(answer, i)  {
	            var editor = React.createElement(Editor, {
	                content: answer.message || "", 
	                placeholder: "Why is this answer " + answer.status + "?\t" +
	                    instructions[answer.status], 
	                widgetEnabled: false, 
	                onChange: function(newProps)  {
	                    if ("content" in newProps) {
	                        this.updateAnswer(i, {message: newProps.content});
	                    }
	                }.bind(this)});
	            return React.createElement("div", {className: "perseus-widget-row", key: i}, 
	                React.createElement("div", {className: "input-answer-editor-value-container" +
	                    (answer.maxError ? " with-max-error" : "")}, 
	                    React.createElement(NumberInput, {value: answer.value, 
	                        className: "numeric-input-value", 
	                        placeholder: "answer", 
	                        format: _.last(answer.answerForms), 
	                        onFormatChange: function(newValue, format)  {
	                            var forms;
	                            if (format === "pi") {
	                                forms = ["pi"];
	                            } else if (format === "mixed") {
	                                forms = ["proper", "mixed"];
	                            } else if (format === "proper" ||
	                                       format === "improper") {
	                                forms = ["proper", "improper"];
	                            }
	                            this.updateAnswer(i, {
	                                value: firstNumericalParse(newValue),
	                                answerForms: forms
	                            });
	                        }.bind(this), 
	                        onChange: function(newValue)  {
	                            this.updateAnswer(i, {
	                                value: firstNumericalParse(newValue)});
	                        }.bind(this)}), 
	                    answer.strict && React.createElement("div", {className: "is-strict-indicator", 
	                        title: "strictly equivalent to"}, "≡"), 
	                    answer.simplify !== "required" &&
	                     answer.status === "correct" &&
	                      React.createElement("div", {className: "simplify-indicator " + answer.simplify, 
	                        title: "accepts unsimplified answers"}, "‰"), 
	                    answer.maxError ? React.createElement("div", {className: "max-error-container"}, 
	                        React.createElement("div", {className: "max-error-plusmn"}, "±"), 
	                        React.createElement(NumberInput, {placeholder: 0, 
	                            value: answers[i]["maxError"], 
	                            format: _.last(answer.answerForms), 
	                            onChange: this.updateAnswer(i, "maxError")})
	                    ) : null, 
	                    React.createElement("div", {className: "value-divider"}), 
	                    React.createElement("a", {href: "javascript:void(0)", 
	                        className: "answer-status " + answer.status, 
	                        onClick: function()  {return this.onStatusChange(i);}.bind(this), 
	                        onKeyDown: function(e)  {return this.onSpace(e, this.onStatusChange, i);}.bind(this)}, 
	                        answer.status
	                    ), 
	                    React.createElement("a", {
	                        href: "javascript:void(0)", 
	                        className: "answer-trash", 
	                        onClick: function()  {return this.onTrashAnswer(i);}.bind(this), 
	                        onKeyDown: function(e)  {return this.onSpace(e, this.onTrashAnswer, i);}.bind(this)}, 
	                      React.createElement("span", {className: "icon-trash"})
	                    ), 
	                    React.createElement("a", {href: "javascript:void(0)", 
	                        className: "options-toggle", 
	                        onClick: function()  {return this.onToggleOptions(i);}.bind(this), 
	                        onKeyDown: function(e)  {return this.onSpace(e, this.onToggleOptions, i);}.bind(this)}, 
	                      React.createElement("i", {className: "icon-gear"})
	                    )
	                ), 
	                React.createElement("div", {className: "input-answer-editor-message"}, editor), 
	                this.state.showOptions[i] &&
	                    React.createElement("div", {className: "options-container"}, 
	                        maxError(i), 
	                        answer.status === "correct" && unsimplifiedAnswers(i), 
	                        suggestedAnswerTypes(i)
	                    )
	            );
	        }.bind(this));}.bind(this);

	        return React.createElement("div", {className: "perseus-input-number-editor"}, 
	            React.createElement("div", {className: "ui-title"}, "User input"), 
	            React.createElement("div", {className: "msg-title"}, "Message shown to user on attempt"), 
	            generateInputAnswerEditors(), 
	            addAnswerButton, 
	            inputSize, 
	            coefficientCheck, 
	            labelText
	        );

	    },

	    onToggleOptions: function(choiceIndex) {
	        var showOptions = this.state.showOptions.slice();
	        showOptions[choiceIndex] = !showOptions[choiceIndex];
	        this.setState({showOptions: showOptions});
	    },

	    onTrashAnswer: function(choiceIndex) {
	        if (choiceIndex >= 0 && choiceIndex < this.props.answers.length) {
	            var answers = this.props.answers.slice(0);
	            answers.splice(choiceIndex, 1);
	            this.props.onChange({answers: answers});
	        }
	    },

	    onSpace: function(e, callback) {
	        if (e.key === " ") {
	            e.preventDefault(); // prevent page shifting
	            var args = _.toArray(arguments).slice(2);
	            callback.apply(this, args);
	        }
	    },

	    onStatusChange: function(choiceIndex) {
	        var statuses = ["wrong", "ungraded", "correct"];
	        var answers = this.props.answers;
	        var i = _.indexOf(statuses, answers[choiceIndex].status);
	        var newStatus = statuses[(i + 1) % statuses.length];

	        this.updateAnswer(choiceIndex, {
	            status: newStatus,
	            simplify: newStatus === "correct" ? "required" : "accepted"
	        });
	    },

	    updateAnswer: function(choiceIndex, update) {
	        if (!_.isObject(update)) {
	            return _.partial(function(choiceIndex, key, value)  {
	                var update = {};
	                update[key] = value;
	                this.updateAnswer(choiceIndex, update);
	            }.bind(this), choiceIndex, update);
	        }

	        var answers = _.clone(this.props.answers);

	        // Don't bother to make a new answer box unless we are editing the last one
	        // TODO(michelle): This might not be necessary anymore.
	        if (choiceIndex == answers.length) {
	            var lastAnswer = initAnswer(this.state.lastStatus);
	            var answers = answers.concat(lastAnswer);
	        }

	        answers[choiceIndex] = _.extend({}, answers[choiceIndex], update);
	        this.props.onChange({answers: answers});
	    },

	    addAnswer: function() {
	        var lastAnswer = initAnswer(this.state.lastStatus);
	        var answers = this.props.answers.concat(lastAnswer);
	        this.props.onChange({answers: answers});
	    },

	    getSaveWarnings: function() {
	        // Filter out all the empty answers
	        var warnings = [];
	        // TODO(emily): This doesn't actually work, because the value is either
	        // null or undefined when undefined, probably.
	        if (_.contains(_.pluck(this.props.answers, "value"), "")) {
	            warnings.push("One or more answers is empty");
	        }
	        if (this.props.labelText === "") {
	            warnings.push("No label is specified");
	        }
	        this.props.answers.forEach(function(answer, i)  {
	            if (answer.strict && (!answer.answerForms || answer.answerForms.length === 0)) {
	                warnings.push("Answer " + (i + 1) + " is set to strict format matching, but no format was selected");
	            }
	        });
	        return warnings;
	    },
	});

	var unionAnswerForms = function(answerFormsList) {
	    // Takes a list of lists of answer forms, and returns a list of the forms
	    // in each of these lists in the same order that they're listed in the
	    // `formExamples` forms from above.

	    // uniqueBy takes a list of elements and a function which compares whether
	    // two elements are equal, and returns a list of unique elements. This is
	    // just a helper function here, but works generally.
	    var uniqueBy = function(list, iteratee) {
	        return _.reduce(list, function(uniqueList, element)  {
	            // For each element, decide whether it's already in the list of
	            // unique items.
	            var inList = _.find(uniqueList, iteratee.bind(null, element));
	            if (inList) {
	                return uniqueList;
	            } else {
	                return uniqueList.concat([element]);
	            }
	        }, []);
	    };

	    // Pull out all of the forms from the different lists.
	    var allForms = _.flatten(answerFormsList);
	    // Pull out the unique forms using uniqueBy.
	    var uniqueForms = uniqueBy(allForms, _.isEqual);
	    // Sort them by the order they appear in the `formExamples` list.
	    return _.sortBy(uniqueForms, function(form)  {
	        return _.keys(formExamples).indexOf(form.name);
	    });
	};

	var propsTransform = function(editorProps) {
	    var rendererProps = _.extend(
	        _.omit(editorProps, "answers"),
	        {
	            answerForms: unionAnswerForms(
	                // Pull out the name of each form and whether that form has
	                // required simplification.
	                _.map(editorProps.answers, function(answer)  {
	                    return _.map(answer.answerForms, function(form)  {
	                        return {
	                            simplify: answer.simplify,
	                            name: form
	                        };
	                    });
	                })
	            )
	        }
	    );
	    return rendererProps;
	};

	module.exports = {
	    name: "numeric-input",
	    displayName: "Number text box",
	    defaultAlignment: "inline-block",
	    accessible: true,
	    widget: NumericInput,
	    editor: NumericInputEditor,
	    transform: propsTransform
	};


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	var InfoTip = __webpack_require__(75);
	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Renderer = __webpack_require__(15);
	var TextListEditor = __webpack_require__(79);
	var Util = __webpack_require__(5);

	var ApiClassNames = __webpack_require__(17).ClassNames;

	var PlaceholderCard = React.createClass({displayName: 'PlaceholderCard',
	    propTypes: {
	        width: React.PropTypes.number.isRequired,
	        height: React.PropTypes.number.isRequired
	    },

	    render: function() {
	        return React.createElement("div", {
	                className: "card-wrap " + ApiClassNames.INTERACTIVE, 
	                style: {width: this.props.width}}, 
	            React.createElement("div", {
	                className: "card placeholder", 
	                style: {height: this.props.height}})
	        );
	    }
	});

	var DragHintCard = React.createClass({displayName: 'DragHintCard',
	    render: function() {
	        return React.createElement("div", {className: "card-wrap " + ApiClassNames.INTERACTIVE}, 
	            React.createElement("div", {className: "card drag-hint"})
	        );
	    }
	});

	var PropTypes = {
	    position: React.PropTypes.shape({
	        left: React.PropTypes.number,
	        top: React.PropTypes.number
	    })
	};

	var Card = React.createClass({displayName: 'Card',
	    propTypes: {
	        floating: React.PropTypes.bool.isRequired,
	        animating: React.PropTypes.bool,
	        width: React.PropTypes.number,
	        stack: React.PropTypes.bool,

	        onMouseDown: React.PropTypes.func,
	        onMouseMove: React.PropTypes.func,
	        onMouseUp: React.PropTypes.func,

	        // Used only for floating/animating cards
	        startMouse: PropTypes.position,
	        startOffset: PropTypes.position,
	        animateTo: PropTypes.position,
	        onAnimationEnd: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            stack: false,
	            animating: false
	        };
	    },

	    render: function() {
	        var style = {};

	        if (this.props.floating) {
	            style = {
	                position: "absolute",
	                left: this.props.startOffset.left,
	                top: this.props.startOffset.top,
	            };
	        }

	        if (this.props.width) {
	            style.width = this.props.width;
	        }

	        var className = ["card"];
	        if (this.props.stack) {
	            className.push("stack");
	        }
	        if (this.props.floating && !this.props.animating) {
	            className.push("dragging");
	            style.left += this.props.mouse.left - this.props.startMouse.left;
	            style.top += this.props.mouse.top - this.props.startMouse.top;
	        }

	        // Pull out the content to get rendered
	        var rendererProps = _.pick(this.props, "content");

	        var onMouseDown = (this.props.animating) ? $.noop : this.onMouseDown;

	        return React.createElement("div", {className: "card-wrap " + ApiClassNames.INTERACTIVE, 
	                    style: style, 
	                    onMouseDown: onMouseDown, 
	                    onTouchStart: onMouseDown, 
	                    onTouchMove: this.onMouseMove, 
	                    onTouchEnd: this.onMouseUp, 
	                    onTouchCancel: this.onMouseUp}, 
	                React.createElement("div", {className: className.join(" ")}, 
	                    React.createElement(Renderer, React.__spread({},  rendererProps))
	                )
	            );
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        // Cards in the bank or drag list don't usually change -- they only
	        // reorder themselves -- so we want to skip the update to things a
	        // little faster. We also need to re-render if the content changes,
	        // which happens only in the editor. (We do want to update the floating
	        // card on mouse move to update its position.)
	        return this.props.floating || nextProps.floating ||
	            this.props.content !== nextProps.content ||
	            // TODO(alpert): Remove ref here after fixing facebook/react#1392.
	            this.props.fakeRef !== nextProps.fakeRef;
	    },

	    componentDidMount: function() {
	        this.mouseMoveUpBound = false;
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        if (this.props.animating && !prevProps.animating) {
	            // If we just were changed into animating, start the animation.
	            // We pick the animation speed based on the distance that the card
	            // needs to travel. (Why sqrt? Just because it looks nice -- with a
	            // linear scale, far things take too long to come back.)
	            var ms = 15 * Math.sqrt(
	                Math.sqrt(
	                    Math.pow(this.props.animateTo.left -
	                             this.props.startOffset.left, 2) +
	                    Math.pow(this.props.animateTo.top -
	                             this.props.startOffset.top, 2)
	                )
	            );
	            $(this.getDOMNode()).animate(
	                this.props.animateTo, Math.max(ms, 1),
	                this.props.onAnimationEnd
	            );
	        }
	    },

	    componentWillUnmount: function() {
	        // Event handlers should be unbound before component unmounting, but
	        // just in case...
	        if (this.mouseMoveUpBound) {
	            console.warn("Removing an element with bound event handlers.");

	            this.unbindMouseMoveUp();
	            Util.resetTouchHandlers();
	        }
	    },

	    bindMouseMoveUp: function() {
	        this.mouseMoveUpBound = true;
	        $(document).on("mousemove", this.onMouseMove);
	        $(document).on("mouseup", this.onMouseUp);
	    },

	    unbindMouseMoveUp: function() {
	        this.mouseMoveUpBound = false;
	        $(document).off("mousemove", this.onMouseMove);
	        $(document).off("mouseup", this.onMouseUp);
	    },

	    onMouseDown: function(event) {
	        event.preventDefault();
	        var loc = Util.extractPointerLocation(event);
	        if (loc) {
	            this.bindMouseMoveUp();
	            this.props.onMouseDown && this.props.onMouseDown(loc, this);
	        }
	    },

	    onMouseMove: function(event) {
	        event.preventDefault();
	        var loc = Util.extractPointerLocation(event);
	        if (loc) {
	            this.props.onMouseMove && this.props.onMouseMove(loc);
	        }
	    },

	    onMouseUp: function(event) {
	        event.preventDefault();
	        var loc = Util.extractPointerLocation(event);
	        if (loc) {
	            this.unbindMouseMoveUp();
	            this.props.onMouseUp && this.props.onMouseUp(loc);
	        }
	    }
	});

	var NORMAL = "normal",
	    AUTO = "auto",
	    HORIZONTAL = "horizontal",
	    VERTICAL = "vertical";

	var Orderer = React.createClass({displayName: 'Orderer',
	    propTypes: {
	        current: React.PropTypes.array,
	        options: React.PropTypes.array,
	        correctOptions: React.PropTypes.array,
	        height: React.PropTypes.oneOf([NORMAL, AUTO]),
	        layout: React.PropTypes.oneOf([HORIZONTAL, VERTICAL])
	    },

	    getDefaultProps: function() {
	        return {
	            current: [],
	            options: [],
	            correctOptions: [],
	            height: NORMAL,
	            layout: HORIZONTAL
	        };
	    },

	    getInitialState: function() {
	        return {
	            current: [],
	            dragging: false,
	            placeholderIndex: null,
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (!_.isEqual(this.props.current, nextProps.current)) {
	            this.setState({current: nextProps.current});
	        }
	    },

	    render: function() {
	        // This is the card we are currently dragging
	        var dragging = this.state.dragging &&
	            React.createElement(Card, {ref: "dragging", 
	                       floating: true, 
	                       content: this.state.dragContent, 
	                       startOffset: this.state.offsetPos, 
	                       startMouse: this.state.grabPos, 
	                       mouse: this.state.mousePos, 
	                       width: this.state.dragWidth, 
	                       onMouseUp: this.onRelease, 
	                       onMouseMove: this.onMouseMove, 
	                       key: this.state.dragKey || "draggingCard"}
	                       );

	        // This is the card that is currently animating
	        var animating = this.state.animating &&
	            React.createElement(Card, {floating: true, 
	                       animating: true, 
	                       content: this.state.dragContent, 
	                       startOffset: this.state.offsetPos, 
	                       width: this.state.dragWidth, 
	                       animateTo: this.state.animateTo, 
	                       onAnimationEnd: this.state.onAnimationEnd, 
	                       key: this.state.dragKey || "draggingCard"}
	                       );

	        // This is the list of draggable, rearrangable cards
	        var sortableCards = _.map(this.state.current, function(opt, i) {
	            return React.createElement(Card, {
	                ref: "sortable" + i, 
	                fakeRef: "sortable" + i, 
	                floating: false, 
	                content: opt.content, 
	                width: opt.width, 
	                key: opt.key, 
	                onMouseDown: (this.state.animating) ?
	                    $.noop :
	                    this.onClick.bind(null, "current", i)});
	        }, this);

	        if (this.state.placeholderIndex != null) {
	            var placeholder = React.createElement(PlaceholderCard, {
	                ref: "placeholder", 
	                width: this.state.dragWidth, 
	                height: this.state.dragHeight, 
	                key: "placeholder"});
	            sortableCards.splice(this.state.placeholderIndex, 0, placeholder);
	        }

	        var anySortableCards = sortableCards.length > 0;
	        sortableCards.push(dragging, animating);

	        // If there are no cards in the list, then add a "hint" card
	        var sortable = React.createElement("div", {className: "ui-helper-clearfix draggable-box"}, 
	            !anySortableCards && React.createElement(DragHintCard, null), 
	            React.createElement("div", {ref: "dragList"}, sortableCards)
	        );

	        // This is the bank of stacks of cards
	        var bank = React.createElement("div", {ref: "bank", className: "bank ui-helper-clearfix"}, 
	            _.map(this.props.options, function(opt, i)  {
	                return React.createElement(Card, {
	                    ref: "bank" + i, 
	                    floating: false, 
	                    content: opt.content, 
	                    stack: true, 
	                    key: i, 
	                    onMouseDown: (this.state.animating) ?
	                        $.noop :
	                        this.onClick.bind(null, "bank", i), 
	                    onMouseMove: this.onMouseMove, 
	                    onMouseUp: this.onRelease});
	            }.bind(this), this)
	        );

	        return React.createElement("div", {className: "draggy-boxy-thing orderer " +
	                        "height-" + this.props.height + " " +
	                        "layout-" + this.props.layout + " " +
	                        "above-scratchpad blank-background " +
	                        "ui-helper-clearfix " + ApiClassNames.INTERACTIVE, 
	                    ref: "orderer"}, 
	                   bank, 
	                   sortable
	               );
	    },

	    onClick: function(type, index, loc, draggable) {
	        var $draggable = $(draggable.getDOMNode());
	        var list = this.state.current.slice();

	        var opt;
	        var placeholderIndex = null;

	        if (type === "current") {
	            // If this is coming from the original list, remove the original
	            // card from the list
	            list.splice(index, 1);
	            opt = this.state.current[index];
	            placeholderIndex = index;
	        } else if (type === "bank") {
	            opt = this.props.options[index];
	        }

	        this.setState({
	            current: list,
	            dragging: true,
	            placeholderIndex: placeholderIndex,
	            dragKey: opt.key,
	            dragContent: opt.content,
	            dragWidth: $draggable.width(),
	            dragHeight: $draggable.height(),
	            grabPos: loc,
	            mousePos: loc,
	            offsetPos: $draggable.position()
	        });
	    },

	    onRelease: function(loc) {
	        var draggable = this.refs.dragging;
	        if (draggable == null) {
	            return;
	        }
	        var inCardBank = this.isCardInBank(draggable);
	        var index = this.state.placeholderIndex;

	        // Here, we build a callback function for the card to call when it is
	        // done animating
	        var onAnimationEnd = function()  {
	            var list = this.state.current.slice();

	            if (!inCardBank) {
	                // Insert the new card into the position
	                var newCard = {
	                    content: this.state.dragContent,
	                    key: _.uniqueId("perseus_draggable_card_"),
	                    width: this.state.dragWidth
	                };

	                list.splice(index, 0, newCard);
	            }

	            this.props.onChange({
	                current: list
	            });
	            this.setState({
	                current: list,
	                dragging: false,
	                placeholderIndex: null,
	                animating: false
	            });
	        }.bind(this);

	        // Find the position of the card we should animate to
	        // TODO(alpert): Update mouse position once more before animating?
	        var offset = $(draggable.getDOMNode()).position();
	        var finalOffset = null;
	        if (inCardBank) {
	            // If we're in the card bank, go through the options to find the
	            // one with the same content
	            _.each(this.props.options, function(opt, i) {
	                if (opt.content === this.state.dragContent) {
	                    var card = this.refs["bank" + i].getDOMNode();
	                    finalOffset = $(card).position();
	                }
	            }, this);
	        } else if (this.refs.placeholder != null) {
	            // Otherwise, go to the position that the placeholder is at
	            finalOffset = $(this.refs.placeholder.getDOMNode()).position();
	        }

	        if (finalOffset == null) {
	            // If we didn't find a card to go to, simply make the changes we
	            // would have made at the end. (should only happen if we are
	            // messing around with card contents, and not on the real site)
	            onAnimationEnd();
	        } else {
	            this.setState({
	                offsetPos: offset,
	                animateTo: finalOffset,
	                onAnimationEnd: onAnimationEnd,
	                animating: true,
	                dragging: false
	            });
	        }
	    },

	    onMouseMove: function(loc) {
	        var draggable = this.refs.dragging;
	        if (draggable == null) {
	            return;
	        }

	        var index;
	        if (this.isCardInBank(draggable)) {
	            index = null;
	        } else {
	            index = this.findCorrectIndex(draggable, this.state.current);
	        }

	        this.setState({
	            mousePos: loc,
	            placeholderIndex: index
	        });
	    },

	    findCorrectIndex: function(draggable, list) {
	        // Find the correct index for a card given the current cards.
	        var isHorizontal = this.props.layout === HORIZONTAL,
	            $dragList = $(this.refs.dragList.getDOMNode()),
	            leftEdge = $dragList.offset().left,
	            topEdge = $dragList.offset().top,
	            midWidth = $(draggable.getDOMNode()).offset().left - leftEdge,
	            midHeight = $(draggable.getDOMNode()).offset().top - topEdge,
	            index = 0,
	            sumWidth = 0,
	            sumHeight = 0;

	        if (isHorizontal) {
	            _.each(list, function(opt, i) {
	                var card = this.refs["sortable" + i].getDOMNode();
	                var outerWidth = $(card).outerWidth(true);
	                if (midWidth > sumWidth + outerWidth / 2) {
	                    index += 1;
	                }
	                sumWidth += outerWidth;
	            }, this);
	        } else {
	            _.each(list, function(opt, i) {
	                var card = this.refs["sortable" + i].getDOMNode();
	                var outerHeight = $(card).outerHeight(true);
	                if (midHeight > sumHeight + outerHeight / 2) {
	                    index += 1;
	                }
	                sumHeight += outerHeight;
	            }, this);
	        }

	        return index;
	    },

	    isCardInBank: function(draggable) {
	        if (draggable == null) {
	            return false;
	        }

	        var isHorizontal = this.props.layout === HORIZONTAL,
	            $draggable = $(draggable.getDOMNode()),
	            $bank = $(this.refs.bank.getDOMNode()),
	            draggableOffset = $draggable.offset(),
	            bankOffset = $bank.offset(),
	            draggableHeight = $draggable.outerHeight(true),
	            bankHeight = $bank.outerHeight(true),
	            bankWidth = $bank.outerWidth(true),
	            dragList = this.refs.dragList.getDOMNode(),
	            dragListWidth = $(dragList).width(),
	            draggableWidth = $draggable.outerWidth(true);

	        if (isHorizontal) {
	            return (draggableOffset.top + draggableHeight / 2 <
	                    bankOffset.top + bankHeight);
	        } else {
	            return (draggableOffset.left + draggableWidth / 2 <
	                    bankOffset.left + bankWidth);
	        }
	    },

	    getUserInput: function() {
	        return {current: _.map(this.props.current, function(v) {
	            return v.content;
	        })};
	    },

	    simpleValidate: function(rubric) {
	        return Orderer.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Orderer, {
	    validate: function(state, rubric) {
	        if (state.current.length === 0) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        }

	        var correct = _.isEqual(
	            state.current,
	            _.pluck(rubric.correctOptions, 'content')
	        );

	        return {
	            type: "points",
	            earned: correct ? 1 : 0,
	            total: 1,
	            message: null
	        };
	    }
	});


	var OrdererEditor = React.createClass({displayName: 'OrdererEditor',
	    propTypes: {
	        correctOptions: React.PropTypes.array,
	        otherOptions: React.PropTypes.array,
	        height: React.PropTypes.oneOf([NORMAL, AUTO]),
	        layout: React.PropTypes.oneOf([HORIZONTAL, VERTICAL]),
	        onChange: React.PropTypes.func.isRequired
	    },

	    getDefaultProps: function() {
	        return {
	            correctOptions: [
	                {content: "$x$"}
	            ],
	            otherOptions: [
	                {content: "$y$"}
	            ],
	            height: NORMAL,
	            layout: HORIZONTAL
	        };
	    },

	    render: function() {
	        var editor = this;

	        return React.createElement("div", {className: "perseus-widget-orderer"}, 
	            React.createElement("div", null, 
	                ' ', "Correct answer:", ' ', 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "Place the cards in the correct order. The same card can be" + ' ' +
	                    "used more than once in the answer but will only be" + ' ' +
	                    "displayed once at the top of a stack of identical cards."
	                ))
	            ), 
	            React.createElement(TextListEditor, {
	                options: _.pluck(this.props.correctOptions, "content"), 
	                onChange: this.onOptionsChange.bind(this, "correctOptions"), 
	                layout: this.props.layout}), 

	            React.createElement("div", null, 
	                ' ', "Other cards:", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Create cards that are not part of the answer.")
	                )
	            ), 
	            React.createElement(TextListEditor, {
	                options: _.pluck(this.props.otherOptions, "content"), 
	                onChange: this.onOptionsChange.bind(this, "otherOptions"), 
	                layout: this.props.layout}), 

	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    ' ', "Layout:", ' ', 
	                    React.createElement("select", {value: this.props.layout, 
	                            onChange: this.onLayoutChange}, 
	                        React.createElement("option", {value: HORIZONTAL}, "Horizontal"), 
	                        React.createElement("option", {value: VERTICAL}, "Vertical")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use the horizontal layout for short text and small" + ' ' +
	                    "images. The vertical layout is best for longer text (e.g." + ' ' +
	                    "proofs).")
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    ' ', "Height:", ' ', 
	                    React.createElement("select", {value: this.props.height, 
	                            onChange: this.onHeightChange}, 
	                        React.createElement("option", {value: NORMAL}, "Normal"), 
	                        React.createElement("option", {value: AUTO}, "Automatic")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use \"Normal\" for text, \"Automatic\" for images.")
	                )
	            )
	        );
	    },

	    onOptionsChange: function(whichOptions, options, cb) {
	        var props = {};
	        props[whichOptions] = _.map(options, function(option) {
	            return {content: option};
	        });
	        this.props.onChange(props, cb);
	    },

	    onLayoutChange: function(e) {
	        this.props.onChange({layout: e.target.value});
	    },

	    onHeightChange: function(e) {
	        this.props.onChange({height: e.target.value});
	    },

	    serialize: function() {
	        // We combine the correct answer and the other cards by merging them,
	        // removing duplicates and empty cards, and sorting them into
	        // categories based on their content
	        var options =
	            _.chain(_.pluck(this.props.correctOptions, 'content'))
	             .union(_.pluck(this.props.otherOptions, 'content'))
	             .uniq()
	             .reject(function(content) { return content === ""; })
	             .sort()
	             .sortBy(function(content) {
	                 if (/\d/.test(content)) {
	                     return 0;
	                 } else if (/^\$?[a-zA-Z]+\$?$/.test(content)) {
	                     return 2;
	                 } else {
	                     return 1;
	                 }
	             })
	             .map(function(content) {
	                 return { content: content };
	             })
	             .value();

	        return {
	            options: options,
	            correctOptions: this.props.correctOptions,
	            otherOptions: this.props.otherOptions,
	            height: this.props.height,
	            layout: this.props.layout
	        };
	    }
	});

	module.exports = {
	    name: "orderer",
	    displayName: "Orderer",
	    widget: Orderer,
	    editor: OrdererEditor
	};


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var Editor = __webpack_require__(11);
	var Renderer = __webpack_require__(15);
	var InfoTip = __webpack_require__(75);
	var PropCheckBox  = __webpack_require__(65);
	var PassageMarkdown = __webpack_require__(110);

	var Passage = React.createClass({displayName: 'Passage',
	    mixins: [Changeable],

	    propTypes: {
	        passageTitle: React.PropTypes.string,
	        passageText: React.PropTypes.string,
	        footnotes: React.PropTypes.string,
	        showLineNumbers: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            passageTitle: "",
	            passageText: "",
	            footnotes: "",
	            showLineNumbers: true
	        };
	    },

	    getInitialState: function() {
	        return {
	            nLines: null,
	            startLineNumbersAfter: 0,
	        };
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        return !_.isEqual(this.props, nextProps) ||
	            !_.isEqual(this.state, nextState);
	    },

	    render: function() {
	        var lineNumbers;
	        var nLines = this.state.nLines;
	        if (this.props.showLineNumbers && nLines) {
	            // lineN is the line number in the current passage;
	            // the displayed line number is
	            // lineN + this.state.startLineNumbersAfter, where
	            // startLineNumbersAfter is the sum of all line numbers
	            // in earlier passages.
	            lineNumbers = _.range(1, nLines + 1).map(function(lineN)  {
	                if (lineN === 4 && nLines > 4) {
	                    return React.createElement("span", {
	                            key: "line-marker", 
	                            className: "line-marker"}, 
	                        "Line"
	                    );
	                } else if (lineN % 5 === 0) {
	                    return lineN + this.state.startLineNumbersAfter;
	                } else {
	                    return "\n";
	                }
	            }.bind(this));
	        }

	        var rawContent = this.props.passageText;
	        var parseState = {};
	        var parsedContent = PassageMarkdown.parse(rawContent, parseState);

	        return React.createElement("div", {className: "perseus-widget-passage-container"}, 
	            this._renderInstructions(parseState), 
	            React.createElement("div", {className: "perseus-widget-passage"}, 
	                React.createElement("div", {className: "passage-title"}, 
	                    React.createElement(Renderer, {content: this.props.passageTitle})
	                ), 
	                lineNumbers &&
	                    React.createElement("div", {className: "line-numbers", 'aria-hidden': true}, 
	                        lineNumbers
	                    ), 
	                
	                React.createElement("h3", {className: "perseus-sr-only"}, 
	                    $_(null, "Beginning of reading passage.")
	                ), 
	                React.createElement("div", {className: "passage-text"}, 
	                    this._renderContent(parsedContent)
	                ), 
	                this._hasFootnotes() && [
	                    React.createElement("h4", {key: "footnote-start", className: "perseus-sr-only"}, 
	                        $_(null, "Beginning of reading passage footnotes.")
	                    ),
	                    React.createElement("div", {key: "footnotes", className: "footnotes"}, 
	                        this._renderFootnotes()
	                    )
	                ], 
	                React.createElement("div", {className: "perseus-sr-only"}, 
	                    $_(null, "End of reading passage.")
	                )
	            )
	        );
	    },

	    componentDidMount: function() {
	        this._updateState();
	    },

	    componentDidUpdate: function() {
	        this._updateState();
	    },

	    _updateState: function() {
	        this.setState({
	            nLines: this._measureLines(),
	            startLineNumbersAfter: this._getInitialLineNumber(),
	        });
	    },

	    _measureLines: function() {
	        var $renderer = $(this.refs.content.getDOMNode());
	        var contentsHeight = $renderer.height();
	        var lineHeight = parseInt($renderer.css("line-height"));
	        var nLines = Math.round(contentsHeight / lineHeight);
	        return nLines;
	    },

	    _getInitialLineNumber: function() {
	        var isPassageBeforeThisPassage = true;
	        var passagesBeforeUs = this.props.interWidgets(function(id, widgetInfo)  {
	            if (widgetInfo.type !== "passage") {
	                return false;
	            }
	            if (id === this.props.widgetId) {
	                isPassageBeforeThisPassage = false;
	            }
	            return isPassageBeforeThisPassage;
	        }.bind(this));

	        return passagesBeforeUs.map(function(passageWidget)  {
	            return passageWidget.getLineCount();
	        }).reduce(function(a, b)  {return a + b;}, 0);
	    },

	    getLineCount: function() {
	        if (this.state.nLines != null) {
	            return this.state.nLines;
	        } else {
	            return this._measureLines();
	        }
	    },

	    _renderInstructions: function(parseState) {
	        var firstQuestionNumber = parseState.firstQuestionRef;
	        var firstSentenceRef = parseState.firstSentenceRef;

	        var instructions = "";
	        if (firstQuestionNumber) {
	            instructions += $._(
	                "The symbol %(questionSymbol)s indicates that question " +
	                "%(questionNumber)s references this portion of the passage.",
	                {
	                    questionSymbol: "[[" + firstQuestionNumber + "]]",
	                    questionNumber: firstQuestionNumber,
	                }
	            );
	        }
	        if (firstSentenceRef) {
	            instructions += $._(
	                " The symbol %(sentenceSymbol)s indicates that the " +
	                "following sentence is referenced in a question.",
	                {
	                    sentenceSymbol: "[" + firstSentenceRef + "]",
	                }
	            );
	        }
	        var parsedInstructions = PassageMarkdown.parse(instructions);
	        return React.createElement("div", {className: "perseus-widget-passage-instructions"}, 
	            PassageMarkdown.output(parsedInstructions)
	        );
	    },

	    _renderContent: function(parsed) {
	        return React.createElement("div", {ref: "content"}, 
	            PassageMarkdown.output(parsed)
	        );
	    },

	    _hasFootnotes: function() {
	        var rawContent = this.props.footnotes;
	        var isEmpty = /^\s*$/.test(rawContent);
	        return !isEmpty;
	    },

	    _renderFootnotes: function() {
	        var rawContent = this.props.footnotes;
	        var parsed = PassageMarkdown.parse(rawContent);
	        return PassageMarkdown.output(parsed);
	    },

	    _getStartRefLineNumber: function(referenceNumber) {
	        var refRef = PassageMarkdown.START_REF_PREFIX + referenceNumber;
	        var ref = this.refs[refRef];
	        if (!ref) {
	            return null;
	        }

	        var $ref = $(ref.getDOMNode());
	        // We really care about the first text after the ref, not the
	        // ref element itself:
	        var $refText = $ref.next();
	        if ($refText.length === 0) {
	            // But if there are no elements after the ref, just
	            // use the ref itself.
	            $refText = $ref;
	        }
	        var vPos = $refText.offset().top;

	        return this.state.startLineNumbersAfter + 1 +
	            this._convertPosToLineNumber(vPos);
	    },

	    _getEndRefLineNumber: function(referenceNumber) {
	        var refRef = PassageMarkdown.END_REF_PREFIX + referenceNumber;
	        var ref = this.refs[refRef];
	        if (!ref) {
	            return null;
	        }

	        var $ref = $(ref.getDOMNode());
	        // We really care about the last text before the ref, not the
	        // ref element itself:
	        var $refText = $ref.prev();
	        if ($refText.length === 0) {
	            // But if there are no elements before the ref, just
	            // use the ref itself.
	            $refText = $ref;
	        }
	        var height = $refText.height();
	        var vPos = $refText.offset().top;

	        var line = this._convertPosToLineNumber(vPos + height);
	        if (height === 0) {
	            // If the element before the end ref span was the start
	            // ref span, it might have 0 height. This is obviously not
	            // the intended use case, but we should handle it gracefully.
	            // If this is the case, then the "bottom" of our element is
	            // actually the top of the line we're on, so we need to add
	            // one to the line number.
	            line += 1;
	        }

	        return this.state.startLineNumbersAfter + line;
	    },

	    _convertPosToLineNumber: function(absoluteVPos) {
	        var $content= $(this.refs.content.getDOMNode());
	        var relativeVPos = absoluteVPos - $content.offset().top;
	        var lineHeight = parseInt($content.css("line-height"));

	        var line = Math.round(relativeVPos / lineHeight);
	        return line;
	    },

	    _getRefContent: function(referenceNumber) {
	        var refRef = PassageMarkdown.START_REF_PREFIX + referenceNumber;
	        var ref = this.refs[refRef];
	        if (!ref) {
	            return null;
	        }
	        return ref.getRefContent();
	    },

	    getReference: function(referenceNumber) {
	        var refStartLine = this._getStartRefLineNumber(referenceNumber);
	        var refEndLine = this._getEndRefLineNumber(referenceNumber);
	        if (refStartLine == null || refEndLine == null) {
	            return null;
	        }
	        var refContent = this._getRefContent(referenceNumber);

	        return {
	            startLine: refStartLine,
	            endLine: refEndLine,
	            content: refContent,
	        };
	    },

	    getUserInput: function() {
	        return null;
	    },

	    simpleValidate: function(rubric) {
	        return Passage.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Passage, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});

	var PassageEditor = React.createClass({displayName: 'PassageEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        passageTitle: React.PropTypes.string,
	        passageText: React.PropTypes.string,
	        footnotes: React.PropTypes.string,
	        showLineNumbers: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            passageTitle: "",
	            passageText: "",
	            footnotes: "",
	            showLineNumbers: true
	        };
	    },

	    render: function() {
	        var passageEditor = React.createElement(Editor, {
	            ref: "passage-editor", 
	            content: this.props.passageText, 
	            widgetEnabled: false, 
	            placeholder: "Type passage here...", 
	            onChange: function(newProps)  {
	                this.change({ passageText: newProps.content });
	            }.bind(this), 
	            showWordCount: true}
	        );
	        var footnotesEditor = React.createElement(Editor, {
	            ref: "passage-footnotes-editor", 
	            content: this.props.footnotes, 
	            widgetEnabled: false, 
	            placeholder: "Type footnotes here...", 
	            onChange: function(newProps)  {
	                this.change({ footnotes: newProps.content });
	            }.bind(this)}
	        );
	        return React.createElement("div", {className: "perseus-widget-passage-editor"}, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement(PropCheckBox, {
	                    label: "Show line numbers", 
	                    labelAlignment: "right", 
	                    showLineNumbers: this.props.showLineNumbers, 
	                    onChange: this.props.onChange})
	            ), 
	            React.createElement("div", null, 
	                "Passage title:", 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "An optional title that will appear directly above the" + ' ' +
	                    "passage in the same font style. (E.g. Passage 1)")
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("input", {
	                        type: "text", 
	                        defaultValue: this.props.passageTitle, 
	                        onChange: function(e)  {
	                            this.change({ passageTitle: e.target.value });
	                        }.bind(this)})
	                )
	            ), 
	            React.createElement("div", null, 
	                "Passage Text:", 
	                passageEditor
	            ), 
	            React.createElement("div", null, 
	                "Footnotes:", 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "To add footnotes, add ^ characters where they belong in" + ' ' +
	                    "the passage. Then, add ^ in the footnotes area to reference" + ' ' +
	                    "the footnotes in the passage.")
	                ), 
	                footnotesEditor
	            )
	        );
	    },
	});

	module.exports = {
	    name: "passage",
	    displayName: "Passage",
	    widget: Passage,
	    editor: PassageEditor,
	    transform: function(editorProps)  {
	        return _.pick(editorProps, "passageTitle", "passageText", "footnotes",
	            "showLineNumbers");
	    }
	};


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var InfoTip = __webpack_require__(75);
	var NumberInput = __webpack_require__(94);
	var PerseusMarkdown = __webpack_require__(57);
	var TextInput = __webpack_require__(81);
	var WidgetJsonifyDeprecated = __webpack_require__(78);

	var EN_DASH = "\u2013";

	var PassageRef = React.createClass({displayName: 'PassageRef',
	    mixins: [WidgetJsonifyDeprecated, Changeable],

	    propTypes: {
	        passageNumber: React.PropTypes.number,
	        referenceNumber: React.PropTypes.number,
	        summaryText: React.PropTypes.string,
	    },

	    getDefaultProps: function() {
	        return {
	            passageNumber: 1,
	            referenceNumber: 1,
	            summaryText: "",
	        };
	    },

	    getInitialState: function() {
	        return {
	            lineRange: null,
	            content: null,
	        };
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        return !_.isEqual(this.props, nextProps) ||
	            !_.isEqual(this.state, nextState);
	    },

	    render: function() {
	        var lineRange = this.state.lineRange;
	        var lineRangeOutput;
	        if (!lineRange) {
	            lineRangeOutput = $_({lineRange: "?" + EN_DASH + "?"}, 
	                "lines %(lineRange)s"
	            );
	        } else if (lineRange[0] === lineRange[1]) {
	            lineRangeOutput = $_({lineNumber: lineRange[0]}, 
	                "line %(lineNumber)s"
	            );
	        } else {
	            lineRangeOutput = $_({
	                    lineRange: lineRange[0] + EN_DASH + lineRange[1]}, 
	                "lines %(lineRange)s"
	            );
	        }

	        var summaryOutput;
	        if (this.props.summaryText) {
	            var summaryTree = PerseusMarkdown.parseInline(
	                this.props.summaryText
	            );
	            summaryOutput = React.createElement("span", {'aria-hidden': true}, 
	                " ", 
	                /* curly quotes */
	                "(“", 
	                PerseusMarkdown.basicOutput(summaryTree), 
	                "”)"
	            );
	        } else {
	            summaryOutput = null;
	        }

	        return React.createElement("span", null, 
	            lineRangeOutput, 
	            summaryOutput, 
	            lineRange &&
	                React.createElement("div", {className: "perseus-sr-only"}, 
	                    this.state.content
	                )
	            
	        );
	    },

	    componentDidMount: function() {
	        _.defer(this._updateRange);
	    },

	    componentDidUpdate: function() {
	        _.defer(this._updateRange);
	    },

	    _updateRange: function() {
	        var passage = this.props.interWidgets(
	                "passage " + this.props.passageNumber)[0];

	        var refInfo = null;
	        if (passage) {
	            refInfo = passage.getReference(this.props.referenceNumber);
	        }

	        if (this.isMounted()) {
	            if (refInfo) {
	                this.setState({
	                    lineRange: [refInfo.startLine, refInfo.endLine],
	                    content: refInfo.content,
	                });
	            } else {
	                this.setState({
	                    lineRange: null,
	                    content: null
	                });
	            }
	        }
	    },

	    simpleValidate: function(rubric) {
	        return PassageRef.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(PassageRef, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});

	var PassageRefEditor = React.createClass({displayName: 'PassageRefEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        passageNumber: React.PropTypes.number,
	        referenceNumber: React.PropTypes.number,
	        summaryText: React.PropTypes.string,
	    },

	    getDefaultProps: function() {
	        return {
	            passageNumber: 1,
	            referenceNumber: 1,
	            summaryText: "",
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Passage Number: ", 
	                    React.createElement(NumberInput, {
	                        value: this.props.passageNumber, 
	                        onChange: this.change("passageNumber")})
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Reference Number: ", 
	                    React.createElement(NumberInput, {
	                        value: this.props.referenceNumber, 
	                        onChange: this.change("referenceNumber")})
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Summary Text: ", 
	                    React.createElement(TextInput, {
	                        value: this.props.summaryText, 
	                        onChange: this.change("summaryText")}), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, 
	                            "Short summary of the referenced section. This" + ' ' +
	                            "will be included in parentheses and quotes" + ' ' +
	                            "automatically."
	                        ), 
	                        React.createElement("p", null, 
	                            "Ex: The start ... the end"
	                        )
	                    )
	                )
	            )
	        );
	    }
	});

	module.exports = {
	    name: "passage-ref",
	    displayName: "PassageRef",
	    defaultAlignment: "inline",
	    widget: PassageRef,
	    editor: PassageRefEditor,
	    transform: function(editorProps)  {
	        return _.pick(editorProps,
	            "passageNumber",
	            "referenceNumber",
	            "summaryText"
	        );
	    },
	    version: {major: 0, minor: 1}
	};


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var WidgetJsonifyDeprecated = __webpack_require__(78);
	var Renderer = __webpack_require__(15);

	var PassageRefTarget = React.createClass({displayName: 'PassageRefTarget',
	    mixins: [WidgetJsonifyDeprecated, Changeable],

	    propTypes: {
	        content: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            content: ""
	        };
	    },

	    render: function() {
	        return React.createElement(Renderer, {
	            content: this.props.content, 
	            inline: true, 
	            enabledFeatures: this.props.enabledFeatures, 
	            apiOptions: this.props.apiOptions}
	            );
	    },

	    simpleValidate: function(rubric) {
	        return PassageRefTarget.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(PassageRefTarget, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});

	var PassageRefTargetEditor = React.createClass({displayName: 'PassageRefTargetEditor',
	    mixins: [EditorJsonify, Changeable],

	    propTypes: {
	        content: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            content: ""
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            "Content:", 
	            React.createElement("input", {type: "text", 
	                value: this.props.content, 
	                onChange: this.handleContentChange})
	        );
	    },

	    handleContentChange: function(e) {
	        this.change({content: e.target.value});
	    }
	});

	module.exports = {
	    name: "passage-ref-target",
	    displayName: "PassageRefTarget",
	    defaultAlignment: "inline",
	    widget: PassageRefTarget,
	    editor: PassageRefTargetEditor,
	    hidden: true,
	    transform: function(editorProps)  {
	        return _.pick(editorProps, "content");
	    },
	    version: {major: 0, minor: 0}
	};


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var InfoTip = __webpack_require__(75);
	var BlurInput = __webpack_require__(91);
	var _ = __webpack_require__(67);

	var NumberInput = __webpack_require__(94);
	var TextListEditor = __webpack_require__(79);
	var RangeInput = __webpack_require__(92);
	var SvgImage = __webpack_require__(64);

	var ApiClassNames = __webpack_require__(17).ClassNames;

	var deepEq = __webpack_require__(5).deepEq;
	var knumber = __webpack_require__(113).number;

	var BAR = "bar",
	    LINE = "line",
	    PIC = "pic",
	    HISTOGRAM = "histogram",
	    DOTPLOT = "dotplot";

	var DOT_PLOT_POINT_SIZE = 4;
	var DOT_PLOT_POINT_PADDING = 8;

	var widgetPropTypes = {
	    type: React.PropTypes.oneOf([BAR, LINE, PIC, HISTOGRAM, DOTPLOT]),
	    labels: React.PropTypes.arrayOf(React.PropTypes.string),
	    categories: React.PropTypes.arrayOf(React.PropTypes.oneOfType([
	        React.PropTypes.number,
	        React.PropTypes.string
	    ])),

	    scaleY: React.PropTypes.number,
	    maxY: React.PropTypes.number,
	    snapsPerLine: React.PropTypes.number,

	    picSize: React.PropTypes.number,
	    pixBoxHeight: React.PropTypes.number,
	    picUrl: React.PropTypes.string,

	    plotDimensions: React.PropTypes.arrayOf(React.PropTypes.number),
	    labelInterval: React.PropTypes.number
	};

	var formatNumber = function(num)  {return "$" + knumber.round(num, 2) + "$";};

	var Plotter = React.createClass({displayName: 'Plotter',
	    propTypes: widgetPropTypes,

	    getDefaultProps: function () {
	        return {
	            type: BAR,
	            labels: ["", ""],
	            categories: [""],

	            scaleY: 1,
	            maxY: 10,
	            snapsPerLine: 2,

	            picSize: 40,
	            picBoxHeight: 48,
	            picUrl: "",

	            plotDimensions: [380, 300],
	            labelInterval: 1
	        };
	    },

	    getInitialState: function() {
	        return {
	            values: this.props.starting || [1]
	        };
	    },

	    render: function() {
	        return React.createElement("div", {
	            className: "perseus-widget-plotter graphie " +
	                ApiClassNames.INTERACTIVE, 
	            ref: "graphieDiv"});
	    },

	    componentDidUpdate: function(prevProps, prevState) {
	        if (this.shouldSetupGraphie) {
	            this.setupGraphie(prevState);
	        }
	    },

	    componentDidMount: function() {
	        this.setupGraphie(this.state);
	    },

	    componentWillReceiveProps: function(nextProps) {
	        var props = ["type", "labels", "categories", "scaleY", "maxY",
	            "snapsPerLine", "picUrl", "labelInterval"];

	        this.shouldSetupGraphie = _.any(props, function (prop) {
	            return !_.isEqual(this.props[prop], nextProps[prop]);
	        }, this);

	        if (!_.isEqual(this.props.starting, nextProps.starting) &&
	            !_.isEqual(this.state.values, nextProps.starting)) {
	            this.shouldSetupGraphie = true;
	            this.setState({values: nextProps.starting});
	        }
	    },

	    setupGraphie: function(prevState) {
	        var self = this;
	        self.shouldSetupGraphie = false;
	        var graphieDiv = self.refs.graphieDiv.getDOMNode();
	        $(graphieDiv).empty();
	        var graphie = KhanUtil.createGraphie(graphieDiv);

	        // TODO(jakesandlund): It's not the react way to hang
	        // something off the component object, but since graphie
	        // is outside React, it makes it easier to do this.
	        self.graphie = graphie;
	        self.graphie.pics = [];

	        var isBar = self.props.type === BAR,
	            isLine = self.props.type === LINE,
	            isPic = self.props.type === PIC,
	            isHistogram = self.props.type === HISTOGRAM,
	            isDotplot = self.props.type === DOTPLOT;

	        var isTiledPlot = isPic || isDotplot;

	        var config = {};
	        var c = config; // c for short

	        c.graph = {
	            lines: [],
	            bars: [],
	            points: [],
	            dividers: []
	        };
	        c.scaleY = self.props.scaleY;
	        c.dimX = self.props.categories.length;
	        var plotDimensions = self.props.plotDimensions;
	        if (isLine) {
	            c.dimX += 1;
	        } else if (isHistogram) {
	            c.barPad = 0;
	            c.barWidth = 1;
	        } else if (isBar) {
	            c.barPad = 0.15;
	            c.barWidth = 1 - 2 * c.barPad;
	            c.dimX += 2 * c.barPad;
	        } else if (isTiledPlot) {
	            c.picBoxHeight = self.props.picBoxHeight;
	            c.picBoxWidthPx = plotDimensions[0] / self.props.categories.length;
	            var picPadAllWidth = plotDimensions[0] - c.dimX * c.picBoxWidthPx;
	            c.picPad = picPadAllWidth / (2 * c.dimX + 2);
	            var picFullWidth = c.picBoxWidthPx + 2 * c.picPad;

	            // Convert from px to "unscaled"
	            c.picPad = c.picPad / picFullWidth;
	            c.picBoxWidth = c.picBoxWidthPx / picFullWidth;
	            c.dimX += 2 * c.picPad;
	        }

	        if (isDotplot) {
	            c.picBoxHeight = DOT_PLOT_POINT_SIZE * 2 + DOT_PLOT_POINT_PADDING;
	        }

	        c.dimY = Math.ceil(self.props.maxY / c.scaleY) * c.scaleY;
	        c.scale = _.map([c.dimX, c.dimY], function (dim, i) {
	            return plotDimensions[i] / dim;
	        });
	        if (isTiledPlot) {
	            c.scale[1] = c.picBoxHeight / c.scaleY;
	        }

	        var padX = 25 / c.scale[0];
	        var padY = 25 / c.scale[1];

	        // Since dotplot doesn't have an axis along the left it looks weird
	        // with the same padding as the others
	        if (isDotplot) {
	            padX /= 2;
	        }

	        graphie.init({
	            range: [[-3 * padX, c.dimX + padX], [-3 * padY, c.dimY + padY]],
	            scale: c.scale
	        });
	        graphie.addMouseLayer({
	            allowScratchpad: true
	        });

	        if (!isTiledPlot) {
	            for (var y = 0; y <= c.dimY; y += c.scaleY) {
	                graphie.label(
	                    [0, y],
	                    KhanUtil.roundToApprox(y, 2),
	                    "left",
	                    /* isTeX */ true /* for the \approx symbol */
	                );
	                graphie.style(
	                    {stroke: "#000", strokeWidth: 1, opacity: 0.3},
	                    function() {
	                        graphie.line([0, y], [c.dimX, y]);
	                    });
	            }
	        }

	        self.setupCategories(config);

	        if (isTiledPlot) {
	            self.drawPicHeights(self.state.values, prevState.values);
	        }

	        graphie.style(
	            {stroke: "#000", strokeWidth: 2, opacity: 1.0},
	            function() {
	                if (isDotplot) {
	                    graphie.line([0.5, 0], [c.dimX - 0.5, 0]);
	                } else {
	                    graphie.line([0, 0], [c.dimX, 0]);
	                    graphie.line([0, 0], [0, c.dimY]);
	                }
	            });

	        graphie.label([c.dimX / 2, -35 / c.scale[1]],
	            self.props.labels[0],
	            "below", false)
	            .css("font-weight", "bold");

	        graphie.label([-60 / c.scale[0], c.dimY / 2],
	            self.props.labels[1],
	            "center", false)
	            .css("font-weight", "bold")
	            .addClass("rotate");
	    },

		labelCategory: function(x, category) {
			var graphie = this.graphie;
			category = category + "";
			var isTeX = false;
			var mathyCategory = category.match(/^\$(.*)\$$/);
			if (mathyCategory) {
				category = mathyCategory[1];
				isTeX = true;
			}
			graphie.label([x, 0], category, "below", isTeX);
		},

	    setupCategories: function(config) {
	        var self = this;
	        var c = config;
	        var graphie = self.graphie;

	        if (self.props.type === HISTOGRAM) {
	            // Histograms with n labels/categories have n - 1 buckets
	            _.times(self.props.categories.length - 1, function(i) {
	                self.setupBar({
	                    index: i,
	                    startHeight: self.state.values[i],
	                    config: config,
	                    isHistogram: true
	                });
	            });

	            // Label categories
	            _.each(self.props.categories, function(category, i) {
	                var x = 0.5 + i * c.barWidth;

	                self.labelCategory(x, category);
	                var tickHeight = 6 / c.scale[1];
	                graphie.style({
	                    stroke: "#000", strokeWidth: 2, opacity: 1.0
	                }, function() {
	                    graphie.line([x, -tickHeight], [x, 0]);
	                });
	            });
	        } else {
	            _.each(self.props.categories, function (category, i) {
	                var startHeight = self.state.values[i];
	                var x;

	                if (self.props.type === BAR) {
	                    x = self.setupBar({
	                        index: i,
	                        startHeight: startHeight,
	                        config: config,
	                        isHistogram: false
	                    });
	                } else if (self.props.type === LINE) {
	                    x = self.setupLine(i, startHeight, config);
	                } else if (self.props.type === PIC) {
	                    x = self.setupPic(i, config);
	                } else if (self.props.type === DOTPLOT) {
	                    x = self.setupDotplot(i, config);
	                }

	                var tickStart = 0;
	                var tickEnd = -6 / c.scale[1];

	                if (self.props.type === DOTPLOT) {
	                    tickStart = -tickEnd;
	                }

	                if (self.props.type === DOTPLOT) {
	                    // Dotplot lets you specify to only show labels every 'n'
	                    // ticks. It also looks nicer if it makes the labelled
	                    // ticks a bit bigger.
	                    if (i % self.props.labelInterval === 0 ||
	                            i === self.props.categories.length - 1) {
	                        self.labelCategory(x, category);
	                        tickStart *= 1.5;
	                        tickEnd *= 1.5;
	                    }
	                } else {
	                    self.labelCategory(x, category);
	                }

	                graphie.style({
	                    stroke: "#000", strokeWidth: 2, opacity: 1.0
	                }, function() {
	                    graphie.line([x, tickStart], [x, tickEnd]);
	                });
	            });
	        }
	    },

	    setupBar: function(args) {
	        var i = args.index;
	        var startHeight = args.startHeight;
	        var config = args.config;
	        var isHistogram = args.isHistogram;

	        var self = this;
	        var graphie = self.graphie;
	        var barHalfWidth = config.barWidth / 2;
	        var x;
	        if (isHistogram) {
	            x = 0.5 + i * config.barWidth + barHalfWidth;
	        } else {
	            x = 0.5 + i + config.barPad;
	        }

	        var scaleBar = function(i, height) {
	            var center = graphie.scalePoint(0);

	            // Scale filled bucket (bar)
	            config.graph.bars[i].scale(
	                    1, Math.max(0.01, height / config.scaleY),
	                    center[0], center[1]);

	            if (isHistogram) {
	                // Scale dividers between buckets
	                var leftDivider = config.graph.dividers[i - 1],
	                    rightDivider = config.graph.dividers[i];

	                if (leftDivider) {
	                    var divHeight = Math.min(self.state.values[i - 1], height);
	                    leftDivider.scale(
	                        1, Math.max(0.01, divHeight / config.scaleY),
	                        center[0], center[1]);
	                }

	                if (rightDivider) {
	                    var divHeight = Math.min(self.state.values[i + 1], height);
	                    rightDivider.scale(
	                        1, Math.max(0.01, divHeight / config.scaleY),
	                        center[0], center[1]
	                    );
	                }
	            }
	        };

	        graphie.style({
	            stroke: "none", fill: KhanUtil.LIGHT_BLUE, opacity: 1.0
	        }, function() {
	            config.graph.bars[i] = graphie.path([
	                [x - barHalfWidth, 0],
	                [x - barHalfWidth, config.scaleY],
	                [x + barHalfWidth, config.scaleY],
	                [x + barHalfWidth, 0],
	                [x - barHalfWidth, 0]
	            ]);
	        });

	        if (isHistogram) {
	            if (i > 0) {
	                // Don't draw a divider to the left of the first bucket
	                graphie.style({
	                    stroke: "#000", strokeWidth: 1, opacity: 0.3
	                }, function() {
	                    config.graph.dividers.push(graphie.path([
	                        [x - barHalfWidth, 0],
	                        [x - barHalfWidth, config.scaleY]
	                    ]));
	                });
	            }
	        }

	        config.graph.lines[i] = graphie.addMovableLineSegment({
	            coordA: [x - barHalfWidth, startHeight],
	            coordZ: [x + barHalfWidth, startHeight],
	            snapY: config.scaleY / self.props.snapsPerLine,
	            constraints: {
	                constrainX: true
	            },
	            normalStyle: {
	                "stroke": KhanUtil.INTERACTIVE,
	                "stroke-width": 4
	            }
	        });

	        config.graph.lines[i].onMove = function(dx, dy) {
	            var y = this.coordA[1];
	            if (y < 0 || y > config.dimY) {
	                y = Math.min(Math.max(y, 0), config.dimY);
	                this.coordA[1] = this.coordZ[1] = y;

	                // Snap the line back into range.
	                this.transform();
	            }

	            var values = _.clone(self.state.values);
	            values[i] = y;
	            self.setState({values: values});
	            self.props.onChange({ values: values });

	            scaleBar(i, y);
	        };

	        scaleBar(i, startHeight);
	        return x;
	    },

	    setupLine: function(i, startHeight, config) {
	        var self = this;
	        var c = config;
	        var graphie = self.graphie;
	        var x = i + 1;
	        c.graph.points[i] = graphie.addMovablePoint({
	            coord: [x, startHeight],
	            constraints: {
	                constrainX: true
	            },
	            normalStyle: {
	                fill: KhanUtil.INTERACTIVE,
	                stroke: KhanUtil.INTERACTIVE
	            },
	            snapY: c.scaleY / self.props.snapsPerLine,
	        });
	        c.graph.points[i].onMove = function(x, y) {
	            y = Math.min(Math.max(y, 0), c.dimY);
	            var values = _.clone(self.state.values);
	            values[i] = y;
	            self.setState({values: values});
	            self.props.onChange({ values: values });
	            return [x, y];
	        };
	        if (i > 0) {
	            c.graph.lines[i] = graphie.addMovableLineSegment({
	                pointA: c.graph.points[i - 1],
	                pointZ: c.graph.points[i],
	                constraints: {
	                    fixed: true
	                },
	                normalStyle: {
	                    stroke: "#9ab8ed",
	                    "stroke-width": 2
	                }
	            });
	        }
	        return x;
	    },

	    setupDotplot: function(i, config) {
	        var graphie = this.graphie;
	        return this.setupTiledPlot(i, 1, config, function(x, y)  {
	            return graphie.ellipse([x, y],
	                 [
	                     DOT_PLOT_POINT_SIZE / graphie.scale[0],
	                     DOT_PLOT_POINT_SIZE / graphie.scale[1]
	                 ],
	                 {
	                    fill: KhanUtil.INTERACTIVE,
	                    stroke: KhanUtil.INTERACTIVE
	                 });
	        });
	    },

	    setupPic: function(i, config) {
	        var graphie = this.graphie;
	        return this.setupTiledPlot(i, 0, config, function(x, y)  {
	            var scaledCenter = graphie.scalePoint([x, y]);
	            var size = this.props.picSize;
	            return graphie.raphael.image(
	                    this.props.picUrl,
	                    scaledCenter[0] - size / 2,
	                    scaledCenter[1] - size / 2,
	                    size,
	                    size);
	        }.bind(this));
	    },

	    setupTiledPlot: function(i, bottomMargin, config, createImage) {
	        var self = this;
	        var c = config;
	        var graphie = self.graphie;
	        var pics = graphie.pics;
	        var x = i + 0.5 + c.picPad;

	        pics[i] = [];
	        var n = Math.round(c.dimY / c.scaleY) + 1;
	        _(n).times(function(j) {
	            j -= 1;
	            var midY = (j + 0.5) * c.scaleY;
	            var leftX = x - c.picBoxWidth / 2;
	            var topY = midY + 0.5 * c.scaleY;
	            var coord = graphie.scalePoint([leftX, topY + bottomMargin]);
	            var mouseRect = graphie.mouselayer.rect(
	                    coord[0], coord[1], c.picBoxWidthPx, c.picBoxHeight);
	            $(mouseRect[0])
	                .css({fill: "#000", opacity: 0.0, cursor: "pointer"})
	                .on("vmousedown", function(e) {
	                    e.preventDefault();
	                    self.whichPicClicked = i;
	                    self.setPicHeight(i, topY);

	                    $(document).on("vmouseup.plotTile", function(e) {
	                        $(document).unbind(".plotTile");
	                    });

	                    $(document).on("vmousemove.plotTile", function(e) {
	                        e.preventDefault();

	                        // Reverse-engineer the initial calculation
	                        var yCoord = graphie.getMouseCoord(e)[1];
	                        var adjustedCoord = Math.floor(yCoord - bottomMargin);

	                        // Calculate top coord from j value, but don't let them
	                        // go below j = -1, which is equivalent to having '0'
	                        // on the dot plot (due to weird indexing).
	                        var newJ = Math.max(-1,
	                            Math.floor(adjustedCoord / c.scaleY));
	                        var newMidY = (newJ + 0.5) * c.scaleY;
	                        var newTopY = newMidY + 0.5 * c.scaleY;
	                        self.setPicHeight(self.whichPicClicked, newTopY);
	                    });
	                });

	            if (j < 0) {
	                // Don't show a pic underneath the axis!
	                return;
	            }
	            pics[i][j] = createImage(x, midY + bottomMargin);
	        });
	        return x;
	    },

	    setPicHeight: function(i, y) {
	        var values = _.clone(this.state.values);
	        values[i] = y;
	        this.drawPicHeights(values, this.state.values);
	        this.setState({values: values});
	        this.props.onChange({ values: values });
	    },

	    drawPicHeights: function(values, prevValues) {
	        var self = this;
	        var graphie = self.graphie;
	        var pics = graphie.pics;
	        _.each(pics, function(ps, i) {
	            _.each(ps, function(pic, j) {
	                var y = (j + 1) * self.props.scaleY;
	                var show = y <= values[i];
	                if (self.props.type === DOTPLOT) {
	                    var wasShown = y <= prevValues[i];
	                    var wasJustShown = show && !wasShown;
	                    if (wasJustShown) {
	                        pic.animate({
	                            "stroke-width": 8
	                        }, 75, function()  {return pic.animate({
	                                "stroke-width": 2
	                            }, 75);});
	                    }
	                }
	                $(pic[0]).css({display: show ? "inline" : "none"});
	            });
	        });
	    },

	    getUserInput: function() {
	        return this.state.values;
	    },

	    simpleValidate: function(rubric) {
	        return Plotter.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Plotter, {
	    validate: function (guess, rubric) {
	        if (deepEq(guess, rubric.starting)) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        } else {
	            return {
	                type: "points",
	                earned: deepEq(guess, rubric.correct) ? 1 : 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});


	// Return a copy of array with length n, padded with given value
	function padArray(array, n, value) {
	    var copy = _.clone(array);
	    copy.length = n;
	    for (var i = array.length; i < n; i++) {
	        copy[i] = value;
	    }
	    return copy;
	}

	var editorDefaults = {
	    scaleY: 1,
	    maxY: 10,
	    snapsPerLine: 2
	};

	var PlotterEditor = React.createClass({displayName: 'PlotterEditor',
	    propTypes: widgetPropTypes,

	    getDefaultProps: function () {
	        return _.extend({}, editorDefaults, {
	            correct: [1],
	            starting: [1],

	            type: BAR,
	            labels: ["", ""],
	            categories: [""],

	            picSize: 30,
	            picBoxHeight: 36,
	            picUrl: Khan.imageBase + "badges/earth-small.png",

	            plotDimensions: [275, 200],
	            labelInterval: 1
	        });
	    },

	    getInitialState: function() {
	        return {
	            editing: "correct",
	            pic: null,
	            loadedUrl: null,
	            minX: null,
	            maxX: null,
	            tickStep: null
	        };
	    },

	    componentWillMount: function() {
	        this.fetchPic(this.props.picUrl);
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.fetchPic(nextProps.picUrl);
	    },

	    fetchPic: function(url) {
	        if (this.state.loadedUrl !== url) {
	            var pic = new Image();
	            pic.src = url;
	            pic.onload = function()  {
	                this.setState({
	                    pic: pic,
	                    loadedUrl: url
	                });
	            }.bind(this);
	        }
	    },

	    render: function() {
	        var setFromScale = _.contains([LINE, HISTOGRAM, DOTPLOT],
	                                      this.props.type);
	        var canChangeSnaps = !_.contains([PIC, DOTPLOT], this.props.type);
	        return React.createElement("div", {className: "perseus-widget-plotter-editor"}, 
	            React.createElement("div", null, 
	                "Chart type:", ' ', 
	                _.map([BAR, LINE, PIC, HISTOGRAM, DOTPLOT], function(type) {
	                    return React.createElement("label", {key: type}, 
	                        React.createElement("input", {
	                            type: "radio", 
	                            name: "chart-type", 
	                            checked: this.props.type === type, 
	                            onChange: _.partial(this.changeType, type)}), 
	                        type
	                    );
	                }, this)
	            ), 
	            React.createElement("div", null, 
	                "Labels:", ' ', 
	                _.map(["x", "y"], function(axis, i) {
	                    return React.createElement("label", {key: axis}, 
	                        axis + ":", 
	                        React.createElement("input", {
	                            type: "text", 
	                            onChange: _.partial(this.changeLabel, i), 
	                            defaultValue: this.props.labels[i]})
	                    );
	                }, this)
	            ), 

	            setFromScale && React.createElement("div", {className: "set-from-scale-box"}, 
	                React.createElement("span", {className: "categories-title"}, 
	                    "Set Categories From Scale"
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("label", null, 
	                        "Tick Step:", ' ', 
	                        React.createElement(NumberInput, {
	                            placeholder: 1, 
	                            useArrowKeys: true, 
	                            value: this.state.tickStep, 
	                            onChange: this.handleChangeTickStep})
	                    ), 
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, "The difference between adjacent ticks.")
	                    )
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("label", null, 
	                        "Range:", ' ', 
	                        React.createElement(RangeInput, {
	                            placeholder: [0, 10], 
	                            useArrowKeys: true, 
	                            value: [this.state.minX, this.state.maxX], 
	                            onChange: this.handleChangeRange})
	                    )
	                ), 
	                React.createElement("div", null, 
	                    React.createElement("button", {onClick: this.setCategoriesFromScale}, 
	                        "Set Categories", ' '
	                    )
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Label Interval:", ' ', 
	                    React.createElement(NumberInput, {
	                        useArrowKeys: true, 
	                        value: this.props.labelInterval, 
	                        onChange: this.changeLabelInterval})
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Which ticks to display the labels for. For instance," + ' ' +
	                    "setting this to \"4\" will only show every 4th label (plus" + ' ' +
	                    "the last one)")
	                )
	            ), 
	            this.props.type === PIC && React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Picture:", ' ', 
	                    React.createElement(BlurInput, {
	                        className: "pic-url", 
	                        value: this.props.picUrl, 
	                        onChange: this.changePicUrl}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use the default picture of Earth, or insert the URL for" + ' ' +
	                    "a different picture using the \"Add image\" function.")
	                )
	                ), 
	                this.state.pic &&
	                    this.state.pic.width !== this.state.pic.height &&
	                    React.createElement("p", {className: "warning"}, 
	                        React.createElement("b", null, "Warning"), ": You are using a picture which is not" + ' ' +
	                        "square.  This means the image will get distorted. You" + ' ' +
	                        "should probably crop it to be square."
	                    )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Categories:", ' ', 
	                    React.createElement(TextListEditor, {
	                        ref: "categories", 
	                        layout: "horizontal", 
	                        options: this.props.categories, 
	                        onChange: this.changeCategories})
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Scale (y):", ' ', 
	                    React.createElement("input", {
	                        type: "text", 
	                        onChange: this.changeScale, 
	                        defaultValue: this.props.scaleY})
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Max y:", ' ', 
	                    React.createElement("input", {
	                        type: "text", 
	                        ref: "maxY", 
	                        onChange: this.changeMax, 
	                        defaultValue: this.props.maxY})
	                )
	            ), 
	            canChangeSnaps && React.createElement("div", null, 
	                React.createElement("label", null, 
	                    "Snaps per line:", ' ', 
	                    React.createElement("input", {
	                        type: "text", 
	                        onChange: this.changeSnaps, 
	                        defaultValue: this.props.snapsPerLine})
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Creates the specified number of divisions between the" + ' ' +
	                    "horizontal lines. Fewer snaps between lines makes the graph" + ' ' +
	                    "easier for the student to create correctly.")
	                )
	            ), 
	            React.createElement("div", null, 
	                "Editing values:", ' ', 
	                _.map(["correct", "starting"], function(editing) {
	                    return React.createElement("label", {key: editing}, 
	                        React.createElement("input", {
	                            type: "radio", 
	                            name: "editing", 
	                            checked: this.state.editing === editing, 
	                            onChange: _.partial(this.changeEditing, editing)}), 
	                        editing
	                    );
	                }, this), 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "Use this toggle to switch between editing the correct" + ' ' +
	                    "answer (what the student will be graded on) and the" + ' ' +
	                    "starting values (what the student will see plotted when" + ' ' +
	                    "they start the problem). Note: These cannot be the same."
	                ))
	            ), 
	            React.createElement(Plotter, React.__spread({}, 
	                this.props, 
	                {starting: this.props[this.state.editing], 
	                onChange: this.handlePlotterChange}))
	        );
	    },

	    handleChangeTickStep: function(value) {
	        this.setState({
	            tickStep: value
	        });
	    },

	    handleChangeRange: function(newValue) {
	        this.setState({
	            minX: newValue[0],
	            maxX: newValue[1]
	        });
	    },

	    changeLabelInterval: function(value) {
	        this.props.onChange({
	            labelInterval: value
	        });
	    },

	    handlePlotterChange: function(newProps) {
	        var props = {};
	        props[this.state.editing] = newProps.values;
	        this.props.onChange(props);
	    },

	    changeType: function(type) {
	        var categories;
	        if (type === HISTOGRAM) {
	            // Switching to histogram, add a label (0) to the left
	            categories = [formatNumber(0)].concat(this.props.categories);
	            this.props.onChange({type: type, categories: categories});
	        } else if (this.props.type === HISTOGRAM) {
	            // Switching from histogram, remove a label from the left
	            categories = this.props.categories.slice(1);
	            this.props.onChange({type: type, categories: categories});
	        } else {
	            this.props.onChange({type: type});
	        }

	        if (categories) {
	            this.refs.categories.getDOMNode().value = categories.join(", ");
	        }
	    },

	    changeLabel: function(i, e) {
	        var labels = _.clone(this.props.labels);
	        labels[i] = e.target.value;
	        this.props.onChange({labels: labels});
	    },

	    changePicUrl: function(value) {
	        // We don't need the labels and other data in the plotter, so just
	        // extract the raw image and use that.
	        // TODO(emily): Maybe indicate that such a change has happened?
	        var url = SvgImage.getRealImageUrl(value);

	        this.props.onChange({picUrl: url});
	    },

	    changeCategories: function(categories) {
	        var n = categories.length;
	        if (this.props.type === HISTOGRAM) {
	            // Histograms with n labels/categories have n - 1 buckets
	            n--;
	        }
	        var value = this.props.scaleY;

	        this.props.onChange({
	            categories: categories,
	            correct: padArray(this.props.correct, n, value),
	            starting: padArray(this.props.starting, n, value)
	        });
	    },

	    changeScale: function(e) {
	        var oldScale = this.props.scaleY;
	        var newScale = +e.target.value || editorDefaults.scaleY;

	        var scale = function(value) {
	            return value * newScale / oldScale;
	        };

	        var maxY = scale(this.props.maxY);

	        this.props.onChange({
	            scaleY: newScale,
	            maxY: maxY,
	            correct: _.map(this.props.correct, scale),
	            starting: _.map(this.props.starting, scale)
	        });

	        this.refs.maxY.getDOMNode().value = maxY;
	    },

	    changeMax: function(e) {
	        this.props.onChange({
	            maxY: +e.target.value || editorDefaults.maxY
	        });
	    },

	    changeSnaps: function(e) {
	        this.props.onChange({
	            snapsPerLine: +e.target.value || editorDefaults.snapsPerLine
	        });
	    },

	    changeEditing: function(editing) {
	        this.setState({editing: editing});
	    },

	    setCategoriesFromScale: function() {
	        var scale = this.state.tickStep || 1;
	        var min = this.state.minX || 0;
	        var max = this.state.maxX || 0;
	        var length = Math.floor((max - min) / scale) * scale;

	        var categories;
	        if (this.props.type === HISTOGRAM || this.props.type === DOTPLOT) {
	            // Ranges for histogram and dotplot labels should start at zero
	            categories = _.range(0, length + scale, scale);
	        } else {
	            categories = _.range(scale, length + scale, scale);
	        }

	        categories = _.map(categories, function(num)  {return num + min;});
	        categories = _.map(categories, formatNumber);

	        this.changeCategories(categories);

	        this.refs.categories.getDOMNode().value = categories.join(", ");
	    },

	    serialize: function() {
	        var json = _.pick(this.props, "correct", "starting", "type", "labels",
	            "categories", "scaleY", "maxY", "snapsPerLine", "labelInterval");

	        if (this.props.type === PIC) {
	            json.picUrl = this.props.picUrl;
	        }

	        return json;
	    }
	});

	module.exports = {
	    name: "plotter",
	    displayName: "Plotter",
	    widget: Plotter,
	    editor: PlotterEditor
	};


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable = __webpack_require__(77);
	var ApiClassNames = __webpack_require__(17).ClassNames;

	var Editor = __webpack_require__(11);
	var PropCheckBox = __webpack_require__(65);
	var Renderer = __webpack_require__(15);
	var PassageRef = __webpack_require__(42);
	var Util = __webpack_require__(5);

	var InfoTip = __webpack_require__(75);

	var shuffle = __webpack_require__(5).shuffle;
	var seededRNG = __webpack_require__(5).seededRNG;
	var captureScratchpadTouchStart =
	        __webpack_require__(5).captureScratchpadTouchStart;

	var classNames = __webpack_require__(112);

	var Choice = React.createClass({displayName: 'Choice',
	    propTypes: {
	        checked: React.PropTypes.bool,
	        className: React.PropTypes.string,
	        clue: React.PropTypes.object,
	        content: React.PropTypes.node,
	        disabled: React.PropTypes.bool,
	        groupName: React.PropTypes.string,
	        showClue: React.PropTypes.bool,
	        type: React.PropTypes.string,
	        onChecked: React.PropTypes.func,
	        // This indicates the position of the choice relative to others
	        // (so that we can display a nice little (A), (B), etc. next to it)
	        pos: React.PropTypes.number
	    },

	    getDefaultProps: function() {
	        return {
	            checked: false,
	            classSet: {},
	            disabled: false,
	            showClue: false,
	            type: 'radio',
	            pos: 0
	        };
	    },

	    render: function() {
	        // NOTE(jeresig): This is not i18n appropriate and should probably be
	        // changed to a map of common options that are properly translated.
	        var letter = String.fromCharCode(65 + this.props.pos);

	        var a11yText = function()  {
	            // If the option was checked we need to reveal more context about
	            // what the result was (correct/incorrect)
	            if (this.props.checked) {
	                if (typeof this.props.correct === "boolean") {
	                    if (this.props.correct) {
	                        return $._("(Choice %(letter)s, Checked, Correct)",
	                            {letter: letter});
	                    } else {
	                        return $._("(Choice %(letter)s, Checked, Incorrect)",
	                            {letter: letter});
	                    }
	                }

	                return $._("(Choice %(letter)s, Checked)", {letter: letter});

	            // If the option wasn't checked, but was correct, we need to tell
	            // the user that this was, in fact, the correct answer.
	            } else if (this.props.correct) {
	                return $._("(Choice %(letter)s, Correct Answer)",
	                    {letter: letter});
	            }

	            return $._("(Choice %(letter)s)", {letter: letter});
	        }.bind(this);

	        return React.createElement("label", {className: this.props.className}, 
	            React.createElement("div", {className: "checkbox-and-option"}, 
	                React.createElement("span", {className: "checkbox"}, 
	                    React.createElement("div", {className: "pos-back"}), 
	                    React.createElement("div", {className: "pos"}, 
	                        React.createElement("span", {className: "perseus-sr-only"}, a11yText()), 
	                        React.createElement("span", {'aria-hidden': "true"}, letter)
	                    ), 
	                    React.createElement("input", {
	                        type: this.props.type, 
	                        name: this.props.groupName, 
	                        checked: this.props.checked, 
	                        disabled: this.props.disabled, 
	                        onClick: function(e)  {
	                            // Avoid sending this to the parent
	                            e.stopPropagation();
	                        }, 
	                        onChange: function(e)  {
	                            this.props.onChecked(e.target.checked);
	                        }.bind(this)})
	                ), 
	                /* A pseudo-label. <label> is slightly broken on iOS,
	                    so this works around that. Unfortunately, it is
	                    simplest to just work around that everywhere. */
	                React.createElement("span", {className: 
	                        ApiClassNames.RADIO.OPTION_CONTENT + " " +
	                        ApiClassNames.INTERACTIVE, 
	                    
	                    style: { cursor: "default"}}, 
	                    React.createElement("div", null, 
	                        this.props.content
	                    )
	                )
	            ), 
	            this.props.showClue &&
	                React.createElement("div", {className: "perseus-radio-clue"}, 
	                    this.props.clue
	                )
	        );
	    }
	});

	var ChoiceNoneAbove = React.createClass({displayName: 'ChoiceNoneAbove',
	    propTypes: {
	        showContent: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            showContent: true
	        };
	    },

	    render: function() {
	        var choiceProps = _.extend({}, this.props, {
	            className: classNames(this.props.className, "none-of-above"),
	            content: (this.props.showContent ?
	                this.props.content :
	                // We use a Renderer here because that is how
	                // `this.props.content` is wrapped otherwise.
	                // We pass in a key here so that we avoid a semi-spurious
	                // react warning when we render this in the same place
	                // as the previous choice content renderer.
	                // Note this destroys state, but since all we're doing
	                // is outputting "None of the above", that is okay.
	                React.createElement(Renderer, {
	                    key: "noneOfTheAboveRenderer", 
	                    content: $._("None of the above")})
	            ),
	        });

	        return React.createElement(Choice, React.__spread({},  choiceProps));
	    }
	});

	var ChoiceEditor = React.createClass({displayName: 'ChoiceEditor',
	    propTypes: {
	        choice: React.PropTypes.object,
	        showDelete: React.PropTypes.bool,
	        onClueChange: React.PropTypes.func,
	        onContentChange: React.PropTypes.func,
	        onDelete: React.PropTypes.func
	    },

	    render: function() {
	        var checkedClass = this.props.choice.correct ? "correct" : "incorrect";
	        var placeholder = "Type a choice here...";

	        if (this.props.choice.isNoneOfTheAbove) {
	            placeholder = this.props.choice.correct ?
	                "Type the answer to reveal to the user..." :
	                "None of the above";
	        }

	        var editor = React.createElement(Editor, {
	            ref: "content-editor", 
	            content: this.props.choice.content || "", 
	            widgetEnabled: false, 
	            placeholder: placeholder, 
	            disabled: this.props.choice.isNoneOfTheAbove &&
	                !this.props.choice.correct, 
	            onChange: this.props.onContentChange});

	        var clueEditor = React.createElement(Editor, {
	            ref: "clue-editor", 
	            content: this.props.choice.clue || "", 
	            widgetEnabled: false, 
	            placeholder: $._(("Why is this choice " + checkedClass + "?")), 
	            onChange: this.props.onClueChange});

	        var deleteLink = React.createElement("a", {href: "#", 
	                className: "simple-button orange delete-choice", 
	                title: "Remove this choice", 
	                onClick: this.props.onDelete}, 
	            React.createElement("span", {className: "icon-trash"})
	        );

	        return React.createElement("div", {className: "choice-clue-editors"}, 
	            React.createElement("div", {className: ("choice-editor " + checkedClass)}, 
	                editor
	            ), 
	            React.createElement("div", {className: "clue-editor"}, 
	                clueEditor
	            ), 
	            this.props.showDelete && deleteLink
	        );
	    }
	});

	var BaseRadio = React.createClass({displayName: 'BaseRadio',
	    propTypes: {
	        labelWrap: React.PropTypes.bool,
	        multipleSelect: React.PropTypes.bool,
	        onCheckedChange: React.PropTypes.func,
	        onePerLine: React.PropTypes.bool,
	        apiOptions: React.PropTypes.object,
	        reviewModeRubric: React.PropTypes.object,
	        deselectEnabled: React.PropTypes.bool,
	    },

	    getDefaultProps: function() {
	        return {
	            onePerLine: true,
	        };
	    },

	    render: function() {
	        // TODO(aria): Stop this from mutating the id every time someone
	        // clicks on a radio :(
	        var radioGroupName = _.uniqueId("perseus_radio_");
	        var inputType = this.props.multipleSelect ? "checkbox" : "radio";
	        var rubric = this.props.reviewModeRubric;

	        return React.createElement("fieldset", {className: "perseus-widget-radio-fieldset"}, 
	            React.createElement("legend", {className: "perseus-sr-only"}, this.props.multipleSelect ?
	                $_(null, "Select all that apply.") :
	                $_(null, "Please choose from one of the following options.")
	            ), 
	            React.createElement("ul", {className: "perseus-widget-radio " +
	                "above-scratchpad blank-background"}, 
	                this.props.multipleSelect &&
	                    React.createElement("div", {className: "instructions"}, 
	                        $_(null, "Select all that apply.")
	                    ), 
	                this.props.choices.map(function(choice, i) {
	                    // True if we're in review mode and a clue (aka rationale)
	                    // is available. These are only used for SAT questions,
	                    // though there was historically an inconclusive AB test
	                    // that showed clues for other exercises.
	                    // (See content/targeted_clues_exercises.py for more)
	                    // TODO(marcia): Aria recommends bringing this logic up a
	                    // level, as with this.props.questionCompleted.
	                    var reviewModeClues = !!(rubric && rubric.choices[i].clue);

	                    var Element = Choice;
	                    var elementProps = {
	                        ref: ("radio" + i),
	                        checked: choice.checked,
	                        correct: (rubric && rubric.choices[i].correct),
	                        clue: choice.clue,
	                        content: choice.content,
	                        disabled: this.props.apiOptions.readOnly,
	                        groupName: radioGroupName,
	                        showClue: reviewModeClues,
	                        type: inputType,
	                        pos: i,
	                        onChecked: function(checked)  {
	                            this.checkOption(i, checked);
	                        }.bind(this)
	                    };

	                    if (choice.isNoneOfTheAbove) {
	                        Element = ChoiceNoneAbove;
	                        _.extend(elementProps, { showContent: choice.correct });
	                    }

	                    var className = classNames(
	                        // TODO(aria): Make a test case for these API classNames
	                        ApiClassNames.RADIO.OPTION,
	                        choice.checked && ApiClassNames.RADIO.SELECTED,
	                        !this.props.onePerLine && "inline",
	                        (rubric && rubric.choices[i].correct &&
	                            ApiClassNames.CORRECT
	                        ),
	                        (rubric && !rubric.choices[i].correct &&
	                            ApiClassNames.INCORRECT
	                        )
	                    );

	                    var checkHandler = function(e)  {
	                        if (!this.props.labelWrap) {
	                            return;
	                        }

	                        // Ignore non-enter and non-space keypresses
	                        if (e.keyCode && e.keyCode !== 13 && e.keyCode !== 32) {
	                            return;
	                        }

	                        // Don't send this to the scratchpad
	                        e.preventDefault();
	                        if (!this.props.apiOptions.readOnly) {
	                            var shouldToggle =
	                                this.props.multipleSelect ||
	                                this.props.deselectEnabled;
	                            this.checkOption(
	                                i,
	                                shouldToggle ? !choice.checked : true);
	                        }
	                    }.bind(this);

	                    return React.createElement("li", {className: className, key: i, tabIndex: "0", 
	                            role: "radio", 'aria-checked': choice.checked, 
	                            onTouchStart: !this.props.labelWrap ?
	                                null : captureScratchpadTouchStart, 
	                            
	                            onKeyDown: checkHandler, 
	                            onClick: checkHandler}, 
	                        React.createElement(Element, React.__spread({},  elementProps))
	                    );
	                }, this)
	            )
	        );
	    },

	    checkOption: function(radioIndex, shouldBeChecked) {
	        var newChecked;
	        if (this.props.multipleSelect) {
	            // When multipleSelect is on, clicking an index toggles the
	            // selection of just that index.
	            newChecked = _.map(this.props.choices, function(choice, i)  {
	                return (i === radioIndex) ? shouldBeChecked : choice.checked;
	            });
	        } else {
	            // When multipleSelect is turned off we always unselect everything
	            // that wasn't clicked.
	            newChecked = _.map(this.props.choices, function(choice, i)  {
	                return i === radioIndex && shouldBeChecked;
	            });
	        }

	        // We send just the array of [true/false] checked values here;
	        // onCheckedChange reconstructs the new choices to send to
	        // this.props.onChange
	        this.props.onCheckedChange(newChecked);
	    },

	    focus: function(i) {
	        this.refs["radio" + (i || 0)].getDOMNode().focus();
	        return true;
	    }
	});

	var Radio = React.createClass({displayName: 'Radio',
	    getDefaultProps: function() {
	        return {
	            choices: [{}],
	            displayCount: null,
	            multipleSelect: false,
	            deselectEnabled: false,
	        };
	    },

	    render: function() {
	        var choices = this.props.choices;
	        var values = this.props.values || _.map(choices, function()  {return false;});

	        choices = _.map(choices, function(choice, i)  {
	            var content = (choice.isNoneOfTheAbove && !choice.content) ?
	                // we use $._ instead of $_ here because the content
	                // sent to a renderer needs to be a string, not a react
	                // node (/renderable/fragment).
	                $._("None of the above") :
	                choice.content;
	            return {
	                content: this._renderRenderer(content),
	                checked: values[i],
	                correct: this.props.questionCompleted && values[i],
	                clue: this._renderRenderer(choice.clue),
	                isNoneOfTheAbove: choice.isNoneOfTheAbove
	            };
	        }.bind(this));
	        choices = this.enforceOrdering(choices);

	        return React.createElement(BaseRadio, {
	            ref: "baseRadio", 
	            labelWrap: true, 
	            onePerLine: this.props.onePerLine, 
	            multipleSelect: this.props.multipleSelect, 
	            choices: choices, 
	            onCheckedChange: this.onCheckedChange, 
	            reviewModeRubric: this.props.reviewModeRubric, 
	            deselectEnabled: this.props.deselectEnabled, 
	            apiOptions: this.props.apiOptions});
	    },

	    _renderRenderer: function(content) {
	        content = content || "";

	        var nextPassageRefId = 1;
	        var widgets = {};

	        var modContent = content.replace(
	            /\{\{passage-ref (\d+) (\d+)(?: "([^"]*)")?\}\}/g,
	            function(match, passageNum, refNum, summaryText)  {
	                var widgetId = "passage-ref " + nextPassageRefId;
	                nextPassageRefId++;

	                widgets[widgetId] = {
	                    type: "passage-ref",
	                    graded: false,
	                    options: {
	                        passageNumber: parseInt(passageNum),
	                        referenceNumber: parseInt(refNum),
	                        summaryText: summaryText,
	                    },
	                    version: PassageRef.version
	                };

	                return "[[" + Util.snowman + " " + widgetId + "]]";
	            }
	        );

	        // alwaysUpdate={true} so that passage-refs interwidgets
	        // get called when the outer passage updates the renderer
	        // TODO(aria): This is really hacky
	        // We pass in a key here so that we avoid a semi-spurious
	        // react warning when the ChoiceNoneAbove renders a
	        // different renderer in the same place. Note this destroys
	        // state, but since all we're doing is outputting
	        // "None of the above", that is okay.
	        return React.createElement(Renderer, {
	                key: "choiceContentRenderer", 
	                content: modContent, 
	                widgets: widgets, 
	                interWidgets: this._interWidgets, 
	                alwaysUpdate: true});
	    },

	    _interWidgets: function(filterCriterion, localResults) {
	        // If local results are not found, forward interwidgets
	        // calls to our parent renderer.
	        // For passage-refs to communicate with their passages.
	        if (localResults.length) {
	            return localResults;
	        } else {
	            return this.props.interWidgets(filterCriterion);
	        }
	    },

	    focus: function(i) {
	        return this.refs.baseRadio.focus(i);
	    },

	    onCheckedChange: function(checked) {
	        this.props.onChange({
	            values: checked
	        });
	    },

	    getUserInput: function() {
	        // Return checked inputs in the form {values: [bool]}. (Dear future
	        // timeline implementers: this used to be {value: i} before multiple
	        // select was added)
	        if (this.props.values) {
	            var noneOfTheAboveIndex = null;
	            var noneOfTheAboveSelected = false;

	            var values = this.props.values.slice();

	            for (var i = 0; i < this.props.values.length; i++) {
	                var index = this.props.choices[i].originalIndex;
	                values[index] = this.props.values[i];

	                if (this.props.choices[i].isNoneOfTheAbove) {
	                    noneOfTheAboveIndex = index;

	                    if (values[i]) {
	                        noneOfTheAboveSelected = true;
	                    }
	                }
	            }

	            return {
	                values: values,
	                noneOfTheAboveIndex: noneOfTheAboveIndex,
	                noneOfTheAboveSelected: noneOfTheAboveSelected
	            };
	        } else {
	            // Nothing checked
	            return {
	                values: _.map(this.props.choices, function()  {return false;})
	            };
	        }
	    },

	    simpleValidate: function(rubric) {
	        return Radio.validate(this.getUserInput(), rubric);
	    },

	    enforceOrdering: function(choices) {
	        var content = _.pluck(choices, "content");
	        if (_.isEqual(content, [$._("False"), $._("True")]) ||
	            _.isEqual(content, [$._("No"), $._("Yes")])) {
	            return ([choices[1]]).concat([choices[0]]);
	        }
	        return choices;
	    }
	});

	_.extend(Radio, {
	    validate: function(state, rubric) {
	        var numSelected = _.reduce(state.values, function(sum, selected) {
	            return sum + ((selected) ? 1 : 0); }
	        , 0);

	        if (numSelected === 0) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        // If NOTA and some other answer are checked, ...
	        } else if (state.noneOfTheAboveSelected && numSelected > 1) {
	            return {
	                type: "invalid",
	                message: $._("'None of the above' may not be selected " +
	                                    "when other answers are selected.")
	             };
	        } else {
	            /* jshint -W018 */
	            var correct = _.all(state.values, function(selected, i) {
	                var isCorrect;
	                if (state.noneOfTheAboveIndex === i) {
	                    isCorrect = _.all(rubric.choices, function(choice, j) {
	                        return i === j || !choice.correct;
	                    });
	                } else {
	                    isCorrect = !!rubric.choices[i].correct;
	                }
	                return isCorrect === selected;
	            });
	            /* jshint +W018 */

	            return {
	                type: "points",
	                earned: correct ? 1 : 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});

	var RadioEditor = React.createClass({displayName: 'RadioEditor',
	    mixins: [Changeable],

	    propTypes: {
	        choices: React.PropTypes.arrayOf(React.PropTypes.shape({
	            content: React.PropTypes.string,
	            clue: React.PropTypes.string,
	            correct: React.PropTypes.bool
	        })),
	        displayCount: React.PropTypes.number,
	        randomize: React.PropTypes.bool,
	        hasNoneOfTheAbove: React.PropTypes.bool,
	        multipleSelect: React.PropTypes.bool,
	        onePerLine: React.PropTypes.bool,
	        deselectEnabled: React.PropTypes.bool,
	    },

	    getDefaultProps: function() {
	        return {
	            choices: [{}, {}],
	            displayCount: null,
	            randomize: false,
	            hasNoneOfTheAbove: false,
	            multipleSelect: false,
	            onePerLine: true,
	            deselectEnabled: false,
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("div", {className: "perseus-widget-row"}, 

	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    React.createElement("div", null, 
	                        React.createElement(PropCheckBox, {label: "One answer per line", 
	                                      labelAlignment: "right", 
	                                      onePerLine: this.props.onePerLine, 
	                                      onChange: this.props.onChange}), 
	                        React.createElement(InfoTip, null, 
	                            React.createElement("p", null, 
	                                "Use one answer per line unless your question has" + ' ' +
	                                "images that might cause the answers to go off the" + ' ' +
	                                "page."
	                            )
	                        )
	                    )
	                ), 

	                React.createElement("div", {className: "perseus-widget-right-col"}, 
	                    React.createElement(PropCheckBox, {label: "Multiple selections", 
	                                  labelAlignment: "right", 
	                                  multipleSelect: this.props.multipleSelect, 
	                                  onChange: this.onMultipleSelectChange})
	                ), 
	                React.createElement("div", {className: "perseus-widget-left-col"}, 
	                    React.createElement(PropCheckBox, {label: "Randomize order", 
	                                  labelAlignment: "right", 
	                                  randomize: this.props.randomize, 
	                                  onChange: this.props.onChange})
	                ), 
	                React.createElement("div", {className: "perseus-widget-right-col"}, 
	                    React.createElement(PropCheckBox, {label: "Radio deselect enabled", 
	                                  labelAlignment: "right", 
	                                  deselectEnabled: this.props.deselectEnabled, 
	                                  onChange: this.props.onChange})
	                )
	            ), 

	            React.createElement(BaseRadio, {
	                ref: "baseRadio", 
	                multipleSelect: this.props.multipleSelect, 
	                onePerLine: true, 
	                labelWrap: false, 
	                apiOptions: this.props.apiOptions, 
	                choices: this.props.choices.map(function(choice, i) {
	                    return {
	                        content: React.createElement(ChoiceEditor, {
	                            ref: ("choice-editor" + i), 
	                            choice: choice, 
	                            onContentChange: function(newProps)  {
	                                if ("content" in newProps) {
	                                    this.onContentChange(i, newProps.content);
	                                }
	                            }.bind(this), 
	                            onClueChange: function(newProps)  {
	                                if ("content" in newProps) {
	                                    this.onClueChange(i, newProps.content);
	                                }
	                            }.bind(this), 
	                            onDelete: this.onDelete.bind(this, i), 
	                            showDelete: this.props.choices.length >= 2}),
	                        isNoneOfTheAbove: choice.isNoneOfTheAbove,
	                        checked: choice.correct
	                    };
	                }, this), 
	                onCheckedChange: this.onCheckedChange}), 

	            React.createElement("div", {className: "add-choice-container"}, 
	                React.createElement("a", {href: "#", className: "simple-button orange", 
	                        onClick: this.addChoice.bind(this, false)}, 
	                    React.createElement("span", {className: "icon-plus"}), 
	                    ' ', "Add a choice", ' '
	                ), 

	                !this.props.hasNoneOfTheAbove && React.createElement("a", {href: "#", className: "simple-button", 
	                        onClick: this.addChoice.bind(this, true)}, 
	                    React.createElement("span", {className: "icon-plus"}), 
	                    ' ', "None of the above", ' '
	                )
	            )

	        );
	    },

	    onMultipleSelectChange: function(allowMultiple) {
	        allowMultiple = allowMultiple.multipleSelect;

	        var numSelected = _.reduce(this.props.choices,
	                function(memo, choice) {
	            return choice.correct ? memo + 1 : memo;
	        }, 0);

	        if (!allowMultiple && numSelected > 1) {
	            var choices = _.map(this.props.choices, function(choice) {
	                return _.defaults({
	                    correct: false
	                }, choice);
	            });
	            this.props.onChange({
	                multipleSelect: allowMultiple,
	                choices: choices
	            });

	        } else {
	            this.props.onChange({
	                multipleSelect: allowMultiple
	            });
	        }
	    },

	    onCheckedChange: function(checked) {
	        var choices = _.map(this.props.choices, function(choice, i)  {
	            return _.extend({}, choice, {
	                correct: checked[i],
	                content: choice.isNoneOfTheAbove && !checked[i] ? '' : choice.content
	            });
	        });
	        this.props.onChange({choices: choices});
	    },

	    onContentChange: function(choiceIndex, newContent) {
	        var choices = this.props.choices.slice();
	        choices[choiceIndex] = _.extend({}, choices[choiceIndex], {
	            content: newContent
	        });
	        this.props.onChange({choices: choices});
	    },

	    onClueChange: function(choiceIndex, newClue) {
	        var choices = this.props.choices.slice();
	        choices[choiceIndex] = _.extend({}, choices[choiceIndex], {
	            clue: newClue
	        });
	        if (newClue === "") {
	            delete choices[choiceIndex].clue;
	        }
	        this.props.onChange({choices: choices});
	    },

	    onDelete: function(choiceIndex, e) {
	        e.preventDefault();

	        var choices = this.props.choices.slice();
	        var deleted = choices[choiceIndex];

	        choices.splice(choiceIndex, 1);

	        this.props.onChange({
	            choices: choices,
	            hasNoneOfTheAbove: this.props.hasNoneOfTheAbove && !deleted.isNoneOfTheAbove
	        });
	    },

	    addChoice: function(noneOfTheAbove, e) {
	        e.preventDefault();

	        var choices = this.props.choices.slice();
	        var newChoice = { isNoneOfTheAbove: noneOfTheAbove };
	        var addIndex = choices.length - (this.props.hasNoneOfTheAbove ? 1 : 0);

	        choices.splice(addIndex, 0, newChoice);

	        this.props.onChange({
	            choices: choices,
	            hasNoneOfTheAbove: noneOfTheAbove || this.props.hasNoneOfTheAbove
	        }, function()  {
	            this.refs[("choice-editor" + addIndex)].refs['content-editor'].focus();
	        }.bind(this));
	    },

	    setDisplayCount: function(num){
	        this.props.onChange({displayCount: num});
	    },

	    focus: function() {
	        this.refs['choice-editor0'].refs['content-editor'].focus()
	        return true;
	    },

	    getSaveWarnings: function() {
	        if (!_.some(_.pluck(this.props.choices, "correct"))) {
	            return ["No choice is marked as correct."];
	        }
	        return [];
	    },

	    serialize: function() {
	        return _.pick(this.props, "choices", "randomize",
	            "multipleSelect", "displayCount", "hasNoneOfTheAbove", "onePerLine",
	            "deselectEnabled");
	    }
	});

	var choiceTransform = function(editorProps, problemNum)  {

	    var randomize = function(array) {
	        if (editorProps.randomize) {
	            return shuffle(array, problemNum);
	        } else {
	            return array;
	        }
	    };

	    var addNoneOfAbove = function(array) {
	        var noneOfTheAbove = null;

	        array = _.reject(array, function(choice, index) {
	            if (choice.isNoneOfTheAbove) {
	                noneOfTheAbove = choice;
	                return true;
	            }
	        });

	        // Place the "None of the above" options last
	        if (noneOfTheAbove) {
	            array.push(noneOfTheAbove)
	        }

	        return array;
	    };

	    // Add meta-information to choices
	    var choices = editorProps.choices.slice();

	    choices = _.map(choices, function(choice, i) {
	        return _.extend({}, _.omit(choice, "correct"), { originalIndex: i });
	    });

	    // Randomize and add 'None of the above'
	    choices = addNoneOfAbove(randomize(choices));

	    editorProps = _.extend({}, editorProps, { choices: choices });
	    return _.pick(editorProps, "choices", "hasNoneOfTheAbove", "onePerLine",
	        "multipleSelect", "correctAnswer", "deselectEnabled");
	};

	var propUpgrades = {
	    1: function(v0props)  {
	        var choices;
	        var hasNoneOfTheAbove;

	        if (!v0props.noneOfTheAbove) {
	            choices = v0props.choices;
	            hasNoneOfTheAbove = false;

	        } else {
	            choices = _.clone(v0props.choices);
	            var noneOfTheAboveIndex = _.random(0, v0props.choices.length - 1);
	            var noneChoice = _.extend(
	                {},
	                v0props.choices[noneOfTheAboveIndex],
	                {
	                    isNoneOfTheAbove: true,
	                }
	            );
	            choices.splice(noneOfTheAboveIndex, 1);
	            choices.push(noneChoice);
	            hasNoneOfTheAbove = true;
	        }

	        return _.extend(_.omit(v0props, "noneOfTheAbove"), {
	            choices: choices,
	            hasNoneOfTheAbove: hasNoneOfTheAbove,
	        });
	    },
	};

	module.exports = {
	    name: "radio",
	    displayName: "Multiple choice",
	    accessible: true,
	    widget: Radio,
	    editor: RadioEditor,
	    transform: choiceTransform,
	    version: { major: 1, minor: 0 },
	    propUpgrades: propUpgrades,
	};



/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var ApiOptions = __webpack_require__(17).Options;
	var Changeable   = __webpack_require__(77);
	var Editor = __webpack_require__(11);
	var Renderer = __webpack_require__(15);
	var Util = __webpack_require__(5);

	var StepControlButton = React.createClass({displayName: 'StepControlButton',
	    render: function() {
	        return React.createElement("a", {
	                href: "#", 
	                className: 
	                    "step-control-button " +
	                    "simple-button " +
	                    "simple-button--small " +
	                    "orange", 
	                
	                onClick: function(e)  {
	                    e.preventDefault();
	                    this.props.onClick();
	                }.bind(this)}, 
	            React.createElement("span", {className: this.props.icon})
	        );
	    }
	});

	var Sequence = React.createClass({displayName: 'Sequence',
	    mixins: [Changeable],

	    propTypes: {
	        json:  React.PropTypes.arrayOf(React.PropTypes.shape({
	            content: React.PropTypes.string,
	            widgets: React.PropTypes.object,
	            images: React.PropTypes.object
	        })),
	        apiOptions: ApiOptions.propTypes
	    },

	    getDefaultProps: function() {
	        return {
	            json: [{
	                content: "",
	                widgets: {},
	                images: {},
	            }]
	        };
	    },

	    getInitialState: function() {
	        return {
	            visible: 1
	        };
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        return nextProps !== this.props || nextState !== this.state;
	    },

	    render: function() {
	        var icon = React.createElement("div", {className: "icon-ok", style: {color: "green"}});

	        var content = _.chain(this.props.json)
	                .first(this.state.visible)
	                .map(function(step, i)  {
	                    return "[[" + Util.snowman + " group " + i + "]]";
	                })
	                .join("\n\n")
	                .value();
	        
	        var widgets = {};
	        _.each(this.props.json, function(step, i)  {
	            var widgetId = "group " + i;
	            widgets[widgetId] = {
	                type: "group",
	                graded: true,
	                version: {major: 0, minor: 0},
	                options: _.extend({}, step, {
	                    onInteractWithWidget: _.partial(
	                            this._handleInteraction, i),
	                    icon: i < this.state.visible - 1 ? icon : null
	                })
	            };
	        }.bind(this));

	        return React.createElement("div", {className: "perseus-sequence"}, 
	            React.createElement(Renderer, {
	                ref: "renderer", 
	                content: content, 
	                widgets: widgets, 
	                apiOptions: this.props.apiOptions, 
	                enabledFeatures: this.props.enabledFeatures})
	        );
	    },

	    _handleInteraction: function(step) {
	        if (step === this.state.visible - 1) {
	            var widget = this.refs.renderer.getWidgetInstance("group " + step);
	            var score = widget.simpleValidate();

	            if (score.type === "points" && score.total === score.earned) {
	                this.setState({
	                    visible: this.state.visible + 1
	                });
	            }
	        }
	    }
	});


	var SequenceEditor = React.createClass({displayName: 'SequenceEditor',
	    propTypes: {
	        json:  React.PropTypes.arrayOf(React.PropTypes.shape({
	            content: React.PropTypes.string,
	            widgets: React.PropTypes.object,
	            images: React.PropTypes.object
	        })),
	        apiOptions: ApiOptions.propTypes,
	        onChange: React.PropTypes.func.isRequired,
	    },

	    getDefaultProps: function() {
	        return {
	            json: [{
	                content: "",
	                widgets: {},
	                images: {},
	            }]
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-sequence-editor"}, 
	            _.map(this.props.json, function(json, i)  {
	                return React.createElement("div", null, 
	                    "Step ", i+1, 
	                    React.createElement("div", {style: {
	                        display: "inline-block",
	                        float: "right"
	                    }}, 
	                        (i + 1 < this.props.json.length) &&
	                            React.createElement(StepControlButton, {
	                                icon: "icon-circle-arrow-down", 
	                                onClick: function()  {
	                                    this._handleMoveStepLater(i);
	                                }.bind(this)}), 
	                        
	                        (i > 0) &&
	                            React.createElement(StepControlButton, {
	                                icon: "icon-circle-arrow-up", 
	                                onClick: function()  {
	                                    this._handleMoveStepEarlier(i);
	                                }.bind(this)}), 
	                        
	                        React.createElement(StepControlButton, {
	                            icon: "icon-trash", 
	                            onClick: function()  {
	                                var msg = "Are you sure you " +
	                                    "want to remove step " +
	                                    (i + 1) + "?";
	                                if (confirm(msg)) {
	                                    this._handleRemoveStep(i);
	                                }
	                            }.bind(this)}), 
	                        React.createElement(StepControlButton, {
	                            icon: "icon-plus", 
	                            onClick: function()  {
	                                this._handleAddStepAfter(i);
	                            }.bind(this)})
	                    ), 
	                    React.createElement(Editor, {
	                        ref: "editor" + i, 
	                        content: json.content, 
	                        widgets: json.widgets, 
	                        images: json.images, 
	                        widgetEnabled: true, 
	                        immutableWidgets: false, 
	                        onChange: _.partial(this._handleEditorChange, i)})
	                );
	            }.bind(this))
	        );
	    },

	    _handleEditorChange: function(i, newProps) {
	        var steps = _.clone(this.props.json);
	        steps[i] = _.extend({}, steps[i], newProps);
	        this.props.onChange({json: steps});
	    },

	    serialize: function() {
	        return {
	            json: _.times(this.props.json.length, function(i)  {
	                return this.refs["editor" + i].serialize();
	            }.bind(this))
	        };
	    },

	    _handleMoveStepEarlier: function(i) {
	        if (i === 0) {
	            return;
	        }
	        var steps = _.clone(this.props.json);
	        var step = steps[i];
	        steps.splice(i, 1);
	        steps.splice(i - 1, 0, step);
	        this.props.onChange({
	            json: steps
	        });
	    },

	    _handleMoveStepLater: function(i) {
	        var steps = _.clone(this.props.json);
	        if (i + 1 === steps.length) {
	            return;
	        }
	        var step = steps[i];
	        steps.splice(i, 1);
	        steps.splice(i + 1, 0, step);
	        this.props.onChange({
	            json: steps
	        });
	    },

	    _handleAddStepAfter: function(i) {
	        // We do a full serialization here because we
	        // might be copying widgets:
	        var steps = _.clone(this.props.json);
	        // Here we do magic to allow you to copy-paste
	        // things from the previous section into the new
	        // section while preserving widgets.
	        // To enable this, we preserve the widgets
	        // object for the new section, but wipe out
	        // the content.
	        var newStep = (i >= 0) ? {
	            widgets: steps[i].widgets
	        } : {};
	        steps.splice(i + 1, 0, newStep);
	        this.props.onChange({
	            json: steps
	        });
	    },

	    _handleRemoveStep: function(i) {
	        var steps = _.clone(this.props.json);
	        steps.splice(i, 1);
	        this.props.onChange({
	            json: steps
	        });
	    },
	});

	var traverseChildWidgets = function(
	        props,
	        traverseRenderer) {

	    var oldJson = props.json;
	    if (!_.isArray(oldJson)) {
	        oldJson = [oldJson];
	    }
	    var json = _.map(oldJson, function(rendererOptions)  {
	        return traverseRenderer(rendererOptions);
	    });

	    return _.extend({}, props, {json: json});
	};

	module.exports = {
	    name: "sequence",
	    displayName: "Sequence",
	    widget: Sequence,
	    editor: SequenceEditor,
	    traverseChildWidgets: traverseChildWidgets,
	    hidden: true,
	};



/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var InfoTip      = __webpack_require__(75);
	var _ = __webpack_require__(67);

	var Changeable   = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var ApiOptions = __webpack_require__(17).Options;
	var assert = __webpack_require__(97).assert;

	var Graphie = __webpack_require__(80);
	var $__0=
	    
	    
	    
	    
	    
	    
	    
	  Graphie,Path=$__0.Path,Arc=$__0.Arc,Circle=$__0.Circle,Label=$__0.Label,Line=$__0.Line,MovablePoint=$__0.MovablePoint,MovableLine=$__0.MovableLine;
	var NumberInput  = __webpack_require__(94);
	var MathOutput  = __webpack_require__(96);
	var seededRNG    = __webpack_require__(5).seededRNG;
	var Util         = __webpack_require__(5);
	var knumber      = __webpack_require__(113).number;

	var defaultBoxSize = 400;
	var maxSampleSize = 1000;
	var maxTrials = 5000;

	var Histogram = React.createClass({displayName: 'Histogram',
	    propTypes: {
	        data: React.PropTypes.arrayOf(React.PropTypes.number),
	        xAxisLabel: React.PropTypes.string,
	        yAxisLabel: React.PropTypes.string,
	        box: React.PropTypes.arrayOf(React.PropTypes.number)
	    },

	    getDefaultProps: function() {
	        return {
	            data: null,
	            xAxisLabel: "Proportion (%)",
	            yAxisLabel: "Number of times seen",
	            box: [defaultBoxSize, defaultBoxSize]
	        };
	    },

	    getInitialState: function() {
	        return {
	            threshold: this._getInitialThreshold(this._range())
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        // Reset the threshold if the range has changed
	        var oldRange = this._range();
	        var nextRange = this._range(nextProps);
	        if (!Util.deepEq(oldRange, nextRange)) {
	            this.setState({
	                threshold: this._getInitialThreshold(nextRange)
	            });
	        }
	    },

	    /* Renders the vertical line that users can drag across the histogram. */
	    _renderThresholdLine: function() {
	        // Recall the the y-range goes from [-1, yMax] to allow for ticks on
	        // the x-axis.
	        var yRange = [0, this._range()[1][1]];
	        var coords = _.map(yRange, function(y)  {return [this.state.threshold, y];}.bind(this));

	        // Returns an inivisble, placeholder coord that anchors the line
	        var invisiblePointForCoord = function(coord, i)  {
	            return React.createElement(MovablePoint, {
	                key: i, 
	                static: true, 
	                coord: coord, 
	                normalStyle: {stroke: "none", fill: "none"}});
	        };

	        return React.createElement(MovableLine, {onMove: this.handleMouseInteraction}, 
	            _.map(coords, invisiblePointForCoord)
	        );
	    },

	    /* Renders the shaded circle in the top right. */
	    _renderCircle: function() {
	        var data = this.props.data;

	        // Get proportion of results below threshold
	        var total = _.reduce(data, function(sum, next)  {
	            return sum + next;
	        }, 0);
	        var numBelow = _.reduce(data, function(sum, next, i)  {
	            if (this.state.threshold != null &&
	                    i <= this.state.threshold) {
	                return sum + next;
	            } else {
	                return sum;
	            }
	        }.bind(this), 0);
	        var proportionBelow = numBelow / total;

	        // This is a hack around the arc taking angles modulo 360.
	        // TODO(charlie): Find a better way around this.
	        var epsilon = 1e-5;
	        var radius = 20;
	        var center = [this.props.box[0] - 1.5 * radius, 1.5 * radius];

	        // Plot little circle
	        var plotBelowCircle = function()  {
	            var options = {
	                key: "below",
	                center: center,
	                radius: radius,
	                startAngle: 0,
	                endAngle: (proportionBelow < 1) ? 360 * proportionBelow
	                                                : 360 - epsilon,
	                sector: (proportionBelow !== 1),
	                unscaled: true,
	                style: {
	                    fill: KhanUtil.LIGHT_RED,
	                    stroke: KhanUtil.RED
	                }
	            };

	            return React.createElement(Arc, React.__spread({},  options));
	        };
	        var plotAboveCircle = function()  {
	            var options = {
	                key: "above",
	                center: center,
	                radius: radius,
	                startAngle: (proportionBelow > 0) ? 360 * proportionBelow
	                                                  : epsilon,
	                endAngle: 360,
	                sector: (proportionBelow !== 0),
	                unscaled: true,
	                style: {
	                    fill: KhanUtil.LIGHT_BLUE,
	                    stroke: KhanUtil.BLUE
	                },
	            };

	            return React.createElement(Arc, React.__spread({},  options));
	        };

	        // Plot the label below the circle
	        var xRange = this._range()[0];
	        var formattedThreshold = Math.min(
	            Math.max(this.state.threshold, xRange[0]), xRange[1]).toFixed(2);
	        var plotLabel = function()  {
	            var options = {
	                key: "label",
	                coord: [center[0], center[1] + 1.5 * radius],
	                text: numBelow + " of " + total + " results below " +
	                    formattedThreshold + "%",
	                direction: "center",
	                tex: false,
	                unscaled: true,
	                style: {
	                    fontSize: "12px"
	                }
	            };
	            return React.createElement(Label, React.__spread({},  options));
	        };

	        return [
	            proportionBelow > 0 && plotBelowCircle(),
	            proportionBelow < 1 && plotAboveCircle(),
	            plotLabel()
	        ];
	    },

	    /* Renders the actual bars of the histogram. */
	    _renderData: function() {
	        var data = this.props.data;
	        var range = this._range();

	        // Plot bars
	        var barWidth = 1;
	        var pathForData = function(count, i)  {
	            // Avoid plotting bars of height 0, else you get a thick blue line
	            // over the x-axis. We don't filter these out of the data passed in
	            // to this function, however, to preserve absolute indices.
	            if (!count) {
	                return;
	            }

	            var isBelow = this.state.threshold != null &&
	                    i <= this.state.threshold;
	            var style = {
	                fill: (isBelow) ?  KhanUtil.LIGHT_RED : KhanUtil.LIGHT_BLUE,
	                stroke: (isBelow) ? KhanUtil.RED : KhanUtil.BLUE
	            };
	            var coords = [
	                [i, 0],
	                [i, count],
	                [i + barWidth, count],
	                [i + barWidth, 0]
	            ];
	            return React.createElement(Path, {key: i, coords: coords, style: style});
	        }.bind(this);

	        return _.map(data, pathForData);
	    },

	    render: function() {
	        var data = this.props.data;
	        var range = this._range();

	        var options = {
	            xAxisLabel: this.props.xAxisLabel,
	            yAxisLabel: this.props.yAxisLabel,
	            box: this.props.box,
	            range: range,
	            data: data,
	            scale: [Util.scaleFromExtent(range[0], this.props.box[0]),
	                        Util.scaleFromExtent(range[1], this.props.box[1])]
	        };

	        var axisStyle = {
	            stroke: "#000",
	            strokeWidth: 1,
	            opacity: 1.0
	        };
	        var origin = [range[0][0], 0];
	        var bottomRight = [range[0][1], 0];

	        return React.createElement(Graphie, {box: options.box, 
	                        range: options.range, 
	                        options: options, 
	                        setup: this._setupGraphie, 
	                        onMouseMove: this.handleMouseInteraction, 
	                        onMouseDown: this.handleMouseInteraction}, 
	            React.createElement(Line, {start: origin, end: bottomRight, style: axisStyle}), 
	            /* Only plot these cool extra features if there's data */
	            data && this._renderData(), 
	            data && this._renderCircle(), 
	            data && this._renderThresholdLine()
	        );
	    },

	    _setupGraphie: function(graphie, options) {
	        var data = options.data;
	        var range = options.range;
	        var scale = options.scale;

	        /* Plot the bars that run parallel to the x-axis. */
	        var xWidth = range[0][1] - range[0][0];
	        var yWidth = range[1][1] - 0;

	        var maxYAxisEntities = 20;
	        var ySkip = Math.ceil(yWidth / maxYAxisEntities);
	        _.each(_.range(0, range[1][1], ySkip), function(y)  {

	            // If there's no data, we don't label the axes
	            if (data) {
	                graphie.label(
	                    [range[0][0], y],
	                    KhanUtil.roundToApprox(y, 2),
	                    "left",
	                    /* isTeX */ true /* for the \approx symbol */
	                );
	            }

	            graphie.line([range[0][0], y], [range[0][1], y], {
	                stroke: "#000",
	                strokeWidth: 1,
	                opacity: 0.3
	            });
	        });


	        // If there's no data, we don't label the x-axis at all
	        if (data) {
	            // Plot the labels below the bars
	            var maxXAxisEntities = 15;
	            var xSkip = Math.ceil(xWidth / maxXAxisEntities);
	            _.each(_.range(range[0][0], range[0][1], xSkip), function(x)  {
	                graphie.label([x, 0], knumber.round(x, 2), "below", true);

	                var tickHeight = 8;
	                graphie.line([x, 0], [x, - tickHeight / scale[1]], {
	                        stroke: "#000",
	                        strokeWidth: 1
	                    }
	                );
	            });
	        }

	        // Add y axis (x axis is added later to overlap the bars)
	        var axisStyle = {
	            stroke: "#000",
	            strokeWidth: 2,
	            opacity: 1.0
	        };
	        var origin = [range[0][0], 0];
	        var topLeft = [range[0][0], range[1][1]];
	        graphie.line(origin, topLeft, axisStyle);

	        // Add axis labels
	        var xMid = range[0][0] + (xWidth / 2);
	        var xOffset = (data) ? 25 : 0;
	        graphie.label([xMid, - xOffset / scale[1]],
	            options.xAxisLabel,
	            "below", false)
	            .css("font-weight", "bold");

	        var yMid = 0 + (yWidth / 2);
	        var yOffset = (data) ? 55 : 28;
	        graphie.label([range[0][0] - yOffset / scale[0], yMid],
	            options.yAxisLabel,
	            "center", false)
	            .css("font-weight", "bold")
	            .css("-webkit-transform", "rotate(-90deg)");
	    },

	    handleMouseInteraction: function(point) {
	        this.setState({
	            threshold: point[0]
	        });
	    },

	    /* Convenience functions that help calculate props based on other props. */
	    _range: function(props) {
	        var defaultRange = [[0, 100], [-1, 10]];
	        props = props || this.props;
	        return (props.data) ? this._getRangeForData(props.data) : defaultRange;
	    },

	    _getRangeForData: function(data) {
	        // Find first/last non-zero entry and add some padding
	        var padding = 10;
	        var firstIndex = _.indexOf(data, _.find(data, function(n)  {return n > 0;}));
	        var xMin = Math.max(0, firstIndex - padding);
	        var lastIndex = _.lastIndexOf(data, _.last(
	            _.filter(data, function(n)  {return n > 0;})));
	        var xMax = Math.min(100 + 1, (lastIndex + 1) + padding);

	        // The y-axis is bounded above by largest value, and below by 0.
	        // However, the 'range' of the y-axis goes as low as -1 to allow
	        // Graphie to draw ticks on the x-Axis that extend vertically below
	        // y = 0.
	        var yMin = -1;
	        var yMax = _.max(data);

	        return [[xMin, xMax], [yMin, yMax]];
	    },

	    _getInitialThreshold: function(range) {
	        // We pick a pretty-looking threshold, 1/3 of the way along the axis
	        var xRange = range[0];
	        return xRange[0] + (xRange[1] - xRange[0]) / 3;
	    }
	});

	var Simulator = React.createClass({displayName: 'Simulator',
	    mixins: [Changeable],

	    propTypes: {
	        data: React.PropTypes.arrayOf(React.PropTypes.number),
	        userProportion: React.PropTypes.number,
	        sampleSize: React.PropTypes.number,
	        numTrials: React.PropTypes.number,
	        randomSeed: React.PropTypes.number,
	        xAxisLabel: React.PropTypes.string,
	        yAxisLabel: React.PropTypes.string,
	        proportionLabel: React.PropTypes.string,
	        proportionOrPercentage: React.PropTypes.string,
	        apiOptions: ApiOptions.propTypes
	    },

	    getInitialState: function() {
	        return {
	            invalidInput: false
	        };
	    },

	    getDefaultProps: function() {
	        return {
	            data: null,
	            userProportion: null,
	            sampleSize: null,
	            numTrials: null,
	            randomSeed: 0,
	            xAxisLabel: "Proportion (%)",
	            yAxisLabel: "Number of times seen",
	            proportionLabel: "Underlying proportion",
	            proportionOrPercentage: "proportion",
	            apiOptions: ApiOptions.defaults
	        };
	    },

	    componentWillMount: function() {
	        if (this.props.randomSeed != null) {
	            this.generateNumber = Util.seededRNG(this.props.randomSeed);
	        }
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (nextProps.randomSeed !== this.props.randomSeed) {
	            this.generateNumber = Util.seededRNG(nextProps.randomSeed);
	        }
	    },

	    render: function() {
	        var inputStyle = {
	            marginLeft: "5px"
	        };

	        var highlight = "0px 0px 9px 2px rgba(255, 165, 0, 1)";
	        var highlightStyle = _.extend({}, inputStyle, {
	            WebkitBoxShadow: highlight,
	            MozBoxShadow: highlight,
	            boxShadow: highlight,
	            transition: "all 0.15s"
	        });
	        var unhighlightStyle = _.extend({}, inputStyle, {
	            transition: "all 0.15s"
	        });
	        var style = (this.state.invalidInput) ? highlightStyle
	                                              : unhighlightStyle;

	        var InputComponent = this.props.apiOptions.staticRender ? MathOutput
	                                                                : NumberInput;

	        var proportionInput = React.createElement("div", null, 
	            React.createElement(InputComponent, {
	                ref: "userProportion", 
	                style: style, 
	                value: this.calculateDisplayProportion(), 
	                checkValidity: this.checkProportionValidity, 
	                onChange: this.handleUserProportionChange, 
	                onFocus: function()  {return this.props.onFocus(["userProportion"]);}.bind(this), 
	                onBlur: function()  {return this.props.onBlur(["userProportion"]);}.bind(this)}), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "This controls the proportion or percentage that will be used" + ' ' +
	                   "in your simulation.")
	            )
	        );

	        var sampleSizeInput = React.createElement("div", null, 
	            React.createElement(InputComponent, {
	                ref: "sampleSize", 
	                style: style, 
	                value: this.props.sampleSize, 
	                checkValidity: function(val)  {return val >= 0;}, 
	                onChange: this.handleSampleSizeChange, 
	                onFocus: function()  {return this.props.onFocus(["sampleSize"]);}.bind(this), 
	                onBlur: function()  {return this.props.onBlur(["sampleSize"]);}.bind(this)}), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "This controls the sample size that will be used in your" + ' ' +
	                   "simulation. For example, if you set this to 100, then for" + ' ' +
	                   "each trial, responses from 100 participants will be" + ' ' +
	                   "simulated.")
	            )
	        );

	        var numTrialsDisplay = React.createElement("div", {style: {float: "right"}}, 
	            React.createElement("b", null, this.props.numTrials), 
	            React.createElement(InfoTip, null, 
	                React.createElement("p", null, "This is the number of trials used in the simulation. For" + ' ' +
	                   "example, if set to 50, then the survey will be conducted 50" + ' ' +
	                   "times.")
	            )
	        );

	        // Generates a table from a set of titles and values.
	        var generateTable = function(contents)  {
	            var header = React.createElement("thead", null, 
	                React.createElement("tr", null, 
	                    React.createElement("th", null, "Parameter"), 
	                    React.createElement("th", null, "Value")
	                )
	            );

	            var body = React.createElement("tbody", null, 
	                _.map(contents, function(row, i)  {
	                    return React.createElement("tr", {key: i}, 
	                        React.createElement("td", null, row.title), 
	                        React.createElement("td", null, row.value)
	                    );
	                })
	            );

	            return React.createElement("table", null, 
	                header, 
	                body
	            );
	        };

	        // Contents for the table to-be generated
	        var contents = [
	            {
	                title: this.props.proportionLabel + ":",
	                value: proportionInput,
	            },
	            {
	                title: "Sample size:",
	                value: sampleSizeInput
	            },
	            {
	                title: "Number of trials:",
	                value: numTrialsDisplay
	            }
	        ];

	        // The 'Run Simulation' button
	        var buttonStyle = {
	            margin: "20px 0"
	        };
	        var startButton = React.createElement("button", {
	                className: "simple-button", 
	                style: buttonStyle, 
	                onClick: this.handleRunSimulation}, 
	            $_(null, "Run simulation")
	        );

	        // When we plot data, ticks on the x-axis require some vertical padding
	        var histogramStyle = {
	            paddingBottom: (this.props.data) ? 40 : 0
	        };
	        var histogram = React.createElement("div", {style: histogramStyle}, 
	            React.createElement(Histogram, {data: this.props.data, 
	                       xAxisLabel: this.props.xAxisLabel, 
	                       yAxisLabel: this.props.yAxisLabel})
	        );

	        return React.createElement("div", null, 
	            generateTable(contents), 
	            startButton, 
	            histogram
	        );
	    },

	    calculateDisplayProportion: function() {
	        var userProportion = this.props.userProportion;

	        // If we want to display as a percentage, multiply proportion by 100.0.
	        if (this.props.proportionOrPercentage === "percentage") {
	            return Math.round(100 * userProportion);
	        } else {
	            return userProportion;
	        }
	    },

	    checkProportionValidity: function(value) {
	        return value >= 0.0 &&
	            (this.props.proportionOrPercentage === "proportion" &&
	                value <= 1.0) ||
	            (this.props.proportionOrPercentage === "percentage" &&
	                value <= 100.0);
	    },

	    handleUserProportionChange: function(value, cb) {
	        var userProportion;

	        // If "percentage" mode is enabled, user will have entered value as
	        // a percentage. However, we always store as a proportion, so we cast.
	        if (this.props.proportionOrPercentage === "percentage") {
	            userProportion = value / 100.0;
	        } else {
	            userProportion = value;
	        }

	        // If they entered a number, we may need to cap it
	        if (userProportion != null) {
	            userProportion = Math.min(1.0, Math.max(0.0, userProportion));
	        }
	        this.props.onChange({
	            userProportion: userProportion
	        }, cb);
	    },

	    handleSampleSizeChange: function(sampleSize, cb) {
	        if (sampleSize != null) {
	            sampleSize = Math.min(maxSampleSize,
	                Math.max(0, Math.floor(sampleSize)));
	        }
	        this.props.onChange({
	            sampleSize: sampleSize
	        }, cb);
	    },

	    handleRunSimulation: function() {
	        // If they haven't filled out a parameter field, highlight it.
	        if (this.props.numTrials == null ||
	                this.props.userProportion == null ||
	                this.props.sampleSize == null) {
	            this.setState({
	                invalidInput: true
	            });
	            return;
	        } else {
	            this.setState({
	                invalidInput: false
	            });
	        }
	        this.props.onChange({
	            data: this.generateData()
	        });
	    },

	    generateData: function(props) {
	        props = props || this.props;
	        var getSampleDistribution = function(sampleSize, numTrials, proportion)  {
	            var draw = function()  {
	                return this.generateNumber() < proportion;
	            }.bind(this);
	            var sampleDistribution = _.times(100 + 1, function()  {return 0;});
	            _.times(numTrials, function()  {
	                var results = _.times(sampleSize, draw);
	                var count = _.filter(results, _.identity).length;
	                var normalizedCount = Math.floor(100 * count / sampleSize);
	                sampleDistribution[normalizedCount]++;
	            });
	            return sampleDistribution;
	        }.bind(this);
	        return getSampleDistribution(props.sampleSize, props.numTrials,
	            props.userProportion);
	    },

	    /* InputPath API */
	    getInputPaths: function() {
	        return [["userProportion"], ["sampleSize"]];
	    },

	    focus: function() {
	        var path = _.head(this.getInputPaths());
	        this.focusInputPath(path);
	        return true;
	    },

	    focusInputPath: function(path) {
	        assert(path.length > 0);
	        var inputID = _.head(path);
	        var inputComponent = this.refs[inputID];
	        inputComponent.focus();
	    },

	    blurInputPath: function(path) {
	        assert(path.length > 0);
	        var inputID = _.head(path);
	        var inputComponent = this.refs[inputID];
	        inputComponent.blur();
	    },

	    getDOMNodeForPath: function(path) {
	        assert(path.length > 0);
	        var inputID = _.head(path);
	        return this.refs[inputID].getDOMNode();
	    },

	    getGrammarTypeForPath: function(path) {
	        assert(path.length > 0);
	        return "number";
	    },

	    setInputValue: function(path, newValue, cb) {
	        assert(path.length > 0);
	        var inputID = _.head(path);
	        var capitalizedID = inputID.charAt(0).toUpperCase() + inputID.slice(1);
	        var functionName = "handle" + capitalizedID + "Change";
	        this[functionName](newValue, cb);
	    },

	    getUserInput: function() {
	        return null;
	    },

	    simpleValidate: function(rubric) {
	        return Simulator.validate(this.getUserInput(), rubric);
	    }
	});

	_.extend(Simulator, {
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});

	var SimulatorEditor = React.createClass({displayName: 'SimulatorEditor',
	    mixins: [Changeable, EditorJsonify],

	    propTypes: {
	        xAxisLabel: React.PropTypes.string,
	        yAxisLabel: React.PropTypes.string,
	        numTrials: React.PropTypes.number,
	        proportionLabel: React.PropTypes.string,
	        proportionOrPercentage: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            xAxisLabel: "Proportion (%)",
	            yAxisLabel: "Number of times seen",
	            numTrials: 100,
	            proportionLabel: "Underlying proportion",
	            proportionOrPercentage: "proportion"
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-widget-simulator"}, 
	            React.createElement("div", null, 
	                $_(null, "X-Axis Label"), ":", 
	                React.createElement("input", {
	                    type: "text", 
	                    className: "graph-settings-axis-label", 
	                    value: this.props.xAxisLabel, 
	                    onChange: _.partial(this.handleTargetValueChange,
	                        "xAxisLabel")})
	            ), 
	            React.createElement("div", null, 
	                $_(null, "Y-Axis Label"), ":", 
	                React.createElement("input", {
	                    type: "text", 
	                    className: "graph-settings-axis-label", 
	                    value: this.props.yAxisLabel, 
	                    onChange: _.partial(this.handleTargetValueChange,
	                        "yAxisLabel")})
	            ), 
	            React.createElement("div", null, 
	                $_(null, "\"True Proportion\" Label"), ":", 
	                React.createElement("input", {
	                    type: "text", 
	                    className: "graph-settings-axis-label", 
	                    value: this.props.proportionLabel, 
	                    onChange: _.partial(this.handleTargetValueChange,
	                        "proportionLabel")}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "This text will be displayed next to the box in which" + ' ' +
	                        "the user enters the sample proportion for their" + ' ' +
	                        "simulation. For example, if your question is about" + ' ' +
	                        "surveying for approval ratings, you might want this to" + ' ' +
	                        "say \"Sample approval rating\".")
	                )
	            ), 
	            React.createElement("div", null, 
	                $_(null, "Proportion or Percentage"), ":", 
	                React.createElement("select", {
	                    className: "perseus-widget-dropdown", 
	                    value: this.props.proportionOrPercentage, 
	                    onChange: _.partial(this.handleTargetValueChange,
	                        "proportionOrPercentage")}, 
	                        React.createElement("option", {key: "proportion", value: "proportion"}, 
	                            "Proportion"
	                        ), 
	                        React.createElement("option", {key: "percentage", value: "percentage"}, 
	                            "Percentage"
	                        )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Do you want the user to describe their simulation in" + ' ' +
	                        "terms of a proportion or a percentage?")
	                )
	            ), 
	            React.createElement("div", null, 
	                $_(null, "Number of trials"), ":", 
	                React.createElement(NumberInput, {
	                    value: this.props.numTrials, 
	                    checkValidity: function(val)  {
	                        return val >= 0 && val <= maxTrials;
	                    }, 
	                    onChange: this.change("numTrials")}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "This controls the number of trials used in the" + ' ' +
	                       "simulation. For example, if you set this to 50, then the" + ' ' +
	                       "survey will be conducted 50 times. Warning: setting" + ' ' +
	                       "this too high (i.e., greater than 5000 or so) will" + ' ' +
	                       "freeze the page.")
	                )
	            )
	        );
	    },

	    handleTargetValueChange: function(propName, e) {
	        this.change(propName, e.target.value);
	    }
	});

	var propTransform = function(editorProps)  {
	    var widgetProps = _.clone(editorProps);
	    widgetProps.randomSeed = editorProps.problemNum;
	    return widgetProps;
	};

	module.exports = {
	    name: "simulator",
	    displayName: "Simulator",
	    widget: Simulator,
	    editor: SimulatorEditor,
	    transform: propTransform
	};


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);

	var PerseusMarkdown = __webpack_require__(57);
	var mdParse = PerseusMarkdown.parse;
	var mdOutput = PerseusMarkdown.basicOutput;

	var TextArea = React.createClass({displayName: 'TextArea',
	    render: function() {
	        return React.createElement("textarea", {
	            ref: "input", 
	            value: this.props.value || "", 
	            onChange: this.changeValue});
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    changeValue: function(e) {
	        // Translating from the js event e to the value
	        // of the textbox to send to onChange
	        this.props.onChange(e.target.value);
	    }
	});

	var SimpleMarkdownTester = React.createClass({displayName: 'SimpleMarkdownTester',
	    propTypes: {
	        value: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            value: ""
	        };
	    },

	    mixins: [Changeable],

	    toJSON: function() {
	        return {};
	    },

	    render: function() {
	        var parsed = mdParse(this.props.value);
	        var output = mdOutput(parsed);
	        return React.createElement("div", null, 
	            output
	        );
	    },

	    /**
	     * Widgets that are focusable should add a focus method that returns
	     * true if focusing succeeded. The first such widget found will be
	     * focused on page load.
	     */
	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    },

	    /**
	     * simpleValidate is called for grading. Rubric is the result of calling
	     * toJSON() on the editor that created this widget.
	     *
	     * Should return an object representing the grading result, such as
	     * {
	     *     type: "points",
	     *     earned: 1,
	     *     total: 1,
	     *     message: null
	     * }
	     */
	    simpleValidate: function(rubric) {
	        return SimpleMarkdownTester.validate(this.toJSON(), rubric);
	    }
	});


	/**
	 * This is the widget's grading function
	 */
	_.extend(SimpleMarkdownTester, {
	    /**
	     * simpleValidate generally defers to this function
	     *
	     * state is usually the result of toJSON on the widget
	     * rubric is the result of calling toJSON() on the editor
	     */
	    validate: function(state, rubric) {
	        return {
	            type: "points",
	            earned: 0,
	            total: 0,
	            message: null
	        };
	    }
	});


	/**
	 * This is the widget's editor. This is what shows up on the left side
	 * of the screen in test.html. Only the question writer sees this.
	 */
	var SimpleMarkdownTesterEditor = React.createClass({displayName: 'SimpleMarkdownTesterEditor',
	    mixins: [Changeable, EditorJsonify],

	    getDefaultProps: function() {
	        return {
	            value: ""
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement("label", null, 
	                React.createElement("div", null, "Simple markdown contents:"), 
	                React.createElement("div", null, 
	                    React.createElement(TextArea, {
	                        value: this.props.value, 
	                        onChange: this.change("value"), 
	                        ref: "input"})
	                )
	            )
	        );
	    },

	    focus: function() {
	        this.refs.input.focus();
	        return true;
	    }
	});


	/**
	 * For this widget to work, we must require() this file in src/all-widgets.js
	 */
	module.exports = {
	    name: "simple-markdown-tester",
	    displayName: "Simple Markdown Tester",
	    hidden: true,   // Hides this widget from the Perseus.Editor widget select
	    widget: SimpleMarkdownTester,
	    editor: SimpleMarkdownTesterEditor,
	    transform: _.identity
	};


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	var React          = __webpack_require__(68);
	var InfoTip        = __webpack_require__(75);
	var _ = __webpack_require__(67);

	var PropCheckBox   = __webpack_require__(65);
	var Sortable       = __webpack_require__(98);
	var TextListEditor = __webpack_require__(79);

	var shuffle = __webpack_require__(5).shuffle;

	var HORIZONTAL = "horizontal",
	    VERTICAL = "vertical";

	var Sorter = React.createClass({displayName: 'Sorter',
	    propTypes: {
	        correct: React.PropTypes.array,
	        layout: React.PropTypes.oneOf([HORIZONTAL, VERTICAL]),
	        padding: React.PropTypes.bool,
	        problemNum: React.PropTypes.number,
	        onChange: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            correct: [],
	            layout: HORIZONTAL,
	            padding: true,
	            problemNum: 0,
	            onChange: function() {}
	        };
	    },

	    render: function() {
	        var options = shuffle(
	            this.props.correct,
	            this.props.problemNum,
	            /* ensurePermuted */ true
	        );

	        return React.createElement("div", {className: "perseus-widget-sorter ui-helper-clearfix"}, 
	            React.createElement(Sortable, {
	                options: options, 
	                layout: this.props.layout, 
	                padding: this.props.padding, 
	                onChange: this.props.onChange, 
	                ref: "sortable"})
	        );
	    },

	    getUserInput: function() {
	        return {options: this.refs.sortable.getOptions()};
	    },

	    simpleValidate: function(rubric) {
	        return Sorter.validate(this.getUserInput(), rubric);
	    }
	});


	_.extend(Sorter, {
	    validate: function(state, rubric) {
	        var correct = _.isEqual(state.options, rubric.correct);

	        return {
	            type: "points",
	            earned: correct ? 1 : 0,
	            total: 1,
	            message: null
	        };
	    }
	});


	var SorterEditor = React.createClass({displayName: 'SorterEditor',
	    propTypes: {
	        correct: React.PropTypes.array,
	        layout: React.PropTypes.oneOf([HORIZONTAL, VERTICAL]),
	        padding: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            correct: ["$x$", "$y$", "$z$"],
	            layout: HORIZONTAL,
	            padding: true
	        };
	    },

	    render: function() {
	        var editor = this;

	        return React.createElement("div", null, 
	            React.createElement("div", null, 
	                ' ', "Correct answer:", ' ', 
	                React.createElement(InfoTip, null, React.createElement("p", null, 
	                    "Enter the correct answer (in the correct order) here. The" + ' ' +
	                    "preview on the right will have the cards in a randomized" + ' ' +
	                    "order, which is how the student will see them."
	                ))
	            ), 
	            React.createElement(TextListEditor, {
	                options: this.props.correct, 
	                onChange: function(options, cb) {
	                    editor.props.onChange({correct: options}, cb);
	                }, 
	                layout: this.props.layout}), 
	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    ' ', "Layout:", ' ', 
	                    React.createElement("select", {value: this.props.layout, 
	                            onChange: this.onLayoutChange}, 
	                        React.createElement("option", {value: HORIZONTAL}, "Horizontal"), 
	                        React.createElement("option", {value: VERTICAL}, "Vertical")
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Use the horizontal layout for short text and small" + ' ' +
	                    "images. The vertical layout is best for longer text and" + ' ' +
	                    "larger images.")
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement(PropCheckBox, {
	                    label: "Padding:", 
	                    padding: this.props.padding, 
	                    onChange: this.props.onChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "Padding is good for text, but not needed for images.")
	                )
	            )
	        );
	    },

	    onLayoutChange: function(e) {
	        this.props.onChange({layout: e.target.value});
	    },

	    serialize: function() {
	        return _.pick(this.props, "correct", "layout", "padding");
	    }
	});

	module.exports = {
	    name: "sorter",
	    displayName: "Sorter",
	    widget: Sorter,
	    editor: SorterEditor
	};


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Editor = __webpack_require__(11);
	var InfoTip = __webpack_require__(75);
	var MathOutput = __webpack_require__(96);
	var NumberInput  = __webpack_require__(94);
	var Renderer = __webpack_require__(15);
	var Util = __webpack_require__(5);

	var ApiOptions = __webpack_require__(17).Options;

	var assert = __webpack_require__(97).assert;

	/* Input handling: Maps a (row, column) pair to a unique ref used by React,
	 * and extracts (row, column) pairs from input paths, used to allow outsiders
	 * to focus, blur, set input values, etc. */
	var getInputPath = function(row, column) {
	    return ["" + row, "" + column];
	};

	var getDefaultPath = function() {
	    return getInputPath(0, 0);
	};

	var getRowFromPath = function(path) {
	    // 'path' should be a (row, column) pair
	    assert(_.isArray(path) && path.length === 2);
	    return +path[0];
	};

	var getColumnFromPath = function(path) {
	    // 'path' should be a (row, column) pair
	    assert(_.isArray(path) && path.length === 2);
	    return +path[1];
	};

	var getRefForPath = function(path) {
	    var row = getRowFromPath(path);
	    var column = getColumnFromPath(path);
	    return "answer" + row + "," + column;
	};

	var Table = React.createClass({displayName: 'Table',
	    propTypes: {
	        editableHeaders: React.PropTypes.bool,
	        headers: React.PropTypes.arrayOf(React.PropTypes.string),
	        answers: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(
	                React.PropTypes.string
	            )
	        )
	    },

	    getDefaultProps: function() {
	        var defaultRows = 4;
	        var defaultColumns = 1;
	        var blankAnswers = _(defaultRows).times(function() {
	            return Util.stringArrayOfSize(defaultColumns);
	        });
	        return {
	            apiOptions: ApiOptions.defaults,
	            headers: [""],
	            editableHeaders: false,
	            rows: defaultRows,
	            columns: defaultColumns,
	            answers: blankAnswers,
	        };
	    },

	    _getRows: function() {
	        return this.props.answers.length;
	    },

	    _getColumns: function() {
	        return this.props.answers[0].length;
	    },

	    render: function() {
	        var rows = this._getRows();
	        var columns = this._getColumns();
	        var headers = this.props.headers;

	        var InputComponent;
	        if (this.props.apiOptions.staticRender) {
	            InputComponent = MathOutput;
	        } else {
	            InputComponent = "input";
	        }

	        return React.createElement("table", {className: "perseus-widget-table-of-values non-markdown"}, 
	            React.createElement("thead", null, 
	                React.createElement("tr", null, 
	                    _.map(headers, function(header, i)  {
	                        if (this.props.editableHeaders) {
	                            return React.createElement("th", {key: i}, 
	                                React.createElement(Editor, {
	                                    ref: "columnHeader" + i, 
	                                    content: header, 
	                                    widgetEnabled: false, 
	                                    onChange: 
	                                        _.partial(this.onHeaderChange, i)
	                                    }
	                                )
	                            );
	                        } else {
	                            return React.createElement("th", {key: i}, 
	                                React.createElement(Renderer, {content: header})
	                            );
	                        }
	                    }.bind(this))
	                
	                )
	            ), 
	            React.createElement("tbody", null, 
	                _(rows).times(function(r)  {
	                    return React.createElement("tr", {key: r}, 
	                        _(columns).times(function(c)  {
	                            return React.createElement("td", {key: c}, 
	                                React.createElement(InputComponent, {
	                                    ref: getRefForPath(getInputPath(r, c)), 
	                                    type: "text", 
	                                    value: this.props.answers[r][c], 
	                                    onFocus: _.partial(
	                                        this._handleFocus, getInputPath(r, c)
	                                    ), 
	                                    onBlur: _.partial(
	                                        this._handleBlur, getInputPath(r, c)
	                                    ), 
	                                    onChange: 
	                                        _.partial(this.onValueChange, r, c)
	                                    })
	                            );
	                        }.bind(this))
	                    );
	                }.bind(this))
	            
	            )
	        );
	    },

	    getUserInput: function() {
	        return _.map(this.props.answers, _.clone);
	    },

	    onValueChange: function(row, column, e) {
	        var answers = _.map(this.props.answers, _.clone);
	        answers[row][column] = e.target.value;
	        this.props.onChange({
	            answers: answers
	        });
	    },

	    onHeaderChange: function(index, e) {
	        var headers = this.props.headers.slice();
	        headers[index] = e.content;
	        this.props.onChange({
	            headers: headers
	        });
	    },

	    simpleValidate: function(rubric) {
	        return Table.validate(this.getUserInput(), rubric);
	    },

	    _handleFocus: function(inputPath) {
	        this.props.onFocus(inputPath);
	    },

	    _handleBlur: function(inputPath) {
	        this.props.onBlur(inputPath);
	    },

	    focus: function() {
	        this.focusInputPath(getDefaultPath());
	        return true;
	    },

	    focusInputPath: function(path) {
	        var inputID = getRefForPath(path);
	        var inputComponent = this.refs[inputID];
	        if (this.props.apiOptions.staticRender) {
	            inputComponent.focus();
	        } else {
	            inputComponent.getDOMNode().focus();
	        }
	    },

	    blurInputPath: function(path) {
	        var inputID = getRefForPath(path);
	        var inputComponent = this.refs[inputID];
	        if (this.props.apiOptions.staticRender) {
	            inputComponent.blur();
	        } else {
	            inputComponent.getDOMNode().blur();
	        }
	    },

	    getDOMNodeForPath: function(path) {
	        var inputID = getRefForPath(path);
	        return this.refs[inputID].getDOMNode();
	    },

	    getInputPaths: function() {
	        var rows = this._getRows();
	        var columns = this._getColumns();
	        var inputPaths = [];
	        _(rows).times(function(r)  {
	            _(columns).times(function(c)  {
	                var inputPath = getInputPath(r, c);
	                inputPaths.push(inputPath);
	            });
	        });
	        return inputPaths;
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "number";
	    },

	    setInputValue: function(path, newValue, cb) {
	        // Extract row, column information
	        var row = getRowFromPath(path);
	        var column = getColumnFromPath(path);

	        var answers = _.map(this.props.answers, _.clone);
	        answers[row][column] = newValue;
	        this.props.onChange({
	            answers: answers
	        }, cb);
	    }
	});

	_.extend(Table, {
	    validate: function(state, rubric) {
	        var filterNonEmpty = function (table) {
	            return _.filter(table, function (row) {

	                // Check if row has a cell that is nonempty
	                return _.some(row, _.identity);
	            });
	        };
	        var solution = filterNonEmpty(rubric.answers);
	        var supplied = filterNonEmpty(state);
	        var hasEmptyCell = _.some(supplied, function(row) {
	            return _.some(row, function(cell) {
	                return cell === "";
	            });
	        });
	        if (hasEmptyCell || !supplied.length) {
	            return {
	                type: "invalid",
	                message: null
	            };
	        }
	        if (supplied.length !== solution.length) {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	        var createValidator = Khan.answerTypes
	                                  .number.createValidatorFunctional;
	        var message = null;
	        var allCorrect = _.every(solution, function (rowSolution) {
	            var i;
	            for (i = 0; i < supplied.length; i++) {
	                var rowSupplied = supplied[i];
	                var correct = _.every(rowSupplied, function (cellSupplied, i) {
	                    var cellSolution = rowSolution[i];
	                    var validator = createValidator(
	                            cellSolution, {
	                                simplify: true
	                            });
	                    var result = validator(cellSupplied);
	                    if (result.message) {
	                        message = result.message;
	                    }
	                    return result.correct;
	                });
	                if (correct) {
	                    supplied.splice(i, 1);
	                    return true;
	                }
	            }
	            return false;
	        });
	        return {
	            type: "points",
	            earned: allCorrect ? 1 : 0,
	            total: 1,
	            message: message
	        };
	    }
	});

	var TableEditor = React.createClass({displayName: 'TableEditor',
	    propTypes: {
	        rows: React.PropTypes.number,
	        columns: React.PropTypes.number,
	        headers: React.PropTypes.arrayOf(React.PropTypes.string),
	        answers: React.PropTypes.arrayOf(
	            React.PropTypes.arrayOf(
	                React.PropTypes.string
	            )
	        )
	    },

	    getDefaultProps: function() {
	        var defaultRows = 4;
	        var defaultColumns = 1;
	        var blankAnswers = _(defaultRows).times(function() {
	            return Util.stringArrayOfSize(defaultColumns);
	        });
	        return {
	            headers: [""],
	            rows: defaultRows,
	            columns: defaultColumns,
	            answers: blankAnswers
	        };
	    },

	    focus: function() {
	        this.refs.numberOfColumns.getDOMNode().focus();
	    },

	    render: function() {
	        var rows = this.props.rows;
	        var cols = this.props.columns;

	        var tableProps = _.pick(this.props, "headers", "answers", "onChange");
	        _.extend(tableProps, {
	            editableHeaders: true
	        });

	        return React.createElement("div", null, 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, 
	                    "Number of columns:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        ref: "numberOfColumns", 
	                        value: this.props.columns, 
	                        onChange: function(val)  {
	                            if (val) {
	                                this.onSizeInput(this.props.rows, val);
	                            }
	                        }.bind(this), 
	                        useArrowKeys: true})
	                )
	            ), 
	            React.createElement("div", {className: "perseus-widget-row"}, 
	                React.createElement("label", null, 
	                    "Number of rows:", 
	                    " ", 
	                    React.createElement(NumberInput, {
	                        ref: "numberOfRows", 
	                        value: this.props.rows, 
	                        onChange: function(val)  {
	                            if (val) {
	                                this.onSizeInput(val, this.props.columns);
	                            }
	                        }.bind(this), 
	                        useArrowKeys: true})
	                )
	            ), 
	            React.createElement("div", null, 
	                ' ', "Table of answers:", ' ', 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, "The student has to fill out all cells in the" + ' ' +
	                    "table.  For partially filled tables create a table" + ' ' +
	                    "using the template, and insert text input boxes" + ' ' +
	                    "as desired.")
	                )
	            ), 
	            React.createElement("div", null, 
	                React.createElement(Table, React.__spread({},  tableProps))
	            )
	        );
	    },

	    onSizeInput: function(numRawRows, numRawColumns) {
	        var rows = +numRawRows || 0;
	        var columns = +numRawColumns || 0;
	        rows = Math.min(Math.max(1, rows), 30);
	        columns = Math.min(Math.max(1, columns), 6);
	        var oldColumns = this.props.columns;
	        var oldRows = this.props.rows;

	        var answers = this.props.answers;
	        // Truncate if necessary; else, append
	        if (rows <= oldRows) {
	            answers.length = rows;
	        } else {
	            _(rows - oldRows).times(function() {
	                answers.push(Util.stringArrayOfSize(oldColumns));
	            });
	        }

	        function fixColumnSizing(array) {
	            // Truncate if necessary; else, append
	            if (columns <= oldColumns) {
	                array.length = columns;
	            } else {
	                _(columns - oldColumns).times(function() {
	                    array.push("");
	                });
	            }
	        }

	        var headers = this.props.headers;
	        fixColumnSizing(headers);
	        _.each(answers, fixColumnSizing);

	        this.props.onChange({
	            rows: rows,
	            columns: columns,
	            answers: answers,
	            headers: headers
	        });
	    },

	    serialize: function() {
	        var json = _.pick(this.props, "headers", "rows", "columns");

	        return _.extend({}, json, {
	            answers: _.map(this.props.answers, _.clone)
	        });
	    }
	});

	var propTransform = function(editorProps)  {
	    // Remove answers before passing to widget
	    var rows = editorProps.answers.length;
	    var columns = editorProps.answers[0].length;
	    var blankAnswers = _(rows).times(function() {
	        return Util.stringArrayOfSize(columns);
	    });
	    return _.extend({}, editorProps, {
	        answers: blankAnswers
	    });
	};

	module.exports = {
	    name: "table",
	    displayName: "Table of values",
	    accessible: true,
	    widget: Table,
	    editor: TableEditor,
	    transform: propTransform
	};


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Graph         = __webpack_require__(95);
	var GraphSettings = __webpack_require__(88);
	var InfoTip       = __webpack_require__(75);
	var NumberInput   = __webpack_require__(94);
	var MathOutput    = __webpack_require__(96);
	var PropCheckBox  = __webpack_require__(65);
	var TeX           = __webpack_require__(73);

	var ApiOptions = __webpack_require__(17).Options;

	var ROTATE_SNAP_DEGREES = 15;
	var DEGREE_SIGN = "\u00B0";
	var RENDER_TRANSFORM_DELAY_IN_MS = 300;
	var ROTATE_HANDLE_DIST = 1.5;
	var REFLECT_ROTATE_HANDLE_DIST = 2;
	var REFLECT_BUTTON_SIZE = 1;

	var deepEq = __webpack_require__(5).deepEq;
	var getGridStep = __webpack_require__(5).getGridStep;
	var captureScratchpadTouchStart =
	        __webpack_require__(5).captureScratchpadTouchStart;

	var knumber = __webpack_require__(113).number;
	var kvector = __webpack_require__(113).vector;
	var kpoint = __webpack_require__(113).point;
	var kray = __webpack_require__(113).ray;
	var kline = __webpack_require__(113).line;

	var assert = __webpack_require__(97).assert;

	var defaultBoxSize = 400;
	var defaultBackgroundImage = {
	    url: null
	};

	function arraySum(array) {
	    return _.reduce(array, function(memo, arg) { return memo + arg; }, 0);
	}

	/* Does a pluck on keys inside objects in an object
	 *
	 * Ex:
	 * tools = {
	 *     translation: {
	 *         enabled: true
	 *     },
	 *     rotation: {
	 *         enabled: false
	 *     }
	 * };
	 * pluckObject(tools, "enabled") returns {
	 *     translation: true
	 *     rotation: false
	 * }
	 */
	function pluckObject(object, subKey) {
	    return _.object(_.map(object, function (value, key) {
	        return [key, value[subKey]];
	    }));
	}


	var defaultGraphProps = function(setProps, boxSize) {
	    setProps = setProps || {};
	    var labels = setProps.labels || ["x", "y"];
	    var range = setProps.range || [[-10, 10], [-10, 10]];
	    var step = setProps.step || [1, 1];
	    var gridStep = setProps.gridStep ||
	               getGridStep(range, step, boxSize);
	    return {
	        box: [boxSize, boxSize],
	        labels: labels,
	        range: range,
	        step: step,
	        gridStep: gridStep,
	        valid: true,
	        backgroundImage: defaultBackgroundImage,
	        markings: "grid",
	        showProtractor: false
	    };
	};

	var defaultTransformerProps = {
	    apiOptions: ApiOptions.defaults,
	    gradeEmpty: false,
	    graphMode: "interactive",
	    listMode: "dynamic",
	    graph: {},
	    tools: {
	        translation: {
	            enabled: true,
	            required: false,
	            constraints: {}
	        },
	        rotation: {
	            enabled: true,
	            required: false,
	            constraints: {
	                fixed: false
	            },
	            coord: [1, 6]
	        },
	        reflection: {
	            enabled: true,
	            required: false,
	            constraints: {
	                fixed: false
	            },
	            coords: [[2, -4], [2, 2]]
	        },
	        dilation: {
	            enabled: true,
	            required: false,
	            constraints: {
	                fixed: false
	            },
	            coord: [6, 6]
	        }
	    },
	    drawSolutionShape: true,
	    starting: {
	        shape: {
	            type: "polygon-3",
	            coords: [[2, 2], [2, 6], [7, 2]],
	        },
	        transformations: []
	    },
	    correct: {
	        shape: {
	            type: "polygon-3",
	            coords: [[2, 2], [2, 6], [7, 2]],
	        },
	        transformations: []
	    }
	};

	function colorForTool(tool) {
	    return tool.constraints.fixed ? KhanUtil.DYNAMIC
	                                  : KhanUtil.INTERACTIVE;
	}


	/* Scales a distance from the default range of
	 * [-10, 10] to a given props.range pair
	 *
	 * Used for sizing various transformation tools
	 * (rotation handle, dilation circle)
	 */
	function scaleToRange(dist, range) {
	    var spreadX = range[0][1] - range[0][0];
	    var spreadY = range[1][1] - range[1][0];

	    return dist * Math.max(spreadX, spreadY) / 20;
	}

	function dilatePointFromCenter(point, dilationCenter, scale) {
	    var pv = kvector.subtract(point, dilationCenter);
	    var pvScaled = kvector.scale(pv, scale);
	    var transformedPoint = kvector.add(dilationCenter, pvScaled);
	    return transformedPoint;
	}

	// TODO(jack): i18nize this
	function stringFromDecimal(number) {
	    return String(KhanUtil.roundTo(9, number));
	}

	function stringFromFraction(number) {
	    var frac = KhanUtil.toFraction(number, knumber.DEFAULT_TOLERANCE);
	    if (frac[1] === 1) {
	        return stringFromDecimal(number);
	    } else {
	        return stringFromDecimal(frac[0]) + "/" +
	                stringFromDecimal(frac[1]);
	    }
	}

	function texFromPoint(point) {
	    return [
	        React.createElement(TeX, null, "("),
	        stringFromDecimal(point[0]),
	        React.createElement(TeX, null, ", {}"),
	        stringFromDecimal(point[1]),
	        React.createElement(TeX, null, ")")
	    ];
	}

	function texFromVector(vector) {
	    return [
	        React.createElement(TeX, null, "\\langle"),
	        stringFromDecimal(vector[0]),
	        React.createElement(TeX, null, ", {}"),
	        stringFromDecimal(vector[1]),
	        React.createElement(TeX, null, "\\rangle")
	    ];
	}

	function texFromAngleDeg(angleDeg) {
	    return stringFromDecimal(angleDeg) + DEGREE_SIGN;
	}

	function orderInsensitiveCoordsEqual(coords1, coords2) {
	    coords1 = _.clone(coords1).sort(kpoint.compare);
	    coords2 = _.clone(coords2).sort(kpoint.compare);
	    return _.all(_.map(coords1, function(coord1, i) {
	        var coord2 = coords2[i];
	        return kpoint.equal(coord1, coord2);
	    }));
	}



	/* Perform operations on raw transform objects */
	var TransformOps = {
	    apply: function(transform) {
	        // Any transformation with empty text boxes is a no-op until
	        // filled out (these show up as nulls in transform.vector/line/etc).
	        // TODO (jack): Merge this just into reflections now that other
	        // transforms are always valid (after merging transformation
	        // collapsing, which may use isValid)
	        if (!Transformations[transform.type].isValid(transform)) {
	            return _.identity;  // do not transform the coord
	        } else {
	            return Transformations[transform.type].apply(transform);
	        }
	    },

	    append: function(transformList, newTransform) {
	        // Append newTransform to transformList, and collapse the last
	        // two transforms if they are collapsable
	        var results = TransformOps._appendAndCollapseLastTwo(
	            transformList,
	            newTransform
	        );
	        // Collapse any no-ops at the end of the transformation list
	        return TransformOps._collapseFinalNoOps(results);
	    },

	    _collapseFinalNoOps: function(transforms) {
	        // Collapse no-op transformations at the end of the list
	        if (transforms.length && TransformOps.isNoOp(_.last(transforms))) {
	            return _.initial(transforms);
	        } else {
	            return transforms;
	        }
	    },

	    _appendAndCollapseLastTwo: function(transformList, newTransform) {
	        if (!transformList.length) {
	            return [newTransform];
	        } else {
	            var collapsed = TransformOps.collapse(
	                _.last(transformList),
	                newTransform
	            );
	            return _.initial(transformList).concat(collapsed);
	        }
	    },

	    isNoOp: function(transform) {
	        return Transformations[transform.type].isNoOp(transform);
	    },

	    collapse: function(transform1, transform2) {
	        // We can only collapse transforms that have the same type
	        if (transform1.type !== transform2.type) {
	            return [transform1, transform2];
	        }

	        // Clicking the button again removes empty transformations
	        if (TransformOps.isEmpty(transform1) &&
	                TransformOps.isEmpty(transform2)) {
	            return [];
	        }

	        // Don't collapse invalid transformations otherwise
	        if (!TransformOps.isValid(transform1) ||
	                !TransformOps.isValid(transform2)) {
	            return [transform1, transform2];
	        }

	        return TransformOps._collapseValidMonotypedTransforms(
	            transform1,
	            transform2
	        );
	    },

	    isValid: function(transform) {
	        return Transformations[transform.type].isValid(transform);
	    },

	    isEmpty: function(transform) {
	        return Transformations[transform.type].isEmpty(transform);
	    },

	    _collapseValidMonotypedTransforms: function(transform1, transform2) {
	        var collapsed = Transformations[transform1.type].collapse(
	            transform1,
	            transform2
	        );
	        if (collapsed) {
	            // Force all answers into an array
	            if (!_.isArray(collapsed)) {
	                collapsed = [collapsed];
	            }
	            // Add types to all transforms in the answer
	            _.each(collapsed, function(transform) {
	                transform.type = transform1.type;
	            });
	            return collapsed;
	        } else {
	            // These transforms can't be collapsed together
	            return [transform1, transform2];
	        }
	    },

	    toTeX: function(transform) {
	        return Transformations[transform.type].toTeX(transform);
	    },

	    /* A react representation of this transform object */
	    ListItem: React.createClass({displayName: 'ListItem',
	        render: function() {
	            if (this.props.mode === "dynamic") {
	                return React.createElement("div", null, 
	                    TransformOps.toTeX(this.props.transform)
	                );
	            } else if (this.props.mode === "interactive") {
	                var TransformClass =
	                        Transformations[this.props.transform.type].Input;
	                return React.createElement(TransformClass, React.__spread({
	                    ref: "transform", 
	                    onChange: this.handleChange, 
	                    onFocus: this.props.onFocus, 
	                    onBlur: this.props.onBlur, 
	                    apiOptions: this.props.apiOptions}, 
	                    this.props.transform)
	                    );
	            } else {
	                throw new Error("Invalid mode: " + this.props.mode);
	            }
	        },
	        value: function() {
	            if (this.props.mode === "interactive") {
	                return _.extend({
	                    type: this.props.transform.type,
	                }, this.refs.transform.value());
	            } else {
	                return this.props.transform;
	            }
	        },
	        handleChange: _.debounce(function(callback) {
	            this.props.onChange(this.value(), callback);
	        }, RENDER_TRANSFORM_DELAY_IN_MS),

	        /* InputPath API: depending on the API call, this could involve simply
	         * navigating to the right ref and calling the function on that
	         * component, or threading the call down and returning the result. */
	        _getComponentAtPath: function(path) {
	            var transform = this.refs.transform;
	            var ref = _.head(path);
	            return transform.refs[ref];
	        },
	        focus: function() {
	            var transform = this.refs.transform;
	            var path = _.head(transform.getInputPaths());
	            if (path) {
	                this.focusInputPath(path);
	            }
	        },
	        focusInputPath: function(path) {
	            this._getComponentAtPath(path).focus();
	        },
	        blurInputPath: function(path) {
	            this._getComponentAtPath(path).blur();
	        },
	        getDOMNodeForPath: function(path) {
	            return this._getComponentAtPath(path).getDOMNode();
	        },
	        getGrammarTypeForPath: function(path) {
	            return "number";
	        },
	        setInputValue: function(path, value, cb) {
	            this.refs.transform.setInputValue(path, value, cb);
	        },
	        getInputPaths: function() {
	            return this.refs.transform.getInputPaths();
	        }
	    })
	};

	var Transformations = {
	    translation: {
	        // I18N: As in the command, "Translate the polygon"
	        verbName: $._("Translate"),
	        nounName: $._("Translation"),
	        lowerNounName: $._("translation"),
	        apply: function(transform) {
	            return function(coord) {
	                return kvector.add(coord, transform.vector);
	            };
	        },
	        isValid: function(transform) {
	            return _.isFinite(transform.vector[0]) &&
	                _.isFinite(transform.vector[1]);
	        },
	        isEmpty: function(transform) {
	            return transform.vector[0] === null &&
	                transform.vector[1] === null;
	        },
	        isNoOp: function(transform) {
	            return kvector.equal(transform.vector, [0, 0]);
	        },
	        collapse: function(transform1, transform2) {
	            return {
	                vector: kvector.add(
	                    transform1.vector,
	                    transform2.vector
	                )
	            };
	        },
	        toTeX: function(transform) {
	            // I18N: As in the command, "Translation by <3, 1>"
	            return $_({vector: texFromVector(transform.vector)}, 
	                "Translation by %(vector)s"
	            );
	        },
	        Input: React.createClass({displayName: 'Input',
	            getInitialState: function() {
	                return {
	                    vector: this.props.vector || [null, null]
	                };
	            },
	            componentDidUpdate: function(prevProps) {
	                if (!deepEq(this.props, prevProps)) {
	                    this.setState({vector: this.props.vector});
	                }
	            },
	            render: function() {
	                var InputComponent = (this.props.apiOptions.staticRender) ?
	                        MathOutput :
	                        NumberInput;
	                var vector = [
	                    React.createElement(TeX, null, "\\langle"),
	                    React.createElement(InputComponent, {
	                        ref: "x", 
	                        placeholder: 0, 
	                        value: this.state.vector[0], 
	                        useArrowKeys: true, 
	                        onChange: function(val0)  {
	                            var val1 = this.state.vector[1];
	                            this.setState({vector: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "x"), 
	                        onBlur: _.partial(this.props.onBlur, "x")}),
	                    React.createElement(TeX, null, ", {}"),
	                    React.createElement(InputComponent, {
	                        ref: "y", 
	                        placeholder: 0, 
	                        value: this.state.vector[1], 
	                        useArrowKeys: true, 
	                        onChange: function(val1)  {
	                            var val0 = this.state.vector[0];
	                            this.setState({vector: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "y"), 
	                        onBlur: _.partial(this.props.onBlur, "y")}),
	                    React.createElement(TeX, null, "\\rangle")
	                ];
	                return React.createElement("div", null, 
	                    $_({vector: vector}, 
	                        "Translation by %(vector)s"
	                    )
	                );
	            },
	            value: function() {
	                var x = this.refs.x.getValue();
	                var y = this.refs.y.getValue();
	                return {
	                    vector: [x, y]
	                };
	            },
	            /* InputPath API */
	            setInputValue: function(path, value, cb) {
	                var id = _.first(path);
	                var vector = _.clone(this.state.vector);
	                if (id === "x") {
	                    vector[0] = value;
	                } else if (id === "y") {
	                    vector[1] = value;
	                }
	                this.setState({vector: vector}, function()  {
	                    this.props.onChange(cb);
	                }.bind(this));
	            },
	            getInputPaths: function() {
	                return [["x"], ["y"]];
	            }
	        })
	    },

	    rotation: {
	        // I18N: As in the command, "Rotate the polygon"
	        verbName: $._("Rotate"),
	        nounName: $._("Rotation"),
	        lowerNounName: $._("rotation"),
	        apply: function(transform) {
	            return function(coord) {
	                return kpoint.rotateDeg(coord, transform.angleDeg,
	                        transform.center);
	            };
	        },
	        isValid: function(transform) {
	            return _.isFinite(transform.angleDeg) &&
	                _.isFinite(transform.center[0]) &&
	                _.isFinite(transform.center[1]);
	        },
	        isEmpty: function(transform) {
	            return transform.angleDeg === null &&
	                transform.center[0] === null &&
	                transform.center[1] === null;
	        },
	        isNoOp: function(transform) {
	            return knumber.equal(transform.angleDeg, 0);
	        },
	        collapse: function(transform1, transform2) {
	            if (!kpoint.equal(transform1.center, transform2.center)) {
	                return false;
	            }
	            return {
	                center: transform1.center,
	                angleDeg: transform1.angleDeg + transform2.angleDeg
	            };
	        },
	        toTeX: function(transform) {
	            return $_({degrees: texFromAngleDeg(transform.angleDeg), 
	                       point: texFromPoint(transform.center)}, 
	                "Rotation by %(degrees)s about %(point)s"
	            );
	        },
	        Input: React.createClass({displayName: 'Input',
	            getInitialState: function() {
	                return {
	                    center: this.props.center || [null, null],
	                    angleDeg: this.props.angleDeg || null
	                };
	            },
	            componentDidUpdate: function(prevProps) {
	                if (!deepEq(this.props, prevProps)) {
	                    this.setState({
	                        center: this.props.center,
	                        angleDeg: this.props.angleDeg
	                    });
	                }
	            },
	            render: function() {
	                var InputComponent = (this.props.apiOptions.staticRender) ?
	                        MathOutput :
	                        NumberInput;
	                var point = [
	                    React.createElement(TeX, null, "("),
	                    React.createElement(InputComponent, {
	                        ref: "centerX", 
	                        placeholder: 0, 
	                        value: this.state.center[0], 
	                        useArrowKeys: true, 
	                        onChange: function(val0)  {
	                            var val1 = this.state.center[1];
	                            this.setState({center: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "centerX"), 
	                        onBlur: _.partial(this.props.onBlur, "centerX")}),
	                    React.createElement(TeX, null, ", {}"),
	                    React.createElement(InputComponent, {
	                        ref: "centerY", 
	                        placeholder: 0, 
	                        value: this.state.center[1], 
	                        useArrowKeys: true, 
	                        onChange: function(val1)  {
	                            var val0 = this.state.center[0];
	                            this.setState({center: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "centerY"), 
	                        onBlur: _.partial(this.props.onBlur, "centerY")}),
	                    React.createElement(TeX, null, ")")
	                ];
	                var degrees = [
	                    React.createElement(InputComponent, {
	                        ref: "angleDeg", 
	                        placeholder: 0, 
	                        value: this.state.angleDeg, 
	                        useArrowKeys: true, 
	                        onChange: function(val)  {
	                            this.setState({angleDeg: val}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "angleDeg"), 
	                        onBlur: _.partial(this.props.onBlur, "angleDeg")}),
	                    DEGREE_SIGN
	                ];
	                // I18N: %(point)s must come before %(degrees)s in this phrase
	                var text = $_({point: point, degrees: degrees}, 
	                    "Rotation about %(point)s by %(degrees)s"
	                );

	                return React.createElement("div", null, text);
	            },
	            value: function() {
	                var angleDeg = this.refs.angleDeg.getValue();
	                var centerX = this.refs.centerX.getValue();
	                var centerY = this.refs.centerY.getValue();
	                return {
	                    angleDeg: angleDeg,
	                    center: [centerX, centerY]
	                };
	            },
	            /* InputPath API */
	            setInputValue: function(path, value, cb) {
	                var id = _.first(path);
	                var angleDeg = _.clone(this.state.angleDeg);
	                var center = _.clone(this.state.center);
	                if (id === "angleDeg") {
	                    angleDeg = value;
	                } else if (id === "centerX") {
	                    center[0] = value;
	                } else if (id === "centerY") {
	                    center[1] = value;
	                }
	                this.setState({angleDeg: angleDeg, center: center}, function()  {
	                    this.props.onChange(cb);
	                }.bind(this));
	            },
	            getInputPaths: function() {
	                return [["centerX"], ["centerY"], ["angleDeg"]];
	            }
	        })
	    },

	    reflection: {
	        // I18N: As in the command, "Reflect the polygon"
	        verbName: $._("Reflect"),
	        nounName: $._("Reflection"),
	        lowerNounName: $._("reflection"),
	        apply: function(transform) {
	            return function(coord) {
	                return kpoint.reflectOverLine(
	                    coord,
	                    transform.line
	                );
	            };
	        },
	        isValid: function(transform) {
	            // A bit hacky, but we'll also define reflecting over a
	            // single point as a no-op, to avoid NaN fun.
	            return _.all(_.flatten(transform.line), _.isFinite) &&
	                    !kpoint.equal(transform.line[0], transform.line[1]);
	        },
	        isEmpty: function(transform) {
	            return _.all(_.flatten(transform.line), _.isNull);
	        },
	        isNoOp: function(transform) {
	            // Invalid transforms are implicitly no-ops, so we don't
	            // have to catch that case here.
	            return false;
	        },
	        collapse: function(transform1, transform2) {
	            if (!kline.equal(transform1.line, transform2.line)) {
	                return false;
	            }
	            return [];
	        },
	        toTeX: function(transform) {
	            var point1 = transform.line[0];
	            var point2 = transform.line[1];
	            return $_({point1: texFromPoint(point1), 
	                       point2: texFromPoint(point2)}, 
	                "Reflection over the line from %(point1)s to %(point2)s"
	            );
	        },
	        Input: React.createClass({displayName: 'Input',
	            getInitialState: function() {
	                return {
	                    line: this.props.line || [[null, null], [null, null]]
	                };
	            },
	            componentDidUpdate: function(prevProps) {
	                if (!deepEq(this.props, prevProps)) {
	                    this.setState({line: this.props.line});
	                }
	            },
	            render: function() {
	                var InputComponent = (this.props.apiOptions.staticRender) ?
	                        MathOutput :
	                        NumberInput;
	                var point1 = [React.createElement(TeX, null, "("),
	                    React.createElement(InputComponent, {
	                        ref: "x1", 
	                        value: this.state.line[0][0], 
	                        useArrowKeys: true, 
	                        onChange: this.changePoint.bind(this, 0, 0), 
	                        onFocus: _.partial(
	                            this.props.onFocus, "x1"
	                        ), 
	                        onBlur: _.partial(
	                            this.props.onBlur, "x1"
	                        )}),
	                    React.createElement(TeX, null, ", {}"),
	                    React.createElement(InputComponent, {
	                        ref: "y1", 
	                        value: this.state.line[0][1], 
	                        useArrowKeys: true, 
	                        onChange: this.changePoint.bind(this, 0, 1), 
	                        onFocus: _.partial(this.props.onFocus, "y1"), 
	                        onBlur: _.partial(this.props.onBlur, "y1")}),
	                    React.createElement(TeX, null, ")")
	                ];
	                var point2 = [React.createElement(TeX, null, "("),
	                    React.createElement(InputComponent, {
	                        ref: "x2", 
	                        value: this.state.line[1][0], 
	                        useArrowKeys: true, 
	                        onChange: this.changePoint.bind(this, 1, 0), 
	                        onFocus: _.partial(this.props.onFocus, "x2"), 
	                        onBlur: _.partial(this.props.onBlur, "x2")}),
	                    React.createElement(TeX, null, ", {}"),
	                    React.createElement(InputComponent, {
	                        ref: "y2", 
	                        value: this.state.line[1][1], 
	                        useArrowKeys: true, 
	                        onChange: this.changePoint.bind(this, 1, 1), 
	                        onFocus: _.partial(this.props.onFocus, "y2"), 
	                        onBlur: _.partial(this.props.onBlur, "y2")}),
	                    React.createElement(TeX, null, ")")
	                ];
	                return React.createElement("div", null, 
	                    $_({point1: point1, point2: point2}, 
	                        "Reflection over the line from %(point1)s to %(point2)s"
	                    )
	                );
	            },
	            changePoint: function(i, j, val, cb) {
	                var line = _.map(this.state.line, _.clone);
	                line[i][j] = val;
	                this.setState({line: line}, function()  {
	                    this.props.onChange(cb);
	                }.bind(this));
	            },
	            value: function() {
	                var x1 = this.refs.x1.getValue();
	                var y1 = this.refs.y1.getValue();
	                var x2 = this.refs.x2.getValue();
	                var y2 = this.refs.y2.getValue();
	                return {
	                    line: [[x1, y1], [x2, y2]]
	                };
	            },
	            /* InputPath API */
	            setInputValue: function(path, value, cb) {
	                var id = _.first(path);
	                var j;
	                if (id[0] === "x") {
	                    j = 0;
	                } else if (id[0] === "y") {
	                    j = 1;
	                }
	                var i;
	                if (id[1] === "1") {
	                    i = 0;
	                } else if (id[1] === "2") {
	                    i = 1;
	                }
	                this.changePoint(i, j, value, cb);
	            },
	            getInputPaths: function() {
	                return [["x1"], ["y1"], ["x2"], ["y2"]];
	            }
	        })
	    },

	    dilation: {
	        // I18N: As in the command, "Dilate the polygon"
	        verbName: $._("Dilate"),
	        nounName: $._("Dilation"),
	        lowerNounName: $._("dilation"),
	        apply: function(transform) {
	            return function(coord) {
	                return dilatePointFromCenter(coord, transform.center,
	                        transform.scale);
	            };
	        },
	        isValid: function(transform) {
	            return _.isFinite(transform.scale) &&
	                _.isFinite(transform.center[0]) &&
	                _.isFinite(transform.center[1]);
	        },
	        isEmpty: function(transform) {
	            return transform.scale === null &&
	                transform.center[0] === null &&
	                transform.center[1] === null;
	        },
	        isNoOp: function(transform) {
	            return knumber.equal(transform.scale, 1);
	        },
	        collapse: function(transform1, transform2) {
	            if (!kpoint.equal(transform1.center, transform2.center)) {
	                return false;
	            }
	            return {
	                center: transform1.center,
	                scale: transform1.scale * transform2.scale
	            };
	        },
	        toTeX: function(transform) {
	            var scaleString = stringFromFraction(transform.scale);
	            return $_({scale: scaleString, 
	                       point: texFromPoint(transform.center)}, 
	                "Dilation of scale %(scale)s about %(point)s"
	            );
	        },
	        Input: React.createClass({displayName: 'Input',
	            getInitialState: function() {
	                return {
	                    center: this.props.center || [null, null],
	                    scale: this.props.scale || null
	                };
	            },
	            componentDidUpdate: function(prevProps) {
	                if (!deepEq(this.props, prevProps)) {
	                    this.setState({
	                        center: this.props.center,
	                        scale: this.props.scale
	                    });
	                }
	            },
	            render: function() {
	                var InputComponent = (this.props.apiOptions.staticRender) ?
	                        MathOutput :
	                        NumberInput;
	                var point = [React.createElement(TeX, null, "("),
	                    React.createElement(InputComponent, {
	                        ref: "x", 
	                        placeholder: 0, 
	                        value: this.state.center[0], 
	                        useArrowKeys: true, 
	                        onChange: function(val0)  {
	                            var val1 = this.state.center[1];
	                            this.setState({center: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "x"), 
	                        onBlur: _.partial(this.props.onBlur, "x")}),
	                    React.createElement(TeX, null, ", {}"),
	                    React.createElement(InputComponent, {
	                        ref: "y", 
	                        placeholder: 0, 
	                        value: this.state.center[1], 
	                        useArrowKeys: true, 
	                        onChange: function(val1)  {
	                            var val0 = this.state.center[0];
	                            this.setState({center: [val0, val1]}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                        onFocus: _.partial(this.props.onFocus, "y"), 
	                        onBlur: _.partial(this.props.onBlur, "y")}),
	                    React.createElement(TeX, null, ")")
	                ];
	                var scale = React.createElement(InputComponent, {
	                    ref: "scale", 
	                    placeholder: 1, 
	                    value: this.state.scale, 
	                    useArrowKeys: true, 
	                    onChange: function(val)  {
	                            this.setState({scale: val}, function()  {
	                                this.props.onChange();
	                            }.bind(this));
	                        }.bind(this), 
	                    onFocus: _.partial(this.props.onFocus, "scale"), 
	                    onBlur: _.partial(this.props.onBlur, "scale")});
	                return React.createElement("div", null, 
	                    $_({point: point, scale: scale}, 
	                        "Dilation about %(point)s by %(scale)s"
	                    )
	                );
	            },
	            value: function() {
	                var scale = this.refs.scale.getValue();
	                var x = this.refs.x.getValue();
	                var y = this.refs.y.getValue();
	                return {
	                    scale: scale,
	                    center: [x, y]
	                };
	            },
	            /* InputPath API */
	            setInputValue: function(path, value, cb) {
	                var id = _.first(path);
	                var scale = this.state.scale;
	                var center = _.clone(this.state.center);
	                if (id === "x") {
	                    center[0] = value;
	                } else if (id === "y") {
	                    center[1] = value;
	                } else if (id === "scale") {
	                    scale = value;
	                }
	                this.setState({scale: scale, center: center}, function()  {
	                    this.props.onChange(cb);
	                }.bind(this));
	            },
	            getInputPaths: function() {
	                return [["x"], ["y"], ["scale"]];
	            }
	        })
	    }
	};


	/* Various functions to deal with different shape types */
	var ShapeTypes = {
	    getPointCountForType: function(type) {
	        var splitType = type.split("-");
	        if (splitType[0] === "polygon") {
	            return splitType[1] || 3;
	        } else if (splitType[0] === "line" ||
	                splitType[0] === "lineSegment") {
	            return 2;
	        } else if (splitType[0] === "angle") {
	            return 3;
	        } else if (splitType[0] === "circle") {
	            return 2;
	        } else if (splitType[0] === "point") {
	            return 1;
	        }
	    },

	    addMovableShape: function(graphie, options) {
	        if (options.editable && options.translatable) {
	            throw new Error("It doesn't make sense to have a movable shape " +
	                    "where you can stretch the points and translate them " +
	                    "simultaneously. options: " + JSON.stringify(options));
	        }

	        var shape;
	        var points = _.map(options.shape.coords, function(coord) {
	            var currentPoint;
	            var isMoving = false;
	            var previousCoord = coord;

	            var onMove = function(x, y) {
	                if (!isMoving) {
	                    previousCoord = currentPoint.coord;
	                    isMoving = true;
	                }

	                var moveVector = kvector.subtract(
	                    [x, y],
	                    currentPoint.coord
	                );

	                // Translate from (x, y) semantics to (dX, dY) semantics
	                // This is more useful for translations on multiple points,
	                // where we care about how the points moved, not where any
	                // individual point ended up
	                if (options.onMove) {
	                    moveVector = options.onMove(moveVector[0],
	                            moveVector[1]);
	                }

	                // Perform a translation on all points in this shape when
	                // any point moves
	                if (options.translatable) {
	                    _.each(points, function(point) {
	                        // The point itself will be updated by the
	                        // movablePoint class, so only translate the other
	                        // points
	                        if (point !== currentPoint) {
	                            point.setCoord(kvector.add(
	                                point.coord,
	                                moveVector
	                            ));
	                        }
	                    });
	                }

	                // Update our shape and our currentPoint
	                // Without this, some shapes (circles, angles) appear
	                // "bouncy" as they are updated with currentPoint at the
	                // current mouse coordinate (oldCoord), rather than newCoord
	                var oldCoord = currentPoint.coord;
	                var newCoord = kvector.add(
	                    currentPoint.coord,
	                    moveVector
	                );
	                // Temporarily change our coordinate so that
	                // shape.update() sees the new coordinate
	                currentPoint.coord = newCoord;
	                shape.update();
	                // ...But don't break onMove, which assumes it
	                // is the only thing changing our coord
	                currentPoint.coord = oldCoord;
	                return newCoord;
	            };

	            var onMoveEnd = function() {
	                // onMove isn't guaranteed to be called before onMoveEnd, so
	                // we have to take into account that we may not have moved and
	                // set previousCoord.
	                if (options.onMoveEnd && isMoving) {
	                    isMoving = false;
	                    // We don't use the supplied x and y parameters here
	                    // because MovablePoint's onMoveEnd semantics suck.
	                    // It returns the mouseX, mouseY without processing them
	                    // through onMove, leaving us with weird fractional moves
	                    var change = kvector.subtract(
	                        currentPoint.coord,
	                        previousCoord
	                    );
	                    options.onMoveEnd(change[0], change[1]);
	                }
	                shape.update();
	            };

	            currentPoint = graphie.addMovablePoint({
	                coord: coord,
	                normalStyle: options.normalPointStyle,
	                highlightStyle: options.highlightPointStyle,
	                constraints: {
	                    fixed: !options.translatable && !options.editable
	                },
	                visible: options.showPoints,
	                snapX: options.snap && options.snap[0] || 0,
	                snapY: options.snap && options.snap[1] || 0,
	                bounded: false, // Don't bound it when placing it on the graph
	                onMove: onMove,
	                onMoveEnd: onMoveEnd
	            });

	            // Bound it when moving
	            // We can't set this earlier, because doing so would mean any
	            // points outside of the graph would be moved into a moved into
	            // a position that doesn't preserve the shape
	            currentPoint.bounded = true;

	            return currentPoint;
	        });

	        shape = ShapeTypes.addShape(graphie, options, points);
	        var removeShapeWithoutPoints = shape.remove;
	        shape.remove = function() {
	            removeShapeWithoutPoints.apply(shape);
	            _.invoke(points, "remove");
	        };
	        return shape;
	    },

	    addShape: function(graphie, options, points) {
	        points = points || options.shape.coords;

	        var types = ShapeTypes._typesOf(options.shape);
	        var typeOptions = options.shape.options ||
	                ShapeTypes.defaultOptions(types);

	        var shapes = ShapeTypes._mapTypes(types, points,
	                function(type, points, i) {
	            var shapeOptions = _.extend({}, options, typeOptions[i]);
	            return ShapeTypes._addType(graphie, type, points, shapeOptions);
	        });

	        var updateFuncs = _.filter(_.pluck(shapes, "update"), _.identity);
	        var update = function() {
	            _.invoke(updateFuncs, "call");
	        };

	        var removeFuncs = _.filter(_.pluck(shapes, "remove"), _.identity);
	        var remove = function() {
	            _.invoke(removeFuncs, "call");
	        };

	        var getOptions = function() {
	            return _.map(shapes, function(shape) {
	                if (shape.getOptions) {
	                    return shape.getOptions();
	                } else {
	                    return {};
	                }
	            });
	        };

	        var toJSON = function() {
	            var coords = _.map(points, function(pt) {
	                if (_.isArray(pt)) {
	                    return pt;
	                } else {
	                    return pt.coord;
	                }
	            });
	            return {
	                type: types,
	                coords: coords,
	                options: getOptions()
	            };
	        };

	        return {
	            type: types,
	            points: points,
	            update: update,
	            remove: remove,
	            toJSON: toJSON,
	            getOptions: getOptions
	        };
	    },

	    equal: function(shape1, shape2) {
	        var types1 = ShapeTypes._typesOf(shape1);
	        var types2 = ShapeTypes._typesOf(shape2);
	        if (types1.length !== types2.length) {
	            return false;
	        }
	        var shapes1 = ShapeTypes._mapTypes(types1, shape1.coords,
	                ShapeTypes._combine);
	        var shapes2 = ShapeTypes._mapTypes(types2, shape2.coords,
	                ShapeTypes._combine);
	        return _.all(_.map(shapes1, function(partialShape1, i) {
	            var partialShape2 = shapes2[i];
	            if (partialShape1.type !== partialShape2.type) {
	                return false;
	            }
	            return ShapeTypes._forType(partialShape1.type).equal(
	                partialShape1.coords,
	                partialShape2.coords
	            );
	        }));
	    },

	    _typesOf: function(shape) {
	        var types = shape.type;
	        if (!_.isArray(types)) {
	            types = [types];
	        }
	        return _.map(types, function(type) {
	            if (type === "polygon") {
	                return "polygon-3";
	            } else {
	                return type;
	            }
	        });
	    },

	    defaultOptions: function(types) {
	        return _.map(types, function(type) {
	            var typeDefaultOptions = ShapeTypes._forType(type).defaultOptions;
	            return _.extend({}, typeDefaultOptions);
	        });
	    },

	    _forType: function(type) {
	        var baseType = type.split("-")[0];
	        return ShapeTypes[baseType];
	    },

	    _mapTypes: function(types, points, func, context) {
	        return _.map(types, function(type, i) {
	            var pointCount = ShapeTypes.getPointCountForType(type);
	            var currentPoints = _.first(points, pointCount);
	            points = _.rest(points, pointCount);
	            return func.call(context, type, currentPoints, i);
	        });
	    },

	    _addType: function(graphie, type, points, options) {
	        var lineCoords = _.isArray(points[0]) ? {
	            coordA: points[0],
	            coordZ: points[1],
	        } : {
	            pointA: points[0],
	            pointZ: points[1],
	        };

	        type = type.split("-")[0];
	        if (type === "polygon") {
	            var polygon = graphie.addMovablePolygon(_.extend({}, options, {
	                fixed: !options.editable,
	                snapX: options.snap && options.snap[0] || 0,
	                snapY: options.snap && options.snap[1] || 0,
	                points: points,
	                constrainToGraph: false
	            }));
	            return {
	                update: polygon.transform.bind(polygon),
	                remove: polygon.remove.bind(polygon)
	            };
	        } else if (type === "line" || type === "lineSegment") {
	            var line = graphie.addMovableLineSegment(
	                    _.extend({}, options, lineCoords, {
	                movePointsWithLine: true,
	                fixed: true,
	                constraints: {
	                    fixed: true
	                },
	                extendLine: (type === "line")
	            }));

	            // TODO(jack): Hide points on uneditable lines when translation
	            // is a vector.
	            // We can't just remove the points yet, because they are the
	            // translation handle for the line.
	            return {
	                update: line.transform.bind(line, true),
	                remove: line.remove.bind(line)
	            };
	        } else if (type === "angle") {
	            // If this angle is editable, we want to be able to make angles
	            // both larger and smaller than 180 degrees.
	            // If this angle is not editable, it should always maintain
	            // it's angle measure, even if it is reflected (causing the
	            // clockwise-ness of the points to change)
	            var shouldChangeReflexivity = options.editable ? null : false;

	            var angle = graphie.addMovableAngle({
	                angleLabel: "$deg0",
	                fixed: true,
	                points: points,
	                normalStyle: options.normalStyle,
	                reflex: options.reflex
	            });

	            // Hide non-vertex points on uneditable angles
	            if (!_.isArray(points[0]) && !options.editable) {
	                points[0].remove();
	                points[2].remove();
	            }
	            return {
	                update: angle.update.bind(angle, shouldChangeReflexivity),
	                remove: angle.remove.bind(angle),
	                getOptions: function() {
	                    return {
	                        reflex: angle.isReflex()
	                    };
	                }
	            };
	        } else if (type === "circle") {
	            var perimeter = {
	                // temporary object for the first removal
	                remove: _.identity
	            };
	            var redrawPerim = function() {
	                var coord0 = points[0].coord || points[0];
	                var coord1 = points[1].coord || points[1];
	                var radius = kpoint.distanceToPoint(coord0, coord1);
	                perimeter.remove();
	                perimeter = graphie.circle(coord0, radius, _.extend({
	                    stroke: KhanUtil.DYNAMIC,
	                    "stroke-width": 2,
	                }, options.normalStyle));
	            };

	            redrawPerim();
	            if (points[1].remove && !options.editable) {
	                points[1].remove();
	            }

	            return {
	                update: redrawPerim,
	                remove: function() {
	                    // Not _.bind because the remove function changes
	                    // when the perimeter is redrawn
	                    perimeter.remove();
	                }
	            };
	        } else if (type === "point") {
	            // do nothing
	            return {
	                update: null,
	                remove: null
	            };
	        } else {
	            throw new Error("Invalid shape type " + type);
	        }
	    },

	    _combine: function(type, coords) {
	        return {
	            type: type,
	            coords: coords
	        };
	    },

	    polygon: {
	        equal: orderInsensitiveCoordsEqual
	    },

	    line: {
	        equal: kline.equal
	    },

	    lineSegment: {
	        equal: orderInsensitiveCoordsEqual
	    },

	    angle: {
	        equal: function(points1, points2) {
	            if (!kpoint.equal(points1[1], points2[1])) {
	                return false;
	            }

	            var line1_0 = [points1[1], points1[0]];
	            var line1_2 = [points1[1], points1[2]];
	            var line2_0 = [points2[1], points2[0]];
	            var line2_2 = [points2[1], points2[2]];

	            var equalUnflipped = kray.equal(line1_0, line2_0) &&
	                    kray.equal(line1_2, line2_2);
	            var equalFlipped = kray.equal(line1_0, line2_2) &&
	                    kray.equal(line1_2, line2_0);

	            return equalUnflipped || equalFlipped;
	        },

	        defaultOptions: {
	            reflex: false
	        }
	    },

	    circle: {
	        equal: function(points1, points2) {
	            var radius1 = kpoint.distanceToPoint(points1[0], points1[1]);
	            var radius2 = kpoint.distanceToPoint(points2[0], points2[1]);
	            return kpoint.equal(points1[0], points2[0]) &&
	                knumber.equal(radius1, radius2);
	        }
	    },

	    point: {
	        equal: kpoint.equal
	    }
	};


	var ToolSettings = React.createClass({displayName: 'ToolSettings',
	    getDefaultProps: function() {
	        return {
	            allowFixed: true
	        };
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            this.props.name, ":", ' ', 
	            " ", 
	            React.createElement(PropCheckBox, {
	                label: "enabled:", 
	                enabled: this.props.settings.enabled, 
	                onChange: this.props.onChange}), 
	            " ", 
	            this.props.settings.enabled &&
	                React.createElement(PropCheckBox, {
	                    label: "required:", 
	                    required: this.props.settings.required, 
	                    onChange: this.props.onChange}), 
	            
	            this.props.settings.enabled &&
	                React.createElement(InfoTip, null, 
	                    "'Required' will only grade the answer as correct if the" + ' ' +
	                    "student has used at least one such transformation."
	                ), 
	            
	            " ", 
	            this.props.allowFixed && this.props.settings.enabled &&
	                React.createElement(PropCheckBox, {
	                    label: "fixed:", 
	                    fixed: this.props.settings.constraints.fixed, 
	                    onChange: this.changeConstraints}), 
	            
	            this.props.allowFixed && this.props.settings.enabled &&
	                React.createElement(InfoTip, null, 
	                    "Enable 'fixed' to prevent the student from repositioning" + ' ' +
	                    "the tool. The tool will appear in the position at which it" + ' ' +
	                    "is placed in the editor below."
	                )
	            
	        );
	    },

	    changeConstraints: function(changed) {
	        var newConstraints = _.extend({}, this.props.constraints, changed);
	        this.props.onChange({
	            constraints: newConstraints
	        });
	    }
	});


	var TransformationExplorerSettings = React.createClass({displayName: 'TransformationExplorerSettings',
	    render: function() {

	        return React.createElement("div", {className: "transformer-settings"}, 
	            React.createElement("div", null, 
	                ' ', "Mode:", ' ', 
	                React.createElement("select", {value: this.getMode(), 
	                        onChange: this.changeMode}, 
	                    React.createElement("option", {value: "interactive,dynamic"}, 
	                        ' ', "Exploration with text", ' '
	                    ), 
	                    React.createElement("option", {value: "interactive,static"}, 
	                        ' ', "Exploration without text", ' '
	                    ), 
	                    React.createElement("option", {value: "dynamic,interactive"}, 
	                        ' ', "Formal with movement", ' '
	                    ), 
	                    React.createElement("option", {value: "static,interactive"}, 
	                        ' ', "Formal without movement", ' '
	                    )
	                ), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("ul", null, 
	                        React.createElement("li", null, 
	                            React.createElement("b", null, "Exploration:"), " Students create" + ' ' +
	                            "transformations with tools on the graph.", ' '
	                        ), 
	                        React.createElement("li", null, 
	                            React.createElement("b", null, "Formal with movement:"), " Students specify" + ' ' +
	                            "transformations mathematically in the" + ' ' +
	                            "transformation list. Graph shows the results of" + ' ' +
	                            "these transformations.", ' '
	                        ), 
	                        React.createElement("li", null, 
	                            React.createElement("b", null, "Formal without movement:"), " Students specify" + ' ' +
	                            "transformations mathematically in the" + ' ' +
	                            "transformation list. Graph does not update.", ' '
	                        )
	                    )
	                )
	            ), 
	            React.createElement(ToolSettings, {
	                    name: "Translations", 
	                    settings: this.props.tools.translation, 
	                    allowFixed: false, 
	                    onChange: this.changeHandlerFor("translation")}), 
	            React.createElement(ToolSettings, {
	                    name: "Rotations", 
	                    settings: this.props.tools.rotation, 
	                    onChange: this.changeHandlerFor("rotation")}), 
	            React.createElement(ToolSettings, {
	                    name: "Reflections", 
	                    settings: this.props.tools.reflection, 
	                    onChange: this.changeHandlerFor("reflection")}), 
	            React.createElement(ToolSettings, {
	                    name: "Dilations", 
	                    settings: this.props.tools.dilation, 
	                    onChange: this.changeHandlerFor("dilation")}), 
	            React.createElement(PropCheckBox, {
	                    label: "Draw Solution:", 
	                    drawSolutionShape: this.props.drawSolutionShape, 
	                    onChange: this.props.onChange})
	        );
	    },

	    getMode: function() {
	        return this.props.graphMode + "," + this.props.listMode;
	    },

	    changeMode: function(e) {
	        var selected = e.target.value;
	        var modes = selected.split(",");

	        this.props.onChange({
	            graphMode: modes[0],
	            listMode: modes[1]
	        });
	    },

	    changeHandlerFor: function(toolName) {
	        return function(change)  {
	            var newTools = _.clone(this.props.tools);
	            newTools[toolName] = _.extend({}, this.props.tools[toolName],
	                    change);

	            this.props.onChange({
	                tools: newTools
	            });
	        }.bind(this);
	    }
	});


	var TransformationsShapeEditor = React.createClass({displayName: 'TransformationsShapeEditor',
	    render: function() {
	        return React.createElement("div", null, 
	            React.createElement(Graph, {
	                ref: "graph", 
	                box: this.props.graph.box, 
	                range: this.props.graph.range, 
	                labels: this.props.graph.labels, 
	                step: this.props.graph.step, 
	                gridStep: this.props.graph.gridStep, 
	                markings: this.props.graph.markings, 
	                backgroundImage: this.props.graph.backgroundImage, 
	                onGraphieUpdated: this.setupGraphie}), 
	            React.createElement("select", {
	                    key: "type-select", 
	                    value: this.getTypeString(this.props.shape.type), 
	                    onChange: this.changeType}, 
	                React.createElement("option", {value: "polygon-3"}, "Triangle"), 
	                React.createElement("option", {value: "polygon-4"}, "Quadrilateral"), 
	                React.createElement("option", {value: "polygon-5"}, "Pentagon"), 
	                React.createElement("option", {value: "polygon-6"}, "Hexagon"), 
	                React.createElement("option", {value: "line"}, "Line"), 
	                React.createElement("option", {value: "line,line"}, "2 lines"), 
	                React.createElement("option", {value: "lineSegment"}, "Line segment"), 
	                React.createElement("option", {value: "lineSegment,lineSegment"}, 
	                    ' ', "2 line segments", ' '
	                ), 
	                React.createElement("option", {value: "angle"}, "Angle"), 
	                React.createElement("option", {value: "circle"}, "Circle")
	            )
	        );
	    },

	    /* Return the option string for a given type */
	    getTypeString: function(type) {
	        if (_.isArray(type)) {
	            return _.map(type, this.getTypeString).join(",");
	        } else if (type === "polygon") {
	            return "polygon-" + this.props.shape.coords.length;
	        } else {
	            return type;
	        }
	    },

	    /* Change the type on the window event e
	     *
	     * e.target.value is the new type string
	     */
	    changeType: function(e) {
	        var types = String(e.target.value).split(",");
	        var pointCount = arraySum(_.map(
	                types,
	                ShapeTypes.getPointCountForType
	        ));

	        var radius = scaleToRange(4, this.refs.graph.props.range);
	        var offset = (1 / 2 - 1 / pointCount) * 180;
	        var coords = _.times(pointCount, function(i) {
	            return kpoint.rotateDeg([radius, 0],
	                360 * i / pointCount + offset);
	        });

	        this.props.onChange({
	            shape: {
	                type: types,
	                coords: coords,
	                options: ShapeTypes.defaultOptions(types)
	            }
	        });
	    },

	    componentDidMount: function() {
	        this.setupGraphie(this.refs.graph.graphie());
	    },

	    componentDidUpdate: function(prevProps) {
	        if (!deepEq(prevProps.shape, this.props.shape)) {
	            this.refs.graph.reset();
	        }
	    },

	    updateCoords: function() {
	        this.props.onChange({
	            shape: this.shape.toJSON()
	        });
	    },

	    setupGraphie: function(graphie) {
	        this.shape = ShapeTypes.addMovableShape(graphie, {
	            editable: true,
	            snap: graphie.snap,
	            shape: this.props.shape,
	            onMoveEnd: this.updateCoords
	        });
	    },

	});

	var TransformationListItem = TransformOps.ListItem;

	var TransformationList = React.createClass({displayName: 'TransformationList',
	    render: function() {
	        if (this.props.mode === "static") {
	            return React.createElement("span", null);  // don't render anything
	        }

	        var transformationList = _.map(
	            this.props.transformations,
	            function(transform, i) {
	                return React.createElement(TransformationListItem, {
	                            ref: "transformation" + i, 
	                            key: "transformation" + i, 
	                            transform: transform, 
	                            mode: this.props.mode, 
	                            onChange: this.handleChange, 
	                            onFocus: _.partial(this.props.onFocus, "" + i), 
	                            onBlur: _.partial(this.props.onBlur, "" + i), 
	                            apiOptions: this.props.apiOptions});
	            },
	            this
	        );

	        return React.createElement("div", {className: "perseus-transformation-list"}, 
	            transformationList
	        );
	    },

	    _transformationRefs: function() {
	        return _.times(this.props.transformations.length, function(i)  {
	            return this.refs["transformation" + i];
	        }.bind(this));
	    },

	    value: function() {
	        return _.invoke(this._transformationRefs(), "value");
	    },

	    handleChange: function(changed, callback) {
	        this.props.onChange(this.value(), callback);
	    },

	    focusLast: function() {
	        var transformationRefs = this._transformationRefs();
	        if (transformationRefs.length !== 0) {
	            _.last(transformationRefs).focus();
	        }
	    }
	});

	var ToolButton = React.createClass({displayName: 'ToolButton',
	    render: function() {
	        var classes = this.props.toggled ?
	            "simple-button exercise-orange toggled highlighted-tool-button" :
	            "simple-button";

	        return React.createElement("button", {
	                type: "button", 
	                className: classes, 
	                onClick: this.props.onClick, 
	                onTouchStart: captureScratchpadTouchStart}, 
	            this.props.children
	        );
	    }
	});

	var ToolsBar = React.createClass({displayName: 'ToolsBar',
	    getInitialState: function() {
	        return {
	            selected: null
	        };
	    },

	    render: function() {
	        var tools = _.map(Transformations, function(tool, type) {
	            if (this.props.enabled[type]) {
	                return React.createElement(ToolButton, {
	                        key: type, 
	                        toggled: this.state.selected === type, 
	                        onClick: this.changeSelected.bind(this, type)}, 
	                    tool.verbName
	                );
	            }
	        }, this);

	        return React.createElement("div", {className: "transformer-tools-bar"}, 
	            React.createElement("span", {className: "simple-button-group"}, 
	                tools
	            ), 
	            React.createElement("button", {
	                    className: "transformer-undo-button simple-button", 
	                    type: "button", 
	                    onClick: this.props.onUndoClick, 
	                    onTouchStart: captureScratchpadTouchStart}, 
	                React.createElement("span", {className: "icon-undo"}), 
	                " ", 
	                "Undo"
	            ), 
	            React.createElement("div", {className: "clear"})
	        );
	    },

	    changeSelected: function(tool) {
	        this.props.removeTool(this.state.selected);

	        if (!tool || tool === this.state.selected) {
	            this.setState({
	                selected: null
	            });
	        } else {
	            this.props.addTool(tool);
	            this.setState({
	                selected: tool
	            });
	        }
	    }
	});

	var AddTransformBar = React.createClass({displayName: 'AddTransformBar',
	    render: function() {
	        var tools = _.map(Transformations, function(tool, type) {
	            if (this.props.enabled[type]) {
	                return React.createElement(ToolButton, {
	                        key: type, 
	                        toggled: false, 
	                        onClick: this.changeSelected.bind(this, type)}, 
	                    React.createElement("span", {className: "icon-plus"}), 
	                    " ", 
	                    tool.nounName
	                );
	            }
	        }, this);

	        return React.createElement("div", {className: "transformer-tools-bar"}, 
	            tools, 
	            React.createElement("button", {
	                    className: "transformer-undo-button simple-button", 
	                    type: "button", 
	                    onClick: this.props.onUndoClick, 
	                    onTouchStart: captureScratchpadTouchStart}, 
	                React.createElement("span", {className: "icon-undo"}), 
	                " ", 
	                "Undo"
	            ), 
	            React.createElement("div", {className: "clear"})
	        );
	    },

	    changeSelected: function(tool) {
	        if (tool) {
	            this.props.addTool(tool);
	        }
	    }
	});

	var Transformer = React.createClass({displayName: 'Transformer',
	    getDefaultProps: function() {
	        return _.defaults({
	            transformations: []
	        }, defaultTransformerProps);
	    },

	    render: function() {
	        // Fill in any missing value in this.props.graph
	        // this can happen because the graph json doesn't include
	        // box, for example
	        var graph = _.extend(
	                defaultGraphProps(this.props.graph, defaultBoxSize),
	                this.props.graph
	        );

	        var interactiveToolsMode = this.props.graphMode === "interactive";

	        var ToolsBarClass = interactiveToolsMode ?
	                ToolsBar :
	                AddTransformBar;

	        // This style is applied inline because it is dependent on the
	        // size of the graph as set by the graph.box prop, and this also
	        // lets us specify it in the same place the graph's width is
	        // specified.
	        var toolsBar = React.createElement("div", {style: {width: graph.box[0]}}, 
	            React.createElement(ToolsBarClass, {
	                ref: "toolsBar", 
	                enabled: pluckObject(this.props.tools, "enabled"), 
	                addTool: this.addTool, 
	                removeTool: this.removeTool, 
	                onUndoClick: this.handleUndoClick})
	        );

	        return React.createElement("div", {className: "perseus-widget " +
	                        "perseus-widget-transformer"}, 
	            React.createElement(Graph, {
	                ref: "graph", 
	                box: graph.box, 
	                range: graph.range, 
	                labels: graph.labels, 
	                step: graph.step, 
	                gridStep: graph.gridStep, 
	                markings: graph.markings, 
	                backgroundImage: graph.backgroundImage, 
	                showProtractor: graph.showProtractor, 
	                onGraphieUpdated: this.setupGraphie}), 

	            !interactiveToolsMode && (
	                "Add transformations below:"
	            ), 

	            this.props.graphMode === "static" && [
	                React.createElement("br", {key: "static-br"}),
	                React.createElement("em", {key: "static-nomove"}, 
	                    ' ', "Note: For this question, the shape will not move.", ' '
	                )
	            ], 

	            interactiveToolsMode && toolsBar, 

	            React.createElement(TransformationList, {
	                ref: "transformationList", 
	                mode: this.props.listMode, 
	                transformations: this.props.transformations, 
	                onChange: this.setTransformationProps, 
	                onFocus: this._handleFocus, 
	                onBlur: this._handleBlur, 
	                apiOptions: this.props.apiOptions}), 

	            !interactiveToolsMode && toolsBar

	        );
	    },

	    componentDidMount: function() {
	        this.setupGraphie(this.graphie());
	    },

	    componentDidUpdate: function(prevProps) {
	        if (this.shouldSetupGraphie(this.props, prevProps)) {
	            this.refs.graph.reset();
	        } else if (!deepEq(this.props.transformations,
	                this.transformations)) {
	            this.setTransformations(this.props.transformations);
	        }
	    },

	    shouldSetupGraphie: function(nextProps, prevProps) {
	        if (!deepEq(prevProps.starting, nextProps.starting)) {
	            return true;
	        } else if (prevProps.graphMode !== nextProps.graphMode) {
	            return true;
	        } else if (prevProps.listMode !== nextProps.listMode) {
	            return true;
	        } else if (prevProps.drawSolutionShape !==
	                nextProps.drawSolutionShape) {
	            return true;
	        } else if (nextProps.drawSolutionShape && !deepEq(
	                prevProps.correct.shape, nextProps.correct.shape)) {
	            return true;
	        } else if (!deepEq(this.tools, nextProps.tools)) {
	            return true;
	        } else {
	            return false;
	        }
	    },

	    graphie: function() {
	        return this.refs.graph.graphie();
	    },

	    setupGraphie: function(graphie) {
	        // A background image of our solution:
	        if (this.props.drawSolutionShape &&
	                this.props.correct.shape &&
	                this.props.correct.shape.coords) {
	            ShapeTypes.addShape(graphie, {
	                fixed: true,
	                shape: this.props.correct.shape,
	                normalStyle: {
	                    stroke: KhanUtil.GRAY,
	                    "stroke-dasharray": "",
	                    "stroke-width": 2
	                }
	            });
	        }

	        this.currentTool = null;
	        this.refs.toolsBar.changeSelected(null);
	        this.addTransformerShape(this.props.starting.shape,
	                /* translatable */ false);
	        this.setTransformations(this.props.transformations);

	        // Save a copy of our tools so that we can check future
	        // this.props.tools changes against them
	        // This seems weird, but gives us an easy way to tell whether
	        // props changes were self-inflicted (for which a graphie reset
	        // is not required, and is in fact a bad idea right now because
	        // of resetting the size of the dilation tool).
	        // TODO (jack): A deepClone method would be nice here
	        this.tools = {
	            translation: _.clone(this.props.tools.translation),
	            rotation: _.clone(this.props.tools.rotation),
	            reflection: _.clone(this.props.tools.reflection),
	            dilation: _.clone(this.props.tools.dilation)
	        };
	    },

	    /* Applies all transformations in `transformations`
	     * to the starting shape, and updates this.transformations
	     * to reflect this
	     *
	     * Usually called with this.props.transformations
	     */
	    setTransformations: function(transformations) {
	        this.resetCoords();
	        this.transformations = _.clone(transformations);
	        _.each(this.transformations, this.applyTransform);
	    },

	    // the polygon that we transform
	    addTransformerShape: function(shape, translatable) {
	        var self = this;
	        var graphie = this.graphie();

	        this.shape = ShapeTypes.addMovableShape(graphie, {
	            shape: shape,
	            editable: false,
	            showPoints: (this.props.graphMode !== "static"),
	            translatable: translatable,
	            onMove: function (dX, dY) {
	                dX = KhanUtil.roundToNearest(graphie.snap[0], dX);
	                dY = KhanUtil.roundToNearest(graphie.snap[1], dY);
	                self.addTransform({
	                    type: "translation",
	                    vector: [dX, dY]
	                });
	                return [dX, dY];
	            },
	            normalPointStyle: {
	                fill: (translatable ? KhanUtil.INTERACTIVE
	                                    : KhanUtil.DYNAMIC),
	                stroke: (translatable ? KhanUtil.INTERACTIVE
	                                      : KhanUtil.DYNAMIC)
	            },
	            highlightPointStyle: {
	                fill: KhanUtil.INTERACTING,
	                stroke: KhanUtil.INTERACTING
	            }
	        });
	    },

	    addTool: function(toolId) {
	        var self = this;

	        if (this.props.graphMode === "interactive") {
	            if (toolId === "translation") {
	                this.currentTool = this.addTranslationTool();
	            } else if (toolId === "rotation") {
	                this.currentTool = this.addRotationTool();
	            } else if (toolId === "reflection") {
	                this.currentTool = this.addReflectionTool();
	            } else if (toolId === "dilation") {
	                this.currentTool = this.addDilationTool();
	            } else {
	                throw new Error("Invalid tool id: " + toolId);
	            }
	        } else {
	            var transform;
	            if (toolId === "translation") {
	                transform = {
	                    type: toolId,
	                    vector: [null, null]
	                };
	            } else if (toolId === "rotation") {
	                transform = {
	                    type: toolId,
	                    center: [null, null],
	                    angleDeg: null
	                };
	            } else if (toolId === "reflection") {
	                // Reflections with nulls in them won't be applied until
	                // fills in the blanks
	                transform = {
	                    type: toolId,
	                    line: [[null, null], [null, null]]
	                };
	            } else if (toolId === "dilation") {
	                transform = {
	                    type: toolId,
	                    center: [null, null],
	                    scale: null
	                };
	            } else {
	                throw new Error("Invalid tool id: " + toolId);
	            }

	            this.doTransform(transform, function() {
	                self.refs.transformationList.focusLast();
	            });
	        }
	    },

	    removeTool: function(toolId) {
	        if (this.currentTool) {
	            this.currentTool.remove();
	        }
	        this.currentTool = null;
	    },

	    addTranslationTool: function() {
	        var self = this;
	        this.shape.remove();
	        this.addTransformerShape(this.shape.toJSON(),
	                /* translatable */ true);

	        return {
	            remove: function() {
	                self.shape.remove();
	                self.addTransformerShape(self.shape.toJSON(),
	                        /* translatable */ false);
	            }
	        };
	    },

	    // Snaps a coord to this.graphie()'s snap
	    snapCoord: function(coord) {
	        var graphie = this.graphie();
	        return _.map(coord, function (val, dim) {
	            return KhanUtil.roundToNearest(graphie.snap[dim], val);
	        });
	    },

	    // Normalize the coords into something that fits the new 45 degree
	    // reflection line.
	    normalizeReflectionCoords: function(messyCoords) {
	        var midpoint = this.snapCoord(kline.midpoint(messyCoords));
	        var origDirectionPolar = kvector.polarDegFromCart(
	            kvector.subtract(messyCoords[0], messyCoords[1])
	        );
	        var directionPolar = [
	            1,
	            KhanUtil.roundToNearest(45, origDirectionPolar[1])
	        ];
	        var direction = kvector.cartFromPolarDeg(directionPolar);
	        var coords = _.map([-1, 1], function(directionCoefficient) {
	            var coord = kvector.add(
	                midpoint,
	                kvector.scale(
	                    direction,
	                    directionCoefficient *
	                        this.scaleToCurrentRange(REFLECT_ROTATE_HANDLE_DIST)
	                )
	            );
	            return this.snapCoord(coord);
	        }, this);
	        return coords;
	    },

	    addReflectionTool: function() {
	        var options = this.props.tools.reflection;
	        if (!options.enabled) {
	            return;
	        }
	        var self = this;
	        var graphie = this.refs.graph.graphie();

	        var updateReflectionTool = function() {
	            self.changeTool("reflection", {
	                coords: _.pluck(reflectPoints, "coord")
	            });
	        };

	        var coords = this.normalizeReflectionCoords(options.coords);

	        // The points defining the line of reflection; hidden from the
	        // user.
	        var reflectPoints = _.map(coords, function(coord) {
	            return graphie.addMovablePoint({
	                coord: coord,
	                visible: false
	            });
	        }, this);

	        // the line of reflection
	        // TODO(jack): graphie.style here is a hack to prevent the dashed
	        // style from leaking into the rest of the shapes. Remove when
	        // graphie.addMovableLineSegment doesn't leak styles anymore.
	        var reflectLine;
	        var normalColor = colorForTool(options);
	        graphie.style({}, function() {
	            reflectLine = graphie.addMovableLineSegment({
	                fixed: options.constraints.fixed,
	                constraints: options.constraints,
	                pointA: reflectPoints[0],
	                pointZ: reflectPoints[1],
	                snapX: graphie.snap[0],
	                snapY: graphie.snap[1],
	                extendLine: true,
	                normalStyle: {
	                    "stroke": normalColor,
	                    "stroke-width": 2,
	                    "stroke-dasharray": "- "
	                },
	                highlightStyle: {
	                    "stroke": KhanUtil.INTERACTING,
	                    "stroke-width": 2,
	                    "stroke-dasharray": "- " // TODO(jack) solid doesn't
	                                             // work here, but would be
	                                             // nicer
	                },
	                movePointsWithLine: true,
	                onMoveEnd: updateReflectionTool
	            });
	        });

	        // the "button" point in the center of the line of reflection
	        var reflectButton = graphie.addReflectButton({
	            fixed: options.constraints.fixed,
	            line: reflectLine,
	            size: this.scaleToCurrentRange(REFLECT_BUTTON_SIZE),
	            onClick: function() {
	                self.doTransform({
	                    type: "reflection",
	                    line: _.pluck(reflectPoints, "coord")
	                });
	                if (reflectRotateHandle) {
	                    // flip the rotation handle
	                    reflectRotateHandle.setCoord(kvector.add(
	                        reflectButton.coord,
	                        kvector.subtract(
	                            reflectButton.coord,
	                            reflectRotateHandle.coord
	                        )
	                    ));
	                    reflectRotateHandle.update();
	                }
	            },
	            normalStyle: {
	                stroke: normalColor,
	                "stroke-width": 2,
	                fill: normalColor
	            },
	            highlightStyle: {
	                stroke: KhanUtil.INTERACTING,
	                "stroke-width": 3,
	                fill: KhanUtil.INTERACTING
	            },
	            onMoveEnd: updateReflectionTool
	        });

	        var reflectRotateHandle = null;
	        if (!options.constraints.fixed) {
	            // The rotation handle for rotating the line of reflection
	            var initRotateHandleAngle = kvector.polarDegFromCart(
	                kvector.subtract(
	                    reflectPoints[1].coord,
	                    reflectPoints[0].coord
	                )
	            )[1] + 90; // 90 degrees off of the line
	            reflectRotateHandle = graphie.addRotateHandle({
	                center: reflectButton,
	                radius: this.scaleToCurrentRange(REFLECT_ROTATE_HANDLE_DIST),
	                angleDeg: initRotateHandleAngle,
	                width: this.scaleToCurrentRange(0.24),
	                hoverWidth: this.scaleToCurrentRange(0.4),
	                lengthAngle: 17,
	                onMove: function(newAngle) {
	                    return KhanUtil.roundToNearest(45, newAngle);
	                },
	                onMoveEnd: updateReflectionTool
	            });
	        }

	        // Move the reflectButton and reflectRotateHandle with the line
	        $(reflectLine).on("move",
	                function() {
	            reflectButton.update();
	            $(reflectButton).trigger("move"); // update the rotation handle,
	                    // which watches for this in ke/utils/interactive.js.
	        });

	        // Update the line and reflect button when the reflectRotateHandle is
	        // rotated
	        if (reflectRotateHandle) {
	            $(reflectRotateHandle).on("move", function() {
	                var rotateHandleApprox = self.snapCoord(
	                    reflectRotateHandle.coord
	                );

	                var rotateVector = kvector.subtract(
	                    rotateHandleApprox,
	                    reflectButton.coord
	                );

	                var flipped = reflectButton.isFlipped() ? 1 : 0;
	                reflectPoints[flipped].setCoord(kvector.add(
	                    reflectButton.coord,
	                    kvector.rotateDeg(rotateVector, 90)
	                ));
	                reflectPoints[1 - flipped].setCoord(kvector.add(
	                    reflectButton.coord,
	                    kvector.rotateDeg(rotateVector, -90)
	                ));

	                reflectLine.transform(true);
	                reflectButton.update();
	            });
	        }

	        return {
	            remove: function() {
	                reflectButton.remove();
	                if (reflectRotateHandle) {
	                    reflectRotateHandle.remove();
	                }
	                reflectLine.remove();
	                reflectPoints[0].remove();
	                reflectPoints[1].remove();
	            }
	        };
	    },

	    /* Scales a distance from the default range of
	     * [-10, 10] to the current this.props.graph.range
	     *
	     * Used for sizing various transformation tools
	     * (rotation handle, dilation circle)
	     */
	    scaleToCurrentRange: function(dist) {
	        return scaleToRange(dist, this.refs.graph.props.range);
	    },

	    addRotationTool: function() {
	        var options = this.props.tools.rotation;
	        if (!options.enabled) {
	            return;
	        }
	        var self = this;
	        var graphie = this.refs.graph.graphie();

	        var pointColor = colorForTool(options);
	        // The center of our rotation, which can be moved to change the
	        // center of rotation
	        this.rotatePoint = graphie.addMovablePoint({
	            constraints: options.constraints,
	            coord: options.coord,
	            snapX: graphie.snap[0],
	            snapY: graphie.snap[1],
	            normalStyle: {               // ugh, this seems to be a global and
	                "stroke-dasharray": "",  // is set to dash above
	                stroke: pointColor,
	                fill: pointColor
	            },
	            highlightStyle: {
	                "stroke-dasharray": "",
	                stroke: KhanUtil.INTERACTING,
	                fill: KhanUtil.INTERACTING
	            }
	        });

	        // The point that we move around the center of rotation to actually
	        // cause rotations
	        this.rotateHandle = graphie.addRotateHandle({
	            center: this.rotatePoint,
	            radius: this.scaleToCurrentRange(ROTATE_HANDLE_DIST),
	            width: this.scaleToCurrentRange(0.24),
	            hoverWidth: this.scaleToCurrentRange(0.4),
	            onMove: function(newAngle, oldAngle) {
	                var transform = self.getRotationTransformFromAngle(
	                    self.rotatePoint.coord,
	                    newAngle - oldAngle
	                );

	                // Rotate polygon with rotateHandle
	                self.doTransform(transform);

	                return oldAngle + transform.angleDeg;
	            }
	        });

	        // Update tools.rotation.coord
	        this.rotatePoint.onMoveEnd = function(x, y) {
	            self.changeTool("rotation", {
	                coord: [x, y]
	            });
	        };


	        return {
	            remove: function() {
	                self.rotateHandle.remove();
	                self.rotatePoint.remove();
	            }
	        };
	    },

	    addDilationTool: function() {
	        var options = this.props.tools.dilation;
	        if (!options.enabled) {
	            return;
	        }
	        var self = this;
	        var graphie = this.refs.graph.graphie();

	        var pointColor = colorForTool(options);
	        // the circle for causing dilation transforms
	        self.dilationCircle = graphie.addCircleGraph({
	            centerConstraints: options.constraints,
	            center: options.coord,
	            radius: self.scaleToCurrentRange(2),
	            snapX: graphie.snap[0],
	            snapY: graphie.snap[1],
	            minRadius: self.scaleToCurrentRange(1),
	            snapRadius: self.scaleToCurrentRange(0.5),
	            onResize: function(newRadius, oldRadius) {
	                self.doTransform({
	                    type: "dilation",
	                    center: self.dilationCircle.centerPoint.coord,
	                    scale: newRadius/oldRadius
	                });
	            },
	            circleNormalStyle: {
	                "stroke": pointColor,
	                "stroke-width": 2,
	                "stroke-dasharray": "- ",
	                "fill-opacity": 0
	            },
	            circleHighlightStyle: {
	                "stroke": KhanUtil.INTERACTING,
	                "stroke-width": 2,
	                "stroke-dasharray": "",
	                "fill": KhanUtil.INTERACTING,
	                "fill-opacity": 0.05
	            },
	            centerNormalStyle: {
	                "stroke": pointColor,
	                "fill": pointColor,
	                "stroke-width": 2,
	                "stroke-dasharray": ""
	            },
	            centerHighlightStyle: {
	                "stroke": pointColor,
	                "fill": pointColor,
	                "stroke-width": 2,
	                "stroke-dasharray": ""
	            }
	        });

	        var origOnMoveEnd = this.dilationCircle.centerPoint.onMoveEnd;
	        this.dilationCircle.centerPoint.onMoveEnd = function() {
	            if (origOnMoveEnd) {
	                origOnMoveEnd.apply(this, _.toArray(arguments));
	            }
	            self.changeTool("dilation", {
	                coord: self.dilationCircle.centerPoint.coord
	            });
	        };

	        return {
	            remove: function() {
	                self.dilationCircle.remove();
	            }
	        };
	    },

	    // returns a transformation object representing a rotation
	    // rounds the angle to the nearest 15 degrees
	    getRotationTransformFromAngle: function(center, angleChanged) {
	        angleChanged = (angleChanged + 360) % 360;
	        if (angleChanged > 180) {
	            angleChanged -= 360;
	        }
	        var roundedAngle = Math.round(
	                angleChanged / ROTATE_SNAP_DEGREES
	            ) * ROTATE_SNAP_DEGREES;

	        return {
	            type: "rotation",
	            center: center,
	            angleDeg: roundedAngle
	        };
	    },

	    // apply and save a transform
	    doTransform: function(transform, callback) {
	        this.applyTransform(transform);
	        this.addTransform(transform, callback);
	    },

	    // apply a transform to our polygon (without modifying our transformation
	    // list)
	    applyTransform: function(transform) {
	        if (this.props.graphMode !== "static") {
	            var transformFunc = TransformOps.apply(transform);
	            this.applyCoordTransformation(transformFunc);
	        }
	    },

	    // transform our polygon by transforming each point using a given function
	    applyCoordTransformation: function(pointTransform) {
	        _.each(this.shape.points, function(point) {
	            var newCoord = pointTransform(point.coord);
	            point.setCoord(newCoord);
	        });
	        this.shape.update();
	    },

	    resetCoords: function() {
	        var startCoords = this.props.starting.shape.coords;
	        _.each(this.shape.points, function(point, i) {
	            point.setCoord(startCoords[i]);
	        });
	        this.shape.update();
	    },

	    // Remove the last transformation
	    handleUndoClick: function() {
	        this.refs.toolsBar.changeSelected(null);
	        if (this.props.transformations.length) {
	            this.props.onChange({
	                transformations: _.initial(this.props.transformations)
	            });
	        }
	    },

	    setTransformationProps: function(newTransfomationList, callback) {
	        this.props.onChange({
	            transformations: newTransfomationList
	        }, callback);
	    },

	    // add a transformation to our props list of transformation
	    addTransform: function(transform, callback) {
	        this.transformations = TransformOps.append(
	                this.transformations,
	                transform
	        );
	        this.props.onChange({
	            transformations: _.clone(this.transformations)
	        }, callback);
	    },

	    changeTool: function(tool, changes) {
	        var newTools = _.clone(this.props.tools);
	        newTools[tool] = _.extend({}, this.props.tools[tool], changes);
	        this.tools[tool] = _.clone(newTools[tool]);
	        this.props.onChange({
	            tools: newTools,
	        });
	    },

	    simpleValidate: function(rubric) {
	        return Transformer.validate(this.getUserInput(), rubric);
	    },

	    /**
	     * Calculate where the coordinates would be if they were
	     * moved, even if we're in formal mode with no movement
	     * (and thus the actual movablepoints may not have moved
	     */
	    getCoords: function() {
	        var startCoords = this.props.starting.shape.coords;
	        var transforms = this.props.transformations;
	        return _.reduce(transforms, function (coords, transform) {
	            return _.map(coords, TransformOps.apply(transform));
	        }, startCoords);
	    },

	    getEditorJSON: function() {
	        var json = _.pick(this.props, "grading", "starting", "graphMode",
	                "listMode", "tools", "drawSolutionShape", "gradeEmpty");
	        json.graph = this.refs.graph.toJSON();
	        json.version = 1.2; // Give us some safety to change the format
	                            // when we realize that I wrote
	                            // a horrible json spec for this widget

	        json.answer = this.getUserInput();
	        return json;
	    },

	    getUserInput: function() {
	        return {
	            transformations: this.props.transformations,
	            // This doesn't call this.shape.toJSON() because that doesn't
	            // handle coordinates in formal mode without movement, since
	            // the movablepoints never move
	            shape: {
	                type: this.shape.type,
	                coords: this.getCoords(),
	                options: this.shape.getOptions()
	            }
	        };
	    },

	    /* InputPath API */

	    _handleFocus: function() {
	        var path = Array.prototype.slice.call(arguments);
	        this.props.onFocus(path);
	    },

	    _handleBlur: function() {
	        var path = Array.prototype.slice.call(arguments);
	        this.props.onBlur(path);
	    },

	    _getTransformationForID: function(transformationID) {
	        // Returns the 'transformation' component corresponding to a given ID
	        var refPath = [
	            "transformationList",
	            "transformation" + transformationID
	        ];

	        // Follow the path of references
	        var component = this;
	        _.each(refPath, function(ref)  {
	            component = component.refs[ref];
	        });
	        return component;
	    },

	    getInputPaths: function() {
	        var inputPaths = [];
	        _.each(this.props.transformations, function(transformation, i)  {
	            var transformation = this._getTransformationForID(i);
	            var innerPaths = transformation.getInputPaths();
	            var fullPaths = _.map(innerPaths, function(innerPath)  {
	                return ["" + i].concat(innerPath);
	            });
	            inputPaths = inputPaths.concat(fullPaths);
	        }.bind(this));
	        return inputPaths;
	    },

	    _passToInner: function(functionName, path) {
	        if (!path || !path.length) {
	            return;
	        }

	        // First argument tells us which transformation will receive the call;
	        // remaining arguments are used within that transformation to identify
	        // a specific input.
	        var innerPath = _.rest(path);
	        var args = [innerPath].concat(_.rest(arguments, 2));

	        // Pass arguments down to appropriate 'transformation' component
	        var transformationID = _.head(path);
	        var caller = this._getTransformationForID(transformationID);
	        return caller[functionName].apply(caller, args);
	    },

	    focus: function() {
	        // Just focus the first showing input
	        var inputs = this.getInputPaths();
	        if (inputs.length > 0) {
	            this.focusInputPath(inputs[0]);
	            return true;
	        }
	        return false;
	    },

	    focusInputPath: function(path) {
	        assert(path.length >= 2);
	        return this._passToInner('focusInputPath', path);
	    },

	    blurInputPath: function(path) {
	        assert(path.length >= 2);
	        return this._passToInner('blurInputPath', path);
	    },

	    setInputValue: function(path, value, cb) {
	        assert(path.length >= 2);
	        return this._passToInner('setInputValue', path, value, cb);
	    },

	    getDOMNodeForPath: function(path) {
	        assert(path.length >= 2);
	        return this._passToInner('getDOMNodeForPath', path);
	    },

	    getGrammarTypeForPath: function(path) {
	        assert(path.length >= 2);
	        return this._passToInner('getGrammarTypeForPath', path);
	    }
	});

	_.extend(Transformer, {
	    validate: function (guess, rubric) {
	        // Check for any required transformations
	        for (var type in Transformations) {
	            if (rubric.tools[type].required) {
	                var isUsed = _.any(_.map(guess.transformations,
	                        function(transform) {
	                    // Required transformations must appear in the
	                    // transformation list, and must not be no-ops
	                    return (transform.type === type) &&
	                        !TransformOps.isEmpty(transform) &&
	                        !TransformOps.isNoOp(transform);
	                }));

	                if (!isUsed) {
	                    return {
	                        type: "invalid",
	                        message: $._("Your transformation must use a " +
	                                "%(type)s.", {
	                            type: Transformations[type].lowerNounName
	                        })
	                    };
	                }
	            }
	        }

	        // Compare shapes
	        if (ShapeTypes.equal(guess.shape,
	                rubric.correct.shape)) {
	            return {
	                type: "points",
	                earned: 1,
	                total: 1,
	                message: null
	            };
	        } else if (!rubric.gradeEmpty && deepEq(
	                    guess.shape.coords,
	                    rubric.starting.shape.coords
	                )) {
	            return {
	                type: "invalid",
	                message: $._("Use the interactive graph to define a " +
	                    "correct transformation.")
	            };
	        } else {
	            return {
	                type: "points",
	                earned: 0,
	                total: 1,
	                message: null
	            };
	        }
	    }
	});

	var TransformerEditor = React.createClass({displayName: 'TransformerEditor',
	    // TODO (jack): These should be refactored into a nice object at the top
	    // so that we don't have all this duplication
	    getDefaultProps: function() {
	        return defaultTransformerProps;
	    },

	    render: function() {
	        // Fill in any missing value in this.props.graph
	        // this can happen because the graph json doesn't include
	        // box, for example
	        var graph = _.extend(
	                defaultGraphProps(this.props.graph, 340),
	                this.props.graph
	        );

	        return React.createElement("div", null, 
	            React.createElement("div", null, 
	                React.createElement(PropCheckBox, {
	                    label: "Grade empty answers as wrong:", 
	                    gradeEmpty: this.props.gradeEmpty, 
	                    onChange: this.props.onChange}), 
	                React.createElement(InfoTip, null, 
	                    React.createElement("p", null, 
	                        "We generally do not grade empty answers. This usually" + ' ' +
	                        "works well, but sometimes can result in giving away" + ' ' +
	                        "part of an answer in a multi-part question."
	                    ), 
	                    React.createElement("p", null, 
	                        "If this is a multi-part question (there is another" + ' ' +
	                        "widget), you probably want to enable this option." + ' ' +
	                        "Otherwise, you should leave it disabled."
	                    ), 
	                    React.createElement("p", null, 
	                        "Confused? Talk to Elizabeth."
	                    )
	                )
	            ), 
	            React.createElement("div", null, "Graph settings:"), 
	            React.createElement(GraphSettings, {
	                box: graph.box, 
	                labels: graph.labels, 
	                range: graph.range, 
	                step: graph.step, 
	                gridStep: graph.gridStep, 
	                valid: graph.valid, 
	                backgroundImage: graph.backgroundImage, 
	                markings: graph.markings, 
	                showProtractor: graph.showProtractor, 
	                onChange: this.changeGraph}), 
	            React.createElement("div", null, "Transformation settings:"), 
	            React.createElement(TransformationExplorerSettings, {
	                ref: "transformationSettings", 
	                graphMode: this.props.graphMode, 
	                listMode: this.props.listMode, 
	                tools: this.props.tools, 
	                drawSolutionShape: this.props.drawSolutionShape, 
	                onChange: this.props.onChange}), 
	            React.createElement("div", null, "Starting location:"), 
	            React.createElement(TransformationsShapeEditor, {
	                ref: "shapeEditor", 
	                graph: graph, 
	                shape: this.props.starting.shape, 
	                onChange: this.changeStarting}), 
	            React.createElement("div", null, "Solution transformations:"), 
	            React.createElement(Transformer, {
	                ref: "explorer", 
	                graph: graph, 
	                graphMode: this.props.graphMode, 
	                listMode: this.props.listMode, 
	                gradeEmpty: this.props.gradeEmpty, 
	                tools: this.props.tools, 
	                drawSolutionShape: this.props.drawSolutionShape, 
	                starting: this.props.starting, 
	                correct: this.props.starting, 
	                transformations: this.props.correct.transformations, 
	                onChange: this.changeTransformer})
	        );
	    },

	    // propagate a props change on our graph settings to
	    // this.props.graph
	    changeGraph: function(graphChanges, callback) {
	        var newGraph = _.extend({}, this.props.graph, graphChanges);
	        this.props.onChange({
	            graph: newGraph
	        }, callback);
	    },

	    // propagate a props change on our starting graph to
	    // this.props.starting
	    changeStarting: function(startingChanges) {
	        var newStarting = _.extend({}, this.props.starting, startingChanges);
	        this.props.onChange({
	            starting: newStarting
	        });
	    },

	    // propagate a transformations change onto correct.transformations
	    changeTransformer: function(changes, callback) {
	        if (changes.transformations) {
	            changes.correct = {
	                transformations: changes.transformations
	            };
	            delete changes.transformations;
	        }
	        this.props.onChange(changes, callback);
	    },

	    serialize: function() {
	        var json = this.refs.explorer.getEditorJSON();
	        json.correct = json.answer;
	        delete json.answer;
	        return json;
	    }
	});


	module.exports = {
	    name: "transformer",
	    displayName: "Transformer",
	    widget: Transformer,
	    editor: TransformerEditor
	};


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	// TODO(joel): teach KAS how to accept an answer only if it's expressed in
	// terms of a certain type.
	// TODO(joel): Allow sigfigs within a range rather than an exact expected
	// value?

	var _ = __webpack_require__(67);
	var lens = __webpack_require__(114);

	var ApiClassNames = __webpack_require__(17).ClassNames;
	var ApiOptions = __webpack_require__(17).Options;
	var Changeable = __webpack_require__(77);
	var EditorJsonify = __webpack_require__(76);
	var MathOutput   = __webpack_require__(96);
	var NumberInput = __webpack_require__(94);
	var $__0=     __webpack_require__(99),SignificantFigures=$__0.SignificantFigures,displaySigFigs=$__0.displaySigFigs;

	var ALL = "all";
	var SOME = "some";
	var MAX_SIGFIGS = 10;

	var countSigfigs = function(value) {
	    return new SignificantFigures(value).sigFigs;
	};

	var sigfigPrint = function(num, sigfigs) {
	    return displaySigFigs(num, sigfigs, -MAX_SIGFIGS, false);
	};

	/* I just wrote this, but it's old by analogy to `OldExpression`, in that it's
	 * the version that non-mathquill platforms get stuck with. Constructed with an
	 * <input>, a parser, popsicle sticks, and glue.
	 *
	 * In the same way as OldExpression, this parses continuously as you type, then
	 * shows and hides an error buddy. The error message is only shown after a
	* rolling two second delay, but hidden immediately on further typing.
	 */
	var OldUnitInput = React.createClass({displayName: 'OldUnitInput',
	    mixins: [Changeable],

	    propTypes: {
	        value: React.PropTypes.string,
	    },

	    getDefaultProps: function() {
	        return {
	            apiOptions: ApiOptions.defaults,
	            value: "",
	        };
	    },

	    // TODO(joel) think about showing the error buddy
	    render: function() {
	        var inputType = this.props.apiOptions.staticRender ?
	                React.createFactory(MathOutput) :
	                React.DOM.input;
	        var input = inputType({
	            onChange: this.handleChange,
	            ref: "input",
	            className: ApiClassNames.INTERACTIVE,
	            value: this.props.value,
	            onFocus: this.handleFocus,
	            onBlur: this.handleBlur,
	        });

	        return React.createElement("div", {className: "old-unit-input"}, 
	            input, 
	            React.createElement("div", {ref: "error", 
	                 className: "error", 
	                 style: {display: "none"}}, 
	                $_(null, "I don't understand that")
	            )
	        );
	    },

	    _errorTimeout: null,

	    _showError: function() {
	        if (this.props.value === "") {
	            return;
	        }

	        var $error = $(this.refs.error.getDOMNode());
	        if (!$error.is(":visible")) {
	            $error.css({ top: 50, opacity: 0.1 }).show()
	                .animate({ top: 0, opacity: 1.0 }, 300);
	        }
	    },

	    _hideError: function() {
	        var $error = $(this.refs.error.getDOMNode());
	        if ($error.is(":visible")) {
	            $error.animate({ top: 50, opacity: 0.1 }, 300, function() {
	                $(this).hide();
	            });
	        }
	    },

	    componentDidUpdate: function() {
	        clearTimeout(this._errorTimeout);
	        if (KAS.unitParse(this.props.value).parsed) {
	            this._hideError();
	        } else {
	            this._errorTimeout = setTimeout(this._showError, 2000);
	        }
	    },

	    componentWillUnmount: function() {
	        clearTimeout(this._errorTimeout);
	    },

	    handleBlur: function() {
	        this.props.onBlur([]);
	        clearTimeout(this._errorTimeout);
	        if (!KAS.unitParse(this.props.value).parsed) {
	            this._showError();
	        }
	    },

	    handleChange: function(event) {
	        this._hideError();
	        this.props.onChange({ value: event.target.value });
	    },

	    simpleValidate: function(rubric, onInputError) {
	        onInputError = onInputError || function() {};
	        return OldUnitInput.validate(this.getUserInput(), rubric);
	    },

	    getUserInput: function() {
	        return this.props.value;
	    },

	    // begin mobile stuff

	    getInputPaths: function() {
	        // The widget itself is an input, so we return a single empty list to
	        // indicate this.
	        return [[]];
	    },

	    focusInputPath: function(inputPath) {
	        this.refs.input.getDOMNode().focus();
	    },

	    handleFocus: function() {
	        this.props.onFocus([]);
	    },

	    blurInputPath: function(inputPath) {
	        this.refs.input.getDOMNode().blur();
	    },

	    setInputValue: function(path, newValue, cb) {
	        this.props.onChange({
	            value: newValue
	        }, cb);
	    },

	    getDOMNodeForPath: function() {
	        return this.refs.input.getDOMNode();
	    },

	    getGrammarTypeForPath: function(inputPath) {
	        return "unit";
	    },

	    // end mobile stuff
	});

	// Extract the primitive units from a unit expression. This first simplifies
	// `expr` to a `Mul` like "5 kg m / s^2" then removes the first term.
	var primUnits = function(expr) {
	    return expr.simplify().asMul().partition()[1].flatten().simplify();
	};

	_.extend(OldUnitInput, {
	    validate: function(state, rubric) {
	        var answer = KAS.unitParse(rubric.value).expr;
	        var guess = KAS.unitParse(state);
	        if (!guess.parsed) {
	            return  {
	                type: "invalid",
	                message: $._("I couldn't understand those units."),
	            };
	        }

	        // Note: we check sigfigs, then numerical correctness, then units, so
	        // the most significant things come last, that way the user will see
	        // the most important message.
	        var message = null;

	        // did the user specify the right number of sigfigs?
	        // TODO(joel) - add a grading mode where the wrong number of sigfigs
	        // isn't marked wrong
	        var sigfigs = rubric.sigfigs;
	        var sigfigsCorrect = countSigfigs(guess.coefficient) === sigfigs;
	        if (!sigfigsCorrect) {
	            message = $._("Check your significant figures.");
	        }

	        // now we need to check that the answer is correct to the precision we
	        // require.
	        var numericallyCorrect;
	        try {
	            var x = new KAS.Var("x");
	            var equality = new KAS.Eq(
	                answer.simplify(),
	                "=",
	                new KAS.Mul(x, guess.expr.simplify())
	            );

	            var conversion = equality.solveLinearEquationForVariable(x);

	            // Make sure the conversion factor between the user's input answer
	            // and the canonical answer is 1, to sigfig places.
	            // TODO(joel) is this sound?
	            numericallyCorrect =
	                Number(conversion.eval()).toPrecision(sigfigs) ===
	                Number(1).toPrecision(sigfigs);
	        } catch (e) {
	            numericallyCorrect = false;
	        }

	        if (!numericallyCorrect) {
	            message = $._("That answer is numerically incorrect.");
	        }

	        var kasCorrect;
	        var guessUnit = primUnits(guess.expr.simplify());
	        var answerUnit = primUnits(answer.simplify());

	        if (rubric.accepting === ALL) {
	            // We're accepting all units - KAS does the hard work of figuring
	            // out if the user's unit is equivalent to the author's unit.
	            kasCorrect = KAS.compare(
	                guessUnit,
	                answerUnit
	            ).equal;
	        } else {
	            // Are any of the accepted units the same as what the user entered?
	            kasCorrect = _(rubric.acceptingUnits).any(function(unit)  {
	                var thisAnswerUnit = primUnits(
	                    KAS.unitParse(unit).unit.simplify()
	                );
	                return KAS.compare(
	                    thisAnswerUnit,
	                    guessUnit
	                    // TODO(joel) - make this work as intended.
	                    // { form: true }
	                ).equal;
	            });
	        }
	        if (!kasCorrect) {
	            var message = $._("Check your units.");
	        }

	        var correct = kasCorrect && numericallyCorrect && sigfigsCorrect;

	        return {
	            type: "points",
	            earned: correct ? 1 : 0,
	            total: 1,
	            message:message,
	        };
	    }
	});


	// Show the name of a unit and whether it's recognized by KAS.
	//
	// In the future I plan for this to show an example of a thing that would be
	// accepted in that unit.
	var UnitExample = React.createClass({displayName: 'UnitExample',
	    render: function() {
	        var icon;
	        if (this.state.valid) {
	            icon = React.createElement("span", null, 
	                React.createElement("i", {className: "icon-ok unit-example-okay"}), 
	                this.state.solvedExample
	            );
	        } else {
	            icon = React.createElement("i", {className: "icon-remove unit-example-not-okay"});
	        }

	        return React.createElement("div", null, 
	            icon, " ", this.props.name
	        );
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this._checkValidity(nextProps);
	    },

	    componentWillMount: function() {
	        this._checkValidity(this.props);
	    },

	    _checkValidity: function($__0    ) {var name=$__0.name,original=$__0.original,sigfigs=$__0.sigfigs;
	        var parseResult = KAS.unitParse(name);
	        var solvedExample = "";

	        // A unit is valid if it parses and is equivalent to the original.
	        var valid = true;

	        if (parseResult.parsed && original) {
	            var x = new KAS.Var("x");
	            var $__1=    parseResult,unit=$__1.unit;
	            var equality = new KAS.Eq(
	                original,
	                "=",
	                new KAS.Mul(x, unit)
	            );
	            try {
	                var answer = equality.solveLinearEquationForVariable(x);

	                // The third parameter is the least significant decimal place.
	                // I.e. the index of the last place you care about
	                // (543210.(-1)(-2)(-3) etc). We use -10 because that should
	                // always be safe since we only care up to maximum 10 decimal
	                // places.
	                solvedExample = sigfigPrint(answer.eval(), sigfigs);

	                valid = KAS.compare(
	                    primUnits(original),
	                    primUnits(unit)
	                ).equal;
	            } catch (e) {
	                valid = false;
	            }
	        } else {
	            valid = false;
	        }

	        this.setState({
	            valid:valid,
	            solvedExample:solvedExample,
	        });
	    },
	});

	var UnitInputEditor = React.createClass({displayName: 'UnitInputEditor',
	    mixins: [Changeable, EditorJsonify],

	    propTypes: {
	        value: React.PropTypes.string,
	        acceptingUnits: React.PropTypes.arrayOf(React.PropTypes.string),
	        accepting: React.PropTypes.oneOf([ALL, SOME]),
	        sigfigs: React.PropTypes.number,
	    },

	    getDefaultProps: function() {
	        return {
	            value: "5x10^5 kg m / s^2",
	            accepting: ALL,
	            sigfigs: 3
	        };
	    },

	    render: function() {
	        var $__0=     this.props,acceptingUnits=$__0.acceptingUnits,accepting=$__0.accepting;
	        acceptingUnits = acceptingUnits || [];
	        var acceptingElem = null;
	        if (accepting === SOME) {
	            var unitsArr = acceptingUnits.map(function(name) 
	                {return React.createElement(UnitExample, {name: name, 
	                             original: this.original || null, 
	                             sigfigs: this.props.sigfigs});}.bind(this)
	            );

	            acceptingElem = React.createElement("div", null, 
	                React.createElement("input", {
	                    type: "text", 
	                    defaultValue: acceptingUnits.join(", "), 
	                    onChange: this.handleAcceptingUnitsChange}
	                ), 
	                " ", "(comma-separated)", 
	                unitsArr
	            );
	        }

	        return React.createElement("div", {className: "unit-editor"}, 
	            React.createElement("div", null, 
	                React.createElement("input", {value: this.props.value, 
	                       className: "unit-editor-canonical", 
	                       onBlur: this._handleBlur, 
	                       onKeyPress: this._handleBlur, 
	                       onChange: this.onChange}), 
	                " ", 
	                this.parsed ?
	                    React.createElement("i", {className: "icon-ok unit-example-okay"}) :
	                    React.createElement("i", {className: "icon-remove unit-example-not-okay"})
	                
	            ), 

	            React.createElement("div", null, 
	                "Significant Figures:", " ", 
	                React.createElement(NumberInput, {value: this.props.sigfigs, 
	                             onChange: this.handleSigfigChange, 
	                             checkValidity: this._checkSigfigValidity, 
	                             useArrowKeys: true})
	            ), 

	            React.createElement("div", null, 
	                React.createElement("label", null, 
	                    React.createElement("input", {type: "radio", 
	                           name: this.groupId, 
	                           onChange: function()  {return this._setAccepting(ALL);}.bind(this), 
	                           checked: this.props.accepting === ALL}), 
	                    " Any equivalent unit "
	                ), 
	                React.createElement("label", null, 
	                    React.createElement("input", {type: "radio", 
	                           name: this.groupId, 
	                           onChange: function()  {return this._setAccepting(SOME);}.bind(this), 
	                           checked: this.props.accepting === SOME}), 
	                    " Only these units "
	                )
	            ), 

	            acceptingElem
	        );
	    },

	    handleAcceptingUnitsChange: function(event) {
	        var acceptingUnits = event.target.value
	            .split(",")
	            .map(function(str)  {return str.trim();})
	            .filter(function(str)  {return str !== "";});
	        this.change({ acceptingUnits:acceptingUnits });
	    },

	    handleSigfigChange: function(sigfigs) {
	        this.change({ sigfigs:sigfigs });
	    },

	    _checkSigfigValidity: function(sigfigs) {
	        return sigfigs > 0 && sigfigs <= MAX_SIGFIGS;
	    },

	    _setAccepting: function(val) {
	        this.change({ accepting: val });
	    },

	    componentWillMount: function() {
	        this.groupId = _.uniqueId("accepting");
	        this._doOriginal(this.props);
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this._doOriginal(nextProps);
	    },

	    _doOriginal: function(props) {
	        var tryParse = KAS.unitParse(props.value);
	        this.parsed = false;

	        // Only update this state if the unit parsed *and* it has a magnitude
	        // attached to it. KAS can also parse units without magnitudes ("1.2
	        // g" vs "g").
	        if (tryParse.parsed && tryParse.type === "unitMagnitude") {
	            this.original = tryParse.expr;
	            this.parsed = true;
	        }
	    },

	    onChange: function(event) {
	        this.props.onChange({ value: event.target.value });
	    },

	    getSaveWarnings: function() {
	        var $__0=      this.props,value=$__0.value,accepting=$__0.accepting,acceptingUnits=$__0.acceptingUnits;
	        var warnings = [];

	        var tryParse = KAS.unitParse(value);
	        if (!tryParse.parsed) {
	            warnings.push("Answer did not parse");
	        }

	        if (accepting === SOME && acceptingUnits.length === 0) {
	            warnings.push("There are no accepted units");
	        }

	        return warnings;
	    },
	});

	module.exports = {
	    name: "unit-input",
	    displayName: "Unit",
	    defaultAlignment: "inline-block",
	    getWidget: function(enabledFeatures)  {
	        // Allow toggling between the two versions of the widget
	        return OldUnitInput;
	    },
	    editor: UnitInputEditor,
	    transform: function(x)  {return lens(x).del(["value"]).freeze();},
	    version: { major: 0, minor: 1 },
	    countSigfigs:countSigfigs,
	    sigfigPrint:sigfigPrint,
	    hidden: true,
	};


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
		"apiVersion": {
			"major": 3,
			"minor": 0
		},
		"itemDataVersion": {
			"major": 0,
			"minor": 1
		}
	}

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);

	var QuestionParagraph = React.createClass({displayName: 'QuestionParagraph',
	    render: function() {
	        var className = (this.props.className) ?
	            "paragraph " + this.props.className :
	            "paragraph";
	        return React.createElement("div", {className: className}, 
	            this.props.children
	        );
	    }
	});

	module.exports = QuestionParagraph;


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var React = __webpack_require__(68);

	var EnabledFeatures = __webpack_require__(56);
	var Widgets = __webpack_require__(19);

	var WidgetContainer = React.createClass({displayName: 'WidgetContainer',
	    propTypes: {
	        shouldHighlight: React.PropTypes.bool.isRequired,
	        type: React.PropTypes.string,
	        enabledFeatures: EnabledFeatures.propTypes,
	        initialProps: React.PropTypes.object.isRequired,
	    },

	    getInitialState: function() {
	        return {widgetProps: this.props.initialProps};
	    },

	    render: function() {
	        var className = classNames({
	            "perseus-widget-container": true,
	            "widget-highlight": this.props.shouldHighlight,
	            "widget-nohighlight": !this.props.shouldHighlight,
	        });

	        var type = this.props.type;
	        var WidgetType = Widgets.getWidget(type, this.props.enabledFeatures);
	        if (WidgetType == null) {
	            // Just give up on invalid widget types
	            return React.createElement("div", {className: className});
	        }

	        var alignment = this.state.widgetProps.alignment;
	        var style = {};


	        if (alignment === "default") {
	            alignment = Widgets.getDefaultAlignment(type,
	                            this.props.enabledFeatures);
	        }

	        className += " widget-" + alignment;

	        return React.createElement("div", {className: className, style: style}, 
	            React.createElement(WidgetType, React.__spread({},  this.state.widgetProps, {ref: "widget"}))
	        );
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (this.props.type !== nextProps.type) {
	            throw new Error(
	                "WidgetContainer can't change widget type; set a different " +
	                "key instead to recreate the container."
	            );
	        }
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        return (
	            this.props.shouldHighlight !== nextProps.shouldHighlight ||
	            this.props.type !== nextProps.type ||
	            this.state.widgetProps !== nextState.widgetProps
	        );
	    },

	    getWidget: function() {
	        return this.refs.widget;
	    },

	    replaceWidgetProps: function(newWidgetProps) {
	        this.setState({widgetProps: newWidgetProps});
	    }
	});

	module.exports = WidgetContainer;


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);

	module.exports = {
	    propTypes: React.PropTypes.shape({
	        toolTipFormats: React.PropTypes.bool.isRequired,
	        useMathQuill: React.PropTypes.bool.isRequired
	    }).isRequired,

	    defaults: {
	        // TODO(jack): Remove this two options
	        toolTipFormats: true,
	        useMathQuill: false
	    }
	};


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var SimpleMarkdown = __webpack_require__(123);
	var TeX = __webpack_require__(73);
	var Util = __webpack_require__(5);

	/**
	 * This match function matches math in `$`s, such as:
	 *
	 * $y = x + 1$
	 *
	 * It functions roughly like the following regex:
	 * /\$([^\$]*)\$/
	 *
	 * Unfortunately, math may have other `$`s inside it, as
	 * long as they are inside `{` braces `}`, mostly for
	 * `\text{ $math$ }`.
	 *
	 * To parse this, we can't use a regex, since we
	 * should support arbitrary nesting (even though
	 * MathJax actually only supports two levels of nesting
	 * here, which we *could* parse with a regex).
	 *
	 * Non-regex matchers like this are now a first-class
	 * concept in simple-markdown. Yay!
	 */
	var mathMatch = function(source)  {
	    var length = source.length;
	    // our source must start with a "$"
	    if (length === 0 || source[0] !== "$") {
	        return null;
	    }
	    var index = 1;
	    var braceLevel = 0;

	    // Loop through the source, looking for a closing '$'
	    // closing '$'s only count if they are not escaped with
	    // a `\`, and we are not in nested `{}` braces.
	    while (index < length) {
	        var character = source[index];

	        if (character === "\\") {
	            // Consume both the `\` and the escaped char as a single
	            // token.
	            // This is so that the second `$` in `$\\$` closes
	            // the math expression, since the first `\` is escaping
	            // the second `\`, but the second `\` is not escaping
	            // the second `$`.
	            // This also handles the case of escaping `$`s or
	            // braces `\{`
	            index++;

	        } else if (braceLevel <= 0 &&
	                character === "$") {

	            // Return an array that looks like the results of a
	            // regex's .exec function:
	            // capture[0] is the whole string
	            // capture[1] is the first "paren" match, which is the
	            //   content of the math here, as if we wrote the regex
	            //   /\$([^\$]*)\$/
	            return [
	                source.substring(0, index + 1),
	                source.substring(1, index)
	            ];

	        } else if (character === "{") {
	            braceLevel++;

	        } else if (character === "}") {
	            braceLevel--;

	        } else if (character === "\n" &&
	                source[index - 1] === "\n") {
	            // This is a weird case we supported in the old
	            // math implementation--double newlines break
	            // math. I'm preserving it for now because content
	            // creators might have questions with single '$'s
	            // in paragraphs...
	            return null;
	        }

	        index++;
	    }

	    // we didn't find a closing `$`
	    return null;
	};

	var TITLED_TABLE_REGEX = new RegExp(
	    "^\\|\\| +(.*) +\\|\\| *\\n" +
	    "(" +
	    // The simple-markdown nptable regex, without
	    // the leading `^`
	    SimpleMarkdown.defaultRules.nptable.match.regex.source.substring(1) +
	    ")"
	);

	var rules = _.extend({}, SimpleMarkdown.defaultRules, {
	    columns: {
	        order: -1,
	        match: SimpleMarkdown.blockRegex(/^([\s\S]*\n\n)={5,}\n\n([\s\S]*)/),
	        parse: function(capture, parse, state)  {
	            return {
	                col1: parse(capture[1], state),
	                col2: parse(capture[2], state)
	            };
	        },
	        react: function(node, output, state)  {
	            return React.createElement("div", {className: "perseus-two-columns", key: state.key}, 
	                React.createElement("div", {className: "perseus-column"}, 
	                    output(node.col1, state)
	                ), 
	                React.createElement("div", {className: "perseus-column"}, 
	                    output(node.col2, state), 
	                    /* HACK(#sat) This is a cheap way to allow hints to be
	                      * displayed in two-column items in the SAT mission. The
	                      * hint renderer will be rendered into this div. Do not
	                      * write code outside of the SAT mission that relies on
	                      * this because this will be cleaned up with other SAT
	                      * technical debt. */
	                    React.createElement("div", {className: "sat-grafting-area"})
	                )
	            );
	        },
	    },
	    // This is pretty much horrible, but we have a regex here to capture an
	    // entire table + a title. capture[1] is the title. capture[2] of the
	    // regex is a copy of the simple-markdown nptable regex. Then we turn
	    // our capture[2] into tableCapture[0], and any further captures in
	    // our table regex into tableCapture[1..], and we pass tableCapture to
	    // our nptable regex
	    titledTable: {
	        // process immediately before nptables
	        order: SimpleMarkdown.defaultRules.nptable.order - 0.5,
	        match: SimpleMarkdown.blockRegex(TITLED_TABLE_REGEX),
	        parse: function(capture, parse, state)  {
	            var title = SimpleMarkdown.parseInline(parse, capture[1], state);

	            // Remove our [0] and [1] captures, and pass the rest to
	            // the nptable parser
	            var tableCapture = _.rest(capture, 2);
	            var table = SimpleMarkdown.defaultRules.nptable.parse(
	                tableCapture,
	                parse,
	                state
	            );
	            return {
	                title: title,
	                table: table,
	            };
	        },
	        react: function(node, output, state)  {
	            var tableOutput = node.table ?
	                SimpleMarkdown.defaultRules.table.react(
	                    node.table,
	                    output,
	                    state
	                ) :  // :( (middle of the ternary expression)
	                "//invalid table//";
	            return React.createElement("div", {className: "perseus-titled-table", key: state.key}, 
	                React.createElement("div", {className: "perseus-table-title"}, 
	                    output(node.title, state)
	                ), 
	                React.createElement("div", null, tableOutput)
	            );
	        }
	    },
	    widget: {
	        order: SimpleMarkdown.defaultRules.link.order - 0.75,
	        match: SimpleMarkdown.inlineRegex(Util.rWidgetRule),
	        parse: function(capture, parse, state)  {
	            return {
	                id: capture[1],
	                widgetType: capture[2]
	            };
	        },
	        react: function(node, output, state)  {
	            // The actual output is handled in the renderer, where
	            // we know the current widget props/state. This is
	            // just a stub for testing.
	            return React.createElement("em", {key: state.key}, 
	                "[Widget: ", node.id, "]"
	            );
	        }
	    },
	    math: {
	        order: SimpleMarkdown.defaultRules.link.order - 0.25,
	        match: mathMatch,
	        parse: function(capture, parse, state)  {
	            return {
	                content: capture[1]
	            };
	        },
	        react: function(node, output, state)  {
	            // The actual output is handled in the renderer, because
	            // it needs to pass in an `onRender` callback prop. This
	            // is just a stub for testing.
	            return React.createElement(TeX, {key: state.key}, node.content);
	        }
	    },
	    fence: _.extend({}, SimpleMarkdown.defaultRules.fence, {
	        parse: function(capture, parse, state)  {
	            var node = SimpleMarkdown.defaultRules.fence.parse(
	                capture,
	                parse,
	                state
	            );

	            // support screenreader-only text with ```alt
	            if (node.lang === "alt") {
	                return {
	                    type: "codeBlock",
	                    lang: "alt",
	                    // default codeBlock parsing doesn't parse the contents.
	                    // We need to parse the contents for things like table
	                    // support :).
	                    // The \n\n is because the inside of the codeblock might
	                    // not end in double newlines for block rules, because
	                    // ordinarily we don't parse this :).
	                    content: parse(node.content + "\n\n", state),
	                };
	            } else {
	                return node;
	            }
	        },
	    }),
	    codeBlock: _.extend({}, SimpleMarkdown.defaultRules.codeBlock, {
	        react: function(node, output, state)  {
	            // ideally this should be a different rule, with only an
	            // output function, but right now that breaks the parser.
	            if (node.lang === "alt") {
	                return React.createElement("div", {
	                        key: state.key, 
	                        className: "perseus-markdown-alt perseus-sr-only"}, 
	                    output(node.content, state)
	                );
	            } else {
	                return SimpleMarkdown.defaultRules.codeBlock.react(
	                    node,
	                    output,
	                    state
	                );
	            }
	        }
	    }),
	});

	var builtParser = SimpleMarkdown.parserFor(rules);
	var parse = function(source)  {
	    var paragraphedSource = source + "\n\n";
	    return builtParser(paragraphedSource, {inline: false});
	};
	var inlineParser = function(source)  {
	    return builtParser(source, {inline: true});
	};

	/**
	 * Traverse all of the nodes in the Perseus Markdown AST. The callback is
	 * called for each node in the AST.
	 */
	var traverseContent = function(ast, cb)  {
	    if (_.isArray(ast)) {
	        _.each(ast, function(node)  {return traverseContent(node, cb);});
	    } else if (_.isObject(ast)) {
	        cb(ast);
	        if (ast.type === "table") {
	            traverseContent(ast.header, cb);
	            traverseContent(ast.cells, cb);
	        } else if (ast.type === "list") {
	            traverseContent(ast.items, cb);
	        } else if (ast.type === "titledTable") {
	            traverseContent(ast.table, cb);
	        } else if (ast.type === "columns") {
	            traverseContent(ast.col1, cb);
	            traverseContent(ast.col2, cb);
	        } else if (_.isArray(ast.content)) {
	            traverseContent(ast.content, cb);
	        }
	    }
	};

	/**
	 * Pull out text content from a Perseus Markdown AST.
	 * Returns an array of strings.
	 */
	var getContent = function(ast)  {
	    // Simplify logic by dealing with a single AST node at a time
	    if (_.isArray(ast)) {
	        return _.flatten(_.map(ast, getContent));
	    }

	    // Base case: This is where we actually extract text content
	    if (ast.content && _.isString(ast.content)) {
	        // Collapse whitespace within content unless it is code
	        if (ast.type.toLowerCase().indexOf('code') !== -1) {
	            // In case this is the sole child of a paragraph,
	            // prevent whitespace from being trimmed later
	            return ['', ast.content, ''];
	        } else {
	            return [ast.content.replace(/\s+/g, ' ')];
	        }
	    }

	    // Recurse through child AST nodes
	    // Assumptions made:
	    // 1) Child AST nodes are either direct properties or inside
	    //    arbitrarily nested lists that are direct properties.
	    // 2) Only AST nodes have a 'type' property.
	    var children = _.chain(ast)
	        .values()
	        .flatten()
	        .filter(function(object)  {return object != null && _.has(object, 'type');})
	        .value();

	    if (!children.length) {
	        return [];
	    } else {
	        var nestedContent = getContent(children);
	        if (ast.type === 'paragraph' && nestedContent.length) {
	            // Trim whitespace before or after a paragraph
	            nestedContent[0] = nestedContent[0].replace(/^\s+/, '');
	            var last = nestedContent.length - 1;
	            nestedContent[last] = nestedContent[last].replace(/\s+$/, '');
	        }
	        return nestedContent;
	    }
	};

	/**
	 * Count the number of characters in Perseus Markdown source.
	 * Markdown markup and widget references are ignored.
	 */
	var characterCount = function(source)  {
	    var ast = parse(source);
	    var content = getContent(ast).join('');
	    return content.length;
	};

	module.exports = {
	    characterCount: characterCount,
	    traverseContent: traverseContent,
	    parse: parse,
	    parseInline: inlineParser,
	    reactFor: SimpleMarkdown.reactFor,
	    ruleOutput: SimpleMarkdown.ruleOutput(rules, "react"),
	    basicOutput: SimpleMarkdown.reactFor(
	        SimpleMarkdown.ruleOutput(rules, "react")
	    ),
	    sanitizeUrl: SimpleMarkdown.sanitizeUrl,
	};



/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	var JsonEditor = React.createClass({displayName: 'JsonEditor',

	    getInitialState: function() {
	        return {
	            currentValue: JSON.stringify(this.props.value, null, 4),
	            valid: true
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        var shouldReplaceContent = !this.state.valid ||
	            !_.isEqual(
	                nextProps.value,
	                JSON.parse(this.state.currentValue)
	            );

	        if (shouldReplaceContent) {
	            this.setState(this.getInitialState());
	        }
	    },

	    render: function() {
	        var classes = "perseus-json-editor " +
	            (this.state.valid ? "valid" : "invalid");

	        return React.createElement("textarea", {
	            className: classes, 
	            value: this.state.currentValue, 
	            onChange: this.handleChange, 
	            onKeyDown: this.handleKeyDown, 
	            onBlur: this.handleBlur});
	    },

	    handleKeyDown: function(e) {
	        // This handler allows the tab character to be entered by pressing
	        // tab, instead of jumping to the next (non-existant) field
	        if (e.key === "Tab") {
	            var cursorPos = e.target.selectionStart;
	            var v = e.target.value;
	            var textBefore = v.substring(0, cursorPos);
	            var textAfter = v.substring(cursorPos, v.length);
	            e.target.value = textBefore+ "    " +textAfter;
	            e.target.selectionStart = textBefore.length + 4;
	            e.target.selectionEnd = textBefore.length + 4;

	            e.preventDefault();
	            this.handleChange(e);
	        }
	    },

	    handleChange: function(e) {
	        var nextString = e.target.value;
	        try {
	            var json = JSON.parse(nextString);
	            // Some extra handling to allow copy-pasting from /api/vi
	            if (_.isString(json)) {
	                json = JSON.parse(json);
	            }
	            // This callback unfortunately causes multiple renders,
	            // but seems to be necessary to avoid componentWillReceiveProps
	            // being called before setState has gone through
	            this.setState({
	                currentValue: nextString,
	                valid: true
	            }, function() {
	                this.props.onChange(json);
	            });
	        } catch (ex) {
	            this.setState({
	                currentValue: nextString,
	                valid: false
	            });
	        }
	    },

	    // You can type whatever you want as you're typing, but if it's not valid
	    // when you blur, it will revert to the last valid value.
	    handleBlur: function(e) {
	        var nextString = e.target.value;
	        try {
	            var json = JSON.parse(nextString);
	            // Some extra handling to allow copy-pasting from /api/vi
	            if (_.isString(json)) {
	                json = JSON.parse(json);
	            }
	            // This callback unfortunately causes multiple renders,
	            // but seems to be necessary to avoid componentWillReceiveProps
	            // being called before setState has gone through
	            this.setState({
	                currentValue: JSON.stringify(json, null, 4),
	                valid: true
	            }, function() {
	                this.props.onChange(json);
	            });
	        } catch (ex) {
	            this.setState({
	                currentValue: JSON.stringify(this.props.value, null, 4),
	                valid: true
	            });
	        }
	    }
	});

	module.exports = JsonEditor;


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	/* Collection of classes for rendering the hint editor area,
	 * hint editor boxes, and hint previews
	 */

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var Editor = __webpack_require__(11);
	var HintRenderer = __webpack_require__(61);
	var InfoTip = __webpack_require__(75);

	/* Renders a hint editor box
	 *
	 * This includes:
	 *  ~ A "Hint" title
	 *  ~ the textarea for the hint
	 *  ~ the "remove this hint" box
	 *  ~ the move hint up/down arrows
	 */
	var HintEditor = React.createClass({displayName: 'HintEditor',
	    propTypes: {
	        imageUploader: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            content: ""
	        };
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-hint-editor perseus-editor-left-cell"}, 
	            React.createElement("div", {className: "pod-title"}, "Hint"), 
	            React.createElement(Editor, {ref: "editor", 
	                    widgets: this.props.widgets, 
	                    content: this.props.content, 
	                    images: this.props.images, 
	                    placeholder: "Type your hint here...", 
	                    imageUploader: this.props.imageUploader, 
	                    onChange: this.props.onChange}), 
	            React.createElement("div", {className: "hint-controls-container clearfix"}, 
	                React.createElement("span", {className: "reorder-hints"}, 
	                    React.createElement("button", {type: "button", 
	                            className: this.props.isLast ? "hidden" : "", 
	                            onClick: _.partial(this.props.onMove, 1)}, 
	                        React.createElement("span", {className: "icon-circle-arrow-down"})
	                    ), 
	                    ' ', 
	                    React.createElement("button", {type: "button", 
	                            className: this.props.isFirst ? "hidden" : "", 
	                            onClick: _.partial(this.props.onMove, -1)}, 
	                        React.createElement("span", {className: "icon-circle-arrow-up"})
	                    ), 
	                    ' ', 
	                    this.props.isLast &&
	                    React.createElement(InfoTip, null, 
	                        React.createElement("p", null, "The last hint is automatically bolded.")
	                    )
	                ), 
	                React.createElement("button", {type: "button", 
	                        className: "remove-hint simple-button orange", 
	                        onClick: this.props.onRemove}, 
	                    React.createElement("span", {className: "icon-trash"}), " Remove this hint", ' '
	                )
	            )
	        );
	    },

	    focus: function() {
	        this.refs.editor.focus();
	    },

	    getSaveWarnings: function() {
	        return this.refs.editor.getSaveWarnings();
	    },

	    serialize: function(options) {
	        return this.refs.editor.serialize(options);
	    }
	});


	/* A single hint-row containing a hint editor and preview */
	var CombinedHintEditor = React.createClass({displayName: 'CombinedHintEditor',
	    propTypes: {
	        imageUploader: React.PropTypes.func
	    },

	    render: function() {
	        var shouldBold = this.props.isLast &&
	                         !(/\*\*/).test(this.props.hint.content);
	        return React.createElement("div", {className: "perseus-combined-hint-editor " +
	                    "perseus-editor-row"}, 
	            React.createElement(HintEditor, {
	                ref: "editor", 
	                isFirst: this.props.isFirst, 
	                isLast: this.props.isLast, 
	                widgets: this.props.hint.widgets, 
	                content: this.props.hint.content, 
	                images: this.props.hint.images, 
	                imageUploader: this.props.imageUploader, 
	                onChange: this.props.onChange, 
	                onRemove: this.props.onRemove, 
	                onMove: this.props.onMove}), 

	            React.createElement("div", {className: "perseus-editor-right-cell"}, 
	                React.createElement(HintRenderer, {
	                    hint: this.props.hint, 
	                    bold: shouldBold, 
	                    pos: this.props.pos})
	            )
	        );
	    },

	    getSaveWarnings: function() {
	        return this.refs.editor.getSaveWarnings();
	    },

	    serialize: function(options) {
	        return this.refs.editor.serialize(options);
	    },

	    focus: function() {
	        this.refs.editor.focus();
	    }
	});


	/* The entire hints editing/preview area
	 *
	 * Includes:
	 *  ~ All the hint edit boxes, move and remove buttons
	 *  ~ All the hint previews
	 *  ~ The "add a hint" button
	 */
	var CombinedHintsEditor = React.createClass({displayName: 'CombinedHintsEditor',
	    propTypes: {
	        imageUploader: React.PropTypes.func
	    },

	    getDefaultProps: function() {
	        return {
	            onChange: function()  {},
	            hints: []
	        };
	    },

	    render: function() {
	        var hints = this.props.hints;
	        var hintElems = _.map(hints, function(hint, i) {
	            return React.createElement(CombinedHintEditor, {
	                        ref: "hintEditor" + i, 
	                        key: "hintEditor" + i, 
	                        isFirst: i === 0, 
	                        isLast: i + 1 === hints.length, 
	                        hint: hint, 
	                        pos: i, 
	                        imageUploader: this.props.imageUploader, 
	                        onChange: this.handleHintChange.bind(this, i), 
	                        onRemove: this.handleHintRemove.bind(this, i), 
	                        onMove: this.handleHintMove.bind(this, i)});
	        }, this);

	        return React.createElement("div", {className: "perseus-hints-editor perseus-editor-table"}, 
	            hintElems, 
	            React.createElement("div", {className: "perseus-editor-row"}, 
	                React.createElement("div", {className: "add-hint-container perseus-editor-left-cell"}, 
	                React.createElement("button", {type: "button", 
	                        className: "add-hint simple-button orange", 
	                        onClick: this.addHint}, 
	                    React.createElement("span", {className: "icon-plus"}), 
	                    ' ', "Add a hint"
	                )
	                ), 
	                React.createElement("div", {className: "perseus-editor-right-cell"})
	            )
	        );
	    },

	    handleHintChange: function(i, newProps, cb, silent) {
	        // TODO(joel) - lens
	        var hints = _(this.props.hints).clone();
	        hints[i] = _.extend(
	            {},
	            this.serializeHint(i, {keepDeletedWidgets: true}),
	            newProps
	        );

	        this.props.onChange({hints: hints}, cb, silent);
	    },

	    handleHintRemove: function(i) {
	        var hints = _(this.props.hints).clone();
	        hints.splice(i, 1);
	        this.props.onChange({hints: hints});
	    },

	    handleHintMove: function(i, dir) {
	        var hints = _(this.props.hints).clone();
	        var hint = hints.splice(i, 1)[0];
	        hints.splice(i + dir, 0, hint);
	        this.props.onChange({hints: hints}, function()  {
	            this.refs["hintEditor" + (i + dir)].focus();
	        }.bind(this));
	    },

	    addHint: function() {
	        var hints = _(this.props.hints).clone().concat([{ content: "" }]);
	        this.props.onChange({hints: hints}, function()  {
	            var i = hints.length - 1;
	            this.refs["hintEditor" + i].focus();
	        }.bind(this));
	    },

	    getSaveWarnings: function() {
	        return _.chain(this.props.hints)
	            .map(function(hint, i)  {
	                return _.map(
	                    this.refs["hintEditor" + i].getSaveWarnings(),
	                    function(issue)  {return "Hint " + (i + 1) + ": " + issue;});
	            }.bind(this))
	            .flatten(true)
	            .value();
	    },

	    serialize: function(options) {
	        return this.props.hints.map(function(hint, i)  {
	            return this.serializeHint(i, options);
	        }.bind(this));
	    },

	    serializeHint: function(index, options) {
	        return this.refs["hintEditor" + index].serialize(options);
	    }
	});

	module.exports = CombinedHintsEditor;


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	var AnswerAreaEditor = __webpack_require__(100);
	var Editor = __webpack_require__(11);
	var ApiOptions = __webpack_require__(17).Options;
	var ITEM_DATA_VERSION = __webpack_require__(53).itemDataVersion;

	var ItemEditor = React.createClass({displayName: 'ItemEditor',
	    propTypes: {
	        imageUploader: React.PropTypes.func,
	        wasAnswered: React.PropTypes.bool,
	        gradeMessage: React.PropTypes.string,
	        apiOptions: ApiOptions.propTypes,
	    },

	    getDefaultProps: function() {
	        return {
	            onChange: function()  {},
	            question: {},
	            answerArea: {},
	            apiOptions: ApiOptions.defaults,
	        };
	    },

	    // Notify the parent that the question or answer area has been updated.
	    updateProps: function(newProps, cb, silent) {
	        var props = _(this.props).pick("question", "answerArea");

	        this.props.onChange(_(props).extend(newProps), cb, silent);
	    },

	    render: function() {
	        return React.createElement("div", {className: "perseus-editor-table"}, 
	            React.createElement("div", {className: "perseus-editor-row perseus-question-container"}, 
	                React.createElement("div", {className: "perseus-editor-left-cell"}, 
	                    React.createElement("div", {className: "pod-title"}, "Question"), 
	                    React.createElement(Editor, React.__spread({
	                        ref: "questionEditor", 
	                        placeholder: "Type your question here...", 
	                        className: "perseus-question-editor", 
	                        imageUploader: this.props.imageUploader, 
	                        onChange: this.handleEditorChange, 
	                        apiOptions: this.props.apiOptions, 
	                        showWordCount: true}, 
	                        this.props.question))
	                ), 

	                React.createElement("div", {className: "perseus-editor-right-cell"}, 
	                    React.createElement("div", {id: "problemarea"}, 
	                        React.createElement("div", {id: "workarea", className: "workarea"}), 
	                        React.createElement("div", {id: "hintsarea", 
	                             className: "hintsarea", 
	                             style: {display: "none"}})
	                    )
	                )
	            ), 

	            React.createElement("div", {className: "perseus-editor-row perseus-answer-container"}, 
	                React.createElement("div", {className: "perseus-editor-left-cell"}, 
	                    React.createElement("div", {className: "pod-title"}, "Answer"), 
	                    React.createElement(AnswerAreaEditor, React.__spread({
	                        ref: "answerAreaEditor", 
	                        onChange: this.handleAnswerAreaChange, 
	                        apiOptions: this.props.apiOptions}, 
	                        this.props.answerArea))
	                ), 

	                React.createElement("div", {className: "perseus-editor-right-cell"}, 
	                    React.createElement("div", {id: "answer_area"}, 
	                        React.createElement("div", {id: "solutionarea", className: "solutionarea"}), 
	                        React.createElement("div", {className: "answer-buttons"}, 
	                            React.createElement("input", {
	                                type: "button", 
	                                className: "simple-button green", 
	                                onClick: this.props.onCheckAnswer, 
	                                value: "Check Answer"}), 
	                            this.props.wasAnswered &&
	                                React.createElement("img", {src: "/images/face-smiley.png", 
	                                    className: "smiley"}), 
	                            this.props.gradeMessage &&
	                                React.createElement("span", null, this.props.gradeMessage)
	                        )
	                    )
	                )
	            )
	        );
	    },

	    handleEditorChange: function(newProps, cb, silent) {
	        var question = _.extend({}, this.props.question, newProps);
	        this.updateProps({ question:question }, cb, silent);
	    },

	    handleAnswerAreaChange: function(newProps, cb, silent) {
	        var answerArea = _.extend({}, this.props.answerArea, newProps);
	        this.updateProps({ answerArea:answerArea }, cb, silent);
	    },

	    getSaveWarnings: function() {
	        var issues1 = this.refs.questionEditor.getSaveWarnings();
	        var issues2 = this.refs.answerAreaEditor.getSaveWarnings();
	        return issues1.concat(issues2);
	    },

	    serialize: function(options) {
	        return {
	            question: this.refs.questionEditor.serialize(options),
	            answerArea: this.refs.answerAreaEditor.serialize(options),
	            itemDataVersion: ITEM_DATA_VERSION
	        };
	    },

	    focus: function() {
	        this.questionEditor.focus();
	    }
	});

	module.exports = ItemEditor;


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var Renderer = __webpack_require__(15);

	/* Renders just a hint preview */
	var HintRenderer = React.createClass({displayName: 'HintRenderer',
	    render: function() {
	        var shouldBold = this.props.bold;
	        var hint = this.props.hint;
	        var classNames;
	        if (shouldBold) {
	            classNames = "perseus-hint-renderer last-hint";
	        } else {
	            classNames = "perseus-hint-renderer";
	        }
	        return React.createElement("div", {className: classNames, tabIndex: "-1"}, 
	            React.createElement("span", {className: "perseus-sr-only"}, 
	                $._("Hint #%(pos)s", {pos: this.props.pos + 1})
	            ), 
	            React.createElement(Renderer, {
	                ref: "renderer", 
	                widgets: this.props.hint.widgets, 
	                content: this.props.hint.content || "", 
	                images: this.props.hint.images})
	        );
	    },

	    getSerializedState: function() {
	        return this.refs.renderer.getSerializedState();
	    },

	    restoreSerializedState: function(state, callback) {
	        this.refs.renderer.restoreSerializedState(state, callback);
	    },
	});

	module.exports = HintRenderer;


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);

	var diff = __webpack_require__(111);
	var splitDiff = __webpack_require__(102);
	var stringArrayDiff = __webpack_require__(103);

	var BEFORE = "before";
	var AFTER = "after";

	var IMAGE_REGEX = /http.*?\.png/g;

	var imagesInString = function(str) {
	    return str.match(IMAGE_REGEX) || [];
	};

	var classFor = function(entry, ifAdded, ifRemoved) {
	    if (entry.added) {
	        return ifAdded;
	    } else if (entry.removed) {
	        return ifRemoved;
	    } else {
	        return "";
	    }
	};

	var ImageDiffSide = React.createClass({displayName: 'ImageDiffSide',
	    propTypes: {
	        side: React.PropTypes.oneOf([BEFORE, AFTER]).isRequired,
	        images: React.PropTypes.array.isRequired
	    },

	    render: function() {
	        return React.createElement("div", null, 
	            this.props.images.length > 0 &&
	                React.createElement("div", {className: "diff-header"}, "Images"), 
	            _.map(this.props.images, function(entry)  {
	                var className = classNames({
	                    "image": true,
	                    "image-unchanged": entry.status === "unchanged",
	                    "image-added": entry.status === "added",
	                    "image-removed": entry.status === "removed"
	                });
	                return React.createElement("div", null, 
	                    React.createElement("img", {src: entry.value, 
	                        title: entry.value, 
	                        className: className})
	                );
	            })
	        );
	    }
	});

	var TextDiff = React.createClass({displayName: 'TextDiff',
	    propTypes: {
	        before: React.PropTypes.string,
	        after: React.PropTypes.string,
	        title: React.PropTypes.string
	    },

	    getDefaultProps: function() {
	        return {
	            before: "",
	            after: "",
	            title: ""
	        };
	    },

	    getInitialState: function() {
	        return {
	            collapsed: this.props.before === this.props.after
	        };
	    },

	    componentWillReceiveProps: function(nextProps) {
	        this.setState({
	            collapsed: nextProps.before === nextProps.after
	        });
	    },

	    render: function() {
	        var diffed = diff.diffWords(this.props.before, this.props.after);

	        var lines = splitDiff(diffed);

	        beforeImages = imagesInString(this.props.before);
	        afterImages = imagesInString(this.props.after);

	        var images = stringArrayDiff(beforeImages, afterImages);

	        var renderedLines = _.map(lines, function(line)  {
	            var contents = {};

	            contents.before = _(line).map(function(entry, i) {
	                var className = classFor(entry, "not-present", "removed dark");
	                return React.createElement("span", {
	                    key: i, 
	                    className: className}, entry.value);
	            });

	            contents.after = _(line).map(function(entry, i) {
	                var className = classFor(entry, "added dark", "not-present");
	                return React.createElement("span", {
	                    key: i, 
	                    className: className}, entry.value);
	            });
	            return contents;
	        });

	        var className = classNames({
	            "diff-row": true,
	            "collapsed": this.state.collapsed
	        });

	        return React.createElement("div", null, 
	            React.createElement("div", {className: "ui-helper-clearfix"}, 
	                _.map([BEFORE, AFTER], function(side)  {
	                    return React.createElement("div", {className: "diff-row " + side}, 
	                        !this.state.collapsed &&
	                            _.map(renderedLines, function(line)  {
	                                var changed = line[side].length > 1;
	                                var lineClass = classNames({
	                                    "diff-line": true,
	                                    "added": side === AFTER && changed,
	                                    "removed": side === BEFORE && changed
	                                });
	                                return React.createElement("div", {className: lineClass}, 
	                                    line[side]
	                                );
	                            }), 
	                         !this.state.collapsed &&
	                             React.createElement(ImageDiffSide, {
	                                 side: side, 
	                                 images: images[side]})
	                    );
	                }.bind(this))
	            ), 
	            _.map([BEFORE, AFTER], function(side)  {
	                return React.createElement("div", {className: className + " " + side, 
	                    onClick: this.handleExpand}, 
	                    this.state.collapsed &&
	                    React.createElement("span", null, 
	                        React.createElement("span", {className: "expand-button"}, 
	                            " ", "[ show unmodified ]"
	                        )
	                    )
	                );
	            }.bind(this))
	        );
	    },

	    handleExpand: function() {
	        this.setState({ collapsed: false });
	    }
	});

	module.exports = TextDiff;


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	var classNames = __webpack_require__(112);
	var performDiff = __webpack_require__(101);

	var indentationFromDepth = function(depth) {
	    return (depth - 1) * 20;
	};

	var BEFORE = "before";
	var AFTER = "after";

	var UNCHANGED = "unchanged";

	var DiffSide = React.createClass({displayName: 'DiffSide',
	    propTypes: {
	        side: React.PropTypes.oneOf([BEFORE, AFTER]).isRequired,
	        className: React.PropTypes.string.isRequired,
	        showKey: React.PropTypes.bool.isRequired,
	        propKey: React.PropTypes.string.isRequired,
	        value: React.PropTypes.string,
	        depth: React.PropTypes.number.isRequired
	    },

	    render: function() {
	        var className = classNames(this.props.className, {
	            "diff-row": true,
	            before: this.props.side === BEFORE,
	            after: this.props.side === AFTER
	        });
	        return React.createElement("div", {className: className}, 
	            React.createElement("div", {style: {
	                paddingLeft: indentationFromDepth(this.props.depth)
	            }}, 
	                this.props.showKey && this.props.propKey + ": ", 
	                React.createElement("span", {className: "inner-value dark " + this.props.className}, 
	                    this.props.value
	                )
	            )
	        );
	    }
	});

	var CollapsedRow = React.createClass({displayName: 'CollapsedRow',
	    propTypes: {
	        depth: React.PropTypes.number,
	        onClick: React.PropTypes.func.isRequired
	    },

	    getDefaultProps: function() {
	        return {
	            depth: 0
	        };
	    },

	    render: function() {
	        var self = this;
	        return React.createElement("div", {onClick: self.props.onClick}, 
	            _.map([BEFORE, AFTER], function(side) {
	                return React.createElement("div", {className: "diff-row collapsed " + side, 
	                    key: side}, 
	                        React.createElement("div", {style: {
	                            paddingLeft: indentationFromDepth(self.props.depth)
	                        }}, 
	                        React.createElement("span", null, " [ show unmodified ] ")
	                    )
	                );
	            })
	        );
	    }
	});

	// Component representing a single property that may be nested.
	var DiffEntry = React.createClass({displayName: 'DiffEntry',
	    propTypes: {
	        entry: React.PropTypes.shape({
	            key: React.PropTypes.string,
	            children: React.PropTypes.array,
	            before: React.PropTypes.string,
	            after: React.PropTypes.string
	        }),
	        depth: React.PropTypes.number,
	        expanded: React.PropTypes.bool
	    },

	    getDefaultProps: function() {
	        return {
	            depth: 0
	        };
	    },

	    getInitialState: function() {
	        return {
	            expanded: this.props.expanded
	        };
	    },

	    render: function() {
	        var entry = this.props.entry;
	        var propertyDeleted = entry.status === "removed";
	        var propertyAdded   = entry.status === "added";
	        var propertyChanged = entry.status === "changed";

	        var hasChildren = entry.children.length > 0;

	        var leftClass = classNames({
	            "removed": (propertyDeleted || propertyChanged) && !hasChildren,
	            "dark": propertyDeleted,
	            "blank-space": propertyAdded
	        });

	        var rightClass = classNames({
	            "added": (propertyAdded || propertyChanged) && !hasChildren,
	            "dark": propertyAdded,
	            "blank-space": propertyDeleted
	        });

	        var shownChildren;
	        if (this.state.expanded) {
	            shownChildren = entry.children;
	        } else {
	            shownChildren = _(entry.children).select(function(child) {
	                return child.status !== UNCHANGED;
	            });
	        }

	        var collapsed = shownChildren.length < entry.children.length;

	        // don't hide just one entry
	        if (entry.children.length === shownChildren.length + 1) {
	            shownChildren = entry.children;
	            collapsed = false;
	        }

	        var self = this;
	        return React.createElement("div", null, 
	            entry.key && React.createElement("div", null, 
	            React.createElement(DiffSide, {
	                side: BEFORE, 
	                className: leftClass, 
	                depth: this.props.depth, 
	                propKey: entry.key, 
	                showKey: !propertyAdded, 
	                value: entry.before}), 
	            React.createElement(DiffSide, {
	                side: AFTER, 
	                className: rightClass, 
	                depth: this.props.depth, 
	                propKey: entry.key, 
	                showKey: !propertyDeleted, 
	                value: entry.after})
	            ), 
	            _.map(shownChildren, function(child) {
	                return React.createElement(DiffEntry, {
	                    key: child.key, 
	                    depth: self.props.depth + 1, 
	                    entry: child, 
	                    expanded: self.state.expanded});
	            }), 
	            collapsed &&
	                React.createElement(CollapsedRow, {
	                    depth: this.props.depth + 1, 
	                    onClick: this.expand})
	        );
	    },

	    expand: function() {
	        this.setState({ expanded: true });
	    }
	});

	var WidgetDiff = React.createClass({displayName: 'WidgetDiff',
	    propTypes: {
	        before: React.PropTypes.shape({
	            options: React.PropTypes.object
	        }).isRequired,
	        after: React.PropTypes.shape({
	            options: React.PropTypes.object
	        }).isRequired,
	        title: React.PropTypes.string.isRequired
	    },

	    render: function() {
	        var diff = performDiff(this.props.before,
	                               this.props.after);
	        return React.createElement("div", null, 
	            React.createElement("div", {className: "ui-helper-clearfix"}, 
	                React.createElement(DiffEntry, {entry: diff})
	            )
	        );
	    }
	});

	module.exports = WidgetDiff;


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(67);

	var FixedToResponsive = __webpack_require__(104);
	var Graphie = __webpack_require__(80);
	var Util = __webpack_require__(5);

	// The global cache of label data. Its format is:
	// {
	//   hash (e.g. "c21435944d2cf0c8f39d9059cb35836aa701d04a"): {
	//     loaded: a boolean of whether the data has been loaded or not
	//     dataCallbacks: a list of callbacks to call with the data when the data
	//                    is loaded
	//     data: the other data for this hash
	//   },
	//   ...
	// }
	var labelDataCache = {};

	// Write our own JSONP handler because all the other ones don't do things we
	// need.
	var doJSONP = function(url, options) {
	    options = _.extend({}, {
	        callbackName: "callback",
	        success: $.noop,
	        error: $.noop
	    }, options);

	    // Create the script
	    var script = document.createElement("script");
	    script.setAttribute("async", "");
	    script.setAttribute("src", url);

	    // A cleanup function to run when we're done.
	    function cleanup() {
	        document.head.removeChild(script);
	        delete window[options.callbackName];
	    }

	    // Add the global callback.
	    window[options.callbackName] = function() {
	        cleanup();
	        options.success.apply(null, arguments);
	    };

	    // Add the error handler.
	    script.addEventListener("error", function() {
	        cleanup();
	        options.error.apply(null, arguments);
	    });

	    // Insert the script to start the download.
	    document.head.appendChild(script);
	};

	var svgLabelsRegex = /^web\+graphie\:/;
	var hashRegex = /\/([^/]+)$/;

	function isLabeledSVG(url) {
	    return svgLabelsRegex.test(url);
	}

	// For each svg+labels, there are two urls we need to download from. This gets
	// the base url without the suffix, and `getSvgUrl` and `getDataUrl` apply
	// appropriate suffixes to get the image and other data
	function getBaseUrl(url) {
	    // Force HTTPS connection unless we're on HTTP, so that IE works.
	    var protocol = window.location.protocol === "http:" ? "http:" : "https:";

	    return url.replace(svgLabelsRegex, protocol);
	}

	function getSvgUrl(url) {
	    return getBaseUrl(url) + ".svg";
	}

	function getDataUrl(url) {
	    return getBaseUrl(url) + "-data.json";
	}

	function shouldUseLocalizedData() {
	    // TODO(emily): Remove this depenency on `KA` and pass it down with
	    // Perseus' initialization. (Also used in renderer.jsx)
	    return typeof KA !== "undefined" && KA.language !== "en";
	}

	// A regex to split at the last / of a URL, separating the base part from the
	// hash. This is used to create the localized label data URLs.
	var splitHashRegex = /\/(?=[^/]+$)/;

	function getLocalizedDataUrl(url) {
	    if (typeof KA !== "undefined") {
	        // Parse out the hash and base so that we can insert the locale
	        // directory in the middle.
	        var $__0=   getBaseUrl(url).split(splitHashRegex),base=$__0[0],hash=$__0[1];
	        return (base + "/" + KA.language + "/" + hash + "-data.json");
	    } else {
	        return getDataUrl(url);
	    }
	}

	// Get the hash from the url, which is just the filename
	function getUrlHash(url) {
	    var match = url.match(hashRegex);

	    return match && match[1];
	}

	var SvgImage = React.createClass({displayName: 'SvgImage',
	    statics: {
	        // Sometimes other components want to download the actual image e.g. to
	        // determine its size. Here, we transform an .svg-labels url into the
	        // correct image url, and leave normal image urls alone
	        getRealImageUrl: function(url) {
	            if (isLabeledSVG(url)) {
	                return getSvgUrl(url);
	            } else {
	                return url;
	            }
	        }
	    },

	    propTypes: {
	        src: React.PropTypes.string.isRequired,
	        alt: React.PropTypes.string,
	        title: React.PropTypes.string,
	        width: React.PropTypes.number,
	        height: React.PropTypes.number,
	        scale: React.PropTypes.number,

	        // By default, this component attempts to be responsive whenever
	        // possible (specifically, when width and height are passed in).
	        // You can expliclty force unresponsive behavior by *either*
	        // not passing in width/height *or* setting this prop to false.
	        // The difference is that forcing via this prop will result in
	        // explicit width and height styles being set on the rendered
	        // component.
	        responsive: React.PropTypes.bool,

	        extraGraphie: React.PropTypes.shape({
	            box: React.PropTypes.array.isRequired,
	            range: React.PropTypes.array.isRequired,
	            labels: React.PropTypes.array.isRequired,
	        }),
	    },

	    getDefaultProps: function() {
	        return {
	            src: "",
	            scale: 1,
	            responsive: true,
	        };
	    },

	    getInitialState: function() {
	        return {
	            imageLoaded: false,
	            imageDimensions: null,
	            dataLoaded: false,
	            labels: [],
	            range: [[0, 0], [0, 0]],
	        };
	    },

	    // Check if all of the resources are loaded in a given state
	    isLoadedInState: function(state) {
	        return state.imageLoaded && state.dataLoaded;
	    },

	    shouldComponentUpdate: function(nextProps, nextState) {
	        // If the props changed, we definitely need to update
	        if (!_.isEqual(this.props, nextProps)) {
	            return true;
	        }

	        // If something changed but 
	        if (!isLabeledSVG(nextProps.src)) {
	            return false;
	        }

	        var wasLoaded = this.isLoadedInState(this.state);
	        var nextLoaded = this.isLoadedInState(nextState);

	        return wasLoaded !== nextLoaded;
	    },

	    render: function() {
	        // Props to send to all images
	        var imageProps = {
	            alt: this.props.alt,
	            title: this.props.title
	        };

	        var width = this.props.width && this.props.width * this.props.scale;
	        var height = this.props.height && this.props.height * this.props.scale;
	        var dimensions = {
	            width: width,
	            height: height,
	        };

	        // To make an image responsive, we need to know what its width and
	        // height are in advance (before inserting it into the DOM) so that we
	        // can ensure it doesn't grow past those limits. We don't always have
	        // this information, especially in places where <Renderer /> is used
	        // to render inline Markdown images within a widget. See Radio, Sorter,
	        // Matcher, etc.
	        // TODO(alex): Make all of those image rendering locations aware of
	        // width+height so that they too can render responsively.
	        var responsive = this.props.responsive && !!(width && height);

	        // An additional <Graphie /> may be inserted after the image/graphie
	        // pair. Only used by the image widget, for its legacy labels support.
	        // Note that since the image widget always provides width and height
	        // data, extraGraphie can be ignored for unresponsive images.
	        // TODO(alex): Convert all existing uses of that to web+graphie. This
	        // is tricky because web+graphie doesn't support labels on non-graphie
	        // images.
	        var extraGraphie;
	        if (this.props.extraGraphie && this.props.extraGraphie.labels.length) {
	            extraGraphie = React.createElement(Graphie, {
	                box: this.props.extraGraphie.box, 
	                range: this.props.extraGraphie.range, 
	                options: {labels: this.props.extraGraphie.labels}, 
	                responsive: true, 
	                setup: this.setupGraphie});
	        }

	        // Just use a normal image if a normal image is provided
	        if (!isLabeledSVG(this.props.src)) {
	            if (responsive) {
	                return React.createElement(FixedToResponsive, {
	                            className: "svg-image", 
	                            width: width, 
	                            height: height}, 
	                    React.createElement("img", React.__spread({src: this.props.src},  imageProps)), 
	                    extraGraphie
	                );
	            } else {
	                return React.createElement("img", React.__spread({src: this.props.src, 
	                            style: dimensions}, 
	                            imageProps));
	            }
	            
	        }

	        var imageUrl = getSvgUrl(this.props.src);

	        var graphie;
	        // Since we only want to do the graphie setup once, we only render the
	        // graphie once everything is loaded
	        if (this.isLoadedInState(this.state)) {
	            // Use the provided width and height to size the graphie if
	            // possible, otherwise use our own calculated size
	            var box;
	            if (this.sizeProvided()) {
	                box = [width, height];
	            } else {
	                box = [this.state.imageDimensions[0] * this.props.scale,
	                       this.state.imageDimensions[1] * this.props.scale];
	            }

	            var scale = [40 * this.props.scale, 40 * this.props.scale];

	            graphie = React.createElement(Graphie, {
	                ref: "graphie", 
	                box: box, 
	                scale: scale, 
	                range: this.state.range, 
	                options: _.pick(this.state, "labels"), 
	                responsive: responsive, 
	                setup: this.setupGraphie});
	        }

	        if (responsive) {
	            return React.createElement(FixedToResponsive, {
	                        className: "svg-image", 
	                        width: width, 
	                        height: height}, 
	                React.createElement("img", React.__spread({
	                    src: imageUrl, 
	                    onLoad: this.onImageLoad}, 
	                    imageProps)), 
	                graphie, 
	                extraGraphie
	            );
	        } else {
	            return React.createElement("div", {
	                        className: "unresponsive-svg-image", 
	                        style: dimensions}, 
	                React.createElement("img", React.__spread({
	                    src: imageUrl, 
	                    onLoad: this.onImageLoad, 
	                    style: dimensions}, 
	                    imageProps)), 
	                graphie
	            );
	        }
	    },

	    componentWillReceiveProps: function(nextProps) {
	        if (this.props.src !== nextProps.src) {
	            this.setState({
	                imageLoaded: false,
	                dataLoaded: false,
	            });
	        }
	    },

	    componentDidMount: function() {
	        if (isLabeledSVG(this.props.src)) {
	            this.loadResources();
	        }
	    },

	    componentDidUpdate: function() {
	        if (isLabeledSVG(this.props.src) &&
	            !this.isLoadedInState(this.state)) {
	            this.loadResources();
	        }
	    },

	    loadResources: function() {
	        var hash = getUrlHash(this.props.src);

	        // We can't make multiple jsonp calls to the same file because their
	        // callbacks will collide with each other. Instead, we cache the data
	        // and only make the jsonp calls once.
	        if (labelDataCache[hash]) {
	            if (labelDataCache[hash].loaded) {
	                this.onDataLoaded(labelDataCache[hash].data);
	            } else {
	                labelDataCache[hash].dataCallbacks.push(this.onDataLoaded);
	            }
	        } else {
	            var cacheData = {
	                loaded: false,
	                dataCallbacks: [this.onDataLoaded],
	                data: null,
	            };

	            labelDataCache[hash] = cacheData;

	            var retrieveData = function(url, errorCallback)  {
	                doJSONP(url, {
	                    callbackName: "svgData" + hash,
	                    success: function(data)  {
	                        cacheData.data = data;
	                        cacheData.loaded = true;

	                        _.each(cacheData.dataCallbacks, function(callback)  {
	                            callback(cacheData.data);
	                        });
	                    },
	                    error: errorCallback
	                });
	            };

	            if (shouldUseLocalizedData()) {
	                retrieveData(
	                    getLocalizedDataUrl(this.props.src),
	                    function(x, status, error)  {
	                        // If there is isn't any localized data, fall back to
	                        // the original, unlocalized data
	                        retrieveData(
	                            getDataUrl(this.props.src),
	                            function(x, status, error)  {
	                                console.error(
	                                    "Data load failed:",
	                                    getDataUrl(this.props.src), error
	                                );
	                            }.bind(this)
	                        );
	                    }.bind(this)
	                );
	            } else {
	                retrieveData(
	                    getDataUrl(this.props.src),
	                    function(x, status, error)  {
	                        console.error(
	                            "Data load failed:",
	                            getDataUrl(this.props.src), error
	                        );
	                    }.bind(this)
	                );
	            }
	        }
	    },

	    onDataLoaded: function(data) {
	        if (this.isMounted()) {
	            this.setState({
	                dataLoaded: true,
	                labels: data.labels,
	                range: data.range
	            });
	        }
	    },

	    sizeProvided: function() {
	        return this.props.width != null && this.props.height != null;
	    },

	    onImageLoad: function() {
	        // Only need to do this if rendering a Graphie
	        if (this.sizeProvided()) {
	            // If width and height are provided, we don't need to calculate the
	            // size ourselves
	            this.setState({
	                imageLoaded: true
	            });
	        } else {
	            Util.getImageSize(this.props.src, function(width, height)  {
	                this.setState({
	                    imageLoaded: true,
	                    imageDimensions: [width, height],
	                });
	            }.bind(this));
	        }
	    },

	    setupGraphie: function(graphie, options) {
	        _.map(options.labels, function(labelData)  {
	            // Create labels from the data
	            var label = graphie.label(
	                labelData.coordinates,
	                labelData.content,
	                labelData.alignment,
	                labelData.typesetAsMath,
	                {"font-size": (100 * this.props.scale) + "%"}
	            );

	            // Convert absolute positioning css from pixels to percentages
	            // TODO(alex): Dynamically resize font-size as well. This almost
	            // certainly means listening to throttled window.resize events.
	            var position = label.position();
	            var height = this.props.height * this.props.scale;
	            var width = this.props.width * this.props.scale;
	            label.css({
	                top: position.top / height * 100 + '%',
	                left: position.left / width * 100 + '%',
	            });

	            // Add back the styles to each of the labels
	            _.each(labelData.style, function(styleValue, styleName)  {
	                label.css(styleName, styleValue);
	            });
	        }.bind(this));
	    }
	});

	module.exports = SvgImage;


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	var React = __webpack_require__(68);
	var _ = __webpack_require__(67);

	/* A checkbox that syncs its value to props using the
	 * renderer's onChange method, and gets the prop name
	 * dynamically from its props list
	 */
	var PropCheckBox = React.createClass({displayName: 'PropCheckBox',
	    propTypes: {
	        labelAlignment: React.PropTypes.oneOf(["left", "right"])
	    },

	    DEFAULT_PROPS: {
	        label: null,
	        onChange: null,
	        labelAlignment: "left"
	    },

	    getDefaultProps: function() {
	        return this.DEFAULT_PROPS;
	    },

	    propName: function() {
	        var propName = _.find(_.keys(this.props), function(localPropName) {
	            return !_.has(this.DEFAULT_PROPS, localPropName);
	        }, this);

	        if (!propName) {
	            throw new Error("Attempted to create a PropCheck