#!/usr/bin/env python

shore=[(-94.300235999999998, 29.581315), (-94.370000000000005, 29.548333), (-94.423500000000004, 29.535625), (-94.518304000000001, 29.4985), (-94.611682000000002, 29.466702999999999), (-94.687252000000001, 29.427802), (-94.734654000000006, 29.381855000000002), (-94.746491000000006, 29.371255999999999), (-94.778333000000003, 29.363333000000001), (-94.780000000000001, 29.364999999999998), (-94.792413999999994, 29.373031999999998), (-94.787975000000003, 29.392453), (-94.716845000000006, 29.436624999999999), (-94.699089000000001, 29.464926999999999), (-94.672402000000005, 29.473749999999999), (-94.641276000000005, 29.480854999999998), (-94.576116999999996, 29.528578), (-94.513333333333335, 29.515000000000001), (-94.513333000000003, 29.518332999999998), (-94.482738999999995, 29.544447000000002), (-94.476821000000001, 29.563927), (-94.487230999999994, 29.560375000000001), (-94.510906000000006, 29.547999999999998), (-94.537593000000001, 29.555046000000001), (-94.567239000000001, 29.574525999999999), (-94.777617000000006, 29.526802), (-94.786666999999994, 29.535), (-94.807264000000004, 29.542670999999999), (-94.798333, 29.555046000000001), (-94.777617000000006, 29.547999999999998), (-94.767259999999993, 29.569196999999999), (-94.730215000000001, 29.618697000000001), (-94.721283999999997, 29.666421), (-94.689999999999998, 29.713333333333335), (-94.705008000000007, 29.715921000000002), (-94.706666999999996, 29.738333000000001), (-94.709446999999997, 29.756539), (-94.722763999999998, 29.765421), (-94.739092999999997, 29.761868), (-94.747971000000007, 29.786618000000001), (-94.836856999999995, 29.751269000000001), (-94.866667000000007, 29.68), (-94.930234999999996, 29.657598), (-94.937634000000003, 29.675242999999998), (-94.965800000000002, 29.701768999999999), (-95.025040000000004, 29.712368000000001), (-95.053207, 29.72119), (-95.063564999999997, 29.715921000000002), (-95.060604999999995, 29.701768999999999), (-95.035398000000001, 29.685842000000001), (-95.020600999999999, 29.685842000000001), (-94.981667000000002, 29.675000000000001), (-95.026520000000005, 29.643446999999998), (-94.986515999999995, 29.595723), (-95.023560000000003, 29.553328), (-95.019120999999998, 29.532071999999999), (-94.968760000000003, 29.509098000000002), (-94.925796000000005, 29.505604999999999), (-94.911666999999994, 29.498332999999999), (-94.925796000000005, 29.479078000000001), (-94.962840999999997, 29.464926999999999), (-94.949471000000003, 29.449000000000002), (-94.950951000000003, 29.417203000000001), (-94.924317000000002, 29.413651000000002), (-94.915385999999998, 29.426026), (-94.924317000000002, 29.434906999999999), (-94.912425999999996, 29.434906999999999), (-94.900588999999997, 29.429577999999999), (-94.891711000000001, 29.399559), (-94.827978999999999, 29.376525999999998), (-94.822059999999993, 29.369479999999999), (-94.829459, 29.365926999999999), (-94.881299999999996, 29.378302000000001), (-94.893191000000002, 29.371255999999999), (-94.905000000000001, 29.295000000000002), (-94.930234999999996, 29.304110999999999), (-94.949471000000003, 29.312933999999998), (-94.953909999999993, 29.300559), (-95.001365000000007, 29.275808999999999), (-94.996872999999994, 29.261657), (-95.025040000000004, 29.240459999999999), (-95.039837000000006, 29.213933999999998), (-95.128332999999998, 29.166667), (-95.118364999999997, 29.180361000000001), (-95.121378000000007, 29.201559), (-95.145052000000007, 29.196289), (-95.161382000000003, 29.206887999999999), (-95.167299999999997, 29.205110999999999), (-95.165820999999994, 29.198065), (-95.150970999999998, 29.175032000000002), (-95.161382000000003, 29.120263000000001), (-95.148011999999994, 29.079643999999998), (-95.155410000000003, 29.072538999999999), (-95.140613000000002, 29.060164), (-95.244349, 28.991243000000001), (-95.331755999999999, 28.915216999999998), (-95.200000000000003, 28.915216999999998), (-94.302008000000001, 29.5)]
isle=[(-94.729308000000003, 29.332367000000001), (-94.790000000000006, 29.286667000000001), (-94.802194999999998, 29.280390000000001), (-94.883334000000005, 29.233839), (-94.978398999999996, 29.177814999999999), (-95.051309000000003, 29.133275999999999), (-95.115944999999996, 29.088736999999998), (-95.120397999999994, 29.092784000000002), (-95.112779000000003, 29.092784000000002), (-95.105816000000004, 29.102913000000001), (-95.103916999999996, 29.112362999999998), (-95.093132999999995, 29.123825), (-95.081084000000004, 29.127872), (-95.071588000000006, 29.131240999999999), (-95.067790000000002, 29.139357), (-95.048755, 29.147451), (-95.030373999999995, 29.169042000000001), (-94.970803000000004, 29.213581000000001), (-94.948601999999994, 29.231804), (-94.937207999999998, 29.240576000000001), (-94.915030000000002, 29.258120000000002), (-94.883334000000005, 29.272296000000001), (-94.863032000000004, 29.294564999999999), (-94.819309000000004, 29.308062), (-94.793333333333337, 29.309999999999999), (-94.786666999999994, 29.313333), (-94.776829000000006, 29.318190999999999), (-94.773663999999997, 29.331688), (-94.770499000000001, 29.337769999999999), (-94.740701999999999, 29.333722999999999)]
isle_center=(-94.900000000000006, 29.25)
gauges = [ (-94.69, 29.7133), (-94.985, 29.681) ]

ns = len(shore)
ni = len(isle)

area = 0.1

shoresegs = [ (i, i+1) for i in range(ns-1)] + [ (ns-1,0) ]
islesegs  = [ (i, i+1) for i in range(ns, ns+ni-1)] + [ (ns+ni-1,ns) ]
segs = shoresegs + islesegs


import Triangulate
t = Triangulate.Triangulate()
t.set_points(shore + isle + gauges)

# w/out island
t.set_segments(shoresegs)

t.triangulate(area=area)
# refine
for i in range(20):
    t.refine(area_ratio=1.3)
grid = t.get_nodes()
grid.plot()

# with island
t = Triangulate.Triangulate()
t.set_points(shore + isle + gauges)
t.set_segments(shoresegs + islesegs)
t.set_holes([isle_center,])
t.triangulate(area=area)
# refine
for i in range(20):
    t.refine(area_ratio=1.3)
grid = t.get_nodes()
grid.plot()



##import Ireg2tri
##area = 0.01

##meshgen = Ireg2tri.Ireg2tri(0.1)
##ns = len(shore)
##ni = len(isle)
##pts = shore + isle
##shoresegs = [ (i, i+1) for i in range(ns-1)] + [ (ns-1,0) ]
##islesegs  = [ (i, i+1) for i in range(ns, ns+ni-1)] + [ (ns+ni-1,ns) ]
##segs = shoresegs + islesegs
### add island points
##pts = shore + isle
##holelist = [isle_center,]
##meshgen.setUpConvexHull(listofpoints=pts, seglist=segs, holelist=holelist)
##meshgen.triangulate()
##print '1'
##grid = meshgen.refine(10)
##grid.plot()
