#!/usr/bin/env python
#  -*- mode: python; indent-tabs-mode: nil; -*- coding: utf-8 -*-

unicode_to_iso_8859_1 = {
    u'Đ': u'D', # LATIN CAPITAL LETTER D WITH STROKE
    u'đ': u'd', # LATIN SMALL LETTER D WITH STROKE
    u'Ħ': u'H', # LATIN CAPITAL LETTER H WITH STROKE
    u'ħ': u'h', # LATIN SMALL LETTER H WITH STROKE
    u'Ŀ': u'L', # LATIN CAPITAL LETTER L WITH MIDDLE DOT
    u'ŀ': u'l', # LATIN SMALL LETTER L WITH MIDDLE DOT
    u'Ł': u'L', # LATIN CAPITAL LETTER L WITH STROKE
    u'ł': u'l', # LATIN SMALL LETTER L WITH STROKE
    u'ŉ': u'n', # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    u'Œ': u'OE', # LATIN CAPITAL LIGATURE OE
    u'œ': u'oe', # LATIN SMALL LIGATURE OE
    u'Ŧ': u'T', # LATIN CAPITAL LETTER T WITH STROKE
    u'ŧ': u't', # LATIN SMALL LETTER T WITH STROKE
    u'ƀ': u'b', # LATIN SMALL LETTER B WITH STROKE
    u'Ɓ': u'B', # LATIN CAPITAL LETTER B WITH HOOK
    u'Ƃ': u'B', # LATIN CAPITAL LETTER B WITH TOPBAR
    u'ƃ': u'b', # LATIN SMALL LETTER B WITH TOPBAR
    u'Ɔ': u'O', # LATIN CAPITAL LETTER OPEN O
    u'Ƈ': u'C', # LATIN CAPITAL LETTER C WITH HOOK
    u'ƈ': u'c', # LATIN SMALL LETTER C WITH HOOK
    u'Ɗ': u'D', # LATIN CAPITAL LETTER D WITH HOOK
    u'Ƌ': u'D', # LATIN CAPITAL LETTER D WITH TOPBAR
    u'ƌ': u'd', # LATIN SMALL LETTER D WITH TOPBAR
    u'Ƒ': u'F', # LATIN CAPITAL LETTER F WITH HOOK
    u'ƒ': u'f', # LATIN SMALL LETTER F WITH HOOK
    u'Ɠ': u'G', # LATIN CAPITAL LETTER G WITH HOOK
    u'Ɨ': u'I', # LATIN CAPITAL LETTER I WITH STROKE
    u'Ƙ': u'K', # LATIN CAPITAL LETTER K WITH HOOK
    u'ƙ': u'k', # LATIN SMALL LETTER K WITH HOOK
    u'ƚ': u'l', # LATIN SMALL LETTER L WITH BAR
    u'Ɲ': u'N', # LATIN CAPITAL LETTER N WITH LEFT HOOK
    u'ƞ': u'n', # LATIN SMALL LETTER N WITH LONG RIGHT LEG
    u'Ɵ': u'O', # LATIN CAPITAL LETTER O WITH MIDDLE TILDE
    u'Ƥ': u'P', # LATIN CAPITAL LETTER P WITH HOOK
    u'ƥ': u'p', # LATIN SMALL LETTER P WITH HOOK
    u'ƫ': u't', # LATIN SMALL LETTER T WITH PALATAL HOOK
    u'Ƭ': u'T', # LATIN CAPITAL LETTER T WITH HOOK
    u'ƭ': u't', # LATIN SMALL LETTER T WITH HOOK
    u'Ʈ': u'T', # LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
    u'Ʋ': u'V', # LATIN CAPITAL LETTER V WITH HOOK
    u'Ƴ': u'Y', # LATIN CAPITAL LETTER Y WITH HOOK
    u'ƴ': u'y', # LATIN SMALL LETTER Y WITH HOOK
    u'Ƶ': u'Z', # LATIN CAPITAL LETTER Z WITH STROKE
    u'ƶ': u'z', # LATIN SMALL LETTER Z WITH STROKE
    u'ǈ': u'L', # LATIN CAPITAL LETTER L WITH SMALL LETTER J
    u'ǋ': u'N', # LATIN CAPITAL LETTER N WITH SMALL LETTER J
    u'Ǣ': u'AE', # LATIN CAPITAL LETTER AE WITH MACRON
    u'ǣ': u'ae', # LATIN SMALL LETTER AE WITH MACRON
    u'Ǥ': u'G', # LATIN CAPITAL LETTER G WITH STROKE
    u'ǥ': u'g', # LATIN SMALL LETTER G WITH STROKE
    u'ǲ': u'D', # LATIN CAPITAL LETTER D WITH SMALL LETTER Z
    u'Ǽ': u'AE', # LATIN CAPITAL LETTER AE WITH ACUTE
    u'ǽ': u'ae', # LATIN SMALL LETTER AE WITH ACUTE
    u'Ǿ': u'O', # LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    u'ǿ': u'o', # LATIN SMALL LETTER O WITH STROKE AND ACUTE
    u'Ƞ': u'N', # LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
    u'ȡ': u'd', # LATIN SMALL LETTER D WITH CURL
    u'Ȥ': u'Z', # LATIN CAPITAL LETTER Z WITH HOOK
    u'ȥ': u'z', # LATIN SMALL LETTER Z WITH HOOK
    u'ȴ': u'l', # LATIN SMALL LETTER L WITH CURL
    u'ȵ': u'n', # LATIN SMALL LETTER N WITH CURL
    u'ȶ': u't', # LATIN SMALL LETTER T WITH CURL
    u'ɓ': u'b', # LATIN SMALL LETTER B WITH HOOK
    u'ɕ': u'c', # LATIN SMALL LETTER C WITH CURL
    u'ɖ': u'd', # LATIN SMALL LETTER D WITH TAIL
    u'ɗ': u'd', # LATIN SMALL LETTER D WITH HOOK
    u'ɠ': u'g', # LATIN SMALL LETTER G WITH HOOK
    u'ɦ': u'h', # LATIN SMALL LETTER H WITH HOOK
    u'ɨ': u'i', # LATIN SMALL LETTER I WITH STROKE
    u'ɫ': u'l', # LATIN SMALL LETTER L WITH MIDDLE TILDE
    u'ɬ': u'l', # LATIN SMALL LETTER L WITH BELT
    u'ɭ': u'l', # LATIN SMALL LETTER L WITH RETROFLEX HOOK
    u'ɱ': u'm', # LATIN SMALL LETTER M WITH HOOK
    u'ɲ': u'n', # LATIN SMALL LETTER N WITH LEFT HOOK
    u'ɳ': u'n', # LATIN SMALL LETTER N WITH RETROFLEX HOOK
    u'ɼ': u'r', # LATIN SMALL LETTER R WITH LONG LEG
    u'ɽ': u'r', # LATIN SMALL LETTER R WITH TAIL
    u'ɾ': u'r', # LATIN SMALL LETTER R WITH FISHHOOK
    u'ʂ': u's', # LATIN SMALL LETTER S WITH HOOK
    u'ʈ': u't', # LATIN SMALL LETTER T WITH RETROFLEX HOOK
    u'ʉ': u'u', # LATIN SMALL LETTER U BAR
    u'ʋ': u'v', # LATIN SMALL LETTER V WITH HOOK
    u'ʐ': u'z', # LATIN SMALL LETTER Z WITH RETROFLEX HOOK
    u'ʑ': u'z', # LATIN SMALL LETTER Z WITH CURL
    u'ʜ': u'H', # LATIN LETTER SMALL CAPITAL H
    u'ʝ': u'j', # LATIN SMALL LETTER J WITH CROSSED-TAIL
    u'ʠ': u'q', # LATIN SMALL LETTER Q WITH HOOK
    u'ʮ': u'h', # LATIN SMALL LETTER TURNED H WITH FISHHOOK
    u'ʯ': u'h', # LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
    u'Ѝ': u'I', # CYRILLIC CAPITAL LETTER I WITH GRAVE
    u'ѝ': u'i', # CYRILLIC SMALL LETTER I WITH GRAVE
    u'Ӑ': u'A', # CYRILLIC CAPITAL LETTER A WITH BREVE
    u'ӑ': u'a', # CYRILLIC SMALL LETTER A WITH BREVE
    u'Ӓ': u'A', # CYRILLIC CAPITAL LETTER A WITH DIAERESIS
    u'ӓ': u'a', # CYRILLIC SMALL LETTER A WITH DIAERESIS
    u'Ӣ': u'I', # CYRILLIC CAPITAL LETTER I WITH MACRON
    u'ӣ': u'i', # CYRILLIC SMALL LETTER I WITH MACRON
    u'Ӥ': u'I', # CYRILLIC CAPITAL LETTER I WITH DIAERESIS
    u'ӥ': u'i', # CYRILLIC SMALL LETTER I WITH DIAERESIS
    u'Ӧ': u'O', # CYRILLIC CAPITAL LETTER O WITH DIAERESIS
    u'ӧ': u'o', # CYRILLIC SMALL LETTER O WITH DIAERESIS
    u'Ӭ': u'E', # CYRILLIC CAPITAL LETTER E WITH DIAERESIS
    u'ӭ': u'e', # CYRILLIC SMALL LETTER E WITH DIAERESIS
    u'Ӯ': u'U', # CYRILLIC CAPITAL LETTER U WITH MACRON
    u'ӯ': u'u', # CYRILLIC SMALL LETTER U WITH MACRON
    u'Ӱ': u'U', # CYRILLIC CAPITAL LETTER U WITH DIAERESIS
    u'ӱ': u'u', # CYRILLIC SMALL LETTER U WITH DIAERESIS
    u'Ӳ': u'U', # CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
    u'ӳ': u'u', # CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
    u'ẚ': u'a', # LATIN SMALL LETTER A WITH RIGHT HALF RING
    u'‐': u'-', # HYPHEN
    u'–': u'-', # EN DASH
    u'—': u'--', # EM DASH
    u'‖': u'||', # DOUBLE VERTICAL LINE
    u'‗': u'_', # DOUBLE LOW LINE
    u'‘': u'\'', # LEFT SINGLE QUOTATION MARK
    u'’': u'\'', # RIGHT SINGLE QUOTATION MARK
    u'‚': u'\'', # SINGLE LOW-9 QUOTATION MARK
    u'‛': u'\'', # SINGLE HIGH-REVERSED-9 QUOTATION MARK
    u'“': u'"', # LEFT DOUBLE QUOTATION MARK
    u'”': u'"', # RIGHT DOUBLE QUOTATION MARK
    u'„': u'"', # DOUBLE LOW-9 QUOTATION MARK
    u'‟': u'"', # DOUBLE HIGH-REVERSED-9 QUOTATION MARK
    u'⁅': u'[', # LEFT SQUARE BRACKET WITH QUILL
    u'⁆': u']', # RIGHT SQUARE BRACKET WITH QUILL
}


iso_8859_1_to_ascii = {
    u'¡': u'i', # INVERTED EXCLAMATION MARK
    u'¢': u'c', # CENT SIGN
    u'£': u'L', # POUND SIGN
    u'¥': u'Y', # YEN SIGN
    u'¦': u'|', # BROKEN BAR
    u'§': u'Sec.', # SECTION SIGN
    u'¨': u'"', # DIAERESIS
    u'©': u'(C)', # COPYRIGHT SIGN
    u'«': u'"', # LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    u'­': u'-', # SOFT HYPHEN
    u'®': u'(R)', # REGISTERED SIGN
    u'¯': u'-', # MACRON
    u'°': u' deg.', # DEGREE SIGN
    u'±': u'+-', # PLUS-MINUS SIGN
    u'²': u' squared', # SUPERSCRIPT TWO
    u'³': u' cubed', # SUPERSCRIPT THREE
    u'´': u'\'', # ACUTE ACCENT
    u'µ': u' mu', # MICRO SIGN
    u'·': u'.', # MIDDLE DOT
    u'»': u'"', # RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    u'¼': u'1/4', # VULGAR FRACTION ONE QUARTER
    u'½': u'1/2', # VULGAR FRACTION ONE HALF
    u'¾': u'3/4', # VULGAR FRACTION THREE QUARTERS
    u'¿': u'?', # INVERTED QUESTION MARK
    u'Ä': u'Ae', # LATIN CAPITAL LETTER A WITH DIAERESIS
    u'Æ': u'AE', # LATIN CAPITAL LETTER AE
    u'Ð': u'Eth', # LATIN CAPITAL LETTER ETH
    u'Ö': u'Oe', # LATIN CAPITAL LETTER O WITH DIAERESIS
    u'×': u'x', # MULTIPLICATION SIGN
    u'Ø': u'O', # LATIN CAPITAL LETTER O WITH STROKE
    u'Ü': u'Ue', # LATIN CAPITAL LETTER U WITH DIAERESIS
    u'ß': u'ss', # LATIN SMALL LETTER SHARP S
    u'ä': u'ae', # LATIN SMALL LETTER A WITH DIAERESIS
    u'æ': u'ae', # LATIN SMALL LETTER AE
    u'ð': u'eth', # LATIN SMALL LETTER ETH
    u'ö': u'oe', # LATIN SMALL LETTER O WITH DIAERESIS
    u'÷': u'/', # DIVISION SIGN
    u'ø': u'o', # LATIN SMALL LETTER O WITH STROKE
    u'ü': u'ue', # LATIN SMALL LETTER U WITH DIAERESIS
}


