from __future__ import generators

import py
from py.__.rest.latex import process_configfile, process_rest_file
from py.__.rest.testing.setup import getdata

try:
    import docutils
except ImportError:
    py.test.skip("docutils not present")


def setup_module(mod):
    if not py.path.local.sysfind("gs") or \
           not py.path.local.sysfind("dot") or \
           not py.path.local.sysfind("latex"):
        py.test.skip("ghostscript, graphviz and latex needed")
    mod.datadir = getdata()

class TestRst2Pdf(object):
    def _process_rest_file(self):
        part2 = datadir.join("part1.txt")
        pdf = part2.new(ext="pdf")
        process_rest_file(part2)
        assert pdf.check()
        pdf.remove()

    def _process_configfile(self):
        config = datadir.join("example.rst2pdfconfig")
        pdf = config.new(ext="pdf")
        tex = datadir.join('example.tex')
        process_configfile(config, debug=True)
        assert pdf.check()
        assert tex.check()
        texcontent = tex.read()
        assert "Generated by" in texcontent
        assert "Docutils" in texcontent
        process_configfile(config, debug=False)
        assert pdf.check()
        assert not tex.check()
        pdf.remove()

    def _process_all(self):
        # fallback test: only checks that no exception is raised
        def rec(p):
            return p.check(dotfile=0)

        for x in datadir.visit("*.rst2pdfconfig", rec=rec):
            process_configfile(x)
        for x in datadir.visit("*.txt", rec=rec):
            process_rest_file(x)

    def test_rst2pdf(self):
        self._process_rest_file()
        self._process_configfile()
        self._process_all()
